/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.BinaryArithmetic;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Remainder$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.FractionalType;
import org.apache.spark.sql.types.IntegralType;
import org.apache.spark.sql.types.NumericType$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.math.Integral;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="expr1 _FUNC_ expr2 - Returns the remainder after `expr1`/`expr2`.", extended="\n    Examples:\n      > SELECT 2 _FUNC_ 1.8;\n       0.2\n  ")
@ScalaSignature(bytes="\u0006\u0001\u0005\rg\u0001B\u0001\u0003\u0001>\u0011\u0011BU3nC&tG-\u001a:\u000b\u0005\r!\u0011aC3yaJ,7o]5p]NT!!\u0002\u0004\u0002\u0011\r\fG/\u00197zgRT!a\u0002\u0005\u0002\u0007M\fHN\u0003\u0002\n\u0015\u0005)1\u000f]1sW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u0019B\u0001\u0001\t\u00155A\u0011\u0011CE\u0007\u0002\u0005%\u00111C\u0001\u0002\u0011\u0005&t\u0017M]=Be&$\b.\\3uS\u000e\u0004\"!\u0006\r\u000e\u0003YQ\u0011aF\u0001\u0006g\u000e\fG.Y\u0005\u00033Y\u0011q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002\u00167%\u0011AD\u0006\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\t=\u0001\u0011)\u001a!C\u0001?\u0005!A.\u001a4u+\u0005\u0001\u0003CA\t\"\u0013\t\u0011#A\u0001\u0006FqB\u0014Xm]:j_:D\u0001\u0002\n\u0001\u0003\u0012\u0003\u0006I\u0001I\u0001\u0006Y\u00164G\u000f\t\u0005\tM\u0001\u0011)\u001a!C\u0001?\u0005)!/[4ii\"A\u0001\u0006\u0001B\tB\u0003%\u0001%\u0001\u0004sS\u001eDG\u000f\t\u0005\u0006U\u0001!\taK\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00071jc\u0006\u0005\u0002\u0012\u0001!)a$\u000ba\u0001A!)a%\u000ba\u0001A!)\u0001\u0007\u0001C!c\u0005I\u0011N\u001c9viRK\b/Z\u000b\u0002eA\u00111GN\u0007\u0002i)\u0011QGB\u0001\u0006if\u0004Xm]\u0005\u0003oQ\u0012\u0001#\u00112tiJ\f7\r\u001e#bi\u0006$\u0016\u0010]3\t\u000be\u0002A\u0011\t\u001e\u0002\rMLXNY8m+\u0005Y\u0004C\u0001\u001f@\u001d\t)R(\u0003\u0002?-\u00051\u0001K]3eK\u001aL!\u0001Q!\u0003\rM#(/\u001b8h\u0015\tqd\u0003C\u0003D\u0001\u0011\u0005#(A\u0007eK\u000eLW.\u00197NKRDw\u000e\u001a\u0005\u0006\u000b\u0002!\tER\u0001\t]VdG.\u00192mKV\tq\t\u0005\u0002\u0016\u0011&\u0011\u0011J\u0006\u0002\b\u0005>|G.Z1o\u0011!Y\u0005\u0001#b\u0001\n\u0013a\u0015\u0001C5oi\u0016<'/\u00197\u0016\u00035\u00032A\u0014,Z\u001d\tyEK\u0004\u0002Q'6\t\u0011K\u0003\u0002S\u001d\u00051AH]8pizJ\u0011aF\u0005\u0003+Z\tq\u0001]1dW\u0006<W-\u0003\u0002X1\nA\u0011J\u001c;fOJ\fGN\u0003\u0002V-A\u0011QCW\u0005\u00037Z\u00111!\u00118z\u0011!i\u0006\u0001#A!B\u0013i\u0015!C5oi\u0016<'/\u00197!\u0011\u0015y\u0006\u0001\"\u0011a\u0003\u0011)g/\u00197\u0015\u0005e\u000b\u0007b\u00022_!\u0003\u0005\raY\u0001\u0006S:\u0004X\u000f\u001e\t\u0003I\u0016l\u0011\u0001B\u0005\u0003M\u0012\u00111\"\u00138uKJt\u0017\r\u001c*po\")\u0001\u000e\u0001C!S\u0006IAm\\$f]\u000e{G-\u001a\u000b\u0004UB,\bCA6o\u001b\u0005a'BA7\u0003\u0003\u001d\u0019w\u000eZ3hK:L!a\u001c7\u0003\u0011\u0015C\bO]\"pI\u0016DQ!]4A\u0002I\f1a\u0019;y!\tY7/\u0003\u0002uY\nq1i\u001c3fO\u0016t7i\u001c8uKb$\b\"\u0002<h\u0001\u0004Q\u0017AA3w\u0011\u001dA\b!!A\u0005\u0002e\fAaY8qsR\u0019AF_>\t\u000fy9\b\u0013!a\u0001A!9ae\u001eI\u0001\u0002\u0004\u0001\u0003bB?\u0001#\u0003%\tA`\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\u0005y(f\u0001\u0011\u0002\u0002-\u0012\u00111\u0001\t\u0005\u0003\u000b\ty!\u0004\u0002\u0002\b)!\u0011\u0011BA\u0006\u0003%)hn\u00195fG.,GMC\u0002\u0002\u000eY\t!\"\u00198o_R\fG/[8o\u0013\u0011\t\t\"a\u0002\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r\u0003\u0005\u0002\u0016\u0001\t\n\u0011\"\u0001\u007f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIIB\u0011\"!\u0007\u0001\u0003\u0003%\t%a\u0007\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\ti\u0002\u0005\u0003\u0002 \u0005%RBAA\u0011\u0015\u0011\t\u0019#!\n\u0002\t1\fgn\u001a\u0006\u0003\u0003O\tAA[1wC&\u0019\u0001)!\t\t\u0013\u00055\u0002!!A\u0005\u0002\u0005=\u0012\u0001\u00049s_\u0012,8\r^!sSRLXCAA\u0019!\r)\u00121G\u0005\u0004\u0003k1\"aA%oi\"I\u0011\u0011\b\u0001\u0002\u0002\u0013\u0005\u00111H\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\rI\u0016Q\b\u0005\u000b\u0003\u007f\t9$!AA\u0002\u0005E\u0012a\u0001=%c!I\u00111\t\u0001\u0002\u0002\u0013\u0005\u0013QI\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011q\t\t\u0006\u0003\u0013\ny%W\u0007\u0003\u0003\u0017R1!!\u0014\u0017\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003#\nYE\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0011%\t)\u0006AA\u0001\n\u0003\t9&\u0001\u0005dC:,\u0015/^1m)\r9\u0015\u0011\f\u0005\n\u0003\u007f\t\u0019&!AA\u0002eC\u0011\"!\u0018\u0001\u0003\u0003%\t%a\u0018\u0002\r\u0015\fX/\u00197t)\r9\u0015\u0011\r\u0005\n\u0003\u007f\tY&!AA\u0002eC3\u0002AA3\u0003W\ni'!\u001d\u0002tA\u0019\u0011#a\u001a\n\u0007\u0005%$AA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\u0005=\u0014!Q3yaJ\f\u0004e\u0018$V\u001d\u000e{\u0006%\u001a=qeJ\u0002S\u0006\t*fiV\u0014hn\u001d\u0011uQ\u0016\u0004#/Z7bS:$WM\u001d\u0011bMR,'\u000f\t1fqB\u0014\u0018\u0007Y\u0018aKb\u0004(O\r1/\u0003!)\u0007\u0010^3oI\u0016$\u0017EAA;\u0003eR\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006E\r\u0011`\rVs5i\u0018\u00112]aZ$\u0002\t\u0011!A\u0001\u0002\u0003\u0005\r\u00183\u0015\u0001\u0002s!CA=\u0005\u0005\u0005\t\u0012AA>\u0003%\u0011V-\\1j]\u0012,'\u000fE\u0002\u0012\u0003{2\u0001\"\u0001\u0002\u0002\u0002#\u0005\u0011qP\n\u0006\u0003{\n\tI\u0007\t\b\u0003\u0007\u000bI\t\t\u0011-\u001b\t\t)IC\u0002\u0002\bZ\tqA];oi&lW-\u0003\u0003\u0002\f\u0006\u0015%!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oe!9!&! \u0005\u0002\u0005=ECAA>\u0011)\t\u0019*! \u0002\u0002\u0013\u0015\u0013QS\u0001\ti>\u001cFO]5oOR\u0011\u0011Q\u0004\u0005\u000b\u00033\u000bi(!A\u0005\u0002\u0006m\u0015!B1qa2LH#\u0002\u0017\u0002\u001e\u0006}\u0005B\u0002\u0010\u0002\u0018\u0002\u0007\u0001\u0005\u0003\u0004'\u0003/\u0003\r\u0001\t\u0005\u000b\u0003G\u000bi(!A\u0005\u0002\u0006\u0015\u0016aB;oCB\u0004H.\u001f\u000b\u0005\u0003O\u000b\u0019\fE\u0003\u0016\u0003S\u000bi+C\u0002\u0002,Z\u0011aa\u00149uS>t\u0007#B\u000b\u00020\u0002\u0002\u0013bAAY-\t1A+\u001e9mKJB\u0011\"!.\u0002\"\u0006\u0005\t\u0019\u0001\u0017\u0002\u0007a$\u0003\u0007\u0003\u0006\u0002:\u0006u\u0014\u0011!C\u0005\u0003w\u000b1B]3bIJ+7o\u001c7wKR\u0011\u0011Q\u0018\t\u0005\u0003?\ty,\u0003\u0003\u0002B\u0006\u0005\"AB(cU\u0016\u001cG\u000f")
public class Remainder
extends BinaryArithmetic
implements Serializable {
    private final Expression left;
    private final Expression right;
    private Integral<Object> integral;
    private volatile boolean bitmap$0;

    public static Function1<Tuple2<Expression, Expression>, Remainder> tupled() {
        return Remainder$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Remainder>> curried() {
        return Remainder$.MODULE$.curried();
    }

    private Integral integral$lzycompute() {
        Remainder remainder = this;
        synchronized (remainder) {
            DataType dataType2;
            block7: {
                if (!this.bitmap$0) {
                    Integral<Object> integral;
                    dataType2 = this.dataType();
                    if (dataType2 instanceof IntegralType) {
                        IntegralType integralType = (IntegralType)dataType2;
                        integral = integralType.integral();
                    } else {
                        if (!(dataType2 instanceof FractionalType)) break block7;
                        FractionalType fractionalType = (FractionalType)dataType2;
                        integral = fractionalType.asIntegral();
                    }
                    this.integral = integral;
                    this.bitmap$0 = true;
                }
                return this.integral;
            }
            throw new MatchError((Object)dataType2);
        }
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public AbstractDataType inputType() {
        return NumericType$.MODULE$;
    }

    @Override
    public String symbol() {
        return "%";
    }

    @Override
    public String decimalMethod() {
        return "remainder";
    }

    @Override
    public boolean nullable() {
        return true;
    }

    private Integral<Object> integral() {
        return this.bitmap$0 ? this.integral : this.integral$lzycompute();
    }

    @Override
    public Object eval(InternalRow input) {
        Object object;
        Object input2 = this.right().eval(input);
        if (input2 == null || BoxesRunTime.equals((Object)input2, (Object)BoxesRunTime.boxToInteger((int)0))) {
            object = null;
        } else {
            Object input1 = this.left().eval(input);
            if (input1 == null) {
                object = null;
            } else {
                Object object2;
                Object object3 = input1;
                if (object3 instanceof Double) {
                    double d = BoxesRunTime.unboxToDouble((Object)object3);
                    object2 = BoxesRunTime.boxToDouble((double)(d % Predef$.MODULE$.Double2double((Double)input2)));
                } else if (object3 instanceof Float) {
                    float f = BoxesRunTime.unboxToFloat((Object)object3);
                    object2 = BoxesRunTime.boxToFloat((float)(f % Predef$.MODULE$.Float2float((Float)input2)));
                } else {
                    object2 = this.integral().rem(input1, input2);
                }
                object = object2;
            }
        }
        return object;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode eval1 = this.left().genCode(ctx);
        ExprCode eval2 = this.right().genCode(ctx);
        String isZero = this.dataType() instanceof DecimalType ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".isZero()"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{eval2.value()})) : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " == 0"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{eval2.value()}));
        String javaType = ctx.javaType(this.dataType());
        String remainder = this.dataType() instanceof DecimalType ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", "(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{eval1.value(), this.decimalMethod(), eval2.value()})) : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", ")(", " ", " ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{javaType, eval1.value(), this.symbol(), eval2.value()}));
        return this.left().nullable() || this.right().nullable() ? ev.copy(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        ", "\n        boolean ", " = false;\n        ", " ", " = ", ";\n        if (", " || ", ") {\n          ", " = true;\n        } else {\n          ", "\n          if (", ") {\n            ", " = true;\n          } else {\n            ", " = ", ";\n          }\n        }"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{eval2.code(), ev.isNull(), javaType, ev.value(), ctx.defaultValue(javaType), eval2.isNull(), isZero, ev.isNull(), eval1.code(), eval1.isNull(), ev.isNull(), ev.value(), remainder})), ev.copy$default$2(), ev.copy$default$3()) : ev.copy(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        ", "\n        boolean ", " = false;\n        ", " ", " = ", ";\n        if (", ") {\n          ", " = true;\n        } else {\n          ", "\n          ", " = ", ";\n        }"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{eval2.code(), ev.isNull(), javaType, ev.value(), ctx.defaultValue(javaType), isZero, ev.isNull(), eval1.code(), ev.value(), remainder})), ev.copy$default$2(), ev.copy$default$3());
    }

    public Remainder copy(Expression left, Expression right) {
        return new Remainder(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "Remainder";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 1: {
                expression = this.right();
                break;
            }
            case 0: {
                expression = this.left();
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Remainder;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Remainder)) return false;
        boolean bl = true;
        if (!bl) return false;
        Remainder remainder = (Remainder)x$1;
        Expression expression = this.left();
        Expression expression2 = remainder.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = remainder.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!remainder.canEqual(this)) return false;
        return true;
    }

    public Remainder(Expression left, Expression right) {
        this.left = left;
        this.right = right;
    }
}

