/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.BinaryComparison;
import org.apache.spark.sql.catalyst.expressions.EqualNullSafe$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AnyDataType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import scala.Function1;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    expr1 _FUNC_ expr2 - Returns same result as the EQUAL(=) operator for non-null operands,\n      but returns true if both are null, false if one of the them is null.\n  ")
@ScalaSignature(bytes="\u0006\u0001\u0005%f\u0001B\u0001\u0003\u0001>\u0011Q\"R9vC2tU\u000f\u001c7TC\u001a,'BA\u0002\u0005\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005\u00151\u0011\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005\u001dA\u0011aA:rY*\u0011\u0011BC\u0001\u0006gB\f'o\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001\u0001BC\u0007\t\u0003#Ii\u0011AA\u0005\u0003'\t\u0011\u0001CQ5oCJL8i\\7qCJL7o\u001c8\u0011\u0005UAR\"\u0001\f\u000b\u0003]\tQa]2bY\u0006L!!\u0007\f\u0003\u000fA\u0013x\u000eZ;diB\u0011QcG\u0005\u00039Y\u0011AbU3sS\u0006d\u0017N_1cY\u0016D\u0001B\b\u0001\u0003\u0016\u0004%\taH\u0001\u0005Y\u00164G/F\u0001!!\t\t\u0012%\u0003\u0002#\u0005\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\t\u0011\u0011\u0002!\u0011#Q\u0001\n\u0001\nQ\u0001\\3gi\u0002B\u0001B\n\u0001\u0003\u0016\u0004%\taH\u0001\u0006e&<\u0007\u000e\u001e\u0005\tQ\u0001\u0011\t\u0012)A\u0005A\u00051!/[4ii\u0002BQA\u000b\u0001\u0005\u0002-\na\u0001P5oSRtDc\u0001\u0017.]A\u0011\u0011\u0003\u0001\u0005\u0006=%\u0002\r\u0001\t\u0005\u0006M%\u0002\r\u0001\t\u0005\u0006a\u0001!\t%M\u0001\nS:\u0004X\u000f\u001e+za\u0016,\u0012A\r\t\u0003gYj\u0011\u0001\u000e\u0006\u0003k\u0019\tQ\u0001^=qKNL!a\u000e\u001b\u0003!\u0005\u00137\u000f\u001e:bGR$\u0015\r^1UsB,\u0007\"B\u001d\u0001\t\u0003R\u0014aE2iK\u000e\\\u0017J\u001c9vi\u0012\u000bG/\u0019+za\u0016\u001cH#A\u001e\u0011\u0005qzT\"A\u001f\u000b\u0005y\"\u0011\u0001C1oC2L8/[:\n\u0005\u0001k$a\u0004+za\u0016\u001c\u0005.Z2l%\u0016\u001cX\u000f\u001c;\t\u000b\t\u0003A\u0011I\"\u0002\rMLXNY8m+\u0005!\u0005CA#I\u001d\t)b)\u0003\u0002H-\u00051\u0001K]3eK\u001aL!!\u0013&\u0003\rM#(/\u001b8h\u0015\t9e\u0003C\u0003M\u0001\u0011\u0005S*\u0001\u0005ok2d\u0017M\u00197f+\u0005q\u0005CA\u000bP\u0013\t\u0001fCA\u0004C_>dW-\u00198\t\u000bI\u0003A\u0011I*\u0002\t\u00154\u0018\r\u001c\u000b\u0003)^\u0003\"!F+\n\u0005Y3\"aA!os\"9\u0001,\u0015I\u0001\u0002\u0004I\u0016!B5oaV$\bC\u0001.\\\u001b\u0005!\u0011B\u0001/\u0005\u0005-Ie\u000e^3s]\u0006d'k\\<\t\u000by\u0003A\u0011I0\u0002\u0013\u0011|w)\u001a8D_\u0012,Gc\u00011gWB\u0011\u0011\rZ\u0007\u0002E*\u00111MA\u0001\bG>$WmZ3o\u0013\t)'M\u0001\u0005FqB\u00148i\u001c3f\u0011\u00159W\f1\u0001i\u0003\r\u0019G\u000f\u001f\t\u0003C&L!A\u001b2\u0003\u001d\r{G-Z4f]\u000e{g\u000e^3yi\")A.\u0018a\u0001A\u0006\u0011QM\u001e\u0005\b]\u0002\t\t\u0011\"\u0001p\u0003\u0011\u0019w\u000e]=\u0015\u00071\u0002\u0018\u000fC\u0004\u001f[B\u0005\t\u0019\u0001\u0011\t\u000f\u0019j\u0007\u0013!a\u0001A!91\u000fAI\u0001\n\u0003!\u0018AD2paf$C-\u001a4bk2$H%M\u000b\u0002k*\u0012\u0001E^\u0016\u0002oB\u0011\u00010`\u0007\u0002s*\u0011!p_\u0001\nk:\u001c\u0007.Z2lK\u0012T!\u0001 \f\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002\u007fs\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0011\u0005\u0005\u0001!%A\u0005\u0002Q\fabY8qs\u0012\"WMZ1vYR$#\u0007C\u0005\u0002\u0006\u0001\t\t\u0011\"\u0011\u0002\b\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!!\u0003\u0011\t\u0005-\u0011QC\u0007\u0003\u0003\u001bQA!a\u0004\u0002\u0012\u0005!A.\u00198h\u0015\t\t\u0019\"\u0001\u0003kCZ\f\u0017bA%\u0002\u000e!I\u0011\u0011\u0004\u0001\u0002\u0002\u0013\u0005\u00111D\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003;\u00012!FA\u0010\u0013\r\t\tC\u0006\u0002\u0004\u0013:$\b\"CA\u0013\u0001\u0005\u0005I\u0011AA\u0014\u00039\u0001(o\u001c3vGR,E.Z7f]R$2\u0001VA\u0015\u0011)\tY#a\t\u0002\u0002\u0003\u0007\u0011QD\u0001\u0004q\u0012\n\u0004\"CA\u0018\u0001\u0005\u0005I\u0011IA\u0019\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA\u001a!\u0015\t)$a\u000fU\u001b\t\t9DC\u0002\u0002:Y\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\ti$a\u000e\u0003\u0011%#XM]1u_JD\u0011\"!\u0011\u0001\u0003\u0003%\t!a\u0011\u0002\u0011\r\fg.R9vC2$2ATA#\u0011%\tY#a\u0010\u0002\u0002\u0003\u0007A\u000bC\u0005\u0002J\u0001\t\t\u0011\"\u0011\u0002L\u00051Q-];bYN$2ATA'\u0011%\tY#a\u0012\u0002\u0002\u0003\u0007A\u000bK\u0004\u0001\u0003#\n9&!\u0017\u0011\u0007E\t\u0019&C\u0002\u0002V\t\u0011Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002\\\u0005\t9F\u0003\u0011!A\u0001*\u0007\u0010\u001d:2A}3UKT\"`A\u0015D\bO\u001d\u001a![\u0001\u0012V\r^;s]N\u00043/Y7fAI,7/\u001e7uA\u0005\u001c\b\u0005\u001e5fA\u0015\u000bV+\u0011'){%\u0002s\u000e]3sCR|'\u000f\t4pe\u0002rwN\\\u0017ok2d\u0007e\u001c9fe\u0006tGm\u001d\u0017\u000bA\u0001\u0002\u0003\u0005\t\u0011ckR\u0004#/\u001a;ve:\u001c\b\u0005\u001e:vK\u0002Jg\r\t2pi\"\u0004\u0013M]3!]VdG\u000e\f\u0011gC2\u001cX\rI5gA=tW\rI8gAQDW\r\t;iK6\u0004\u0013n\u001d\u0011ok2dgF\u0003\u0011!\u000f%\tyFAA\u0001\u0012\u0003\t\t'A\u0007FcV\fGNT;mYN\u000bg-\u001a\t\u0004#\u0005\rd\u0001C\u0001\u0003\u0003\u0003E\t!!\u001a\u0014\u000b\u0005\r\u0014q\r\u000e\u0011\u000f\u0005%\u0014q\u000e\u0011!Y5\u0011\u00111\u000e\u0006\u0004\u0003[2\u0012a\u0002:v]RLW.Z\u0005\u0005\u0003c\nYGA\tBEN$(/Y2u\rVt7\r^5p]JBqAKA2\t\u0003\t)\b\u0006\u0002\u0002b!Q\u0011\u0011PA2\u0003\u0003%)%a\u001f\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!\u0003\t\u0015\u0005}\u00141MA\u0001\n\u0003\u000b\t)A\u0003baBd\u0017\u0010F\u0003-\u0003\u0007\u000b)\t\u0003\u0004\u001f\u0003{\u0002\r\u0001\t\u0005\u0007M\u0005u\u0004\u0019\u0001\u0011\t\u0015\u0005%\u00151MA\u0001\n\u0003\u000bY)A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u00055\u0015\u0011\u0014\t\u0006+\u0005=\u00151S\u0005\u0004\u0003#3\"AB(qi&|g\u000eE\u0003\u0016\u0003+\u0003\u0003%C\u0002\u0002\u0018Z\u0011a\u0001V;qY\u0016\u0014\u0004\"CAN\u0003\u000f\u000b\t\u00111\u0001-\u0003\rAH\u0005\r\u0005\u000b\u0003?\u000b\u0019'!A\u0005\n\u0005\u0005\u0016a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!a)\u0011\t\u0005-\u0011QU\u0005\u0005\u0003O\u000biA\u0001\u0004PE*,7\r\u001e")
public class EqualNullSafe
extends BinaryComparison
implements Serializable {
    private final Expression left;
    private final Expression right;

    public static Function1<Tuple2<Expression, Expression>, EqualNullSafe> tupled() {
        return EqualNullSafe$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, EqualNullSafe>> curried() {
        return EqualNullSafe$.MODULE$.curried();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public AbstractDataType inputType() {
        return AnyDataType$.MODULE$;
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        TypeCheckResult typeCheckResult = super.checkInputDataTypes();
        TypeCheckResult$TypeCheckSuccess$ typeCheckResult$TypeCheckSuccess$ = TypeCheckResult$TypeCheckSuccess$.MODULE$;
        TypeCheckResult typeCheckResult2 = typeCheckResult;
        TypeCheckResult typeCheckResult3 = !(typeCheckResult$TypeCheckSuccess$ != null ? !typeCheckResult$TypeCheckSuccess$.equals(typeCheckResult2) : typeCheckResult2 != null) ? (this.left().dataType().existsRecursively((Function1<DataType, Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(DataType x$19) {
                return x$19 instanceof MapType;
            }
        }) ? new TypeCheckResult.TypeCheckFailure(new StringBuilder().append((Object)"Cannot use map type in EqualNullSafe, but the actual ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"input type is ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.left().dataType().catalogString()}))).toString()) : TypeCheckResult$TypeCheckSuccess$.MODULE$) : typeCheckResult;
        return typeCheckResult3;
    }

    @Override
    public String symbol() {
        return "<=>";
    }

    @Override
    public boolean nullable() {
        return false;
    }

    @Override
    public Object eval(InternalRow input) {
        Object input1 = this.left().eval(input);
        Object input2 = this.right().eval(input);
        return input1 == null && input2 == null ? BoxesRunTime.boxToBoolean((boolean)true) : (input1 == null || input2 == null ? BoxesRunTime.boxToBoolean((boolean)false) : BoxesRunTime.boxToBoolean((boolean)this.ordering().equiv(input1, input2)));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode eval1 = this.left().genCode(ctx);
        ExprCode eval2 = this.right().genCode(ctx);
        String equalCode = ctx.genEqual(this.left().dataType(), eval1.value(), eval2.value());
        return ev.copy(new StringBuilder().append((Object)eval1.code()).append((Object)eval2.code()).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        boolean ", " = (", " && ", ") ||\n           (!", " && !", " && ", ");"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.value(), eval1.isNull(), eval2.isNull(), eval1.isNull(), eval2.isNull(), equalCode}))).toString(), "false", ev.copy$default$3());
    }

    public EqualNullSafe copy(Expression left, Expression right) {
        return new EqualNullSafe(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "EqualNullSafe";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 1: {
                expression = this.right();
                break;
            }
            case 0: {
                expression = this.left();
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof EqualNullSafe;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof EqualNullSafe)) return false;
        boolean bl = true;
        if (!bl) return false;
        EqualNullSafe equalNullSafe = (EqualNullSafe)x$1;
        Expression expression = this.left();
        Expression expression2 = equalNullSafe.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = equalNullSafe.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!equalNullSafe.canEqual(this)) return false;
        return true;
    }

    public EqualNullSafe(Expression left, Expression right) {
        this.left = left;
        this.right = right;
    }
}

