/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.spark.sql.catalyst.expressions.MutableRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeReaders;
import org.apache.spark.sql.types.ArrayData;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType;
import org.apache.spark.sql.types.BooleanType;
import org.apache.spark.sql.types.ByteType;
import org.apache.spark.sql.types.CalendarIntervalType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.DateType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType;
import org.apache.spark.sql.types.FloatType;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.LongType;
import org.apache.spark.sql.types.MapData;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.NullType;
import org.apache.spark.sql.types.ShortType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType;
import org.apache.spark.unsafe.Platform;
import org.apache.spark.unsafe.array.ByteArrayMethods;
import org.apache.spark.unsafe.bitset.BitSetMethods;
import org.apache.spark.unsafe.hash.Murmur3_x86_32;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.apache.spark.unsafe.types.UTF8String;

public final class UnsafeRow
extends MutableRow {
    public static final Set<DataType> mutableFieldTypes = Collections.unmodifiableSet(new HashSet<DataType>(Arrays.asList(DataTypes.NullType, DataTypes.BooleanType, DataTypes.ByteType, DataTypes.ShortType, DataTypes.IntegerType, DataTypes.LongType, DataTypes.FloatType, DataTypes.DoubleType, DataTypes.DateType, DataTypes.TimestampType)));
    private Object baseObject;
    private long baseOffset;
    private int numFields;
    private int sizeInBytes;
    private int bitSetWidthInBytes;

    public static int calculateBitSetWidthInBytes(int numFields) {
        return (numFields + 63) / 64 * 8;
    }

    public static boolean isFixedLength(DataType dt) {
        if (dt instanceof DecimalType) {
            return ((DecimalType)dt).precision() <= Decimal.MAX_LONG_DIGITS();
        }
        return mutableFieldTypes.contains(dt);
    }

    public static boolean isMutable(DataType dt) {
        return mutableFieldTypes.contains(dt) || dt instanceof DecimalType;
    }

    private void setNotNullAt(int i) {
        this.assertIndexIsValid(i);
        BitSetMethods.unset((Object)this.baseObject, (long)this.baseOffset, (int)i);
    }

    private long getFieldOffset(int ordinal) {
        return this.baseOffset + (long)this.bitSetWidthInBytes + (long)ordinal * 8L;
    }

    private void assertIndexIsValid(int index) {
        assert (index >= 0) : "index (" + index + ") should >= 0";
        assert (index < this.numFields) : "index (" + index + ") should < " + this.numFields;
    }

    public Object getBaseObject() {
        return this.baseObject;
    }

    public long getBaseOffset() {
        return this.baseOffset;
    }

    public int getSizeInBytes() {
        return this.sizeInBytes;
    }

    @Override
    public int numFields() {
        return this.numFields;
    }

    public void pointTo(Object baseObject, long baseOffset, int numFields, int sizeInBytes) {
        assert (numFields >= 0) : "numFields (" + numFields + ") should >= 0";
        this.bitSetWidthInBytes = UnsafeRow.calculateBitSetWidthInBytes(numFields);
        this.baseObject = baseObject;
        this.baseOffset = baseOffset;
        this.numFields = numFields;
        this.sizeInBytes = sizeInBytes;
    }

    public void pointTo(byte[] buf, int numFields, int sizeInBytes) {
        this.pointTo(buf, Platform.BYTE_ARRAY_OFFSET, numFields, sizeInBytes);
    }

    @Override
    public void setNullAt(int i) {
        this.assertIndexIsValid(i);
        BitSetMethods.set((Object)this.baseObject, (long)this.baseOffset, (int)i);
        Platform.putLong((Object)this.baseObject, (long)this.getFieldOffset(i), (long)0L);
    }

    @Override
    public void update(int ordinal, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setInt(int ordinal, int value) {
        this.assertIndexIsValid(ordinal);
        this.setNotNullAt(ordinal);
        Platform.putInt((Object)this.baseObject, (long)this.getFieldOffset(ordinal), (int)value);
    }

    @Override
    public void setLong(int ordinal, long value) {
        this.assertIndexIsValid(ordinal);
        this.setNotNullAt(ordinal);
        Platform.putLong((Object)this.baseObject, (long)this.getFieldOffset(ordinal), (long)value);
    }

    @Override
    public void setDouble(int ordinal, double value) {
        this.assertIndexIsValid(ordinal);
        this.setNotNullAt(ordinal);
        if (Double.isNaN(value)) {
            value = Double.NaN;
        }
        Platform.putDouble((Object)this.baseObject, (long)this.getFieldOffset(ordinal), (double)value);
    }

    @Override
    public void setBoolean(int ordinal, boolean value) {
        this.assertIndexIsValid(ordinal);
        this.setNotNullAt(ordinal);
        Platform.putBoolean((Object)this.baseObject, (long)this.getFieldOffset(ordinal), (boolean)value);
    }

    @Override
    public void setShort(int ordinal, short value) {
        this.assertIndexIsValid(ordinal);
        this.setNotNullAt(ordinal);
        Platform.putShort((Object)this.baseObject, (long)this.getFieldOffset(ordinal), (short)value);
    }

    @Override
    public void setByte(int ordinal, byte value) {
        this.assertIndexIsValid(ordinal);
        this.setNotNullAt(ordinal);
        Platform.putByte((Object)this.baseObject, (long)this.getFieldOffset(ordinal), (byte)value);
    }

    @Override
    public void setFloat(int ordinal, float value) {
        this.assertIndexIsValid(ordinal);
        this.setNotNullAt(ordinal);
        if (Float.isNaN(value)) {
            value = Float.NaN;
        }
        Platform.putFloat((Object)this.baseObject, (long)this.getFieldOffset(ordinal), (float)value);
    }

    @Override
    public void setDecimal(int ordinal, Decimal value, int precision) {
        this.assertIndexIsValid(ordinal);
        if (precision <= Decimal.MAX_LONG_DIGITS()) {
            if (value == null) {
                this.setNullAt(ordinal);
            } else {
                this.setLong(ordinal, value.toUnscaledLong());
            }
        } else {
            long cursor = this.getLong(ordinal) >>> 32;
            assert (cursor > 0L) : "invalid cursor " + cursor;
            Platform.putLong((Object)this.baseObject, (long)(this.baseOffset + cursor), (long)0L);
            Platform.putLong((Object)this.baseObject, (long)(this.baseOffset + cursor + 8L), (long)0L);
            if (value == null) {
                this.setNullAt(ordinal);
                Platform.putLong((Object)this.baseObject, (long)this.getFieldOffset(ordinal), (long)(cursor << 32));
            } else {
                BigInteger integer = value.toJavaBigDecimal().unscaledValue();
                byte[] bytes = integer.toByteArray();
                assert (bytes.length <= 16);
                Platform.copyMemory((Object)bytes, (long)Platform.BYTE_ARRAY_OFFSET, (Object)this.baseObject, (long)(this.baseOffset + cursor), (long)bytes.length);
                this.setLong(ordinal, cursor << 32 | (long)bytes.length);
            }
        }
    }

    @Override
    public Object get(int ordinal, DataType dataType2) {
        if (this.isNullAt(ordinal) || dataType2 instanceof NullType) {
            return null;
        }
        if (dataType2 instanceof BooleanType) {
            return this.getBoolean(ordinal);
        }
        if (dataType2 instanceof ByteType) {
            return this.getByte(ordinal);
        }
        if (dataType2 instanceof ShortType) {
            return this.getShort(ordinal);
        }
        if (dataType2 instanceof IntegerType) {
            return this.getInt(ordinal);
        }
        if (dataType2 instanceof LongType) {
            return this.getLong(ordinal);
        }
        if (dataType2 instanceof FloatType) {
            return Float.valueOf(this.getFloat(ordinal));
        }
        if (dataType2 instanceof DoubleType) {
            return this.getDouble(ordinal);
        }
        if (dataType2 instanceof DecimalType) {
            DecimalType dt = (DecimalType)dataType2;
            return this.getDecimal(ordinal, dt.precision(), dt.scale());
        }
        if (dataType2 instanceof DateType) {
            return this.getInt(ordinal);
        }
        if (dataType2 instanceof TimestampType) {
            return this.getLong(ordinal);
        }
        if (dataType2 instanceof BinaryType) {
            return this.getBinary(ordinal);
        }
        if (dataType2 instanceof StringType) {
            return this.getUTF8String(ordinal);
        }
        if (dataType2 instanceof CalendarIntervalType) {
            return this.getInterval(ordinal);
        }
        if (dataType2 instanceof StructType) {
            return this.getStruct(ordinal, ((StructType)dataType2).size());
        }
        if (dataType2 instanceof ArrayType) {
            return this.getArray(ordinal);
        }
        if (dataType2 instanceof MapType) {
            return this.getMap(ordinal);
        }
        throw new UnsupportedOperationException("Unsupported data type " + dataType2.simpleString());
    }

    @Override
    public boolean isNullAt(int ordinal) {
        this.assertIndexIsValid(ordinal);
        return BitSetMethods.isSet((Object)this.baseObject, (long)this.baseOffset, (int)ordinal);
    }

    @Override
    public boolean getBoolean(int ordinal) {
        this.assertIndexIsValid(ordinal);
        return Platform.getBoolean((Object)this.baseObject, (long)this.getFieldOffset(ordinal));
    }

    @Override
    public byte getByte(int ordinal) {
        this.assertIndexIsValid(ordinal);
        return Platform.getByte((Object)this.baseObject, (long)this.getFieldOffset(ordinal));
    }

    @Override
    public short getShort(int ordinal) {
        this.assertIndexIsValid(ordinal);
        return Platform.getShort((Object)this.baseObject, (long)this.getFieldOffset(ordinal));
    }

    @Override
    public int getInt(int ordinal) {
        this.assertIndexIsValid(ordinal);
        return Platform.getInt((Object)this.baseObject, (long)this.getFieldOffset(ordinal));
    }

    @Override
    public long getLong(int ordinal) {
        this.assertIndexIsValid(ordinal);
        return Platform.getLong((Object)this.baseObject, (long)this.getFieldOffset(ordinal));
    }

    @Override
    public float getFloat(int ordinal) {
        this.assertIndexIsValid(ordinal);
        return Platform.getFloat((Object)this.baseObject, (long)this.getFieldOffset(ordinal));
    }

    @Override
    public double getDouble(int ordinal) {
        this.assertIndexIsValid(ordinal);
        return Platform.getDouble((Object)this.baseObject, (long)this.getFieldOffset(ordinal));
    }

    @Override
    public Decimal getDecimal(int ordinal, int precision, int scale) {
        if (this.isNullAt(ordinal)) {
            return null;
        }
        if (precision <= Decimal.MAX_LONG_DIGITS()) {
            return Decimal.apply(this.getLong(ordinal), precision, scale);
        }
        byte[] bytes = this.getBinary(ordinal);
        BigInteger bigInteger = new BigInteger(bytes);
        BigDecimal javaDecimal = new BigDecimal(bigInteger, scale);
        return Decimal.apply(javaDecimal, precision, scale);
    }

    @Override
    public UTF8String getUTF8String(int ordinal) {
        if (this.isNullAt(ordinal)) {
            return null;
        }
        long offsetAndSize = this.getLong(ordinal);
        int offset = (int)(offsetAndSize >> 32);
        int size = (int)(offsetAndSize & 0xFFFFFFFFL);
        return UTF8String.fromAddress((Object)this.baseObject, (long)(this.baseOffset + (long)offset), (int)size);
    }

    @Override
    public byte[] getBinary(int ordinal) {
        if (this.isNullAt(ordinal)) {
            return null;
        }
        long offsetAndSize = this.getLong(ordinal);
        int offset = (int)(offsetAndSize >> 32);
        int size = (int)(offsetAndSize & 0xFFFFFFFFL);
        byte[] bytes = new byte[size];
        Platform.copyMemory((Object)this.baseObject, (long)(this.baseOffset + (long)offset), (Object)bytes, (long)Platform.BYTE_ARRAY_OFFSET, (long)size);
        return bytes;
    }

    @Override
    public CalendarInterval getInterval(int ordinal) {
        if (this.isNullAt(ordinal)) {
            return null;
        }
        long offsetAndSize = this.getLong(ordinal);
        int offset = (int)(offsetAndSize >> 32);
        int months = (int)Platform.getLong((Object)this.baseObject, (long)(this.baseOffset + (long)offset));
        long microseconds = Platform.getLong((Object)this.baseObject, (long)(this.baseOffset + (long)offset + 8L));
        return new CalendarInterval(months, microseconds);
    }

    @Override
    public UnsafeRow getStruct(int ordinal, int numFields) {
        if (this.isNullAt(ordinal)) {
            return null;
        }
        long offsetAndSize = this.getLong(ordinal);
        int offset = (int)(offsetAndSize >> 32);
        int size = (int)(offsetAndSize & 0xFFFFFFFFL);
        UnsafeRow row = new UnsafeRow();
        row.pointTo(this.baseObject, this.baseOffset + (long)offset, numFields, size);
        return row;
    }

    @Override
    public ArrayData getArray(int ordinal) {
        if (this.isNullAt(ordinal)) {
            return null;
        }
        long offsetAndSize = this.getLong(ordinal);
        int offset = (int)(offsetAndSize >> 32);
        int size = (int)(offsetAndSize & 0xFFFFFFFFL);
        return UnsafeReaders.readArray(this.baseObject, this.baseOffset + (long)offset, size);
    }

    @Override
    public MapData getMap(int ordinal) {
        if (this.isNullAt(ordinal)) {
            return null;
        }
        long offsetAndSize = this.getLong(ordinal);
        int offset = (int)(offsetAndSize >> 32);
        int size = (int)(offsetAndSize & 0xFFFFFFFFL);
        return UnsafeReaders.readMap(this.baseObject, this.baseOffset + (long)offset, size);
    }

    @Override
    public UnsafeRow copy() {
        UnsafeRow rowCopy = new UnsafeRow();
        byte[] rowDataCopy = new byte[this.sizeInBytes];
        Platform.copyMemory((Object)this.baseObject, (long)this.baseOffset, (Object)rowDataCopy, (long)Platform.BYTE_ARRAY_OFFSET, (long)this.sizeInBytes);
        rowCopy.pointTo(rowDataCopy, Platform.BYTE_ARRAY_OFFSET, this.numFields, this.sizeInBytes);
        return rowCopy;
    }

    public static UnsafeRow createFromByteArray(int numBytes, int numFields) {
        UnsafeRow row = new UnsafeRow();
        row.pointTo(new byte[numBytes], numFields, numBytes);
        return row;
    }

    public void copyFrom(UnsafeRow row) {
        assert (this.baseObject instanceof byte[] && this.baseOffset == (long)Platform.BYTE_ARRAY_OFFSET);
        if (row.sizeInBytes > this.sizeInBytes) {
            this.baseObject = new byte[row.sizeInBytes];
        }
        Platform.copyMemory((Object)row.baseObject, (long)row.baseOffset, (Object)this.baseObject, (long)this.baseOffset, (long)row.sizeInBytes);
        this.sizeInBytes = row.sizeInBytes;
    }

    public void writeToStream(OutputStream out, byte[] writeBuffer) throws IOException {
        if (this.baseObject instanceof byte[]) {
            int offsetInByteArray = (int)((long)Platform.BYTE_ARRAY_OFFSET - this.baseOffset);
            out.write((byte[])this.baseObject, offsetInByteArray, this.sizeInBytes);
        } else {
            int toTransfer;
            long rowReadPosition = this.baseOffset;
            for (int dataRemaining = this.sizeInBytes; dataRemaining > 0; dataRemaining -= toTransfer) {
                toTransfer = Math.min(writeBuffer.length, dataRemaining);
                Platform.copyMemory((Object)this.baseObject, (long)rowReadPosition, (Object)writeBuffer, (long)Platform.BYTE_ARRAY_OFFSET, (long)toTransfer);
                out.write(writeBuffer, 0, toTransfer);
                rowReadPosition += (long)toTransfer;
            }
        }
    }

    public int hashCode() {
        return Murmur3_x86_32.hashUnsafeWords((Object)this.baseObject, (long)this.baseOffset, (int)this.sizeInBytes, (int)42);
    }

    public boolean equals(Object other) {
        if (other instanceof UnsafeRow) {
            UnsafeRow o = (UnsafeRow)other;
            return this.sizeInBytes == o.sizeInBytes && ByteArrayMethods.arrayEquals((Object)this.baseObject, (long)this.baseOffset, (Object)o.baseObject, (long)o.baseOffset, (long)this.sizeInBytes);
        }
        return false;
    }

    public byte[] getBytes() {
        if (this.baseObject instanceof byte[] && this.baseOffset == (long)Platform.BYTE_ARRAY_OFFSET && ((byte[])this.baseObject).length == this.sizeInBytes) {
            return (byte[])this.baseObject;
        }
        byte[] bytes = new byte[this.sizeInBytes];
        Platform.copyMemory((Object)this.baseObject, (long)this.baseOffset, (Object)bytes, (long)Platform.BYTE_ARRAY_OFFSET, (long)this.sizeInBytes);
        return bytes;
    }

    public String toString() {
        StringBuilder build = new StringBuilder("[");
        for (int i = 0; i < this.sizeInBytes; i += 8) {
            build.append(Long.toHexString(Platform.getLong((Object)this.baseObject, (long)(this.baseOffset + (long)i))));
            build.append(',');
        }
        build.append(']');
        return build.toString();
    }

    @Override
    public boolean anyNull() {
        return BitSetMethods.anySet((Object)this.baseObject, (long)this.baseOffset, (long)(this.bitSetWidthInBytes / 8));
    }

    public void writeToMemory(Object target, long targetOffset) {
        Platform.copyMemory((Object)this.baseObject, (long)this.baseOffset, (Object)target, (long)targetOffset, (long)this.sizeInBytes);
    }
}

