/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.expressions.UnsafeArrayData;
import org.apache.spark.sql.types.ArrayData;
import org.apache.spark.sql.types.MapData;

public class UnsafeMapData
extends MapData {
    public final UnsafeArrayData keys;
    public final UnsafeArrayData values;
    private int numElements;
    private int sizeInBytes;

    public int getSizeInBytes() {
        return this.sizeInBytes;
    }

    public UnsafeMapData(UnsafeArrayData keys, UnsafeArrayData values) {
        assert (keys.numElements() == values.numElements());
        this.sizeInBytes = keys.getSizeInBytes() + values.getSizeInBytes();
        this.numElements = keys.numElements();
        this.keys = keys;
        this.values = values;
    }

    @Override
    public int numElements() {
        return this.numElements;
    }

    @Override
    public ArrayData keyArray() {
        return this.keys;
    }

    @Override
    public ArrayData valueArray() {
        return this.values;
    }

    @Override
    public UnsafeMapData copy() {
        return new UnsafeMapData(this.keys.copy(), this.values.copy());
    }
}

