/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.analysis;

import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.catalyst.analysis.Append$;
import org.apache.spark.sql.catalyst.analysis.OutputMode;
import org.apache.spark.sql.catalyst.plans.FullOuter$;
import org.apache.spark.sql.catalyst.plans.Inner$;
import org.apache.spark.sql.catalyst.plans.JoinType;
import org.apache.spark.sql.catalyst.plans.LeftAnti$;
import org.apache.spark.sql.catalyst.plans.LeftOuter$;
import org.apache.spark.sql.catalyst.plans.LeftSemi$;
import org.apache.spark.sql.catalyst.plans.NaturalJoin;
import org.apache.spark.sql.catalyst.plans.RightOuter$;
import org.apache.spark.sql.catalyst.plans.UsingJoin;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.CoGroup;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.Except;
import org.apache.spark.sql.catalyst.plans.logical.GlobalLimit;
import org.apache.spark.sql.catalyst.plans.logical.GroupingSets;
import org.apache.spark.sql.catalyst.plans.logical.InsertIntoTable;
import org.apache.spark.sql.catalyst.plans.logical.Intersect;
import org.apache.spark.sql.catalyst.plans.logical.Join;
import org.apache.spark.sql.catalyst.plans.logical.LocalLimit;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.ReturnAnswer;
import org.apache.spark.sql.catalyst.plans.logical.Sample;
import org.apache.spark.sql.catalyst.plans.logical.Sort;
import org.apache.spark.sql.catalyst.plans.logical.SortPartitions;
import org.apache.spark.sql.catalyst.plans.logical.Union;
import org.apache.spark.sql.catalyst.plans.logical.Window;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;

public final class UnsupportedOperationChecker$ {
    public static final UnsupportedOperationChecker$ MODULE$;

    static {
        new UnsupportedOperationChecker$();
    }

    public void checkForBatch(LogicalPlan plan2) {
        plan2.foreachUp(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(LogicalPlan x0$1) {
                LogicalPlan logicalPlan = x0$1;
                if (logicalPlan.isStreaming()) {
                    throw UnsupportedOperationChecker$.MODULE$.org$apache$spark$sql$catalyst$analysis$UnsupportedOperationChecker$$throwError("Queries with streaming sources must be executed with write.startStream()", logicalPlan);
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        });
    }

    public void checkForStreaming(LogicalPlan plan2, OutputMode outputMode) {
        if (plan2.isStreaming()) {
            plan2.foreachUp(new Serializable(outputMode){
                public static final long serialVersionUID = 0L;
                private final OutputMode outputMode$1;

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final void apply(LogicalPlan plan2) {
                    Aggregate aggregate;
                    LogicalPlan child;
                    LogicalPlan logicalPlan = plan2;
                    if (logicalPlan instanceof Command) {
                        throw UnsupportedOperationChecker$.MODULE$.org$apache$spark$sql$catalyst$analysis$UnsupportedOperationChecker$$throwError("Commands like CreateTable*, AlterTable*, Show* are not supported with streaming DataFrames/Datasets", plan2);
                    }
                    if (logicalPlan instanceof InsertIntoTable) {
                        throw UnsupportedOperationChecker$.MODULE$.org$apache$spark$sql$catalyst$analysis$UnsupportedOperationChecker$$throwError("InsertIntoTable is not supported with streaming DataFrames/Datasets", plan2);
                    }
                    if (logicalPlan instanceof Aggregate && (child = (aggregate = (Aggregate)logicalPlan).child()).isStreaming()) {
                        OutputMode outputMode = this.outputMode$1;
                        Append$ append$ = Append$.MODULE$;
                        if (!(outputMode != null ? !outputMode.equals(append$) : append$ != null)) {
                            throw UnsupportedOperationChecker$.MODULE$.org$apache$spark$sql$catalyst$analysis$UnsupportedOperationChecker$$throwError("Aggregations are not supported on streaming DataFrames/Datasets in Append output mode. Consider changing output mode to Update.", plan2);
                        }
                    }
                    if (logicalPlan instanceof Join) {
                        Join join = (Join)logicalPlan;
                        LogicalPlan left = join.left();
                        LogicalPlan right = join.right();
                        JoinType joinType = join.joinType();
                        JoinType joinType2 = joinType;
                        if (Inner$.MODULE$.equals(joinType2)) {
                            if (left.isStreaming() && right.isStreaming()) {
                                throw UnsupportedOperationChecker$.MODULE$.org$apache$spark$sql$catalyst$analysis$UnsupportedOperationChecker$$throwError("Inner join between two streaming DataFrames/Datasets is not supported", plan2);
                            }
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else if (FullOuter$.MODULE$.equals(joinType2)) {
                            if (left.isStreaming() || right.isStreaming()) {
                                throw UnsupportedOperationChecker$.MODULE$.org$apache$spark$sql$catalyst$analysis$UnsupportedOperationChecker$$throwError("Full outer joins with streaming DataFrames/Datasets are not supported", plan2);
                            }
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boolean bl = LeftOuter$.MODULE$.equals(joinType2) ? true : (LeftSemi$.MODULE$.equals(joinType2) ? true : LeftAnti$.MODULE$.equals(joinType2));
                            if (bl) {
                                if (right.isStreaming()) {
                                    throw UnsupportedOperationChecker$.MODULE$.org$apache$spark$sql$catalyst$analysis$UnsupportedOperationChecker$$throwError("Left outer/semi/anti joins with a streaming DataFrame/Dataset on the right is not supported", plan2);
                                }
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            } else if (RightOuter$.MODULE$.equals(joinType2)) {
                                if (left.isStreaming()) {
                                    throw UnsupportedOperationChecker$.MODULE$.org$apache$spark$sql$catalyst$analysis$UnsupportedOperationChecker$$throwError("Right outer join with a streaming DataFrame/Dataset on the left is not supported", plan2);
                                }
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            } else {
                                boolean bl2 = joinType2 instanceof NaturalJoin ? true : joinType2 instanceof UsingJoin;
                                if (!bl2) throw UnsupportedOperationChecker$.MODULE$.org$apache$spark$sql$catalyst$analysis$UnsupportedOperationChecker$$throwError(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Join type ", " is not supported with streaming DataFrame/Dataset"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{joinType})), plan2);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            }
                        }
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    } else {
                        ReturnAnswer returnAnswer;
                        LogicalPlan child2;
                        Window window;
                        LogicalPlan child3;
                        Sample sample2;
                        LogicalPlan child4;
                        GroupingSets groupingSets;
                        LogicalPlan child5;
                        Except except;
                        LogicalPlan right;
                        Union union;
                        CoGroup coGroup;
                        if (logicalPlan instanceof CoGroup && (coGroup = (CoGroup)logicalPlan).children().exists((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(LogicalPlan x$1) {
                                return x$1.isStreaming();
                            }
                        })) {
                            throw UnsupportedOperationChecker$.MODULE$.org$apache$spark$sql$catalyst$analysis$UnsupportedOperationChecker$$throwError("CoGrouping with a streaming DataFrame/Dataset is not supported", plan2);
                        }
                        if (logicalPlan instanceof Union && ((SeqLike)((SeqLike)(union = (Union)logicalPlan).children().map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(LogicalPlan x$2) {
                                return x$2.isStreaming();
                            }
                        }, Seq$.MODULE$.canBuildFrom())).distinct()).size() == 2) {
                            throw UnsupportedOperationChecker$.MODULE$.org$apache$spark$sql$catalyst$analysis$UnsupportedOperationChecker$$throwError("Union between streaming and batch DataFrames/Datasets is not supported", plan2);
                        }
                        if (logicalPlan instanceof Except && (right = (except = (Except)logicalPlan).right()).isStreaming()) {
                            throw UnsupportedOperationChecker$.MODULE$.org$apache$spark$sql$catalyst$analysis$UnsupportedOperationChecker$$throwError("Except with a streaming DataFrame/Dataset on the right is not supported", plan2);
                        }
                        if (logicalPlan instanceof Intersect) {
                            Intersect intersect = (Intersect)logicalPlan;
                            LogicalPlan left = intersect.left();
                            LogicalPlan right2 = intersect.right();
                            if (left.isStreaming() && right2.isStreaming()) {
                                throw UnsupportedOperationChecker$.MODULE$.org$apache$spark$sql$catalyst$analysis$UnsupportedOperationChecker$$throwError("Intersect between two streaming DataFrames/Datasets is not supported", plan2);
                            }
                        }
                        if (logicalPlan instanceof GroupingSets && (child5 = (groupingSets = (GroupingSets)logicalPlan).child()).isStreaming()) {
                            throw UnsupportedOperationChecker$.MODULE$.org$apache$spark$sql$catalyst$analysis$UnsupportedOperationChecker$$throwError("GroupingSets is not supported on streaming DataFrames/Datasets", plan2);
                        }
                        boolean bl = logicalPlan instanceof GlobalLimit ? true : logicalPlan instanceof LocalLimit;
                        if (bl && plan2.children().forall((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(LogicalPlan x$3) {
                                return x$3.isStreaming();
                            }
                        })) {
                            throw UnsupportedOperationChecker$.MODULE$.org$apache$spark$sql$catalyst$analysis$UnsupportedOperationChecker$$throwError("Limits are not supported on streaming DataFrames/Datasets", plan2);
                        }
                        boolean bl3 = logicalPlan instanceof Sort ? true : logicalPlan instanceof SortPartitions;
                        if (bl3 && plan2.children().forall((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(LogicalPlan x$4) {
                                return x$4.isStreaming();
                            }
                        })) {
                            throw UnsupportedOperationChecker$.MODULE$.org$apache$spark$sql$catalyst$analysis$UnsupportedOperationChecker$$throwError("Sorting is not supported on streaming DataFrames/Datasets", plan2);
                        }
                        if (logicalPlan instanceof Sample && (child4 = (sample2 = (Sample)logicalPlan).child()).isStreaming()) {
                            throw UnsupportedOperationChecker$.MODULE$.org$apache$spark$sql$catalyst$analysis$UnsupportedOperationChecker$$throwError("Sampling is not supported on streaming DataFrames/Datasets", plan2);
                        }
                        if (logicalPlan instanceof Window && (child3 = (window = (Window)logicalPlan).child()).isStreaming()) {
                            throw UnsupportedOperationChecker$.MODULE$.org$apache$spark$sql$catalyst$analysis$UnsupportedOperationChecker$$throwError("Non-time-based windows are not supported on streaming DataFrames/Datasets", plan2);
                        }
                        if (logicalPlan instanceof ReturnAnswer && (child2 = (returnAnswer = (ReturnAnswer)logicalPlan).child()).isStreaming()) {
                            throw UnsupportedOperationChecker$.MODULE$.org$apache$spark$sql$catalyst$analysis$UnsupportedOperationChecker$$throwError("Cannot return immediate result on streaming DataFrames/Dataset. Queries with streaming DataFrames/Datasets must be executed with write.startStream().", plan2);
                        }
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                }
                {
                    this.outputMode$1 = outputMode$1;
                }
            });
            return;
        }
        throw this.org$apache$spark$sql$catalyst$analysis$UnsupportedOperationChecker$$throwError("Queries without streaming sources cannot be executed with write.startStream()", plan2);
    }

    private void throwErrorIf(boolean condition, String msg, LogicalPlan operator) {
        if (condition) {
            throw this.org$apache$spark$sql$catalyst$analysis$UnsupportedOperationChecker$$throwError(msg, operator);
        }
    }

    public Nothing$ org$apache$spark$sql$catalyst$analysis$UnsupportedOperationChecker$$throwError(String msg, LogicalPlan operator) {
        throw new AnalysisException(msg, operator.origin().line(), operator.origin().startPosition(), (Option<LogicalPlan>)new Some((Object)operator));
    }

    private UnsupportedOperationChecker$() {
        MODULE$ = this;
    }
}

