/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.catalog;

import javax.annotation.concurrent.GuardedBy;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.catalyst.CatalystConf;
import org.apache.spark.sql.catalyst.FunctionIdentifier;
import org.apache.spark.sql.catalyst.FunctionIdentifier$;
import org.apache.spark.sql.catalyst.SimpleCatalystConf;
import org.apache.spark.sql.catalyst.SimpleCatalystConf$;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.TableIdentifier$;
import org.apache.spark.sql.catalyst.analysis.FunctionAlreadyExistsException;
import org.apache.spark.sql.catalyst.analysis.FunctionRegistry;
import org.apache.spark.sql.catalyst.analysis.FunctionRegistry$;
import org.apache.spark.sql.catalyst.analysis.NoSuchDatabaseException;
import org.apache.spark.sql.catalyst.analysis.NoSuchFunctionException;
import org.apache.spark.sql.catalyst.analysis.NoSuchPermanentFunctionException;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.analysis.NoSuchTempFunctionException;
import org.apache.spark.sql.catalyst.analysis.SimpleFunctionRegistry;
import org.apache.spark.sql.catalyst.analysis.TableAlreadyExistsException;
import org.apache.spark.sql.catalyst.analysis.TempFunctionAlreadyExistsException;
import org.apache.spark.sql.catalyst.analysis.TempTableAlreadyExistsException;
import org.apache.spark.sql.catalyst.catalog.CatalogDatabase;
import org.apache.spark.sql.catalyst.catalog.CatalogFunction;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTablePartition;
import org.apache.spark.sql.catalyst.catalog.DummyFunctionResourceLoader$;
import org.apache.spark.sql.catalyst.catalog.ExternalCatalog;
import org.apache.spark.sql.catalyst.catalog.FunctionResource;
import org.apache.spark.sql.catalyst.catalog.FunctionResourceLoader;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog$;
import org.apache.spark.sql.catalyst.catalog.SimpleCatalogRelation;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionInfo;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.SubqueryAlias;
import org.apache.spark.sql.catalyst.util.StringUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\u0011-b\u0001B\u0001\u0003\u0001=\u0011abU3tg&|gnQ1uC2|wM\u0003\u0002\u0004\t\u000591-\u0019;bY><'BA\u0003\u0007\u0003!\u0019\u0017\r^1msN$(BA\u0004\t\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u0013)\tQa\u001d9be.T!a\u0003\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0011aA8sO\u000e\u00011c\u0001\u0001\u0011-A\u0011\u0011\u0003F\u0007\u0002%)\t1#A\u0003tG\u0006d\u0017-\u0003\u0002\u0016%\t1\u0011I\\=SK\u001a\u0004\"a\u0006\u000e\u000e\u0003aQ!!\u0007\u0005\u0002\u0011%tG/\u001a:oC2L!a\u0007\r\u0003\u000f1{wmZ5oO\"AQ\u0004\u0001B\u0001B\u0003%a$A\bfqR,'O\\1m\u0007\u0006$\u0018\r\\8h!\ty\u0002%D\u0001\u0003\u0013\t\t#AA\bFqR,'O\\1m\u0007\u0006$\u0018\r\\8h\u0011!\u0019\u0003A!A!\u0002\u0013!\u0013A\u00064v]\u000e$\u0018n\u001c8SKN|WO]2f\u0019>\fG-\u001a:\u0011\u0005})\u0013B\u0001\u0014\u0003\u0005Y1UO\\2uS>t'+Z:pkJ\u001cW\rT8bI\u0016\u0014\b\u0002\u0003\u0015\u0001\u0005\u0003\u0005\u000b\u0011B\u0015\u0002!\u0019,hn\u0019;j_:\u0014VmZ5tiJL\bC\u0001\u0016.\u001b\u0005Y#B\u0001\u0017\u0005\u0003!\tg.\u00197zg&\u001c\u0018B\u0001\u0018,\u0005A1UO\\2uS>t'+Z4jgR\u0014\u0018\u0010\u0003\u00051\u0001\t\u0005\t\u0015!\u00032\u0003\u0011\u0019wN\u001c4\u0011\u0005I\u001aT\"\u0001\u0003\n\u0005Q\"!\u0001D\"bi\u0006d\u0017p\u001d;D_:4\u0007\u0002\u0003\u001c\u0001\u0005\u0003\u0005\u000b\u0011B\u001c\u0002\u0015!\fGm\\8q\u0007>tg\r\u0005\u00029y5\t\u0011H\u0003\u00021u)\u00111HC\u0001\u0007Q\u0006$wn\u001c9\n\u0005uJ$!D\"p]\u001aLw-\u001e:bi&|g\u000eC\u0003@\u0001\u0011\u0005\u0001)\u0001\u0004=S:LGO\u0010\u000b\u0007\u0003\n\u001bE)\u0012$\u0011\u0005}\u0001\u0001\"B\u000f?\u0001\u0004q\u0002\"B\u0012?\u0001\u0004!\u0003\"\u0002\u0015?\u0001\u0004I\u0003\"\u0002\u0019?\u0001\u0004\t\u0004\"\u0002\u001c?\u0001\u00049\u0004\"B \u0001\t\u0003AE\u0003B!J\u0015.CQ!H$A\u0002yAQ\u0001K$A\u0002%BQ\u0001M$A\u0002EBQa\u0010\u0001\u0005\u00025#\"!\u0011(\t\u000bua\u0005\u0019\u0001\u0010\t\u000fA\u0003!\u0019!C\t#\u0006QA/Z7q)\u0006\u0014G.Z:\u0016\u0003I\u0003Ba\u0015-[C6\tAK\u0003\u0002V-\u00069Q.\u001e;bE2,'BA,\u0013\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u00033R\u0013q\u0001S1tQ6\u000b\u0007\u000f\u0005\u0002\\=:\u0011\u0011\u0003X\u0005\u0003;J\ta\u0001\u0015:fI\u00164\u0017BA0a\u0005\u0019\u0019FO]5oO*\u0011QL\u0005\t\u0003E\u001el\u0011a\u0019\u0006\u0003I\u0016\fq\u0001\\8hS\u000e\fGN\u0003\u0002g\t\u0005)\u0001\u000f\\1og&\u0011\u0001n\u0019\u0002\f\u0019><\u0017nY1m!2\fg\u000e\u0003\u0004k\u0001\u0001\u0006IAU\u0001\fi\u0016l\u0007\u000fV1cY\u0016\u001c\b\u0005\u000b\u0003jYZ<\bCA7u\u001b\u0005q'BA8q\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003cJ\f!\"\u00198o_R\fG/[8o\u0015\u0005\u0019\u0018!\u00026bm\u0006D\u0018BA;o\u0005%9U/\u0019:eK\u0012\u0014\u00150A\u0003wC2,X-I\u0001y\u0003\u0011!\b.[:\t\u000fi\u0004\u0001\u0019!C\tw\u0006I1-\u001e:sK:$HIY\u000b\u00025\"9Q\u0010\u0001a\u0001\n#q\u0018!D2veJ,g\u000e\u001e#c?\u0012*\u0017\u000fF\u0002\u0000\u0003\u000b\u00012!EA\u0001\u0013\r\t\u0019A\u0005\u0002\u0005+:LG\u000f\u0003\u0005\u0002\bq\f\t\u00111\u0001[\u0003\rAH%\r\u0005\b\u0003\u0017\u0001\u0001\u0015)\u0003[\u0003)\u0019WO\u001d:f]R$%\r\t\u0015\u0006\u0003\u0013ago\u001e\u0005\t\u0003#\u0001\u0001\u0015\"\u0005\u0002\u0014\u0005yam\u001c:nCR$\u0016M\u00197f\u001d\u0006lW\rF\u0002[\u0003+Aq!a\u0006\u0002\u0010\u0001\u0007!,\u0001\u0003oC6,\u0007\u0002CA\u000e\u0001\u0001&\t\"!\b\u0002%\u0019|'/\\1u\t\u0006$\u0018MY1tK:\u000bW.\u001a\u000b\u00045\u0006}\u0001bBA\f\u00033\u0001\rA\u0017\u0005\b\u0003G\u0001A\u0011BA\u0013\u0003Ei\u0017m[3Rk\u0006d\u0017NZ5fIB\u000bG\u000f\u001b\u000b\u0005\u0003O\t\u0019\u0004\u0005\u0003\u0002*\u0005=RBAA\u0016\u0015\r\tiCO\u0001\u0003MNLA!!\r\u0002,\t!\u0001+\u0019;i\u0011\u001d\t)$!\tA\u0002i\u000bA\u0001]1uQ\"A\u0011\u0011\b\u0001!\n#\tY$A\bsKF,\u0018N]3EE\u0016C\u0018n\u001d;t)\ry\u0018Q\b\u0005\b\u0003\u007f\t9\u00041\u0001[\u0003\t!'\r\u0003\u0005\u0002D\u0001\u0001K\u0011CA#\u0003I\u0011X-];je\u0016$\u0016M\u00197f\u000bbL7\u000f^:\u0015\u0007}\f9\u0005\u0003\u0005\u0002\u0018\u0005\u0005\u0003\u0019AA%!\r\u0011\u00141J\u0005\u0004\u0003\u001b\"!a\u0004+bE2,\u0017\nZ3oi&4\u0017.\u001a:\t\u000f\u0005E\u0003\u0001\"\u0003\u0002T\u0005)\"/Z9vSJ,G+\u00192mK:{G/\u0012=jgR\u001cHcA@\u0002V!A\u0011qCA(\u0001\u0004\tI\u0005C\u0004\u0002Z\u0001!\t!a\u0017\u0002\u001d\r\u0014X-\u0019;f\t\u0006$\u0018MY1tKR)q0!\u0018\u0002h!A\u0011qLA,\u0001\u0004\t\t'\u0001\u0007eE\u0012+g-\u001b8ji&|g\u000eE\u0002 \u0003GJ1!!\u001a\u0003\u0005=\u0019\u0015\r^1m_\u001e$\u0015\r^1cCN,\u0007\u0002CA5\u0003/\u0002\r!a\u001b\u0002\u001d%<gn\u001c:f\u0013\u001a,\u00050[:ugB\u0019\u0011#!\u001c\n\u0007\u0005=$CA\u0004C_>dW-\u00198\t\u000f\u0005M\u0004\u0001\"\u0001\u0002v\u0005aAM]8q\t\u0006$\u0018MY1tKR9q0a\u001e\u0002z\u0005u\u0004bBA \u0003c\u0002\rA\u0017\u0005\t\u0003w\n\t\b1\u0001\u0002l\u0005\t\u0012n\u001a8pe\u0016LeMT8u\u000bbL7\u000f^:\t\u0011\u0005}\u0014\u0011\u000fa\u0001\u0003W\nqaY1tG\u0006$W\rC\u0004\u0002\u0004\u0002!\t!!\"\u0002\u001b\u0005dG/\u001a:ECR\f'-Y:f)\ry\u0018q\u0011\u0005\t\u0003?\n\t\t1\u0001\u0002b!9\u00111\u0012\u0001\u0005\u0002\u00055\u0015aE4fi\u0012\u000bG/\u00192bg\u0016lU\r^1eCR\fG\u0003BA1\u0003\u001fCq!a\u0010\u0002\n\u0002\u0007!\fC\u0004\u0002\u0014\u0002!\t!!&\u0002\u001d\u0011\fG/\u00192bg\u0016,\u00050[:ugR!\u00111NAL\u0011\u001d\ty$!%A\u0002iCq!a'\u0001\t\u0003\ti*A\u0007mSN$H)\u0019;bE\u0006\u001cXm\u001d\u000b\u0003\u0003?\u0003R!!)\u00022jsA!a)\u0002.:!\u0011QUAV\u001b\t\t9KC\u0002\u0002*:\ta\u0001\u0010:p_Rt\u0014\"A\n\n\u0007\u0005=&#A\u0004qC\u000e\\\u0017mZ3\n\t\u0005M\u0016Q\u0017\u0002\u0004'\u0016\f(bAAX%!9\u00111\u0014\u0001\u0005\u0002\u0005eF\u0003BAP\u0003wCq!!0\u00028\u0002\u0007!,A\u0004qCR$XM\u001d8\t\r\u0005\u0005\u0007\u0001\"\u0001|\u0003I9W\r^\"veJ,g\u000e\u001e#bi\u0006\u0014\u0017m]3\t\u000f\u0005\u0015\u0007\u0001\"\u0001\u0002H\u0006\u00112/\u001a;DkJ\u0014XM\u001c;ECR\f'-Y:f)\ry\u0018\u0011\u001a\u0005\b\u0003\u007f\t\u0019\r1\u0001[\u0011\u001d\ti\r\u0001C\u0001\u0003\u001f\f\u0001cZ3u\t\u00164\u0017-\u001e7u\t\n\u0003\u0016\r\u001e5\u0015\u0007i\u000b\t\u000eC\u0004\u0002@\u0005-\u0007\u0019\u0001.\t\u000f\u0005U\u0007\u0001\"\u0001\u0002X\u0006Y1M]3bi\u0016$\u0016M\u00197f)\u0015y\u0018\u0011\\Ar\u0011!\tY.a5A\u0002\u0005u\u0017a\u0004;bE2,G)\u001a4j]&$\u0018n\u001c8\u0011\u0007}\ty.C\u0002\u0002b\n\u0011AbQ1uC2|w\rV1cY\u0016D\u0001\"!\u001b\u0002T\u0002\u0007\u00111\u000e\u0005\b\u0003O\u0004A\u0011AAu\u0003)\tG\u000e^3s)\u0006\u0014G.\u001a\u000b\u0004\u007f\u0006-\b\u0002CAn\u0003K\u0004\r!!8\t\u000f\u0005=\b\u0001\"\u0001\u0002r\u0006\u0001r-\u001a;UC\ndW-T3uC\u0012\fG/\u0019\u000b\u0005\u0003;\f\u0019\u0010\u0003\u0005\u0002\u0018\u00055\b\u0019AA%\u0011\u001d\t9\u0010\u0001C\u0001\u0003s\facZ3u)\u0006\u0014G.Z'fi\u0006$\u0017\r^1PaRLwN\u001c\u000b\u0005\u0003w\u0014\t\u0001E\u0003\u0012\u0003{\fi.C\u0002\u0002\u0000J\u0011aa\u00149uS>t\u0007\u0002CA\f\u0003k\u0004\r!!\u0013\t\u000f\t\u0015\u0001\u0001\"\u0001\u0003\b\u0005IAn\\1e)\u0006\u0014G.\u001a\u000b\n\u007f\n%!1\u0002B\b\u0005'A\u0001\"a\u0006\u0003\u0004\u0001\u0007\u0011\u0011\n\u0005\b\u0005\u001b\u0011\u0019\u00011\u0001[\u0003!aw.\u00193QCRD\u0007\u0002\u0003B\t\u0005\u0007\u0001\r!a\u001b\u0002\u0017%\u001cxJ^3soJLG/\u001a\u0005\t\u0005+\u0011\u0019\u00011\u0001\u0002l\u0005Y\u0001n\u001c7e\t\u0012cE+[7f\u0011\u001d\u0011I\u0002\u0001C\u0001\u00057\tQ\u0002\\8bIB\u000b'\u000f^5uS>tGcD@\u0003\u001e\t}!\u0011\u0005B\u001a\u0005k\u00119Da\u000f\t\u0011\u0005]!q\u0003a\u0001\u0003\u0013BqA!\u0004\u0003\u0018\u0001\u0007!\f\u0003\u0005\u0003$\t]\u0001\u0019\u0001B\u0013\u0003%\u0001\u0018M\u001d;ji&|g\u000e\u0005\u0003\u0003(\t5bbA\u0010\u0003*%\u0019!1\u0006\u0002\u0002\u0019\r\u000bG/\u00197pORK\b/Z:\n\t\t=\"\u0011\u0007\u0002\u0013)\u0006\u0014G.\u001a)beRLG/[8o'B,7MC\u0002\u0003,\tA\u0001B!\u0005\u0003\u0018\u0001\u0007\u00111\u000e\u0005\t\u0005+\u00119\u00021\u0001\u0002l!A!\u0011\bB\f\u0001\u0004\tY'A\tj]\",'/\u001b;UC\ndWm\u00159fGND\u0001B!\u0010\u0003\u0018\u0001\u0007\u00111N\u0001\u0016SN\u001c6.Z<fIN#xN]3BgN+(\rZ5s\u0011\u001d\u0011\t\u0005\u0001C\u0001\u0005\u0007\n\u0001\u0003Z3gCVdG\u000fV1cY\u0016\u0004\u0016\r\u001e5\u0015\u0007i\u0013)\u0005\u0003\u0005\u0003H\t}\u0002\u0019AA%\u0003)!\u0018M\u00197f\u0013\u0012,g\u000e\u001e\u0005\b\u0005\u0017\u0002A\u0011\u0001B'\u00039\u0019'/Z1uKR+W\u000e\u001d,jK^$ra B(\u0005#\u0012\u0019\u0006C\u0004\u0002\u0018\t%\u0003\u0019\u0001.\t\u000f\u0005m'\u0011\na\u0001C\"A!Q\u000bB%\u0001\u0004\tY'\u0001\tpm\u0016\u0014(/\u001b3f\u0013\u001a,\u00050[:ug\"9!\u0011\f\u0001\u0005\u0002\tm\u0013a\u0003:f]\u0006lW\rV1cY\u0016$Ra B/\u0005CB\u0001Ba\u0018\u0003X\u0001\u0007\u0011\u0011J\u0001\b_2$g*Y7f\u0011!\u0011\u0019Ga\u0016A\u0002\u0005%\u0013a\u00028fo:\u000bW.\u001a\u0005\b\u0005O\u0002A\u0011\u0001B5\u0003%!'o\u001c9UC\ndW\rF\u0003\u0000\u0005W\u0012i\u0007\u0003\u0005\u0002\u0018\t\u0015\u0004\u0019AA%\u0011!\tYH!\u001aA\u0002\u0005-\u0004b\u0002B9\u0001\u0011\u0005!1O\u0001\u000fY>|7.\u001e9SK2\fG/[8o)\u0015\t'Q\u000fB<\u0011!\t9Ba\u001cA\u0002\u0005%\u0003B\u0003B=\u0005_\u0002\n\u00111\u0001\u0003|\u0005)\u0011\r\\5bgB!\u0011#!@[\u0011\u001d\u0011y\b\u0001C\u0001\u0005\u0003\u000b1\u0002^1cY\u0016,\u00050[:ugR!\u00111\u000eBB\u0011!\t9B! A\u0002\u0005%\u0003b\u0002BD\u0001\u0011\u0005!\u0011R\u0001\u0011SN$V-\u001c9pe\u0006\u0014\u0018\u0010V1cY\u0016$B!a\u001b\u0003\f\"A\u0011q\u0003BC\u0001\u0004\tI\u0005C\u0004\u0003\u0010\u0002!\tA!%\u0002\u00151L7\u000f\u001e+bE2,7\u000f\u0006\u0003\u0003\u0014\nU\u0005CBAQ\u0003c\u000bI\u0005C\u0004\u0002@\t5\u0005\u0019\u0001.\t\u000f\t=\u0005\u0001\"\u0001\u0003\u001aR1!1\u0013BN\u0005;Cq!a\u0010\u0003\u0018\u0002\u0007!\fC\u0004\u0002>\n]\u0005\u0019\u0001.\t\u000f\t\u0005\u0006\u0001\"\u0001\u0003$\u0006a!/\u001a4sKNDG+\u00192mKR\u0019qP!*\t\u0011\u0005]!q\u0014a\u0001\u0003\u0013BqA!+\u0001\t\u0003\u0011Y+A\bj]Z\fG.\u001b3bi\u0016$\u0016M\u00197f)\ry(Q\u0016\u0005\t\u0003/\u00119\u000b1\u0001\u0002J!9!\u0011\u0017\u0001\u0005\u0002\tM\u0016aD2mK\u0006\u0014H+Z7q)\u0006\u0014G.Z:\u0015\u0003}D\u0001Ba.\u0001\t\u0003\u0011!\u0011X\u0001\rO\u0016$H+Z7q)\u0006\u0014G.\u001a\u000b\u0005\u0005w\u0013i\f\u0005\u0003\u0012\u0003{\f\u0007bBA\f\u0005k\u0003\rA\u0017\u0005\b\u0005\u0003\u0004A\u0011\u0001Bb\u0003A\u0019'/Z1uKB\u000b'\u000f^5uS>t7\u000fF\u0004\u0000\u0005\u000b\u0014IM!6\t\u0011\t\u001d'q\u0018a\u0001\u0003\u0013\n\u0011\u0002^1cY\u0016t\u0015-\\3\t\u0011\t-'q\u0018a\u0001\u0005\u001b\fQ\u0001]1siN\u0004b!!)\u00022\n=\u0007cA\u0010\u0003R&\u0019!1\u001b\u0002\u0003+\r\u000bG/\u00197pOR\u000b'\r\\3QCJ$\u0018\u000e^5p]\"A\u0011\u0011\u000eB`\u0001\u0004\tY\u0007C\u0004\u0003Z\u0002!\tAa7\u0002\u001d\u0011\u0014x\u000e\u001d)beRLG/[8ogR9qP!8\u0003`\n\u0015\b\u0002\u0003Bd\u0005/\u0004\r!!\u0013\t\u0011\t\u0005(q\u001ba\u0001\u0005G\fQa\u001d9fGN\u0004b!!)\u00022\n\u0015\u0002\u0002CA>\u0005/\u0004\r!a\u001b\t\u000f\t%\b\u0001\"\u0001\u0003l\u0006\u0001\"/\u001a8b[\u0016\u0004\u0016M\u001d;ji&|gn\u001d\u000b\b\u007f\n5(q\u001eBy\u0011!\u00119Ma:A\u0002\u0005%\u0003\u0002\u0003Bq\u0005O\u0004\rAa9\t\u0011\tM(q\u001da\u0001\u0005G\f\u0001B\\3x'B,7m\u001d\u0005\b\u0005o\u0004A\u0011\u0001B}\u0003=\tG\u000e^3s!\u0006\u0014H/\u001b;j_:\u001cH#B@\u0003|\nu\b\u0002\u0003Bd\u0005k\u0004\r!!\u0013\t\u0011\t-'Q\u001fa\u0001\u0005\u001bDqa!\u0001\u0001\t\u0003\u0019\u0019!\u0001\u0007hKR\u0004\u0016M\u001d;ji&|g\u000e\u0006\u0004\u0003P\u000e\u00151q\u0001\u0005\t\u0005\u000f\u0014y\u00101\u0001\u0002J!A1\u0011\u0002B\u0000\u0001\u0004\u0011)#\u0001\u0003ta\u0016\u001c\u0007bBB\u0007\u0001\u0011\u00051qB\u0001\u000fY&\u001cH\u000fU1si&$\u0018n\u001c8t)\u0019\u0011im!\u0005\u0004\u0014!A!qYB\u0006\u0001\u0004\tI\u0005\u0003\u0006\u0004\u0016\r-\u0001\u0013!a\u0001\u0007/\t1\u0002]1si&\fGn\u00159fGB)\u0011#!@\u0003&!911\u0004\u0001\u0005\n\ru\u0011\u0001\t:fcVL'/Z#yC\u000e$X*\u0019;dQ\u0016$\u0007+\u0019:uSRLwN\\*qK\u000e$Ra`B\u0010\u0007CA\u0001B!9\u0004\u001a\u0001\u0007!1\u001d\u0005\t\u0007G\u0019I\u00021\u0001\u0002^\u0006)A/\u00192mK\"91q\u0005\u0001\u0005\n\r%\u0012A\t:fcVL'/\u001a)beRL\u0017\r\\'bi\u000eDW\r\u001a)beRLG/[8o'B,7\rF\u0003\u0000\u0007W\u0019i\u0003\u0003\u0005\u0003b\u000e\u0015\u0002\u0019\u0001Br\u0011!\u0019\u0019c!\nA\u0002\u0005u\u0007bBB\u0019\u0001\u0011\u000511G\u0001\u000fGJ,\u0017\r^3Gk:\u001cG/[8o)\u0015y8QGB \u0011!\u00199da\fA\u0002\re\u0012A\u00044v]\u000e$UMZ5oSRLwN\u001c\t\u0004?\rm\u0012bAB\u001f\u0005\ty1)\u0019;bY><g)\u001e8di&|g\u000e\u0003\u0005\u0002j\r=\u0002\u0019AA6\u0011\u001d\u0019\u0019\u0005\u0001C\u0001\u0007\u000b\nA\u0002\u001a:pa\u001a+hn\u0019;j_:$Ra`B$\u0007\u001fB\u0001\"a\u0006\u0004B\u0001\u00071\u0011\n\t\u0004e\r-\u0013bAB'\t\t\u0011b)\u001e8di&|g.\u00133f]RLg-[3s\u0011!\tYh!\u0011A\u0002\u0005-\u0004bBB*\u0001\u0011\u00051QK\u0001\u0014O\u0016$h)\u001e8di&|g.T3uC\u0012\fG/\u0019\u000b\u0005\u0007s\u00199\u0006\u0003\u0005\u0002\u0018\rE\u0003\u0019AB%\u0011\u001d\u0019Y\u0006\u0001C\u0001\u0007;\naBZ;oGRLwN\\#ySN$8\u000f\u0006\u0003\u0002l\r}\u0003\u0002CA\f\u00073\u0002\ra!\u0013\t\u0011\r\r\u0004\u0001\"\u0001\u0007\u0007K\n1#\\1lK\u001a+hn\u0019;j_:\u0014U/\u001b7eKJ$baa\u001a\u0004\u000e\u000e=\u0005\u0003BB5\u0007\u000fsAaa\u001b\u0004\u0004:!1QNBA\u001d\u0011\u0019yga \u000f\t\rE4Q\u0010\b\u0005\u0007g\u001aYH\u0004\u0003\u0004v\red\u0002BAS\u0007oJ\u0011!D\u0005\u0003\u00171I!!\u0003\u0006\n\u0005\u001dA\u0011BA\u0003\u0007\u0013\taC!C\u0002\u0004\u0006.\n\u0001CR;oGRLwN\u001c*fO&\u001cHO]=\n\t\r%51\u0012\u0002\u0010\rVt7\r^5p]\n+\u0018\u000e\u001c3fe*\u00191QQ\u0016\t\u000f\u0005]1\u0011\ra\u00015\"91\u0011SB1\u0001\u0004Q\u0016!\u00054v]\u000e$\u0018n\u001c8DY\u0006\u001c8OT1nK\"91Q\u0013\u0001\u0005\u0002\r]\u0015!\u00067pC\u00124UO\\2uS>t'+Z:pkJ\u001cWm\u001d\u000b\u0004\u007f\u000ee\u0005\u0002CBN\u0007'\u0003\ra!(\u0002\u0013I,7o\\;sG\u0016\u001c\bCBAQ\u0003c\u001by\nE\u0002 \u0007CK1aa)\u0003\u0005A1UO\\2uS>t'+Z:pkJ\u001cW\rC\u0004\u0004(\u0002!\ta!+\u0002%\r\u0014X-\u0019;f)\u0016l\u0007OR;oGRLwN\u001c\u000b\n\u007f\u000e-6QVB_\u0007\u007fCq!a\u0006\u0004&\u0002\u0007!\f\u0003\u0005\u00040\u000e\u0015\u0006\u0019ABY\u0003\u0011IgNZ8\u0011\t\rM6\u0011X\u0007\u0003\u0007kS1aa.\u0005\u0003-)\u0007\u0010\u001d:fgNLwN\\:\n\t\rm6Q\u0017\u0002\u000f\u000bb\u0004(/Z:tS>t\u0017J\u001c4p\u0011!\u00199d!*A\u0002\r\u001d\u0004\u0002CA5\u0007K\u0003\r!a\u001b\t\u000f\r\r\u0007\u0001\"\u0001\u0004F\u0006\u0001BM]8q)\u0016l\u0007OR;oGRLwN\u001c\u000b\u0006\u007f\u000e\u001d7\u0011\u001a\u0005\b\u0003/\u0019\t\r1\u0001[\u0011!\tYh!1A\u0002\u0005-\u0004bBBg\u0001\u0011E1qZ\u0001\u0013M\u0006LGNR;oGRLwN\u001c'p_.,\b\u000f\u0006\u0003\u0004R\u000e]\u0007cA\t\u0004T&\u00191Q\u001b\n\u0003\u000f9{G\u000f[5oO\"9\u0011qCBf\u0001\u0004Q\u0006\u0002CBn\u0001\u0011\u0005\u0001b!8\u0002%1|wn[;q\rVt7\r^5p]&sgm\u001c\u000b\u0005\u0007c\u001by\u000e\u0003\u0005\u0002\u0018\re\u0007\u0019AB%\u0011\u001d\u0019\u0019\u000f\u0001C\u0001\u0007K\fa\u0002\\8pWV\u0004h)\u001e8di&|g\u000e\u0006\u0004\u0004h\u000e58q\u001e\t\u0005\u0007g\u001bI/\u0003\u0003\u0004l\u000eU&AC#yaJ,7o]5p]\"A\u0011qCBq\u0001\u0004\u0019I\u0005\u0003\u0005\u0004r\u000e\u0005\b\u0019ABz\u0003!\u0019\u0007.\u001b7ee\u0016t\u0007CBAQ\u0003c\u001b9\u000fC\u0004\u0004x\u0002!\ta!?\u0002\u001b1L7\u000f\u001e$v]\u000e$\u0018n\u001c8t)\u0011\u0019Yp!@\u0011\r\u0005\u0005\u0016\u0011WB%\u0011\u001d\tyd!>A\u0002iCqaa>\u0001\t\u0003!\t\u0001\u0006\u0004\u0004|\u0012\rAQ\u0001\u0005\b\u0003\u007f\u0019y\u00101\u0001[\u0011\u001d\tila@A\u0002iC\u0001\u0002\"\u0003\u0001\t\u00031!1W\u0001\u0006e\u0016\u001cX\r\u001e\u0005\n\t\u001b\u0001\u0011\u0013!C\u0001\t\u001f\t\u0001\u0004\\8pWV\u0004(+\u001a7bi&|g\u000e\n3fM\u0006,H\u000e\u001e\u00133+\t!\tB\u000b\u0003\u0003|\u0011M1F\u0001C\u000b!\u0011!9\u0002b\b\u000e\u0005\u0011e!\u0002\u0002C\u000e\t;\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005E\u0014\u0012\u0002\u0002C\u0011\t3\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011%!)\u0003AI\u0001\n\u0003!9#\u0001\rmSN$\b+\u0019:uSRLwN\\:%I\u00164\u0017-\u001e7uII*\"\u0001\"\u000b+\t\r]A1\u0003")
public class SessionCatalog
implements Logging {
    public final ExternalCatalog org$apache$spark$sql$catalyst$catalog$SessionCatalog$$externalCatalog;
    public final FunctionResourceLoader org$apache$spark$sql$catalyst$catalog$SessionCatalog$$functionResourceLoader;
    public final FunctionRegistry org$apache$spark$sql$catalyst$catalog$SessionCatalog$$functionRegistry;
    private final CatalystConf conf;
    private final Configuration hadoopConf;
    @GuardedBy(value="this")
    private final HashMap<String, LogicalPlan> tempTables;
    @GuardedBy(value="this")
    private String currentDb;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public HashMap<String, LogicalPlan> tempTables() {
        return this.tempTables;
    }

    public String currentDb() {
        return this.currentDb;
    }

    public void currentDb_$eq(String x$1) {
        this.currentDb = x$1;
    }

    public String formatTableName(String name2) {
        return this.conf.caseSensitiveAnalysis() ? name2 : name2.toLowerCase();
    }

    public String formatDatabaseName(String name2) {
        return this.conf.caseSensitiveAnalysis() ? name2 : name2.toLowerCase();
    }

    private Path makeQualifiedPath(String path) {
        Path hadoopPath = new Path(path);
        FileSystem fs = hadoopPath.getFileSystem(this.hadoopConf);
        return fs.makeQualified(hadoopPath);
    }

    public void requireDbExists(String db) {
        if (this.databaseExists(db)) {
            return;
        }
        throw new NoSuchDatabaseException(db);
    }

    public void requireTableExists(TableIdentifier name2) {
        if (this.tableExists(name2)) {
            return;
        }
        String db = (String)name2.database().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalog $outer;

            public final String apply() {
                return this.$outer.currentDb();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        throw new NoSuchTableException(db, name2.table());
    }

    private void requireTableNotExists(TableIdentifier name2) {
        if (this.tableExists(name2)) {
            String db = (String)name2.database().getOrElse((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ SessionCatalog $outer;

                public final String apply() {
                    return this.$outer.currentDb();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            throw new TableAlreadyExistsException(db, name2.table());
        }
    }

    public void createDatabase(CatalogDatabase dbDefinition, boolean ignoreIfExists) {
        String dbName;
        String qualifiedPath = this.makeQualifiedPath(dbDefinition.locationUri()).toString();
        String x$4 = dbName = this.formatDatabaseName(dbDefinition.name());
        String x$5 = qualifiedPath;
        String x$6 = dbDefinition.copy$default$2();
        Map<String, String> x$7 = dbDefinition.copy$default$4();
        this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$externalCatalog.createDatabase(dbDefinition.copy(x$4, x$6, x$5, x$7), ignoreIfExists);
    }

    public void dropDatabase(String db, boolean ignoreIfNotExists, boolean cascade) {
        String dbName;
        String string = dbName = this.formatDatabaseName(db);
        String string2 = "default";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Can not drop default database"})).s((Seq)Nil$.MODULE$), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4());
        }
        this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$externalCatalog.dropDatabase(dbName, ignoreIfNotExists, cascade);
    }

    public void alterDatabase(CatalogDatabase dbDefinition) {
        String dbName = this.formatDatabaseName(dbDefinition.name());
        this.requireDbExists(dbName);
        this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$externalCatalog.alterDatabase(dbDefinition.copy(dbName, dbDefinition.copy$default$2(), dbDefinition.copy$default$3(), dbDefinition.copy$default$4()));
    }

    public CatalogDatabase getDatabaseMetadata(String db) {
        String dbName = this.formatDatabaseName(db);
        this.requireDbExists(dbName);
        return this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$externalCatalog.getDatabase(dbName);
    }

    public boolean databaseExists(String db) {
        String dbName = this.formatDatabaseName(db);
        return this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$externalCatalog.databaseExists(dbName);
    }

    public Seq<String> listDatabases() {
        return this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$externalCatalog.listDatabases();
    }

    public Seq<String> listDatabases(String pattern) {
        return this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$externalCatalog.listDatabases(pattern);
    }

    public synchronized String getCurrentDatabase() {
        return this.currentDb();
    }

    public void setCurrentDatabase(String db) {
        String dbName = this.formatDatabaseName(db);
        this.requireDbExists(dbName);
        SessionCatalog sessionCatalog = this;
        synchronized (sessionCatalog) {
            this.currentDb_$eq(dbName);
            return;
        }
    }

    public String getDefaultDBPath(String db) {
        String database2 = this.formatDatabaseName(db);
        return new Path(new Path(this.conf.warehousePath()), new StringBuilder().append((Object)database2).append((Object)".db").toString()).toString();
    }

    public void createTable(CatalogTable tableDefinition, boolean ignoreIfExists) {
        String db = this.formatDatabaseName((String)tableDefinition.identifier().database().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalog $outer;

            public final String apply() {
                return this.$outer.getCurrentDatabase();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }));
        String table = this.formatTableName(tableDefinition.identifier().table());
        CatalogTable newTableDefinition = tableDefinition.copy(new TableIdentifier(table, (Option<String>)new Some((Object)db)), tableDefinition.copy$default$2(), tableDefinition.copy$default$3(), tableDefinition.copy$default$4(), tableDefinition.copy$default$5(), tableDefinition.copy$default$6(), tableDefinition.copy$default$7(), tableDefinition.copy$default$8(), tableDefinition.copy$default$9(), tableDefinition.copy$default$10(), tableDefinition.copy$default$11(), tableDefinition.copy$default$12(), tableDefinition.copy$default$13(), tableDefinition.copy$default$14(), tableDefinition.copy$default$15(), tableDefinition.copy$default$16());
        this.requireDbExists(db);
        this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$externalCatalog.createTable(db, newTableDefinition, ignoreIfExists);
    }

    public void alterTable(CatalogTable tableDefinition) {
        String db = this.formatDatabaseName((String)tableDefinition.identifier().database().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalog $outer;

            public final String apply() {
                return this.$outer.getCurrentDatabase();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }));
        String table = this.formatTableName(tableDefinition.identifier().table());
        TableIdentifier tableIdentifier = new TableIdentifier(table, (Option<String>)new Some((Object)db));
        CatalogTable newTableDefinition = tableDefinition.copy(tableIdentifier, tableDefinition.copy$default$2(), tableDefinition.copy$default$3(), tableDefinition.copy$default$4(), tableDefinition.copy$default$5(), tableDefinition.copy$default$6(), tableDefinition.copy$default$7(), tableDefinition.copy$default$8(), tableDefinition.copy$default$9(), tableDefinition.copy$default$10(), tableDefinition.copy$default$11(), tableDefinition.copy$default$12(), tableDefinition.copy$default$13(), tableDefinition.copy$default$14(), tableDefinition.copy$default$15(), tableDefinition.copy$default$16());
        this.requireDbExists(db);
        this.requireTableExists(tableIdentifier);
        this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$externalCatalog.alterTable(db, newTableDefinition);
    }

    public CatalogTable getTableMetadata(TableIdentifier name2) {
        String db = this.formatDatabaseName((String)name2.database().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalog $outer;

            public final String apply() {
                return this.$outer.getCurrentDatabase();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }));
        String table = this.formatTableName(name2.table());
        this.requireDbExists(db);
        this.requireTableExists(new TableIdentifier(table, (Option<String>)new Some((Object)db)));
        return this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$externalCatalog.getTable(db, table);
    }

    public Option<CatalogTable> getTableMetadataOption(TableIdentifier name2) {
        String db = this.formatDatabaseName((String)name2.database().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalog $outer;

            public final String apply() {
                return this.$outer.getCurrentDatabase();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }));
        String table = this.formatTableName(name2.table());
        this.requireDbExists(db);
        return this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$externalCatalog.getTableOption(db, table);
    }

    public void loadTable(TableIdentifier name2, String loadPath, boolean isOverwrite, boolean holdDDLTime) {
        String db = this.formatDatabaseName((String)name2.database().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalog $outer;

            public final String apply() {
                return this.$outer.getCurrentDatabase();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }));
        String table = this.formatTableName(name2.table());
        this.requireDbExists(db);
        this.requireTableExists(new TableIdentifier(table, (Option<String>)new Some((Object)db)));
        this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$externalCatalog.loadTable(db, table, loadPath, isOverwrite, holdDDLTime);
    }

    public void loadPartition(TableIdentifier name2, String loadPath, Map<String, String> partition, boolean isOverwrite, boolean holdDDLTime, boolean inheritTableSpecs, boolean isSkewedStoreAsSubdir) {
        String db = this.formatDatabaseName((String)name2.database().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalog $outer;

            public final String apply() {
                return this.$outer.getCurrentDatabase();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }));
        String table = this.formatTableName(name2.table());
        this.requireDbExists(db);
        this.requireTableExists(new TableIdentifier(table, (Option<String>)new Some((Object)db)));
        this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$externalCatalog.loadPartition(db, table, loadPath, partition, isOverwrite, holdDDLTime, inheritTableSpecs, isSkewedStoreAsSubdir);
    }

    public String defaultTablePath(TableIdentifier tableIdent) {
        String dbName = this.formatDatabaseName((String)tableIdent.database().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalog $outer;

            public final String apply() {
                return this.$outer.getCurrentDatabase();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }));
        String dbLocation = this.getDatabaseMetadata(dbName).locationUri();
        return new Path(new Path(dbLocation), this.formatTableName(tableIdent.table())).toString();
    }

    public void createTempView(String name2, LogicalPlan tableDefinition, boolean overrideIfExists) {
        SessionCatalog sessionCatalog = this;
        synchronized (sessionCatalog) {
            String table = this.formatTableName(name2);
            if (this.tempTables().contains((Object)table) && !overrideIfExists) {
                throw new TempTableAlreadyExistsException(name2);
            }
            this.tempTables().put((Object)table, (Object)tableDefinition);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void renameTable(TableIdentifier oldName, TableIdentifier newName) {
        SessionCatalog sessionCatalog = this;
        synchronized (sessionCatalog) {
            void var5_5;
            void var4_4;
            String db = this.formatDatabaseName((String)oldName.database().getOrElse((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ SessionCatalog $outer;

                public final String apply() {
                    return this.$outer.currentDb();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }));
            this.requireDbExists(db);
            String newDb = this.formatDatabaseName((String)newName.database().getOrElse((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ SessionCatalog $outer;

                public final String apply() {
                    return this.$outer.currentDb();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }));
            String string = db;
            String string2 = newDb;
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                BoxedUnit boxedUnit;
                String oldTableName = this.formatTableName(oldName.table());
                String newTableName = this.formatTableName(newName.table());
                if (!oldName.database().isDefined() && this.tempTables().contains((Object)oldTableName)) {
                    if (newName.database().isDefined()) {
                        throw new AnalysisException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"RENAME TEMPORARY TABLE from '", "' to '", "': cannot specify database "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{oldName, newName}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"name '", "' in the destination table"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{newName.database().get()}))).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4());
                    }
                    if (this.tempTables().contains((Object)newTableName)) {
                        throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"RENAME TEMPORARY TABLE from '", "' to '", "': destination table already exists"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{oldName, newName})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4());
                    }
                    LogicalPlan table = (LogicalPlan)this.tempTables().apply((Object)oldTableName);
                    this.tempTables().remove((Object)oldTableName);
                    boxedUnit = this.tempTables().put((Object)newTableName, (Object)table);
                } else {
                    this.requireTableExists(new TableIdentifier(oldTableName, (Option<String>)new Some((Object)db)));
                    this.requireTableNotExists(new TableIdentifier(newTableName, (Option<String>)new Some((Object)db)));
                    this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$externalCatalog.renameTable(db, oldTableName, newTableName);
                    boxedUnit = BoxedUnit.UNIT;
                }
                return;
            }
            throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"RENAME TABLE source and destination databases do not match: '", "' != '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var4_4, var5_5})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4());
        }
    }

    /*
     * WARNING - void declaration
     */
    public void dropTable(TableIdentifier name2, boolean ignoreIfNotExists) {
        SessionCatalog sessionCatalog = this;
        synchronized (sessionCatalog) {
            void var5_5;
            void var4_4;
            block8: {
                block6: {
                    Option option;
                    block7: {
                        String table;
                        String db;
                        block5: {
                            db = this.formatDatabaseName((String)name2.database().getOrElse((Function0)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ SessionCatalog $outer;

                                public final String apply() {
                                    return this.$outer.currentDb();
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            }));
                            table = this.formatTableName(name2.table());
                            if (name2.database().isDefined() || !this.tempTables().contains((Object)table)) break block5;
                            option = this.tempTables().remove((Object)table);
                            break block6;
                        }
                        this.requireDbExists(db);
                        if (!this.tableExists(new TableIdentifier(table, (Option<String>)Option$.MODULE$.apply((Object)db)))) break block7;
                        this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$externalCatalog.dropTable(db, table, true);
                        option = BoxedUnit.UNIT;
                        break block6;
                    }
                    if (!ignoreIfNotExists) break block8;
                    option = BoxedUnit.UNIT;
                }
                return;
            }
            throw new NoSuchTableException((String)var4_4, (String)var5_5);
        }
    }

    public synchronized LogicalPlan lookupRelation(TableIdentifier name2, Option<String> alias) {
        LogicalPlan logicalPlan;
        String db = this.formatDatabaseName((String)name2.database().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalog $outer;

            public final String apply() {
                return this.$outer.currentDb();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }));
        String table = this.formatTableName(name2.table());
        if (!name2.database().isDefined() && this.tempTables().contains((Object)table)) {
            logicalPlan = (LogicalPlan)this.tempTables().apply((Object)table);
        } else {
            CatalogTable metadata2 = this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$externalCatalog.getTable(db, table);
            logicalPlan = new SimpleCatalogRelation(db, metadata2, alias);
        }
        LogicalPlan relation = logicalPlan;
        SubqueryAlias qualifiedTable = new SubqueryAlias(table, relation);
        return (LogicalPlan)alias.map((Function1)new Serializable(this, qualifiedTable){
            public static final long serialVersionUID = 0L;
            private final SubqueryAlias qualifiedTable$1;

            public final SubqueryAlias apply(String a) {
                return new SubqueryAlias(a, this.qualifiedTable$1);
            }
            {
                this.qualifiedTable$1 = qualifiedTable$1;
            }
        }).getOrElse((Function0)new Serializable(this, qualifiedTable){
            public static final long serialVersionUID = 0L;
            private final SubqueryAlias qualifiedTable$1;

            public final SubqueryAlias apply() {
                return this.qualifiedTable$1;
            }
            {
                this.qualifiedTable$1 = qualifiedTable$1;
            }
        });
    }

    public Option<String> lookupRelation$default$2() {
        return None$.MODULE$;
    }

    public synchronized boolean tableExists(TableIdentifier name2) {
        String db = this.formatDatabaseName((String)name2.database().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalog $outer;

            public final String apply() {
                return this.$outer.currentDb();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }));
        String table = this.formatTableName(name2.table());
        return !name2.database().isDefined() && this.tempTables().contains((Object)table) ? true : this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$externalCatalog.tableExists(db, table);
    }

    public synchronized boolean isTemporaryTable(TableIdentifier name2) {
        return name2.database().isEmpty() && this.tempTables().contains((Object)this.formatTableName(name2.table()));
    }

    public Seq<TableIdentifier> listTables(String db) {
        return this.listTables(this.formatDatabaseName(db), "*");
    }

    public Seq<TableIdentifier> listTables(String db, String pattern) {
        String dbName = this.formatDatabaseName(db);
        this.requireDbExists(dbName);
        Seq dbTables = (Seq)this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$externalCatalog.listTables(dbName, pattern).map((Function1)new Serializable(this, dbName){
            public static final long serialVersionUID = 0L;
            private final String dbName$1;

            public final TableIdentifier apply(String t) {
                return new TableIdentifier(t, (Option<String>)new Some((Object)this.dbName$1));
            }
            {
                this.dbName$1 = dbName$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        SessionCatalog sessionCatalog = this;
        synchronized (sessionCatalog) {
            Seq _tempTables = (Seq)StringUtils$.MODULE$.filterPattern((Seq<String>)this.tempTables().keys().toSeq(), pattern).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final TableIdentifier apply(String t) {
                    return TableIdentifier$.MODULE$.apply(t);
                }
            }, Seq$.MODULE$.canBuildFrom());
            Object object = dbTables.$plus$plus((GenTraversableOnce)_tempTables, Seq$.MODULE$.canBuildFrom());
            return (Seq)object;
        }
    }

    public void refreshTable(TableIdentifier name2) {
    }

    public void invalidateTable(TableIdentifier name2) {
    }

    public synchronized void clearTempTables() {
        this.tempTables().clear();
    }

    public synchronized Option<LogicalPlan> getTempTable(String name2) {
        return this.tempTables().get((Object)name2);
    }

    public void createPartitions(TableIdentifier tableName, Seq<CatalogTablePartition> parts, boolean ignoreIfExists) {
        this.requireExactMatchedPartitionSpec((Seq<Map<String, String>>)((Seq)parts.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Map<String, String> apply(CatalogTablePartition x$1) {
                return x$1.spec();
            }
        }, Seq$.MODULE$.canBuildFrom())), this.getTableMetadata(tableName));
        String db = this.formatDatabaseName((String)tableName.database().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalog $outer;

            public final String apply() {
                return this.$outer.getCurrentDatabase();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }));
        String table = this.formatTableName(tableName.table());
        this.requireDbExists(db);
        this.requireTableExists(new TableIdentifier(table, (Option<String>)Option$.MODULE$.apply((Object)db)));
        this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$externalCatalog.createPartitions(db, table, parts, ignoreIfExists);
    }

    public void dropPartitions(TableIdentifier tableName, Seq<Map<String, String>> specs, boolean ignoreIfNotExists) {
        this.requirePartialMatchedPartitionSpec(specs, this.getTableMetadata(tableName));
        String db = this.formatDatabaseName((String)tableName.database().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalog $outer;

            public final String apply() {
                return this.$outer.getCurrentDatabase();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }));
        String table = this.formatTableName(tableName.table());
        this.requireDbExists(db);
        this.requireTableExists(new TableIdentifier(table, (Option<String>)Option$.MODULE$.apply((Object)db)));
        this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$externalCatalog.dropPartitions(db, table, specs, ignoreIfNotExists);
    }

    public void renamePartitions(TableIdentifier tableName, Seq<Map<String, String>> specs, Seq<Map<String, String>> newSpecs) {
        CatalogTable tableMetadata = this.getTableMetadata(tableName);
        this.requireExactMatchedPartitionSpec(specs, tableMetadata);
        this.requireExactMatchedPartitionSpec(newSpecs, tableMetadata);
        String db = this.formatDatabaseName((String)tableName.database().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalog $outer;

            public final String apply() {
                return this.$outer.getCurrentDatabase();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }));
        String table = this.formatTableName(tableName.table());
        this.requireDbExists(db);
        this.requireTableExists(new TableIdentifier(table, (Option<String>)Option$.MODULE$.apply((Object)db)));
        this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$externalCatalog.renamePartitions(db, table, specs, newSpecs);
    }

    public void alterPartitions(TableIdentifier tableName, Seq<CatalogTablePartition> parts) {
        this.requireExactMatchedPartitionSpec((Seq<Map<String, String>>)((Seq)parts.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Map<String, String> apply(CatalogTablePartition x$2) {
                return x$2.spec();
            }
        }, Seq$.MODULE$.canBuildFrom())), this.getTableMetadata(tableName));
        String db = this.formatDatabaseName((String)tableName.database().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalog $outer;

            public final String apply() {
                return this.$outer.getCurrentDatabase();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }));
        String table = this.formatTableName(tableName.table());
        this.requireDbExists(db);
        this.requireTableExists(new TableIdentifier(table, (Option<String>)Option$.MODULE$.apply((Object)db)));
        this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$externalCatalog.alterPartitions(db, table, parts);
    }

    public CatalogTablePartition getPartition(TableIdentifier tableName, Map<String, String> spec) {
        this.requireExactMatchedPartitionSpec((Seq<Map<String, String>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{spec}))), this.getTableMetadata(tableName));
        String db = this.formatDatabaseName((String)tableName.database().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalog $outer;

            public final String apply() {
                return this.$outer.getCurrentDatabase();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }));
        String table = this.formatTableName(tableName.table());
        this.requireDbExists(db);
        this.requireTableExists(new TableIdentifier(table, (Option<String>)Option$.MODULE$.apply((Object)db)));
        return this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$externalCatalog.getPartition(db, table, spec);
    }

    public Seq<CatalogTablePartition> listPartitions(TableIdentifier tableName, Option<Map<String, String>> partialSpec) {
        String db = this.formatDatabaseName((String)tableName.database().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalog $outer;

            public final String apply() {
                return this.$outer.getCurrentDatabase();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }));
        String table = this.formatTableName(tableName.table());
        this.requireDbExists(db);
        this.requireTableExists(new TableIdentifier(table, (Option<String>)Option$.MODULE$.apply((Object)db)));
        return this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$externalCatalog.listPartitions(db, table, partialSpec);
    }

    public Option<Map<String, String>> listPartitions$default$2() {
        return None$.MODULE$;
    }

    private void requireExactMatchedPartitionSpec(Seq<Map<String, String>> specs, CatalogTable table) {
        Seq defined = (Seq)table.partitionColumnNames().sorted((Ordering)Ordering.String$.MODULE$);
        specs.foreach((Function1)new Serializable(this, table, defined){
            public static final long serialVersionUID = 0L;
            private final CatalogTable table$1;
            private final Seq defined$1;

            public final void apply(Map<String, String> s) {
                Object object = s.keys().toSeq().sorted((Ordering)Ordering.String$.MODULE$);
                Seq seq = this.defined$1;
                if (!(object != null ? !object.equals(seq) : seq != null)) {
                    return;
                }
                throw new AnalysisException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Partition spec is invalid. The spec (", ") must match "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{s.keys().mkString(", ")}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"the partition spec (", ") defined in "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.table$1.partitionColumnNames().mkString(", ")}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"table '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.table$1.identifier()}))).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4());
            }
            {
                this.table$1 = table$1;
                this.defined$1 = defined$1;
            }
        });
    }

    private void requirePartialMatchedPartitionSpec(Seq<Map<String, String>> specs, CatalogTable table) {
        Seq<String> defined = table.partitionColumnNames();
        specs.foreach((Function1)new Serializable(this, table, defined){
            public static final long serialVersionUID = 0L;
            private final CatalogTable table$2;
            public final Seq defined$2;

            public final void apply(Map<String, String> s) {
                if (s.keys().forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$requirePartialMatchedPartitionSpec$1 $outer;

                    public final boolean apply(Object elem) {
                        return this.$outer.defined$2.contains(elem);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                })) {
                    return;
                }
                throw new AnalysisException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Partition spec is invalid. The spec (", ") must be contained "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{s.keys().mkString(", ")}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"within the partition spec (", ") defined "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.table$2.partitionColumnNames().mkString(", ")}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"in table '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.table$2.identifier()}))).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4());
            }
            {
                this.table$2 = table$2;
                this.defined$2 = defined$2;
            }
        });
    }

    public void createFunction(CatalogFunction funcDefinition, boolean ignoreIfExists) {
        String db = this.formatDatabaseName((String)funcDefinition.identifier().database().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalog $outer;

            public final String apply() {
                return this.$outer.getCurrentDatabase();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }));
        this.requireDbExists(db);
        FunctionIdentifier identifier = new FunctionIdentifier(funcDefinition.identifier().funcName(), (Option<String>)new Some((Object)db));
        CatalogFunction newFuncDefinition = funcDefinition.copy(identifier, funcDefinition.copy$default$2(), funcDefinition.copy$default$3());
        if (this.functionExists(identifier)) {
            if (!ignoreIfExists) {
                throw new FunctionAlreadyExistsException(db, identifier.toString());
            }
        } else {
            this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$externalCatalog.createFunction(db, newFuncDefinition);
        }
    }

    public void dropFunction(FunctionIdentifier name2, boolean ignoreIfNotExists) {
        FunctionIdentifier identifier;
        String db;
        block4: {
            block3: {
                block2: {
                    db = this.formatDatabaseName((String)name2.database().getOrElse((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ SessionCatalog $outer;

                        public final String apply() {
                            return this.$outer.getCurrentDatabase();
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }));
                    this.requireDbExists(db);
                    Some x$8 = new Some((Object)db);
                    String x$9 = name2.copy$default$1();
                    identifier = name2.copy(x$9, (Option<String>)x$8);
                    if (!this.functionExists(identifier)) break block2;
                    Object object = this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$functionRegistry.functionExists(identifier.unquotedString()) ? BoxesRunTime.boxToBoolean((boolean)this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$functionRegistry.dropFunction(identifier.unquotedString())) : BoxedUnit.UNIT;
                    this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$externalCatalog.dropFunction(db, name2.funcName());
                    break block3;
                }
                if (!ignoreIfNotExists) break block4;
            }
            return;
        }
        throw new NoSuchFunctionException(db, identifier.toString());
    }

    public CatalogFunction getFunctionMetadata(FunctionIdentifier name2) {
        String db = this.formatDatabaseName((String)name2.database().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalog $outer;

            public final String apply() {
                return this.$outer.getCurrentDatabase();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }));
        this.requireDbExists(db);
        return this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$externalCatalog.getFunction(db, name2.funcName());
    }

    public boolean functionExists(FunctionIdentifier name2) {
        String db = this.formatDatabaseName((String)name2.database().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalog $outer;

            public final String apply() {
                return this.$outer.getCurrentDatabase();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }));
        this.requireDbExists(db);
        return this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$functionRegistry.functionExists(name2.unquotedString()) || this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$externalCatalog.functionExists(db, name2.funcName());
    }

    public Function1<Seq<Expression>, Expression> makeFunctionBuilder(String name2, String functionClassName) {
        throw new UnsupportedOperationException("Use sqlContext.udf.register(...) instead.");
    }

    public void loadFunctionResources(Seq<FunctionResource> resources) {
        resources.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalog $outer;

            public final void apply(FunctionResource resource) {
                this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$functionResourceLoader.loadResource(resource);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void createTempFunction(String name2, ExpressionInfo info, Function1<Seq<Expression>, Expression> funcDefinition, boolean ignoreIfExists) {
        if (this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$functionRegistry.lookupFunctionBuilder(name2).isDefined() && !ignoreIfExists) {
            throw new TempFunctionAlreadyExistsException(name2);
        }
        this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$functionRegistry.registerFunction(name2, info, funcDefinition);
    }

    public void dropTempFunction(String name2, boolean ignoreIfNotExists) {
        if (this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$functionRegistry.dropFunction(name2) || ignoreIfNotExists) {
            return;
        }
        throw new NoSuchTempFunctionException(name2);
    }

    public Nothing$ failFunctionLookup(String name2) {
        throw new NoSuchFunctionException(this.currentDb(), name2);
    }

    public synchronized ExpressionInfo lookupFunctionInfo(FunctionIdentifier name2) {
        Option database2;
        Option x$10 = database2 = name2.database().orElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalog $outer;

            public final Some<String> apply() {
                return new Some((Object)this.$outer.currentDb());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalog $outer;

            public final String apply(String name2) {
                return this.$outer.formatDatabaseName(name2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        String x$11 = name2.copy$default$1();
        FunctionIdentifier qualifiedName = name2.copy(x$11, (Option<String>)x$10);
        return (ExpressionInfo)this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$functionRegistry.lookupFunction(name2.funcName()).orElse((Function0)new Serializable(this, qualifiedName){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalog $outer;
            private final FunctionIdentifier qualifiedName$1;

            public final Option<ExpressionInfo> apply() {
                return this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$functionRegistry.lookupFunction(this.qualifiedName$1.unquotedString());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.qualifiedName$1 = qualifiedName$1;
            }
        }).getOrElse((Function0)new Serializable(this, name2, qualifiedName){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalog $outer;
            private final FunctionIdentifier name$1;
            private final FunctionIdentifier qualifiedName$1;

            public final ExpressionInfo apply() {
                String db = (String)this.qualifiedName$1.database().get();
                this.$outer.requireDbExists(db);
                if (this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$externalCatalog.functionExists(db, this.name$1.funcName())) {
                    CatalogFunction metadata2 = this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$externalCatalog.getFunction(db, this.name$1.funcName());
                    return new ExpressionInfo(metadata2.className(), this.qualifiedName$1.unquotedString());
                }
                throw this.$outer.failFunctionLookup(this.name$1.funcName());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.name$1 = name$1;
                this.qualifiedName$1 = qualifiedName$1;
            }
        });
    }

    public synchronized Expression lookupFunction(FunctionIdentifier name2, Seq<Expression> children2) {
        Option database2;
        if (name2.database().isEmpty() && this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$functionRegistry.functionExists(name2.funcName())) {
            return this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$functionRegistry.lookupFunction(name2.funcName(), children2);
        }
        Option x$12 = database2 = name2.database().orElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalog $outer;

            public final Some<String> apply() {
                return new Some((Object)this.$outer.currentDb());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalog $outer;

            public final String apply(String name2) {
                return this.$outer.formatDatabaseName(name2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        String x$13 = name2.copy$default$1();
        FunctionIdentifier qualifiedName = name2.copy(x$13, (Option<String>)x$12);
        if (this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$functionRegistry.functionExists(qualifiedName.unquotedString())) {
            return this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$functionRegistry.lookupFunction(qualifiedName.unquotedString(), children2);
        }
        try {
            CatalogFunction catalogFunction = this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$externalCatalog.getFunction(this.currentDb(), name2.funcName());
            this.loadFunctionResources(catalogFunction.resources());
            ExpressionInfo info = new ExpressionInfo(catalogFunction.className(), qualifiedName.unquotedString());
            Function1<Seq<Expression>, Expression> builder = this.makeFunctionBuilder(qualifiedName.unquotedString(), catalogFunction.className());
            this.createTempFunction(qualifiedName.unquotedString(), info, builder, false);
        }
        catch (NoSuchPermanentFunctionException noSuchPermanentFunctionException) {
            throw this.failFunctionLookup(name2.funcName());
        }
        catch (AnalysisException analysisException) {
            throw this.failFunctionLookup(name2.funcName());
        }
        return this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$functionRegistry.lookupFunction(qualifiedName.unquotedString(), children2);
    }

    public Seq<FunctionIdentifier> listFunctions(String db) {
        return this.listFunctions(db, "*");
    }

    public Seq<FunctionIdentifier> listFunctions(String db, String pattern) {
        String dbName = this.formatDatabaseName(db);
        this.requireDbExists(dbName);
        Seq dbFunctions = (Seq)this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$externalCatalog.listFunctions(dbName, pattern).map((Function1)new Serializable(this, dbName){
            public static final long serialVersionUID = 0L;
            private final String dbName$2;

            public final FunctionIdentifier apply(String f) {
                return new FunctionIdentifier(f, (Option<String>)new Some((Object)this.dbName$2));
            }
            {
                this.dbName$2 = dbName$2;
            }
        }, Seq$.MODULE$.canBuildFrom());
        Seq loadedFunctions = (Seq)StringUtils$.MODULE$.filterPattern(this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$functionRegistry.listFunction(), pattern).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final FunctionIdentifier apply(String f) {
                return FunctionIdentifier$.MODULE$.apply(f);
            }
        }, Seq$.MODULE$.canBuildFrom());
        return (Seq)dbFunctions.$plus$plus((GenTraversableOnce)loadedFunctions, Seq$.MODULE$.canBuildFrom());
    }

    public synchronized void reset() {
        String string = "default";
        ((IterableLike)this.listDatabases().filter((Function1)new Serializable(this, string){
            public static final long serialVersionUID = 0L;
            private final String default$1;

            public final boolean apply(String x$3) {
                String string = x$3;
                String string2 = this.default$1;
                return string != null ? !string.equals(string2) : string2 != null;
            }
            {
                this.default$1 = default$1;
            }
        })).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalog $outer;

            public final void apply(String db) {
                this.$outer.dropDatabase(db, false, true);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.listTables(string).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalog $outer;

            public final void apply(TableIdentifier table) {
                this.$outer.dropTable(table, false);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.listFunctions(string).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalog $outer;

            public final void apply(FunctionIdentifier func) {
                if (func.database().isDefined()) {
                    this.$outer.dropFunction(func, false);
                } else {
                    this.$outer.dropTempFunction(func.funcName(), false);
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.tempTables().clear();
        this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$functionRegistry.clear();
        FunctionRegistry$.MODULE$.builtin().listFunction().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalog $outer;

            public final void apply(String f) {
                Option<ExpressionInfo> expressionInfo = FunctionRegistry$.MODULE$.builtin().lookupFunction(f);
                Option<Function1<Seq<Expression>, Expression>> functionBuilder = FunctionRegistry$.MODULE$.builtin().lookupFunctionBuilder(f);
                Predef$.MODULE$.require(expressionInfo.isDefined(), (Function0)new Serializable(this, f){
                    public static final long serialVersionUID = 0L;
                    private final String f$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"built-in function '", "' is missing expression info"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.f$1}));
                    }
                    {
                        this.f$1 = f$1;
                    }
                });
                Predef$.MODULE$.require(functionBuilder.isDefined(), (Function0)new Serializable(this, f){
                    public static final long serialVersionUID = 0L;
                    private final String f$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"built-in function '", "' is missing function builder"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.f$1}));
                    }
                    {
                        this.f$1 = f$1;
                    }
                });
                this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$functionRegistry.registerFunction(f, (ExpressionInfo)expressionInfo.get(), (Function1<Seq<Expression>, Expression>)((Function1)functionBuilder.get()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.setCurrentDatabase(string);
    }

    public SessionCatalog(ExternalCatalog externalCatalog, FunctionResourceLoader functionResourceLoader, FunctionRegistry functionRegistry, CatalystConf conf, Configuration hadoopConf) {
        this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$externalCatalog = externalCatalog;
        this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$functionResourceLoader = functionResourceLoader;
        this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$functionRegistry = functionRegistry;
        this.conf = conf;
        this.hadoopConf = hadoopConf;
        Logging.class.$init$((Logging)this);
        this.tempTables = new HashMap();
        String defaultName = "default";
        CatalogDatabase defaultDbDefinition = new CatalogDatabase(defaultName, "default database", conf.warehousePath(), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)));
        this.createDatabase(defaultDbDefinition, true);
        this.currentDb = this.formatDatabaseName(defaultName);
    }

    public SessionCatalog(ExternalCatalog externalCatalog, FunctionRegistry functionRegistry, CatalystConf conf) {
        this(externalCatalog, DummyFunctionResourceLoader$.MODULE$, functionRegistry, conf, new Configuration());
    }

    public SessionCatalog(ExternalCatalog externalCatalog) {
        this(externalCatalog, new SimpleFunctionRegistry(), new SimpleCatalystConf(true, SimpleCatalystConf$.MODULE$.$lessinit$greater$default$2(), SimpleCatalystConf$.MODULE$.$lessinit$greater$default$3(), SimpleCatalystConf$.MODULE$.$lessinit$greater$default$4(), SimpleCatalystConf$.MODULE$.$lessinit$greater$default$5(), SimpleCatalystConf$.MODULE$.$lessinit$greater$default$6(), SimpleCatalystConf$.MODULE$.$lessinit$greater$default$7(), SimpleCatalystConf$.MODULE$.$lessinit$greater$default$8()));
    }
}

