/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.commons.lang.StringUtils;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.IntegerLiteral$;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.NonNullLiteral$;
import org.apache.spark.sql.catalyst.expressions.TimeWindow;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.CalendarInterval;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public final class TimeWindow$
implements Serializable {
    public static final TimeWindow$ MODULE$;

    static {
        new TimeWindow$();
    }

    private long getIntervalInMicroSeconds(String interval) {
        if (StringUtils.isBlank((String)interval)) {
            throw new IllegalArgumentException("The window duration, slide duration and start time cannot be null or blank.");
        }
        String intervalString = interval.startsWith("interval") ? interval : new StringBuilder().append((Object)"interval ").append((Object)interval).toString();
        CalendarInterval cal = CalendarInterval.fromString((String)intervalString);
        if (cal == null) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The provided interval (", ") did not correspond to a valid interval string."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{interval})));
        }
        if (cal.months > 0) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Intervals greater than a month is not supported (", ")."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{interval})));
        }
        return cal.microseconds;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long org$apache$spark$sql$catalyst$expressions$TimeWindow$$parseExpression(Expression expr) {
        Option<Object> option;
        boolean bl = false;
        Literal literal = null;
        Expression expression = expr;
        if (expression instanceof Literal) {
            bl = true;
            literal = (Literal)expression;
            Option<Tuple2<Object, DataType>> option2 = NonNullLiteral$.MODULE$.unapply(literal);
            if (!option2.isEmpty()) {
                Object s = ((Tuple2)option2.get())._1();
                DataType dataType2 = (DataType)((Tuple2)option2.get())._2();
                if (StringType$.MODULE$.equals(dataType2)) {
                    return this.getIntervalInMicroSeconds(s.toString());
                }
            }
        }
        if ((option = IntegerLiteral$.MODULE$.unapply(expression)).isEmpty()) {
            if (!bl) throw new AnalysisException("The duration and time inputs to window must be an integer, long or string literal.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4());
            Option<Tuple2<Object, DataType>> option3 = NonNullLiteral$.MODULE$.unapply(literal);
            if (option3.isEmpty()) throw new AnalysisException("The duration and time inputs to window must be an integer, long or string literal.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4());
            Object l = ((Tuple2)option3.get())._1();
            DataType dataType3 = (DataType)((Tuple2)option3.get())._2();
            if (!LongType$.MODULE$.equals(dataType3)) throw new AnalysisException("The duration and time inputs to window must be an integer, long or string literal.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4());
            return new StringOps(Predef$.MODULE$.augmentString(l.toString())).toLong();
        }
        int i = BoxesRunTime.unboxToInt((Object)option.get());
        return i;
    }

    public TimeWindow apply(Expression timeColumn, String windowDuration, String slideDuration, String startTime) {
        return new TimeWindow(timeColumn, this.getIntervalInMicroSeconds(windowDuration), this.getIntervalInMicroSeconds(slideDuration), this.getIntervalInMicroSeconds(startTime));
    }

    public TimeWindow apply(Expression timeColumn, long windowDuration, long slideDuration, long startTime) {
        return new TimeWindow(timeColumn, windowDuration, slideDuration, startTime);
    }

    public Option<Tuple4<Expression, Object, Object, Object>> unapply(TimeWindow x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple4((Object)x$0.timeColumn(), (Object)BoxesRunTime.boxToLong((long)x$0.windowDuration()), (Object)BoxesRunTime.boxToLong((long)x$0.slideDuration()), (Object)BoxesRunTime.boxToLong((long)x$0.startTime())));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private TimeWindow$() {
        MODULE$ = this;
    }
}

