/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import java.util.Arrays;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.MutableRow;
import org.apache.spark.sql.catalyst.expressions.XxHash64Function$;
import org.apache.spark.sql.catalyst.expressions.aggregate.HyperLogLogPlusPlus$;
import org.apache.spark.sql.catalyst.expressions.aggregate.ImperativeAggregate;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AnyDataType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(expr) - Returns the estimated cardinality by HyperLogLog++.\n    _FUNC_(expr, relativeSD=0.05) - Returns the estimated cardinality by HyperLogLog++\n      with relativeSD, the maximum estimation error allowed.\n    ")
@ScalaSignature(bytes="\u0006\u0001\t\rh\u0001B\u0001\u0003\u0001F\u00111\u0003S=qKJdun\u001a'pOBcWo\u001d)mkNT!a\u0001\u0003\u0002\u0013\u0005<wM]3hCR,'BA\u0003\u0007\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005\u001dA\u0011\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005%Q\u0011aA:rY*\u00111\u0002D\u0001\u0006gB\f'o\u001b\u0006\u0003\u001b9\ta!\u00199bG\",'\"A\b\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001\u0011b\u0003\b\t\u0003'Qi\u0011AA\u0005\u0003+\t\u00111#S7qKJ\fG/\u001b<f\u0003\u001e<'/Z4bi\u0016\u0004\"a\u0006\u000e\u000e\u0003aQ\u0011!G\u0001\u0006g\u000e\fG.Y\u0005\u00037a\u0011q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002\u0018;%\u0011a\u0004\u0007\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\tA\u0001\u0011)\u001a!C\u0001C\u0005)1\r[5mIV\t!\u0005\u0005\u0002$I5\tA!\u0003\u0002&\t\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\t\u0011\u001d\u0002!\u0011#Q\u0001\n\t\naa\u00195jY\u0012\u0004\u0003\u0002C\u0015\u0001\u0005+\u0007I\u0011\u0001\u0016\u0002\u0015I,G.\u0019;jm\u0016\u001cF)F\u0001,!\t9B&\u0003\u0002.1\t1Ai\\;cY\u0016D\u0001b\f\u0001\u0003\u0012\u0003\u0006IaK\u0001\fe\u0016d\u0017\r^5wKN#\u0005\u0005\u0003\u00052\u0001\tU\r\u0011\"\u00013\u0003YiW\u000f^1cY\u0016\fum\u001a\"vM\u001a,'o\u00144gg\u0016$X#A\u001a\u0011\u0005]!\u0014BA\u001b\u0019\u0005\rIe\u000e\u001e\u0005\to\u0001\u0011\t\u0012)A\u0005g\u00059R.\u001e;bE2,\u0017iZ4Ck\u001a4WM](gMN,G\u000f\t\u0005\ts\u0001\u0011)\u001a!C\u0001e\u0005!\u0012N\u001c9vi\u0006;wMQ;gM\u0016\u0014xJ\u001a4tKRD\u0001b\u000f\u0001\u0003\u0012\u0003\u0006IaM\u0001\u0016S:\u0004X\u000f^!hO\n+hMZ3s\u001f\u001a47/\u001a;!\u0011\u0015i\u0004\u0001\"\u0001?\u0003\u0019a\u0014N\\5u}Q)q\bQ!C\u0007B\u00111\u0003\u0001\u0005\u0006Aq\u0002\rA\t\u0005\bSq\u0002\n\u00111\u0001,\u0011\u001d\tD\b%AA\u0002MBq!\u000f\u001f\u0011\u0002\u0003\u00071\u0007C\u0003>\u0001\u0011\u0005Q\t\u0006\u0002@\r\")\u0001\u0005\u0012a\u0001E!)Q\b\u0001C\u0001\u0011R\u0019q(\u0013&\t\u000b\u0001:\u0005\u0019\u0001\u0012\t\u000b%:\u0005\u0019\u0001\u0012\t\u000b1\u0003A\u0011I'\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-F\u0001O!\ty%K\u0004\u0002\u0018!&\u0011\u0011\u000bG\u0001\u0007!J,G-\u001a4\n\u0005M#&AB*ue&twM\u0003\u0002R1!)a\u000b\u0001C!/\u0006ir/\u001b;i\u001d\u0016<X*\u001e;bE2,\u0017iZ4Ck\u001a4WM](gMN,G\u000f\u0006\u0002\u00131\")\u0011,\u0016a\u0001g\u0005Ib.Z<NkR\f'\r\\3BO\u001e\u0014UO\u001a4fe>3gm]3u\u0011\u0015Y\u0006\u0001\"\u0011]\u0003m9\u0018\u000e\u001e5OK^Le\u000e];u\u0003\u001e<')\u001e4gKJ|eMZ:fiR\u0011!#\u0018\u0005\u0006=j\u0003\raM\u0001\u0018]\u0016<\u0018J\u001c9vi\u0006;wMQ;gM\u0016\u0014xJ\u001a4tKRDA\u0002\u0019\u0001\u0005\u0002\u0003\u0015\t\u0011!Q\u0001\nM\n!j\u001c:hI\u0005\u0004\u0018m\u00195fIM\u0004\u0018M]6%gFdGeY1uC2L8\u000f\u001e\u0013fqB\u0014Xm]:j_:\u001cH%Y4he\u0016<\u0017\r^3%\u0011f\u0004XM\u001d'pO2{w\r\u00157vgBcWo\u001d\u0013%a\"1!\r\u0001Q\u0001\nM\n\u0001\"\u001b3y'\"Lg\r\u001e\u0005\u0007I\u0002\u0001\u000b\u0011B3\u0002\u0011]\u0004\u0016\r\u001a3j]\u001e\u0004\"a\u00064\n\u0005\u001dD\"\u0001\u0002'p]\u001eDA\"\u001b\u0001\u0005\u0002\u0003\u0015\t\u0011!Q\u0001\nM\n!j\u001c:hI\u0005\u0004\u0018m\u00195fIM\u0004\u0018M]6%gFdGeY1uC2L8\u000f\u001e\u0013fqB\u0014Xm]:j_:\u001cH%Y4he\u0016<\u0017\r^3%\u0011f\u0004XM\u001d'pO2{w\r\u00157vgBcWo\u001d\u0013%[\"a1\u000e\u0001C\u0001\u0002\u000b\u0005\t\u0011)A\u0005W\u0005\u0001vN]4%CB\f7\r[3%gB\f'o\u001b\u0013tc2$3-\u0019;bYf\u001cH\u000fJ3yaJ,7o]5p]N$\u0013mZ4sK\u001e\fG/\u001a\u0013IsB,'\u000fT8h\u0019><\u0007\u000b\\;t!2,8\u000f\n\u0013bYBD\u0017-\u0014\u001a\t\r5\u0004\u0001\u0015!\u00034\u0003!qW/\\,pe\u0012\u001c\b\"B8\u0001\t\u0003\u0002\u0018\u0001C2iS2$'/\u001a8\u0016\u0003E\u00042A\u001d>#\u001d\t\u0019\bP\u0004\u0002uo6\tQO\u0003\u0002w!\u00051AH]8pizJ\u0011!G\u0005\u0003sb\tq\u0001]1dW\u0006<W-\u0003\u0002|y\n\u00191+Z9\u000b\u0005eD\u0002\"\u0002@\u0001\t\u0003z\u0018\u0001\u00038vY2\f'\r\\3\u0016\u0005\u0005\u0005\u0001cA\f\u0002\u0004%\u0019\u0011Q\u0001\r\u0003\u000f\t{w\u000e\\3b]\"9\u0011\u0011\u0002\u0001\u0005B\u0005-\u0011\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u0005\u00055\u0001\u0003BA\b\u0003+i!!!\u0005\u000b\u0007\u0005M\u0001\"A\u0003usB,7/\u0003\u0003\u0002\u0018\u0005E!\u0001\u0003#bi\u0006$\u0016\u0010]3\t\u000f\u0005m\u0001\u0001\"\u0011\u0002\u001e\u0005Q\u0011N\u001c9viRK\b/Z:\u0016\u0005\u0005}\u0001\u0003\u0002:{\u0003C\u0001B!a\u0004\u0002$%!\u0011QEA\t\u0005A\t%m\u001d;sC\u000e$H)\u0019;b)f\u0004X\rC\u0004\u0002*\u0001!\t%a\u000b\u0002\u001f\u0005<wMQ;gM\u0016\u00148k\u00195f[\u0006,\"!!\f\u0011\t\u0005=\u0011qF\u0005\u0005\u0003c\t\tB\u0001\u0006TiJ,8\r\u001e+za\u0016D\u0011\"!\u000e\u0001\u0005\u0004%\t%a\u000e\u0002'\u0005<wMQ;gM\u0016\u0014\u0018\t\u001e;sS\n,H/Z:\u0016\u0005\u0005e\u0002\u0003\u0002:{\u0003w\u00012aIA\u001f\u0013\r\ty\u0004\u0002\u0002\u0013\u0003R$(/\u001b2vi\u0016\u0014VMZ3sK:\u001cW\r\u0003\u0005\u0002D\u0001\u0001\u000b\u0011BA\u001d\u0003Q\twm\u001a\"vM\u001a,'/\u0011;ue&\u0014W\u000f^3tA!I\u0011q\t\u0001C\u0002\u0013\u0005\u0013qG\u0001\u0019S:\u0004X\u000f^!hO\n+hMZ3s\u0003R$(/\u001b2vi\u0016\u001c\b\u0002CA&\u0001\u0001\u0006I!!\u000f\u00023%t\u0007/\u001e;BO\u001e\u0014UO\u001a4fe\u0006#HO]5ckR,7\u000f\t\u0005\b\u0003\u001f\u0002A\u0011IA)\u0003)Ig.\u001b;jC2L'0\u001a\u000b\u0005\u0003'\nI\u0006E\u0002\u0018\u0003+J1!a\u0016\u0019\u0005\u0011)f.\u001b;\t\u0011\u0005m\u0013Q\na\u0001\u0003;\naAY;gM\u0016\u0014\bcA\u0012\u0002`%\u0019\u0011\u0011\r\u0003\u0003\u00155+H/\u00192mKJ{w\u000fC\u0004\u0002f\u0001!\t%a\u001a\u0002\rU\u0004H-\u0019;f)\u0019\t\u0019&!\u001b\u0002l!A\u00111LA2\u0001\u0004\ti\u0006\u0003\u0005\u0002n\u0005\r\u0004\u0019AA8\u0003\u0015Ig\u000e];u!\u0011\t\t(a\u001d\u000e\u0003\u0019I1!!\u001e\u0007\u0005-Ie\u000e^3s]\u0006d'k\\<\t\u000f\u0005e\u0004\u0001\"\u0011\u0002|\u0005)Q.\u001a:hKR1\u00111KA?\u0003\u0003C\u0001\"a \u0002x\u0001\u0007\u0011QL\u0001\bEV4g-\u001a:2\u0011!\t\u0019)a\u001eA\u0002\u0005=\u0014a\u00022vM\u001a,'O\r\u0005\b\u0003\u000f\u0003A\u0011AAE\u00031)7\u000f^5nCR,')[1t)\rY\u00131\u0012\u0005\b\u0003\u001b\u000b)\t1\u0001,\u0003\u0005)\u0007bBAI\u0001\u0011\u0005\u00131S\u0001\u0005KZ\fG\u000e\u0006\u0003\u0002\u0016\u0006m\u0005cA\f\u0002\u0018&\u0019\u0011\u0011\u0014\r\u0003\u0007\u0005s\u0017\u0010\u0003\u0006\u0002\\\u0005=\u0005\u0013!a\u0001\u0003_Ba!a(\u0001\t\u0003Q\u0013a\u0002;sk\u0016\u00146\u000f\u001a\u0005\n\u0003G\u0003\u0011\u0011!C\u0001\u0003K\u000bAaY8qsRIq(a*\u0002*\u0006-\u0016Q\u0016\u0005\tA\u0005\u0005\u0006\u0013!a\u0001E!A\u0011&!)\u0011\u0002\u0003\u00071\u0006\u0003\u00052\u0003C\u0003\n\u00111\u00014\u0011!I\u0014\u0011\u0015I\u0001\u0002\u0004\u0019\u0004\"CAY\u0001E\u0005I\u0011AAZ\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!!.+\u0007\t\n9l\u000b\u0002\u0002:B!\u00111XAc\u001b\t\tiL\u0003\u0003\u0002@\u0006\u0005\u0017!C;oG\",7m[3e\u0015\r\t\u0019\rG\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAd\u0003{\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011%\tY\rAI\u0001\n\u0003\ti-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005='fA\u0016\u00028\"I\u00111\u001b\u0001\u0012\u0002\u0013\u0005\u0011Q[\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134+\t\t9NK\u00024\u0003oC\u0011\"a7\u0001#\u0003%\t!!6\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%i!I\u0011q\u001c\u0001\u0002\u0002\u0013\u0005\u0013\u0011]\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005\r\b\u0003BAs\u0003_l!!a:\u000b\t\u0005%\u00181^\u0001\u0005Y\u0006twM\u0003\u0002\u0002n\u0006!!.\u0019<b\u0013\r\u0019\u0016q\u001d\u0005\t\u0003g\u0004\u0011\u0011!C\u0001e\u0005a\u0001O]8ek\u000e$\u0018I]5us\"I\u0011q\u001f\u0001\u0002\u0002\u0013\u0005\u0011\u0011`\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\t)*a?\t\u0013\u0005u\u0018Q_A\u0001\u0002\u0004\u0019\u0014a\u0001=%c!I!\u0011\u0001\u0001\u0002\u0002\u0013\u0005#1A\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011!Q\u0001\t\u0007\u0005\u000f\u0011i!!&\u000e\u0005\t%!b\u0001B\u00061\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\t=!\u0011\u0002\u0002\t\u0013R,'/\u0019;pe\"I!1\u0003\u0001\u0002\u0002\u0013\u0005!QC\u0001\tG\u0006tW)];bYR!\u0011\u0011\u0001B\f\u0011)\tiP!\u0005\u0002\u0002\u0003\u0007\u0011Q\u0013\u0005\n\u00057\u0001\u0011\u0011!C!\u0005;\ta!Z9vC2\u001cH\u0003BA\u0001\u0005?A!\"!@\u0003\u001a\u0005\u0005\t\u0019AAKQ\u001d\u0001!1\u0005B\u0015\u0005W\u00012a\tB\u0013\u0013\r\u00119\u0003\u0002\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\u0011i#AA\\?\u001a+fjQ0)Kb\u0004(/\u000b\u0011.AI+G/\u001e:og\u0002\"\b.\u001a\u0011fgRLW.\u0019;fI\u0002\u001a\u0017M\u001d3j]\u0006d\u0017\u000e^=!Ef\u0004\u0003*\u001f9fe2{w\rT8hW-r#\u0002\t\u0011!A}3UKT\"`Q\u0015D\bO\u001d\u0017!e\u0016d\u0017\r^5wKN#U\b\r\u00181k%\u0002S\u0006\t*fiV\u0014hn\u001d\u0011uQ\u0016\u0004Sm\u001d;j[\u0006$X\r\u001a\u0011dCJ$\u0017N\\1mSRL\bEY=!\u0011f\u0004XM\u001d'pO2{wmK\u0016\u000bA\u0001\u0002\u0003\u0005\t\u0011xSRD\u0007E]3mCRLg/Z*EY\u0001\"\b.\u001a\u0011nCbLW.^7!KN$\u0018.\\1uS>t\u0007%\u001a:s_J\u0004\u0013\r\u001c7po\u0016$gF\u0003\u0011!A\u0001:qA!\r\u0003\u0011\u0003\u0011\u0019$A\nIsB,'\u000fT8h\u0019><\u0007\u000b\\;t!2,8\u000fE\u0002\u0014\u0005k1a!\u0001\u0002\t\u0002\t]2#\u0002B\u001b\u0005sa\u0002cA\f\u0003<%\u0019!Q\b\r\u0003\r\u0005s\u0017PU3g\u0011\u001di$Q\u0007C\u0001\u0005\u0003\"\"Aa\r\t\u0013\t\u0015#Q\u0007b\u0001\n\u0003\u0011\u0014!C,P%\u0012{6+\u0013.F\u0011!\u0011IE!\u000e!\u0002\u0013\u0019\u0014AC,P%\u0012{6+\u0013.FA!I!Q\nB\u001b\u0005\u0004%\tAM\u0001\u000e%\u0016;\u0015j\u0015+F%~\u001b\u0016JW#\t\u0011\tE#Q\u0007Q\u0001\nM\naBU#H\u0013N#VIU0T\u0013j+\u0005\u0005\u0003\u0006\u0003V\tU\"\u0019!C\u0001\u0005/\n!CU#H\u0013N#VIU0X\u001fJ#u,T!T\u0017V\tQ\r\u0003\u0005\u0003\\\tU\u0002\u0015!\u0003f\u0003M\u0011ViR%T)\u0016\u0013vlV(S\t~k\u0015iU&!\u0011%\u0011yF!\u000eC\u0002\u0013\u0005!'\u0001\nS\u000b\u001eK5\u000bV#S'~\u0003VIU0X\u001fJ#\u0005\u0002\u0003B2\u0005k\u0001\u000b\u0011B\u001a\u0002'I+u)S*U\u000bJ\u001bv\fU#S?^{%\u000b\u0012\u0011\t\u0013\t\u001d$Q\u0007b\u0001\n\u0003\u0011\u0014!A&\t\u0011\t-$Q\u0007Q\u0001\nM\n!a\u0013\u0011\t\u0015\t=$Q\u0007b\u0001\n\u0003\u0011\t(\u0001\u0006U\u0011J+5\u000bS(M\tN+\"Aa\u001d\u0011\t]\u0011)hK\u0005\u0004\u0005oB\"!B!se\u0006L\b\"\u0003B>\u0005k\u0001\u000b\u0011\u0002B:\u0003-!\u0006JU#T\u0011>cEi\u0015\u0011\t\u0015\t}$Q\u0007b\u0001\n\u0003\u0011\t)A\tS\u0003^{Vi\u0015+J\u001b\u0006#Vi\u0018#B)\u0006+\"Aa!\u0011\u000b]\u0011)Ha\u001d\t\u0013\t\u001d%Q\u0007Q\u0001\n\t\r\u0015A\u0005*B/~+5\u000bV%N\u0003R+u\fR!U\u0003\u0002B!Ba#\u00036\t\u0007I\u0011\u0001BA\u0003%\u0011\u0015*Q*`\t\u0006#\u0016\tC\u0005\u0003\u0010\nU\u0002\u0015!\u0003\u0003\u0004\u0006Q!)S!T?\u0012\u000bE+\u0011\u0011\t\u0011\tM%Q\u0007C\u0005\u0005+\u000bQC^1mS\u0012\fG/\u001a#pk\ndW\rT5uKJ\fG\u000eF\u0002,\u0005/CqA!'\u0003\u0012\u0002\u0007!%A\u0002fqBD!B!(\u00036\u0005\u0005I\u0011\u0011BP\u0003\u0015\t\u0007\u000f\u001d7z)%y$\u0011\u0015BR\u0005K\u00139\u000b\u0003\u0004!\u00057\u0003\rA\t\u0005\tS\tm\u0005\u0013!a\u0001W!A\u0011Ga'\u0011\u0002\u0003\u00071\u0007\u0003\u0005:\u00057\u0003\n\u00111\u00014\u0011)\u0011YK!\u000e\u0002\u0002\u0013\u0005%QV\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011yKa/\u0011\u000b]\u0011\tL!.\n\u0007\tM\u0006D\u0001\u0004PaRLwN\u001c\t\b/\t]&eK\u001a4\u0013\r\u0011I\f\u0007\u0002\u0007)V\u0004H.\u001a\u001b\t\u0013\tu&\u0011VA\u0001\u0002\u0004y\u0014a\u0001=%a!Q!\u0011\u0019B\u001b#\u0003%\t!!4\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIIB!B!2\u00036E\u0005I\u0011AAk\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\u001a\u0004B\u0003Be\u0005k\t\n\u0011\"\u0001\u0002V\u0006y\u0011\r\u001d9ms\u0012\"WMZ1vYR$C\u0007\u0003\u0006\u0003N\nU\u0012\u0013!C\u0001\u0003\u001b\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u0012\u0004B\u0003Bi\u0005k\t\n\u0011\"\u0001\u0002V\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIMB!B!6\u00036E\u0005I\u0011AAk\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%i!Q!\u0011\u001cB\u001b\u0003\u0003%IAa7\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0005;\u0004B!!:\u0003`&!!\u0011]At\u0005\u0019y%M[3di\u0002")
public class HyperLogLogPlusPlus
extends ImperativeAggregate
implements Serializable {
    private final Expression child;
    private final double relativeSD;
    private final int mutableAggBufferOffset;
    private final int inputAggBufferOffset;
    public final int org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$p;
    private final int idxShift;
    private final long wPadding;
    public final int org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m;
    public final double org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$alphaM2;
    private final int numWords;
    private final Seq<AttributeReference> aggBufferAttributes;
    private final Seq<AttributeReference> inputAggBufferAttributes;

    public static int $lessinit$greater$default$4() {
        return HyperLogLogPlusPlus$.MODULE$.$lessinit$greater$default$4();
    }

    public static int $lessinit$greater$default$3() {
        return HyperLogLogPlusPlus$.MODULE$.$lessinit$greater$default$3();
    }

    public static double $lessinit$greater$default$2() {
        return HyperLogLogPlusPlus$.MODULE$.$lessinit$greater$default$2();
    }

    public static int apply$default$4() {
        return HyperLogLogPlusPlus$.MODULE$.apply$default$4();
    }

    public static int apply$default$3() {
        return HyperLogLogPlusPlus$.MODULE$.apply$default$3();
    }

    public static double apply$default$2() {
        return HyperLogLogPlusPlus$.MODULE$.apply$default$2();
    }

    public static Option<Tuple4<Expression, Object, Object, Object>> unapply(HyperLogLogPlusPlus hyperLogLogPlusPlus) {
        return HyperLogLogPlusPlus$.MODULE$.unapply(hyperLogLogPlusPlus);
    }

    public static double[][] BIAS_DATA() {
        return HyperLogLogPlusPlus$.MODULE$.BIAS_DATA();
    }

    public static double[][] RAW_ESTIMATE_DATA() {
        return HyperLogLogPlusPlus$.MODULE$.RAW_ESTIMATE_DATA();
    }

    public static double[] THRESHOLDS() {
        return HyperLogLogPlusPlus$.MODULE$.THRESHOLDS();
    }

    public static int K() {
        return HyperLogLogPlusPlus$.MODULE$.K();
    }

    public static int REGISTERS_PER_WORD() {
        return HyperLogLogPlusPlus$.MODULE$.REGISTERS_PER_WORD();
    }

    public static long REGISTER_WORD_MASK() {
        return HyperLogLogPlusPlus$.MODULE$.REGISTER_WORD_MASK();
    }

    public static int REGISTER_SIZE() {
        return HyperLogLogPlusPlus$.MODULE$.REGISTER_SIZE();
    }

    public static int WORD_SIZE() {
        return HyperLogLogPlusPlus$.MODULE$.WORD_SIZE();
    }

    public Expression child() {
        return this.child;
    }

    public double relativeSD() {
        return this.relativeSD;
    }

    @Override
    public int mutableAggBufferOffset() {
        return this.mutableAggBufferOffset;
    }

    @Override
    public int inputAggBufferOffset() {
        return this.inputAggBufferOffset;
    }

    @Override
    public String prettyName() {
        return "approx_count_distinct";
    }

    @Override
    public ImperativeAggregate withNewMutableAggBufferOffset(int newMutableAggBufferOffset) {
        int x$2 = newMutableAggBufferOffset;
        Expression x$3 = this.copy$default$1();
        double x$4 = this.copy$default$2();
        int x$5 = this.copy$default$4();
        return this.copy(x$3, x$4, x$2, x$5);
    }

    @Override
    public ImperativeAggregate withNewInputAggBufferOffset(int newInputAggBufferOffset) {
        int x$6 = newInputAggBufferOffset;
        Expression x$7 = this.copy$default$1();
        double x$8 = this.copy$default$2();
        int x$9 = this.copy$default$3();
        return this.copy(x$7, x$8, x$9, x$6);
    }

    @Override
    public Seq<Expression> children() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.child()}));
    }

    @Override
    public boolean nullable() {
        return false;
    }

    @Override
    public DataType dataType() {
        return LongType$.MODULE$;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AnyDataType$[]{AnyDataType$.MODULE$}));
    }

    @Override
    public StructType aggBufferSchema() {
        return StructType$.MODULE$.fromAttributes(this.aggBufferAttributes());
    }

    @Override
    public Seq<AttributeReference> aggBufferAttributes() {
        return this.aggBufferAttributes;
    }

    @Override
    public Seq<AttributeReference> inputAggBufferAttributes() {
        return this.inputAggBufferAttributes;
    }

    @Override
    public void initialize(MutableRow buffer) {
        for (int word = 0; word < this.numWords; ++word) {
            buffer.setLong(this.mutableAggBufferOffset() + word, 0L);
        }
    }

    @Override
    public void update(MutableRow buffer, InternalRow input) {
        Object v = this.child().eval(input);
        if (v != null) {
            long x = XxHash64Function$.MODULE$.hash(v, this.child().dataType(), 42L);
            int idx = (int)(x >>> this.idxShift);
            long pw = (long)Long.numberOfLeadingZeros(x << this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$p | this.wPadding) + 1L;
            int wordOffset = idx / HyperLogLogPlusPlus$.MODULE$.REGISTERS_PER_WORD();
            long word = buffer.getLong(this.mutableAggBufferOffset() + wordOffset);
            int shift = HyperLogLogPlusPlus$.MODULE$.REGISTER_SIZE() * (idx - wordOffset * HyperLogLogPlusPlus$.MODULE$.REGISTERS_PER_WORD());
            long mask = HyperLogLogPlusPlus$.MODULE$.REGISTER_WORD_MASK() << shift;
            long Midx = (word & mask) >>> shift;
            if (pw > Midx) {
                buffer.setLong(this.mutableAggBufferOffset() + wordOffset, word & (mask ^ 0xFFFFFFFFFFFFFFFFL) | pw << shift);
            }
        }
    }

    @Override
    public void merge(MutableRow buffer1, InternalRow buffer2) {
        int idx = 0;
        for (int wordOffset = 0; wordOffset < this.numWords; ++wordOffset) {
            long word1 = buffer1.getLong(this.mutableAggBufferOffset() + wordOffset);
            long word2 = buffer2.getLong(this.inputAggBufferOffset() + wordOffset);
            long word = 0L;
            long mask = HyperLogLogPlusPlus$.MODULE$.REGISTER_WORD_MASK();
            for (int i = 0; idx < this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m && i < HyperLogLogPlusPlus$.MODULE$.REGISTERS_PER_WORD(); ++i, ++idx) {
                word |= Math.max(word1 & mask, word2 & mask);
                mask <<= HyperLogLogPlusPlus$.MODULE$.REGISTER_SIZE();
            }
            buffer1.setLong(this.mutableAggBufferOffset() + wordOffset, word);
        }
    }

    public double estimateBias(double e) {
        int high;
        double[] estimates = HyperLogLogPlusPlus$.MODULE$.RAW_ESTIMATE_DATA()[this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$p - 4];
        int numEstimates = estimates.length;
        int n = Arrays.binarySearch(estimates, 0, numEstimates, e);
        switch (n) {
            default: 
        }
        int nearestEstimateIndex = n < 0 ? -(n + 1) : n;
        int low = package$.MODULE$.max(nearestEstimateIndex - HyperLogLogPlusPlus$.MODULE$.K() + 1, 0);
        for (high = package$.MODULE$.min(low + HyperLogLogPlusPlus$.MODULE$.K(), numEstimates); high < numEstimates && this.distance$1(high, e, estimates) < this.distance$1(low, e, estimates); ++high) {
            ++low;
        }
        double[] biases = HyperLogLogPlusPlus$.MODULE$.BIAS_DATA()[this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$p - 4];
        double biasSum = 0.0;
        for (int i = low; i < high; ++i) {
            biasSum += biases[i];
        }
        return biasSum / (double)(high - low);
    }

    @Override
    public Object eval(InternalRow buffer) {
        double H;
        DoubleRef zInverse = DoubleRef.create((double)0.0);
        double V = 0.0;
        int idx = 0;
        for (int wordOffset = 0; wordOffset < this.numWords; ++wordOffset) {
            long word = buffer.getLong(this.mutableAggBufferOffset() + wordOffset);
            int shift = 0;
            for (int i = 0; idx < this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m && i < HyperLogLogPlusPlus$.MODULE$.REGISTERS_PER_WORD(); ++i, ++idx) {
                long Midx = word >>> shift & HyperLogLogPlusPlus$.MODULE$.REGISTER_WORD_MASK();
                zInverse.elem += 1.0 / (double)(1L << (int)Midx);
                if (Midx == 0L) {
                    V += 1.0;
                }
                shift += HyperLogLogPlusPlus$.MODULE$.REGISTER_SIZE();
            }
        }
        double estimate = V > 0.0 ? ((H = (double)this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m * Math.log((double)this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m / V)) <= HyperLogLogPlusPlus$.MODULE$.THRESHOLDS()[this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$p - 4] ? H : this.EBiasCorrected$1(zInverse)) : this.EBiasCorrected$1(zInverse);
        return BoxesRunTime.boxToLong((long)Math.round(estimate));
    }

    public double trueRsd() {
        return 1.04 / package$.MODULE$.sqrt((double)this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m);
    }

    public HyperLogLogPlusPlus copy(Expression child, double relativeSD, int mutableAggBufferOffset, int inputAggBufferOffset) {
        return new HyperLogLogPlusPlus(child, relativeSD, mutableAggBufferOffset, inputAggBufferOffset);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public double copy$default$2() {
        return this.relativeSD();
    }

    public int copy$default$3() {
        return this.mutableAggBufferOffset();
    }

    public int copy$default$4() {
        return this.inputAggBufferOffset();
    }

    @Override
    public String productPrefix() {
        return "HyperLogLogPlusPlus";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 3: {
                object = BoxesRunTime.boxToInteger((int)this.inputAggBufferOffset());
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToInteger((int)this.mutableAggBufferOffset());
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToDouble((double)this.relativeSD());
                break;
            }
            case 0: {
                object = this.child();
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof HyperLogLogPlusPlus;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof HyperLogLogPlusPlus)) return false;
        boolean bl = true;
        if (!bl) return false;
        HyperLogLogPlusPlus hyperLogLogPlusPlus = (HyperLogLogPlusPlus)x$1;
        Expression expression = this.child();
        Expression expression2 = hyperLogLogPlusPlus.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (this.relativeSD() != hyperLogLogPlusPlus.relativeSD()) return false;
        if (this.mutableAggBufferOffset() != hyperLogLogPlusPlus.mutableAggBufferOffset()) return false;
        if (this.inputAggBufferOffset() != hyperLogLogPlusPlus.inputAggBufferOffset()) return false;
        if (!hyperLogLogPlusPlus.canEqual(this)) return false;
        return true;
    }

    private final double distance$1(int i, double e$1, double[] estimates$1) {
        double diff = e$1 - estimates$1[i];
        return diff * diff;
    }

    private final double EBiasCorrected$1(DoubleRef zInverse$1) {
        double d = this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$alphaM2 / zInverse$1.elem;
        double d2 = this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$p < 19 && d < 5.0 * (double)this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m ? d - this.estimateBias(d) : d;
        return d2;
    }

    public HyperLogLogPlusPlus(Expression child, double relativeSD, int mutableAggBufferOffset, int inputAggBufferOffset) {
        double d;
        this.child = child;
        this.relativeSD = relativeSD;
        this.mutableAggBufferOffset = mutableAggBufferOffset;
        this.inputAggBufferOffset = inputAggBufferOffset;
        this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$p = (int)Math.ceil(2.0 * Math.log(1.106 / relativeSD) / Math.log(2.0));
        Predef$.MODULE$.require(this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$p >= 4, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "HLL++ requires at least 4 bits for addressing. Use a lower error, at most 27%.";
            }
        });
        this.idxShift = 64 - this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$p;
        this.wPadding = 1L << this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$p - 1;
        this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m = 1 << this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$p;
        int n = this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$p;
        switch (n) {
            default: {
                d = 0.7213 / (1.0 + 1.079 / (double)this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m) * (double)this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m * (double)this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m;
                break;
            }
            case 6: {
                d = 0.709 * (double)this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m * (double)this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m;
                break;
            }
            case 5: {
                d = 0.697 * (double)this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m * (double)this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m;
                break;
            }
            case 4: {
                d = 0.673 * (double)this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m * (double)this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m;
            }
        }
        this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$alphaM2 = d;
        this.numWords = this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m / HyperLogLogPlusPlus$.MODULE$.REGISTERS_PER_WORD() + 1;
        this.aggBufferAttributes = (Seq)Seq$.MODULE$.tabulate(this.numWords, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final AttributeReference apply(int i) {
                String x$10 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"MS[", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)}));
                LongType$ x$11 = LongType$.MODULE$;
                boolean x$12 = AttributeReference$.MODULE$.apply$default$3();
                Metadata x$13 = AttributeReference$.MODULE$.apply$default$4();
                ExprId x$14 = AttributeReference$.MODULE$.apply$default$5(x$10, x$11, x$12, x$13);
                Option<String> x$15 = AttributeReference$.MODULE$.apply$default$6(x$10, x$11, x$12, x$13);
                Boolean x$16 = AttributeReference$.MODULE$.apply$default$7(x$10, x$11, x$12, x$13);
                return new AttributeReference(x$10, x$11, x$12, x$13, x$14, x$15, x$16);
            }
        });
        this.inputAggBufferAttributes = (Seq)this.aggBufferAttributes().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final AttributeReference apply(AttributeReference x$1) {
                return x$1.newInstance();
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public HyperLogLogPlusPlus(Expression child) {
        this(child, 0.05, 0, 0);
    }

    public HyperLogLogPlusPlus(Expression child, Expression relativeSD) {
        this(child, HyperLogLogPlusPlus$.MODULE$.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$validateDoubleLiteral(relativeSD), 0, 0);
    }
}

