/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes$class;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Sha2$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(input, bitLength) - Returns a checksum of SHA-2 family as a hex string of the input.\n            SHA-224, SHA-256, SHA-384, and SHA-512 are supported. Bit length of 0 is equivalent to 256.", extended="> SELECT _FUNC_('Spark', 0);\n               '529bc3b07127ecb7e53a4dcf1991d9152c24537d919178022b2c42657f79a26b'")
@ScalaSignature(bytes="\u0006\u0001\u0005-f\u0001B\u0001\u0003\u0001>\u0011Aa\u00155be)\u00111\u0001B\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002\u0006\r\u0005A1-\u0019;bYf\u001cHO\u0003\u0002\b\u0011\u0005\u00191/\u001d7\u000b\u0005%Q\u0011!B:qCJ\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c\u0001aE\u0003\u0001!QQR\u0004\u0005\u0002\u0012%5\t!!\u0003\u0002\u0014\u0005\t\u0001\")\u001b8bef,\u0005\u0010\u001d:fgNLwN\u001c\t\u0003+ai\u0011A\u0006\u0006\u0002/\u0005)1oY1mC&\u0011\u0011D\u0006\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\t\u0003#mI!\u0001\b\u0002\u0003-%k\u0007\u000f\\5dSR\u001c\u0015m\u001d;J]B,H\u000fV=qKN\u0004\"!\u0006\u0010\n\u0005}1\"a\u0002)s_\u0012,8\r\u001e\u0005\tC\u0001\u0011)\u001a!C\u0001E\u0005!A.\u001a4u+\u0005\u0019\u0003CA\t%\u0013\t)#A\u0001\u0006FqB\u0014Xm]:j_:D\u0001b\n\u0001\u0003\u0012\u0003\u0006IaI\u0001\u0006Y\u00164G\u000f\t\u0005\tS\u0001\u0011)\u001a!C\u0001E\u0005)!/[4ii\"A1\u0006\u0001B\tB\u0003%1%\u0001\u0004sS\u001eDG\u000f\t\u0005\u0006[\u0001!\tAL\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007=\u0002\u0014\u0007\u0005\u0002\u0012\u0001!)\u0011\u0005\fa\u0001G!)\u0011\u0006\fa\u0001G!)1\u0007\u0001C!i\u0005AA-\u0019;b)f\u0004X-F\u00016!\t1\u0014(D\u00018\u0015\tAd!A\u0003usB,7/\u0003\u0002;o\tAA)\u0019;b)f\u0004X\rC\u0003=\u0001\u0011\u0005S(\u0001\u0005ok2d\u0017M\u00197f+\u0005q\u0004CA\u000b@\u0013\t\u0001eCA\u0004C_>dW-\u00198\t\u000b\t\u0003A\u0011I\"\u0002\u0015%t\u0007/\u001e;UsB,7/F\u0001E!\r)U*\u000e\b\u0003\r.s!a\u0012&\u000e\u0003!S!!\u0013\b\u0002\rq\u0012xn\u001c;?\u0013\u00059\u0012B\u0001'\u0017\u0003\u001d\u0001\u0018mY6bO\u0016L!AT(\u0003\u0007M+\u0017O\u0003\u0002M-!)\u0011\u000b\u0001C)%\u0006aa.\u001e7m'\u00064W-\u0012<bYR\u00191K\u0016-\u0011\u0005U!\u0016BA+\u0017\u0005\r\te.\u001f\u0005\u0006/B\u0003\raU\u0001\u0007S:\u0004X\u000f^\u0019\t\u000be\u0003\u0006\u0019A*\u0002\r%t\u0007/\u001e;3\u0011\u0015Y\u0006\u0001\"\u0011]\u0003%!wnR3o\u0007>$W\rF\u0002^G\"\u0004\"AX1\u000e\u0003}S!\u0001\u0019\u0002\u0002\u000f\r|G-Z4f]&\u0011!m\u0018\u0002\t\u000bb\u0004(oQ8eK\")AM\u0017a\u0001K\u0006\u00191\r\u001e=\u0011\u0005y3\u0017BA4`\u00059\u0019u\u000eZ3hK:\u001cuN\u001c;fqRDQ!\u001b.A\u0002u\u000b!!\u001a<\t\u000f-\u0004\u0011\u0011!C\u0001Y\u0006!1m\u001c9z)\rySN\u001c\u0005\bC)\u0004\n\u00111\u0001$\u0011\u001dI#\u000e%AA\u0002\rBq\u0001\u001d\u0001\u0012\u0002\u0013\u0005\u0011/\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0003IT#aI:,\u0003Q\u0004\"!\u001e>\u000e\u0003YT!a\u001e=\u0002\u0013Ut7\r[3dW\u0016$'BA=\u0017\u0003)\tgN\\8uCRLwN\\\u0005\u0003wZ\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011\u001di\b!%A\u0005\u0002E\fabY8qs\u0012\"WMZ1vYR$#\u0007\u0003\u0005\u0000\u0001\u0005\u0005I\u0011IA\u0001\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u00111\u0001\t\u0005\u0003\u000b\ty!\u0004\u0002\u0002\b)!\u0011\u0011BA\u0006\u0003\u0011a\u0017M\\4\u000b\u0005\u00055\u0011\u0001\u00026bm\u0006LA!!\u0005\u0002\b\t11\u000b\u001e:j]\u001eD\u0011\"!\u0006\u0001\u0003\u0003%\t!a\u0006\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005e\u0001cA\u000b\u0002\u001c%\u0019\u0011Q\u0004\f\u0003\u0007%sG\u000fC\u0005\u0002\"\u0001\t\t\u0011\"\u0001\u0002$\u0005q\u0001O]8ek\u000e$X\t\\3nK:$HcA*\u0002&!Q\u0011qEA\u0010\u0003\u0003\u0005\r!!\u0007\u0002\u0007a$\u0013\u0007C\u0005\u0002,\u0001\t\t\u0011\"\u0011\u0002.\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u00020A)\u0011\u0011GA\u001c'6\u0011\u00111\u0007\u0006\u0004\u0003k1\u0012AC2pY2,7\r^5p]&!\u0011\u0011HA\u001a\u0005!IE/\u001a:bi>\u0014\b\"CA\u001f\u0001\u0005\u0005I\u0011AA \u0003!\u0019\u0017M\\#rk\u0006dGc\u0001 \u0002B!I\u0011qEA\u001e\u0003\u0003\u0005\ra\u0015\u0005\n\u0003\u000b\u0002\u0011\u0011!C!\u0003\u000f\na!Z9vC2\u001cHc\u0001 \u0002J!I\u0011qEA\"\u0003\u0003\u0005\ra\u0015\u0015\f\u0001\u00055\u00131KA+\u00033\nY\u0006E\u0002\u0012\u0003\u001fJ1!!\u0015\u0003\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!a\u0016\u0002\u0003\u000f{f)\u0016(D?\"Jg\u000e];uY\u0001\u0012\u0017\u000e\u001e'f]\u001e$\b.\u000b\u0011.AI+G/\u001e:og\u0002\n\u0007e\u00195fG.\u001cX/\u001c\u0011pM\u0002\u001a\u0006*Q\u00173A\u0019\fW.\u001b7zA\u0005\u001c\b%\u0019\u0011iKb\u00043\u000f\u001e:j]\u001e\u0004sN\u001a\u0011uQ\u0016\u0004\u0013N\u001c9vi:R\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!AMC\u0015)\f\u001a3i1\u00023\u000bS!.eU2D\u0006I*I\u00036\u001a\u0004\b\u000e\u0017!C:$\u0007e\u0015%B[U\n$\u0007I1sK\u0002\u001aX\u000f\u001d9peR,GM\f\u0011CSR\u0004C.\u001a8hi\"\u0004sN\u001a\u00111A%\u001c\b%Z9vSZ\fG.\u001a8uAQ|\u0007EM\u001b7]\u0005AQ\r\u001f;f]\u0012,G-\t\u0002\u0002^\u0005qg\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u0014Ta\u0006\u00148n\n\u0017!a%Z$\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005I\u00146ee\u00127m\r21oE\u0012t'Z2co\u0015,4'\u0019\u001beG\u001a\f\u0014(O\u0019esE*$g\u0019\u001a5kM:D-O\u0019:c]B\u0004G\r\u001ace\r$$GN\u001b8M^J\u0014M\r\u001ccO\u001dI\u0011\u0011\r\u0002\u0002\u0002#\u0005\u00111M\u0001\u0005'\"\f'\u0007E\u0002\u0012\u0003K2\u0001\"\u0001\u0002\u0002\u0002#\u0005\u0011qM\n\u0006\u0003K\nI\u0007\u0006\t\b\u0003W\n\thI\u00120\u001b\t\tiGC\u0002\u0002pY\tqA];oi&lW-\u0003\u0003\u0002t\u00055$!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oe!9Q&!\u001a\u0005\u0002\u0005]DCAA2\u0011)\tY(!\u001a\u0002\u0002\u0013\u0015\u0013QP\u0001\ti>\u001cFO]5oOR\u0011\u00111\u0001\u0005\u000b\u0003\u0003\u000b)'!A\u0005\u0002\u0006\r\u0015!B1qa2LH#B\u0018\u0002\u0006\u0006\u001d\u0005BB\u0011\u0002\u0000\u0001\u00071\u0005\u0003\u0004*\u0003\u007f\u0002\ra\t\u0005\u000b\u0003\u0017\u000b)'!A\u0005\u0002\u00065\u0015aB;oCB\u0004H.\u001f\u000b\u0005\u0003\u001f\u000bY\nE\u0003\u0016\u0003#\u000b)*C\u0002\u0002\u0014Z\u0011aa\u00149uS>t\u0007#B\u000b\u0002\u0018\u000e\u001a\u0013bAAM-\t1A+\u001e9mKJB\u0011\"!(\u0002\n\u0006\u0005\t\u0019A\u0018\u0002\u0007a$\u0003\u0007\u0003\u0006\u0002\"\u0006\u0015\u0014\u0011!C\u0005\u0003G\u000b1B]3bIJ+7o\u001c7wKR\u0011\u0011Q\u0015\t\u0005\u0003\u000b\t9+\u0003\u0003\u0002*\u0006\u001d!AB(cU\u0016\u001cG\u000f")
public class Sha2
extends BinaryExpression
implements Serializable,
ImplicitCastInputTypes {
    private final Expression left;
    private final Expression right;

    public static Option<Tuple2<Expression, Expression>> unapply(Sha2 sha2) {
        return Sha2$.MODULE$.unapply(sha2);
    }

    public static Function1<Tuple2<Expression, Expression>, Sha2> tupled() {
        return Sha2$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Sha2>> curried() {
        return Sha2$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes$class.checkInputDataTypes(this);
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    public Seq<DataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AtomicType[]{BinaryType$.MODULE$, IntegerType$.MODULE$}));
    }

    @Override
    public Object nullSafeEval(Object input1, Object input2) {
        UTF8String uTF8String;
        int bitLength = BoxesRunTime.unboxToInt((Object)input2);
        byte[] input = (byte[])input1;
        int n = bitLength;
        switch (n) {
            default: {
                uTF8String = null;
                break;
            }
            case 512: {
                uTF8String = UTF8String.fromString((String)DigestUtils.sha512Hex((byte[])input));
                break;
            }
            case 384: {
                uTF8String = UTF8String.fromString((String)DigestUtils.sha384Hex((byte[])input));
                break;
            }
            case 0: 
            case 256: {
                uTF8String = UTF8String.fromString((String)DigestUtils.sha256Hex((byte[])input));
                break;
            }
            case 224: {
                try {
                    MessageDigest md = MessageDigest.getInstance("SHA-224");
                    md.update(input);
                    uTF8String = UTF8String.fromBytes((byte[])md.digest());
                    break;
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    uTF8String = null;
                }
            }
        }
        return uTF8String;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String digestUtils = "org.apache.commons.codec.digest.DigestUtils";
        return this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)new Serializable(this, ev, digestUtils){
            public static final long serialVersionUID = 0L;
            private final ExprCode ev$1;
            private final String digestUtils$1;

            public final String apply(String eval1, String eval2) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        if (", " == 224) {\n          try {\n            java.security.MessageDigest md = java.security.MessageDigest.getInstance(\"SHA-224\");\n            md.update(", ");\n            ", " = UTF8String.fromBytes(md.digest());\n          } catch (java.security.NoSuchAlgorithmException e) {\n            ", " = true;\n          }\n        } else if (", " == 256 || ", " == 0) {\n          ", " =\n            UTF8String.fromString(", ".sha256Hex(", "));\n        } else if (", " == 384) {\n          ", " =\n            UTF8String.fromString(", ".sha384Hex(", "));\n        } else if (", " == 512) {\n          ", " =\n            UTF8String.fromString(", ".sha512Hex(", "));\n        } else {\n          ", " = true;\n        }\n      "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{eval2, eval1, this.ev$1.value(), this.ev$1.isNull(), eval2, eval2, this.ev$1.value(), this.digestUtils$1, eval1, eval2, this.ev$1.value(), this.digestUtils$1, eval1, eval2, this.ev$1.value(), this.digestUtils$1, eval1, this.ev$1.isNull()}));
            }
            {
                this.ev$1 = ev$1;
                this.digestUtils$1 = digestUtils$1;
            }
        });
    }

    public Sha2 copy(Expression left, Expression right) {
        return new Sha2(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "Sha2";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 1: {
                expression = this.right();
                break;
            }
            case 0: {
                expression = this.left();
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Sha2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Sha2)) return false;
        boolean bl = true;
        if (!bl) return false;
        Sha2 sha2 = (Sha2)x$1;
        Expression expression = this.left();
        Expression expression2 = sha2.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = sha2.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!sha2.canEqual(this)) return false;
        return true;
    }

    public Sha2(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        ExpectsInputTypes$class.$init$(this);
    }
}

