/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.internal;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.spark.internal.config.ConfigBuilder;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.util.Utils$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.runtime.BoxesRunTime;

public final class StaticSQLConf$ {
    public static final StaticSQLConf$ MODULE$;
    private final Set<String> globalConfKeys;
    private final ConfigEntry<String> WAREHOUSE_PATH;
    private final ConfigEntry<String> CATALOG_IMPLEMENTATION;
    private final ConfigEntry<String> GLOBAL_TEMP_DATABASE;
    private final ConfigEntry<Object> SCHEMA_STRING_LENGTH_THRESHOLD;
    private final ConfigEntry<Object> DEBUG_MODE;

    static {
        new StaticSQLConf$();
    }

    public Set<String> globalConfKeys() {
        return this.globalConfKeys;
    }

    private ConfigBuilder buildConf(String key) {
        return new ConfigBuilder(key).onCreate((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(ConfigEntry<?> entry) {
                StaticSQLConf$.MODULE$.globalConfKeys().add(entry.key());
                SQLConf$.MODULE$.register(entry);
            }
        });
    }

    public ConfigEntry<String> WAREHOUSE_PATH() {
        return this.WAREHOUSE_PATH;
    }

    public ConfigEntry<String> CATALOG_IMPLEMENTATION() {
        return this.CATALOG_IMPLEMENTATION;
    }

    public ConfigEntry<String> GLOBAL_TEMP_DATABASE() {
        return this.GLOBAL_TEMP_DATABASE;
    }

    public ConfigEntry<Object> SCHEMA_STRING_LENGTH_THRESHOLD() {
        return this.SCHEMA_STRING_LENGTH_THRESHOLD;
    }

    public ConfigEntry<Object> DEBUG_MODE() {
        return this.DEBUG_MODE;
    }

    private StaticSQLConf$() {
        MODULE$ = this;
        this.globalConfKeys = Collections.synchronizedSet(new HashSet());
        this.WAREHOUSE_PATH = this.buildConf("spark.sql.warehouse.dir").doc("The default location for managed databases and tables.").stringConf().createWithDefault((Object)Utils$.MODULE$.resolveURI("spark-warehouse").toString());
        this.CATALOG_IMPLEMENTATION = this.buildConf("spark.sql.catalogImplementation").internal().stringConf().checkValues((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hive", "in-memory"}))).createWithDefault((Object)"in-memory");
        this.GLOBAL_TEMP_DATABASE = this.buildConf("spark.sql.globalTempDatabase").internal().stringConf().createWithDefault((Object)"global_temp");
        this.SCHEMA_STRING_LENGTH_THRESHOLD = this.buildConf("spark.sql.sources.schemaStringLengthThreshold").doc("The maximum length allowed in a single cell when storing additional schema information in Hive's metastore.").internal().intConf().createWithDefault((Object)BoxesRunTime.boxToInteger((int)4000));
        this.DEBUG_MODE = this.buildConf("spark.sql.debug").internal().doc("Only used for internal debugging. Not all functions are supported when it is enabled.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)false));
    }
}

