/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.util.regex.Pattern;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes$class;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Like$;
import org.apache.spark.sql.catalyst.expressions.StringRegexExpression;
import org.apache.spark.sql.catalyst.expressions.StringRegexExpression$class;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.StringUtils$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="str _FUNC_ pattern - Returns true if str matches pattern, null if any arguments are null, false otherwise.", extended="\n    Arguments:\n      str - a string expression\n      pattern - a string expression. The pattern is a string which is matched literally, with\n        exception to the following special symbols:\n\n          _ matches any one character in the input (similar to . in posix regular expressions)\n\n          % matches zero or more characters in the input (similar to .* in posix regular\n          expressions)\n\n        The escape character is '\\'. If an escape character precedes a special symbol or another\n        escape character, the following character is matched literally. It is invalid to escape\n        any other character.\n\n    Examples:\n      > SELECT '%SystemDrive%\\Users\\John' _FUNC_ '\\%SystemDrive\\%\\\\Users%'\n      true\n\n    See also:\n      Use RLIKE to match with standard regular expressions.\n")
@ScalaSignature(bytes="\u0006\u0001\u0005ue\u0001B\u0001\u0003\u0001>\u0011A\u0001T5lK*\u00111\u0001B\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002\u0006\r\u0005A1-\u0019;bYf\u001cHO\u0003\u0002\b\u0011\u0005\u00191/\u001d7\u000b\u0005%Q\u0011!B:qCJ\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c\u0001aE\u0003\u0001!Q9R\u0004\u0005\u0002\u0012%5\t!!\u0003\u0002\u0014\u0005\t\u0001\")\u001b8bef,\u0005\u0010\u001d:fgNLwN\u001c\t\u0003#UI!A\u0006\u0002\u0003+M#(/\u001b8h%\u0016<W\r_#yaJ,7o]5p]B\u0011\u0001dG\u0007\u00023)\t!$A\u0003tG\u0006d\u0017-\u0003\u0002\u001d3\t9\u0001K]8ek\u000e$\bC\u0001\r\u001f\u0013\ty\u0012D\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0003\u0005\"\u0001\tU\r\u0011\"\u0001#\u0003\u0011aWM\u001a;\u0016\u0003\r\u0002\"!\u0005\u0013\n\u0005\u0015\u0012!AC#yaJ,7o]5p]\"Aq\u0005\u0001B\tB\u0003%1%A\u0003mK\u001a$\b\u0005\u0003\u0005*\u0001\tU\r\u0011\"\u0001#\u0003\u0015\u0011\u0018n\u001a5u\u0011!Y\u0003A!E!\u0002\u0013\u0019\u0013A\u0002:jO\"$\b\u0005C\u0003.\u0001\u0011\u0005a&\u0001\u0004=S:LGO\u0010\u000b\u0004_A\n\u0004CA\t\u0001\u0011\u0015\tC\u00061\u0001$\u0011\u0015IC\u00061\u0001$\u0011\u0015\u0019\u0004\u0001\"\u00115\u0003\u0019)7oY1qKR\u0011Q\u0007\u0010\t\u0003mer!\u0001G\u001c\n\u0005aJ\u0012A\u0002)sK\u0012,g-\u0003\u0002;w\t11\u000b\u001e:j]\u001eT!\u0001O\r\t\u000bu\u0012\u0004\u0019A\u001b\u0002\u0003YDQa\u0010\u0001\u0005B\u0001\u000bq!\\1uG\",7\u000fF\u0002B\t>\u0003\"\u0001\u0007\"\n\u0005\rK\"a\u0002\"p_2,\u0017M\u001c\u0005\u0006\u000bz\u0002\rAR\u0001\u0006e\u0016<W\r\u001f\t\u0003\u000f6k\u0011\u0001\u0013\u0006\u0003\u000b&S!AS&\u0002\tU$\u0018\u000e\u001c\u0006\u0002\u0019\u0006!!.\u0019<b\u0013\tq\u0005JA\u0004QCR$XM\u001d8\t\u000bAs\u0004\u0019A\u001b\u0002\u0007M$(\u000fC\u0003S\u0001\u0011\u00053+\u0001\u0005u_N#(/\u001b8h)\u0005)\u0004\"B+\u0001\t#2\u0016!\u00033p\u000f\u0016t7i\u001c3f)\r9VL\u0019\t\u00031nk\u0011!\u0017\u0006\u00035\n\tqaY8eK\u001e,g.\u0003\u0002]3\nAQ\t\u001f9s\u0007>$W\rC\u0003_)\u0002\u0007q,A\u0002dib\u0004\"\u0001\u00171\n\u0005\u0005L&AD\"pI\u0016<WM\\\"p]R,\u0007\u0010\u001e\u0005\u0006GR\u0003\raV\u0001\u0003KZDq!\u001a\u0001\u0002\u0002\u0013\u0005a-\u0001\u0003d_BLHcA\u0018hQ\"9\u0011\u0005\u001aI\u0001\u0002\u0004\u0019\u0003bB\u0015e!\u0003\u0005\ra\t\u0005\bU\u0002\t\n\u0011\"\u0001l\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\u0012\u0001\u001c\u0016\u0003G5\\\u0013A\u001c\t\u0003_Rl\u0011\u0001\u001d\u0006\u0003cJ\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005ML\u0012AC1o]>$\u0018\r^5p]&\u0011Q\u000f\u001d\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007bB<\u0001#\u0003%\ta[\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u0011\u001dI\b!!A\u0005Bi\fQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DX#A>\u0011\u0005q|X\"A?\u000b\u0005y\\\u0015\u0001\u00027b]\u001eL!AO?\t\u0013\u0005\r\u0001!!A\u0005\u0002\u0005\u0015\u0011\u0001\u00049s_\u0012,8\r^!sSRLXCAA\u0004!\rA\u0012\u0011B\u0005\u0004\u0003\u0017I\"aA%oi\"I\u0011q\u0002\u0001\u0002\u0002\u0013\u0005\u0011\u0011C\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\t\u0019\"!\u0007\u0011\u0007a\t)\"C\u0002\u0002\u0018e\u00111!\u00118z\u0011)\tY\"!\u0004\u0002\u0002\u0003\u0007\u0011qA\u0001\u0004q\u0012\n\u0004\"CA\u0010\u0001\u0005\u0005I\u0011IA\u0011\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA\u0012!\u0019\t)#a\u000b\u0002\u00145\u0011\u0011q\u0005\u0006\u0004\u0003SI\u0012AC2pY2,7\r^5p]&!\u0011QFA\u0014\u0005!IE/\u001a:bi>\u0014\b\"CA\u0019\u0001\u0005\u0005I\u0011AA\u001a\u0003!\u0019\u0017M\\#rk\u0006dGcA!\u00026!Q\u00111DA\u0018\u0003\u0003\u0005\r!a\u0005\t\u0013\u0005e\u0002!!A\u0005B\u0005m\u0012AB3rk\u0006d7\u000fF\u0002B\u0003{A!\"a\u0007\u00028\u0005\u0005\t\u0019AA\nQ-\u0001\u0011\u0011IA$\u0003\u0013\ni%a\u0014\u0011\u0007E\t\u0019%C\u0002\u0002F\t\u0011Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002L\u0005Q7\u000f\u001e:!?\u001a+fjQ0!a\u0006$H/\u001a:oA5\u0002#+\u001a;ve:\u001c\b\u0005\u001e:vK\u0002Jg\rI:ue\u0002j\u0017\r^2iKN\u0004\u0003/\u0019;uKJtG\u0006\t8vY2\u0004\u0013N\u001a\u0011b]f\u0004\u0013M]4v[\u0016tGo\u001d\u0011be\u0016\u0004c.\u001e7mY\u00012\u0017\r\\:fA=$\b.\u001a:xSN,g&\u0001\u0005fqR,g\u000eZ3eC\t\t\t&\u0001D#\u0015\u0001\u0002\u0003\u0005I!sOVlWM\u001c;tu)\u0001\u0003\u0005\t\u0011!AM$(\u000fI\u0017!C\u0002\u001aHO]5oO\u0002*\u0007\u0010\u001d:fgNLwN\u001c\u0006!A\u0001\u0002\u0003\u0005\t9biR,'O\u001c\u0011.A\u0005\u00043\u000f\u001e:j]\u001e\u0004S\r\u001f9sKN\u001c\u0018n\u001c8/AQCW\r\t9biR,'O\u001c\u0011jg\u0002\n\u0007e\u001d;sS:<\u0007e\u001e5jG\"\u0004\u0013n\u001d\u0011nCR\u001c\u0007.\u001a3!Y&$XM]1mYfd\u0003e^5uQ*\u0001\u0003\u0005\t\u0011!A\u0001\u0002S\r_2faRLwN\u001c\u0011u_\u0002\"\b.\u001a\u0011g_2dwn^5oO\u0002\u001a\b/Z2jC2\u00043/_7c_2\u001c(H\u0003\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001z\u0006%\\1uG\",7\u000fI1os\u0002zg.\u001a\u0011dQ\u0006\u0014\u0018m\u0019;fe\u0002Jg\u000e\t;iK\u0002Jg\u000e];uA!\u001a\u0018.\\5mCJ\u0004Co\u001c\u0011/A%t\u0007\u0005]8tSb\u0004#/Z4vY\u0006\u0014\b%\u001a=qe\u0016\u001c8/[8og&R!\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!K\u0001j\u0017\r^2iKN\u0004#0\u001a:pA=\u0014\b%\\8sK\u0002\u001a\u0007.\u0019:bGR,'o\u001d\u0011j]\u0002\"\b.\u001a\u0011j]B,H\u000f\t\u0015tS6LG.\u0019:!i>\u0004cF\u000b\u0011j]\u0002\u0002xn]5yAI,w-\u001e7be*\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005I3yaJ,7o]5p]NL#B\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011UQ\u0016\u0004Sm]2ba\u0016\u00043\r[1sC\u000e$XM\u001d\u0011jg\u0002:Cl\n\u0018!\u0013\u001a\u0004\u0013M\u001c\u0011fg\u000e\f\u0007/\u001a\u0011dQ\u0006\u0014\u0018m\u0019;fe\u0002\u0002(/Z2fI\u0016\u001c\b%\u0019\u0011ta\u0016\u001c\u0017.\u00197!gfl'm\u001c7!_J\u0004\u0013M\\8uQ\u0016\u0014(\u0002\t\u0011!A\u0001\u0002\u0003\u0005I3tG\u0006\u0004X\rI2iCJ\f7\r^3sY\u0001\"\b.\u001a\u0011g_2dwn^5oO\u0002\u001a\u0007.\u0019:bGR,'\u000fI5tA5\fGo\u00195fI\u0002b\u0017\u000e^3sC2d\u0017P\f\u0011Ji\u0002J7\u000fI5om\u0006d\u0017\u000e\u001a\u0011u_\u0002*7oY1qK*\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0013M\\=!_RDWM\u001d\u0011dQ\u0006\u0014\u0018m\u0019;fe:R!\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI\u0014&'f\u001cH/Z7Ee&4X-\n/Vg\u0016\u00148\u000f\u0018&pQ:<\u0003e\u0018$V\u001d\u000e{\u0006e\n/&'f\u001cH/Z7Ee&4X\rX\u0013]9V\u001bXM]:&O)\u0001\u0003\u0005\t\u0011!AQ\u0014X/\u001a\u0006\u000bA\u0001\u0002\u0003eU3fA\u0005d7o\u001c\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011Vg\u0016\u0004#\u000bT%L\u000b\u0002\"x\u000eI7bi\u000eD\u0007e^5uQ\u0002\u001aH/\u00198eCJ$\u0007E]3hk2\f'\u000fI3yaJ,7o]5p]Nt#bB\u0005\u0002V\t\t\t\u0011#\u0001\u0002X\u0005!A*[6f!\r\t\u0012\u0011\f\u0004\t\u0003\t\t\t\u0011#\u0001\u0002\\M)\u0011\u0011LA/;A9\u0011qLA3G\rzSBAA1\u0015\r\t\u0019'G\u0001\beVtG/[7f\u0013\u0011\t9'!\u0019\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t'\u0007C\u0004.\u00033\"\t!a\u001b\u0015\u0005\u0005]\u0003\"\u0003*\u0002Z\u0005\u0005IQIA8)\u0005Y\bBCA:\u00033\n\t\u0011\"!\u0002v\u0005)\u0011\r\u001d9msR)q&a\u001e\u0002z!1\u0011%!\u001dA\u0002\rBa!KA9\u0001\u0004\u0019\u0003BCA?\u00033\n\t\u0011\"!\u0002\u0000\u00059QO\\1qa2LH\u0003BAA\u0003\u001b\u0003R\u0001GAB\u0003\u000fK1!!\"\u001a\u0005\u0019y\u0005\u000f^5p]B)\u0001$!#$G%\u0019\u00111R\r\u0003\rQ+\b\u000f\\33\u0011%\ty)a\u001f\u0002\u0002\u0003\u0007q&A\u0002yIAB!\"a%\u0002Z\u0005\u0005I\u0011BAK\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005]\u0005c\u0001?\u0002\u001a&\u0019\u00111T?\u0003\r=\u0013'.Z2u\u0001")
public class Like
extends BinaryExpression
implements StringRegexExpression,
Serializable {
    private final Expression left;
    private final Expression right;
    private final Pattern org$apache$spark$sql$catalyst$expressions$StringRegexExpression$$cache;
    private volatile boolean bitmap$0;

    public static Option<Tuple2<Expression, Expression>> unapply(Like like) {
        return Like$.MODULE$.unapply(like);
    }

    public static Function1<Tuple2<Expression, Expression>, Like> tupled() {
        return Like$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Like>> curried() {
        return Like$.MODULE$.curried();
    }

    private Pattern org$apache$spark$sql$catalyst$expressions$StringRegexExpression$$cache$lzycompute() {
        Like like = this;
        synchronized (like) {
            if (!this.bitmap$0) {
                this.org$apache$spark$sql$catalyst$expressions$StringRegexExpression$$cache = StringRegexExpression$class.org$apache$spark$sql$catalyst$expressions$StringRegexExpression$$cache(this);
                this.bitmap$0 = true;
            }
            return this.org$apache$spark$sql$catalyst$expressions$StringRegexExpression$$cache;
        }
    }

    @Override
    public Pattern org$apache$spark$sql$catalyst$expressions$StringRegexExpression$$cache() {
        return this.bitmap$0 ? this.org$apache$spark$sql$catalyst$expressions$StringRegexExpression$$cache : this.org$apache$spark$sql$catalyst$expressions$StringRegexExpression$$cache$lzycompute();
    }

    @Override
    public DataType dataType() {
        return StringRegexExpression$class.dataType(this);
    }

    @Override
    public Seq<DataType> inputTypes() {
        return StringRegexExpression$class.inputTypes(this);
    }

    @Override
    public Pattern compile(String str) {
        return StringRegexExpression$class.compile(this, str);
    }

    @Override
    public Pattern pattern(String str) {
        return StringRegexExpression$class.pattern(this, str);
    }

    @Override
    public Object nullSafeEval(Object input1, Object input2) {
        return StringRegexExpression$class.nullSafeEval(this, input1, input2);
    }

    @Override
    public String sql() {
        return StringRegexExpression$class.sql(this);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes$class.checkInputDataTypes(this);
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public String escape(String v) {
        return StringUtils$.MODULE$.escapeLikeRegex(v);
    }

    @Override
    public boolean matches(Pattern regex, String str) {
        return regex.matcher(str).matches();
    }

    @Override
    public String toString() {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " LIKE ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.left(), this.right()}));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode exprCode;
        String patternClass = Pattern.class.getName();
        String escapeFunc = new StringBuilder().append((Object)new StringOps(Predef$.MODULE$.augmentString(StringUtils$.MODULE$.getClass().getName())).stripSuffix("$")).append((Object)".escapeLikeRegex").toString();
        String pattern = ctx.freshName("pattern");
        if (this.right().foldable()) {
            Object rVal = this.right().eval(this.right().eval$default$1());
            if (rVal == null) {
                exprCode = ev.copy(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n          boolean ", " = true;\n          ", " ", " = ", ";\n        "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), ctx.javaType(this.dataType()), ev.value(), ctx.defaultValue(this.dataType())})), ev.copy$default$2(), ev.copy$default$3());
            } else {
                String regexStr = StringEscapeUtils.escapeJava((String)this.escape(((UTF8String)rVal).toString()));
                ctx.addMutableState(patternClass, pattern, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = ", ".compile(\"", "\");"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{pattern, patternClass, regexStr})));
                ExprCode eval2 = this.left().genCode(ctx);
                exprCode = ev.copy(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n          ", "\n          boolean ", " = ", ";\n          ", " ", " = ", ";\n          if (!", ") {\n            ", " = ", ".matcher(", ".toString()).matches();\n          }\n        "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{eval2.code(), ev.isNull(), eval2.isNull(), ctx.javaType(this.dataType()), ev.value(), ctx.defaultValue(this.dataType()), ev.isNull(), ev.value(), pattern, eval2.value()})), ev.copy$default$2(), ev.copy$default$3());
            }
        } else {
            String rightStr = ctx.freshName("rightStr");
            exprCode = this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)new Serializable(this, ev, patternClass, escapeFunc, pattern, rightStr){
                public static final long serialVersionUID = 0L;
                private final ExprCode ev$1;
                private final String patternClass$1;
                private final String escapeFunc$1;
                private final String pattern$1;
                private final String rightStr$1;

                public final String apply(String eval1, String eval2) {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n          String ", " = ", ".toString();\n          ", " ", " = ", ".compile(", "(", "));\n          ", " = ", ".matcher(", ".toString()).matches();\n        "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.rightStr$1, eval2, this.patternClass$1, this.pattern$1, this.patternClass$1, this.escapeFunc$1, this.rightStr$1, this.ev$1.value(), this.pattern$1, eval1}));
                }
                {
                    this.ev$1 = ev$1;
                    this.patternClass$1 = patternClass$1;
                    this.escapeFunc$1 = escapeFunc$1;
                    this.pattern$1 = pattern$1;
                    this.rightStr$1 = rightStr$1;
                }
            });
        }
        return exprCode;
    }

    public Like copy(Expression left, Expression right) {
        return new Like(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "Like";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 1: {
                expression = this.right();
                break;
            }
            case 0: {
                expression = this.left();
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Like;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Like)) return false;
        boolean bl = true;
        if (!bl) return false;
        Like like = (Like)x$1;
        Expression expression = this.left();
        Expression expression2 = like.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = like.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!like.canEqual(this)) return false;
        return true;
    }

    public Like(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        ExpectsInputTypes$class.$init$(this);
        StringRegexExpression$class.$init$(this);
    }
}

