/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import java.util.Arrays;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.XxHash64Function$;
import org.apache.spark.sql.catalyst.expressions.aggregate.HyperLogLogPlusPlus$;
import org.apache.spark.sql.catalyst.expressions.aggregate.ImperativeAggregate;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(expr[, relativeSD]) - Returns the estimated cardinality by HyperLogLog++.\n      `relativeSD` defines the maximum estimation error allowed.\n  ")
@ScalaSignature(bytes="\u0006\u0001\t=g\u0001B\u0001\u0003\u0001F\u00111\u0003S=qKJdun\u001a'pOBcWo\u001d)mkNT!a\u0001\u0003\u0002\u0013\u0005<wM]3hCR,'BA\u0003\u0007\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005\u001dA\u0011\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005%Q\u0011aA:rY*\u00111\u0002D\u0001\u0006gB\f'o\u001b\u0006\u0003\u001b9\ta!\u00199bG\",'\"A\b\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001\u0011b\u0003\b\t\u0003'Qi\u0011AA\u0005\u0003+\t\u00111#S7qKJ\fG/\u001b<f\u0003\u001e<'/Z4bi\u0016\u0004\"a\u0006\u000e\u000e\u0003aQ\u0011!G\u0001\u0006g\u000e\fG.Y\u0005\u00037a\u0011q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002\u0018;%\u0011a\u0004\u0007\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\tA\u0001\u0011)\u001a!C\u0001C\u0005)1\r[5mIV\t!\u0005\u0005\u0002$I5\tA!\u0003\u0002&\t\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\t\u0011\u001d\u0002!\u0011#Q\u0001\n\t\naa\u00195jY\u0012\u0004\u0003\u0002C\u0015\u0001\u0005+\u0007I\u0011\u0001\u0016\u0002\u0015I,G.\u0019;jm\u0016\u001cF)F\u0001,!\t9B&\u0003\u0002.1\t1Ai\\;cY\u0016D\u0001b\f\u0001\u0003\u0012\u0003\u0006IaK\u0001\fe\u0016d\u0017\r^5wKN#\u0005\u0005\u0003\u00052\u0001\tU\r\u0011\"\u00013\u0003YiW\u000f^1cY\u0016\fum\u001a\"vM\u001a,'o\u00144gg\u0016$X#A\u001a\u0011\u0005]!\u0014BA\u001b\u0019\u0005\rIe\u000e\u001e\u0005\to\u0001\u0011\t\u0012)A\u0005g\u00059R.\u001e;bE2,\u0017iZ4Ck\u001a4WM](gMN,G\u000f\t\u0005\ts\u0001\u0011)\u001a!C\u0001e\u0005!\u0012N\u001c9vi\u0006;wMQ;gM\u0016\u0014xJ\u001a4tKRD\u0001b\u000f\u0001\u0003\u0012\u0003\u0006IaM\u0001\u0016S:\u0004X\u000f^!hO\n+hMZ3s\u001f\u001a47/\u001a;!\u0011\u0015i\u0004\u0001\"\u0001?\u0003\u0019a\u0014N\\5u}Q)q\bQ!C\u0007B\u00111\u0003\u0001\u0005\u0006Aq\u0002\rA\t\u0005\bSq\u0002\n\u00111\u0001,\u0011\u001d\tD\b%AA\u0002MBq!\u000f\u001f\u0011\u0002\u0003\u00071\u0007C\u0003>\u0001\u0011\u0005Q\t\u0006\u0002@\r\")\u0001\u0005\u0012a\u0001E!)Q\b\u0001C\u0001\u0011R\u0019q(\u0013&\t\u000b\u0001:\u0005\u0019\u0001\u0012\t\u000b%:\u0005\u0019\u0001\u0012\t\u000b1\u0003A\u0011I'\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-F\u0001O!\ty%K\u0004\u0002\u0018!&\u0011\u0011\u000bG\u0001\u0007!J,G-\u001a4\n\u0005M#&AB*ue&twM\u0003\u0002R1!)a\u000b\u0001C!/\u0006ir/\u001b;i\u001d\u0016<X*\u001e;bE2,\u0017iZ4Ck\u001a4WM](gMN,G\u000f\u0006\u0002\u00131\")\u0011,\u0016a\u0001g\u0005Ib.Z<NkR\f'\r\\3BO\u001e\u0014UO\u001a4fe>3gm]3u\u0011\u0015Y\u0006\u0001\"\u0011]\u0003m9\u0018\u000e\u001e5OK^Le\u000e];u\u0003\u001e<')\u001e4gKJ|eMZ:fiR\u0011!#\u0018\u0005\u0006=j\u0003\raM\u0001\u0018]\u0016<\u0018J\u001c9vi\u0006;wMQ;gM\u0016\u0014xJ\u001a4tKRDA\u0002\u0019\u0001\u0005\u0002\u0003\u0015\t\u0011!Q\u0001\nM\n!j\u001c:hI\u0005\u0004\u0018m\u00195fIM\u0004\u0018M]6%gFdGeY1uC2L8\u000f\u001e\u0013fqB\u0014Xm]:j_:\u001cH%Y4he\u0016<\u0017\r^3%\u0011f\u0004XM\u001d'pO2{w\r\u00157vgBcWo\u001d\u0013%a\"1!\r\u0001Q\u0001\nM\n\u0001\"\u001b3y'\"Lg\r\u001e\u0005\u0007I\u0002\u0001\u000b\u0011B3\u0002\u0011]\u0004\u0016\r\u001a3j]\u001e\u0004\"a\u00064\n\u0005\u001dD\"\u0001\u0002'p]\u001eDA\"\u001b\u0001\u0005\u0002\u0003\u0015\t\u0011!Q\u0001\nM\n!j\u001c:hI\u0005\u0004\u0018m\u00195fIM\u0004\u0018M]6%gFdGeY1uC2L8\u000f\u001e\u0013fqB\u0014Xm]:j_:\u001cH%Y4he\u0016<\u0017\r^3%\u0011f\u0004XM\u001d'pO2{w\r\u00157vgBcWo\u001d\u0013%[\"11\u000e\u0001Q\u0001\n-\nq!\u00197qQ\u0006l%\u0007\u0003\u0004n\u0001\u0001\u0006IaM\u0001\t]Vlwk\u001c:eg\")q\u000e\u0001C!a\u0006A1\r[5mIJ,g.F\u0001r!\r\u0011(P\t\b\u0003gbt!\u0001^<\u000e\u0003UT!A\u001e\t\u0002\rq\u0012xn\u001c;?\u0013\u0005I\u0012BA=\u0019\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u001f?\u0003\u0007M+\u0017O\u0003\u0002z1!)a\u0010\u0001C!\u007f\u0006Aa.\u001e7mC\ndW-\u0006\u0002\u0002\u0002A\u0019q#a\u0001\n\u0007\u0005\u0015\u0001DA\u0004C_>dW-\u00198\t\u000f\u0005%\u0001\u0001\"\u0011\u0002\f\u0005AA-\u0019;b)f\u0004X-\u0006\u0002\u0002\u000eA!\u0011qBA\u000b\u001b\t\t\tBC\u0002\u0002\u0014!\tQ\u0001^=qKNLA!a\u0006\u0002\u0012\tAA)\u0019;b)f\u0004X\rC\u0004\u0002\u001c\u0001!\t%!\b\u0002\u001f\u0005<wMQ;gM\u0016\u00148k\u00195f[\u0006,\"!a\b\u0011\t\u0005=\u0011\u0011E\u0005\u0005\u0003G\t\tB\u0001\u0006TiJ,8\r\u001e+za\u0016D\u0011\"a\n\u0001\u0005\u0004%\t%!\u000b\u0002'\u0005<wMQ;gM\u0016\u0014\u0018\t\u001e;sS\n,H/Z:\u0016\u0005\u0005-\u0002\u0003\u0002:{\u0003[\u00012aIA\u0018\u0013\r\t\t\u0004\u0002\u0002\u0013\u0003R$(/\u001b2vi\u0016\u0014VMZ3sK:\u001cW\r\u0003\u0005\u00026\u0001\u0001\u000b\u0011BA\u0016\u0003Q\twm\u001a\"vM\u001a,'/\u0011;ue&\u0014W\u000f^3tA!I\u0011\u0011\b\u0001C\u0002\u0013\u0005\u0013\u0011F\u0001\u0019S:\u0004X\u000f^!hO\n+hMZ3s\u0003R$(/\u001b2vi\u0016\u001c\b\u0002CA\u001f\u0001\u0001\u0006I!a\u000b\u00023%t\u0007/\u001e;BO\u001e\u0014UO\u001a4fe\u0006#HO]5ckR,7\u000f\t\u0005\b\u0003\u0003\u0002A\u0011IA\"\u0003)Ig.\u001b;jC2L'0\u001a\u000b\u0005\u0003\u000b\nY\u0005E\u0002\u0018\u0003\u000fJ1!!\u0013\u0019\u0005\u0011)f.\u001b;\t\u0011\u00055\u0013q\ba\u0001\u0003\u001f\naAY;gM\u0016\u0014\b\u0003BA)\u0003'j\u0011AB\u0005\u0004\u0003+2!aC%oi\u0016\u0014h.\u00197S_^Dq!!\u0017\u0001\t\u0003\nY&\u0001\u0004va\u0012\fG/\u001a\u000b\u0007\u0003\u000b\ni&a\u0018\t\u0011\u00055\u0013q\u000ba\u0001\u0003\u001fB\u0001\"!\u0019\u0002X\u0001\u0007\u0011qJ\u0001\u0006S:\u0004X\u000f\u001e\u0005\b\u0003K\u0002A\u0011IA4\u0003\u0015iWM]4f)\u0019\t)%!\u001b\u0002n!A\u00111NA2\u0001\u0004\ty%A\u0004ck\u001a4WM]\u0019\t\u0011\u0005=\u00141\ra\u0001\u0003\u001f\nqAY;gM\u0016\u0014(\u0007C\u0004\u0002t\u0001!\t!!\u001e\u0002\u0019\u0015\u001cH/[7bi\u0016\u0014\u0015.Y:\u0015\u0007-\n9\bC\u0004\u0002z\u0005E\u0004\u0019A\u0016\u0002\u0003\u0015Dq!! \u0001\t\u0003\ny(\u0001\u0003fm\u0006dG\u0003BAA\u0003\u000f\u00032aFAB\u0013\r\t)\t\u0007\u0002\u0004\u0003:L\bBCA'\u0003w\u0002\n\u00111\u0001\u0002P!1\u00111\u0012\u0001\u0005\u0002)\nq\u0001\u001e:vKJ\u001bH\rC\u0005\u0002\u0010\u0002\t\t\u0011\"\u0001\u0002\u0012\u0006!1m\u001c9z)%y\u00141SAK\u0003/\u000bI\n\u0003\u0005!\u0003\u001b\u0003\n\u00111\u0001#\u0011!I\u0013Q\u0012I\u0001\u0002\u0004Y\u0003\u0002C\u0019\u0002\u000eB\u0005\t\u0019A\u001a\t\u0011e\ni\t%AA\u0002MB\u0011\"!(\u0001#\u0003%\t!a(\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011\u0011\u0015\u0016\u0004E\u0005\r6FAAS!\u0011\t9+!-\u000e\u0005\u0005%&\u0002BAV\u0003[\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005=\u0006$\u0001\u0006b]:|G/\u0019;j_:LA!a-\u0002*\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0013\u0005]\u0006!%A\u0005\u0002\u0005e\u0016AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0003wS3aKAR\u0011%\ty\fAI\u0001\n\u0003\t\t-\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005\r'fA\u001a\u0002$\"I\u0011q\u0019\u0001\u0012\u0002\u0013\u0005\u0011\u0011Y\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00135\u0011%\tY\rAA\u0001\n\u0003\ni-A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003\u001f\u0004B!!5\u0002\\6\u0011\u00111\u001b\u0006\u0005\u0003+\f9.\u0001\u0003mC:<'BAAm\u0003\u0011Q\u0017M^1\n\u0007M\u000b\u0019\u000e\u0003\u0005\u0002`\u0002\t\t\u0011\"\u00013\u00031\u0001(o\u001c3vGR\f%/\u001b;z\u0011%\t\u0019\u000fAA\u0001\n\u0003\t)/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005\u0005\u0015q\u001d\u0005\n\u0003S\f\t/!AA\u0002M\n1\u0001\u001f\u00132\u0011%\ti\u000fAA\u0001\n\u0003\ny/A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t\t\u0010\u0005\u0004\u0002t\u0006e\u0018\u0011Q\u0007\u0003\u0003kT1!a>\u0019\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003w\f)P\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0011%\ty\u0010AA\u0001\n\u0003\u0011\t!\u0001\u0005dC:,\u0015/^1m)\u0011\t\tAa\u0001\t\u0015\u0005%\u0018Q`A\u0001\u0002\u0004\t\t\tC\u0005\u0003\b\u0001\t\t\u0011\"\u0011\u0003\n\u00051Q-];bYN$B!!\u0001\u0003\f!Q\u0011\u0011\u001eB\u0003\u0003\u0003\u0005\r!!!)\u000f\u0001\u0011yA!\u0006\u0003\u0018A\u00191E!\u0005\n\u0007\tMAAA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\te\u0011!a\r\u000bA\u0001\u0002\u0003e\u0018$V\u001d\u000e{\u0006&\u001a=qenc\u0003E]3mCRLg/Z*E;&\u0002S\u0006\t*fiV\u0014hn\u001d\u0011uQ\u0016\u0004Sm\u001d;j[\u0006$X\r\u001a\u0011dCJ$\u0017N\\1mSRL\bEY=!\u0011f\u0004XM\u001d'pO2{wmK\u0016/\u0015\u0001\u0002\u0003\u0005\t\u0011!AJ,G.\u0019;jm\u0016\u001cF\t\u0019\u0011eK\u001aLg.Z:!i\",\u0007%\\1yS6,X\u000eI3ti&l\u0017\r^5p]\u0002*'O]8sA\u0005dGn\\<fI:R\u0001\u0005I\u0004\b\u0005;\u0011\u0001\u0012\u0001B\u0010\u0003MA\u0015\u0010]3s\u0019><Gj\\4QYV\u001c\b\u000b\\;t!\r\u0019\"\u0011\u0005\u0004\u0007\u0003\tA\tAa\t\u0014\u000b\t\u0005\"Q\u0005\u000f\u0011\u0007]\u00119#C\u0002\u0003*a\u0011a!\u00118z%\u00164\u0007bB\u001f\u0003\"\u0011\u0005!Q\u0006\u000b\u0003\u0005?A\u0011B!\r\u0003\"\t\u0007I\u0011\u0001\u001a\u0002\u0013]{%\u000bR0T\u0013j+\u0005\u0002\u0003B\u001b\u0005C\u0001\u000b\u0011B\u001a\u0002\u0015]{%\u000bR0T\u0013j+\u0005\u0005C\u0005\u0003:\t\u0005\"\u0019!C\u0001e\u0005i!+R$J'R+%kX*J5\u0016C\u0001B!\u0010\u0003\"\u0001\u0006IaM\u0001\u000f%\u0016;\u0015j\u0015+F%~\u001b\u0016JW#!\u0011)\u0011\tE!\tC\u0002\u0013\u0005!1I\u0001\u0013%\u0016;\u0015j\u0015+F%~;vJ\u0015#`\u001b\u0006\u001b6*F\u0001f\u0011!\u00119E!\t!\u0002\u0013)\u0017a\u0005*F\u000f&\u001bF+\u0012*`/>\u0013FiX'B'.\u0003\u0003\"\u0003B&\u0005C\u0011\r\u0011\"\u00013\u0003I\u0011ViR%T)\u0016\u00136k\u0018)F%~;vJ\u0015#\t\u0011\t=#\u0011\u0005Q\u0001\nM\n1CU#H\u0013N#VIU*`!\u0016\u0013vlV(S\t\u0002B\u0011Ba\u0015\u0003\"\t\u0007I\u0011\u0001\u001a\u0002\u0003-C\u0001Ba\u0016\u0003\"\u0001\u0006IaM\u0001\u0003\u0017\u0002B!Ba\u0017\u0003\"\t\u0007I\u0011\u0001B/\u0003)!\u0006JU#T\u0011>cEiU\u000b\u0003\u0005?\u0002Ba\u0006B1W%\u0019!1\r\r\u0003\u000b\u0005\u0013(/Y=\t\u0013\t\u001d$\u0011\u0005Q\u0001\n\t}\u0013a\u0003+I%\u0016\u001b\u0006j\u0014'E'\u0002B!Ba\u001b\u0003\"\t\u0007I\u0011\u0001B7\u0003E\u0011\u0016iV0F'RKU*\u0011+F?\u0012\u000bE+Q\u000b\u0003\u0005_\u0002Ra\u0006B1\u0005?B\u0011Ba\u001d\u0003\"\u0001\u0006IAa\u001c\u0002%I\u000bukX#T)&k\u0015\tV#`\t\u0006#\u0016\t\t\u0005\u000b\u0005o\u0012\tC1A\u0005\u0002\t5\u0014!\u0003\"J\u0003N{F)\u0011+B\u0011%\u0011YH!\t!\u0002\u0013\u0011y'\u0001\u0006C\u0013\u0006\u001bv\fR!U\u0003\u0002B\u0001Ba \u0003\"\u0011%!\u0011Q\u0001\u0016m\u0006d\u0017\u000eZ1uK\u0012{WO\u00197f\u0019&$XM]1m)\rY#1\u0011\u0005\b\u0005\u000b\u0013i\b1\u0001#\u0003\r)\u0007\u0010\u001d\u0005\u000b\u0005\u0013\u0013\t#!A\u0005\u0002\n-\u0015!B1qa2LH#C \u0003\u000e\n=%\u0011\u0013BJ\u0011\u0019\u0001#q\u0011a\u0001E!A\u0011Fa\"\u0011\u0002\u0003\u00071\u0006\u0003\u00052\u0005\u000f\u0003\n\u00111\u00014\u0011!I$q\u0011I\u0001\u0002\u0004\u0019\u0004B\u0003BL\u0005C\t\t\u0011\"!\u0003\u001a\u00069QO\\1qa2LH\u0003\u0002BN\u0005O\u0003Ra\u0006BO\u0005CK1Aa(\u0019\u0005\u0019y\u0005\u000f^5p]B9qCa)#WM\u001a\u0014b\u0001BS1\t1A+\u001e9mKRB\u0011B!+\u0003\u0016\u0006\u0005\t\u0019A \u0002\u0007a$\u0003\u0007\u0003\u0006\u0003.\n\u0005\u0012\u0013!C\u0001\u0003s\u000bq\"\u00199qYf$C-\u001a4bk2$HE\r\u0005\u000b\u0005c\u0013\t#%A\u0005\u0002\u0005\u0005\u0017aD1qa2LH\u0005Z3gCVdG\u000fJ\u001a\t\u0015\tU&\u0011EI\u0001\n\u0003\t\t-A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00135\u0011)\u0011IL!\t\u0012\u0002\u0013\u0005\u0011\u0011X\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\t\u0015\tu&\u0011EI\u0001\n\u0003\t\t-A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$He\r\u0005\u000b\u0005\u0003\u0014\t#%A\u0005\u0002\u0005\u0005\u0017a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$C\u0007\u0003\u0006\u0003F\n\u0005\u0012\u0011!C\u0005\u0005\u000f\f1B]3bIJ+7o\u001c7wKR\u0011!\u0011\u001a\t\u0005\u0003#\u0014Y-\u0003\u0003\u0003N\u0006M'AB(cU\u0016\u001cG\u000f")
public class HyperLogLogPlusPlus
extends ImperativeAggregate
implements Serializable {
    private final Expression child;
    private final double relativeSD;
    private final int mutableAggBufferOffset;
    private final int inputAggBufferOffset;
    public final int org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$p;
    private final int idxShift;
    private final long wPadding;
    public final int org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m;
    private final double alphaM2;
    private final int numWords;
    private final Seq<AttributeReference> aggBufferAttributes;
    private final Seq<AttributeReference> inputAggBufferAttributes;

    public static int $lessinit$greater$default$4() {
        return HyperLogLogPlusPlus$.MODULE$.$lessinit$greater$default$4();
    }

    public static int $lessinit$greater$default$3() {
        return HyperLogLogPlusPlus$.MODULE$.$lessinit$greater$default$3();
    }

    public static double $lessinit$greater$default$2() {
        return HyperLogLogPlusPlus$.MODULE$.$lessinit$greater$default$2();
    }

    public static int apply$default$4() {
        return HyperLogLogPlusPlus$.MODULE$.apply$default$4();
    }

    public static int apply$default$3() {
        return HyperLogLogPlusPlus$.MODULE$.apply$default$3();
    }

    public static double apply$default$2() {
        return HyperLogLogPlusPlus$.MODULE$.apply$default$2();
    }

    public static Option<Tuple4<Expression, Object, Object, Object>> unapply(HyperLogLogPlusPlus hyperLogLogPlusPlus) {
        return HyperLogLogPlusPlus$.MODULE$.unapply(hyperLogLogPlusPlus);
    }

    public static double[][] BIAS_DATA() {
        return HyperLogLogPlusPlus$.MODULE$.BIAS_DATA();
    }

    public static double[][] RAW_ESTIMATE_DATA() {
        return HyperLogLogPlusPlus$.MODULE$.RAW_ESTIMATE_DATA();
    }

    public static double[] THRESHOLDS() {
        return HyperLogLogPlusPlus$.MODULE$.THRESHOLDS();
    }

    public static int K() {
        return HyperLogLogPlusPlus$.MODULE$.K();
    }

    public static int REGISTERS_PER_WORD() {
        return HyperLogLogPlusPlus$.MODULE$.REGISTERS_PER_WORD();
    }

    public static long REGISTER_WORD_MASK() {
        return HyperLogLogPlusPlus$.MODULE$.REGISTER_WORD_MASK();
    }

    public static int REGISTER_SIZE() {
        return HyperLogLogPlusPlus$.MODULE$.REGISTER_SIZE();
    }

    public static int WORD_SIZE() {
        return HyperLogLogPlusPlus$.MODULE$.WORD_SIZE();
    }

    public Expression child() {
        return this.child;
    }

    public double relativeSD() {
        return this.relativeSD;
    }

    @Override
    public int mutableAggBufferOffset() {
        return this.mutableAggBufferOffset;
    }

    @Override
    public int inputAggBufferOffset() {
        return this.inputAggBufferOffset;
    }

    @Override
    public String prettyName() {
        return "approx_count_distinct";
    }

    @Override
    public ImperativeAggregate withNewMutableAggBufferOffset(int newMutableAggBufferOffset) {
        int x$2 = newMutableAggBufferOffset;
        Expression x$3 = this.copy$default$1();
        double x$4 = this.copy$default$2();
        int x$5 = this.copy$default$4();
        return this.copy(x$3, x$4, x$2, x$5);
    }

    @Override
    public ImperativeAggregate withNewInputAggBufferOffset(int newInputAggBufferOffset) {
        int x$6 = newInputAggBufferOffset;
        Expression x$7 = this.copy$default$1();
        double x$8 = this.copy$default$2();
        int x$9 = this.copy$default$3();
        return this.copy(x$7, x$8, x$9, x$6);
    }

    @Override
    public Seq<Expression> children() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.child()}));
    }

    @Override
    public boolean nullable() {
        return false;
    }

    @Override
    public DataType dataType() {
        return LongType$.MODULE$;
    }

    @Override
    public StructType aggBufferSchema() {
        return StructType$.MODULE$.fromAttributes(this.aggBufferAttributes());
    }

    @Override
    public Seq<AttributeReference> aggBufferAttributes() {
        return this.aggBufferAttributes;
    }

    @Override
    public Seq<AttributeReference> inputAggBufferAttributes() {
        return this.inputAggBufferAttributes;
    }

    @Override
    public void initialize(InternalRow buffer) {
        for (int word = 0; word < this.numWords; ++word) {
            buffer.setLong(this.mutableAggBufferOffset() + word, 0L);
        }
    }

    @Override
    public void update(InternalRow buffer, InternalRow input) {
        Object v = this.child().eval(input);
        if (v != null) {
            long x = XxHash64Function$.MODULE$.hash(v, this.child().dataType(), 42L);
            int idx = (int)(x >>> this.idxShift);
            long pw = (long)Long.numberOfLeadingZeros(x << this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$p | this.wPadding) + 1L;
            int wordOffset = idx / HyperLogLogPlusPlus$.MODULE$.REGISTERS_PER_WORD();
            long word = buffer.getLong(this.mutableAggBufferOffset() + wordOffset);
            int shift = HyperLogLogPlusPlus$.MODULE$.REGISTER_SIZE() * (idx - wordOffset * HyperLogLogPlusPlus$.MODULE$.REGISTERS_PER_WORD());
            long mask = HyperLogLogPlusPlus$.MODULE$.REGISTER_WORD_MASK() << shift;
            long Midx = (word & mask) >>> shift;
            if (pw > Midx) {
                buffer.setLong(this.mutableAggBufferOffset() + wordOffset, word & (mask ^ 0xFFFFFFFFFFFFFFFFL) | pw << shift);
            }
        }
    }

    @Override
    public void merge(InternalRow buffer1, InternalRow buffer2) {
        int idx = 0;
        for (int wordOffset = 0; wordOffset < this.numWords; ++wordOffset) {
            long word1 = buffer1.getLong(this.mutableAggBufferOffset() + wordOffset);
            long word2 = buffer2.getLong(this.inputAggBufferOffset() + wordOffset);
            long word = 0L;
            long mask = HyperLogLogPlusPlus$.MODULE$.REGISTER_WORD_MASK();
            for (int i = 0; idx < this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m && i < HyperLogLogPlusPlus$.MODULE$.REGISTERS_PER_WORD(); ++i, ++idx) {
                word |= Math.max(word1 & mask, word2 & mask);
                mask <<= HyperLogLogPlusPlus$.MODULE$.REGISTER_SIZE();
            }
            buffer1.setLong(this.mutableAggBufferOffset() + wordOffset, word);
        }
    }

    public double estimateBias(double e) {
        int high;
        double[] estimates = HyperLogLogPlusPlus$.MODULE$.RAW_ESTIMATE_DATA()[this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$p - 4];
        int numEstimates = estimates.length;
        int n = Arrays.binarySearch(estimates, 0, numEstimates, e);
        switch (n) {
            default: 
        }
        int nearestEstimateIndex = n < 0 ? -(n + 1) : n;
        int low = package$.MODULE$.max(nearestEstimateIndex - HyperLogLogPlusPlus$.MODULE$.K() + 1, 0);
        for (high = package$.MODULE$.min(low + HyperLogLogPlusPlus$.MODULE$.K(), numEstimates); high < numEstimates && this.distance$1(high, e, estimates) < this.distance$1(low, e, estimates); ++high) {
            ++low;
        }
        double[] biases = HyperLogLogPlusPlus$.MODULE$.BIAS_DATA()[this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$p - 4];
        double biasSum = 0.0;
        for (int i = low; i < high; ++i) {
            biasSum += biases[i];
        }
        return biasSum / (double)(high - low);
    }

    @Override
    public Object eval(InternalRow buffer) {
        double d;
        double zInverse = 0.0;
        double V = 0.0;
        int idx = 0;
        for (int wordOffset = 0; wordOffset < this.numWords; ++wordOffset) {
            long word = buffer.getLong(this.mutableAggBufferOffset() + wordOffset);
            int shift = 0;
            for (int i = 0; idx < this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m && i < HyperLogLogPlusPlus$.MODULE$.REGISTERS_PER_WORD(); ++i, ++idx) {
                long Midx = word >>> shift & HyperLogLogPlusPlus$.MODULE$.REGISTER_WORD_MASK();
                zInverse += 1.0 / (double)(1L << (int)Midx);
                if (Midx == 0L) {
                    V += 1.0;
                }
                shift += HyperLogLogPlusPlus$.MODULE$.REGISTER_SIZE();
            }
        }
        double E = this.alphaM2 / zInverse;
        if (V > 0.0) {
            double H = (double)this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m * Math.log((double)this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m / V);
            d = this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$p < 19 && H <= HyperLogLogPlusPlus$.MODULE$.THRESHOLDS()[this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$p - 4] || E <= 2.5 * (double)this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m ? H : this.EBiasCorrected$1(E);
        } else {
            d = this.EBiasCorrected$1(E);
        }
        double estimate2 = d;
        return BoxesRunTime.boxToLong((long)Math.round(estimate2));
    }

    public double trueRsd() {
        return 1.04 / package$.MODULE$.sqrt((double)this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m);
    }

    public HyperLogLogPlusPlus copy(Expression child, double relativeSD, int mutableAggBufferOffset, int inputAggBufferOffset) {
        return new HyperLogLogPlusPlus(child, relativeSD, mutableAggBufferOffset, inputAggBufferOffset);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public double copy$default$2() {
        return this.relativeSD();
    }

    public int copy$default$3() {
        return this.mutableAggBufferOffset();
    }

    public int copy$default$4() {
        return this.inputAggBufferOffset();
    }

    @Override
    public String productPrefix() {
        return "HyperLogLogPlusPlus";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 3: {
                object = BoxesRunTime.boxToInteger((int)this.inputAggBufferOffset());
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToInteger((int)this.mutableAggBufferOffset());
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToDouble((double)this.relativeSD());
                break;
            }
            case 0: {
                object = this.child();
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof HyperLogLogPlusPlus;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof HyperLogLogPlusPlus)) return false;
        boolean bl = true;
        if (!bl) return false;
        HyperLogLogPlusPlus hyperLogLogPlusPlus = (HyperLogLogPlusPlus)x$1;
        Expression expression = this.child();
        Expression expression2 = hyperLogLogPlusPlus.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (this.relativeSD() != hyperLogLogPlusPlus.relativeSD()) return false;
        if (this.mutableAggBufferOffset() != hyperLogLogPlusPlus.mutableAggBufferOffset()) return false;
        if (this.inputAggBufferOffset() != hyperLogLogPlusPlus.inputAggBufferOffset()) return false;
        if (!hyperLogLogPlusPlus.canEqual(this)) return false;
        return true;
    }

    private final double distance$1(int i, double e$1, double[] estimates$1) {
        double diff = e$1 - estimates$1[i];
        return diff * diff;
    }

    private final double EBiasCorrected$1(double E$1) {
        double d = E$1;
        double d2 = this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$p < 19 && d < 5.0 * (double)this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m ? d - this.estimateBias(d) : d;
        return d2;
    }

    public HyperLogLogPlusPlus(Expression child, double relativeSD, int mutableAggBufferOffset, int inputAggBufferOffset) {
        double d;
        this.child = child;
        this.relativeSD = relativeSD;
        this.mutableAggBufferOffset = mutableAggBufferOffset;
        this.inputAggBufferOffset = inputAggBufferOffset;
        this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$p = (int)Math.ceil(2.0 * Math.log(1.106 / relativeSD) / Math.log(2.0));
        Predef$.MODULE$.require(this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$p >= 4, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "HLL++ requires at least 4 bits for addressing. Use a lower error, at most 39%.";
            }
        });
        this.idxShift = 64 - this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$p;
        this.wPadding = 1L << this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$p - 1;
        this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m = 1 << this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$p;
        int n = this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$p;
        switch (n) {
            default: {
                d = 0.7213 / (1.0 + 1.079 / (double)this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m) * (double)this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m * (double)this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m;
                break;
            }
            case 6: {
                d = 0.709 * (double)this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m * (double)this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m;
                break;
            }
            case 5: {
                d = 0.697 * (double)this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m * (double)this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m;
                break;
            }
            case 4: {
                d = 0.673 * (double)this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m * (double)this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m;
            }
        }
        this.alphaM2 = d;
        this.numWords = this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m / HyperLogLogPlusPlus$.MODULE$.REGISTERS_PER_WORD() + 1;
        this.aggBufferAttributes = (Seq)Seq$.MODULE$.tabulate(this.numWords, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final AttributeReference apply(int i) {
                String x$10 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"MS[", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)}));
                LongType$ x$11 = LongType$.MODULE$;
                boolean x$12 = AttributeReference$.MODULE$.apply$default$3();
                Metadata x$13 = AttributeReference$.MODULE$.apply$default$4();
                ExprId x$14 = AttributeReference$.MODULE$.apply$default$5(x$10, x$11, x$12, x$13);
                Option<String> x$15 = AttributeReference$.MODULE$.apply$default$6(x$10, x$11, x$12, x$13);
                Boolean x$16 = AttributeReference$.MODULE$.apply$default$7(x$10, x$11, x$12, x$13);
                return new AttributeReference(x$10, x$11, x$12, x$13, x$14, x$15, x$16);
            }
        });
        this.inputAggBufferAttributes = (Seq)this.aggBufferAttributes().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final AttributeReference apply(AttributeReference x$1) {
                return x$1.newInstance();
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public HyperLogLogPlusPlus(Expression child) {
        this(child, 0.05, 0, 0);
    }

    public HyperLogLogPlusPlus(Expression child, Expression relativeSD) {
        this(child, HyperLogLogPlusPlus$.MODULE$.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$validateDoubleLiteral(relativeSD), 0, 0);
    }
}

