/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.internal;

import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.internal.config.OptionalConfigEntry;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.util.Utils$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;

public final class StaticSQLConf$ {
    public static final StaticSQLConf$ MODULE$;
    private final ConfigEntry<String> WAREHOUSE_PATH;
    private final ConfigEntry<String> CATALOG_IMPLEMENTATION;
    private final ConfigEntry<String> GLOBAL_TEMP_DATABASE;
    private final ConfigEntry<Object> SCHEMA_STRING_LENGTH_THRESHOLD;
    private final ConfigEntry<Object> FILESOURCE_TABLE_RELATION_CACHE_SIZE;
    private final ConfigEntry<Object> DEBUG_MODE;
    private final ConfigEntry<Object> HIVE_THRIFT_SERVER_SINGLESESSION;
    private final OptionalConfigEntry<String> SPARK_SESSION_EXTENSIONS;

    static {
        new StaticSQLConf$();
    }

    public ConfigEntry<String> WAREHOUSE_PATH() {
        return this.WAREHOUSE_PATH;
    }

    public ConfigEntry<String> CATALOG_IMPLEMENTATION() {
        return this.CATALOG_IMPLEMENTATION;
    }

    public ConfigEntry<String> GLOBAL_TEMP_DATABASE() {
        return this.GLOBAL_TEMP_DATABASE;
    }

    public ConfigEntry<Object> SCHEMA_STRING_LENGTH_THRESHOLD() {
        return this.SCHEMA_STRING_LENGTH_THRESHOLD;
    }

    public ConfigEntry<Object> FILESOURCE_TABLE_RELATION_CACHE_SIZE() {
        return this.FILESOURCE_TABLE_RELATION_CACHE_SIZE;
    }

    public ConfigEntry<Object> DEBUG_MODE() {
        return this.DEBUG_MODE;
    }

    public ConfigEntry<Object> HIVE_THRIFT_SERVER_SINGLESESSION() {
        return this.HIVE_THRIFT_SERVER_SINGLESESSION;
    }

    public OptionalConfigEntry<String> SPARK_SESSION_EXTENSIONS() {
        return this.SPARK_SESSION_EXTENSIONS;
    }

    private StaticSQLConf$() {
        MODULE$ = this;
        this.WAREHOUSE_PATH = SQLConf$.MODULE$.buildStaticConf("spark.sql.warehouse.dir").doc("The default location for managed databases and tables.").stringConf().createWithDefault((Object)Utils$.MODULE$.resolveURI("spark-warehouse").toString());
        this.CATALOG_IMPLEMENTATION = SQLConf$.MODULE$.buildStaticConf("spark.sql.catalogImplementation").internal().stringConf().checkValues((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hive", "in-memory"}))).createWithDefault((Object)"in-memory");
        this.GLOBAL_TEMP_DATABASE = SQLConf$.MODULE$.buildStaticConf("spark.sql.globalTempDatabase").internal().stringConf().createWithDefault((Object)"global_temp");
        this.SCHEMA_STRING_LENGTH_THRESHOLD = SQLConf$.MODULE$.buildStaticConf("spark.sql.sources.schemaStringLengthThreshold").doc("The maximum length allowed in a single cell when storing additional schema information in Hive's metastore.").internal().intConf().createWithDefault((Object)BoxesRunTime.boxToInteger((int)4000));
        this.FILESOURCE_TABLE_RELATION_CACHE_SIZE = SQLConf$.MODULE$.buildStaticConf("spark.sql.filesourceTableRelationCacheSize").internal().doc("The maximum size of the cache that maps qualified table names to table relation plans.").intConf().checkValue((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(int cacheSize) {
                return this.apply$mcZI$sp(cacheSize);
            }

            public boolean apply$mcZI$sp(int cacheSize) {
                return cacheSize >= 0;
            }
        }, "The maximum size of the cache must not be negative").createWithDefault((Object)BoxesRunTime.boxToInteger((int)1000));
        this.DEBUG_MODE = SQLConf$.MODULE$.buildStaticConf("spark.sql.debug").internal().doc("Only used for internal debugging. Not all functions are supported when it is enabled.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.HIVE_THRIFT_SERVER_SINGLESESSION = SQLConf$.MODULE$.buildStaticConf("spark.sql.hive.thriftServer.singleSession").doc("When set to true, Hive Thrift server is running in a single session mode. All the JDBC/ODBC connections share the temporary views, function registries, SQL configuration and the current database.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.SPARK_SESSION_EXTENSIONS = SQLConf$.MODULE$.buildStaticConf("spark.sql.extensions").doc("Name of the class used to configure Spark Session extensions. The class should implement Function1[SparkSessionExtension, Unit], and must have a no-args constructor.").stringConf().createOptional();
    }
}

