/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.apache.spark.internal.config.ConfigBuilder;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.internal.config.OptionalConfigEntry;
import org.apache.spark.internal.config.package$;
import org.apache.spark.network.util.ByteUnit;
import org.apache.spark.sql.internal.SQLConf$HiveCaseSensitiveInferenceMode$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.SortedSet$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

public final class SQLConf$
implements Serializable {
    public static final SQLConf$ MODULE$;
    private final Map<String, ConfigEntry<?>> org$apache$spark$sql$internal$SQLConf$$sqlConfEntries;
    private final Set<String> staticConfKeys;
    private final ConfigEntry<Object> OPTIMIZER_MAX_ITERATIONS;
    private final ConfigEntry<Object> OPTIMIZER_INSET_CONVERSION_THRESHOLD;
    private final ConfigEntry<Object> COMPRESS_CACHED;
    private final ConfigEntry<Object> COLUMN_BATCH_SIZE;
    private final ConfigEntry<Object> IN_MEMORY_PARTITION_PRUNING;
    private final ConfigEntry<Object> PREFER_SORTMERGEJOIN;
    private final ConfigEntry<Object> RADIX_SORT_ENABLED;
    private final ConfigEntry<Object> AUTO_BROADCASTJOIN_THRESHOLD;
    private final ConfigEntry<Object> LIMIT_SCALE_UP_FACTOR;
    private final ConfigEntry<Object> ENABLE_FALL_BACK_TO_HDFS_FOR_STATS;
    private final ConfigEntry<Object> DEFAULT_SIZE_IN_BYTES;
    private final ConfigEntry<Object> SHUFFLE_PARTITIONS;
    private final ConfigEntry<Object> SHUFFLE_TARGET_POSTSHUFFLE_INPUT_SIZE;
    private final ConfigEntry<Object> ADAPTIVE_EXECUTION_ENABLED;
    private final ConfigEntry<Object> SHUFFLE_MIN_NUM_POSTSHUFFLE_PARTITIONS;
    private final ConfigEntry<Object> SUBEXPRESSION_ELIMINATION_ENABLED;
    private final ConfigEntry<Object> CASE_SENSITIVE;
    private final ConfigEntry<Object> CONSTRAINT_PROPAGATION_ENABLED;
    private final ConfigEntry<Object> ESCAPED_STRING_LITERALS;
    private final ConfigEntry<Object> PARQUET_SCHEMA_MERGING_ENABLED;
    private final ConfigEntry<Object> PARQUET_SCHEMA_RESPECT_SUMMARIES;
    private final ConfigEntry<Object> PARQUET_BINARY_AS_STRING;
    private final ConfigEntry<Object> PARQUET_INT96_AS_TIMESTAMP;
    private final ConfigEntry<Object> PARQUET_INT64_AS_TIMESTAMP_MILLIS;
    private final ConfigEntry<Object> PARQUET_CACHE_METADATA;
    private final ConfigEntry<String> PARQUET_COMPRESSION;
    private final ConfigEntry<Object> PARQUET_FILTER_PUSHDOWN_ENABLED;
    private final ConfigEntry<Object> PARQUET_WRITE_LEGACY_FORMAT;
    private final ConfigEntry<String> PARQUET_OUTPUT_COMMITTER_CLASS;
    private final ConfigEntry<Object> PARQUET_VECTORIZED_READER_ENABLED;
    private final ConfigEntry<Object> ORC_FILTER_PUSHDOWN_ENABLED;
    private final ConfigEntry<Object> HIVE_VERIFY_PARTITION_PATH;
    private final ConfigEntry<Object> HIVE_METASTORE_PARTITION_PRUNING;
    private final ConfigEntry<Object> HIVE_MANAGE_FILESOURCE_PARTITIONS;
    private final ConfigEntry<Object> HIVE_FILESOURCE_PARTITION_FILE_CACHE_SIZE;
    private final ConfigEntry<String> HIVE_CASE_SENSITIVE_INFERENCE;
    private final ConfigEntry<Object> OPTIMIZER_METADATA_ONLY;
    private final ConfigEntry<String> COLUMN_NAME_OF_CORRUPT_RECORD;
    private final ConfigEntry<Object> BROADCAST_TIMEOUT;
    private final OptionalConfigEntry<String> THRIFTSERVER_POOL;
    private final ConfigEntry<Object> THRIFTSERVER_INCREMENTAL_COLLECT;
    private final ConfigEntry<Object> THRIFTSERVER_UI_STATEMENT_LIMIT;
    private final ConfigEntry<Object> THRIFTSERVER_UI_SESSION_LIMIT;
    private final ConfigEntry<String> DEFAULT_DATA_SOURCE_NAME;
    private final ConfigEntry<Object> CONVERT_CTAS;
    private final ConfigEntry<Object> GATHER_FASTSTAT;
    private final ConfigEntry<Object> PARTITION_COLUMN_TYPE_INFERENCE;
    private final ConfigEntry<Object> BUCKETING_ENABLED;
    private final ConfigEntry<Object> CROSS_JOINS_ENABLED;
    private final ConfigEntry<Object> ORDER_BY_ORDINAL;
    private final ConfigEntry<Object> GROUP_BY_ORDINAL;
    private final ConfigEntry<Object> GROUP_BY_ALIASES;
    private final OptionalConfigEntry<String> OUTPUT_COMMITTER_CLASS;
    private final ConfigEntry<String> FILE_COMMIT_PROTOCOL_CLASS;
    private final ConfigEntry<Object> PARALLEL_PARTITION_DISCOVERY_THRESHOLD;
    private final ConfigEntry<Object> PARALLEL_PARTITION_DISCOVERY_PARALLELISM;
    private final ConfigEntry<Object> DATAFRAME_SELF_JOIN_AUTO_RESOLVE_AMBIGUITY;
    private final ConfigEntry<Object> DATAFRAME_RETAIN_GROUP_COLUMNS;
    private final ConfigEntry<Object> DATAFRAME_PIVOT_MAX_VALUES;
    private final ConfigEntry<Object> RUN_SQL_ON_FILES;
    private final ConfigEntry<Object> WHOLESTAGE_CODEGEN_ENABLED;
    private final ConfigEntry<Object> WHOLESTAGE_MAX_NUM_FIELDS;
    private final ConfigEntry<Object> WHOLESTAGE_FALLBACK;
    private final ConfigEntry<Object> MAX_CASES_BRANCHES;
    private final ConfigEntry<Object> FILES_MAX_PARTITION_BYTES;
    private final ConfigEntry<Object> FILES_OPEN_COST_IN_BYTES;
    private final ConfigEntry<Object> IGNORE_CORRUPT_FILES;
    private final ConfigEntry<Object> MAX_RECORDS_PER_FILE;
    private final ConfigEntry<Object> EXCHANGE_REUSE_ENABLED;
    private final ConfigEntry<Object> STATE_STORE_MIN_DELTAS_FOR_SNAPSHOT;
    private final OptionalConfigEntry<String> CHECKPOINT_LOCATION;
    private final ConfigEntry<Object> MIN_BATCHES_TO_RETAIN;
    private final ConfigEntry<Object> UNSUPPORTED_OPERATION_CHECK_ENABLED;
    private final ConfigEntry<Object> VARIABLE_SUBSTITUTE_ENABLED;
    private final ConfigEntry<Object> VARIABLE_SUBSTITUTE_DEPTH;
    private final ConfigEntry<Object> ENABLE_TWOLEVEL_AGG_MAP;
    private final ConfigEntry<Object> MAX_NESTED_VIEW_DEPTH;
    private final ConfigEntry<String> STREAMING_FILE_COMMIT_PROTOCOL_CLASS;
    private final ConfigEntry<Object> OBJECT_AGG_SORT_BASED_FALLBACK_THRESHOLD;
    private final ConfigEntry<Object> USE_OBJECT_HASH_AGG;
    private final ConfigEntry<Object> FILE_SINK_LOG_DELETION;
    private final ConfigEntry<Object> FILE_SINK_LOG_COMPACT_INTERVAL;
    private final ConfigEntry<Object> FILE_SINK_LOG_CLEANUP_DELAY;
    private final ConfigEntry<Object> FILE_SOURCE_LOG_DELETION;
    private final ConfigEntry<Object> FILE_SOURCE_LOG_COMPACT_INTERVAL;
    private final ConfigEntry<Object> FILE_SOURCE_LOG_CLEANUP_DELAY;
    private final ConfigEntry<Object> STREAMING_SCHEMA_INFERENCE;
    private final ConfigEntry<Object> STREAMING_POLLING_DELAY;
    private final ConfigEntry<Object> STREAMING_NO_DATA_PROGRESS_EVENT_INTERVAL;
    private final ConfigEntry<Object> STREAMING_METRICS_ENABLED;
    private final ConfigEntry<Object> STREAMING_PROGRESS_RETENTION;
    private final ConfigEntry<Object> NDV_MAX_ERROR;
    private final ConfigEntry<Object> CBO_ENABLED;
    private final ConfigEntry<Object> JOIN_REORDER_ENABLED;
    private final ConfigEntry<Object> JOIN_REORDER_DP_THRESHOLD;
    private final ConfigEntry<Object> JOIN_REORDER_CARD_WEIGHT;
    private final ConfigEntry<Object> JOIN_REORDER_DP_STAR_FILTER;
    private final ConfigEntry<Object> STARSCHEMA_DETECTION;
    private final ConfigEntry<Object> STARSCHEMA_FACT_TABLE_RATIO;
    private final ConfigEntry<String> SESSION_LOCAL_TIMEZONE;
    private final ConfigEntry<Object> WINDOW_EXEC_BUFFER_IN_MEMORY_THRESHOLD;
    private final ConfigEntry<Object> WINDOW_EXEC_BUFFER_SPILL_THRESHOLD;
    private final ConfigEntry<Object> SORT_MERGE_JOIN_EXEC_BUFFER_IN_MEMORY_THRESHOLD;
    private final ConfigEntry<Object> SORT_MERGE_JOIN_EXEC_BUFFER_SPILL_THRESHOLD;
    private final ConfigEntry<Object> CARTESIAN_PRODUCT_EXEC_BUFFER_IN_MEMORY_THRESHOLD;
    private final ConfigEntry<Object> CARTESIAN_PRODUCT_EXEC_BUFFER_SPILL_THRESHOLD;
    private final ConfigEntry<Regex> SQL_OPTIONS_REDACTION_PATTERN;

    static {
        new SQLConf$();
    }

    public Map<String, ConfigEntry<?>> org$apache$spark$sql$internal$SQLConf$$sqlConfEntries() {
        return this.org$apache$spark$sql$internal$SQLConf$$sqlConfEntries;
    }

    public Set<String> staticConfKeys() {
        return this.staticConfKeys;
    }

    public void org$apache$spark$sql$internal$SQLConf$$register(ConfigEntry<?> entry) {
        Map<String, ConfigEntry<?>> map2 = this.org$apache$spark$sql$internal$SQLConf$$sqlConfEntries();
        synchronized (map2) {
            Predef$.MODULE$.require(!this.org$apache$spark$sql$internal$SQLConf$$sqlConfEntries().containsKey(entry.key()), (Function0)new Serializable(entry){
                public static final long serialVersionUID = 0L;
                private final ConfigEntry entry$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Duplicate SQLConfigEntry. ", " has been registered"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.entry$1.key()}));
                }
                {
                    this.entry$1 = entry$1;
                }
            });
            this.org$apache$spark$sql$internal$SQLConf$$sqlConfEntries().put(entry.key(), entry);
            return;
        }
    }

    public void unregister(ConfigEntry<?> entry) {
        Map<String, ConfigEntry<?>> map2 = this.org$apache$spark$sql$internal$SQLConf$$sqlConfEntries();
        synchronized (map2) {
            this.org$apache$spark$sql$internal$SQLConf$$sqlConfEntries().remove(entry.key());
            return;
        }
    }

    public ConfigBuilder buildConf(String key) {
        return new ConfigBuilder(key).onCreate((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(ConfigEntry<?> entry) {
                SQLConf$.MODULE$.org$apache$spark$sql$internal$SQLConf$$register(entry);
            }
        });
    }

    public ConfigBuilder buildStaticConf(String key) {
        return new ConfigBuilder(key).onCreate((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(ConfigEntry<?> entry) {
                SQLConf$.MODULE$.staticConfKeys().add(entry.key());
                SQLConf$.MODULE$.org$apache$spark$sql$internal$SQLConf$$register(entry);
            }
        });
    }

    public ConfigEntry<Object> OPTIMIZER_MAX_ITERATIONS() {
        return this.OPTIMIZER_MAX_ITERATIONS;
    }

    public ConfigEntry<Object> OPTIMIZER_INSET_CONVERSION_THRESHOLD() {
        return this.OPTIMIZER_INSET_CONVERSION_THRESHOLD;
    }

    public ConfigEntry<Object> COMPRESS_CACHED() {
        return this.COMPRESS_CACHED;
    }

    public ConfigEntry<Object> COLUMN_BATCH_SIZE() {
        return this.COLUMN_BATCH_SIZE;
    }

    public ConfigEntry<Object> IN_MEMORY_PARTITION_PRUNING() {
        return this.IN_MEMORY_PARTITION_PRUNING;
    }

    public ConfigEntry<Object> PREFER_SORTMERGEJOIN() {
        return this.PREFER_SORTMERGEJOIN;
    }

    public ConfigEntry<Object> RADIX_SORT_ENABLED() {
        return this.RADIX_SORT_ENABLED;
    }

    public ConfigEntry<Object> AUTO_BROADCASTJOIN_THRESHOLD() {
        return this.AUTO_BROADCASTJOIN_THRESHOLD;
    }

    public ConfigEntry<Object> LIMIT_SCALE_UP_FACTOR() {
        return this.LIMIT_SCALE_UP_FACTOR;
    }

    public ConfigEntry<Object> ENABLE_FALL_BACK_TO_HDFS_FOR_STATS() {
        return this.ENABLE_FALL_BACK_TO_HDFS_FOR_STATS;
    }

    public ConfigEntry<Object> DEFAULT_SIZE_IN_BYTES() {
        return this.DEFAULT_SIZE_IN_BYTES;
    }

    public ConfigEntry<Object> SHUFFLE_PARTITIONS() {
        return this.SHUFFLE_PARTITIONS;
    }

    public ConfigEntry<Object> SHUFFLE_TARGET_POSTSHUFFLE_INPUT_SIZE() {
        return this.SHUFFLE_TARGET_POSTSHUFFLE_INPUT_SIZE;
    }

    public ConfigEntry<Object> ADAPTIVE_EXECUTION_ENABLED() {
        return this.ADAPTIVE_EXECUTION_ENABLED;
    }

    public ConfigEntry<Object> SHUFFLE_MIN_NUM_POSTSHUFFLE_PARTITIONS() {
        return this.SHUFFLE_MIN_NUM_POSTSHUFFLE_PARTITIONS;
    }

    public ConfigEntry<Object> SUBEXPRESSION_ELIMINATION_ENABLED() {
        return this.SUBEXPRESSION_ELIMINATION_ENABLED;
    }

    public ConfigEntry<Object> CASE_SENSITIVE() {
        return this.CASE_SENSITIVE;
    }

    public ConfigEntry<Object> CONSTRAINT_PROPAGATION_ENABLED() {
        return this.CONSTRAINT_PROPAGATION_ENABLED;
    }

    public ConfigEntry<Object> ESCAPED_STRING_LITERALS() {
        return this.ESCAPED_STRING_LITERALS;
    }

    public ConfigEntry<Object> PARQUET_SCHEMA_MERGING_ENABLED() {
        return this.PARQUET_SCHEMA_MERGING_ENABLED;
    }

    public ConfigEntry<Object> PARQUET_SCHEMA_RESPECT_SUMMARIES() {
        return this.PARQUET_SCHEMA_RESPECT_SUMMARIES;
    }

    public ConfigEntry<Object> PARQUET_BINARY_AS_STRING() {
        return this.PARQUET_BINARY_AS_STRING;
    }

    public ConfigEntry<Object> PARQUET_INT96_AS_TIMESTAMP() {
        return this.PARQUET_INT96_AS_TIMESTAMP;
    }

    public ConfigEntry<Object> PARQUET_INT64_AS_TIMESTAMP_MILLIS() {
        return this.PARQUET_INT64_AS_TIMESTAMP_MILLIS;
    }

    public ConfigEntry<Object> PARQUET_CACHE_METADATA() {
        return this.PARQUET_CACHE_METADATA;
    }

    public ConfigEntry<String> PARQUET_COMPRESSION() {
        return this.PARQUET_COMPRESSION;
    }

    public ConfigEntry<Object> PARQUET_FILTER_PUSHDOWN_ENABLED() {
        return this.PARQUET_FILTER_PUSHDOWN_ENABLED;
    }

    public ConfigEntry<Object> PARQUET_WRITE_LEGACY_FORMAT() {
        return this.PARQUET_WRITE_LEGACY_FORMAT;
    }

    public ConfigEntry<String> PARQUET_OUTPUT_COMMITTER_CLASS() {
        return this.PARQUET_OUTPUT_COMMITTER_CLASS;
    }

    public ConfigEntry<Object> PARQUET_VECTORIZED_READER_ENABLED() {
        return this.PARQUET_VECTORIZED_READER_ENABLED;
    }

    public ConfigEntry<Object> ORC_FILTER_PUSHDOWN_ENABLED() {
        return this.ORC_FILTER_PUSHDOWN_ENABLED;
    }

    public ConfigEntry<Object> HIVE_VERIFY_PARTITION_PATH() {
        return this.HIVE_VERIFY_PARTITION_PATH;
    }

    public ConfigEntry<Object> HIVE_METASTORE_PARTITION_PRUNING() {
        return this.HIVE_METASTORE_PARTITION_PRUNING;
    }

    public ConfigEntry<Object> HIVE_MANAGE_FILESOURCE_PARTITIONS() {
        return this.HIVE_MANAGE_FILESOURCE_PARTITIONS;
    }

    public ConfigEntry<Object> HIVE_FILESOURCE_PARTITION_FILE_CACHE_SIZE() {
        return this.HIVE_FILESOURCE_PARTITION_FILE_CACHE_SIZE;
    }

    public ConfigEntry<String> HIVE_CASE_SENSITIVE_INFERENCE() {
        return this.HIVE_CASE_SENSITIVE_INFERENCE;
    }

    public ConfigEntry<Object> OPTIMIZER_METADATA_ONLY() {
        return this.OPTIMIZER_METADATA_ONLY;
    }

    public ConfigEntry<String> COLUMN_NAME_OF_CORRUPT_RECORD() {
        return this.COLUMN_NAME_OF_CORRUPT_RECORD;
    }

    public ConfigEntry<Object> BROADCAST_TIMEOUT() {
        return this.BROADCAST_TIMEOUT;
    }

    public OptionalConfigEntry<String> THRIFTSERVER_POOL() {
        return this.THRIFTSERVER_POOL;
    }

    public ConfigEntry<Object> THRIFTSERVER_INCREMENTAL_COLLECT() {
        return this.THRIFTSERVER_INCREMENTAL_COLLECT;
    }

    public ConfigEntry<Object> THRIFTSERVER_UI_STATEMENT_LIMIT() {
        return this.THRIFTSERVER_UI_STATEMENT_LIMIT;
    }

    public ConfigEntry<Object> THRIFTSERVER_UI_SESSION_LIMIT() {
        return this.THRIFTSERVER_UI_SESSION_LIMIT;
    }

    public ConfigEntry<String> DEFAULT_DATA_SOURCE_NAME() {
        return this.DEFAULT_DATA_SOURCE_NAME;
    }

    public ConfigEntry<Object> CONVERT_CTAS() {
        return this.CONVERT_CTAS;
    }

    public ConfigEntry<Object> GATHER_FASTSTAT() {
        return this.GATHER_FASTSTAT;
    }

    public ConfigEntry<Object> PARTITION_COLUMN_TYPE_INFERENCE() {
        return this.PARTITION_COLUMN_TYPE_INFERENCE;
    }

    public ConfigEntry<Object> BUCKETING_ENABLED() {
        return this.BUCKETING_ENABLED;
    }

    public ConfigEntry<Object> CROSS_JOINS_ENABLED() {
        return this.CROSS_JOINS_ENABLED;
    }

    public ConfigEntry<Object> ORDER_BY_ORDINAL() {
        return this.ORDER_BY_ORDINAL;
    }

    public ConfigEntry<Object> GROUP_BY_ORDINAL() {
        return this.GROUP_BY_ORDINAL;
    }

    public ConfigEntry<Object> GROUP_BY_ALIASES() {
        return this.GROUP_BY_ALIASES;
    }

    public OptionalConfigEntry<String> OUTPUT_COMMITTER_CLASS() {
        return this.OUTPUT_COMMITTER_CLASS;
    }

    public ConfigEntry<String> FILE_COMMIT_PROTOCOL_CLASS() {
        return this.FILE_COMMIT_PROTOCOL_CLASS;
    }

    public ConfigEntry<Object> PARALLEL_PARTITION_DISCOVERY_THRESHOLD() {
        return this.PARALLEL_PARTITION_DISCOVERY_THRESHOLD;
    }

    public ConfigEntry<Object> PARALLEL_PARTITION_DISCOVERY_PARALLELISM() {
        return this.PARALLEL_PARTITION_DISCOVERY_PARALLELISM;
    }

    public ConfigEntry<Object> DATAFRAME_SELF_JOIN_AUTO_RESOLVE_AMBIGUITY() {
        return this.DATAFRAME_SELF_JOIN_AUTO_RESOLVE_AMBIGUITY;
    }

    public ConfigEntry<Object> DATAFRAME_RETAIN_GROUP_COLUMNS() {
        return this.DATAFRAME_RETAIN_GROUP_COLUMNS;
    }

    public ConfigEntry<Object> DATAFRAME_PIVOT_MAX_VALUES() {
        return this.DATAFRAME_PIVOT_MAX_VALUES;
    }

    public ConfigEntry<Object> RUN_SQL_ON_FILES() {
        return this.RUN_SQL_ON_FILES;
    }

    public ConfigEntry<Object> WHOLESTAGE_CODEGEN_ENABLED() {
        return this.WHOLESTAGE_CODEGEN_ENABLED;
    }

    public ConfigEntry<Object> WHOLESTAGE_MAX_NUM_FIELDS() {
        return this.WHOLESTAGE_MAX_NUM_FIELDS;
    }

    public ConfigEntry<Object> WHOLESTAGE_FALLBACK() {
        return this.WHOLESTAGE_FALLBACK;
    }

    public ConfigEntry<Object> MAX_CASES_BRANCHES() {
        return this.MAX_CASES_BRANCHES;
    }

    public ConfigEntry<Object> FILES_MAX_PARTITION_BYTES() {
        return this.FILES_MAX_PARTITION_BYTES;
    }

    public ConfigEntry<Object> FILES_OPEN_COST_IN_BYTES() {
        return this.FILES_OPEN_COST_IN_BYTES;
    }

    public ConfigEntry<Object> IGNORE_CORRUPT_FILES() {
        return this.IGNORE_CORRUPT_FILES;
    }

    public ConfigEntry<Object> MAX_RECORDS_PER_FILE() {
        return this.MAX_RECORDS_PER_FILE;
    }

    public ConfigEntry<Object> EXCHANGE_REUSE_ENABLED() {
        return this.EXCHANGE_REUSE_ENABLED;
    }

    public ConfigEntry<Object> STATE_STORE_MIN_DELTAS_FOR_SNAPSHOT() {
        return this.STATE_STORE_MIN_DELTAS_FOR_SNAPSHOT;
    }

    public OptionalConfigEntry<String> CHECKPOINT_LOCATION() {
        return this.CHECKPOINT_LOCATION;
    }

    public ConfigEntry<Object> MIN_BATCHES_TO_RETAIN() {
        return this.MIN_BATCHES_TO_RETAIN;
    }

    public ConfigEntry<Object> UNSUPPORTED_OPERATION_CHECK_ENABLED() {
        return this.UNSUPPORTED_OPERATION_CHECK_ENABLED;
    }

    public ConfigEntry<Object> VARIABLE_SUBSTITUTE_ENABLED() {
        return this.VARIABLE_SUBSTITUTE_ENABLED;
    }

    public ConfigEntry<Object> VARIABLE_SUBSTITUTE_DEPTH() {
        return this.VARIABLE_SUBSTITUTE_DEPTH;
    }

    public ConfigEntry<Object> ENABLE_TWOLEVEL_AGG_MAP() {
        return this.ENABLE_TWOLEVEL_AGG_MAP;
    }

    public ConfigEntry<Object> MAX_NESTED_VIEW_DEPTH() {
        return this.MAX_NESTED_VIEW_DEPTH;
    }

    public ConfigEntry<String> STREAMING_FILE_COMMIT_PROTOCOL_CLASS() {
        return this.STREAMING_FILE_COMMIT_PROTOCOL_CLASS;
    }

    public ConfigEntry<Object> OBJECT_AGG_SORT_BASED_FALLBACK_THRESHOLD() {
        return this.OBJECT_AGG_SORT_BASED_FALLBACK_THRESHOLD;
    }

    public ConfigEntry<Object> USE_OBJECT_HASH_AGG() {
        return this.USE_OBJECT_HASH_AGG;
    }

    public ConfigEntry<Object> FILE_SINK_LOG_DELETION() {
        return this.FILE_SINK_LOG_DELETION;
    }

    public ConfigEntry<Object> FILE_SINK_LOG_COMPACT_INTERVAL() {
        return this.FILE_SINK_LOG_COMPACT_INTERVAL;
    }

    public ConfigEntry<Object> FILE_SINK_LOG_CLEANUP_DELAY() {
        return this.FILE_SINK_LOG_CLEANUP_DELAY;
    }

    public ConfigEntry<Object> FILE_SOURCE_LOG_DELETION() {
        return this.FILE_SOURCE_LOG_DELETION;
    }

    public ConfigEntry<Object> FILE_SOURCE_LOG_COMPACT_INTERVAL() {
        return this.FILE_SOURCE_LOG_COMPACT_INTERVAL;
    }

    public ConfigEntry<Object> FILE_SOURCE_LOG_CLEANUP_DELAY() {
        return this.FILE_SOURCE_LOG_CLEANUP_DELAY;
    }

    public ConfigEntry<Object> STREAMING_SCHEMA_INFERENCE() {
        return this.STREAMING_SCHEMA_INFERENCE;
    }

    public ConfigEntry<Object> STREAMING_POLLING_DELAY() {
        return this.STREAMING_POLLING_DELAY;
    }

    public ConfigEntry<Object> STREAMING_NO_DATA_PROGRESS_EVENT_INTERVAL() {
        return this.STREAMING_NO_DATA_PROGRESS_EVENT_INTERVAL;
    }

    public ConfigEntry<Object> STREAMING_METRICS_ENABLED() {
        return this.STREAMING_METRICS_ENABLED;
    }

    public ConfigEntry<Object> STREAMING_PROGRESS_RETENTION() {
        return this.STREAMING_PROGRESS_RETENTION;
    }

    public ConfigEntry<Object> NDV_MAX_ERROR() {
        return this.NDV_MAX_ERROR;
    }

    public ConfigEntry<Object> CBO_ENABLED() {
        return this.CBO_ENABLED;
    }

    public ConfigEntry<Object> JOIN_REORDER_ENABLED() {
        return this.JOIN_REORDER_ENABLED;
    }

    public ConfigEntry<Object> JOIN_REORDER_DP_THRESHOLD() {
        return this.JOIN_REORDER_DP_THRESHOLD;
    }

    public ConfigEntry<Object> JOIN_REORDER_CARD_WEIGHT() {
        return this.JOIN_REORDER_CARD_WEIGHT;
    }

    public ConfigEntry<Object> JOIN_REORDER_DP_STAR_FILTER() {
        return this.JOIN_REORDER_DP_STAR_FILTER;
    }

    public ConfigEntry<Object> STARSCHEMA_DETECTION() {
        return this.STARSCHEMA_DETECTION;
    }

    public ConfigEntry<Object> STARSCHEMA_FACT_TABLE_RATIO() {
        return this.STARSCHEMA_FACT_TABLE_RATIO;
    }

    public ConfigEntry<String> SESSION_LOCAL_TIMEZONE() {
        return this.SESSION_LOCAL_TIMEZONE;
    }

    public ConfigEntry<Object> WINDOW_EXEC_BUFFER_IN_MEMORY_THRESHOLD() {
        return this.WINDOW_EXEC_BUFFER_IN_MEMORY_THRESHOLD;
    }

    public ConfigEntry<Object> WINDOW_EXEC_BUFFER_SPILL_THRESHOLD() {
        return this.WINDOW_EXEC_BUFFER_SPILL_THRESHOLD;
    }

    public ConfigEntry<Object> SORT_MERGE_JOIN_EXEC_BUFFER_IN_MEMORY_THRESHOLD() {
        return this.SORT_MERGE_JOIN_EXEC_BUFFER_IN_MEMORY_THRESHOLD;
    }

    public ConfigEntry<Object> SORT_MERGE_JOIN_EXEC_BUFFER_SPILL_THRESHOLD() {
        return this.SORT_MERGE_JOIN_EXEC_BUFFER_SPILL_THRESHOLD;
    }

    public ConfigEntry<Object> CARTESIAN_PRODUCT_EXEC_BUFFER_IN_MEMORY_THRESHOLD() {
        return this.CARTESIAN_PRODUCT_EXEC_BUFFER_IN_MEMORY_THRESHOLD;
    }

    public ConfigEntry<Object> CARTESIAN_PRODUCT_EXEC_BUFFER_SPILL_THRESHOLD() {
        return this.CARTESIAN_PRODUCT_EXEC_BUFFER_SPILL_THRESHOLD;
    }

    public ConfigEntry<Regex> SQL_OPTIONS_REDACTION_PATTERN() {
        return this.SQL_OPTIONS_REDACTION_PATTERN;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private SQLConf$() {
        MODULE$ = this;
        this.org$apache$spark$sql$internal$SQLConf$$sqlConfEntries = Collections.synchronizedMap(new HashMap());
        this.staticConfKeys = Collections.synchronizedSet(new HashSet());
        this.OPTIMIZER_MAX_ITERATIONS = this.buildConf("spark.sql.optimizer.maxIterations").internal().doc("The max number of iterations the optimizer and analyzer runs.").intConf().createWithDefault((Object)BoxesRunTime.boxToInteger((int)100));
        this.OPTIMIZER_INSET_CONVERSION_THRESHOLD = this.buildConf("spark.sql.optimizer.inSetConversionThreshold").internal().doc("The threshold of set size for InSet conversion.").intConf().createWithDefault((Object)BoxesRunTime.boxToInteger((int)10));
        this.COMPRESS_CACHED = this.buildConf("spark.sql.inMemoryColumnarStorage.compressed").internal().doc("When set to true Spark SQL will automatically select a compression codec for each column based on statistics of the data.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.COLUMN_BATCH_SIZE = this.buildConf("spark.sql.inMemoryColumnarStorage.batchSize").internal().doc("Controls the size of batches for columnar caching.  Larger batch sizes can improve memory utilization and compression, but risk OOMs when caching data.").intConf().createWithDefault((Object)BoxesRunTime.boxToInteger((int)10000));
        this.IN_MEMORY_PARTITION_PRUNING = this.buildConf("spark.sql.inMemoryColumnarStorage.partitionPruning").internal().doc("When true, enable partition pruning for in-memory columnar tables.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.PREFER_SORTMERGEJOIN = this.buildConf("spark.sql.join.preferSortMergeJoin").internal().doc("When true, prefer sort merge join over shuffle hash join.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.RADIX_SORT_ENABLED = this.buildConf("spark.sql.sort.enableRadixSort").internal().doc("When true, enable use of radix sort when possible. Radix sort is much faster but requires additional memory to be reserved up-front. The memory overhead may be significant when sorting very small rows (up to 50% more in this case).").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.AUTO_BROADCASTJOIN_THRESHOLD = this.buildConf("spark.sql.autoBroadcastJoinThreshold").doc("Configures the maximum size in bytes for a table that will be broadcast to all worker nodes when performing a join.  By setting this value to -1 broadcasting can be disabled. Note that currently statistics are only supported for Hive Metastore tables where the command <code>ANALYZE TABLE &lt;tableName&gt; COMPUTE STATISTICS noscan</code> has been run, and file-based data source tables where the statistics are computed directly on the files of data.").longConf().createWithDefault((Object)BoxesRunTime.boxToLong((long)0xA00000L));
        this.LIMIT_SCALE_UP_FACTOR = this.buildConf("spark.sql.limit.scaleUpFactor").internal().doc("Minimal increase rate in number of partitions between attempts when executing a take on a query. Higher values lead to more partitions read. Lower values might lead to longer execution times as more jobs will be run").intConf().createWithDefault((Object)BoxesRunTime.boxToInteger((int)4));
        this.ENABLE_FALL_BACK_TO_HDFS_FOR_STATS = this.buildConf("spark.sql.statistics.fallBackToHdfs").doc("If the table statistics are not available from table metadata enable fall back to hdfs. This is useful in determining if a table is small enough to use auto broadcast joins.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.DEFAULT_SIZE_IN_BYTES = this.buildConf("spark.sql.defaultSizeInBytes").internal().doc("The default table size used in query planning. By default, it is set to Long.MaxValue which is larger than `spark.sql.autoBroadcastJoinThreshold` to be more conservative. That is to say by default the optimizer will not choose to broadcast a table unless it knows for sure its size is small enough.").longConf().createWithDefault((Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE));
        this.SHUFFLE_PARTITIONS = this.buildConf("spark.sql.shuffle.partitions").doc("The default number of partitions to use when shuffling data for joins or aggregations.").intConf().createWithDefault((Object)BoxesRunTime.boxToInteger((int)200));
        this.SHUFFLE_TARGET_POSTSHUFFLE_INPUT_SIZE = this.buildConf("spark.sql.adaptive.shuffle.targetPostShuffleInputSize").doc("The target post-shuffle input size in bytes of a task.").bytesConf(ByteUnit.BYTE).createWithDefault((Object)BoxesRunTime.boxToLong((long)0x4000000L));
        this.ADAPTIVE_EXECUTION_ENABLED = this.buildConf("spark.sql.adaptive.enabled").doc("When true, enable adaptive query execution.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.SHUFFLE_MIN_NUM_POSTSHUFFLE_PARTITIONS = this.buildConf("spark.sql.adaptive.minNumPostShufflePartitions").internal().doc("The advisory minimal number of post-shuffle partitions provided to ExchangeCoordinator. This setting is used in our test to make sure we have enough parallelism to expose issues that will not be exposed with a single partition. When the value is a non-positive value, this setting will not be provided to ExchangeCoordinator.").intConf().createWithDefault((Object)BoxesRunTime.boxToInteger((int)-1));
        this.SUBEXPRESSION_ELIMINATION_ENABLED = this.buildConf("spark.sql.subexpressionElimination.enabled").internal().doc("When true, common subexpressions will be eliminated.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.CASE_SENSITIVE = this.buildConf("spark.sql.caseSensitive").internal().doc("Whether the query analyzer should be case sensitive or not. Default to case insensitive. It is highly discouraged to turn on case sensitive mode.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.CONSTRAINT_PROPAGATION_ENABLED = this.buildConf("spark.sql.constraintPropagation.enabled").internal().doc("When true, the query optimizer will infer and propagate data constraints in the query plan to optimize them. Constraint propagation can sometimes be computationally expensivefor certain kinds of query plans (such as those with a large number of predicates and aliases) which might negatively impact overall runtime.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.ESCAPED_STRING_LITERALS = this.buildConf("spark.sql.parser.escapedStringLiterals").internal().doc("When true, string literals (including regex patterns) remain escaped in our SQL parser. The default is false since Spark 2.0. Setting it to true can restore the behavior prior to Spark 2.0.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.PARQUET_SCHEMA_MERGING_ENABLED = this.buildConf("spark.sql.parquet.mergeSchema").doc("When true, the Parquet data source merges schemas collected from all data files, otherwise the schema is picked from the summary file or a random data file if no summary file is available.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.PARQUET_SCHEMA_RESPECT_SUMMARIES = this.buildConf("spark.sql.parquet.respectSummaryFiles").doc("When true, we make assumption that all part-files of Parquet are consistent with summary files and we will ignore them when merging schema. Otherwise, if this is false, which is the default, we will merge all part-files. This should be considered as expert-only option, and shouldn't be enabled before knowing what it means exactly.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.PARQUET_BINARY_AS_STRING = this.buildConf("spark.sql.parquet.binaryAsString").doc("Some other Parquet-producing systems, in particular Impala and older versions of Spark SQL, do not differentiate between binary data and strings when writing out the Parquet schema. This flag tells Spark SQL to interpret binary data as a string to provide compatibility with these systems.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.PARQUET_INT96_AS_TIMESTAMP = this.buildConf("spark.sql.parquet.int96AsTimestamp").doc("Some Parquet-producing systems, in particular Impala, store Timestamp into INT96. Spark would also store Timestamp as INT96 because we need to avoid precision lost of the nanoseconds field. This flag tells Spark SQL to interpret INT96 data as a timestamp to provide compatibility with these systems.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.PARQUET_INT64_AS_TIMESTAMP_MILLIS = this.buildConf("spark.sql.parquet.int64AsTimestampMillis").doc("When true, timestamp values will be stored as INT64 with TIMESTAMP_MILLIS as the extended type. In this mode, the microsecond portion of the timestamp value will betruncated.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.PARQUET_CACHE_METADATA = this.buildConf("spark.sql.parquet.cacheMetadata").doc("Turns on caching of Parquet schema metadata. Can speed up querying of static data.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.PARQUET_COMPRESSION = this.buildConf("spark.sql.parquet.compression.codec").doc("Sets the compression codec use when writing Parquet files. Acceptable values include: uncompressed, snappy, gzip, lzo.").stringConf().transform((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String x$1) {
                return x$1.toLowerCase(Locale.ROOT);
            }
        }).checkValues((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"uncompressed", "snappy", "gzip", "lzo"}))).createWithDefault((Object)"snappy");
        this.PARQUET_FILTER_PUSHDOWN_ENABLED = this.buildConf("spark.sql.parquet.filterPushdown").doc("Enables Parquet filter push-down optimization when set to true.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.PARQUET_WRITE_LEGACY_FORMAT = this.buildConf("spark.sql.parquet.writeLegacyFormat").doc("Whether to follow Parquet's format specification when converting Parquet schema to Spark SQL schema and vice versa.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.PARQUET_OUTPUT_COMMITTER_CLASS = this.buildConf("spark.sql.parquet.output.committer.class").doc("The output committer class used by Parquet. The specified class needs to be a subclass of org.apache.hadoop.mapreduce.OutputCommitter. Typically, it's also a subclass of org.apache.parquet.hadoop.ParquetOutputCommitter. If it is not, then metadata summarieswill never be created, irrespective of the value of parquet.enable.summary-metadata").internal().stringConf().createWithDefault((Object)"org.apache.parquet.hadoop.ParquetOutputCommitter");
        this.PARQUET_VECTORIZED_READER_ENABLED = this.buildConf("spark.sql.parquet.enableVectorizedReader").doc("Enables vectorized parquet decoding.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.ORC_FILTER_PUSHDOWN_ENABLED = this.buildConf("spark.sql.orc.filterPushdown").doc("When true, enable filter pushdown for ORC files.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.HIVE_VERIFY_PARTITION_PATH = this.buildConf("spark.sql.hive.verifyPartitionPath").doc("When true, check all the partition paths under the table's root directory when reading data stored in HDFS.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.HIVE_METASTORE_PARTITION_PRUNING = this.buildConf("spark.sql.hive.metastorePartitionPruning").doc("When true, some predicates will be pushed down into the Hive metastore so that unmatching partitions can be eliminated earlier. This only affects Hive tables not converted to filesource relations (see HiveUtils.CONVERT_METASTORE_PARQUET and HiveUtils.CONVERT_METASTORE_ORC for more information).").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.HIVE_MANAGE_FILESOURCE_PARTITIONS = this.buildConf("spark.sql.hive.manageFilesourcePartitions").doc("When true, enable metastore partition management for file source tables as well. This includes both datasource and converted Hive tables. When partition management is enabled, datasource tables store partition in the Hive metastore, and use the metastore to prune partitions during query planning.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.HIVE_FILESOURCE_PARTITION_FILE_CACHE_SIZE = this.buildConf("spark.sql.hive.filesourcePartitionFileCacheSize").doc("When nonzero, enable caching of partition file metadata in memory. All tables share a cache that can use up to specified num bytes for file metadata. This conf only has an effect when hive filesource partition management is enabled.").longConf().createWithDefault((Object)BoxesRunTime.boxToLong((long)0xFA00000L));
        this.HIVE_CASE_SENSITIVE_INFERENCE = this.buildConf("spark.sql.hive.caseSensitiveInferenceMode").doc("Sets the action to take when a case-sensitive schema cannot be read from a Hive table's properties. Although Spark SQL itself is not case-sensitive, Hive compatible file formats such as Parquet are. Spark SQL must use a case-preserving schema when querying any table backed by files containing case-sensitive field names or queries may not return accurate results. Valid options include INFER_AND_SAVE (the default mode-- infer the case-sensitive schema from the underlying data files and write it back to the table properties), INFER_ONLY (infer the schema but don't attempt to write it to the table properties) and NEVER_INFER (fallback to using the case-insensitive metastore schema instead of inferring).").stringConf().transform((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String x$2) {
                return x$2.toUpperCase(Locale.ROOT);
            }
        }).checkValues((scala.collection.immutable.Set)SQLConf$HiveCaseSensitiveInferenceMode$.MODULE$.values().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Enumeration.Value x$3) {
                return x$3.toString();
            }
        }, SortedSet$.MODULE$.newCanBuildFrom((Ordering)Ordering.String$.MODULE$))).createWithDefault((Object)SQLConf$HiveCaseSensitiveInferenceMode$.MODULE$.INFER_AND_SAVE().toString());
        this.OPTIMIZER_METADATA_ONLY = this.buildConf("spark.sql.optimizer.metadataOnly").doc("When true, enable the metadata-only query optimization that use the table's metadata to produce the partition columns instead of table scans. It applies when all the columns scanned are partition columns and the query has an aggregate operator that satisfies distinct semantics.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.COLUMN_NAME_OF_CORRUPT_RECORD = this.buildConf("spark.sql.columnNameOfCorruptRecord").doc("The name of internal column for storing raw/un-parsed JSON and CSV records that fail to parse.").stringConf().createWithDefault((Object)"_corrupt_record");
        this.BROADCAST_TIMEOUT = this.buildConf("spark.sql.broadcastTimeout").doc("Timeout in seconds for the broadcast wait time in broadcast joins.").intConf().createWithDefault((Object)BoxesRunTime.boxToInteger((int)300));
        this.THRIFTSERVER_POOL = this.buildConf("spark.sql.thriftserver.scheduler.pool").doc("Set a Fair Scheduler pool for a JDBC client session.").stringConf().createOptional();
        this.THRIFTSERVER_INCREMENTAL_COLLECT = this.buildConf("spark.sql.thriftServer.incrementalCollect").internal().doc("When true, enable incremental collection for execution in Thrift Server.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.THRIFTSERVER_UI_STATEMENT_LIMIT = this.buildConf("spark.sql.thriftserver.ui.retainedStatements").doc("The number of SQL statements kept in the JDBC/ODBC web UI history.").intConf().createWithDefault((Object)BoxesRunTime.boxToInteger((int)200));
        this.THRIFTSERVER_UI_SESSION_LIMIT = this.buildConf("spark.sql.thriftserver.ui.retainedSessions").doc("The number of SQL client sessions kept in the JDBC/ODBC web UI history.").intConf().createWithDefault((Object)BoxesRunTime.boxToInteger((int)200));
        this.DEFAULT_DATA_SOURCE_NAME = this.buildConf("spark.sql.sources.default").doc("The default data source to use in input/output.").stringConf().createWithDefault((Object)"parquet");
        this.CONVERT_CTAS = this.buildConf("spark.sql.hive.convertCTAS").internal().doc("When true, a table created by a Hive CTAS statement (no USING clause) without specifying any storage property will be converted to a data source table, using the data source set by spark.sql.sources.default.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.GATHER_FASTSTAT = this.buildConf("spark.sql.hive.gatherFastStats").internal().doc("When true, fast stats (number of files and total size of all files) will be gathered in parallel while repairing table partitions to avoid the sequential listing in Hive metastore.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.PARTITION_COLUMN_TYPE_INFERENCE = this.buildConf("spark.sql.sources.partitionColumnTypeInference.enabled").doc("When true, automatically infer the data types for partitioned columns.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.BUCKETING_ENABLED = this.buildConf("spark.sql.sources.bucketing.enabled").doc("When false, we will treat bucketed table as normal table").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.CROSS_JOINS_ENABLED = this.buildConf("spark.sql.crossJoin.enabled").doc("When false, we will throw an error if a query contains a cartesian product without explicit CROSS JOIN syntax.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.ORDER_BY_ORDINAL = this.buildConf("spark.sql.orderByOrdinal").doc("When true, the ordinal numbers are treated as the position in the select list. When false, the ordinal numbers in order/sort by clause are ignored.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.GROUP_BY_ORDINAL = this.buildConf("spark.sql.groupByOrdinal").doc("When true, the ordinal numbers in group by clauses are treated as the position in the select list. When false, the ordinal numbers are ignored.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.GROUP_BY_ALIASES = this.buildConf("spark.sql.groupByAliases").doc("When true, aliases in a select list can be used in group by clauses. When false, an analysis exception is thrown in the case.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.OUTPUT_COMMITTER_CLASS = this.buildConf("spark.sql.sources.outputCommitterClass").internal().stringConf().createOptional();
        this.FILE_COMMIT_PROTOCOL_CLASS = this.buildConf("spark.sql.sources.commitProtocolClass").internal().stringConf().createWithDefault((Object)"org.apache.spark.sql.execution.datasources.SQLHadoopMapReduceCommitProtocol");
        this.PARALLEL_PARTITION_DISCOVERY_THRESHOLD = this.buildConf("spark.sql.sources.parallelPartitionDiscovery.threshold").doc("The maximum number of paths allowed for listing files at driver side. If the number of detected paths exceeds this value during partition discovery, it tries to list the files with another Spark distributed job. This applies to Parquet, ORC, CSV, JSON and LibSVM data sources.").intConf().checkValue((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(int parallel) {
                return this.apply$mcZI$sp(parallel);
            }

            public boolean apply$mcZI$sp(int parallel) {
                return parallel >= 0;
            }
        }, "The maximum number of paths allowed for listing files at driver side must not be negative").createWithDefault((Object)BoxesRunTime.boxToInteger((int)32));
        this.PARALLEL_PARTITION_DISCOVERY_PARALLELISM = this.buildConf("spark.sql.sources.parallelPartitionDiscovery.parallelism").doc("The number of parallelism to list a collection of path recursively, Set the number to prevent file listing from generating too many tasks.").internal().intConf().createWithDefault((Object)BoxesRunTime.boxToInteger((int)10000));
        this.DATAFRAME_SELF_JOIN_AUTO_RESOLVE_AMBIGUITY = this.buildConf("spark.sql.selfJoinAutoResolveAmbiguity").internal().booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.DATAFRAME_RETAIN_GROUP_COLUMNS = this.buildConf("spark.sql.retainGroupColumns").internal().booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.DATAFRAME_PIVOT_MAX_VALUES = this.buildConf("spark.sql.pivotMaxValues").doc("When doing a pivot without specifying values for the pivot column this is the maximum number of (distinct) values that will be collected without error.").intConf().createWithDefault((Object)BoxesRunTime.boxToInteger((int)10000));
        this.RUN_SQL_ON_FILES = this.buildConf("spark.sql.runSQLOnFiles").internal().doc("When true, we could use `datasource`.`path` as table in SQL query.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.WHOLESTAGE_CODEGEN_ENABLED = this.buildConf("spark.sql.codegen.wholeStage").internal().doc("When true, the whole stage (of multiple operators) will be compiled into single java method.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.WHOLESTAGE_MAX_NUM_FIELDS = this.buildConf("spark.sql.codegen.maxFields").internal().doc("The maximum number of fields (including nested fields) that will be supported before deactivating whole-stage codegen.").intConf().createWithDefault((Object)BoxesRunTime.boxToInteger((int)100));
        this.WHOLESTAGE_FALLBACK = this.buildConf("spark.sql.codegen.fallback").internal().doc("When true, whole stage codegen could be temporary disabled for the part of query that fail to compile generated code").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.MAX_CASES_BRANCHES = this.buildConf("spark.sql.codegen.maxCaseBranches").internal().doc("The maximum number of switches supported with codegen.").intConf().createWithDefault((Object)BoxesRunTime.boxToInteger((int)20));
        this.FILES_MAX_PARTITION_BYTES = this.buildConf("spark.sql.files.maxPartitionBytes").doc("The maximum number of bytes to pack into a single partition when reading files.").longConf().createWithDefault((Object)BoxesRunTime.boxToLong((long)0x8000000L));
        this.FILES_OPEN_COST_IN_BYTES = this.buildConf("spark.sql.files.openCostInBytes").internal().doc("The estimated cost to open a file, measured by the number of bytes could be scanned in the same time. This is used when putting multiple files into a partition. It's better to over estimated, then the partitions with small files will be faster than partitions with bigger files (which is scheduled first).").longConf().createWithDefault((Object)BoxesRunTime.boxToLong((long)0x400000L));
        this.IGNORE_CORRUPT_FILES = this.buildConf("spark.sql.files.ignoreCorruptFiles").doc("Whether to ignore corrupt files. If true, the Spark jobs will continue to run when encountering corrupted files and the contents that have been read will still be returned.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.MAX_RECORDS_PER_FILE = this.buildConf("spark.sql.files.maxRecordsPerFile").doc("Maximum number of records to write out to a single file. If this value is zero or negative, there is no limit.").longConf().createWithDefault((Object)BoxesRunTime.boxToLong((long)0L));
        this.EXCHANGE_REUSE_ENABLED = this.buildConf("spark.sql.exchange.reuse").internal().doc("When true, the planner will try to find out duplicated exchanges and re-use them.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.STATE_STORE_MIN_DELTAS_FOR_SNAPSHOT = this.buildConf("spark.sql.streaming.stateStore.minDeltasForSnapshot").internal().doc("Minimum number of state store delta files that needs to be generated before they consolidated into snapshots.").intConf().createWithDefault((Object)BoxesRunTime.boxToInteger((int)10));
        this.CHECKPOINT_LOCATION = this.buildConf("spark.sql.streaming.checkpointLocation").doc("The default location for storing checkpoint data for streaming queries.").stringConf().createOptional();
        this.MIN_BATCHES_TO_RETAIN = this.buildConf("spark.sql.streaming.minBatchesToRetain").internal().doc("The minimum number of batches that must be retained and made recoverable.").intConf().createWithDefault((Object)BoxesRunTime.boxToInteger((int)100));
        this.UNSUPPORTED_OPERATION_CHECK_ENABLED = this.buildConf("spark.sql.streaming.unsupportedOperationCheck").internal().doc("When true, the logical plan for streaming query will be checked for unsupported operations.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.VARIABLE_SUBSTITUTE_ENABLED = this.buildConf("spark.sql.variable.substitute").doc("This enables substitution using syntax like ${var} ${system:var} and ${env:var}.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.VARIABLE_SUBSTITUTE_DEPTH = this.buildConf("spark.sql.variable.substitute.depth").internal().doc("Deprecated: The maximum replacements the substitution engine will do.").intConf().createWithDefault((Object)BoxesRunTime.boxToInteger((int)40));
        this.ENABLE_TWOLEVEL_AGG_MAP = this.buildConf("spark.sql.codegen.aggregate.map.twolevel.enable").internal().doc("Enable two-level aggregate hash map. When enabled, records will first be inserted/looked-up at a 1st-level, small, fast map, and then fallback to a 2nd-level, larger, slower map when 1st level is full or keys cannot be found. When disabled, records go directly to the 2nd level. Defaults to true.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.MAX_NESTED_VIEW_DEPTH = this.buildConf("spark.sql.view.maxNestedViewDepth").internal().doc("The maximum depth of a view reference in a nested view. A nested view may reference other nested views, the dependencies are organized in a directed acyclic graph (DAG). However the DAG depth may become too large and cause unexpected behavior. This configuration puts a limit on this: when the depth of a view exceeds this value during analysis, we terminate the resolution to avoid potential errors.").intConf().checkValue((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(int depth) {
                return this.apply$mcZI$sp(depth);
            }

            public boolean apply$mcZI$sp(int depth) {
                return depth > 0;
            }
        }, "The maximum depth of a view reference in a nested view must be positive.").createWithDefault((Object)BoxesRunTime.boxToInteger((int)100));
        this.STREAMING_FILE_COMMIT_PROTOCOL_CLASS = this.buildConf("spark.sql.streaming.commitProtocolClass").internal().stringConf().createWithDefault((Object)"org.apache.spark.sql.execution.streaming.ManifestFileCommitProtocol");
        this.OBJECT_AGG_SORT_BASED_FALLBACK_THRESHOLD = this.buildConf("spark.sql.objectHashAggregate.sortBased.fallbackThreshold").internal().doc("In the case of ObjectHashAggregateExec, when the size of the in-memory hash map grows too large, we will fall back to sort-based aggregation. This option sets a row count threshold for the size of the hash map.").intConf().createWithDefault((Object)BoxesRunTime.boxToInteger((int)128));
        this.USE_OBJECT_HASH_AGG = this.buildConf("spark.sql.execution.useObjectHashAggregateExec").internal().doc("Decides if we use ObjectHashAggregateExec").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.FILE_SINK_LOG_DELETION = this.buildConf("spark.sql.streaming.fileSink.log.deletion").internal().doc("Whether to delete the expired log files in file stream sink.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.FILE_SINK_LOG_COMPACT_INTERVAL = this.buildConf("spark.sql.streaming.fileSink.log.compactInterval").internal().doc("Number of log files after which all the previous files are compacted into the next log file.").intConf().createWithDefault((Object)BoxesRunTime.boxToInteger((int)10));
        this.FILE_SINK_LOG_CLEANUP_DELAY = this.buildConf("spark.sql.streaming.fileSink.log.cleanupDelay").internal().doc("How long that a file is guaranteed to be visible for all readers.").timeConf(TimeUnit.MILLISECONDS).createWithDefault((Object)BoxesRunTime.boxToLong((long)TimeUnit.MINUTES.toMillis(10L)));
        this.FILE_SOURCE_LOG_DELETION = this.buildConf("spark.sql.streaming.fileSource.log.deletion").internal().doc("Whether to delete the expired log files in file stream source.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.FILE_SOURCE_LOG_COMPACT_INTERVAL = this.buildConf("spark.sql.streaming.fileSource.log.compactInterval").internal().doc("Number of log files after which all the previous files are compacted into the next log file.").intConf().createWithDefault((Object)BoxesRunTime.boxToInteger((int)10));
        this.FILE_SOURCE_LOG_CLEANUP_DELAY = this.buildConf("spark.sql.streaming.fileSource.log.cleanupDelay").internal().doc("How long in milliseconds a file is guaranteed to be visible for all readers.").timeConf(TimeUnit.MILLISECONDS).createWithDefault((Object)BoxesRunTime.boxToLong((long)TimeUnit.MINUTES.toMillis(10L)));
        this.STREAMING_SCHEMA_INFERENCE = this.buildConf("spark.sql.streaming.schemaInference").internal().doc("Whether file-based streaming sources will infer its own schema").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.STREAMING_POLLING_DELAY = this.buildConf("spark.sql.streaming.pollingDelay").internal().doc("How long to delay polling new data when no data is available").timeConf(TimeUnit.MILLISECONDS).createWithDefault((Object)BoxesRunTime.boxToLong((long)10L));
        this.STREAMING_NO_DATA_PROGRESS_EVENT_INTERVAL = this.buildConf("spark.sql.streaming.noDataProgressEventInterval").internal().doc("How long to wait between two progress events when there is no data").timeConf(TimeUnit.MILLISECONDS).createWithDefault((Object)BoxesRunTime.boxToLong((long)10000L));
        this.STREAMING_METRICS_ENABLED = this.buildConf("spark.sql.streaming.metricsEnabled").doc("Whether Dropwizard/Codahale metrics will be reported for active streaming queries.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.STREAMING_PROGRESS_RETENTION = this.buildConf("spark.sql.streaming.numRecentProgressUpdates").doc("The number of progress updates to retain for a streaming query").intConf().createWithDefault((Object)BoxesRunTime.boxToInteger((int)100));
        this.NDV_MAX_ERROR = this.buildConf("spark.sql.statistics.ndv.maxError").internal().doc("The maximum estimation error allowed in HyperLogLog++ algorithm when generating column level statistics.").doubleConf().createWithDefault((Object)BoxesRunTime.boxToDouble((double)0.05));
        this.CBO_ENABLED = this.buildConf("spark.sql.cbo.enabled").doc("Enables CBO for estimation of plan statistics when set true.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.JOIN_REORDER_ENABLED = this.buildConf("spark.sql.cbo.joinReorder.enabled").doc("Enables join reorder in CBO.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.JOIN_REORDER_DP_THRESHOLD = this.buildConf("spark.sql.cbo.joinReorder.dp.threshold").doc("The maximum number of joined nodes allowed in the dynamic programming algorithm.").intConf().checkValue((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(int number) {
                return this.apply$mcZI$sp(number);
            }

            public boolean apply$mcZI$sp(int number) {
                return number > 0;
            }
        }, "The maximum number must be a positive integer.").createWithDefault((Object)BoxesRunTime.boxToInteger((int)12));
        this.JOIN_REORDER_CARD_WEIGHT = this.buildConf("spark.sql.cbo.joinReorder.card.weight").internal().doc("The weight of cardinality (number of rows) for plan cost comparison in join reorder: rows * weight + size * (1 - weight).").doubleConf().checkValue((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(double weight) {
                return this.apply$mcZD$sp(weight);
            }

            public boolean apply$mcZD$sp(double weight) {
                return weight >= 0.0 && weight <= 1.0;
            }
        }, "The weight value must be in [0, 1].").createWithDefault((Object)BoxesRunTime.boxToDouble((double)0.7));
        this.JOIN_REORDER_DP_STAR_FILTER = this.buildConf("spark.sql.cbo.joinReorder.dp.star.filter").doc("Applies star-join filter heuristics to cost based join enumeration.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.STARSCHEMA_DETECTION = this.buildConf("spark.sql.cbo.starSchemaDetection").doc("When true, it enables join reordering based on star schema detection. ").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.STARSCHEMA_FACT_TABLE_RATIO = this.buildConf("spark.sql.cbo.starJoinFTRatio").internal().doc("Specifies the upper limit of the ratio between the largest fact tables for a star join to be considered. ").doubleConf().createWithDefault((Object)BoxesRunTime.boxToDouble((double)0.9));
        this.SESSION_LOCAL_TIMEZONE = this.buildConf("spark.sql.session.timeZone").doc("The ID of session local timezone, e.g. \"GMT\", \"America/Los_Angeles\", etc.").stringConf().createWithDefaultFunction((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return TimeZone.getDefault().getID();
            }
        });
        this.WINDOW_EXEC_BUFFER_IN_MEMORY_THRESHOLD = this.buildConf("spark.sql.windowExec.buffer.in.memory.threshold").internal().doc("Threshold for number of rows guaranteed to be held in memory by the window operator").intConf().createWithDefault((Object)BoxesRunTime.boxToInteger((int)4096));
        this.WINDOW_EXEC_BUFFER_SPILL_THRESHOLD = this.buildConf("spark.sql.windowExec.buffer.spill.threshold").internal().doc("Threshold for number of rows to be spilled by window operator").intConf().createWithDefault((Object)BoxesRunTime.boxToInteger((int)((int)0x20000000L)));
        this.SORT_MERGE_JOIN_EXEC_BUFFER_IN_MEMORY_THRESHOLD = this.buildConf("spark.sql.sortMergeJoinExec.buffer.in.memory.threshold").internal().doc("Threshold for number of rows guaranteed to be held in memory by the sort merge join operator").intConf().createWithDefault((Object)BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE));
        this.SORT_MERGE_JOIN_EXEC_BUFFER_SPILL_THRESHOLD = this.buildConf("spark.sql.sortMergeJoinExec.buffer.spill.threshold").internal().doc("Threshold for number of rows to be spilled by sort merge join operator").intConf().createWithDefault((Object)BoxesRunTime.boxToInteger((int)((int)0x20000000L)));
        this.CARTESIAN_PRODUCT_EXEC_BUFFER_IN_MEMORY_THRESHOLD = this.buildConf("spark.sql.cartesianProductExec.buffer.in.memory.threshold").internal().doc("Threshold for number of rows guaranteed to be held in memory by the cartesian product operator").intConf().createWithDefault((Object)BoxesRunTime.boxToInteger((int)4096));
        this.CARTESIAN_PRODUCT_EXEC_BUFFER_SPILL_THRESHOLD = this.buildConf("spark.sql.cartesianProductExec.buffer.spill.threshold").internal().doc("Threshold for number of rows to be spilled by cartesian product operator").intConf().createWithDefault((Object)BoxesRunTime.boxToInteger((int)((int)0x20000000L)));
        this.SQL_OPTIONS_REDACTION_PATTERN = this.buildConf("spark.sql.redaction.options.regex").doc(new StringBuilder().append((Object)"Regex to decide which keys in a Spark SQL command's options map contain sensitive information. The values of options whose names that match this regex will be redacted in the explain output. This redaction is applied on top of the global redaction ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"configuration defined by ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{package$.MODULE$.SECRET_REDACTION_PATTERN().key()}))).toString()).regexConf().createWithDefault((Object)new StringOps(Predef$.MODULE$.augmentString("(?i)url")).r());
    }
}

