/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.analysis;

import org.apache.spark.sql.catalyst.analysis.package$;
import org.apache.spark.sql.catalyst.dsl.package$expressions$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.Ceil;
import org.apache.spark.sql.catalyst.expressions.CreateNamedStruct;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.PreciseTimestamp;
import org.apache.spark.sql.catalyst.expressions.Predicate;
import org.apache.spark.sql.catalyst.expressions.TimeWindow;
import org.apache.spark.sql.catalyst.plans.QueryPlan;
import org.apache.spark.sql.catalyst.plans.logical.Expand;
import org.apache.spark.sql.catalyst.plans.logical.Filter;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.rules.Rule;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.Metadata$;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;

public final class TimeWindowing$
extends Rule<LogicalPlan> {
    public static final TimeWindowing$ MODULE$;
    private final String WINDOW_START;
    private final String WINDOW_END;

    static {
        new TimeWindowing$();
    }

    private final String WINDOW_START() {
        return "start";
    }

    private final String WINDOW_END() {
        return "end";
    }

    @Override
    public LogicalPlan apply(LogicalPlan plan2) {
        return plan2.resolveOperators((PartialFunction<LogicalPlan, LogicalPlan>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x82, Function1<A1, B1> function1) {
                Object object;
                A1 A1;
                A1 A12 = x82;
                if (A12 != null && (A1 = A12).children().size() == 1) {
                    Object object2;
                    LogicalPlan child = (LogicalPlan)A1.children().head();
                    List windowExpressions = ((TraversableOnce)((SeqLike)A1.expressions().flatMap((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Seq<TimeWindow> apply(Expression x$135) {
                            return x$135.collect(new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final <A1 extends Expression, B1> B1 applyOrElse(A1 x83, Function1<A1, B1> function1) {
                                    Object object;
                                    A1 A1 = x83;
                                    if (A1 instanceof TimeWindow) {
                                        TimeWindow timeWindow = (TimeWindow)A1;
                                        object = timeWindow;
                                    } else {
                                        object = function1.apply(x83);
                                    }
                                    return (B1)object;
                                }

                                public final boolean isDefinedAt(Expression x83) {
                                    Expression expression = x83;
                                    boolean bl = expression instanceof TimeWindow;
                                    return bl;
                                }
                            });
                        }
                    }, Seq$.MODULE$.canBuildFrom())).distinct()).toList();
                    if (windowExpressions.size() == 1 && ((TimeWindow)windowExpressions.head()).timeColumn().resolved() && ((TimeWindow)windowExpressions.head()).checkInputDataTypes().isSuccess()) {
                        Metadata metadata2;
                        TimeWindow window = (TimeWindow)windowExpressions.head();
                        Expression expression = window.timeColumn();
                        if (expression instanceof Attribute) {
                            Attribute attribute = (Attribute)expression;
                            metadata2 = attribute.metadata();
                        } else {
                            metadata2 = Metadata$.MODULE$.empty();
                        }
                        Metadata metadata3 = metadata2;
                        String x$374 = "window";
                        DataType x$375 = window.dataType();
                        Metadata x$376 = metadata3;
                        boolean x$377 = AttributeReference$.MODULE$.apply$default$3();
                        ExprId x$378 = AttributeReference$.MODULE$.apply$default$5(x$374, x$375, x$377, x$376);
                        Option<String> x$379 = AttributeReference$.MODULE$.apply$default$6(x$374, x$375, x$377, x$376);
                        Boolean x$380 = AttributeReference$.MODULE$.apply$default$7(x$374, x$375, x$377, x$376);
                        AttributeReference windowAttr = new AttributeReference(x$374, x$375, x$377, x$376, x$378, x$379, x$380);
                        int maxNumOverlapping = (int)scala.math.package$.MODULE$.ceil((double)window.windowDuration() * 1.0 / (double)window.slideDuration());
                        Seq windows = (Seq)Seq$.MODULE$.tabulate(maxNumOverlapping + 1, (Function1)new Serializable(this, window, maxNumOverlapping){
                            public static final long serialVersionUID = 0L;
                            private final TimeWindow window$1;
                            private final int maxNumOverlapping$1;

                            public final CreateNamedStruct apply(int i) {
                                Ceil windowId = new Ceil(package$expressions$.MODULE$.DslExpression(package$expressions$.MODULE$.DslExpression(new PreciseTimestamp(this.window$1.timeColumn())).$minus(package$expressions$.MODULE$.longToLiteral(this.window$1.startTime()))).$div(package$expressions$.MODULE$.longToLiteral(this.window$1.slideDuration())));
                                Expression windowStart = package$expressions$.MODULE$.DslExpression(package$expressions$.MODULE$.DslExpression(package$expressions$.MODULE$.DslExpression(package$expressions$.MODULE$.DslExpression(windowId).$plus(package$expressions$.MODULE$.intToLiteral(i))).$minus(package$expressions$.MODULE$.intToLiteral(this.maxNumOverlapping$1))).$times(package$expressions$.MODULE$.longToLiteral(this.window$1.slideDuration()))).$plus(package$expressions$.MODULE$.longToLiteral(this.window$1.startTime()));
                                Expression windowEnd = package$expressions$.MODULE$.DslExpression(windowStart).$plus(package$expressions$.MODULE$.longToLiteral(this.window$1.windowDuration()));
                                Literal literal = Literal$.MODULE$.apply("start");
                                Expression expression = windowStart;
                                Literal literal2 = Literal$.MODULE$.apply("end");
                                Expression expression2 = windowEnd;
                                return new CreateNamedStruct((Seq<Expression>)Nil$.MODULE$.$colon$colon((Object)expression2).$colon$colon((Object)literal2).$colon$colon((Object)expression).$colon$colon((Object)literal));
                            }
                            {
                                this.window$1 = window$1;
                                this.maxNumOverlapping$1 = maxNumOverlapping$1;
                            }
                        });
                        Seq projections = (Seq)windows.map((Function1)new Serializable(this, A1){
                            public static final long serialVersionUID = 0L;
                            private final LogicalPlan x2$8;

                            public final Seq<Expression> apply(CreateNamedStruct x$140) {
                                CreateNamedStruct createNamedStruct = x$140;
                                return (Seq)((QueryPlan)this.x2$8.children().head()).output().$plus$colon((Object)createNamedStruct, Seq$.MODULE$.canBuildFrom());
                            }
                            {
                                this.x2$8 = x2$8;
                            }
                        }, Seq$.MODULE$.canBuildFrom());
                        Predicate filterExpr = package$expressions$.MODULE$.DslExpression((Expression)((Object)package$expressions$.MODULE$.DslExpression(window.timeColumn()).$greater$eq(package$expressions$.MODULE$.DslExpression(windowAttr).getField("start")))).$amp$amp((Expression)((Object)package$expressions$.MODULE$.DslExpression(window.timeColumn()).$less(package$expressions$.MODULE$.DslExpression(windowAttr).getField("end"))));
                        AttributeReference attributeReference = windowAttr;
                        Filter expandedPlan = new Filter((Expression)((Object)filterExpr), new Expand((Seq<Seq<Expression>>)projections, (Seq<Attribute>)((Seq)child.output().$plus$colon((Object)attributeReference, Seq$.MODULE$.canBuildFrom())), child));
                        LogicalPlan substitutedPlan = (LogicalPlan)A1.transformExpressions((PartialFunction<Expression, Expression>)new Serializable(this, windowAttr){
                            public static final long serialVersionUID = 0L;
                            private final AttributeReference windowAttr$1;

                            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x84, Function1<A1, B1> function1) {
                                A1 A1 = x84;
                                Object object = A1 instanceof TimeWindow ? this.windowAttr$1 : function1.apply(x84);
                                return (B1)object;
                            }

                            public final boolean isDefinedAt(Expression x84) {
                                Expression expression = x84;
                                boolean bl = expression instanceof TimeWindow;
                                return bl;
                            }
                            {
                                this.windowAttr$1 = windowAttr$1;
                            }
                        });
                        Filter filter2 = expandedPlan;
                        object2 = substitutedPlan.withNewChildren(Nil$.MODULE$.$colon$colon((Object)filter2));
                    } else {
                        if (windowExpressions.size() > 1) {
                            throw package$.MODULE$.AnalysisErrorAt(A1).failAnalysis("Multiple time window expressions would result in a cartesian product of rows, therefore they are currently not supported.");
                        }
                        object2 = A1;
                    }
                    object = object2;
                } else {
                    object = function1.apply(x82);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(LogicalPlan x82) {
                LogicalPlan logicalPlan;
                LogicalPlan logicalPlan2 = x82;
                boolean bl = logicalPlan2 != null && (logicalPlan = logicalPlan2).children().size() == 1;
                return bl;
            }
        });
    }

    private TimeWindowing$() {
        MODULE$ = this;
    }
}

