/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.catalog;

import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkException;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.catalyst.FunctionIdentifier;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.analysis.DatabaseAlreadyExistsException;
import org.apache.spark.sql.catalyst.analysis.NoSuchDatabaseException;
import org.apache.spark.sql.catalyst.analysis.NoSuchPartitionException;
import org.apache.spark.sql.catalyst.analysis.NoSuchPartitionsException;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.analysis.PartitionAlreadyExistsException;
import org.apache.spark.sql.catalyst.analysis.PartitionsAlreadyExistException;
import org.apache.spark.sql.catalyst.analysis.TableAlreadyExistsException;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.catalog.CatalogDatabase;
import org.apache.spark.sql.catalyst.catalog.CatalogFunction;
import org.apache.spark.sql.catalyst.catalog.CatalogStatistics;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTablePartition;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.ExternalCatalog;
import org.apache.spark.sql.catalyst.catalog.ExternalCatalogUtils$;
import org.apache.spark.sql.catalyst.catalog.FunctionResource;
import org.apache.spark.sql.catalyst.catalog.InMemoryCatalog$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.util.StringUtils$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\r=e\u0001B\u0001\u0003\u0001=\u0011q\"\u00138NK6|'/_\"bi\u0006dwn\u001a\u0006\u0003\u0007\u0011\tqaY1uC2|wM\u0003\u0002\u0006\r\u0005A1-\u0019;bYf\u001cHO\u0003\u0002\b\u0011\u0005\u00191/\u001d7\u000b\u0005%Q\u0011!B:qCJ\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001!A\u0011\u0011CE\u0007\u0002\u0005%\u00111C\u0001\u0002\u0010\u000bb$XM\u001d8bY\u000e\u000bG/\u00197pO\"AQ\u0003\u0001B\u0001B\u0003%a#\u0001\u0003d_:4\u0007CA\f\u0019\u001b\u0005A\u0011BA\r\t\u0005%\u0019\u0006/\u0019:l\u0007>tg\r\u0003\u0005\u001c\u0001\t\u0005\t\u0015!\u0003\u001d\u00031A\u0017\rZ8pa\u000e{gNZ5h!\ti\u0012%D\u0001\u001f\u0015\t)rD\u0003\u0002!\u0015\u00051\u0001.\u00193p_BL!A\t\u0010\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0011\u0015!\u0003\u0001\"\u0001&\u0003\u0019a\u0014N\\5u}Q\u0019ae\n\u0015\u0011\u0005E\u0001\u0001bB\u000b$!\u0003\u0005\rA\u0006\u0005\b7\r\u0002\n\u00111\u0001\u001d\r\u0011Q\u0003\u0001B\u0016\u0003\u0013Q\u000b'\r\\3EKN\u001c7CA\u0015-!\ti\u0003'D\u0001/\u0015\u0005y\u0013!B:dC2\f\u0017BA\u0019/\u0005\u0019\te.\u001f*fM\"A1'\u000bBA\u0002\u0013\u0005A'A\u0003uC\ndW-F\u00016!\t\tb'\u0003\u00028\u0005\ta1)\u0019;bY><G+\u00192mK\"A\u0011(\u000bBA\u0002\u0013\u0005!(A\u0005uC\ndWm\u0018\u0013fcR\u00111H\u0010\t\u0003[qJ!!\u0010\u0018\u0003\tUs\u0017\u000e\u001e\u0005\b\u007fa\n\t\u00111\u00016\u0003\rAH%\r\u0005\t\u0003&\u0012\t\u0011)Q\u0005k\u00051A/\u00192mK\u0002BQ\u0001J\u0015\u0005\u0002\r#\"\u0001\u0012$\u0011\u0005\u0015KS\"\u0001\u0001\t\u000bM\u0012\u0005\u0019A\u001b\t\u000f!K#\u0019!C\u0001\u0013\u0006Q\u0001/\u0019:uSRLwN\\:\u0016\u0003)\u0003Ba\u0013)S36\tAJ\u0003\u0002N\u001d\u00069Q.\u001e;bE2,'BA(/\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003#2\u0013q\u0001S1tQ6\u000b\u0007\u000f\u0005\u0002T-:\u0011\u0011\u0003V\u0005\u0003+\n\tAbQ1uC2|w\rV=qKNL!a\u0016-\u0003%Q\u000b'\r\\3QCJ$\u0018\u000e^5p]N\u0003Xm\u0019\u0006\u0003+\n\u0001\"!\u0005.\n\u0005m\u0013!!F\"bi\u0006dwn\u001a+bE2,\u0007+\u0019:uSRLwN\u001c\u0005\u0007;&\u0002\u000b\u0011\u0002&\u0002\u0017A\f'\u000f^5uS>t7\u000f\t\u0004\u0005?\u0002!\u0001M\u0001\u0007ECR\f'-Y:f\t\u0016\u001c8m\u0005\u0002_Y!A!M\u0018BA\u0002\u0013\u00051-\u0001\u0002eEV\tA\r\u0005\u0002\u0012K&\u0011aM\u0001\u0002\u0010\u0007\u0006$\u0018\r\\8h\t\u0006$\u0018MY1tK\"A\u0001N\u0018BA\u0002\u0013\u0005\u0011.\u0001\u0004eE~#S-\u001d\u000b\u0003w)DqaP4\u0002\u0002\u0003\u0007A\r\u0003\u0005m=\n\u0005\t\u0015)\u0003e\u0003\r!'\r\t\u0005\u0006Iy#\tA\u001c\u000b\u0003_B\u0004\"!\u00120\t\u000b\tl\u0007\u0019\u00013\t\u000fIt&\u0019!C\u0001g\u00061A/\u00192mKN,\u0012\u0001\u001e\t\u0005\u0017B+H\t\u0005\u0002ws:\u0011Qf^\u0005\u0003q:\na\u0001\u0015:fI\u00164\u0017B\u0001>|\u0005\u0019\u0019FO]5oO*\u0011\u0001P\f\u0005\u0007{z\u0003\u000b\u0011\u0002;\u0002\u000fQ\f'\r\\3tA!AqP\u0018b\u0001\n\u0003\t\t!A\u0005gk:\u001cG/[8ogV\u0011\u00111\u0001\t\u0006\u0017B+\u0018Q\u0001\t\u0004#\u0005\u001d\u0011bAA\u0005\u0005\ty1)\u0019;bY><g)\u001e8di&|g\u000e\u0003\u0005\u0002\u000ey\u0003\u000b\u0011BA\u0002\u0003)1WO\\2uS>t7\u000f\t\u0005\t\u0007\u0001\u0011\r\u0011\"\u0003\u0002\u0012U\u0011\u00111\u0003\t\u0005\u0017B+x\u000e\u0003\u0005\u0002\u0018\u0001\u0001\u000b\u0011BA\n\u0003!\u0019\u0017\r^1m_\u001e\u0004\u0003bBA\u000e\u0001\u0011%\u0011QD\u0001\u0010a\u0006\u0014H/\u001b;j_:,\u00050[:ugRA\u0011qDA\u0013\u0003O\tI\u0003E\u0002.\u0003CI1!a\t/\u0005\u001d\u0011un\u001c7fC:DaAYA\r\u0001\u0004)\bBB\u001a\u0002\u001a\u0001\u0007Q\u000fC\u0004\u0002,\u0005e\u0001\u0019\u0001*\u0002\tM\u0004Xm\u0019\u0005\b\u0003_\u0001A\u0011BA\u0019\u0003U\u0011X-];je\u0016$\u0016M\u00197f\u001d>$X\t_5tiN$RaOA\u001a\u0003kAaAYA\u0017\u0001\u0004)\bBB\u001a\u0002.\u0001\u0007Q\u000fC\u0004\u0002:\u0001!I!a\u000f\u0002-I,\u0017/^5sKB\u000b'\u000f^5uS>t7/\u0012=jgR$raOA\u001f\u0003\u007f\t\t\u0005\u0003\u0004c\u0003o\u0001\r!\u001e\u0005\u0007g\u0005]\u0002\u0019A;\t\u0011\u0005\r\u0013q\u0007a\u0001\u0003\u000b\nQa\u001d9fGN\u0004R!a\u0012\u0002XIsA!!\u0013\u0002T9!\u00111JA)\u001b\t\tiEC\u0002\u0002P9\ta\u0001\u0010:p_Rt\u0014\"A\u0018\n\u0007\u0005Uc&A\u0004qC\u000e\\\u0017mZ3\n\t\u0005e\u00131\f\u0002\u0004'\u0016\f(bAA+]!9\u0011q\f\u0001\u0005\n\u0005\u0005\u0014!\u0007:fcVL'/\u001a)beRLG/[8og:{G/\u0012=jgR$raOA2\u0003K\n9\u0007\u0003\u0004c\u0003;\u0002\r!\u001e\u0005\u0007g\u0005u\u0003\u0019A;\t\u0011\u0005\r\u0013Q\fa\u0001\u0003\u000bBq!a\u001b\u0001\t#\ni'\u0001\te_\u000e\u0013X-\u0019;f\t\u0006$\u0018MY1tKR)1(a\u001c\u0002t!9\u0011\u0011OA5\u0001\u0004!\u0017\u0001\u00043c\t\u00164\u0017N\\5uS>t\u0007\u0002CA;\u0003S\u0002\r!a\b\u0002\u001d%<gn\u001c:f\u0013\u001a,\u00050[:ug\"9\u0011\u0011\u0010\u0001\u0005R\u0005m\u0014A\u00043p\tJ|\u0007\u000fR1uC\n\f7/\u001a\u000b\bw\u0005u\u0014qPAB\u0011\u0019\u0011\u0017q\u000fa\u0001k\"A\u0011\u0011QA<\u0001\u0004\ty\"A\tjO:|'/Z%g\u001d>$X\t_5tiND\u0001\"!\"\u0002x\u0001\u0007\u0011qD\u0001\bG\u0006\u001c8-\u00193f\u0011\u001d\tI\t\u0001C!\u0003\u0017\u000bQ\"\u00197uKJ$\u0015\r^1cCN,GcA\u001e\u0002\u000e\"9\u0011\u0011OAD\u0001\u0004!\u0007bBAI\u0001\u0011\u0005\u00131S\u0001\fO\u0016$H)\u0019;bE\u0006\u001cX\rF\u0002e\u0003+CaAYAH\u0001\u0004)\bbBAM\u0001\u0011\u0005\u00131T\u0001\u000fI\u0006$\u0018MY1tK\u0016C\u0018n\u001d;t)\u0011\ty\"!(\t\r\t\f9\n1\u0001v\u0011\u001d\t\t\u000b\u0001C!\u0003G\u000bQ\u0002\\5ti\u0012\u000bG/\u00192bg\u0016\u001cHCAAS!\u0015\t9%a\u0016v\u0011\u001d\t\t\u000b\u0001C!\u0003S#B!!*\u0002,\"9\u0011QVAT\u0001\u0004)\u0018a\u00029biR,'O\u001c\u0005\b\u0003c\u0003A\u0011IAZ\u0003I\u0019X\r^\"veJ,g\u000e\u001e#bi\u0006\u0014\u0017m]3\u0015\u0007m\n)\f\u0003\u0004c\u0003_\u0003\r!\u001e\u0005\b\u0003s\u0003A\u0011KA^\u00035!wn\u0011:fCR,G+\u00192mKR)1(!0\u0002B\"9\u0011qXA\\\u0001\u0004)\u0014a\u0004;bE2,G)\u001a4j]&$\u0018n\u001c8\t\u0011\u0005U\u0014q\u0017a\u0001\u0003?Aq!!2\u0001\t#\n9-A\u0006e_\u0012\u0013x\u000e\u001d+bE2,G#C\u001e\u0002J\u0006-\u0017QZAh\u0011\u0019\u0011\u00171\u0019a\u0001k\"11'a1A\u0002UD\u0001\"!!\u0002D\u0002\u0007\u0011q\u0004\u0005\t\u0003#\f\u0019\r1\u0001\u0002 \u0005)\u0001/\u001e:hK\"9\u0011Q\u001b\u0001\u0005R\u0005]\u0017!\u00043p%\u0016t\u0017-\\3UC\ndW\rF\u0004<\u00033\fY.a8\t\r\t\f\u0019\u000e1\u0001v\u0011\u001d\ti.a5A\u0002U\fqa\u001c7e\u001d\u0006lW\rC\u0004\u0002b\u0006M\u0007\u0019A;\u0002\u000f9,wOT1nK\"9\u0011Q\u001d\u0001\u0005B\u0005\u001d\u0018AC1mi\u0016\u0014H+\u00192mKR\u00191(!;\t\u000f\u0005}\u00161\u001da\u0001k!9\u0011Q\u001e\u0001\u0005B\u0005=\u0018\u0001F1mi\u0016\u0014H+\u00192mK\u0012\u000bG/Y*dQ\u0016l\u0017\rF\u0004<\u0003c\f\u00190!>\t\r\t\fY\u000f1\u0001v\u0011\u0019\u0019\u00141\u001ea\u0001k\"A\u0011q_Av\u0001\u0004\tI0A\u0007oK^$\u0015\r^1TG\",W.\u0019\t\u0005\u0003w\u0014\t!\u0004\u0002\u0002~*\u0019\u0011q \u0004\u0002\u000bQL\b/Z:\n\t\t\r\u0011Q \u0002\u000b'R\u0014Xo\u0019;UsB,\u0007b\u0002B\u0004\u0001\u0011\u0005#\u0011B\u0001\tO\u0016$H+\u00192mKR)QGa\u0003\u0003\u000e!1!M!\u0002A\u0002UDaa\rB\u0003\u0001\u0004)\bb\u0002B\t\u0001\u0011\u0005#1C\u0001\fi\u0006\u0014G.Z#ySN$8\u000f\u0006\u0004\u0002 \tU!q\u0003\u0005\u0007E\n=\u0001\u0019A;\t\rM\u0012y\u00011\u0001v\u0011\u001d\u0011Y\u0002\u0001C!\u0005;\t!\u0002\\5tiR\u000b'\r\\3t)\u0011\t)Ka\b\t\r\t\u0014I\u00021\u0001v\u0011\u001d\u0011Y\u0002\u0001C!\u0005G!b!!*\u0003&\t\u001d\u0002B\u00022\u0003\"\u0001\u0007Q\u000fC\u0004\u0002.\n\u0005\u0002\u0019A;\t\u000f\t-\u0002\u0001\"\u0011\u0003.\u0005IAn\\1e)\u0006\u0014G.\u001a\u000b\fw\t=\"\u0011\u0007B\u001a\u0005o\u0011Y\u0004\u0003\u0004c\u0005S\u0001\r!\u001e\u0005\u0007g\t%\u0002\u0019A;\t\u000f\tU\"\u0011\u0006a\u0001k\u0006AAn\\1e!\u0006$\b\u000e\u0003\u0005\u0003:\t%\u0002\u0019AA\u0010\u0003-I7o\u0014<fe^\u0014\u0018\u000e^3\t\u0011\tu\"\u0011\u0006a\u0001\u0003?\t!\"[:Te\u000edunY1m\u0011\u001d\u0011\t\u0005\u0001C!\u0005\u0007\nQ\u0002\\8bIB\u000b'\u000f^5uS>tGcD\u001e\u0003F\t\u001d#\u0011\nB&\u0005\u001f\u0012\tF!\u0016\t\r\t\u0014y\u00041\u0001v\u0011\u0019\u0019$q\ba\u0001k\"9!Q\u0007B \u0001\u0004)\bb\u0002B'\u0005\u007f\u0001\rAU\u0001\na\u0006\u0014H/\u001b;j_:D\u0001B!\u000f\u0003@\u0001\u0007\u0011q\u0004\u0005\t\u0005'\u0012y\u00041\u0001\u0002 \u0005\t\u0012N\u001c5fe&$H+\u00192mKN\u0003XmY:\t\u0011\tu\"q\ba\u0001\u0003?AqA!\u0017\u0001\t\u0003\u0012Y&A\u000bm_\u0006$G)\u001f8b[&\u001c\u0007+\u0019:uSRLwN\\:\u0015\u001bm\u0012iFa\u0018\u0003b\t\r$Q\rB5\u0011\u0019\u0011'q\u000ba\u0001k\"11Ga\u0016A\u0002UDqA!\u000e\u0003X\u0001\u0007Q\u000fC\u0004\u0003N\t]\u0003\u0019\u0001*\t\u0011\t\u001d$q\u000ba\u0001\u0003?\tqA]3qY\u0006\u001cW\r\u0003\u0005\u0003l\t]\u0003\u0019\u0001B7\u0003\u0015qW/\u001c#Q!\ri#qN\u0005\u0004\u0005cr#aA%oi\"9!Q\u000f\u0001\u0005B\t]\u0014\u0001E2sK\u0006$X\rU1si&$\u0018n\u001c8t)%Y$\u0011\u0010B>\u0005{\u0012\u0019\t\u0003\u0004c\u0005g\u0002\r!\u001e\u0005\u0007g\tM\u0004\u0019A;\t\u0011\t}$1\u000fa\u0001\u0005\u0003\u000bQ\u0001]1siN\u0004R!a\u0012\u0002XeC\u0001\"!\u001e\u0003t\u0001\u0007\u0011q\u0004\u0005\b\u0005\u000f\u0003A\u0011\tBE\u00039!'o\u001c9QCJ$\u0018\u000e^5p]N$Rb\u000fBF\u0005\u001b\u0013yIa%\u0003\u0016\n]\u0005B\u00022\u0003\u0006\u0002\u0007Q\u000f\u0003\u00044\u0005\u000b\u0003\r!\u001e\u0005\t\u0005#\u0013)\t1\u0001\u0002F\u0005I\u0001/\u0019:u'B,7m\u001d\u0005\t\u0003\u0003\u0013)\t1\u0001\u0002 !A\u0011\u0011\u001bBC\u0001\u0004\ty\u0002\u0003\u0005\u0003\u001a\n\u0015\u0005\u0019AA\u0010\u0003)\u0011X\r^1j]\u0012\u000bG/\u0019\u0005\b\u0005;\u0003A\u0011\tBP\u0003A\u0011XM\\1nKB\u000b'\u000f^5uS>t7\u000fF\u0005<\u0005C\u0013\u0019K!*\u0003(\"1!Ma'A\u0002UDaa\rBN\u0001\u0004)\b\u0002CA\"\u00057\u0003\r!!\u0012\t\u0011\t%&1\u0014a\u0001\u0003\u000b\n\u0001B\\3x'B,7m\u001d\u0005\b\u0005[\u0003A\u0011\tBX\u0003=\tG\u000e^3s!\u0006\u0014H/\u001b;j_:\u001cHcB\u001e\u00032\nM&Q\u0017\u0005\u0007E\n-\u0006\u0019A;\t\rM\u0012Y\u000b1\u0001v\u0011!\u0011yHa+A\u0002\t\u0005\u0005b\u0002B]\u0001\u0011\u0005#1X\u0001\rO\u0016$\b+\u0019:uSRLwN\u001c\u000b\b3\nu&q\u0018Ba\u0011\u0019\u0011'q\u0017a\u0001k\"11Ga.A\u0002UDq!a\u000b\u00038\u0002\u0007!\u000bC\u0004\u0003F\u0002!\tEa2\u0002%\u001d,G\u000fU1si&$\u0018n\u001c8PaRLwN\u001c\u000b\t\u0005\u0013\u0014yM!5\u0003TB!QFa3Z\u0013\r\u0011iM\f\u0002\u0007\u001fB$\u0018n\u001c8\t\r\t\u0014\u0019\r1\u0001v\u0011\u0019\u0019$1\u0019a\u0001k\"9\u00111\u0006Bb\u0001\u0004\u0011\u0006b\u0002Bl\u0001\u0011\u0005#\u0011\\\u0001\u0013Y&\u001cH\u000fU1si&$\u0018n\u001c8OC6,7\u000f\u0006\u0005\u0002&\nm'Q\u001cBp\u0011\u0019\u0011'Q\u001ba\u0001k\"11G!6A\u0002UD!B!9\u0003VB\u0005\t\u0019\u0001Br\u0003-\u0001\u0018M\u001d;jC2\u001c\u0006/Z2\u0011\t5\u0012YM\u0015\u0005\b\u0005O\u0004A\u0011\tBu\u00039a\u0017n\u001d;QCJ$\u0018\u000e^5p]N$\u0002B!!\u0003l\n5(q\u001e\u0005\u0007E\n\u0015\b\u0019A;\t\rM\u0012)\u000f1\u0001v\u0011)\u0011\tO!:\u0011\u0002\u0003\u0007!1\u001d\u0005\b\u0005g\u0004A\u0011\tB{\u0003Ya\u0017n\u001d;QCJ$\u0018\u000e^5p]N\u0014\u0015PR5mi\u0016\u0014HC\u0003BA\u0005o\u0014IPa?\u0004\u000e!1!M!=A\u0002UDaa\rBy\u0001\u0004)\b\u0002\u0003B\u007f\u0005c\u0004\rAa@\u0002\u0015A\u0014X\rZ5dCR,7\u000f\u0005\u0004\u0002H\u0005]3\u0011\u0001\t\u0005\u0007\u0007\u0019I!\u0004\u0002\u0004\u0006)\u00191q\u0001\u0003\u0002\u0017\u0015D\bO]3tg&|gn]\u0005\u0005\u0007\u0017\u0019)A\u0001\u0006FqB\u0014Xm]:j_:Dqaa\u0004\u0003r\u0002\u0007Q/A\teK\u001a\fW\u000f\u001c;US6,'l\u001c8f\u0013\u0012Dqaa\u0005\u0001\t#\u001a)\"\u0001\te_\u000e\u0013X-\u0019;f\rVt7\r^5p]R)1ha\u0006\u0004\u001a!1!m!\u0005A\u0002UD\u0001ba\u0007\u0004\u0012\u0001\u0007\u0011QA\u0001\u0005MVt7\rC\u0004\u0004 \u0001!\tf!\t\u0002\u001d\u0011|GI]8q\rVt7\r^5p]R)1ha\t\u0004&!1!m!\bA\u0002UDqaa\n\u0004\u001e\u0001\u0007Q/\u0001\u0005gk:\u001cg*Y7f\u0011\u001d\u0019Y\u0003\u0001C)\u0007[\t\u0001\u0003Z8SK:\fW.\u001a$v]\u000e$\u0018n\u001c8\u0015\u000fm\u001ayc!\r\u00044!1!m!\u000bA\u0002UDq!!8\u0004*\u0001\u0007Q\u000fC\u0004\u0002b\u000e%\u0002\u0019A;\t\u000f\r]\u0002\u0001\"\u0011\u0004:\u0005Yq-\u001a;Gk:\u001cG/[8o)\u0019\t)aa\u000f\u0004>!1!m!\u000eA\u0002UDqaa\n\u00046\u0001\u0007Q\u000fC\u0004\u0004B\u0001!\tea\u0011\u0002\u001d\u0019,hn\u0019;j_:,\u00050[:ugR1\u0011qDB#\u0007\u000fBaAYB \u0001\u0004)\bbBB\u0014\u0007\u007f\u0001\r!\u001e\u0005\b\u0007\u0017\u0002A\u0011IB'\u00035a\u0017n\u001d;Gk:\u001cG/[8ogR1\u0011QUB(\u0007#BaAYB%\u0001\u0004)\bbBAW\u0007\u0013\u0002\r!\u001e\u0005\n\u0007+\u0002\u0011\u0013!C!\u0007/\nA\u0004\\5tiB\u000b'\u000f^5uS>tg*Y7fg\u0012\"WMZ1vYR$3'\u0006\u0002\u0004Z)\"!1]B.W\t\u0019i\u0006\u0005\u0003\u0004`\r%TBAB1\u0015\u0011\u0019\u0019g!\u001a\u0002\u0013Ut7\r[3dW\u0016$'bAB4]\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\r-4\u0011\r\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007\"CB8\u0001E\u0005I\u0011IB,\u0003aa\u0017n\u001d;QCJ$\u0018\u000e^5p]N$C-\u001a4bk2$HeM\u0004\n\u0007g\u0012\u0011\u0011!E\u0001\u0007k\nq\"\u00138NK6|'/_\"bi\u0006dwn\u001a\t\u0004#\r]d\u0001C\u0001\u0003\u0003\u0003E\ta!\u001f\u0014\u0007\r]D\u0006C\u0004%\u0007o\"\ta! \u0015\u0005\rU\u0004BCBA\u0007o\n\n\u0011\"\u0001\u0004\u0004\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIE*\"a!\"+\u0007Y\u0019Y\u0006\u0003\u0006\u0004\n\u000e]\u0014\u0013!C\u0001\u0007\u0017\u000b1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u0012TCABGU\ra21\f")
public class InMemoryCatalog
extends ExternalCatalog {
    public final Configuration org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$$hadoopConfig;
    private final HashMap<String, DatabaseDesc> org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$$catalog;

    public static Configuration $lessinit$greater$default$2() {
        return InMemoryCatalog$.MODULE$.$lessinit$greater$default$2();
    }

    public static SparkConf $lessinit$greater$default$1() {
        return InMemoryCatalog$.MODULE$.$lessinit$greater$default$1();
    }

    public HashMap<String, DatabaseDesc> org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$$catalog() {
        return this.org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$$catalog;
    }

    public boolean org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$$partitionExists(String db, String table, Map<String, String> spec) {
        this.requireTableExists(db, table);
        return ((TableDesc)((DatabaseDesc)this.org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$$catalog().apply((Object)db)).tables().apply((Object)table)).partitions().contains(spec);
    }

    private void requireTableNotExists(String db, String table) {
        if (this.tableExists(db, table)) {
            throw new TableAlreadyExistsException(db, table);
        }
    }

    private void requirePartitionsExist(String db, String table, Seq<Map<String, String>> specs) {
        specs.foreach((Function1)new Serializable(this, db, table){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ InMemoryCatalog $outer;
            private final String db$1;
            private final String table$1;

            public final void apply(Map<String, String> s) {
                if (this.$outer.org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$$partitionExists(this.db$1, this.table$1, s)) {
                    return;
                }
                throw new NoSuchPartitionException(this.db$1, this.table$1, s);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.db$1 = db$1;
                this.table$1 = table$1;
            }
        });
    }

    private void requirePartitionsNotExist(String db, String table, Seq<Map<String, String>> specs) {
        specs.foreach((Function1)new Serializable(this, db, table){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ InMemoryCatalog $outer;
            private final String db$2;
            private final String table$2;

            public final void apply(Map<String, String> s) {
                if (this.$outer.org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$$partitionExists(this.db$2, this.table$2, s)) {
                    throw new PartitionAlreadyExistsException(this.db$2, this.table$2, s);
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.db$2 = db$2;
                this.table$2 = table$2;
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void doCreateDatabase(CatalogDatabase dbDefinition, boolean ignoreIfExists) {
        InMemoryCatalog inMemoryCatalog = this;
        synchronized (inMemoryCatalog) {
            BoxedUnit boxedUnit;
            if (this.org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$$catalog().contains((Object)dbDefinition.name())) {
                if (!ignoreIfExists) throw new DatabaseAlreadyExistsException(dbDefinition.name());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                this.liftedTree1$1(dbDefinition);
                boxedUnit = this.org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$$catalog().put((Object)dbDefinition.name(), (Object)new DatabaseDesc(this, dbDefinition));
            }
            return;
        }
    }

    @Override
    public void doDropDatabase(String db, boolean ignoreIfNotExists, boolean cascade) {
        InMemoryCatalog inMemoryCatalog = this;
        synchronized (inMemoryCatalog) {
            block11: {
                block10: {
                    BoxedUnit boxedUnit;
                    block9: {
                        if (!this.org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$$catalog().contains((Object)db)) break block9;
                        if (!cascade) {
                            if (((DatabaseDesc)this.org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$$catalog().apply((Object)db)).tables().nonEmpty()) {
                                throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Database ", " is not empty. One or more tables exist."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{db})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                            }
                            if (((DatabaseDesc)this.org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$$catalog().apply((Object)db)).functions().nonEmpty()) {
                                throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Database '", "' is not empty. One or more functions exist."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{db})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                            }
                        }
                        CatalogDatabase dbDefinition = ((DatabaseDesc)this.org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$$catalog().apply((Object)db)).db();
                        this.liftedTree2$1(dbDefinition);
                        boxedUnit = this.org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$$catalog().remove((Object)db);
                        break block10;
                    }
                    if (!ignoreIfNotExists) break block11;
                    boxedUnit = BoxedUnit.UNIT;
                }
                return;
            }
            throw new NoSuchDatabaseException(db);
        }
    }

    @Override
    public synchronized void alterDatabase(CatalogDatabase dbDefinition) {
        this.requireDbExists(dbDefinition.name());
        ((DatabaseDesc)this.org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$$catalog().apply((Object)dbDefinition.name())).db_$eq(dbDefinition);
    }

    @Override
    public synchronized CatalogDatabase getDatabase(String db) {
        this.requireDbExists(db);
        return ((DatabaseDesc)this.org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$$catalog().apply((Object)db)).db();
    }

    @Override
    public synchronized boolean databaseExists(String db) {
        return this.org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$$catalog().contains((Object)db);
    }

    @Override
    public synchronized Seq<String> listDatabases() {
        return (Seq)this.org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$$catalog().keySet().toSeq().sorted((Ordering)Ordering.String$.MODULE$);
    }

    @Override
    public synchronized Seq<String> listDatabases(String pattern) {
        return StringUtils$.MODULE$.filterPattern(this.listDatabases(), pattern);
    }

    @Override
    public void setCurrentDatabase(String db) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void doCreateTable(CatalogTable tableDefinition, boolean ignoreIfExists) {
        InMemoryCatalog inMemoryCatalog = this;
        synchronized (inMemoryCatalog) {
            BoxedUnit boxedUnit;
            Predef$.MODULE$.assert(tableDefinition.identifier().database().isDefined());
            String db = (String)tableDefinition.identifier().database().get();
            this.requireDbExists(db);
            String table = tableDefinition.identifier().table();
            if (this.tableExists(db, table)) {
                if (!ignoreIfExists) throw new TableAlreadyExistsException(db, table);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                CatalogTable catalogTable;
                boolean needDefaultTableLocation;
                CatalogTableType catalogTableType = tableDefinition.tableType();
                CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.MANAGED();
                boolean bl = !(catalogTableType != null ? !((Object)catalogTableType).equals(catalogTableType2) : catalogTableType2 != null) && tableDefinition.storage().locationUri().isEmpty() ? true : (needDefaultTableLocation = false);
                if (needDefaultTableLocation) {
                    Path defaultTableLocation = new Path(new Path(((DatabaseDesc)this.org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$$catalog().apply((Object)db)).db().locationUri()), table);
                    this.liftedTree3$1(table, defaultTableLocation);
                    catalogTable = tableDefinition.withNewStorage((Option<URI>)new Some((Object)defaultTableLocation.toUri()), tableDefinition.withNewStorage$default$2(), tableDefinition.withNewStorage$default$3(), tableDefinition.withNewStorage$default$4(), tableDefinition.withNewStorage$default$5(), tableDefinition.withNewStorage$default$6());
                } else {
                    catalogTable = tableDefinition;
                }
                CatalogTable tableWithLocation = catalogTable;
                boxedUnit = ((DatabaseDesc)this.org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$$catalog().apply((Object)db)).tables().put((Object)table, (Object)new TableDesc(this, tableWithLocation));
            }
            return;
        }
    }

    @Override
    public void doDropTable(String db, String table, boolean ignoreIfNotExists, boolean purge) {
        InMemoryCatalog inMemoryCatalog = this;
        synchronized (inMemoryCatalog) {
            block10: {
                block9: {
                    BoxedUnit boxedUnit;
                    block8: {
                        Object object;
                        this.requireDbExists(db);
                        if (!this.tableExists(db, table)) break block8;
                        CatalogTable tableMeta = this.getTable(db, table);
                        CatalogTableType catalogTableType = tableMeta.tableType();
                        CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.MANAGED();
                        if (!(catalogTableType != null ? !((Object)catalogTableType).equals(catalogTableType2) : catalogTableType2 != null)) {
                            Seq locationAllParts = (Seq)((TableDesc)((DatabaseDesc)this.org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$$catalog().apply((Object)db)).tables().apply((Object)table)).partitions().values().toSeq().map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final URI apply(CatalogTablePartition x$1) {
                                    return x$1.location();
                                }
                            }, Seq$.MODULE$.canBuildFrom());
                            locationAllParts.foreach((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ InMemoryCatalog $outer;

                                public final boolean apply(URI loc) {
                                    Path partitionPath = new Path(loc);
                                    try {
                                        FileSystem fs = partitionPath.getFileSystem(this.$outer.org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$$hadoopConfig);
                                        return fs.delete(partitionPath, true);
                                    }
                                    catch (IOException iOException) {
                                        throw new SparkException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to delete partition path ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partitionPath})), (Throwable)iOException);
                                    }
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            });
                            Predef$.MODULE$.assert(tableMeta.storage().locationUri().isDefined(), (Function0)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply() {
                                    return "Managed table should always have table location, as we will assign a default location to it if it doesn't have one.";
                                }
                            });
                            Path dir = new Path(tableMeta.location());
                            object = BoxesRunTime.boxToBoolean((boolean)this.liftedTree4$1(table, dir));
                        } else {
                            object = BoxedUnit.UNIT;
                        }
                        boxedUnit = ((DatabaseDesc)this.org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$$catalog().apply((Object)db)).tables().remove((Object)table);
                        break block9;
                    }
                    if (!ignoreIfNotExists) break block10;
                    boxedUnit = BoxedUnit.UNIT;
                }
                return;
            }
            throw new NoSuchTableException(db, table);
        }
    }

    @Override
    public void doRenameTable(String db, String oldName, String newName) {
        InMemoryCatalog inMemoryCatalog = this;
        synchronized (inMemoryCatalog) {
            this.requireTableExists(db, oldName);
            this.requireTableNotExists(db, newName);
            TableDesc oldDesc = (TableDesc)((DatabaseDesc)this.org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$$catalog().apply((Object)db)).tables().apply((Object)oldName);
            CatalogTable qual$1 = oldDesc.table();
            TableIdentifier x$3 = new TableIdentifier(newName, (Option<String>)new Some((Object)db));
            CatalogTableType x$4 = qual$1.copy$default$2();
            CatalogStorageFormat x$5 = qual$1.copy$default$3();
            StructType x$6 = qual$1.copy$default$4();
            Option<String> x$7 = qual$1.copy$default$5();
            Seq<String> x$8 = qual$1.copy$default$6();
            Option<BucketSpec> x$9 = qual$1.copy$default$7();
            String x$10 = qual$1.copy$default$8();
            long x$11 = qual$1.copy$default$9();
            long x$12 = qual$1.copy$default$10();
            Map<String, String> x$13 = qual$1.copy$default$11();
            Option<CatalogStatistics> x$14 = qual$1.copy$default$12();
            Option<String> x$15 = qual$1.copy$default$13();
            Option<String> x$16 = qual$1.copy$default$14();
            Seq<String> x$17 = qual$1.copy$default$15();
            boolean x$18 = qual$1.copy$default$16();
            boolean x$19 = qual$1.copy$default$17();
            oldDesc.table_$eq(qual$1.copy(x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19));
            CatalogTableType catalogTableType = oldDesc.table().tableType();
            CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.MANAGED();
            if (!(catalogTableType != null ? !((Object)catalogTableType).equals(catalogTableType2) : catalogTableType2 != null)) {
                Predef$.MODULE$.assert(oldDesc.table().storage().locationUri().isDefined(), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Managed table should always have table location, as we will assign a default location to it if it doesn't have one.";
                    }
                });
                Path oldDir = new Path(oldDesc.table().location());
                Path newDir = new Path(new Path(((DatabaseDesc)this.org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$$catalog().apply((Object)db)).db().locationUri()), newName);
                this.liftedTree5$1(oldName, newName, oldDir, newDir);
                CatalogTable qual$2 = oldDesc.table();
                Some x$20 = new Some((Object)newDir.toUri());
                Option<String> x$21 = qual$2.withNewStorage$default$2();
                Option<String> x$22 = qual$2.withNewStorage$default$3();
                boolean x$23 = qual$2.withNewStorage$default$4();
                Option<String> x$24 = qual$2.withNewStorage$default$5();
                Map<String, String> x$25 = qual$2.withNewStorage$default$6();
                oldDesc.table_$eq(qual$2.withNewStorage((Option<URI>)x$20, x$21, x$22, x$23, x$24, x$25));
            }
            ((DatabaseDesc)this.org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$$catalog().apply((Object)db)).tables().put((Object)newName, (Object)oldDesc);
            ((DatabaseDesc)this.org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$$catalog().apply((Object)db)).tables().remove((Object)oldName);
            return;
        }
    }

    @Override
    public synchronized void alterTable(CatalogTable tableDefinition) {
        Predef$.MODULE$.assert(tableDefinition.identifier().database().isDefined());
        String db = (String)tableDefinition.identifier().database().get();
        this.requireTableExists(db, tableDefinition.identifier().table());
        ((TableDesc)((DatabaseDesc)this.org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$$catalog().apply((Object)db)).tables().apply((Object)tableDefinition.identifier().table())).table_$eq(tableDefinition);
    }

    @Override
    public synchronized void alterTableDataSchema(String db, String table, StructType newDataSchema) {
        StructType newSchema;
        this.requireTableExists(db, table);
        CatalogTable origTable = ((TableDesc)((DatabaseDesc)this.org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$$catalog().apply((Object)db)).tables().apply((Object)table)).table();
        StructType x$26 = newSchema = StructType$.MODULE$.apply((Seq<StructField>)((Seq)newDataSchema.$plus$plus(origTable.partitionSchema(), Seq$.MODULE$.canBuildFrom())));
        TableIdentifier x$27 = origTable.copy$default$1();
        CatalogTableType x$28 = origTable.copy$default$2();
        CatalogStorageFormat x$29 = origTable.copy$default$3();
        Option<String> x$30 = origTable.copy$default$5();
        Seq<String> x$31 = origTable.copy$default$6();
        Option<BucketSpec> x$32 = origTable.copy$default$7();
        String x$33 = origTable.copy$default$8();
        long x$34 = origTable.copy$default$9();
        long x$35 = origTable.copy$default$10();
        Map<String, String> x$36 = origTable.copy$default$11();
        Option<CatalogStatistics> x$37 = origTable.copy$default$12();
        Option<String> x$38 = origTable.copy$default$13();
        Option<String> x$39 = origTable.copy$default$14();
        Seq<String> x$40 = origTable.copy$default$15();
        boolean x$41 = origTable.copy$default$16();
        boolean x$42 = origTable.copy$default$17();
        ((TableDesc)((DatabaseDesc)this.org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$$catalog().apply((Object)db)).tables().apply((Object)table)).table_$eq(origTable.copy(x$27, x$28, x$29, x$26, x$30, x$31, x$32, x$33, x$34, x$35, x$36, x$37, x$38, x$39, x$40, x$41, x$42));
    }

    @Override
    public synchronized CatalogTable getTable(String db, String table) {
        this.requireTableExists(db, table);
        return ((TableDesc)((DatabaseDesc)this.org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$$catalog().apply((Object)db)).tables().apply((Object)table)).table();
    }

    @Override
    public synchronized boolean tableExists(String db, String table) {
        this.requireDbExists(db);
        return ((DatabaseDesc)this.org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$$catalog().apply((Object)db)).tables().contains((Object)table);
    }

    @Override
    public synchronized Seq<String> listTables(String db) {
        this.requireDbExists(db);
        return (Seq)((DatabaseDesc)this.org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$$catalog().apply((Object)db)).tables().keySet().toSeq().sorted((Ordering)Ordering.String$.MODULE$);
    }

    @Override
    public synchronized Seq<String> listTables(String db, String pattern) {
        return StringUtils$.MODULE$.filterPattern(this.listTables(db), pattern);
    }

    @Override
    public void loadTable(String db, String table, String loadPath, boolean isOverwrite, boolean isSrcLocal) {
        throw new UnsupportedOperationException("loadTable is not implemented");
    }

    @Override
    public void loadPartition(String db, String table, String loadPath, Map<String, String> partition, boolean isOverwrite, boolean inheritTableSpecs, boolean isSrcLocal) {
        throw new UnsupportedOperationException("loadPartition is not implemented.");
    }

    @Override
    public void loadDynamicPartitions(String db, String table, String loadPath, Map<String, String> partition, boolean replace, int numDP) {
        throw new UnsupportedOperationException("loadDynamicPartitions is not implemented.");
    }

    @Override
    public synchronized void createPartitions(String db, String table, Seq<CatalogTablePartition> parts, boolean ignoreIfExists) {
        Seq dupSpecs;
        this.requireTableExists(db, table);
        HashMap<Map<String, String>, CatalogTablePartition> existingParts = ((TableDesc)((DatabaseDesc)this.org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$$catalog().apply((Object)db)).tables().apply((Object)table)).partitions();
        if (!ignoreIfExists && (dupSpecs = (Seq)parts.collect((PartialFunction)new Serializable(this, existingParts){
            public static final long serialVersionUID = 0L;
            private final HashMap existingParts$1;

            public final <A1 extends CatalogTablePartition, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Object object = this.existingParts$1.contains(A1.spec()) ? A1.spec() : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(CatalogTablePartition x1) {
                CatalogTablePartition catalogTablePartition = x1;
                boolean bl = this.existingParts$1.contains(catalogTablePartition.spec());
                return bl;
            }
            {
                this.existingParts$1 = existingParts$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).nonEmpty()) {
            throw new PartitionsAlreadyExistException(db, table, (Seq<Map<String, String>>)dupSpecs);
        }
        CatalogTable tableMeta = this.getTable(db, table);
        Seq<String> partitionColumnNames = tableMeta.partitionColumnNames();
        Path tablePath = new Path(tableMeta.location());
        parts.foreach((Function1)new Serializable(this, existingParts, partitionColumnNames, tablePath){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ InMemoryCatalog $outer;
            private final HashMap existingParts$1;
            public final Seq partitionColumnNames$1;
            public final Path tablePath$1;

            /*
             * WARNING - void declaration
             */
            public final Option<CatalogTablePartition> apply(CatalogTablePartition p) {
                Path partitionPath = (Path)p.storage().locationUri().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Path apply(URI x$2) {
                        return new Path(x$2);
                    }
                }).getOrElse((Function0)new Serializable(this, p){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$createPartitions$1 $outer;
                    private final CatalogTablePartition p$1;

                    public final Path apply() {
                        return ExternalCatalogUtils$.MODULE$.generatePartitionPath(this.p$1.spec(), (Seq<String>)this.$outer.partitionColumnNames$1, this.$outer.tablePath$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.p$1 = p$1;
                    }
                });
                try {
                    FileSystem fs = this.tablePath$1.getFileSystem(this.$outer.org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$$hadoopConfig);
                    Object object = fs.exists(partitionPath) ? BoxedUnit.UNIT : BoxesRunTime.boxToBoolean((boolean)fs.mkdirs(partitionPath));
                }
                catch (IOException iOException) {
                    void var2_2;
                    throw new SparkException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to create partition path ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var2_2})), (Throwable)iOException);
                }
                CatalogStorageFormat x$43 = p.storage().copy((Option<URI>)new Some((Object)partitionPath.toUri()), p.storage().copy$default$2(), p.storage().copy$default$3(), p.storage().copy$default$4(), p.storage().copy$default$5(), p.storage().copy$default$6());
                Map<String, String> x$44 = p.copy$default$1();
                Map<String, String> x$45 = p.copy$default$3();
                return this.existingParts$1.put(p.spec(), (Object)p.copy(x$44, x$43, x$45));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.existingParts$1 = existingParts$1;
                this.partitionColumnNames$1 = partitionColumnNames$1;
                this.tablePath$1 = tablePath$1;
            }
        });
    }

    @Override
    public synchronized void dropPartitions(String db, String table, Seq<Map<String, String>> partSpecs, boolean ignoreIfNotExists, boolean purge, boolean retainData) {
        boolean bl;
        Seq missingSpecs;
        this.requireTableExists(db, table);
        HashMap<Map<String, String>, CatalogTablePartition> existingParts = ((TableDesc)((DatabaseDesc)this.org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$$catalog().apply((Object)db)).tables().apply((Object)table)).partitions();
        if (!ignoreIfNotExists && (missingSpecs = (Seq)partSpecs.collect((PartialFunction)new Serializable(this, existingParts){
            public static final long serialVersionUID = 0L;
            private final HashMap existingParts$2;

            public final <A1 extends Map<String, String>, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                A1 A1 = x2;
                Object object = this.existingParts$2.contains(A1) ? function1.apply(x2) : A1;
                return (B1)object;
            }

            public final boolean isDefinedAt(Map<String, String> x2) {
                Map<String, String> map2 = x2;
                boolean bl = !this.existingParts$2.contains(map2);
                return bl;
            }
            {
                this.existingParts$2 = existingParts$2;
            }
        }, Seq$.MODULE$.canBuildFrom())).nonEmpty()) {
            throw new NoSuchPartitionsException(db, table, (Seq<Map<String, String>>)missingSpecs);
        }
        if (retainData) {
            bl = false;
        } else {
            CatalogTableType catalogTableType = this.getTable(db, table).tableType();
            CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.MANAGED();
            bl = !(catalogTableType != null ? !((Object)catalogTableType).equals(catalogTableType2) : catalogTableType2 != null);
        }
        boolean shouldRemovePartitionLocation = bl;
        partSpecs.foreach((Function1)new Serializable(this, existingParts, shouldRemovePartitionLocation){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ InMemoryCatalog $outer;
            private final HashMap existingParts$2;
            private final boolean shouldRemovePartitionLocation$1;

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public final Option<CatalogTablePartition> apply(Map<String, String> p) {
                Object object;
                if (this.existingParts$2.contains(p) && this.shouldRemovePartitionLocation$1) {
                    Path partitionPath = new Path(((CatalogTablePartition)this.existingParts$2.apply(p)).location());
                    try {
                        FileSystem fs = partitionPath.getFileSystem(this.$outer.org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$$hadoopConfig);
                        object = BoxesRunTime.boxToBoolean((boolean)fs.delete(partitionPath, true));
                        return this.existingParts$2.remove(p);
                    }
                    catch (IOException iOException) {
                        throw new SparkException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to delete partition path ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partitionPath})), (Throwable)iOException);
                    }
                }
                object = BoxedUnit.UNIT;
                return this.existingParts$2.remove(p);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.existingParts$2 = existingParts$2;
                this.shouldRemovePartitionLocation$1 = shouldRemovePartitionLocation$1;
            }
        });
    }

    @Override
    public synchronized void renamePartitions(String db, String table, Seq<Map<String, String>> specs, Seq<Map<String, String>> newSpecs) {
        Predef$.MODULE$.require(specs.size() == newSpecs.size(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "number of old and new partition specs differ";
            }
        });
        this.requirePartitionsExist(db, table, specs);
        this.requirePartitionsNotExist(db, table, newSpecs);
        CatalogTable tableMeta = this.getTable(db, table);
        Seq<String> partitionColumnNames = tableMeta.partitionColumnNames();
        Path tablePath = new Path(tableMeta.location());
        CatalogTableType catalogTableType = this.getTable(db, table).tableType();
        CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.MANAGED();
        boolean shouldUpdatePartitionLocation = !(catalogTableType != null ? !((Object)catalogTableType).equals(catalogTableType2) : catalogTableType2 != null);
        HashMap<Map<String, String>, CatalogTablePartition> existingParts = ((TableDesc)((DatabaseDesc)this.org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$$catalog().apply((Object)db)).tables().apply((Object)table)).partitions();
        ((IterableLike)specs.zip(newSpecs, Seq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this, db, table, partitionColumnNames, tablePath, shouldUpdatePartitionLocation, existingParts){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ InMemoryCatalog $outer;
            private final String db$3;
            private final String table$5;
            private final Seq partitionColumnNames$2;
            private final Path tablePath$2;
            private final boolean shouldUpdatePartitionLocation$1;
            private final HashMap existingParts$3;

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public final Option<CatalogTablePartition> apply(Tuple2<Map<String, String>, Map<String, String>> x0$1) {
                CatalogTablePartition catalogTablePartition;
                Tuple2<Map<String, String>, Map<String, String>> tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                Map oldSpec = (Map)tuple2._1();
                Map newSpec = (Map)tuple2._2();
                CatalogTablePartition oldPartition = this.$outer.getPartition(this.db$3, this.table$5, (Map<String, String>)oldSpec);
                if (this.shouldUpdatePartitionLocation$1) {
                    Path oldPartPath = new Path(oldPartition.location());
                    Path newPartPath = ExternalCatalogUtils$.MODULE$.generatePartitionPath((Map<String, String>)newSpec, (Seq<String>)this.partitionColumnNames$2, this.tablePath$2);
                    try {
                        FileSystem fs = this.tablePath$2.getFileSystem(this.$outer.org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$$hadoopConfig);
                        fs.rename(oldPartPath, newPartPath);
                    }
                    catch (IOException iOException) {
                        void var6_6;
                        throw new SparkException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to rename partition path ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var6_6})), (Throwable)iOException);
                    }
                    catalogTablePartition = oldPartition.copy((Map<String, String>)newSpec, oldPartition.storage().copy((Option<URI>)new Some((Object)newPartPath.toUri()), oldPartition.storage().copy$default$2(), oldPartition.storage().copy$default$3(), oldPartition.storage().copy$default$4(), oldPartition.storage().copy$default$5(), oldPartition.storage().copy$default$6()), oldPartition.copy$default$3());
                } else {
                    catalogTablePartition = oldPartition.copy((Map<String, String>)newSpec, oldPartition.copy$default$2(), oldPartition.copy$default$3());
                }
                CatalogTablePartition newPartition = catalogTablePartition;
                this.existingParts$3.remove((Object)oldSpec);
                return this.existingParts$3.put((Object)newSpec, (Object)newPartition);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.db$3 = db$3;
                this.table$5 = table$5;
                this.partitionColumnNames$2 = partitionColumnNames$2;
                this.tablePath$2 = tablePath$2;
                this.shouldUpdatePartitionLocation$1 = shouldUpdatePartitionLocation$1;
                this.existingParts$3 = existingParts$3;
            }
        });
    }

    @Override
    public synchronized void alterPartitions(String db, String table, Seq<CatalogTablePartition> parts) {
        this.requirePartitionsExist(db, table, (Seq<Map<String, String>>)((Seq)parts.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Map<String, String> apply(CatalogTablePartition p) {
                return p.spec();
            }
        }, Seq$.MODULE$.canBuildFrom())));
        parts.foreach((Function1)new Serializable(this, db, table){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ InMemoryCatalog $outer;
            private final String db$4;
            private final String table$6;

            public final Option<CatalogTablePartition> apply(CatalogTablePartition p) {
                return ((TableDesc)((DatabaseDesc)this.$outer.org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$$catalog().apply((Object)this.db$4)).tables().apply((Object)this.table$6)).partitions().put(p.spec(), (Object)p);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.db$4 = db$4;
                this.table$6 = table$6;
            }
        });
    }

    @Override
    public synchronized CatalogTablePartition getPartition(String db, String table, Map<String, String> spec) {
        this.requirePartitionsExist(db, table, (Seq<Map<String, String>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{spec}))));
        return (CatalogTablePartition)((TableDesc)((DatabaseDesc)this.org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$$catalog().apply((Object)db)).tables().apply((Object)table)).partitions().apply(spec);
    }

    @Override
    public synchronized Option<CatalogTablePartition> getPartitionOption(String db, String table, Map<String, String> spec) {
        return this.org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$$partitionExists(db, table, spec) ? Option$.MODULE$.apply(((TableDesc)((DatabaseDesc)this.org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$$catalog().apply((Object)db)).tables().apply((Object)table)).partitions().apply(spec)) : None$.MODULE$;
    }

    @Override
    public synchronized Seq<String> listPartitionNames(String db, String table, Option<Map<String, String>> partialSpec) {
        Seq<String> partitionColumnNames = this.getTable(db, table).partitionColumnNames();
        return (Seq)((SeqLike)this.listPartitions(db, table, partialSpec).map((Function1)new Serializable(this, partitionColumnNames){
            public static final long serialVersionUID = 0L;
            private final Seq partitionColumnNames$3;

            public final String apply(CatalogTablePartition partition) {
                return ((TraversableOnce)this.partitionColumnNames$3.map((Function1)new Serializable(this, partition){
                    public static final long serialVersionUID = 0L;
                    private final CatalogTablePartition partition$1;

                    public final String apply(String name2) {
                        return new StringBuilder().append((Object)ExternalCatalogUtils$.MODULE$.escapePathName(name2)).append((Object)"=").append((Object)ExternalCatalogUtils$.MODULE$.escapePathName((String)this.partition$1.spec().apply((Object)name2))).toString();
                    }
                    {
                        this.partition$1 = partition$1;
                    }
                }, Seq$.MODULE$.canBuildFrom())).mkString("/");
            }
            {
                this.partitionColumnNames$3 = partitionColumnNames$3;
            }
        }, Seq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.String$.MODULE$);
    }

    @Override
    public Option<Map<String, String>> listPartitionNames$default$3() {
        return None$.MODULE$;
    }

    @Override
    public synchronized Seq<CatalogTablePartition> listPartitions(String db, String table, Option<Map<String, String>> partialSpec) {
        Option<Map<String, String>> option;
        block4: {
            Seq seq;
            block3: {
                block2: {
                    this.requireTableExists(db, table);
                    option = partialSpec;
                    if (!None$.MODULE$.equals(option)) break block2;
                    seq = ((TableDesc)((DatabaseDesc)this.org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$$catalog().apply((Object)db)).tables().apply((Object)table)).partitions().values().toSeq();
                    break block3;
                }
                if (!(option instanceof Some)) break block4;
                Some some = (Some)option;
                Map partial = (Map)some.x();
                seq = (Seq)((TableDesc)((DatabaseDesc)this.org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$$catalog().apply((Object)db)).tables().apply((Object)table)).partitions().toSeq().collect((PartialFunction)new Serializable(this, partial){
                    public static final long serialVersionUID = 0L;
                    private final Map partial$1;

                    /*
                     * Enabled aggressive block sorting
                     */
                    public final <A1 extends Tuple2<Map<String, String>, CatalogTablePartition>, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x3;
                        if (A1 != null) {
                            Map spec = (Map)A1._1();
                            CatalogTablePartition partition = (CatalogTablePartition)A1._2();
                            if (ExternalCatalogUtils$.MODULE$.isPartialPartitionSpec((Map<String, String>)this.partial$1, (Map<String, String>)spec)) {
                                object = partition;
                                return (B1)object;
                            }
                        }
                        object = function1.apply(x3);
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(Tuple2<Map<String, String>, CatalogTablePartition> x3) {
                        Map spec;
                        Tuple2<Map<String, String>, CatalogTablePartition> tuple2 = x3;
                        boolean bl = tuple2 != null && ExternalCatalogUtils$.MODULE$.isPartialPartitionSpec((Map<String, String>)this.partial$1, (Map<String, String>)(spec = (Map)tuple2._1()));
                        return bl;
                    }
                    {
                        this.partial$1 = partial$1;
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }
            return seq;
        }
        throw new MatchError(option);
    }

    @Override
    public Option<Map<String, String>> listPartitions$default$3() {
        return None$.MODULE$;
    }

    @Override
    public Seq<CatalogTablePartition> listPartitionsByFilter(String db, String table, Seq<Expression> predicates, String defaultTimeZoneId) {
        CatalogTable catalogTable = this.getTable(db, table);
        Seq<CatalogTablePartition> allPartitions = this.listPartitions(db, table, this.listPartitions$default$3());
        return ExternalCatalogUtils$.MODULE$.prunePartitionsByFilter(catalogTable, allPartitions, predicates, defaultTimeZoneId);
    }

    @Override
    public void doCreateFunction(String db, CatalogFunction func) {
        InMemoryCatalog inMemoryCatalog = this;
        synchronized (inMemoryCatalog) {
            this.requireDbExists(db);
            this.requireFunctionNotExists(db, func.identifier().funcName());
            ((DatabaseDesc)this.org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$$catalog().apply((Object)db)).functions().put((Object)func.identifier().funcName(), (Object)func);
            return;
        }
    }

    @Override
    public void doDropFunction(String db, String funcName) {
        InMemoryCatalog inMemoryCatalog = this;
        synchronized (inMemoryCatalog) {
            this.requireFunctionExists(db, funcName);
            ((DatabaseDesc)this.org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$$catalog().apply((Object)db)).functions().remove((Object)funcName);
            return;
        }
    }

    @Override
    public void doRenameFunction(String db, String oldName, String newName) {
        InMemoryCatalog inMemoryCatalog = this;
        synchronized (inMemoryCatalog) {
            this.requireFunctionExists(db, oldName);
            this.requireFunctionNotExists(db, newName);
            CatalogFunction qual$3 = this.getFunction(db, oldName);
            FunctionIdentifier x$46 = new FunctionIdentifier(newName, (Option<String>)new Some((Object)db));
            String x$47 = qual$3.copy$default$2();
            Seq<FunctionResource> x$48 = qual$3.copy$default$3();
            CatalogFunction newFunc = qual$3.copy(x$46, x$47, x$48);
            ((DatabaseDesc)this.org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$$catalog().apply((Object)db)).functions().remove((Object)oldName);
            ((DatabaseDesc)this.org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$$catalog().apply((Object)db)).functions().put((Object)newName, (Object)newFunc);
            return;
        }
    }

    @Override
    public synchronized CatalogFunction getFunction(String db, String funcName) {
        this.requireFunctionExists(db, funcName);
        return (CatalogFunction)((DatabaseDesc)this.org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$$catalog().apply((Object)db)).functions().apply((Object)funcName);
    }

    @Override
    public synchronized boolean functionExists(String db, String funcName) {
        this.requireDbExists(db);
        return ((DatabaseDesc)this.org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$$catalog().apply((Object)db)).functions().contains((Object)funcName);
    }

    @Override
    public synchronized Seq<String> listFunctions(String db, String pattern) {
        this.requireDbExists(db);
        return StringUtils$.MODULE$.filterPattern((Seq<String>)((DatabaseDesc)this.org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$$catalog().apply((Object)db)).functions().keysIterator().toSeq(), pattern);
    }

    private final boolean liftedTree1$1(CatalogDatabase dbDefinition$1) {
        try {
            Path location2 = new Path(dbDefinition$1.locationUri());
            FileSystem fs = location2.getFileSystem(this.org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$$hadoopConfig);
            return fs.mkdirs(location2);
        }
        catch (IOException iOException) {
            throw new SparkException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to create database ", " as failed "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dbDefinition$1.name()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"to create its directory ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dbDefinition$1.locationUri()}))).toString(), (Throwable)iOException);
        }
    }

    private final boolean liftedTree2$1(CatalogDatabase dbDefinition$2) {
        try {
            Path location2 = new Path(dbDefinition$2.locationUri());
            FileSystem fs = location2.getFileSystem(this.org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$$hadoopConfig);
            return fs.delete(location2, true);
        }
        catch (IOException iOException) {
            throw new SparkException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to drop database ", " as failed "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dbDefinition$2.name()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"to delete its directory ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dbDefinition$2.locationUri()}))).toString(), (Throwable)iOException);
        }
    }

    private final boolean liftedTree3$1(String table$3, Path defaultTableLocation$1) {
        try {
            FileSystem fs = defaultTableLocation$1.getFileSystem(this.org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$$hadoopConfig);
            return fs.mkdirs(defaultTableLocation$1);
        }
        catch (IOException iOException) {
            throw new SparkException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to create table ", " as failed "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{table$3}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"to create its directory ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{defaultTableLocation$1}))).toString(), (Throwable)iOException);
        }
    }

    private final boolean liftedTree4$1(String table$4, Path dir$1) {
        try {
            FileSystem fs = dir$1.getFileSystem(this.org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$$hadoopConfig);
            return fs.delete(dir$1, true);
        }
        catch (IOException iOException) {
            throw new SparkException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to drop table ", " as failed "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{table$4}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"to delete its directory ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dir$1}))).toString(), (Throwable)iOException);
        }
    }

    private final boolean liftedTree5$1(String oldName$1, String newName$1, Path oldDir$1, Path newDir$1) {
        try {
            FileSystem fs = oldDir$1.getFileSystem(this.org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$$hadoopConfig);
            return fs.rename(oldDir$1, newDir$1);
        }
        catch (IOException iOException) {
            throw new SparkException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to rename table ", " to ", " as failed "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{oldName$1, newName$1}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"to rename its directory ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{oldDir$1}))).toString(), (Throwable)iOException);
        }
    }

    public InMemoryCatalog(SparkConf conf, Configuration hadoopConfig) {
        this.org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$$hadoopConfig = hadoopConfig;
        this.org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$$catalog = new HashMap();
    }

    public class TableDesc {
        private CatalogTable table;
        private final HashMap<Map<String, String>, CatalogTablePartition> partitions;
        public final /* synthetic */ InMemoryCatalog $outer;

        public CatalogTable table() {
            return this.table;
        }

        public void table_$eq(CatalogTable x$1) {
            this.table = x$1;
        }

        public HashMap<Map<String, String>, CatalogTablePartition> partitions() {
            return this.partitions;
        }

        public /* synthetic */ InMemoryCatalog org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$TableDesc$$$outer() {
            return this.$outer;
        }

        public TableDesc(InMemoryCatalog $outer, CatalogTable table) {
            this.table = table;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.partitions = new HashMap();
        }
    }

    public class DatabaseDesc {
        private CatalogDatabase db;
        private final HashMap<String, TableDesc> tables;
        private final HashMap<String, CatalogFunction> functions;
        public final /* synthetic */ InMemoryCatalog $outer;

        public CatalogDatabase db() {
            return this.db;
        }

        public void db_$eq(CatalogDatabase x$1) {
            this.db = x$1;
        }

        public HashMap<String, TableDesc> tables() {
            return this.tables;
        }

        public HashMap<String, CatalogFunction> functions() {
            return this.functions;
        }

        public /* synthetic */ InMemoryCatalog org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$DatabaseDesc$$$outer() {
            return this.$outer;
        }

        public DatabaseDesc(InMemoryCatalog $outer, CatalogDatabase db) {
            this.db = db;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.tables = new HashMap();
            this.functions = new HashMap();
        }
    }
}

