/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes$class;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.StringToMap$;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback$class;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapData$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.BufferedIterator;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(text[, pairDelim[, keyValueDelim]]) - Creates a map after splitting the text into key/value pairs using delimiters. Default delimiters are ',' for `pairDelim` and ':' for `keyValueDelim`.", extended="\n    Examples:\n      > SELECT _FUNC_('a:1,b:2,c:3', ',', ':');\n       map(\"a\":\"1\",\"b\":\"2\",\"c\":\"3\")\n      > SELECT _FUNC_('a');\n       map(\"a\":null)\n  ")
@ScalaSignature(bytes="\u0006\u0001\u0005%h\u0001B\u0001\u0003\u0001>\u00111b\u0015;sS:<Gk\\'ba*\u00111\u0001B\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002\u0006\r\u0005A1-\u0019;bYf\u001cHO\u0003\u0002\b\u0011\u0005\u00191/\u001d7\u000b\u0005%Q\u0011!B:qCJ\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c\u0001a\u0005\u0004\u0001!QQRd\t\t\u0003#Ii\u0011AA\u0005\u0003'\t\u0011\u0011\u0003V3s]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o!\t)\u0002$D\u0001\u0017\u0015\t9\"!A\u0004d_\u0012,w-\u001a8\n\u0005e1\"aD\"pI\u0016<WM\u001c$bY2\u0014\u0017mY6\u0011\u0005EY\u0012B\u0001\u000f\u0003\u0005E)\u0005\u0010]3diNLe\u000e];u)f\u0004Xm\u001d\t\u0003=\u0005j\u0011a\b\u0006\u0002A\u0005)1oY1mC&\u0011!e\b\u0002\b!J|G-^2u!\tqB%\u0003\u0002&?\ta1+\u001a:jC2L'0\u00192mK\"Aq\u0005\u0001BK\u0002\u0013\u0005\u0001&\u0001\u0003uKb$X#A\u0015\u0011\u0005EQ\u0013BA\u0016\u0003\u0005))\u0005\u0010\u001d:fgNLwN\u001c\u0005\t[\u0001\u0011\t\u0012)A\u0005S\u0005)A/\u001a=uA!Aq\u0006\u0001BK\u0002\u0013\u0005\u0001&A\u0005qC&\u0014H)\u001a7j[\"A\u0011\u0007\u0001B\tB\u0003%\u0011&\u0001\u0006qC&\u0014H)\u001a7j[\u0002B\u0001b\r\u0001\u0003\u0016\u0004%\t\u0001K\u0001\u000eW\u0016Lh+\u00197vK\u0012+G.[7\t\u0011U\u0002!\u0011#Q\u0001\n%\nab[3z-\u0006dW/\u001a#fY&l\u0007\u0005C\u00038\u0001\u0011\u0005\u0001(\u0001\u0004=S:LGO\u0010\u000b\u0005siZD\b\u0005\u0002\u0012\u0001!)qE\u000ea\u0001S!)qF\u000ea\u0001S!)1G\u000ea\u0001S!)q\u0007\u0001C\u0001}Q\u0019\u0011hP!\t\u000b\u0001k\u0004\u0019A\u0015\u0002\u000b\rD\u0017\u000e\u001c3\t\u000b=j\u0004\u0019A\u0015\t\u000b]\u0002A\u0011A\"\u0015\u0005e\"\u0005\"\u0002!C\u0001\u0004I\u0003\"\u0002$\u0001\t\u0003:\u0015\u0001C2iS2$'/\u001a8\u0016\u0003!\u00032!S)*\u001d\tQuJ\u0004\u0002L\u001d6\tAJ\u0003\u0002N\u001d\u00051AH]8pizJ\u0011\u0001I\u0005\u0003!~\tq\u0001]1dW\u0006<W-\u0003\u0002S'\n\u00191+Z9\u000b\u0005A{\u0002\"B+\u0001\t\u00032\u0016AC5oaV$H+\u001f9fgV\tq\u000bE\u0002J#b\u0003\"!\u0017/\u000e\u0003iS!a\u0017\u0004\u0002\u000bQL\b/Z:\n\u0005uS&\u0001E!cgR\u0014\u0018m\u0019;ECR\fG+\u001f9f\u0011\u0015y\u0006\u0001\"\u0011a\u0003!!\u0017\r^1UsB,W#A1\u0011\u0005e\u0013\u0017BA2[\u0005!!\u0015\r^1UsB,\u0007\"B3\u0001\t\u00032\u0017aE2iK\u000e\\\u0017J\u001c9vi\u0012\u000bG/\u0019+za\u0016\u001cH#A4\u0011\u0005!\\W\"A5\u000b\u0005)$\u0011\u0001C1oC2L8/[:\n\u00051L'a\u0004+za\u0016\u001c\u0005.Z2l%\u0016\u001cX\u000f\u001c;\t\u000b9\u0004A\u0011I8\u0002\u00199,H\u000e\\*bM\u0016,e/\u00197\u0015\tA\u001cXo\u001e\t\u0003=EL!A]\u0010\u0003\u0007\u0005s\u0017\u0010C\u0003u[\u0002\u0007\u0001/A\u0006j]B,Ho\u0015;sS:<\u0007\"\u0002<n\u0001\u0004\u0001\u0018aD:ue&tw\rR3mS6LG/\u001a:\t\u000bal\u0007\u0019\u00019\u0002#-,\u0017PV1mk\u0016$U\r\\5nSR,'\u000fC\u0003{\u0001\u0011\u000530\u0001\u0006qe\u0016$H/\u001f(b[\u0016,\u0012\u0001 \t\u0004{\u0006\u0005aB\u0001\u0010\u007f\u0013\tyx$\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u0007\t)A\u0001\u0004TiJLgn\u001a\u0006\u0003\u007f~A\u0011\"!\u0003\u0001\u0003\u0003%\t!a\u0003\u0002\t\r|\u0007/\u001f\u000b\bs\u00055\u0011qBA\t\u0011!9\u0013q\u0001I\u0001\u0002\u0004I\u0003\u0002C\u0018\u0002\bA\u0005\t\u0019A\u0015\t\u0011M\n9\u0001%AA\u0002%B\u0011\"!\u0006\u0001#\u0003%\t!a\u0006\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011\u0011\u0004\u0016\u0004S\u0005m1FAA\u000f!\u0011\ty\"!\u000b\u000e\u0005\u0005\u0005\"\u0002BA\u0012\u0003K\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u001dr$\u0001\u0006b]:|G/\u0019;j_:LA!a\u000b\u0002\"\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0013\u0005=\u0002!%A\u0005\u0002\u0005]\u0011AD2paf$C-\u001a4bk2$HE\r\u0005\n\u0003g\u0001\u0011\u0013!C\u0001\u0003/\tabY8qs\u0012\"WMZ1vYR$3\u0007C\u0005\u00028\u0001\t\t\u0011\"\u0011\u0002:\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!a\u000f\u0011\t\u0005u\u0012qI\u0007\u0003\u0003\u007fQA!!\u0011\u0002D\u0005!A.\u00198h\u0015\t\t)%\u0001\u0003kCZ\f\u0017\u0002BA\u0002\u0003\u007fA\u0011\"a\u0013\u0001\u0003\u0003%\t!!\u0014\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005=\u0003c\u0001\u0010\u0002R%\u0019\u00111K\u0010\u0003\u0007%sG\u000fC\u0005\u0002X\u0001\t\t\u0011\"\u0001\u0002Z\u0005q\u0001O]8ek\u000e$X\t\\3nK:$Hc\u00019\u0002\\!Q\u0011QLA+\u0003\u0003\u0005\r!a\u0014\u0002\u0007a$\u0013\u0007C\u0005\u0002b\u0001\t\t\u0011\"\u0011\u0002d\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002fA)\u0011qMA7a6\u0011\u0011\u0011\u000e\u0006\u0004\u0003Wz\u0012AC2pY2,7\r^5p]&!\u0011qNA5\u0005!IE/\u001a:bi>\u0014\b\"CA:\u0001\u0005\u0005I\u0011AA;\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA<\u0003{\u00022AHA=\u0013\r\tYh\b\u0002\b\u0005>|G.Z1o\u0011%\ti&!\u001d\u0002\u0002\u0003\u0007\u0001\u000fC\u0005\u0002\u0002\u0002\t\t\u0011\"\u0011\u0002\u0004\u00061Q-];bYN$B!a\u001e\u0002\u0006\"I\u0011QLA@\u0003\u0003\u0005\r\u0001\u001d\u0015\f\u0001\u0005%\u0015qRAI\u0003+\u000b9\nE\u0002\u0012\u0003\u0017K1!!$\u0003\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!a%\u0002\u0003\u000b{f)\u0016(D?\"\"X\r\u001f;\\Y\u0001\u0002\u0018-\u001b:EK2LWn\u0017\u0017!W\u0016Lh+\u00197vK\u0012+G.[7^;&\u0002S\u0006I\"sK\u0006$Xm\u001d\u0011bA5\f\u0007\u000fI1gi\u0016\u0014\be\u001d9mSR$\u0018N\\4!i\",\u0007\u0005^3yi\u0002Jg\u000e^8!W\u0016LxF^1mk\u0016\u0004\u0003/Y5sg\u0002*8/\u001b8hA\u0011,G.[7ji\u0016\u00148O\f\u0011EK\u001a\fW\u000f\u001c;!I\u0016d\u0017.\\5uKJ\u001c\b%\u0019:fA\u001dbs\u0005\t4pe\u0002\u0002\u0007/Y5s\t\u0016d\u0017.\u001c1!C:$\u0007e\n\u001e(A\u0019|'\u000f\t1lKf4\u0016\r\\;f\t\u0016d\u0017.\u001c1/\u0003!)\u0007\u0010^3oI\u0016$\u0017EAAM\u0003\u00055\"\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u0014buEb#M\u000f\u001a-Gj\u001at\u0005\f\u0011(Y\u001db\u0003e\n\u001e(SmR\u0001\u0005\t\u0011!A\u0001\u0002S.\u00199)E\u0005\u0014#HI\u0019#Y\t\u0012'E\u000f\u00123E1\u00123M\t\u001e#g\tJ#\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u0014bO%Z$\u0002\t\u0011!A\u0001\u0002\u0003%\\1qQ\t\n'E\u000f8vY2L#\u0002\t\u0011\b\u0013\u0005u%!!A\t\u0002\u0005}\u0015aC*ue&tw\rV8NCB\u00042!EAQ\r!\t!!!A\t\u0002\u0005\r6#BAQ\u0003K\u001b\u0003\u0003CAT\u0003[K\u0013&K\u001d\u000e\u0005\u0005%&bAAV?\u00059!/\u001e8uS6,\u0017\u0002BAX\u0003S\u0013\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c84\u0011\u001d9\u0014\u0011\u0015C\u0001\u0003g#\"!a(\t\u0015\u0005]\u0016\u0011UA\u0001\n\u000b\nI,\u0001\u0005u_N#(/\u001b8h)\t\tY\u0004\u0003\u0006\u0002>\u0006\u0005\u0016\u0011!CA\u0003\u007f\u000bQ!\u00199qYf$r!OAa\u0003\u0007\f)\r\u0003\u0004(\u0003w\u0003\r!\u000b\u0005\u0007_\u0005m\u0006\u0019A\u0015\t\rM\nY\f1\u0001*\u0011)\tI-!)\u0002\u0002\u0013\u0005\u00151Z\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\ti-!7\u0011\u000by\ty-a5\n\u0007\u0005EwD\u0001\u0004PaRLwN\u001c\t\u0007=\u0005U\u0017&K\u0015\n\u0007\u0005]wD\u0001\u0004UkBdWm\r\u0005\n\u00037\f9-!AA\u0002e\n1\u0001\u001f\u00131\u0011)\ty.!)\u0002\u0002\u0013%\u0011\u0011]\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002dB!\u0011QHAs\u0013\u0011\t9/a\u0010\u0003\r=\u0013'.Z2u\u0001")
public class StringToMap
extends TernaryExpression
implements CodegenFallback,
ExpectsInputTypes,
Serializable {
    private final Expression text;
    private final Expression pairDelim;
    private final Expression keyValueDelim;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(StringToMap stringToMap) {
        return StringToMap$.MODULE$.unapply(stringToMap);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, StringToMap> tupled() {
        return StringToMap$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, StringToMap>>> curried() {
        return StringToMap$.MODULE$.curried();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback$class.doGenCode(this, ctx, ev);
    }

    public Expression text() {
        return this.text;
    }

    public Expression pairDelim() {
        return this.pairDelim;
    }

    public Expression keyValueDelim() {
        return this.keyValueDelim;
    }

    @Override
    public Seq<Expression> children() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.text(), this.pairDelim(), this.keyValueDelim()}));
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StringType$[]{StringType$.MODULE$, StringType$.MODULE$, StringType$.MODULE$}));
    }

    @Override
    public DataType dataType() {
        return MapType$.MODULE$.apply(StringType$.MODULE$, StringType$.MODULE$);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.pairDelim(), this.keyValueDelim()}))).exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Expression x$26) {
                return !x$26.foldable();
            }
        }) ? new TypeCheckResult.TypeCheckFailure(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "'s delimiters must be foldable."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.prettyName()}))) : ExpectsInputTypes$class.checkInputDataTypes(this);
    }

    @Override
    public Object nullSafeEval(Object inputString, Object stringDelimiter, Object keyValueDelimiter) {
        UTF8String[] keyValues = ((UTF8String)inputString).split((UTF8String)stringDelimiter, -1);
        Iterator<Tuple2<UTF8String, UTF8String>> iterator2 = new Iterator<Tuple2<UTF8String, UTF8String>>(this, keyValueDelimiter, keyValues){
            private int index;
            private final UTF8String keyValueDelimiterUTF8String;
            private final UTF8String[] keyValues$1;

            public Iterator<Tuple2<UTF8String, UTF8String>> seq() {
                return Iterator.class.seq((Iterator)this);
            }

            public boolean isEmpty() {
                return Iterator.class.isEmpty((Iterator)this);
            }

            public boolean isTraversableAgain() {
                return Iterator.class.isTraversableAgain((Iterator)this);
            }

            public boolean hasDefiniteSize() {
                return Iterator.class.hasDefiniteSize((Iterator)this);
            }

            public Iterator<Tuple2<UTF8String, UTF8String>> take(int n) {
                return Iterator.class.take((Iterator)this, (int)n);
            }

            public Iterator<Tuple2<UTF8String, UTF8String>> drop(int n) {
                return Iterator.class.drop((Iterator)this, (int)n);
            }

            public Iterator<Tuple2<UTF8String, UTF8String>> slice(int from, int until) {
                return Iterator.class.slice((Iterator)this, (int)from, (int)until);
            }

            public <B> Iterator<B> map(Function1<Tuple2<UTF8String, UTF8String>, B> f) {
                return Iterator.class.map((Iterator)this, f);
            }

            public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
                return Iterator.class.$plus$plus((Iterator)this, that);
            }

            public <B> Iterator<B> flatMap(Function1<Tuple2<UTF8String, UTF8String>, GenTraversableOnce<B>> f) {
                return Iterator.class.flatMap((Iterator)this, f);
            }

            public Iterator<Tuple2<UTF8String, UTF8String>> filter(Function1<Tuple2<UTF8String, UTF8String>, Object> p) {
                return Iterator.class.filter((Iterator)this, p);
            }

            public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<Tuple2<UTF8String, UTF8String>, B, Object> p) {
                return Iterator.class.corresponds((Iterator)this, that, p);
            }

            public Iterator<Tuple2<UTF8String, UTF8String>> withFilter(Function1<Tuple2<UTF8String, UTF8String>, Object> p) {
                return Iterator.class.withFilter((Iterator)this, p);
            }

            public Iterator<Tuple2<UTF8String, UTF8String>> filterNot(Function1<Tuple2<UTF8String, UTF8String>, Object> p) {
                return Iterator.class.filterNot((Iterator)this, p);
            }

            public <B> Iterator<B> collect(PartialFunction<Tuple2<UTF8String, UTF8String>, B> pf) {
                return Iterator.class.collect((Iterator)this, pf);
            }

            public <B> Iterator<B> scanLeft(B z, Function2<B, Tuple2<UTF8String, UTF8String>, B> op) {
                return Iterator.class.scanLeft((Iterator)this, z, op);
            }

            public <B> Iterator<B> scanRight(B z, Function2<Tuple2<UTF8String, UTF8String>, B, B> op) {
                return Iterator.class.scanRight((Iterator)this, z, op);
            }

            public Iterator<Tuple2<UTF8String, UTF8String>> takeWhile(Function1<Tuple2<UTF8String, UTF8String>, Object> p) {
                return Iterator.class.takeWhile((Iterator)this, p);
            }

            public Tuple2<Iterator<Tuple2<UTF8String, UTF8String>>, Iterator<Tuple2<UTF8String, UTF8String>>> partition(Function1<Tuple2<UTF8String, UTF8String>, Object> p) {
                return Iterator.class.partition((Iterator)this, p);
            }

            public Tuple2<Iterator<Tuple2<UTF8String, UTF8String>>, Iterator<Tuple2<UTF8String, UTF8String>>> span(Function1<Tuple2<UTF8String, UTF8String>, Object> p) {
                return Iterator.class.span((Iterator)this, p);
            }

            public Iterator<Tuple2<UTF8String, UTF8String>> dropWhile(Function1<Tuple2<UTF8String, UTF8String>, Object> p) {
                return Iterator.class.dropWhile((Iterator)this, p);
            }

            public <B> Iterator<Tuple2<Tuple2<UTF8String, UTF8String>, B>> zip(Iterator<B> that) {
                return Iterator.class.zip((Iterator)this, that);
            }

            public <A1> Iterator<A1> padTo(int len, A1 elem) {
                return Iterator.class.padTo((Iterator)this, (int)len, elem);
            }

            public Iterator<Tuple2<Tuple2<UTF8String, UTF8String>, Object>> zipWithIndex() {
                return Iterator.class.zipWithIndex((Iterator)this);
            }

            public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
                return Iterator.class.zipAll((Iterator)this, that, thisElem, thatElem);
            }

            public <U> void foreach(Function1<Tuple2<UTF8String, UTF8String>, U> f) {
                Iterator.class.foreach((Iterator)this, f);
            }

            public boolean forall(Function1<Tuple2<UTF8String, UTF8String>, Object> p) {
                return Iterator.class.forall((Iterator)this, p);
            }

            public boolean exists(Function1<Tuple2<UTF8String, UTF8String>, Object> p) {
                return Iterator.class.exists((Iterator)this, p);
            }

            public boolean contains(Object elem) {
                return Iterator.class.contains((Iterator)this, (Object)elem);
            }

            public Option<Tuple2<UTF8String, UTF8String>> find(Function1<Tuple2<UTF8String, UTF8String>, Object> p) {
                return Iterator.class.find((Iterator)this, p);
            }

            public int indexWhere(Function1<Tuple2<UTF8String, UTF8String>, Object> p) {
                return Iterator.class.indexWhere((Iterator)this, p);
            }

            public <B> int indexOf(B elem) {
                return Iterator.class.indexOf((Iterator)this, elem);
            }

            public BufferedIterator<Tuple2<UTF8String, UTF8String>> buffered() {
                return Iterator.class.buffered((Iterator)this);
            }

            public <B> Iterator.GroupedIterator<B> grouped(int size) {
                return Iterator.class.grouped((Iterator)this, (int)size);
            }

            public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                return Iterator.class.sliding((Iterator)this, (int)size, (int)step);
            }

            public int length() {
                return Iterator.class.length((Iterator)this);
            }

            public Tuple2<Iterator<Tuple2<UTF8String, UTF8String>>, Iterator<Tuple2<UTF8String, UTF8String>>> duplicate() {
                return Iterator.class.duplicate((Iterator)this);
            }

            public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                return Iterator.class.patch((Iterator)this, (int)from, patchElems, (int)replaced);
            }

            public <B> void copyToArray(Object xs, int start, int len) {
                Iterator.class.copyToArray((Iterator)this, (Object)xs, (int)start, (int)len);
            }

            public boolean sameElements(Iterator<?> that) {
                return Iterator.class.sameElements((Iterator)this, that);
            }

            public Traversable<Tuple2<UTF8String, UTF8String>> toTraversable() {
                return Iterator.class.toTraversable((Iterator)this);
            }

            public Iterator<Tuple2<UTF8String, UTF8String>> toIterator() {
                return Iterator.class.toIterator((Iterator)this);
            }

            public Stream<Tuple2<UTF8String, UTF8String>> toStream() {
                return Iterator.class.toStream((Iterator)this);
            }

            public String toString() {
                return Iterator.class.toString((Iterator)this);
            }

            public <B> int sliding$default$2() {
                return Iterator.class.sliding$default$2((Iterator)this);
            }

            public List<Tuple2<UTF8String, UTF8String>> reversed() {
                return TraversableOnce.class.reversed((TraversableOnce)this);
            }

            public int size() {
                return TraversableOnce.class.size((TraversableOnce)this);
            }

            public boolean nonEmpty() {
                return TraversableOnce.class.nonEmpty((TraversableOnce)this);
            }

            public int count(Function1<Tuple2<UTF8String, UTF8String>, Object> p) {
                return TraversableOnce.class.count((TraversableOnce)this, p);
            }

            public <B> Option<B> collectFirst(PartialFunction<Tuple2<UTF8String, UTF8String>, B> pf) {
                return TraversableOnce.class.collectFirst((TraversableOnce)this, pf);
            }

            public <B> B $div$colon(B z, Function2<B, Tuple2<UTF8String, UTF8String>, B> op) {
                return (B)TraversableOnce.class.$div$colon((TraversableOnce)this, z, op);
            }

            public <B> B $colon$bslash(B z, Function2<Tuple2<UTF8String, UTF8String>, B, B> op) {
                return (B)TraversableOnce.class.$colon$bslash((TraversableOnce)this, z, op);
            }

            public <B> B foldLeft(B z, Function2<B, Tuple2<UTF8String, UTF8String>, B> op) {
                return (B)TraversableOnce.class.foldLeft((TraversableOnce)this, z, op);
            }

            public <B> B foldRight(B z, Function2<Tuple2<UTF8String, UTF8String>, B, B> op) {
                return (B)TraversableOnce.class.foldRight((TraversableOnce)this, z, op);
            }

            public <B> B reduceLeft(Function2<B, Tuple2<UTF8String, UTF8String>, B> op) {
                return (B)TraversableOnce.class.reduceLeft((TraversableOnce)this, op);
            }

            public <B> B reduceRight(Function2<Tuple2<UTF8String, UTF8String>, B, B> op) {
                return (B)TraversableOnce.class.reduceRight((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceLeftOption(Function2<B, Tuple2<UTF8String, UTF8String>, B> op) {
                return TraversableOnce.class.reduceLeftOption((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceRightOption(Function2<Tuple2<UTF8String, UTF8String>, B, B> op) {
                return TraversableOnce.class.reduceRightOption((TraversableOnce)this, op);
            }

            public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.class.reduce((TraversableOnce)this, op);
            }

            public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                return TraversableOnce.class.reduceOption((TraversableOnce)this, op);
            }

            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.class.fold((TraversableOnce)this, z, op);
            }

            public <B> B aggregate(Function0<B> z, Function2<B, Tuple2<UTF8String, UTF8String>, B> seqop, Function2<B, B, B> combop) {
                return (B)TraversableOnce.class.aggregate((TraversableOnce)this, z, seqop, combop);
            }

            public <B> B sum(Numeric<B> num) {
                return (B)TraversableOnce.class.sum((TraversableOnce)this, num);
            }

            public <B> B product(Numeric<B> num) {
                return (B)TraversableOnce.class.product((TraversableOnce)this, num);
            }

            public Object min(Ordering cmp) {
                return TraversableOnce.class.min((TraversableOnce)this, (Ordering)cmp);
            }

            public Object max(Ordering cmp) {
                return TraversableOnce.class.max((TraversableOnce)this, (Ordering)cmp);
            }

            public Object maxBy(Function1 f, Ordering cmp) {
                return TraversableOnce.class.maxBy((TraversableOnce)this, (Function1)f, (Ordering)cmp);
            }

            public Object minBy(Function1 f, Ordering cmp) {
                return TraversableOnce.class.minBy((TraversableOnce)this, (Function1)f, (Ordering)cmp);
            }

            public <B> void copyToBuffer(Buffer<B> dest) {
                TraversableOnce.class.copyToBuffer((TraversableOnce)this, dest);
            }

            public <B> void copyToArray(Object xs, int start) {
                TraversableOnce.class.copyToArray((TraversableOnce)this, (Object)xs, (int)start);
            }

            public <B> void copyToArray(Object xs) {
                TraversableOnce.class.copyToArray((TraversableOnce)this, (Object)xs);
            }

            public <B> Object toArray(ClassTag<B> evidence$1) {
                return TraversableOnce.class.toArray((TraversableOnce)this, evidence$1);
            }

            public List<Tuple2<UTF8String, UTF8String>> toList() {
                return TraversableOnce.class.toList((TraversableOnce)this);
            }

            public Iterable<Tuple2<UTF8String, UTF8String>> toIterable() {
                return TraversableOnce.class.toIterable((TraversableOnce)this);
            }

            public Seq<Tuple2<UTF8String, UTF8String>> toSeq() {
                return TraversableOnce.class.toSeq((TraversableOnce)this);
            }

            public IndexedSeq<Tuple2<UTF8String, UTF8String>> toIndexedSeq() {
                return TraversableOnce.class.toIndexedSeq((TraversableOnce)this);
            }

            public <B> Buffer<B> toBuffer() {
                return TraversableOnce.class.toBuffer((TraversableOnce)this);
            }

            public <B> Set<B> toSet() {
                return TraversableOnce.class.toSet((TraversableOnce)this);
            }

            public Vector<Tuple2<UTF8String, UTF8String>> toVector() {
                return TraversableOnce.class.toVector((TraversableOnce)this);
            }

            public <Col> Col to(CanBuildFrom<Nothing$, Tuple2<UTF8String, UTF8String>, Col> cbf) {
                return (Col)TraversableOnce.class.to((TraversableOnce)this, cbf);
            }

            public <T, U> Map<T, U> toMap(Predef.$less$colon$less<Tuple2<UTF8String, UTF8String>, Tuple2<T, U>> ev) {
                return TraversableOnce.class.toMap((TraversableOnce)this, ev);
            }

            public String mkString(String start, String sep, String end) {
                return TraversableOnce.class.mkString((TraversableOnce)this, (String)start, (String)sep, (String)end);
            }

            public String mkString(String sep) {
                return TraversableOnce.class.mkString((TraversableOnce)this, (String)sep);
            }

            public String mkString() {
                return TraversableOnce.class.mkString((TraversableOnce)this);
            }

            public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
            }

            public StringBuilder addString(StringBuilder b, String sep) {
                return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b, (String)sep);
            }

            public StringBuilder addString(StringBuilder b) {
                return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b);
            }

            public int index() {
                return this.index;
            }

            public void index_$eq(int x$1) {
                this.index = x$1;
            }

            public UTF8String keyValueDelimiterUTF8String() {
                return this.keyValueDelimiterUTF8String;
            }

            public boolean hasNext() {
                return this.keyValues$1.length > this.index();
            }

            public Tuple2<UTF8String, UTF8String> next() {
                UTF8String[] keyValueArray = this.keyValues$1[this.index()].split(this.keyValueDelimiterUTF8String(), 2);
                this.index_$eq(this.index() + 1);
                return new Tuple2((Object)keyValueArray[0], keyValueArray.length < 2 ? null : keyValueArray[1]);
            }
            {
                this.keyValues$1 = keyValues$1;
                TraversableOnce.class.$init$((TraversableOnce)this);
                Iterator.class.$init$((Iterator)this);
                this.index = 0;
                this.keyValueDelimiterUTF8String = (UTF8String)keyValueDelimiter$1;
            }
        };
        return ArrayBasedMapData$.MODULE$.apply(iterator2, Predef$.MODULE$.refArrayOps((Object[])keyValues).size(), (Function1<Object, Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Object apply(Object x) {
                return Predef$.MODULE$.identity(x);
            }
        }, (Function1<Object, Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Object apply(Object x) {
                return Predef$.MODULE$.identity(x);
            }
        });
    }

    @Override
    public String prettyName() {
        return "str_to_map";
    }

    public StringToMap copy(Expression text, Expression pairDelim, Expression keyValueDelim) {
        return new StringToMap(text, pairDelim, keyValueDelim);
    }

    public Expression copy$default$1() {
        return this.text();
    }

    public Expression copy$default$2() {
        return this.pairDelim();
    }

    public Expression copy$default$3() {
        return this.keyValueDelim();
    }

    @Override
    public String productPrefix() {
        return "StringToMap";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 2: {
                expression = this.keyValueDelim();
                break;
            }
            case 1: {
                expression = this.pairDelim();
                break;
            }
            case 0: {
                expression = this.text();
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StringToMap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StringToMap)) return false;
        boolean bl = true;
        if (!bl) return false;
        StringToMap stringToMap = (StringToMap)x$1;
        Expression expression = this.text();
        Expression expression2 = stringToMap.text();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.pairDelim();
        Expression expression4 = stringToMap.pairDelim();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.keyValueDelim();
        Expression expression6 = stringToMap.keyValueDelim();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!stringToMap.canEqual(this)) return false;
        return true;
    }

    public StringToMap(Expression text, Expression pairDelim, Expression keyValueDelim) {
        this.text = text;
        this.pairDelim = pairDelim;
        this.keyValueDelim = keyValueDelim;
        CodegenFallback$class.$init$(this);
        ExpectsInputTypes$class.$init$(this);
    }

    public StringToMap(Expression child, Expression pairDelim) {
        this(child, pairDelim, Literal$.MODULE$.apply(":"));
    }

    public StringToMap(Expression child) {
        this(child, Literal$.MODULE$.apply(","), Literal$.MODULE$.apply(":"));
    }
}

