/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution;

import org.apache.spark.unsafe.Platform;
import org.apache.spark.util.collection.unsafe.sort.RecordComparator;

public final class RecordBinaryComparator
extends RecordComparator {
    public int compare(Object leftObj, long leftOff, int leftLen, Object rightObj, long rightOff, int rightLen) {
        int i;
        int res = 0;
        if (leftLen != rightLen) {
            return leftLen - rightLen;
        }
        if (leftOff % 8L == rightOff % 8L) {
            for (i = 0; (leftOff + (long)i) % 8L != 0L && i < leftLen; ++i) {
                res = (Platform.getByte((Object)leftObj, (long)(leftOff + (long)i)) & 0xFF) - (Platform.getByte((Object)rightObj, (long)(rightOff + (long)i)) & 0xFF);
                if (res == 0) continue;
                return res;
            }
        }
        if (Platform.unaligned() || (leftOff + (long)i) % 8L == 0L && (rightOff + (long)i) % 8L == 0L) {
            while (i <= leftLen - 8) {
                res = (int)((Platform.getLong((Object)leftObj, (long)(leftOff + (long)i)) - Platform.getLong((Object)rightObj, (long)(rightOff + (long)i))) % Integer.MAX_VALUE);
                if (res != 0) {
                    return res;
                }
                i += 8;
            }
        }
        while (i < leftLen) {
            res = (Platform.getByte((Object)leftObj, (long)(leftOff + (long)i)) & 0xFF) - (Platform.getByte((Object)rightObj, (long)(rightOff + (long)i)) & 0xFF);
            if (res != 0) {
                return res;
            }
            ++i;
        }
        return 0;
    }
}

