/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import org.apache.spark.sql.HashBenchmark$;
import org.apache.spark.sql.RandomDataGenerator$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.encoders.RowEncoder$;
import org.apache.spark.sql.catalyst.expressions.HiveHash;
import org.apache.spark.sql.catalyst.expressions.Murmur3Hash;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection$;
import org.apache.spark.sql.catalyst.expressions.XxHash64;
import org.apache.spark.sql.catalyst.expressions.codegen.GenerateSafeProjection$;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.util.Benchmark;
import org.apache.spark.util.Benchmark$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;

public final class HashBenchmark$ {
    public static final HashBenchmark$ MODULE$;

    static {
        new HashBenchmark$();
    }

    public void test(String name, StructType schema, int numRows, int iters) {
        Function0 generator = (Function0)RandomDataGenerator$.MODULE$.forType((DataType)schema, false, RandomDataGenerator$.MODULE$.forType$default$3()).get();
        ExpressionEncoder encoder2 = RowEncoder$.MODULE$.apply(schema);
        Seq attrs = schema.toAttributes();
        package.Projection safeProjection = (package.Projection)GenerateSafeProjection$.MODULE$.generate((Object)attrs, attrs);
        InternalRow[] rows = (InternalRow[])((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), numRows).map((Function1)new Serializable(generator, encoder2, safeProjection){
            public static final long serialVersionUID = 0L;
            private final Function0 generator$1;
            private final ExpressionEncoder encoder$1;
            private final package.Projection safeProjection$1;

            public final InternalRow apply(int x$1) {
                return ((InternalRow)this.safeProjection$1.apply((Object)this.encoder$1.toRow((Object)((Row)this.generator$1.apply())))).copy();
            }
            {
                this.generator$1 = generator$1;
                this.encoder$1 = encoder$1;
                this.safeProjection$1 = safeProjection$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(InternalRow.class));
        Benchmark benchmark = new Benchmark(new StringBuilder().append((Object)"Hash For ").append((Object)name).toString(), (long)(iters * numRows), Benchmark$.MODULE$.$lessinit$greater$default$3(), Benchmark$.MODULE$.$lessinit$greater$default$4(), Benchmark$.MODULE$.$lessinit$greater$default$5(), Benchmark$.MODULE$.$lessinit$greater$default$6(), Benchmark$.MODULE$.$lessinit$greater$default$7());
        benchmark.addCase("interpreted version", benchmark.addCase$default$2(), (Function1)new Serializable(numRows, iters, rows){
            public static final long serialVersionUID = 0L;
            public final int numRows$1;
            private final int iters$1;
            public final InternalRow[] rows$1;

            public final void apply(int x$2) {
                this.apply$mcVI$sp(x$2);
            }

            public void apply$mcVI$sp(int x$2) {
                IntRef sum = IntRef.create((int)0);
                new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)this.iters$1)).foreach((Function1)new Serializable(this, sum){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.test.1 $outer;
                    private final IntRef sum$1;

                    public final void apply(long _) {
                        this.apply$mcVJ$sp(_);
                    }

                    public void apply$mcVJ$sp(long _) {
                        for (int i = 0; i < this.$outer.numRows$1; ++i) {
                            this.sum$1.elem += this.$outer.rows$1[i].hashCode();
                        }
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.sum$1 = sum$1;
                    }
                });
            }
            {
                this.numRows$1 = numRows$1;
                this.iters$1 = iters$1;
                this.rows$1 = rows$1;
            }
        });
        Murmur3Hash murmur3Hash = new Murmur3Hash(attrs);
        UnsafeProjection getHashCode = UnsafeProjection$.MODULE$.create((Seq)Nil$.MODULE$.$colon$colon((Object)murmur3Hash), attrs);
        benchmark.addCase("codegen version", benchmark.addCase$default$2(), (Function1)new Serializable(numRows, iters, rows, getHashCode){
            public static final long serialVersionUID = 0L;
            public final int numRows$1;
            private final int iters$1;
            public final InternalRow[] rows$1;
            public final UnsafeProjection getHashCode$1;

            public final void apply(int x$4) {
                this.apply$mcVI$sp(x$4);
            }

            public void apply$mcVI$sp(int x$4) {
                IntRef sum = IntRef.create((int)0);
                new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)this.iters$1)).foreach((Function1)new Serializable(this, sum){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.test.2 $outer;
                    private final IntRef sum$2;

                    public final void apply(long _) {
                        this.apply$mcVJ$sp(_);
                    }

                    public void apply$mcVJ$sp(long _) {
                        for (int i = 0; i < this.$outer.numRows$1; ++i) {
                            this.sum$2.elem += this.$outer.getHashCode$1.apply(this.$outer.rows$1[i]).getInt(0);
                        }
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.sum$2 = sum$2;
                    }
                });
            }
            {
                this.numRows$1 = numRows$1;
                this.iters$1 = iters$1;
                this.rows$1 = rows$1;
                this.getHashCode$1 = getHashCode$1;
            }
        });
        XxHash64 xxHash64 = new XxHash64(attrs);
        UnsafeProjection getHashCode64b = UnsafeProjection$.MODULE$.create((Seq)Nil$.MODULE$.$colon$colon((Object)xxHash64), attrs);
        benchmark.addCase("codegen version 64-bit", benchmark.addCase$default$2(), (Function1)new Serializable(numRows, iters, rows, getHashCode64b){
            public static final long serialVersionUID = 0L;
            public final int numRows$1;
            private final int iters$1;
            public final InternalRow[] rows$1;
            public final UnsafeProjection getHashCode64b$1;

            public final void apply(int x$6) {
                this.apply$mcVI$sp(x$6);
            }

            public void apply$mcVI$sp(int x$6) {
                IntRef sum = IntRef.create((int)0);
                new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)this.iters$1)).foreach((Function1)new Serializable(this, sum){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.test.3 $outer;
                    private final IntRef sum$3;

                    public final void apply(long _) {
                        this.apply$mcVJ$sp(_);
                    }

                    public void apply$mcVJ$sp(long _) {
                        for (int i = 0; i < this.$outer.numRows$1; ++i) {
                            this.sum$3.elem += this.$outer.getHashCode64b$1.apply(this.$outer.rows$1[i]).getInt(0);
                        }
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.sum$3 = sum$3;
                    }
                });
            }
            {
                this.numRows$1 = numRows$1;
                this.iters$1 = iters$1;
                this.rows$1 = rows$1;
                this.getHashCode64b$1 = getHashCode64b$1;
            }
        });
        HiveHash hiveHash = new HiveHash(attrs);
        UnsafeProjection getHiveHashCode = UnsafeProjection$.MODULE$.create((Seq)Nil$.MODULE$.$colon$colon((Object)hiveHash), attrs);
        benchmark.addCase("codegen HiveHash version", benchmark.addCase$default$2(), (Function1)new Serializable(numRows, iters, rows, getHiveHashCode){
            public static final long serialVersionUID = 0L;
            public final int numRows$1;
            private final int iters$1;
            public final InternalRow[] rows$1;
            public final UnsafeProjection getHiveHashCode$1;

            public final void apply(int x$8) {
                this.apply$mcVI$sp(x$8);
            }

            public void apply$mcVI$sp(int x$8) {
                IntRef sum = IntRef.create((int)0);
                new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)this.iters$1)).foreach((Function1)new Serializable(this, sum){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.test.4 $outer;
                    private final IntRef sum$4;

                    public final void apply(long _) {
                        this.apply$mcVJ$sp(_);
                    }

                    public void apply$mcVJ$sp(long _) {
                        for (int i = 0; i < this.$outer.numRows$1; ++i) {
                            this.sum$4.elem += this.$outer.getHiveHashCode$1.apply(this.$outer.rows$1[i]).getInt(0);
                        }
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.sum$4 = sum$4;
                    }
                });
            }
            {
                this.numRows$1 = numRows$1;
                this.iters$1 = iters$1;
                this.rows$1 = rows$1;
                this.getHiveHashCode$1 = getHiveHashCode$1;
            }
        });
        benchmark.run();
    }

    public void main(String[] args) {
        StructType singleInt = new StructType().add("i", (DataType)IntegerType$.MODULE$);
        this.test("single ints", singleInt, 32768, 16384);
        StructType singleLong = new StructType().add("i", (DataType)LongType$.MODULE$);
        this.test("single longs", singleLong, 32768, 16384);
        StructType normal = new StructType().add("null", (DataType)NullType$.MODULE$).add("boolean", (DataType)BooleanType$.MODULE$).add("byte", (DataType)ByteType$.MODULE$).add("short", (DataType)ShortType$.MODULE$).add("int", (DataType)IntegerType$.MODULE$).add("long", (DataType)LongType$.MODULE$).add("float", (DataType)FloatType$.MODULE$).add("double", (DataType)DoubleType$.MODULE$).add("bigDecimal", (DataType)DecimalType$.MODULE$.SYSTEM_DEFAULT()).add("smallDecimal", (DataType)DecimalType$.MODULE$.USER_DEFAULT()).add("string", (DataType)StringType$.MODULE$).add("binary", (DataType)BinaryType$.MODULE$).add("date", (DataType)DateType$.MODULE$).add("timestamp", (DataType)TimestampType$.MODULE$);
        this.test("normal", normal, 1024, 2048);
        ArrayType arrayOfInt = ArrayType$.MODULE$.apply((DataType)IntegerType$.MODULE$);
        StructType array = new StructType().add("array", (DataType)arrayOfInt).add("arrayOfArray", (DataType)ArrayType$.MODULE$.apply((DataType)arrayOfInt));
        this.test("array", array, 256, 512);
        MapType mapOfInt = MapType$.MODULE$.apply((DataType)IntegerType$.MODULE$, (DataType)IntegerType$.MODULE$);
        StructType map = new StructType().add("map", (DataType)mapOfInt).add("mapOfMap", (DataType)MapType$.MODULE$.apply((DataType)IntegerType$.MODULE$, (DataType)mapOfInt));
        this.test("map", map, 64, 64);
    }

    private HashBenchmark$() {
        MODULE$ = this;
    }
}

