/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.analysis;

import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.analysis.AnalysisTest;
import org.apache.spark.sql.catalyst.analysis.AnalysisTest$class;
import org.apache.spark.sql.catalyst.analysis.Analyzer;
import org.apache.spark.sql.catalyst.analysis.TestRelations$;
import org.apache.spark.sql.catalyst.dsl.package;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.PredicateHelper;
import org.apache.spark.sql.catalyst.parser.CatalystSqlParser$;
import org.apache.spark.sql.catalyst.plans.Inner$;
import org.apache.spark.sql.catalyst.plans.JoinType;
import org.apache.spark.sql.catalyst.plans.PlanTestBase$class;
import org.apache.spark.sql.catalyst.plans.logical.HintInfo;
import org.apache.spark.sql.catalyst.plans.logical.Join;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.ResolvedHint;
import org.apache.spark.sql.catalyst.plans.logical.UnresolvedHint;
import org.apache.spark.sql.internal.SQLConf;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Symbol;
import scala.Symbol$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001q1A!\u0001\u0002\u0001\u001f\t\t\"+Z:pYZ,\u0007*\u001b8ugN+\u0018\u000e^3\u000b\u0005\r!\u0011\u0001C1oC2L8/[:\u000b\u0005\u00151\u0011\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005\u001dA\u0011aA:rY*\u0011\u0011BC\u0001\u0006gB\f'o\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001\u0001B\u0003\u0005\u0002\u0012%5\t\u0001\"\u0003\u0002\u0014\u0011\ti1\u000b]1sW\u001a+hnU;ji\u0016\u0004\"!\u0006\f\u000e\u0003\tI!a\u0006\u0002\u0003\u0019\u0005s\u0017\r\\=tSN$Vm\u001d;\t\u000be\u0001A\u0011\u0001\u000e\u0002\rqJg.\u001b;?)\u0005Y\u0002CA\u000b\u0001\u0001")
public class ResolveHintsSuite
extends SparkFunSuite
implements AnalysisTest {
    private final Analyzer caseSensitiveAnalyzer;
    private final Analyzer caseInsensitiveAnalyzer;

    @Override
    public Analyzer caseSensitiveAnalyzer() {
        return this.caseSensitiveAnalyzer;
    }

    @Override
    public Analyzer caseInsensitiveAnalyzer() {
        return this.caseInsensitiveAnalyzer;
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$catalyst$analysis$AnalysisTest$$super$comparePlans(LogicalPlan plan1, LogicalPlan plan2, boolean checkAnalysis) {
        PlanTestBase$class.comparePlans(this, plan1, plan2, checkAnalysis);
    }

    @Override
    public void org$apache$spark$sql$catalyst$analysis$AnalysisTest$_setter_$caseSensitiveAnalyzer_$eq(Analyzer x$1) {
        this.caseSensitiveAnalyzer = x$1;
    }

    @Override
    public void org$apache$spark$sql$catalyst$analysis$AnalysisTest$_setter_$caseInsensitiveAnalyzer_$eq(Analyzer x$1) {
        this.caseInsensitiveAnalyzer = x$1;
    }

    @Override
    public Analyzer getAnalyzer(boolean caseSensitive) {
        return AnalysisTest$class.getAnalyzer(this, caseSensitive);
    }

    @Override
    public void checkAnalysis(LogicalPlan inputPlan, LogicalPlan expectedPlan, boolean caseSensitive) {
        AnalysisTest$class.checkAnalysis(this, inputPlan, expectedPlan, caseSensitive);
    }

    @Override
    public void comparePlans(LogicalPlan plan1, LogicalPlan plan2, boolean checkAnalysis) {
        AnalysisTest$class.comparePlans(this, plan1, plan2, checkAnalysis);
    }

    @Override
    public void assertAnalysisSuccess(LogicalPlan inputPlan, boolean caseSensitive) {
        AnalysisTest$class.assertAnalysisSuccess(this, inputPlan, caseSensitive);
    }

    @Override
    public void assertAnalysisError(LogicalPlan inputPlan, Seq<String> expectedErrors, boolean caseSensitive) {
        AnalysisTest$class.assertAnalysisError(this, inputPlan, expectedErrors, caseSensitive);
    }

    @Override
    public boolean assertAnalysisError$default$3() {
        return AnalysisTest$class.assertAnalysisError$default$3(this);
    }

    @Override
    public boolean assertAnalysisSuccess$default$2() {
        return AnalysisTest$class.assertAnalysisSuccess$default$2(this);
    }

    @Override
    public boolean checkAnalysis$default$3() {
        return AnalysisTest$class.checkAnalysis$default$3(this);
    }

    @Override
    public boolean comparePlans$default$3() {
        return AnalysisTest$class.comparePlans$default$3(this);
    }

    @Override
    public SQLConf conf() {
        return PlanTestBase$class.conf(this);
    }

    @Override
    public LogicalPlan normalizeExprIds(LogicalPlan plan) {
        return PlanTestBase$class.normalizeExprIds(this, plan);
    }

    @Override
    public LogicalPlan normalizePlan(LogicalPlan plan) {
        return PlanTestBase$class.normalizePlan(this, plan);
    }

    @Override
    public void compareExpressions(Expression e1, Expression e2) {
        PlanTestBase$class.compareExpressions(this, e1, e2);
    }

    @Override
    public void compareJoinOrder(LogicalPlan plan1, LogicalPlan plan2) {
        PlanTestBase$class.compareJoinOrder(this, plan1, plan2);
    }

    @Override
    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f2) {
        PlanTestBase$class.withSQLConf(this, pairs, f2);
    }

    public Seq<Expression> splitConjunctivePredicates(Expression condition) {
        return PredicateHelper.class.splitConjunctivePredicates((PredicateHelper)this, (Expression)condition);
    }

    public Seq<Expression> splitDisjunctivePredicates(Expression condition) {
        return PredicateHelper.class.splitDisjunctivePredicates((PredicateHelper)this, (Expression)condition);
    }

    public Expression replaceAlias(Expression condition, AttributeMap<Expression> aliases) {
        return PredicateHelper.class.replaceAlias((PredicateHelper)this, (Expression)condition, aliases);
    }

    public boolean canEvaluate(Expression expr, LogicalPlan plan) {
        return PredicateHelper.class.canEvaluate((PredicateHelper)this, (Expression)expr, (LogicalPlan)plan);
    }

    public boolean canEvaluateWithinJoin(Expression expr) {
        return PredicateHelper.class.canEvaluateWithinJoin((PredicateHelper)this, (Expression)expr);
    }

    public ResolveHintsSuite() {
        PredicateHelper.class.$init$((PredicateHelper)this);
        PlanTestBase$class.$init$(this);
        AnalysisTest$class.$init$(this);
        this.test("invalid hints should be ignored", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ResolveHintsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.checkAnalysis((LogicalPlan)new UnresolvedHint("some_random_hint_that_does_not_exist", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TaBlE"})), package.plans$.MODULE$.table("TaBlE")), (LogicalPlan)TestRelations$.MODULE$.testRelation(), false);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ResolveHintsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 29));
        this.test("case-sensitive or insensitive parameters", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ResolveHintsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.checkAnalysis((LogicalPlan)new UnresolvedHint("MAPJOIN", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TaBlE"})), package.plans$.MODULE$.table("TaBlE")), (LogicalPlan)new ResolvedHint((LogicalPlan)TestRelations$.MODULE$.testRelation(), new HintInfo(true)), false);
                this.$outer.checkAnalysis((LogicalPlan)new UnresolvedHint("MAPJOIN", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"table"})), package.plans$.MODULE$.table("TaBlE")), (LogicalPlan)new ResolvedHint((LogicalPlan)TestRelations$.MODULE$.testRelation(), new HintInfo(true)), false);
                this.$outer.checkAnalysis((LogicalPlan)new UnresolvedHint("MAPJOIN", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TaBlE"})), package.plans$.MODULE$.table("TaBlE")), (LogicalPlan)new ResolvedHint((LogicalPlan)TestRelations$.MODULE$.testRelation(), new HintInfo(true)), true);
                this.$outer.checkAnalysis((LogicalPlan)new UnresolvedHint("MAPJOIN", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"table"})), package.plans$.MODULE$.table("TaBlE")), (LogicalPlan)TestRelations$.MODULE$.testRelation(), true);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ResolveHintsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 36));
        this.test("multiple broadcast hint aliases", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ResolveHintsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                package.plans$.DslLogicalPlan qual$1 = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("table"));
                LogicalPlan x$1 = package.plans$.MODULE$.table("table2");
                JoinType x$2 = qual$1.join$default$2();
                Option x$3 = qual$1.join$default$3();
                this.$outer.checkAnalysis((LogicalPlan)new UnresolvedHint("MAPJOIN", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"table", "table2"})), qual$1.join(x$1, x$2, x$3)), (LogicalPlan)new Join((LogicalPlan)new ResolvedHint((LogicalPlan)TestRelations$.MODULE$.testRelation(), new HintInfo(true)), (LogicalPlan)new ResolvedHint((LogicalPlan)TestRelations$.MODULE$.testRelation2(), new HintInfo(true)), (JoinType)Inner$.MODULE$, (Option)None$.MODULE$), false);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ResolveHintsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 58));
        this.test("do not traverse past existing broadcast hints", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ResolveHintsSuite $outer;
            private static Symbol symbol$1;

            static {
                symbol$1 = Symbol$.MODULE$.apply("a");
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.checkAnalysis((LogicalPlan)new UnresolvedHint("MAPJOIN", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"table"})), (LogicalPlan)new ResolvedHint(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("table")).where((Expression)package.expressions$.MODULE$.DslSymbol(symbol$1).$greater((Expression)package.expressions$.MODULE$.intToLiteral(1))), new HintInfo(true))), package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new ResolvedHint(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)TestRelations$.MODULE$.testRelation()).where((Expression)package.expressions$.MODULE$.DslSymbol(symbol$1).$greater((Expression)package.expressions$.MODULE$.intToLiteral(1))), new HintInfo(true))).analyze(), false);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ResolveHintsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 66));
        this.test("should work for subqueries", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ResolveHintsSuite $outer;
            private static Symbol symbol$2;

            static {
                symbol$2 = Symbol$.MODULE$.apply("tableAlias");
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.checkAnalysis((LogicalPlan)new UnresolvedHint("MAPJOIN", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tableAlias"})), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("table")).as("tableAlias")), (LogicalPlan)new ResolvedHint((LogicalPlan)TestRelations$.MODULE$.testRelation(), new HintInfo(true)), false);
                this.$outer.checkAnalysis((LogicalPlan)new UnresolvedHint("MAPJOIN", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tableAlias"})), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("table")).subquery(symbol$2)), (LogicalPlan)new ResolvedHint((LogicalPlan)TestRelations$.MODULE$.testRelation(), new HintInfo(true)), false);
                this.$outer.checkAnalysis((LogicalPlan)new UnresolvedHint("MAPJOIN", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"table"})), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("table")).as("tableAlias")), (LogicalPlan)TestRelations$.MODULE$.testRelation(), false);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ResolveHintsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74));
        this.test("do not traverse past subquery alias", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ResolveHintsSuite $outer;
            private static Symbol symbol$3;
            private static Symbol symbol$4;

            static {
                symbol$3 = Symbol$.MODULE$.apply("a");
                symbol$4 = Symbol$.MODULE$.apply("tableAlias");
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.checkAnalysis((LogicalPlan)new UnresolvedHint("MAPJOIN", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"table"})), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table("table")).where((Expression)package.expressions$.MODULE$.DslSymbol(symbol$3).$greater((Expression)package.expressions$.MODULE$.intToLiteral(1)))).subquery(symbol$4)), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)TestRelations$.MODULE$.testRelation()).where((Expression)package.expressions$.MODULE$.DslSymbol(symbol$3).$greater((Expression)package.expressions$.MODULE$.intToLiteral(1)))).analyze(), false);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ResolveHintsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 92));
        this.test("should work for CTE", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ResolveHintsSuite $outer;
            private static Symbol symbol$5;

            static {
                symbol$5 = Symbol$.MODULE$.apply("a");
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.checkAnalysis(CatalystSqlParser$.MODULE$.parsePlan(new StringOps(Predef$.MODULE$.augmentString("\n          |WITH ctetable AS (SELECT * FROM table WHERE a > 1)\n          |SELECT /*+ BROADCAST(ctetable) */ * FROM ctetable\n        ")).stripMargin()), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new ResolvedHint(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)TestRelations$.MODULE$.testRelation()).where((Expression)package.expressions$.MODULE$.DslSymbol(symbol$5).$greater((Expression)package.expressions$.MODULE$.intToLiteral(1)))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$5)})), new HintInfo(true))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$5)}))).analyze(), false);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ResolveHintsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 99));
        this.test("should not traverse down CTE", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ResolveHintsSuite $outer;
            private static Symbol symbol$6;

            static {
                symbol$6 = Symbol$.MODULE$.apply("a");
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.checkAnalysis(CatalystSqlParser$.MODULE$.parsePlan(new StringOps(Predef$.MODULE$.augmentString("\n          |WITH ctetable AS (SELECT * FROM table WHERE a > 1)\n          |SELECT /*+ BROADCAST(table) */ * FROM ctetable\n        ")).stripMargin()), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)TestRelations$.MODULE$.testRelation()).where((Expression)package.expressions$.MODULE$.DslSymbol(symbol$6).$greater((Expression)package.expressions$.MODULE$.intToLiteral(1)))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$6)}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$6)}))).analyze(), false);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ResolveHintsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112));
    }
}

