/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.util.Random;
import org.apache.spark.SparkConf;
import org.apache.spark.memory.MemoryManager;
import org.apache.spark.memory.TaskMemoryManager;
import org.apache.spark.memory.TestMemoryManager;
import org.apache.spark.sql.catalyst.expressions.FixedLengthRowBasedKeyValueBatch;
import org.apache.spark.sql.catalyst.expressions.RowBasedKeyValueBatch;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.catalyst.expressions.VariableLengthRowBasedKeyValueBatch;
import org.apache.spark.sql.catalyst.expressions.codegen.BufferHolder;
import org.apache.spark.sql.catalyst.expressions.codegen.UnsafeRowWriter;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.KVIterator;
import org.apache.spark.unsafe.types.UTF8String;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RowBasedKeyValueBatchSuite {
    private final Random rand = new Random(42L);
    private TestMemoryManager memoryManager;
    private TaskMemoryManager taskMemoryManager;
    private StructType keySchema = new StructType().add("k1", DataTypes.LongType).add("k2", DataTypes.StringType);
    private StructType fixedKeySchema = new StructType().add("k1", DataTypes.LongType).add("k2", DataTypes.LongType);
    private StructType valueSchema = new StructType().add("count", DataTypes.LongType).add("sum", DataTypes.LongType);
    private int DEFAULT_CAPACITY = 65536;

    private String getRandomString(int length) {
        Assert.assertTrue((length >= 0 ? 1 : 0) != 0);
        byte[] bytes = new byte[length];
        this.rand.nextBytes(bytes);
        return new String(bytes);
    }

    private UnsafeRow makeKeyRow(long k1, String k2) {
        UnsafeRow row = new UnsafeRow(2);
        BufferHolder holder = new BufferHolder(row, 32);
        UnsafeRowWriter writer = new UnsafeRowWriter(holder, 2);
        holder.reset();
        writer.write(0, k1);
        writer.write(1, UTF8String.fromString((String)k2));
        row.setTotalSize(holder.totalSize());
        return row;
    }

    private UnsafeRow makeKeyRow(long k1, long k2) {
        UnsafeRow row = new UnsafeRow(2);
        BufferHolder holder = new BufferHolder(row, 0);
        UnsafeRowWriter writer = new UnsafeRowWriter(holder, 2);
        holder.reset();
        writer.write(0, k1);
        writer.write(1, k2);
        row.setTotalSize(holder.totalSize());
        return row;
    }

    private UnsafeRow makeValueRow(long v1, long v2) {
        UnsafeRow row = new UnsafeRow(2);
        BufferHolder holder = new BufferHolder(row, 0);
        UnsafeRowWriter writer = new UnsafeRowWriter(holder, 2);
        holder.reset();
        writer.write(0, v1);
        writer.write(1, v2);
        row.setTotalSize(holder.totalSize());
        return row;
    }

    private UnsafeRow appendRow(RowBasedKeyValueBatch batch, UnsafeRow key, UnsafeRow value) {
        return batch.appendRow(key.getBaseObject(), key.getBaseOffset(), key.getSizeInBytes(), value.getBaseObject(), value.getBaseOffset(), value.getSizeInBytes());
    }

    private void updateValueRow(UnsafeRow row, long v1, long v2) {
        row.setLong(0, v1);
        row.setLong(1, v2);
    }

    private boolean checkKey(UnsafeRow row, long k1, String k2) {
        return row.getLong(0) == k1 && row.getUTF8String(1).equals((Object)UTF8String.fromString((String)k2));
    }

    private boolean checkKey(UnsafeRow row, long k1, long k2) {
        return row.getLong(0) == k1 && row.getLong(1) == k2;
    }

    private boolean checkValue(UnsafeRow row, long v1, long v2) {
        return row.getLong(0) == v1 && row.getLong(1) == v2;
    }

    @Before
    public void setup() {
        this.memoryManager = new TestMemoryManager(new SparkConf().set("spark.memory.offHeap.enabled", "false").set("spark.shuffle.spill.compress", "false").set("spark.shuffle.compress", "false"));
        this.taskMemoryManager = new TaskMemoryManager((MemoryManager)this.memoryManager, 0L);
    }

    @After
    public void tearDown() {
        if (this.taskMemoryManager != null) {
            Assert.assertEquals((long)0L, (long)this.taskMemoryManager.cleanUpAllAllocatedMemory());
            long leakedMemory = this.taskMemoryManager.getMemoryConsumptionForThisTask();
            this.taskMemoryManager = null;
            Assert.assertEquals((long)0L, (long)leakedMemory);
        }
    }

    @Test
    public void emptyBatch() throws Exception {
        try (RowBasedKeyValueBatch batch = RowBasedKeyValueBatch.allocate((StructType)this.keySchema, (StructType)this.valueSchema, (TaskMemoryManager)this.taskMemoryManager, (int)this.DEFAULT_CAPACITY);){
            Assert.assertEquals((long)0L, (long)batch.numRows());
            try {
                batch.getKeyRow(-1);
                Assert.fail((String)"Should not be able to get row -1");
            }
            catch (AssertionError assertionError) {
                // empty catch block
            }
            try {
                batch.getValueRow(-1);
                Assert.fail((String)"Should not be able to get row -1");
            }
            catch (AssertionError assertionError) {
                // empty catch block
            }
            try {
                batch.getKeyRow(0);
                Assert.fail((String)"Should not be able to get row 0 when batch is empty");
            }
            catch (AssertionError assertionError) {
                // empty catch block
            }
            try {
                batch.getValueRow(0);
                Assert.fail((String)"Should not be able to get row 0 when batch is empty");
            }
            catch (AssertionError assertionError) {
                // empty catch block
            }
            Assert.assertFalse((boolean)batch.rowIterator().next());
        }
    }

    @Test
    public void batchType() throws Exception {
        RowBasedKeyValueBatch batch1 = RowBasedKeyValueBatch.allocate((StructType)this.keySchema, (StructType)this.valueSchema, (TaskMemoryManager)this.taskMemoryManager, (int)this.DEFAULT_CAPACITY);
        RowBasedKeyValueBatch batch2 = RowBasedKeyValueBatch.allocate((StructType)this.fixedKeySchema, (StructType)this.valueSchema, (TaskMemoryManager)this.taskMemoryManager, (int)this.DEFAULT_CAPACITY);
        try {
            Assert.assertEquals(batch1.getClass(), VariableLengthRowBasedKeyValueBatch.class);
            Assert.assertEquals(batch2.getClass(), FixedLengthRowBasedKeyValueBatch.class);
        }
        finally {
            batch1.close();
            batch2.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void setAndRetrieve() {
        try (RowBasedKeyValueBatch batch = RowBasedKeyValueBatch.allocate((StructType)this.keySchema, (StructType)this.valueSchema, (TaskMemoryManager)this.taskMemoryManager, (int)this.DEFAULT_CAPACITY);){
            UnsafeRow ret1 = this.appendRow(batch, this.makeKeyRow(1L, "A"), this.makeValueRow(1L, 1L));
            Assert.assertTrue((boolean)this.checkValue(ret1, 1L, 1L));
            UnsafeRow ret2 = this.appendRow(batch, this.makeKeyRow(2L, "B"), this.makeValueRow(2L, 2L));
            Assert.assertTrue((boolean)this.checkValue(ret2, 2L, 2L));
            UnsafeRow ret3 = this.appendRow(batch, this.makeKeyRow(3L, "C"), this.makeValueRow(3L, 3L));
            Assert.assertTrue((boolean)this.checkValue(ret3, 3L, 3L));
            Assert.assertEquals((long)3L, (long)batch.numRows());
            UnsafeRow retrievedKey1 = batch.getKeyRow(0);
            Assert.assertTrue((boolean)this.checkKey(retrievedKey1, 1L, "A"));
            UnsafeRow retrievedKey2 = batch.getKeyRow(1);
            Assert.assertTrue((boolean)this.checkKey(retrievedKey2, 2L, "B"));
            UnsafeRow retrievedValue1 = batch.getValueRow(1);
            Assert.assertTrue((boolean)this.checkValue(retrievedValue1, 2L, 2L));
            UnsafeRow retrievedValue2 = batch.getValueRow(2);
            Assert.assertTrue((boolean)this.checkValue(retrievedValue2, 3L, 3L));
            try {
                batch.getKeyRow(3);
                Assert.fail((String)"Should not be able to get row 3");
            }
            catch (AssertionError assertionError) {
                // empty catch block
            }
            try {
                batch.getValueRow(3);
                Assert.fail((String)"Should not be able to get row 3");
            }
            catch (AssertionError assertionError) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void setUpdateAndRetrieve() {
        try (RowBasedKeyValueBatch batch = RowBasedKeyValueBatch.allocate((StructType)this.keySchema, (StructType)this.valueSchema, (TaskMemoryManager)this.taskMemoryManager, (int)this.DEFAULT_CAPACITY);){
            this.appendRow(batch, this.makeKeyRow(1L, "A"), this.makeValueRow(1L, 1L));
            Assert.assertEquals((long)1L, (long)batch.numRows());
            UnsafeRow retrievedValue = batch.getValueRow(0);
            this.updateValueRow(retrievedValue, 2L, 2L);
            UnsafeRow retrievedValue2 = batch.getValueRow(0);
            Assert.assertTrue((boolean)this.checkValue(retrievedValue2, 2L, 2L));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void iteratorTest() throws Exception {
        try (RowBasedKeyValueBatch batch = RowBasedKeyValueBatch.allocate((StructType)this.keySchema, (StructType)this.valueSchema, (TaskMemoryManager)this.taskMemoryManager, (int)this.DEFAULT_CAPACITY);){
            this.appendRow(batch, this.makeKeyRow(1L, "A"), this.makeValueRow(1L, 1L));
            this.appendRow(batch, this.makeKeyRow(2L, "B"), this.makeValueRow(2L, 2L));
            this.appendRow(batch, this.makeKeyRow(3L, "C"), this.makeValueRow(3L, 3L));
            Assert.assertEquals((long)3L, (long)batch.numRows());
            KVIterator iterator = batch.rowIterator();
            Assert.assertTrue((boolean)iterator.next());
            UnsafeRow key1 = (UnsafeRow)iterator.getKey();
            UnsafeRow value1 = (UnsafeRow)iterator.getValue();
            Assert.assertTrue((boolean)this.checkKey(key1, 1L, "A"));
            Assert.assertTrue((boolean)this.checkValue(value1, 1L, 1L));
            Assert.assertTrue((boolean)iterator.next());
            UnsafeRow key2 = (UnsafeRow)iterator.getKey();
            UnsafeRow value2 = (UnsafeRow)iterator.getValue();
            Assert.assertTrue((boolean)this.checkKey(key2, 2L, "B"));
            Assert.assertTrue((boolean)this.checkValue(value2, 2L, 2L));
            Assert.assertTrue((boolean)iterator.next());
            UnsafeRow key3 = (UnsafeRow)iterator.getKey();
            UnsafeRow value3 = (UnsafeRow)iterator.getValue();
            Assert.assertTrue((boolean)this.checkKey(key3, 3L, "C"));
            Assert.assertTrue((boolean)this.checkValue(value3, 3L, 3L));
            Assert.assertFalse((boolean)iterator.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void fixedLengthTest() throws Exception {
        try (RowBasedKeyValueBatch batch = RowBasedKeyValueBatch.allocate((StructType)this.fixedKeySchema, (StructType)this.valueSchema, (TaskMemoryManager)this.taskMemoryManager, (int)this.DEFAULT_CAPACITY);){
            this.appendRow(batch, this.makeKeyRow(11L, 11L), this.makeValueRow(1L, 1L));
            this.appendRow(batch, this.makeKeyRow(22L, 22L), this.makeValueRow(2L, 2L));
            this.appendRow(batch, this.makeKeyRow(33L, 33L), this.makeValueRow(3L, 3L));
            UnsafeRow retrievedKey1 = batch.getKeyRow(0);
            Assert.assertTrue((boolean)this.checkKey(retrievedKey1, 11L, 11L));
            UnsafeRow retrievedKey2 = batch.getKeyRow(1);
            Assert.assertTrue((boolean)this.checkKey(retrievedKey2, 22L, 22L));
            UnsafeRow retrievedValue1 = batch.getValueRow(1);
            Assert.assertTrue((boolean)this.checkValue(retrievedValue1, 2L, 2L));
            UnsafeRow retrievedValue2 = batch.getValueRow(2);
            Assert.assertTrue((boolean)this.checkValue(retrievedValue2, 3L, 3L));
            Assert.assertEquals((long)3L, (long)batch.numRows());
            KVIterator iterator = batch.rowIterator();
            Assert.assertTrue((boolean)iterator.next());
            UnsafeRow key1 = (UnsafeRow)iterator.getKey();
            UnsafeRow value1 = (UnsafeRow)iterator.getValue();
            Assert.assertTrue((boolean)this.checkKey(key1, 11L, 11L));
            Assert.assertTrue((boolean)this.checkValue(value1, 1L, 1L));
            Assert.assertTrue((boolean)iterator.next());
            UnsafeRow key2 = (UnsafeRow)iterator.getKey();
            UnsafeRow value2 = (UnsafeRow)iterator.getValue();
            Assert.assertTrue((boolean)this.checkKey(key2, 22L, 22L));
            Assert.assertTrue((boolean)this.checkValue(value2, 2L, 2L));
            Assert.assertTrue((boolean)iterator.next());
            UnsafeRow key3 = (UnsafeRow)iterator.getKey();
            UnsafeRow value3 = (UnsafeRow)iterator.getValue();
            Assert.assertTrue((boolean)this.checkKey(key3, 33L, 33L));
            Assert.assertTrue((boolean)this.checkValue(value3, 3L, 3L));
            Assert.assertFalse((boolean)iterator.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void appendRowUntilExceedingCapacity() throws Exception {
        try (RowBasedKeyValueBatch batch = RowBasedKeyValueBatch.allocate((StructType)this.keySchema, (StructType)this.valueSchema, (TaskMemoryManager)this.taskMemoryManager, (int)10);){
            UnsafeRow key = this.makeKeyRow(1L, "A");
            UnsafeRow value = this.makeValueRow(1L, 1L);
            for (int i = 0; i < 10; ++i) {
                this.appendRow(batch, key, value);
            }
            UnsafeRow ret = this.appendRow(batch, key, value);
            Assert.assertEquals((long)batch.numRows(), (long)10L);
            Assert.assertNull((Object)ret);
            KVIterator iterator = batch.rowIterator();
            for (int i = 0; i < 10; ++i) {
                Assert.assertTrue((boolean)iterator.next());
                UnsafeRow key1 = (UnsafeRow)iterator.getKey();
                UnsafeRow value1 = (UnsafeRow)iterator.getValue();
                Assert.assertTrue((boolean)this.checkKey(key1, 1L, "A"));
                Assert.assertTrue((boolean)this.checkValue(value1, 1L, 1L));
            }
            Assert.assertFalse((boolean)iterator.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void appendRowUntilExceedingPageSize() throws Exception {
        int pageSizeToUse = (int)this.memoryManager.pageSizeBytes();
        try (RowBasedKeyValueBatch batch = RowBasedKeyValueBatch.allocate((StructType)this.keySchema, (StructType)this.valueSchema, (TaskMemoryManager)this.taskMemoryManager, (int)pageSizeToUse);){
            UnsafeRow key = this.makeKeyRow(1L, "A");
            UnsafeRow value = this.makeValueRow(1L, 1L);
            int recordLength = 8 + key.getSizeInBytes() + value.getSizeInBytes() + 8;
            int totalSize = 4;
            int numRows = 0;
            while (totalSize + recordLength < pageSizeToUse) {
                this.appendRow(batch, key, value);
                totalSize += recordLength;
                ++numRows;
            }
            UnsafeRow ret = this.appendRow(batch, key, value);
            Assert.assertEquals((long)batch.numRows(), (long)numRows);
            Assert.assertNull((Object)ret);
            KVIterator iterator = batch.rowIterator();
            for (int i = 0; i < numRows; ++i) {
                Assert.assertTrue((boolean)iterator.next());
                UnsafeRow key1 = (UnsafeRow)iterator.getKey();
                UnsafeRow value1 = (UnsafeRow)iterator.getValue();
                Assert.assertTrue((boolean)this.checkKey(key1, 1L, "A"));
                Assert.assertTrue((boolean)this.checkValue(value1, 1L, 1L));
            }
            Assert.assertFalse((boolean)iterator.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void failureToAllocateFirstPage() throws Exception {
        this.memoryManager.limit(1024L);
        try (RowBasedKeyValueBatch batch = RowBasedKeyValueBatch.allocate((StructType)this.keySchema, (StructType)this.valueSchema, (TaskMemoryManager)this.taskMemoryManager, (int)this.DEFAULT_CAPACITY);){
            UnsafeRow key = this.makeKeyRow(1L, "A");
            UnsafeRow value = this.makeValueRow(11L, 11L);
            UnsafeRow ret = this.appendRow(batch, key, value);
            Assert.assertNull((Object)ret);
            Assert.assertFalse((boolean)batch.rowIterator().next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void randomizedTest() {
        RowBasedKeyValueBatch batch = RowBasedKeyValueBatch.allocate((StructType)this.keySchema, (StructType)this.valueSchema, (TaskMemoryManager)this.taskMemoryManager, (int)this.DEFAULT_CAPACITY);
        int numEntry = 100;
        long[] expectedK1 = new long[numEntry];
        String[] expectedK2 = new String[numEntry];
        long[] expectedV1 = new long[numEntry];
        long[] expectedV2 = new long[numEntry];
        for (int i = 0; i < numEntry; ++i) {
            long k1 = this.rand.nextLong();
            String k2 = this.getRandomString(this.rand.nextInt(256));
            long v1 = this.rand.nextLong();
            long v2 = this.rand.nextLong();
            this.appendRow(batch, this.makeKeyRow(k1, k2), this.makeValueRow(v1, v2));
            expectedK1[i] = k1;
            expectedK2[i] = k2;
            expectedV1[i] = v1;
            expectedV2[i] = v2;
        }
        try {
            for (int j = 0; j < 10000; ++j) {
                int rowId = this.rand.nextInt(numEntry);
                if (this.rand.nextBoolean()) {
                    UnsafeRow key = batch.getKeyRow(rowId);
                    Assert.assertTrue((boolean)this.checkKey(key, expectedK1[rowId], expectedK2[rowId]));
                }
                if (!this.rand.nextBoolean()) continue;
                UnsafeRow value = batch.getValueRow(rowId);
                Assert.assertTrue((boolean)this.checkValue(value, expectedV1[rowId], expectedV2[rowId]));
            }
        }
        finally {
            batch.close();
        }
    }
}

