/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes$class;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.TruncDate$;
import org.apache.spark.sql.catalyst.expressions.TruncInstant;
import org.apache.spark.sql.catalyst.expressions.TruncInstant$class;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.StringType$;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(date, fmt) - Returns `date` with the time portion of the day truncated to the unit specified by the format model `fmt`.\n    `fmt` should be one of [\"year\", \"yyyy\", \"yy\", \"mon\", \"month\", \"mm\"]\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('2009-02-12', 'MM');\n       2009-02-01\n      > SELECT _FUNC_('2015-10-27', 'YEAR');\n       2015-01-01\n  ", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0001\u0005]g\u0001B\u0001\u0003\u0001>\u0011\u0011\u0002\u0016:v]\u000e$\u0015\r^3\u000b\u0005\r!\u0011aC3yaJ,7o]5p]NT!!\u0002\u0004\u0002\u0011\r\fG/\u00197zgRT!a\u0002\u0005\u0002\u0007M\fHN\u0003\u0002\n\u0015\u0005)1\u000f]1sW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u0019R\u0001\u0001\t\u0015/u\u0001\"!\u0005\n\u000e\u0003\tI!a\u0005\u0002\u0003!\tKg.\u0019:z\u000bb\u0004(/Z:tS>t\u0007CA\t\u0016\u0013\t1\"A\u0001\u0007UeVt7-\u00138ti\u0006tG\u000f\u0005\u0002\u001975\t\u0011DC\u0001\u001b\u0003\u0015\u00198-\u00197b\u0013\ta\u0012DA\u0004Qe>$Wo\u0019;\u0011\u0005aq\u0012BA\u0010\u001a\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011!\t\u0003A!f\u0001\n\u0003\u0011\u0013\u0001\u00023bi\u0016,\u0012a\t\t\u0003#\u0011J!!\n\u0002\u0003\u0015\u0015C\bO]3tg&|g\u000e\u0003\u0005(\u0001\tE\t\u0015!\u0003$\u0003\u0015!\u0017\r^3!\u0011!I\u0003A!f\u0001\n\u0003\u0011\u0013A\u00024pe6\fG\u000f\u0003\u0005,\u0001\tE\t\u0015!\u0003$\u0003\u001d1wN]7bi\u0002BQ!\f\u0001\u0005\u00029\na\u0001P5oSRtDcA\u00181cA\u0011\u0011\u0003\u0001\u0005\u0006C1\u0002\ra\t\u0005\u0006S1\u0002\ra\t\u0005\u0006g\u0001!\tEI\u0001\u0005Y\u00164G\u000fC\u00036\u0001\u0011\u0005#%A\u0003sS\u001eDG\u000fC\u00038\u0001\u0011\u0005\u0003(\u0001\u0006j]B,H\u000fV=qKN,\u0012!\u000f\t\u0004u\t+eBA\u001eA\u001d\tat(D\u0001>\u0015\tqd\"\u0001\u0004=e>|GOP\u0005\u00025%\u0011\u0011)G\u0001\ba\u0006\u001c7.Y4f\u0013\t\u0019EIA\u0002TKFT!!Q\r\u0011\u0005\u0019KU\"A$\u000b\u0005!3\u0011!\u0002;za\u0016\u001c\u0018B\u0001&H\u0005A\t%m\u001d;sC\u000e$H)\u0019;b)f\u0004X\rC\u0003M\u0001\u0011\u0005S*\u0001\u0005eCR\fG+\u001f9f+\u0005q\u0005C\u0001$P\u0013\t\u0001vI\u0001\u0005ECR\fG+\u001f9f\u0011\u0015\u0011\u0006\u0001\"\u0011T\u0003)\u0001(/\u001a;us:\u000bW.Z\u000b\u0002)B\u0011Q\u000b\u0017\b\u00031YK!aV\r\u0002\rA\u0013X\rZ3g\u0013\tI&L\u0001\u0004TiJLgn\u001a\u0006\u0003/fAq\u0001\u0018\u0001C\u0002\u0013\u0005#%A\u0004j]N$\u0018M\u001c;\t\ry\u0003\u0001\u0015!\u0003$\u0003!Ign\u001d;b]R\u0004\u0003\"\u00021\u0001\t\u0003\n\u0017\u0001B3wC2$\"AY3\u0011\u0005a\u0019\u0017B\u00013\u001a\u0005\r\te.\u001f\u0005\bM~\u0003\n\u00111\u0001h\u0003\u0015Ig\u000e];u!\tA\u0017.D\u0001\u0005\u0013\tQGAA\u0006J]R,'O\\1m%><\b\"\u00027\u0001\t\u0003j\u0017!\u00033p\u000f\u0016t7i\u001c3f)\rqG/\u001f\t\u0003_Jl\u0011\u0001\u001d\u0006\u0003c\n\tqaY8eK\u001e,g.\u0003\u0002ta\nAQ\t\u001f9s\u0007>$W\rC\u0003vW\u0002\u0007a/A\u0002dib\u0004\"a\\<\n\u0005a\u0004(AD\"pI\u0016<WM\\\"p]R,\u0007\u0010\u001e\u0005\u0006u.\u0004\rA\\\u0001\u0003KZDq\u0001 \u0001\u0002\u0002\u0013\u0005Q0\u0001\u0003d_BLHcA\u0018\u007f\u007f\"9\u0011e\u001fI\u0001\u0002\u0004\u0019\u0003bB\u0015|!\u0003\u0005\ra\t\u0005\n\u0003\u0007\u0001\u0011\u0013!C\u0001\u0003\u000b\tabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002\b)\u001a1%!\u0003,\u0005\u0005-\u0001\u0003BA\u0007\u0003/i!!a\u0004\u000b\t\u0005E\u00111C\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u0006\u001a\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u00033\tyAA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D\u0011\"!\b\u0001#\u0003%\t!!\u0002\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e!I\u0011\u0011\u0005\u0001\u0002\u0002\u0013\u0005\u00131E\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005\u0015\u0002\u0003BA\u0014\u0003ci!!!\u000b\u000b\t\u0005-\u0012QF\u0001\u0005Y\u0006twM\u0003\u0002\u00020\u0005!!.\u0019<b\u0013\rI\u0016\u0011\u0006\u0005\n\u0003k\u0001\u0011\u0011!C\u0001\u0003o\tA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!\u000f\u0011\u0007a\tY$C\u0002\u0002>e\u00111!\u00138u\u0011%\t\t\u0005AA\u0001\n\u0003\t\u0019%\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\u0007\t\f)\u0005\u0003\u0006\u0002H\u0005}\u0012\u0011!a\u0001\u0003s\t1\u0001\u001f\u00132\u0011%\tY\u0005AA\u0001\n\u0003\ni%A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\ty\u0005E\u0003\u0002R\u0005]#-\u0004\u0002\u0002T)\u0019\u0011QK\r\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002Z\u0005M#\u0001C%uKJ\fGo\u001c:\t\u0013\u0005u\u0003!!A\u0005\u0002\u0005}\u0013\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005\u0005\u0014q\r\t\u00041\u0005\r\u0014bAA33\t9!i\\8mK\u0006t\u0007\"CA$\u00037\n\t\u00111\u0001c\u0011%\tY\u0007AA\u0001\n\u0003\ni'\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003C\ny\u0007C\u0005\u0002H\u0005%\u0014\u0011!a\u0001E\"z\u0001!a\u001d\u0002z\u0005m\u0014qPAA\u0003\u000b\u000b9\tE\u0002\u0012\u0003kJ1!a\u001e\u0003\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!! \u0002\u0003;S\u0001\u0005\t\u0011!?\u001a+fjQ0)I\u0006$X\r\f\u0011g[RL\u0003%\f\u0011SKR,(O\\:!A\u0012\fG/\u001a1!o&$\b\u000e\t;iK\u0002\"\u0018.\\3!a>\u0014H/[8oA=4\u0007\u0005\u001e5fA\u0011\f\u0017\u0010\t;sk:\u001c\u0017\r^3eAQ|\u0007\u0005\u001e5fAUt\u0017\u000e\u001e\u0011ta\u0016\u001c\u0017NZ5fI\u0002\u0012\u0017\u0010\t;iK\u00022wN]7bi\u0002jw\u000eZ3mA\u00014W\u000e\u001e1/\u0015\u0001\u0002\u0003\u0005\t1g[R\u0004\u0007e\u001d5pk2$\u0007EY3!_:,\u0007e\u001c4!7\nJX-\u0019:#Y\u0001\u0012\u00130_=zE1\u0002#%_=#Y\u0001\u0012Sn\u001c8#Y\u0001\u0012Sn\u001c8uQ\nb\u0003EI7nEuS\u0001\u0005I\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u00111Q\u0001\u0002\u001c)\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~CsE\r\u00191s5\u0002$'L\u00193O1\u0002s%T'(SmR\u0001\u0005\t\u0011!A\u0001\u0002#\u0007\r\u0019:[A\u0012T\u0006M\u0019\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001d\u0012\u0004'M\u001b.cAj#gN\u0014-A\u001dJV)\u0011*(SmR\u0001\u0005\t\u0011!A\u0001\u0002#\u0007M\u00196[A\nT\u0006M\u0019\u000bA\u0001\nQa]5oG\u0016\f#!!#\u0002\u000bErSG\f\u0019\b\u0013\u00055%!!A\t\u0002\u0005=\u0015!\u0003+sk:\u001cG)\u0019;f!\r\t\u0012\u0011\u0013\u0004\t\u0003\t\t\t\u0011#\u0001\u0002\u0014N)\u0011\u0011SAK;A9\u0011qSAOG\rzSBAAM\u0015\r\tY*G\u0001\beVtG/[7f\u0013\u0011\ty*!'\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t'\u0007C\u0004.\u0003##\t!a)\u0015\u0005\u0005=\u0005BCAT\u0003#\u000b\t\u0011\"\u0012\u0002*\u0006AAo\\*ue&tw\r\u0006\u0002\u0002&!Q\u0011QVAI\u0003\u0003%\t)a,\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000b=\n\t,a-\t\r\u0005\nY\u000b1\u0001$\u0011\u0019I\u00131\u0016a\u0001G!Q\u0011qWAI\u0003\u0003%\t)!/\u0002\u000fUt\u0017\r\u001d9msR!\u00111XAd!\u0015A\u0012QXAa\u0013\r\ty,\u0007\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000ba\t\u0019mI\u0012\n\u0007\u0005\u0015\u0017D\u0001\u0004UkBdWM\r\u0005\n\u0003\u0013\f),!AA\u0002=\n1\u0001\u001f\u00131\u0011)\ti-!%\u0002\u0002\u0013%\u0011qZ\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002RB!\u0011qEAj\u0013\u0011\t).!\u000b\u0003\r=\u0013'.Z2u\u0001")
public class TruncDate
extends BinaryExpression
implements TruncInstant,
Serializable {
    private final Expression date;
    private final Expression format;
    private final Expression instant;
    private final int org$apache$spark$sql$catalyst$expressions$TruncInstant$$truncLevel;
    private volatile boolean bitmap$0;

    public static Option<Tuple2<Expression, Expression>> unapply(TruncDate truncDate) {
        return TruncDate$.MODULE$.unapply(truncDate);
    }

    public static Function1<Tuple2<Expression, Expression>, TruncDate> tupled() {
        return TruncDate$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, TruncDate>> curried() {
        return TruncDate$.MODULE$.curried();
    }

    private int org$apache$spark$sql$catalyst$expressions$TruncInstant$$truncLevel$lzycompute() {
        TruncDate truncDate = this;
        synchronized (truncDate) {
            if (!this.bitmap$0) {
                this.org$apache$spark$sql$catalyst$expressions$TruncInstant$$truncLevel = TruncInstant$class.org$apache$spark$sql$catalyst$expressions$TruncInstant$$truncLevel(this);
                this.bitmap$0 = true;
            }
            return this.org$apache$spark$sql$catalyst$expressions$TruncInstant$$truncLevel;
        }
    }

    @Override
    public int org$apache$spark$sql$catalyst$expressions$TruncInstant$$truncLevel() {
        return this.bitmap$0 ? this.org$apache$spark$sql$catalyst$expressions$TruncInstant$$truncLevel : this.org$apache$spark$sql$catalyst$expressions$TruncInstant$$truncLevel$lzycompute();
    }

    @Override
    public boolean nullable() {
        return TruncInstant$class.nullable(this);
    }

    @Override
    public Object evalHelper(InternalRow input, int maxLevel, Function2<Object, Object, Object> truncFunc) {
        return TruncInstant$class.evalHelper(this, input, maxLevel, truncFunc);
    }

    @Override
    public ExprCode codeGenHelper(CodegenContext ctx, ExprCode ev, int maxLevel, boolean orderReversed, Function2<String, String, String> truncFunc) {
        return TruncInstant$class.codeGenHelper(this, ctx, ev, maxLevel, orderReversed, truncFunc);
    }

    @Override
    public boolean codeGenHelper$default$4() {
        return TruncInstant$class.codeGenHelper$default$4(this);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes$class.checkInputDataTypes(this);
    }

    public Expression date() {
        return this.date;
    }

    @Override
    public Expression format() {
        return this.format;
    }

    @Override
    public Expression left() {
        return this.date();
    }

    @Override
    public Expression right() {
        return this.format();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AtomicType[]{DateType$.MODULE$, StringType$.MODULE$}));
    }

    @Override
    public DataType dataType() {
        return DateType$.MODULE$;
    }

    @Override
    public String prettyName() {
        return "trunc";
    }

    @Override
    public Expression instant() {
        return this.instant;
    }

    @Override
    public Object eval(InternalRow input) {
        return this.evalHelper(input, DateTimeUtils$.MODULE$.TRUNC_TO_MONTH(), (Function2<Object, Object, Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Object d, int level) {
                return DateTimeUtils$.MODULE$.truncDate(BoxesRunTime.unboxToInt((Object)d), level);
            }
        });
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.codeGenHelper(ctx, ev, DateTimeUtils$.MODULE$.TRUNC_TO_MONTH(), this.codeGenHelper$default$4(), (Function2<String, String, String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(String date, String fmt) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"truncDate(", ", ", ");"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{date, fmt}));
            }
        });
    }

    public TruncDate copy(Expression date, Expression format2) {
        return new TruncDate(date, format2);
    }

    public Expression copy$default$1() {
        return this.date();
    }

    public Expression copy$default$2() {
        return this.format();
    }

    @Override
    public String productPrefix() {
        return "TruncDate";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 1: {
                expression = this.format();
                break;
            }
            case 0: {
                expression = this.date();
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof TruncDate;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof TruncDate)) return false;
        boolean bl = true;
        if (!bl) return false;
        TruncDate truncDate = (TruncDate)x$1;
        Expression expression = this.date();
        Expression expression2 = truncDate.date();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.format();
        Expression expression4 = truncDate.format();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!truncDate.canEqual(this)) return false;
        return true;
    }

    public TruncDate(Expression date, Expression format2) {
        this.date = date;
        this.format = format2;
        ExpectsInputTypes$class.$init$(this);
        TruncInstant$class.$init$(this);
        this.instant = date;
    }
}

