/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.analysis;

import org.apache.spark.sql.catalyst.analysis.TimeWindowing$;
import org.apache.spark.sql.catalyst.analysis.package$;
import org.apache.spark.sql.catalyst.dsl.package$expressions$;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Alias$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.CaseWhen;
import org.apache.spark.sql.catalyst.expressions.Ceil;
import org.apache.spark.sql.catalyst.expressions.CreateNamedStruct;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.IsNotNull;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.PreciseTimestampConversion;
import org.apache.spark.sql.catalyst.expressions.Predicate;
import org.apache.spark.sql.catalyst.expressions.TimeWindow;
import org.apache.spark.sql.catalyst.plans.logical.Expand;
import org.apache.spark.sql.catalyst.plans.logical.Filter;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.rules.Rule;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;

public final class TimeWindowing$
extends Rule<LogicalPlan> {
    public static final TimeWindowing$ MODULE$;
    private final String WINDOW_COL_NAME;
    private final String WINDOW_START;
    private final String WINDOW_END;

    static {
        new TimeWindowing$();
    }

    private final String WINDOW_COL_NAME() {
        return "window";
    }

    private final String WINDOW_START() {
        return "start";
    }

    private final String WINDOW_END() {
        return "end";
    }

    @Override
    public LogicalPlan apply(LogicalPlan plan2) {
        return plan2.resolveOperatorsUp((PartialFunction<LogicalPlan, LogicalPlan>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x81, Function1<A1, B1> function1) {
                Object object;
                A1 A1;
                A1 A12 = x81;
                if (A12 != null && (A1 = A12).children().size() == 1) {
                    Object object2;
                    LogicalPlan child = (LogicalPlan)A1.children().head();
                    Set windowExpressions = ((TraversableOnce)A1.expressions().flatMap((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Seq<TimeWindow> apply(Expression x$155) {
                            return x$155.collect(new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final <A1 extends Expression, B1> B1 applyOrElse(A1 x82, Function1<A1, B1> function1) {
                                    Object object;
                                    A1 A1 = x82;
                                    if (A1 instanceof TimeWindow) {
                                        TimeWindow timeWindow = (TimeWindow)A1;
                                        object = timeWindow;
                                    } else {
                                        object = function1.apply(x82);
                                    }
                                    return (B1)object;
                                }

                                public final boolean isDefinedAt(Expression x82) {
                                    Expression expression = x82;
                                    boolean bl = expression instanceof TimeWindow;
                                    return bl;
                                }
                            });
                        }
                    }, Seq$.MODULE$.canBuildFrom())).toSet();
                    int numWindowExpr = windowExpressions.size();
                    if (numWindowExpr == 1 && ((TimeWindow)windowExpressions.head()).timeColumn().resolved() && ((TimeWindow)windowExpressions.head()).checkInputDataTypes().isSuccess()) {
                        Metadata metadata2;
                        TimeWindow window = (TimeWindow)windowExpressions.head();
                        Expression expression = window.timeColumn();
                        if (expression instanceof Attribute) {
                            Attribute attribute = (Attribute)expression;
                            metadata2 = attribute.metadata();
                        } else {
                            metadata2 = Metadata$.MODULE$.empty();
                        }
                        Metadata metadata3 = metadata2;
                        String x$406 = "window";
                        DataType x$407 = window.dataType();
                        Metadata x$408 = metadata3;
                        boolean x$409 = AttributeReference$.MODULE$.apply$default$3();
                        ExprId x$410 = AttributeReference$.MODULE$.apply$default$5(x$406, x$407, x$409, x$408);
                        Seq<String> x$411 = AttributeReference$.MODULE$.apply$default$6(x$406, x$407, x$409, x$408);
                        AttributeReference windowAttr = new AttributeReference(x$406, x$407, x$409, x$408, x$410, x$411);
                        if (window.windowDuration() == window.slideDuration()) {
                            Expression x$412 = this.org$apache$spark$sql$catalyst$analysis$TimeWindowing$$anonfun$$getWindow$1(0, 1, window);
                            String x$413 = "window";
                            ExprId x$414 = windowAttr.exprId();
                            Some x$415 = new Some((Object)metadata3);
                            Seq<String> x$416 = Alias$.MODULE$.apply$default$4(x$412, x$413);
                            Alias windowStruct = new Alias(x$412, x$413, x$414, x$416, (Option<Metadata>)x$415);
                            LogicalPlan replacedPlan = (LogicalPlan)A1.transformExpressions((PartialFunction<Expression, Expression>)new Serializable(this, windowAttr){
                                public static final long serialVersionUID = 0L;
                                private final AttributeReference windowAttr$1;

                                public final <A1 extends Expression, B1> B1 applyOrElse(A1 x83, Function1<A1, B1> function1) {
                                    A1 A1 = x83;
                                    Object object = A1 instanceof TimeWindow ? this.windowAttr$1 : function1.apply(x83);
                                    return (B1)object;
                                }

                                public final boolean isDefinedAt(Expression x83) {
                                    Expression expression = x83;
                                    boolean bl = expression instanceof TimeWindow;
                                    return bl;
                                }
                                {
                                    this.windowAttr$1 = windowAttr$1;
                                }
                            });
                            IsNotNull filterExpr = new IsNotNull(window.timeColumn());
                            Alias alias = windowStruct;
                            Filter filter2 = new Filter(filterExpr, new Project((Seq<NamedExpression>)((Seq)child.output().$plus$colon((Object)alias, Seq$.MODULE$.canBuildFrom())), child));
                            object2 = replacedPlan.withNewChildren(Nil$.MODULE$.$colon$colon((Object)filter2));
                        } else {
                            int overlappingWindows = (int)scala.math.package$.MODULE$.ceil((double)window.windowDuration() * 1.0 / (double)window.slideDuration());
                            Seq windows = (Seq)Seq$.MODULE$.tabulate(overlappingWindows, (Function1)new Serializable(this, window, overlappingWindows){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun.apply.43 $outer;
                                private final TimeWindow window$1;
                                private final int overlappingWindows$1;

                                public final Expression apply(int i) {
                                    return this.$outer.org$apache$spark$sql$catalyst$analysis$TimeWindowing$$anonfun$$getWindow$1(i, this.overlappingWindows$1, this.window$1);
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.window$1 = window$1;
                                    this.overlappingWindows$1 = overlappingWindows$1;
                                }
                            });
                            Seq projections = (Seq)windows.map((Function1)new Serializable(this, child){
                                public static final long serialVersionUID = 0L;
                                private final LogicalPlan child$10;

                                public final Seq<Expression> apply(Expression x$162) {
                                    Expression expression = x$162;
                                    return (Seq)this.child$10.output().$plus$colon((Object)expression, Seq$.MODULE$.canBuildFrom());
                                }
                                {
                                    this.child$10 = child$10;
                                }
                            }, Seq$.MODULE$.canBuildFrom());
                            Predicate filterExpr = package$expressions$.MODULE$.DslExpression((Expression)((Object)package$expressions$.MODULE$.DslExpression(window.timeColumn()).$greater$eq(package$expressions$.MODULE$.DslExpression(windowAttr).getField("start")))).$amp$amp((Expression)((Object)package$expressions$.MODULE$.DslExpression(window.timeColumn()).$less(package$expressions$.MODULE$.DslExpression(windowAttr).getField("end"))));
                            AttributeReference attributeReference = windowAttr;
                            Filter substitutedPlan = new Filter((Expression)((Object)filterExpr), new Expand((Seq<Seq<Expression>>)projections, (Seq<Attribute>)((Seq)child.output().$plus$colon((Object)attributeReference, Seq$.MODULE$.canBuildFrom())), child));
                            LogicalPlan renamedPlan = (LogicalPlan)A1.transformExpressions((PartialFunction<Expression, Expression>)new Serializable(this, windowAttr){
                                public static final long serialVersionUID = 0L;
                                private final AttributeReference windowAttr$1;

                                public final <A1 extends Expression, B1> B1 applyOrElse(A1 x84, Function1<A1, B1> function1) {
                                    A1 A1 = x84;
                                    Object object = A1 instanceof TimeWindow ? this.windowAttr$1 : function1.apply(x84);
                                    return (B1)object;
                                }

                                public final boolean isDefinedAt(Expression x84) {
                                    Expression expression = x84;
                                    boolean bl = expression instanceof TimeWindow;
                                    return bl;
                                }
                                {
                                    this.windowAttr$1 = windowAttr$1;
                                }
                            });
                            Filter filter3 = substitutedPlan;
                            object2 = renamedPlan.withNewChildren(Nil$.MODULE$.$colon$colon((Object)filter3));
                        }
                    } else {
                        if (numWindowExpr > 1) {
                            throw package$.MODULE$.AnalysisErrorAt(A1).failAnalysis("Multiple time window expressions would result in a cartesian product of rows, therefore they are currently not supported.");
                        }
                        object2 = A1;
                    }
                    object = object2;
                } else {
                    object = function1.apply(x81);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(LogicalPlan x81) {
                LogicalPlan logicalPlan;
                LogicalPlan logicalPlan2 = x81;
                boolean bl = logicalPlan2 != null && (logicalPlan = logicalPlan2).children().size() == 1;
                return bl;
            }

            public final Expression org$apache$spark$sql$catalyst$analysis$TimeWindowing$$anonfun$$getWindow$1(int i, int overlappingWindows, TimeWindow window$1) {
                Expression division = package$expressions$.MODULE$.DslExpression(package$expressions$.MODULE$.DslExpression(new PreciseTimestampConversion(window$1.timeColumn(), TimestampType$.MODULE$, LongType$.MODULE$)).$minus(package$expressions$.MODULE$.longToLiteral(window$1.startTime()))).$div(package$expressions$.MODULE$.longToLiteral(window$1.slideDuration()));
                Ceil ceil = new Ceil(division);
                CaseWhen windowId = new CaseWhen((Seq<Tuple2<Expression, Expression>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)package$expressions$.MODULE$.DslExpression(ceil).$eq$eq$eq(division), (Object)package$expressions$.MODULE$.DslExpression(ceil).$plus(package$expressions$.MODULE$.intToLiteral(1)))}))), (Option<Expression>)new Some((Object)ceil));
                Expression windowStart = package$expressions$.MODULE$.DslExpression(package$expressions$.MODULE$.DslExpression(package$expressions$.MODULE$.DslExpression(package$expressions$.MODULE$.DslExpression(windowId).$plus(package$expressions$.MODULE$.intToLiteral(i))).$minus(package$expressions$.MODULE$.intToLiteral(overlappingWindows))).$times(package$expressions$.MODULE$.longToLiteral(window$1.slideDuration()))).$plus(package$expressions$.MODULE$.longToLiteral(window$1.startTime()));
                Expression windowEnd = package$expressions$.MODULE$.DslExpression(windowStart).$plus(package$expressions$.MODULE$.longToLiteral(window$1.windowDuration()));
                Literal literal = Literal$.MODULE$.apply("start");
                PreciseTimestampConversion preciseTimestampConversion = new PreciseTimestampConversion(windowStart, LongType$.MODULE$, TimestampType$.MODULE$);
                Literal literal2 = Literal$.MODULE$.apply("end");
                PreciseTimestampConversion preciseTimestampConversion2 = new PreciseTimestampConversion(windowEnd, LongType$.MODULE$, TimestampType$.MODULE$);
                return new CreateNamedStruct((Seq<Expression>)Nil$.MODULE$.$colon$colon((Object)preciseTimestampConversion2).$colon$colon((Object)literal2).$colon$colon((Object)preciseTimestampConversion).$colon$colon((Object)literal));
            }
        });
    }

    private TimeWindowing$() {
        MODULE$ = this;
    }
}

