/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.BinaryComparison;
import org.apache.spark.sql.catalyst.expressions.EqualNullSafe$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprValue$;
import org.apache.spark.sql.catalyst.expressions.codegen.FalseLiteral$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    expr1 _FUNC_ expr2 - Returns same result as the EQUAL(=) operator for non-null operands,\n      but returns true if both are null, false if one of the them is null.\n  ", arguments="\n    Arguments:\n      * expr1, expr2 - the two expressions must be same type or can be casted to a common type,\n          and must be a type that can be used in equality comparison. Map type is not supported.\n          For complex types such array/struct, the data types of fields must be orderable.\n  ", examples="\n    Examples:\n      > SELECT 2 _FUNC_ 2;\n       true\n      > SELECT 1 _FUNC_ '1';\n       true\n      > SELECT true _FUNC_ NULL;\n       false\n      > SELECT NULL _FUNC_ NULL;\n       true\n  ")
@ScalaSignature(bytes="\u0006\u0001\u0005Ee\u0001B\u0001\u0003\u0001>\u0011Q\"R9vC2tU\u000f\u001c7TC\u001a,'BA\u0002\u0005\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005\u00151\u0011\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005\u001dA\u0011aA:rY*\u0011\u0011BC\u0001\u0006gB\f'o\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001\u0001BC\u0007\t\u0003#Ii\u0011AA\u0005\u0003'\t\u0011\u0001CQ5oCJL8i\\7qCJL7o\u001c8\u0011\u0005UAR\"\u0001\f\u000b\u0003]\tQa]2bY\u0006L!!\u0007\f\u0003\u000fA\u0013x\u000eZ;diB\u0011QcG\u0005\u00039Y\u0011AbU3sS\u0006d\u0017N_1cY\u0016D\u0001B\b\u0001\u0003\u0016\u0004%\taH\u0001\u0005Y\u00164G/F\u0001!!\t\t\u0012%\u0003\u0002#\u0005\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\t\u0011\u0011\u0002!\u0011#Q\u0001\n\u0001\nQ\u0001\\3gi\u0002B\u0001B\n\u0001\u0003\u0016\u0004%\taH\u0001\u0006e&<\u0007\u000e\u001e\u0005\tQ\u0001\u0011\t\u0012)A\u0005A\u00051!/[4ii\u0002BQA\u000b\u0001\u0005\u0002-\na\u0001P5oSRtDc\u0001\u0017.]A\u0011\u0011\u0003\u0001\u0005\u0006=%\u0002\r\u0001\t\u0005\u0006M%\u0002\r\u0001\t\u0005\u0006a\u0001!\t%M\u0001\u0007gfl'm\u001c7\u0016\u0003I\u0002\"a\r\u001c\u000f\u0005U!\u0014BA\u001b\u0017\u0003\u0019\u0001&/\u001a3fM&\u0011q\u0007\u000f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005U2\u0002\"\u0002\u001e\u0001\t\u0003Z\u0014\u0001\u00038vY2\f'\r\\3\u0016\u0003q\u0002\"!F\u001f\n\u0005y2\"a\u0002\"p_2,\u0017M\u001c\u0005\u0006\u0001\u0002!\t%Q\u0001\u0005KZ\fG\u000e\u0006\u0002C\u000bB\u0011QcQ\u0005\u0003\tZ\u00111!\u00118z\u0011\u001d1u\b%AA\u0002\u001d\u000bQ!\u001b8qkR\u0004\"\u0001S%\u000e\u0003\u0011I!A\u0013\u0003\u0003\u0017%sG/\u001a:oC2\u0014vn\u001e\u0005\u0006\u0019\u0002!\t%T\u0001\nI><UM\\\"pI\u0016$2A\u0014+Z!\ty%+D\u0001Q\u0015\t\t&!A\u0004d_\u0012,w-\u001a8\n\u0005M\u0003&\u0001C#yaJ\u001cu\u000eZ3\t\u000bU[\u0005\u0019\u0001,\u0002\u0007\r$\b\u0010\u0005\u0002P/&\u0011\u0001\f\u0015\u0002\u000f\u0007>$WmZ3o\u0007>tG/\u001a=u\u0011\u0015Q6\n1\u0001O\u0003\t)g\u000fC\u0004]\u0001\u0005\u0005I\u0011A/\u0002\t\r|\u0007/\u001f\u000b\u0004Yy{\u0006b\u0002\u0010\\!\u0003\u0005\r\u0001\t\u0005\bMm\u0003\n\u00111\u0001!\u0011\u001d\t\u0007!%A\u0005\u0002\t\fabY8qs\u0012\"WMZ1vYR$\u0013'F\u0001dU\t\u0001CmK\u0001f!\t17.D\u0001h\u0015\tA\u0017.A\u0005v]\u000eDWmY6fI*\u0011!NF\u0001\u000bC:tw\u000e^1uS>t\u0017B\u00017h\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\b]\u0002\t\n\u0011\"\u0001c\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIIBq\u0001\u001d\u0001\u0002\u0002\u0013\u0005\u0013/A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0002eB\u00111\u000f_\u0007\u0002i*\u0011QO^\u0001\u0005Y\u0006twMC\u0001x\u0003\u0011Q\u0017M^1\n\u0005]\"\bb\u0002>\u0001\u0003\u0003%\ta_\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0002yB\u0011Q#`\u0005\u0003}Z\u00111!\u00138u\u0011%\t\t\u0001AA\u0001\n\u0003\t\u0019!\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\u0007\t\u000b)\u0001\u0003\u0005\u0002\b}\f\t\u00111\u0001}\u0003\rAH%\r\u0005\n\u0003\u0017\u0001\u0011\u0011!C!\u0003\u001b\tq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003\u001f\u0001R!!\u0005\u0002\u0018\tk!!a\u0005\u000b\u0007\u0005Ua#\u0001\u0006d_2dWm\u0019;j_:LA!!\u0007\u0002\u0014\tA\u0011\n^3sCR|'\u000fC\u0005\u0002\u001e\u0001\t\t\u0011\"\u0001\u0002 \u0005A1-\u00198FcV\fG\u000eF\u0002=\u0003CA\u0011\"a\u0002\u0002\u001c\u0005\u0005\t\u0019\u0001\"\t\u0013\u0005\u0015\u0002!!A\u0005B\u0005\u001d\u0012AB3rk\u0006d7\u000fF\u0002=\u0003SA\u0011\"a\u0002\u0002$\u0005\u0005\t\u0019\u0001\")\u001f\u0001\ti#a\r\u00026\u0005e\u00121HA \u0003\u0003\u00022!EA\u0018\u0013\r\t\tD\u0001\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\t9$AA,\u0015\u0001\u0002\u0003\u0005I3yaJ\f\u0004e\u0018$V\u001d\u000e{\u0006%\u001a=qeJ\u0002S\u0006\t*fiV\u0014hn\u001d\u0011tC6,\u0007E]3tk2$\b%Y:!i\",\u0007%R)V\u00032CS(\u000b\u0011pa\u0016\u0014\u0018\r^8sA\u0019|'\u000f\t8p]6rW\u000f\u001c7!_B,'/\u00198eg2R\u0001\u0005\t\u0011!A\u0001\u0012W\u000f\u001e\u0011sKR,(O\\:!iJ,X\rI5gA\t|G\u000f\u001b\u0011be\u0016\u0004c.\u001e7mY\u00012\u0017\r\\:fA%4\u0007e\u001c8fA=4\u0007\u0005\u001e5fAQDW-\u001c\u0011jg\u0002rW\u000f\u001c7/\u0015\u0001\u0002\u0013!C1sOVlWM\u001c;tC\t\ti$\u0001B/\u0015\u0001\u0002\u0003\u0005I!sOVlWM\u001c;tu)\u0001\u0003\u0005\t\u0011!A)\u0002S\r\u001f9sc1\u0002S\r\u001f9se\u0001j\u0003\u0005\u001e5fAQ<x\u000eI3yaJ,7o]5p]N\u0004S.^:uA\t,\u0007e]1nK\u0002\"\u0018\u0010]3!_J\u00043-\u00198!E\u0016\u00043-Y:uK\u0012\u0004Co\u001c\u0011bA\r|W.\\8oAQL\b/\u001a\u0017\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0013M\u001c3![V\u001cH\u000f\t2fA\u0005\u0004C/\u001f9fAQD\u0017\r\u001e\u0011dC:\u0004#-\u001a\u0011vg\u0016$\u0007%\u001b8!KF,\u0018\r\\5us\u0002\u001aw.\u001c9be&\u001cxN\u001c\u0018!\u001b\u0006\u0004\b\u0005^=qK\u0002J7\u000f\t8pi\u0002\u001aX\u000f\u001d9peR,GM\f\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u00012uN\u001d\u0011d_6\u0004H.\u001a=!if\u0004Xm\u001d\u0011tk\u000eD\u0007%\u0019:sCf|3\u000f\u001e:vGRd\u0003\u0005\u001e5fA\u0011\fG/\u0019\u0011usB,7\u000fI8gA\u0019LW\r\u001c3tA5,8\u000f\u001e\u0011cK\u0002z'\u000fZ3sC\ndWM\f\u0006!A\u0005AQ\r_1na2,7/\t\u0002\u0002D\u0005\tIH\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u00113A}3UKT\"`AIZ$\u0002\t\u0011!A\u0001\u0002\u0003\u0005\u001e:vK*\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003\u0013\u0007I0G+:\u001bu\fI\u00142OmR\u0001\u0005\t\u0011!A\u0001\u0002CO];f\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002\"(/^3!?\u001a+fjQ0!\u001dVcEj\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011gC2\u001cXM\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011O+2c\u0005e\u0018$V\u001d\u000e{\u0006ET+M\u0019nR\u0001\u0005\t\u0011!A\u0001\u0002CO];f\u0015\u0001\u0002s!CA$\u0005\u0005\u0005\t\u0012AA%\u00035)\u0015/^1m\u001dVdGnU1gKB\u0019\u0011#a\u0013\u0007\u0011\u0005\u0011\u0011\u0011!E\u0001\u0003\u001b\u001aR!a\u0013\u0002Pi\u0001r!!\u0015\u0002X\u0001\u0002C&\u0004\u0002\u0002T)\u0019\u0011Q\u000b\f\u0002\u000fI,h\u000e^5nK&!\u0011\u0011LA*\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\u0005\bU\u0005-C\u0011AA/)\t\tI\u0005\u0003\u0006\u0002b\u0005-\u0013\u0011!C#\u0003G\n\u0001\u0002^8TiJLgn\u001a\u000b\u0002e\"Q\u0011qMA&\u0003\u0003%\t)!\u001b\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000b1\nY'!\u001c\t\ry\t)\u00071\u0001!\u0011\u00191\u0013Q\ra\u0001A!Q\u0011\u0011OA&\u0003\u0003%\t)a\u001d\u0002\u000fUt\u0017\r\u001d9msR!\u0011QOAA!\u0015)\u0012qOA>\u0013\r\tIH\u0006\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000bU\ti\b\t\u0011\n\u0007\u0005}dC\u0001\u0004UkBdWM\r\u0005\n\u0003\u0007\u000by'!AA\u00021\n1\u0001\u001f\u00131\u0011)\t9)a\u0013\u0002\u0002\u0013%\u0011\u0011R\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002\fB\u00191/!$\n\u0007\u0005=EO\u0001\u0004PE*,7\r\u001e")
public class EqualNullSafe
extends BinaryComparison
implements Serializable {
    private final Expression left;
    private final Expression right;

    public static Option<Tuple2<Expression, Expression>> unapply(EqualNullSafe equalNullSafe) {
        return EqualNullSafe$.MODULE$.unapply(equalNullSafe);
    }

    public static Function1<Tuple2<Expression, Expression>, EqualNullSafe> tupled() {
        return EqualNullSafe$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, EqualNullSafe>> curried() {
        return EqualNullSafe$.MODULE$.curried();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public String symbol() {
        return "<=>";
    }

    @Override
    public boolean nullable() {
        return false;
    }

    @Override
    public Object eval(InternalRow input) {
        Object input1 = this.left().eval(input);
        Object input2 = this.right().eval(input);
        return input1 == null && input2 == null ? BoxesRunTime.boxToBoolean((boolean)true) : (input1 == null || input2 == null ? BoxesRunTime.boxToBoolean((boolean)false) : BoxesRunTime.boxToBoolean((boolean)this.ordering().equiv(input1, input2)));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode eval1 = this.left().genCode(ctx);
        ExprCode eval2 = this.right().genCode(ctx);
        String equalCode = ctx.genEqual(this.left().dataType(), ExprValue$.MODULE$.exprValueToString(eval1.value()), ExprValue$.MODULE$.exprValueToString(eval2.value()));
        return ev.copy(eval1.code().$plus(eval2.code()).$plus(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        boolean ", " = (", " && ", ") ||\n           (!", " && !", " && ", ");"}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.value(), eval1.isNull(), eval2.isNull(), eval1.isNull(), eval2.isNull(), equalCode}))), FalseLiteral$.MODULE$, ev.copy$default$3());
    }

    public EqualNullSafe copy(Expression left, Expression right) {
        return new EqualNullSafe(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "EqualNullSafe";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 1: {
                expression = this.right();
                break;
            }
            case 0: {
                expression = this.left();
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof EqualNullSafe;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof EqualNullSafe)) return false;
        boolean bl = true;
        if (!bl) return false;
        EqualNullSafe equalNullSafe = (EqualNullSafe)x$1;
        Expression expression = this.left();
        Expression expression2 = equalNullSafe.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = equalNullSafe.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!equalNullSafe.canEqual(this)) return false;
        return true;
    }

    public EqualNullSafe(Expression left, Expression right) {
        this.left = left;
        this.right = right;
    }
}

