/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Sequence;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.unsafe.array.ByteArrayMethods;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.math.Integral;
import scala.runtime.BoxesRunTime;

public final class Sequence$
implements Serializable {
    public static final Sequence$ MODULE$;

    static {
        new Sequence$();
    }

    public <U> int org$apache$spark$sql$catalyst$expressions$Sequence$$getSequenceLength(U start, U stop, U step, Integral<U> num) {
        Predef$.MODULE$.require(num.mkOrderingOps(step).$greater(num.zero()) && num.mkOrderingOps(start).$less$eq(stop) || num.mkOrderingOps(step).$less(num.zero()) && num.mkOrderingOps(start).$greater$eq(stop) || BoxesRunTime.equals(step, (Object)num.zero()) && BoxesRunTime.equals(start, stop), (Function0)new Serializable(start, stop, step){
            public static final long serialVersionUID = 0L;
            private final Object start$1;
            private final Object stop$1;
            private final Object step$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Illegal sequence boundaries: ", " to ", " by ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.start$1, this.stop$1, this.step$1}));
            }
            {
                this.start$1 = start$1;
                this.stop$1 = stop$1;
                this.step$1 = step$1;
            }
        });
        long len = BoxesRunTime.equals(start, stop) ? 1L : 1L + (num.mkNumericOps(stop).toLong() - num.mkNumericOps(start).toLong()) / num.mkNumericOps(step).toLong();
        Predef$.MODULE$.require(len <= (long)ByteArrayMethods.MAX_ROUNDED_ARRAY_LENGTH, (Function0)new Serializable(len){
            public static final long serialVersionUID = 0L;
            private final long len$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Too long sequence: ", ". Should be <= ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.len$1), BoxesRunTime.boxToInteger((int)ByteArrayMethods.MAX_ROUNDED_ARRAY_LENGTH)}));
            }
            {
                this.len$1 = len$1;
            }
        });
        return (int)len;
    }

    public String org$apache$spark$sql$catalyst$expressions$Sequence$$genSequenceLengthCode(CodegenContext ctx, String start, String stop, String step, String len) {
        String longLen = ctx.freshName("longLen");
        return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n       |if (!((", " > 0 && ", " <= ", ") ||\n       |  (", " < 0 && ", " >= ", ") ||\n       |  (", " == 0 && ", " == ", "))) {\n       |  throw new IllegalArgumentException(\n       |    \"Illegal sequence boundaries: \" + ", " + \" to \" + ", " + \" by \" + ", ");\n       |}\n       |long ", " = ", " == ", " ? 1L : 1L + ((long) ", " - ", ") / ", ";\n       |if (", " > ", ") {\n       |  throw new IllegalArgumentException(\n       |    \"Too long sequence: \" + ", " + \". Should be <= ", "\");\n       |}\n       |int ", " = (int) ", ";\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{step, start, stop, step, start, stop, step, start, stop, start, stop, step, longLen, stop, start, stop, start, step, longLen, BoxesRunTime.boxToInteger((int)ByteArrayMethods.MAX_ROUNDED_ARRAY_LENGTH), longLen, BoxesRunTime.boxToInteger((int)ByteArrayMethods.MAX_ROUNDED_ARRAY_LENGTH), len, longLen})))).stripMargin();
    }

    public Sequence apply(Expression start, Expression stop, Option<Expression> stepOpt, Option<String> timeZoneId) {
        return new Sequence(start, stop, stepOpt, timeZoneId);
    }

    public Option<Tuple4<Expression, Expression, Option<Expression>, Option<String>>> unapply(Sequence x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple4((Object)x$0.start(), (Object)x$0.stop(), x$0.stepOpt(), x$0.timeZoneId()));
    }

    public Option<String> $lessinit$greater$default$4() {
        return None$.MODULE$;
    }

    public Option<String> apply$default$4() {
        return None$.MODULE$;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private Sequence$() {
        MODULE$ = this;
    }
}

