/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes$class;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.String2TrimExpression;
import org.apache.spark.sql.catalyst.expressions.String2TrimExpression$class;
import org.apache.spark.sql.catalyst.expressions.StringTrim$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(str) - Removes the leading and trailing space characters from `str`.\n\n    _FUNC_(BOTH trimStr FROM str) - Remove the leading and trailing `trimStr` characters from `str`\n\n    _FUNC_(LEADING trimStr FROM str) - Remove the leading `trimStr` characters from `str`\n\n    _FUNC_(TRAILING trimStr FROM str) - Remove the trailing `trimStr` characters from `str`\n  ", arguments="\n    Arguments:\n      * str - a string expression\n      * trimStr - the trim string characters to trim, the default value is a single space\n      * BOTH, FROM - these are keywords to specify trimming string characters from both ends of\n          the string\n      * LEADING, FROM - these are keywords to specify trimming string characters from the left\n          end of the string\n      * TRAILING, FROM - these are keywords to specify trimming string characters from the right\n          end of the string\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('    SparkSQL   ');\n       SparkSQL\n      > SELECT _FUNC_('SL', 'SSparkSQLS');\n       parkSQ\n      > SELECT _FUNC_(BOTH 'SL' FROM 'SSparkSQLS');\n       parkSQ\n      > SELECT _FUNC_(LEADING 'SL' FROM 'SSparkSQLS');\n       parkSQLS\n      > SELECT _FUNC_(TRAILING 'SL' FROM 'SSparkSQLS');\n       SSparkSQ\n  ")
@ScalaSignature(bytes="\u0006\u0001\u0005-w!B\u0001\u0003\u0011\u0003y\u0011AC*ue&tw\r\u0016:j[*\u00111\u0001B\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002\u0006\r\u0005A1-\u0019;bYf\u001cHO\u0003\u0002\b\u0011\u0005\u00191/\u001d7\u000b\u0005%Q\u0011!B:qCJ\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c\u0001\u0001\u0005\u0002\u0011#5\t!AB\u0003\u0013\u0005!\u00051C\u0001\u0006TiJLgn\u001a+sS6\u001c2!\u0005\u000b\u001b!\t)\u0002$D\u0001\u0017\u0015\u00059\u0012!B:dC2\f\u0017BA\r\u0017\u0005\u0019\te.\u001f*fMB\u0011QcG\u0005\u00039Y\u0011AbU3sS\u0006d\u0017N_1cY\u0016DQAH\t\u0005\u0002}\ta\u0001P5oSRtD#A\b\t\u000b\u0005\nB\u0011\u0001\u0012\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000b\r\n\t*!&\u0011\u0005A!c\u0001\u0002\n\u0003\u0001\u0016\u001aR\u0001\n\u0014*Yi\u0001\"\u0001E\u0014\n\u0005!\u0012!AC#yaJ,7o]5p]B\u0011\u0001CK\u0005\u0003W\t\u0011Qc\u0015;sS:<'\u0007\u0016:j[\u0016C\bO]3tg&|g\u000e\u0005\u0002\u0016[%\u0011aF\u0006\u0002\b!J|G-^2u\u0011!\u0001DE!f\u0001\n\u0003\t\u0014AB:sGN#(/F\u0001'\u0011!\u0019DE!E!\u0002\u00131\u0013aB:sGN#(\u000f\t\u0005\tk\u0011\u0012)\u001a!C\u0001m\u00059AO]5n'R\u0014X#A\u001c\u0011\u0007UAd%\u0003\u0002:-\t1q\n\u001d;j_:D\u0001b\u000f\u0013\u0003\u0012\u0003\u0006IaN\u0001\tiJLWn\u0015;sA!)a\u0004\nC\u0001{Q\u00191EP \t\u000bAb\u0004\u0019\u0001\u0014\t\u000fUb\u0004\u0013!a\u0001o!)a\u0004\nC\u0001\u0003R\u00191EQ\"\t\u000bU\u0002\u0005\u0019\u0001\u0014\t\u000bA\u0002\u0005\u0019\u0001\u0014\t\u000by!C\u0011A#\u0015\u0005\r2\u0005\"\u0002\u0019E\u0001\u00041\u0003\"\u0002%%\t\u0003J\u0015A\u00039sKR$\u0018PT1nKV\t!\n\u0005\u0002L\u001d:\u0011Q\u0003T\u0005\u0003\u001bZ\ta\u0001\u0015:fI\u00164\u0017BA(Q\u0005\u0019\u0019FO]5oO*\u0011QJ\u0006\u0005\u0006%\u0012\"\teU\u0001\tG\"LG\u000e\u001a:f]V\tA\u000bE\u0002V;\u001ar!AV.\u000f\u0005]SV\"\u0001-\u000b\u0005es\u0011A\u0002\u001fs_>$h(C\u0001\u0018\u0013\taf#A\u0004qC\u000e\\\u0017mZ3\n\u0005y{&aA*fc*\u0011AL\u0006\u0005\u0006C\u0012\"\tEY\u0001\u0005KZ\fG\u000e\u0006\u0002dMB\u0011Q\u0003Z\u0005\u0003KZ\u00111!\u00118z\u0011\u001d9\u0007\r%AA\u0002!\fQ!\u001b8qkR\u0004\"!\u001b6\u000e\u0003\u0011I!a\u001b\u0003\u0003\u0017%sG/\u001a:oC2\u0014vn\u001e\u0005\u0006[\u0012\"\tE\\\u0001\nI><UM\\\"pI\u0016$2a\\;{!\t\u00018/D\u0001r\u0015\t\u0011(!A\u0004d_\u0012,w-\u001a8\n\u0005Q\f(\u0001C#yaJ\u001cu\u000eZ3\t\u000bYd\u0007\u0019A<\u0002\u0007\r$\b\u0010\u0005\u0002qq&\u0011\u00110\u001d\u0002\u000f\u0007>$WmZ3o\u0007>tG/\u001a=u\u0011\u0015YH\u000e1\u0001p\u0003\t)g\u000fC\u0004~I\u0005\u0005I\u0011\u0001@\u0002\t\r|\u0007/\u001f\u000b\u0005G}\f\t\u0001C\u00041yB\u0005\t\u0019\u0001\u0014\t\u000fUb\b\u0013!a\u0001o!I\u0011Q\u0001\u0013\u0012\u0002\u0013\u0005\u0011qA\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tIAK\u0002'\u0003\u0017Y#!!\u0004\u0011\t\u0005=\u0011\u0011D\u0007\u0003\u0003#QA!a\u0005\u0002\u0016\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003/1\u0012AC1o]>$\u0018\r^5p]&!\u00111DA\t\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\n\u0003?!\u0013\u0013!C\u0001\u0003C\tabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0002$)\u001aq'a\u0003\t\u0013\u0005\u001dB%!A\u0005B\u0005%\u0012!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002,A!\u0011QFA\u001c\u001b\t\tyC\u0003\u0003\u00022\u0005M\u0012\u0001\u00027b]\u001eT!!!\u000e\u0002\t)\fg/Y\u0005\u0004\u001f\u0006=\u0002\"CA\u001eI\u0005\u0005I\u0011AA\u001f\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\ty\u0004E\u0002\u0016\u0003\u0003J1!a\u0011\u0017\u0005\rIe\u000e\u001e\u0005\n\u0003\u000f\"\u0013\u0011!C\u0001\u0003\u0013\na\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000fF\u0002d\u0003\u0017B!\"!\u0014\u0002F\u0005\u0005\t\u0019AA \u0003\rAH%\r\u0005\n\u0003#\"\u0013\u0011!C!\u0003'\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003+\u0002R!a\u0016\u0002^\rl!!!\u0017\u000b\u0007\u0005mc#\u0001\u0006d_2dWm\u0019;j_:LA!a\u0018\u0002Z\tA\u0011\n^3sCR|'\u000fC\u0005\u0002d\u0011\n\t\u0011\"\u0001\u0002f\u0005A1-\u00198FcV\fG\u000e\u0006\u0003\u0002h\u00055\u0004cA\u000b\u0002j%\u0019\u00111\u000e\f\u0003\u000f\t{w\u000e\\3b]\"I\u0011QJA1\u0003\u0003\u0005\ra\u0019\u0005\n\u0003c\"\u0013\u0011!C!\u0003g\na!Z9vC2\u001cH\u0003BA4\u0003kB\u0011\"!\u0014\u0002p\u0005\u0005\t\u0019A2)\u001f\u0011\nI(a \u0002\u0002\u0006\u0015\u0015qQAF\u0003\u001b\u00032\u0001EA>\u0013\r\tiH\u0001\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\t\u0019)\u0001Bq\u0015\u0001\u0002\u0003\u0005I0G+:\u001bu\fK:ue&\u0002S\u0006\t*f[>4Xm\u001d\u0011uQ\u0016\u0004C.Z1eS:<\u0007%\u00198eAQ\u0014\u0018-\u001b7j]\u001e\u00043\u000f]1dK\u0002\u001a\u0007.\u0019:bGR,'o\u001d\u0011ge>l\u0007\u0005Y:ue\u0002t#B\u0003\u0011!A\u0001zf)\u0016(D?\"\u0012u\n\u0016%!iJLWn\u0015;sA\u0019\u0013v*\u0014\u0011tiJL\u0003%\f\u0011SK6|g/\u001a\u0011uQ\u0016\u0004C.Z1eS:<\u0007%\u00198eAQ\u0014\u0018-\u001b7j]\u001e\u0004\u0003\r\u001e:j[N#(\u000f\u0019\u0011dQ\u0006\u0014\u0018m\u0019;feN\u0004cM]8nA\u0001\u001cHO\u001d1\u000b\u0015\u0001\u0002\u0003\u0005I0G+:\u001bu\f\u000b'F\u0003\u0012Kej\u0012\u0011ue&l7\u000b\u001e:!\rJ{U\nI:ue&\u0002S\u0006\t*f[>4X\r\t;iK\u0002bW-\u00193j]\u001e\u0004\u0003\r\u001e:j[N#(\u000f\u0019\u0011dQ\u0006\u0014\u0018m\u0019;feN\u0004cM]8nA\u0001\u001cHO\u001d1\u000b\u0015\u0001\u0002\u0003\u0005I0G+:\u001bu\f\u000b+S\u0003&c\u0015JT$!iJLWn\u0015;sA\u0019\u0013v*\u0014\u0011tiJL\u0003%\f\u0011SK6|g/\u001a\u0011uQ\u0016\u0004CO]1jY&tw\r\t1ue&l7\u000b\u001e:aA\rD\u0017M]1di\u0016\u00148\u000f\t4s_6\u0004\u0003m\u001d;sA*\u0001\u0003%A\u0005be\u001e,X.\u001a8ug\u0006\u0012\u0011\u0011R\u0001\u0004x*\u0001\u0003\u0005\t\u0011Be\u001e,X.\u001a8ugjR\u0001\u0005\t\u0011!A\u0001R\u0003e\u001d;sA5\u0002\u0013\rI:ue&tw\rI3yaJ,7o]5p]*\u0001\u0003\u0005\t\u0011!A)\u0002CO]5n'R\u0014\b%\f\u0011uQ\u0016\u0004CO]5nAM$(/\u001b8hA\rD\u0017M]1di\u0016\u00148\u000f\t;pAQ\u0014\u0018.\u001c\u0017!i\",\u0007\u0005Z3gCVdG\u000f\t<bYV,\u0007%[:!C\u0002\u001a\u0018N\\4mK\u0002\u001a\b/Y2f\u0015\u0001\u0002\u0003\u0005\t\u0011!U\u0001\u0012u\n\u0016%-A\u0019\u0013v*\u0014\u0011.AQDWm]3!CJ,\u0007e[3zo>\u0014Hm\u001d\u0011u_\u0002\u001a\b/Z2jMf\u0004CO]5n[&tw\rI:ue&tw\rI2iCJ\f7\r^3sg\u00022'o\\7!E>$\b\u000eI3oIN\u0004sN\u001a\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\"\b.\u001a\u0011tiJLgn\u001a\u0006!A\u0001\u0002\u0003\u0005\t\u0016!\u0019\u0016\u000bE)\u0013(HY\u00012%kT'![\u0001\"\b.Z:fA\u0005\u0014X\rI6fs^|'\u000fZ:!i>\u00043\u000f]3dS\u001aL\b\u0005\u001e:j[6Lgn\u001a\u0011tiJLgn\u001a\u0011dQ\u0006\u0014\u0018m\u0019;feN\u0004cM]8nAQDW\r\t7fMRT\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011f]\u0012\u0004sN\u001a\u0011uQ\u0016\u00043\u000f\u001e:j]\u001eT\u0001\u0005\t\u0011!A\u0001R\u0003\u0005\u0016*B\u00132Kej\u0012\u0017!\rJ{U\nI\u0017!i\",7/\u001a\u0011be\u0016\u00043.Z=x_J$7\u000f\t;pAM\u0004XmY5gs\u0002\"(/[7nS:<\u0007e\u001d;sS:<\u0007e\u00195be\u0006\u001cG/\u001a:tA\u0019\u0014x.\u001c\u0011uQ\u0016\u0004#/[4ii*\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005I3oI\u0002zg\r\t;iK\u0002\u001aHO]5oO*\u0001\u0003%\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\ty)\u0001BV\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":\u0003\u0005\t\u0011!'B\f'o[*R\u0019\u0002\u0002\u0003eJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AM\u0003\u0018M]6T#2S\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006fJ*MO1\u0002seU*qCJ\\7+\u0015'TO%Z$\u0002\t\u0011!A\u0001\u0002\u0003\u0005]1sWN\u000b&\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\f\u000b\"P)\"\u0003se\u0015'(A\u0019\u0013v*\u0014\u0011('N\u0003\u0018M]6T#2\u001bv%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!a\u0006\u00148nU)\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q1+\u0015\tR%O\u000f\u0002:3\u000bT\u0014!\rJ{U\nI\u0014T'B\f'o[*R\u0019N;\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011qCJ\\7+\u0015'T\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\"&+Q%M\u0013:;\u0005eJ*MO\u00012%kT'!OM\u001b\u0006/\u0019:l'Fc5kJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AM\u001b\u0006/\u0019:l'FS\u0001\u0005\t\u0005\u0007\u0003'\u0003\u0003\u0019\u0001\u0014\u0002\u0007M$(\u000fC\u00036A\u0001\u0007a\u0005\u0003\u0004\"#\u0011\u0005\u0011\u0011\u0014\u000b\u0004G\u0005m\u0005bBAJ\u0003/\u0003\rA\n\u0005\tCE\t\t\u0011\"!\u0002 R)1%!)\u0002$\"1\u0001'!(A\u0002\u0019B\u0001\"NAO!\u0003\u0005\ra\u000e\u0005\n\u0003O\u000b\u0012\u0011!CA\u0003S\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002,\u0006M\u0006\u0003B\u000b9\u0003[\u0003R!FAXM]J1!!-\u0017\u0005\u0019!V\u000f\u001d7fe!I\u0011QWAS\u0003\u0003\u0005\raI\u0001\u0004q\u0012\u0002\u0004\"CA]#E\u0005I\u0011AA\u0011\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%e!I\u0011QX\t\u0012\u0002\u0013\u0005\u0011\u0011E\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%e!I\u0011\u0011Y\t\u0002\u0002\u0013%\u00111Y\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002FB!\u0011QFAd\u0013\u0011\tI-a\f\u0003\r=\u0013'.Z2u\u0001")
public class StringTrim
extends Expression
implements String2TrimExpression,
Serializable {
    private final Expression srcStr;
    private final Option<Expression> trimStr;

    public static Option<Expression> apply$default$2() {
        return StringTrim$.MODULE$.apply$default$2();
    }

    public static Option<Expression> $lessinit$greater$default$2() {
        return StringTrim$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<Expression, Option<Expression>>> unapply(StringTrim stringTrim) {
        return StringTrim$.MODULE$.unapply(stringTrim);
    }

    @Override
    public DataType dataType() {
        return String2TrimExpression$class.dataType(this);
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return String2TrimExpression$class.inputTypes(this);
    }

    @Override
    public boolean nullable() {
        return String2TrimExpression$class.nullable(this);
    }

    @Override
    public boolean foldable() {
        return String2TrimExpression$class.foldable(this);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes$class.checkInputDataTypes(this);
    }

    public Expression srcStr() {
        return this.srcStr;
    }

    public Option<Expression> trimStr() {
        return this.trimStr;
    }

    @Override
    public String prettyName() {
        return "trim";
    }

    @Override
    public Seq<Expression> children() {
        List list;
        if (this.trimStr().isDefined()) {
            Expression expression = this.srcStr();
            Expression expression2 = (Expression)this.trimStr().get();
            list = Nil$.MODULE$.$colon$colon((Object)expression2).$colon$colon((Object)expression);
        } else {
            Expression expression = this.srcStr();
            list = Nil$.MODULE$.$colon$colon((Object)expression);
        }
        return list;
    }

    @Override
    public Object eval(InternalRow input) {
        UTF8String srcString = (UTF8String)this.srcStr().eval(input);
        return srcString == null ? null : (this.trimStr().isDefined() ? srcString.trim((UTF8String)((Expression)this.trimStr().get()).eval(input)) : srcString.trim());
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode exprCode;
        Seq evals = (Seq)this.children().map((Function1)new Serializable(this, ctx){
            public static final long serialVersionUID = 0L;
            private final CodegenContext ctx$3;

            public final ExprCode apply(Expression x$32) {
                return x$32.genCode(this.ctx$3);
            }
            {
                this.ctx$3 = ctx$3;
            }
        }, Seq$.MODULE$.canBuildFrom());
        ExprCode srcString = (ExprCode)evals.apply(0);
        if (evals.length() == 1) {
            exprCode = ev.copy(Block$.MODULE$.blocksToBlock((Seq<Block>)((Seq)((SeqLike)evals.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Block apply(ExprCode x$33) {
                    return x$33.code();
                }
            }, Seq$.MODULE$.canBuildFrom())).$colon$plus((Object)Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        boolean ", " = false;\n        UTF8String ", " = null;\n        if (", ") {\n          ", " = true;\n        } else {\n          ", " = ", ".trim();\n        }"}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), ev.value(), srcString.isNull(), ev.isNull(), ev.value(), srcString.value()})), Seq$.MODULE$.canBuildFrom()))), ev.copy$default$2(), ev.copy$default$3());
        } else {
            ExprCode trimString = (ExprCode)evals.apply(1);
            String getTrimFunction = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        if (", ") {\n          ", " = true;\n        } else {\n          ", " = ", ".trim(", ");\n        }"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{trimString.isNull(), ev.isNull(), ev.value(), srcString.value(), trimString.value()}));
            exprCode = ev.copy(Block$.MODULE$.blocksToBlock((Seq<Block>)((Seq)((SeqLike)evals.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Block apply(ExprCode x$34) {
                    return x$34.code();
                }
            }, Seq$.MODULE$.canBuildFrom())).$colon$plus((Object)Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        boolean ", " = false;\n        UTF8String ", " = null;\n        if (", ") {\n          ", " = true;\n        } else {\n          ", "\n        }"}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), ev.value(), srcString.isNull(), ev.isNull(), getTrimFunction})), Seq$.MODULE$.canBuildFrom()))), ev.copy$default$2(), ev.copy$default$3());
        }
        return exprCode;
    }

    public StringTrim copy(Expression srcStr, Option<Expression> trimStr) {
        return new StringTrim(srcStr, trimStr);
    }

    public Expression copy$default$1() {
        return this.srcStr();
    }

    public Option<Expression> copy$default$2() {
        return this.trimStr();
    }

    @Override
    public String productPrefix() {
        return "StringTrim";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 1: {
                object = this.trimStr();
                break;
            }
            case 0: {
                object = this.srcStr();
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StringTrim;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StringTrim)) return false;
        boolean bl = true;
        if (!bl) return false;
        StringTrim stringTrim = (StringTrim)x$1;
        Expression expression = this.srcStr();
        Expression expression2 = stringTrim.srcStr();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<Expression> option = this.trimStr();
        Option<Expression> option2 = stringTrim.trimStr();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!stringTrim.canEqual(this)) return false;
        return true;
    }

    public StringTrim(Expression srcStr, Option<Expression> trimStr) {
        this.srcStr = srcStr;
        this.trimStr = trimStr;
        ExpectsInputTypes$class.$init$(this);
        String2TrimExpression$class.$init$(this);
    }

    public StringTrim(Expression trimStr, Expression srcStr) {
        this(srcStr, (Option<Expression>)Option$.MODULE$.apply((Object)trimStr));
    }

    public StringTrim(Expression srcStr) {
        this(srcStr, (Option<Expression>)None$.MODULE$);
    }
}

