/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.expressions.BinaryComparison;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.LessThanOrEqual$;
import org.apache.spark.sql.catalyst.expressions.package;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="expr1 _FUNC_ expr2 - Returns true if `expr1` is less than or equal to `expr2`.", arguments="\n    Arguments:\n      * expr1, expr2 - the two expressions must be same type or can be casted to a common type,\n          and must be a type that can be ordered. For example, map type is not orderable, so it\n          is not supported. For complex types such array/struct, the data types of fields must\n          be orderable.\n  ", examples="\n    Examples:\n      > SELECT 2 _FUNC_ 2;\n       true\n      > SELECT 1.0 _FUNC_ '1';\n       true\n      > SELECT to_date('2009-07-30 04:17:52') _FUNC_ to_date('2009-07-30 04:17:52');\n       true\n      > SELECT to_date('2009-07-30 04:17:52') _FUNC_ to_date('2009-08-01 04:17:52');\n       true\n      > SELECT 1 _FUNC_ NULL;\n       NULL\n  ")
@ScalaSignature(bytes="\u0006\u0001\u0005Ud\u0001B\u0001\u0003\u0001>\u0011q\u0002T3tgRC\u0017M\\(s\u000bF,\u0018\r\u001c\u0006\u0003\u0007\u0011\t1\"\u001a=qe\u0016\u001c8/[8og*\u0011QAB\u0001\tG\u0006$\u0018\r\\=ti*\u0011q\u0001C\u0001\u0004gFd'BA\u0005\u000b\u0003\u0015\u0019\b/\u0019:l\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001M)\u0001\u0001\u0005\u000b\u001cCA\u0011\u0011CE\u0007\u0002\u0005%\u00111C\u0001\u0002\u0011\u0005&t\u0017M]=D_6\u0004\u0018M]5t_:\u0004\"!\u0006\r\u000f\u0005E1\u0012BA\f\u0003\u0003\u001d\u0001\u0018mY6bO\u0016L!!\u0007\u000e\u0003\u001d9+H\u000e\\%oi>dWM]1oi*\u0011qC\u0001\t\u00039}i\u0011!\b\u0006\u0002=\u0005)1oY1mC&\u0011\u0001%\b\u0002\b!J|G-^2u!\ta\"%\u0003\u0002$;\ta1+\u001a:jC2L'0\u00192mK\"AQ\u0005\u0001BK\u0002\u0013\u0005a%\u0001\u0003mK\u001a$X#A\u0014\u0011\u0005EA\u0013BA\u0015\u0003\u0005))\u0005\u0010\u001d:fgNLwN\u001c\u0005\tW\u0001\u0011\t\u0012)A\u0005O\u0005)A.\u001a4uA!AQ\u0006\u0001BK\u0002\u0013\u0005a%A\u0003sS\u001eDG\u000f\u0003\u00050\u0001\tE\t\u0015!\u0003(\u0003\u0019\u0011\u0018n\u001a5uA!)\u0011\u0007\u0001C\u0001e\u00051A(\u001b8jiz\"2a\r\u001b6!\t\t\u0002\u0001C\u0003&a\u0001\u0007q\u0005C\u0003.a\u0001\u0007q\u0005C\u00038\u0001\u0011\u0005\u0003(\u0001\u0004ts6\u0014w\u000e\\\u000b\u0002sA\u0011!(\u0010\b\u00039mJ!\u0001P\u000f\u0002\rA\u0013X\rZ3g\u0013\tqtH\u0001\u0004TiJLgn\u001a\u0006\u0003yuAQ!\u0011\u0001\u0005R\t\u000bAB\\;mYN\u000bg-Z#wC2$2a\u0011$I!\taB)\u0003\u0002F;\t\u0019\u0011I\\=\t\u000b\u001d\u0003\u0005\u0019A\"\u0002\r%t\u0007/\u001e;2\u0011\u0015I\u0005\t1\u0001D\u0003\u0019Ig\u000e];ue!91\nAA\u0001\n\u0003a\u0015\u0001B2paf$2aM'O\u0011\u001d)#\n%AA\u0002\u001dBq!\f&\u0011\u0002\u0003\u0007q\u0005C\u0004Q\u0001E\u0005I\u0011A)\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\t!K\u000b\u0002('.\nA\u000b\u0005\u0002V56\taK\u0003\u0002X1\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u00033v\t!\"\u00198o_R\fG/[8o\u0013\tYfKA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016Dq!\u0018\u0001\u0012\u0002\u0013\u0005\u0011+\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\t\u000f}\u0003\u0011\u0011!C!A\u0006i\u0001O]8ek\u000e$\bK]3gSb,\u0012!\u0019\t\u0003E\u001el\u0011a\u0019\u0006\u0003I\u0016\fA\u0001\\1oO*\ta-\u0001\u0003kCZ\f\u0017B\u0001 d\u0011\u001dI\u0007!!A\u0005\u0002)\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\u0012a\u001b\t\u000391L!!\\\u000f\u0003\u0007%sG\u000fC\u0004p\u0001\u0005\u0005I\u0011\u00019\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR\u00111)\u001d\u0005\be:\f\t\u00111\u0001l\u0003\rAH%\r\u0005\bi\u0002\t\t\u0011\"\u0011v\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014X#\u0001<\u0011\u0007]T8)D\u0001y\u0015\tIX$\u0001\u0006d_2dWm\u0019;j_:L!a\u001f=\u0003\u0011%#XM]1u_JDq! \u0001\u0002\u0002\u0013\u0005a0\u0001\u0005dC:,\u0015/^1m)\ry\u0018Q\u0001\t\u00049\u0005\u0005\u0011bAA\u0002;\t9!i\\8mK\u0006t\u0007b\u0002:}\u0003\u0003\u0005\ra\u0011\u0005\n\u0003\u0013\u0001\u0011\u0011!C!\u0003\u0017\ta!Z9vC2\u001cHcA@\u0002\u000e!A!/a\u0002\u0002\u0002\u0003\u00071\tK\b\u0001\u0003#\t9\"!\u0007\u0002\u001e\u0005}\u00111EA\u0013!\r\t\u00121C\u0005\u0004\u0003+\u0011!!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u00037\ta*\u001a=qeF\u0002sLR+O\u0007~\u0003S\r\u001f9se\u0001j\u0003EU3ukJt7\u000f\t;sk\u0016\u0004\u0013N\u001a\u0011aKb\u0004(/\r1!SN\u0004C.Z:tAQD\u0017M\u001c\u0011pe\u0002*\u0017/^1mAQ|\u0007\u0005Y3yaJ\u0014\u0004ML\u0001\nCJ<W/\\3oiN\f#!!\t\u0002\u0005'S\u0001\u0005\t\u0011!\u0003J<W/\\3oiNT$\u0002\t\u0011!A\u0001\u0002#\u0006I3yaJ\fD\u0006I3yaJ\u0014\u0004%\f\u0011uQ\u0016\u0004Co^8!Kb\u0004(/Z:tS>t7\u000fI7vgR\u0004#-\u001a\u0011tC6,\u0007\u0005^=qK\u0002z'\u000fI2b]\u0002\u0012W\rI2bgR,G\r\t;pA\u0005\u00043m\\7n_:\u0004C/\u001f9fY)\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005I1oI\u0002jWo\u001d;!E\u0016\u0004\u0013\r\t;za\u0016\u0004C\u000f[1uA\r\fg\u000e\t2fA=\u0014H-\u001a:fI:\u0002ci\u001c:!Kb\fW\u000e\u001d7fY\u0001j\u0017\r\u001d\u0011usB,\u0007%[:!]>$\be\u001c:eKJ\f'\r\\3-AM|\u0007%\u001b;\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0013n\u001d\u0011o_R\u00043/\u001e9q_J$X\r\u001a\u0018!\r>\u0014\beY8na2,\u0007\u0010\t;za\u0016\u001c\be];dQ\u0002\n'O]1z_M$(/^2uY\u0001\"\b.\u001a\u0011eCR\f\u0007\u0005^=qKN\u0004sN\u001a\u0011gS\u0016dGm\u001d\u0011nkN$(\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!E\u0016\u0004sN\u001d3fe\u0006\u0014G.\u001a\u0018\u000bA\u0001\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0003O\t!q\u0014\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!e\u0001zf)\u0016(D?\u0002\u00124H\u0003\u0011!A\u0001\u0002\u0003\u0005\t;sk\u0016T\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006%\r\u00181A}3UKT\"`A\u001d\nte\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011ueV,'\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000b\t;p?\u0012\fG/\u001a\u0015(eA\u0002\u0014(\f\u00198[M\u0002\u0004\u0005\r\u001b;c]RTGM\u0014*A}3UKT\"`AQ|w\fZ1uK\":#\u0007\r\u0019:[A:Tf\r\u0019!aQR\u0014g\u000e\u001e6e\u001dJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t;sk\u0016T\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006\u0005^8`I\u0006$X\rK\u00143aAJT\u0006M\u001c.gA\u0002\u0003\u0007\u000e\u001e2oi*$gJ\u0015!?\u001a+fjQ0!i>|F-\u0019;fQ\u001d\u0012\u0004\u0007M\u001d.aaj\u0003'\r\u00111ii\ntGO\u001b3O%Z$\u0002\t\u0011!A\u0001\u0002\u0003\u0005\u001e:vK*\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003\u0013\u0007I0G+:\u001bu\f\t(V\u00192[$\u0002\t\u0011!A\u0001\u0002\u0003ET+M\u0019*\u0001\u0003eB\u0005\u0002,\t\t\t\u0011#\u0001\u0002.\u0005yA*Z:t)\"\fgn\u0014:FcV\fG\u000eE\u0002\u0012\u0003_1\u0001\"\u0001\u0002\u0002\u0002#\u0005\u0011\u0011G\n\u0006\u0003_\t\u0019$\t\t\b\u0003k\tYdJ\u00144\u001b\t\t9DC\u0002\u0002:u\tqA];oi&lW-\u0003\u0003\u0002>\u0005]\"!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oe!9\u0011'a\f\u0005\u0002\u0005\u0005CCAA\u0017\u0011)\t)%a\f\u0002\u0002\u0013\u0015\u0013qI\u0001\ti>\u001cFO]5oOR\t\u0011\r\u0003\u0006\u0002L\u0005=\u0012\u0011!CA\u0003\u001b\nQ!\u00199qYf$RaMA(\u0003#Ba!JA%\u0001\u00049\u0003BB\u0017\u0002J\u0001\u0007q\u0005\u0003\u0006\u0002V\u0005=\u0012\u0011!CA\u0003/\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002Z\u0005\u0015\u0004#\u0002\u000f\u0002\\\u0005}\u0013bAA/;\t1q\n\u001d;j_:\u0004R\u0001HA1O\u001dJ1!a\u0019\u001e\u0005\u0019!V\u000f\u001d7fe!I\u0011qMA*\u0003\u0003\u0005\raM\u0001\u0004q\u0012\u0002\u0004BCA6\u0003_\t\t\u0011\"\u0003\u0002n\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\ty\u0007E\u0002c\u0003cJ1!a\u001dd\u0005\u0019y%M[3di\u0002")
public class LessThanOrEqual
extends BinaryComparison
implements package.NullIntolerant,
Serializable {
    private final Expression left;
    private final Expression right;

    public static Option<Tuple2<Expression, Expression>> unapply(LessThanOrEqual lessThanOrEqual) {
        return LessThanOrEqual$.MODULE$.unapply(lessThanOrEqual);
    }

    public static Function1<Tuple2<Expression, Expression>, LessThanOrEqual> tupled() {
        return LessThanOrEqual$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, LessThanOrEqual>> curried() {
        return LessThanOrEqual$.MODULE$.curried();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public String symbol() {
        return "<=";
    }

    @Override
    public Object nullSafeEval(Object input1, Object input2) {
        return BoxesRunTime.boxToBoolean((boolean)this.ordering().lteq(input1, input2));
    }

    public LessThanOrEqual copy(Expression left, Expression right) {
        return new LessThanOrEqual(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "LessThanOrEqual";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 1: {
                expression = this.right();
                break;
            }
            case 0: {
                expression = this.left();
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof LessThanOrEqual;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof LessThanOrEqual)) return false;
        boolean bl = true;
        if (!bl) return false;
        LessThanOrEqual lessThanOrEqual = (LessThanOrEqual)x$1;
        Expression expression = this.left();
        Expression expression2 = lessThanOrEqual.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = lessThanOrEqual.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!lessThanOrEqual.canEqual(this)) return false;
        return true;
    }

    public LessThanOrEqual(Expression left, Expression right) {
        this.left = left;
        this.right = right;
    }
}

