/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.analysis;

import java.net.URI;
import java.util.Locale;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.catalyst.analysis.AnalysisTest;
import org.apache.spark.sql.catalyst.analysis.Analyzer;
import org.apache.spark.sql.catalyst.analysis.EliminateSubqueryAliases$;
import org.apache.spark.sql.catalyst.analysis.FunctionRegistry;
import org.apache.spark.sql.catalyst.analysis.FunctionRegistry$;
import org.apache.spark.sql.catalyst.analysis.TestRelations$;
import org.apache.spark.sql.catalyst.catalog.CatalogDatabase;
import org.apache.spark.sql.catalyst.catalog.ExternalCatalog;
import org.apache.spark.sql.catalyst.catalog.InMemoryCatalog;
import org.apache.spark.sql.catalyst.catalog.InMemoryCatalog$;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.scalactic.source.Position;
import org.scalatest.Assertions;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public abstract class AnalysisTest$class {
    private static Analyzer makeAnalyzer(AnalysisTest $this, boolean caseSensitive) {
        SQLConf conf = new SQLConf().copy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.CASE_SENSITIVE()), (Object)BoxesRunTime.boxToBoolean((boolean)caseSensitive))}));
        SessionCatalog catalog = new SessionCatalog((ExternalCatalog)new InMemoryCatalog(InMemoryCatalog$.MODULE$.$lessinit$greater$default$1(), InMemoryCatalog$.MODULE$.$lessinit$greater$default$2()), (FunctionRegistry)FunctionRegistry$.MODULE$.builtin(), conf);
        catalog.createDatabase(new CatalogDatabase("default", "", new URI("loc"), Predef$.MODULE$.Map().empty()), false);
        catalog.createTempView("TaBlE", (LogicalPlan)TestRelations$.MODULE$.testRelation(), true);
        catalog.createTempView("TaBlE2", (LogicalPlan)TestRelations$.MODULE$.testRelation2(), true);
        catalog.createTempView("TaBlE3", (LogicalPlan)TestRelations$.MODULE$.testRelation3(), true);
        return new Analyzer($this, conf, catalog){
            private final List<EliminateSubqueryAliases$> extendedResolutionRules;

            public List<EliminateSubqueryAliases$> extendedResolutionRules() {
                return this.extendedResolutionRules;
            }
            {
                EliminateSubqueryAliases$ eliminateSubqueryAliases$ = EliminateSubqueryAliases$.MODULE$;
                this.extendedResolutionRules = Nil$.MODULE$.$colon$colon((Object)eliminateSubqueryAliases$);
            }
        };
    }

    public static Analyzer getAnalyzer(AnalysisTest $this, boolean caseSensitive) {
        return caseSensitive ? $this.caseSensitiveAnalyzer() : $this.caseInsensitiveAnalyzer();
    }

    public static void checkAnalysis(AnalysisTest $this, LogicalPlan inputPlan, LogicalPlan expectedPlan, boolean caseSensitive) {
        Analyzer analyzer = $this.getAnalyzer(caseSensitive);
        LogicalPlan actualPlan = analyzer.executeAndCheck(inputPlan);
        $this.comparePlans(actualPlan, expectedPlan, $this.comparePlans$default$3());
    }

    public static boolean checkAnalysis$default$3(AnalysisTest $this) {
        return true;
    }

    public static void comparePlans(AnalysisTest $this, LogicalPlan plan1, LogicalPlan plan2, boolean checkAnalysis) {
        $this.org$apache$spark$sql$catalyst$analysis$AnalysisTest$$super$comparePlans(plan1, plan2, checkAnalysis);
    }

    public static boolean comparePlans$default$3(AnalysisTest $this) {
        return false;
    }

    public static void assertAnalysisSuccess(AnalysisTest $this, LogicalPlan inputPlan, boolean caseSensitive) {
        Analyzer analyzer = $this.getAnalyzer(caseSensitive);
        LogicalPlan analysisAttempt = analyzer.execute(inputPlan);
        try {
            analyzer.checkAnalysis(analysisAttempt);
            return;
        }
        catch (AnalysisException analysisException) {
            throw ((Assertions)$this).fail(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n            |Failed to Analyze Plan\n            |", "\n            |\n            |Partial Analysis\n            |", "\n          "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{inputPlan, analysisAttempt})))).stripMargin(), (Throwable)analysisException, new Position("AnalysisTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 76));
        }
    }

    public static boolean assertAnalysisSuccess$default$2(AnalysisTest $this) {
        return true;
    }

    public static void assertAnalysisError(AnalysisTest $this, LogicalPlan inputPlan, Seq expectedErrors, boolean caseSensitive) {
        Analyzer analyzer = $this.getAnalyzer(caseSensitive);
        AnalysisException e = (AnalysisException)((Object)((Assertions)$this).intercept((Function0)new Serializable($this, analyzer, inputPlan){
            public static final long serialVersionUID = 0L;
            private final Analyzer analyzer$1;
            private final LogicalPlan inputPlan$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.analyzer$1.checkAnalysis(this.analyzer$1.execute(this.inputPlan$1));
            }
            {
                this.analyzer$1 = analyzer$1;
                this.inputPlan$1 = inputPlan$1;
            }
        }, ClassTag$.MODULE$.apply(AnalysisException.class), new Position("AnalysisTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 92)));
        String string = e.getMessage().toLowerCase(Locale.ROOT);
        if (((IterableLike)expectedErrors.map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply(String x$2) {
                return x$2.toLowerCase(Locale.ROOT);
            }
        }, Seq$.MODULE$.canBuildFrom())).forall((Function1)new Serializable($this, string){
            public static final long serialVersionUID = 0L;
            private final String eta$0$1$1;

            public final boolean apply(CharSequence x$1) {
                return this.eta$0$1$1.contains(x$1);
            }
            {
                this.eta$0$1$1 = eta$0$1$1;
            }
        })) {
            return;
        }
        throw ((Assertions)$this).fail(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Exception message should contain the following substrings:\n           |\n           |  ", "\n           |\n           |Actual exception message:\n           |\n           |  ", "\n         "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{expectedErrors.mkString("\n  "), e.getMessage()})))).stripMargin(), new Position("AnalysisTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 98));
    }

    public static boolean assertAnalysisError$default$3(AnalysisTest $this) {
        return true;
    }

    public static void $init$(AnalysisTest $this) {
        $this.org$apache$spark$sql$catalyst$analysis$AnalysisTest$_setter_$caseSensitiveAnalyzer_$eq(AnalysisTest$class.makeAnalyzer($this, true));
        $this.org$apache$spark$sql$catalyst$analysis$AnalysisTest$_setter_$caseInsensitiveAnalyzer_$eq(AnalysisTest$class.makeAnalyzer($this, false));
    }
}

