/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ArrayRepeat$;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes$class;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprValue;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprValue$;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AnyDataType$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.unsafe.array.ByteArrayMethods;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(element, count) - Returns the array containing element count times.", examples="\n    Examples:\n      > SELECT _FUNC_('123', 2);\n       [\"123\",\"123\"]\n  ", since="2.4.0")
@ScalaSignature(bytes="\u0006\u0001\t-a\u0001B\u0001\u0003\u0001>\u00111\"\u0011:sCf\u0014V\r]3bi*\u00111\u0001B\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002\u0006\r\u0005A1-\u0019;bYf\u001cHO\u0003\u0002\b\u0011\u0005\u00191/\u001d7\u000b\u0005%Q\u0011!B:qCJ\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c\u0001aE\u0003\u0001!Q9R\u0004\u0005\u0002\u0012%5\t!!\u0003\u0002\u0014\u0005\t\u0001\")\u001b8bef,\u0005\u0010\u001d:fgNLwN\u001c\t\u0003#UI!A\u0006\u0002\u0003#\u0015C\b/Z2ug&s\u0007/\u001e;UsB,7\u000f\u0005\u0002\u001975\t\u0011DC\u0001\u001b\u0003\u0015\u00198-\u00197b\u0013\ta\u0012DA\u0004Qe>$Wo\u0019;\u0011\u0005aq\u0012BA\u0010\u001a\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011!\t\u0003A!f\u0001\n\u0003\u0011\u0013\u0001\u00027fMR,\u0012a\t\t\u0003#\u0011J!!\n\u0002\u0003\u0015\u0015C\bO]3tg&|g\u000e\u0003\u0005(\u0001\tE\t\u0015!\u0003$\u0003\u0015aWM\u001a;!\u0011!I\u0003A!f\u0001\n\u0003\u0011\u0013!\u0002:jO\"$\b\u0002C\u0016\u0001\u0005#\u0005\u000b\u0011B\u0012\u0002\rILw\r\u001b;!\u0011\u0015i\u0003\u0001\"\u0001/\u0003\u0019a\u0014N\\5u}Q\u0019q\u0006M\u0019\u0011\u0005E\u0001\u0001\"B\u0011-\u0001\u0004\u0019\u0003\"B\u0015-\u0001\u0004\u0019\u0003\"B\u001a\u0001\t\u0003\"\u0014\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u0003U\u0002\"AN\u001d\u000e\u0003]R!\u0001\u000f\u0004\u0002\u000bQL\b/Z:\n\u0005i:$!C!se\u0006LH+\u001f9f\u0011\u0015a\u0004\u0001\"\u0011>\u0003)Ig\u000e];u)f\u0004Xm]\u000b\u0002}A\u0019qh\u0012&\u000f\u0005\u0001+eBA!E\u001b\u0005\u0011%BA\"\u000f\u0003\u0019a$o\\8u}%\t!$\u0003\u0002G3\u00059\u0001/Y2lC\u001e,\u0017B\u0001%J\u0005\r\u0019V-\u001d\u0006\u0003\rf\u0001\"AN&\n\u00051;$\u0001E!cgR\u0014\u0018m\u0019;ECR\fG+\u001f9f\u0011\u0015q\u0005\u0001\"\u0011P\u0003!qW\u000f\u001c7bE2,W#\u0001)\u0011\u0005a\t\u0016B\u0001*\u001a\u0005\u001d\u0011un\u001c7fC:DQ\u0001\u0016\u0001\u0005BU\u000bA!\u001a<bYR\u0011a+\u0017\t\u00031]K!\u0001W\r\u0003\u0007\u0005s\u0017\u0010C\u0004['B\u0005\t\u0019A.\u0002\u000b%t\u0007/\u001e;\u0011\u0005qkV\"\u0001\u0003\n\u0005y#!aC%oi\u0016\u0014h.\u00197S_^DQ\u0001\u0019\u0001\u0005B\u0005\f!\u0002\u001d:fiRLh*Y7f+\u0005\u0011\u0007CA2g\u001d\tAB-\u0003\u0002f3\u00051\u0001K]3eK\u001aL!a\u001a5\u0003\rM#(/\u001b8h\u0015\t)\u0017\u0004C\u0003k\u0001\u0011\u00053.A\u0005e_\u001e+gnQ8eKR\u0019AN]<\u0011\u00055\u0004X\"\u00018\u000b\u0005=\u0014\u0011aB2pI\u0016<WM\\\u0005\u0003c:\u0014\u0001\"\u0012=qe\u000e{G-\u001a\u0005\u0006g&\u0004\r\u0001^\u0001\u0004GRD\bCA7v\u0013\t1hN\u0001\bD_\u0012,w-\u001a8D_:$X\r\u001f;\t\u000baL\u0007\u0019\u00017\u0002\u0005\u00154\b\"\u0002>\u0001\t\u0013Y\u0018A\u00068vY2,E.Z7f]R\u001c\bK]8uK\u000e$\u0018n\u001c8\u0015\t\tdXp \u0005\u0006qf\u0004\r\u0001\u001c\u0005\u0006}f\u0004\rAY\u0001\fe&<\u0007\u000e^%t\u001dVdG\u000e\u0003\u0004\u0002\u0002e\u0004\rAY\u0001\nG>\u0014X\rT8hS\u000eDq!!\u0002\u0001\t\u0013\t9!\u0001\u000ehK:\u001cu\u000eZ3G_JtU/\u001c2fe>3W\t\\3nK:$8\u000f\u0006\u0004\u0002\n\u0005=\u0011\u0011\u0003\t\u00061\u0005-!MY\u0005\u0004\u0003\u001bI\"A\u0002+va2,'\u0007\u0003\u0004t\u0003\u0007\u0001\r\u0001\u001e\u0005\b\u0003'\t\u0019\u00011\u0001c\u0003\u0015\u0019w.\u001e8u\u0011\u001d\t9\u0002\u0001C\u0005\u00033\t\u0011cZ3o\u0007>$WMR8s\u000b2,W.\u001a8u)5\u0011\u00171DA\u000f\u0003O\tY#!\f\u00022!11/!\u0006A\u0002QD\u0001\"a\b\u0002\u0016\u0001\u0007\u0011\u0011E\u0001\fK2,W.\u001a8u)f\u0004X\rE\u00027\u0003GI1!!\n8\u0005!!\u0015\r^1UsB,\u0007bBA\u0015\u0003+\u0001\rAY\u0001\bK2,W.\u001a8u\u0011\u001d\t\u0019\"!\u0006A\u0002\tDq!a\f\u0002\u0016\u0001\u0007!-\u0001\u0006mK\u001a$\u0018j\u001d(vY2Dq!a\r\u0002\u0016\u0001\u0007!-A\u0007beJ\f\u0017\u0010R1uC:\u000bW.\u001a\u0005\n\u0003o\u0001\u0011\u0011!C\u0001\u0003s\tAaY8qsR)q&a\u000f\u0002>!A\u0011%!\u000e\u0011\u0002\u0003\u00071\u0005\u0003\u0005*\u0003k\u0001\n\u00111\u0001$\u0011%\t\t\u0005AI\u0001\n\u0003\t\u0019%\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005\u0015#fA\u0012\u0002H-\u0012\u0011\u0011\n\t\u0005\u0003\u0017\n)&\u0004\u0002\u0002N)!\u0011qJA)\u0003%)hn\u00195fG.,GMC\u0002\u0002Te\t!\"\u00198o_R\fG/[8o\u0013\u0011\t9&!\u0014\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0005\u0002\\\u0001\t\n\u0011\"\u0001\u0002D\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0004\"CA0\u0001\u0005\u0005I\u0011IA1\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u00111\r\t\u0005\u0003K\ny'\u0004\u0002\u0002h)!\u0011\u0011NA6\u0003\u0011a\u0017M\\4\u000b\u0005\u00055\u0014\u0001\u00026bm\u0006L1aZA4\u0011%\t\u0019\bAA\u0001\n\u0003\t)(\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002xA\u0019\u0001$!\u001f\n\u0007\u0005m\u0014DA\u0002J]RD\u0011\"a \u0001\u0003\u0003%\t!!!\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR\u0019a+a!\t\u0015\u0005\u0015\u0015QPA\u0001\u0002\u0004\t9(A\u0002yIEB\u0011\"!#\u0001\u0003\u0003%\t%a#\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!$\u0011\u000b\u0005=\u0015Q\u0013,\u000e\u0005\u0005E%bAAJ3\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005]\u0015\u0011\u0013\u0002\t\u0013R,'/\u0019;pe\"I\u00111\u0014\u0001\u0002\u0002\u0013\u0005\u0011QT\u0001\tG\u0006tW)];bYR\u0019\u0001+a(\t\u0013\u0005\u0015\u0015\u0011TA\u0001\u0002\u00041\u0006\"CAR\u0001\u0005\u0005I\u0011IAS\u0003\u0019)\u0017/^1mgR\u0019\u0001+a*\t\u0013\u0005\u0015\u0015\u0011UA\u0001\u0002\u00041\u0006f\u0004\u0001\u0002,\u0006E\u00161WA\\\u0003s\u000bi,a0\u0011\u0007E\ti+C\u0002\u00020\n\u0011Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u00026\u0006QuLR+O\u0007~CS\r\\3nK:$H\u0006I2pk:$\u0018\u0006I\u0017!%\u0016$XO\u001d8tAQDW\rI1se\u0006L\beY8oi\u0006Lg.\u001b8hA\u0015dW-\\3oi\u0002\u001aw.\u001e8uAQLW.Z:/\u0003!)\u00070Y7qY\u0016\u001c\u0018EAA^\u0003\u001dS\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006fJ\u00193g\u001db\u0003EM\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!Am\u0013\u0013GM\u001a#Y\t\n$g\r\u0012^\u0015\u0001\u0002\u0013!B:j]\u000e,\u0017EAAa\u0003\u0015\u0011d\u0006\u000e\u00181\u000f%\t)MAA\u0001\u0012\u0003\t9-A\u0006BeJ\f\u0017PU3qK\u0006$\bcA\t\u0002J\u001aA\u0011AAA\u0001\u0012\u0003\tYmE\u0003\u0002J\u00065W\u0004E\u0004\u0002P\u0006U7eI\u0018\u000e\u0005\u0005E'bAAj3\u00059!/\u001e8uS6,\u0017\u0002BAl\u0003#\u0014\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c83\u0011\u001di\u0013\u0011\u001aC\u0001\u00037$\"!a2\t\u0015\u0005}\u0017\u0011ZA\u0001\n\u000b\n\t/\u0001\u0005u_N#(/\u001b8h)\t\t\u0019\u0007\u0003\u0006\u0002f\u0006%\u0017\u0011!CA\u0003O\fQ!\u00199qYf$RaLAu\u0003WDa!IAr\u0001\u0004\u0019\u0003BB\u0015\u0002d\u0002\u00071\u0005\u0003\u0006\u0002p\u0006%\u0017\u0011!CA\u0003c\fq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002t\u0006m\b#\u0002\r\u0002v\u0006e\u0018bAA|3\t1q\n\u001d;j_:\u0004R\u0001GA\u0006G\rB\u0011\"!@\u0002n\u0006\u0005\t\u0019A\u0018\u0002\u0007a$\u0003\u0007\u0003\u0006\u0003\u0002\u0005%\u0017\u0011!C\u0005\u0005\u0007\t1B]3bIJ+7o\u001c7wKR\u0011!Q\u0001\t\u0005\u0003K\u00129!\u0003\u0003\u0003\n\u0005\u001d$AB(cU\u0016\u001cG\u000f")
public class ArrayRepeat
extends BinaryExpression
implements ExpectsInputTypes,
Serializable {
    private final Expression left;
    private final Expression right;

    public static Option<Tuple2<Expression, Expression>> unapply(ArrayRepeat arrayRepeat) {
        return ArrayRepeat$.MODULE$.unapply(arrayRepeat);
    }

    public static Function1<Tuple2<Expression, Expression>, ArrayRepeat> tupled() {
        return ArrayRepeat$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, ArrayRepeat>> curried() {
        return ArrayRepeat$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes$class.checkInputDataTypes(this);
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public ArrayType dataType() {
        return new ArrayType(this.left().dataType(), this.left().nullable());
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{AnyDataType$.MODULE$, IntegerType$.MODULE$}));
    }

    @Override
    public boolean nullable() {
        return this.right().nullable();
    }

    @Override
    public Object eval(InternalRow input) {
        GenericArrayData genericArrayData;
        Object count = this.right().eval(input);
        if (count == null) {
            genericArrayData = null;
        } else {
            if (BoxesRunTime.unboxToInt((Object)count) > ByteArrayMethods.MAX_ROUNDED_ARRAY_LENGTH) {
                throw new RuntimeException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsuccessful try to create array with ", " elements "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{count}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"due to exceeding the array size limit ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)ByteArrayMethods.MAX_ROUNDED_ARRAY_LENGTH)}))).toString());
            }
            Object element = this.left().eval(input);
            genericArrayData = new GenericArrayData((Object[])Array$.MODULE$.fill(BoxesRunTime.unboxToInt((Object)count), (Function0)new Serializable(this, element){
                public static final long serialVersionUID = 0L;
                private final Object element$1;

                public final Object apply() {
                    return this.element$1;
                }
                {
                    this.element$1 = element$1;
                }
            }, ClassTag$.MODULE$.Any()));
        }
        return genericArrayData;
    }

    @Override
    public String prettyName() {
        return "array_repeat";
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode leftGen = this.left().genCode(ctx);
        ExprCode rightGen = this.right().genCode(ctx);
        ExprValue element = leftGen.value();
        ExprValue count = rightGen.value();
        DataType et = this.dataType().elementType();
        String coreLogic = this.genCodeForElement(ctx, et, ExprValue$.MODULE$.exprValueToString(element), ExprValue$.MODULE$.exprValueToString(count), ExprValue$.MODULE$.exprValueToString(leftGen.isNull()), ExprValue$.MODULE$.exprValueToString(ev.value()));
        String resultCode = this.nullElementsProtection(ev, ExprValue$.MODULE$.exprValueToString(rightGen.isNull()), coreLogic);
        return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |boolean ", " = false;\n         |", "\n         |", "\n         |", " ", " =\n         |  ", ";\n         |", "\n       "}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), leftGen.code(), rightGen.code(), CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), CodeGenerator$.MODULE$.defaultValue(this.dataType(), CodeGenerator$.MODULE$.defaultValue$default$2()), resultCode})).stripMargin(), ev.copy$default$2(), ev.copy$default$3());
    }

    private String nullElementsProtection(ExprCode ev, String rightIsNull, String coreLogic) {
        return this.nullable() ? new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |if (", ") {\n         |  ", " = true;\n         |} else {\n         |  ", "\n         |}\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rightIsNull, ev.isNull(), coreLogic})))).stripMargin() : coreLogic;
    }

    private Tuple2<String, String> genCodeForNumberOfElements(CodegenContext ctx, String count) {
        String numElements = ctx.freshName("numElements");
        String numElementsCode = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |int ", " = 0;\n         |if (", " > 0) {\n         |  ", " = ", ";\n         |}\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{numElements, count, numElements, count})))).stripMargin();
        return new Tuple2((Object)numElements, (Object)numElementsCode);
    }

    private String genCodeForElement(CodegenContext ctx, DataType elementType, String element, String count, String leftIsNull, String arrayDataName) {
        String tempArrayDataName = ctx.freshName("tempArrayData");
        String k = ctx.freshName("k");
        Tuple2<String, String> tuple2 = this.genCodeForNumberOfElements(ctx, count);
        if (tuple2 != null) {
            Tuple2 tuple22;
            String numElemName = (String)tuple2._1();
            String numElemCode = (String)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)numElemName, (Object)numElemCode);
            String numElemName2 = (String)tuple23._1();
            String numElemCode2 = (String)tuple23._2();
            String allocation = CodeGenerator$.MODULE$.createArrayData(tempArrayDataName, elementType, numElemName2, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" ", " failed."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.prettyName()})));
            String assignment = CodeGenerator$.MODULE$.setArrayElement(tempArrayDataName, elementType, k, element, CodeGenerator$.MODULE$.setArrayElement$default$5());
            return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n       |", "\n       |", "\n       |if (!", ") {\n       |  for (int ", " = 0; ", " < ", ".numElements(); ", "++) {\n       |    ", "\n       |  }\n       |} else {\n       |  for (int ", " = 0; ", " < ", ".numElements(); ", "++) {\n       |    ", ".setNullAt(", ");\n       |  }\n       |}\n       |", " = ", ";\n     "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{numElemCode2, allocation, leftIsNull, k, k, tempArrayDataName, k, assignment, k, k, tempArrayDataName, k, tempArrayDataName, k, arrayDataName, tempArrayDataName})))).stripMargin();
        }
        throw new MatchError(tuple2);
    }

    public ArrayRepeat copy(Expression left, Expression right) {
        return new ArrayRepeat(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "ArrayRepeat";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 1: {
                expression = this.right();
                break;
            }
            case 0: {
                expression = this.left();
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ArrayRepeat;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ArrayRepeat)) return false;
        boolean bl = true;
        if (!bl) return false;
        ArrayRepeat arrayRepeat = (ArrayRepeat)x$1;
        Expression expression = this.left();
        Expression expression2 = arrayRepeat.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = arrayRepeat.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!arrayRepeat.canEqual(this)) return false;
        return true;
    }

    public ArrayRepeat(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        ExpectsInputTypes$class.$init$(this);
    }
}

