/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Arrays;
import org.apache.spark.SparkException;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes$class;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection$;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.catalyst.expressions.aggregate.Percentile$;
import org.apache.spark.sql.catalyst.expressions.aggregate.TypedImperativeAggregate;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.IntegralType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.NumericType$;
import org.apache.spark.util.collection.OpenHashMap;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n      _FUNC_(col, percentage [, frequency]) - Returns the exact percentile value of numeric column\n       `col` at the given percentage. The value of percentage must be between 0.0 and 1.0. The\n       value of frequency should be positive integral\n\n      _FUNC_(col, array(percentage1 [, percentage2]...) [, frequency]) - Returns the exact\n      percentile value array of numeric column `col` at the given percentage(s). Each value\n      of the percentage array must be between 0.0 and 1.0. The value of frequency should be\n      positive integral\n\n      ")
@ScalaSignature(bytes="\u0006\u0001\r\u0005a\u0001B\u0001\u0003\u0001F\u0011!\u0002U3sG\u0016tG/\u001b7f\u0015\t\u0019A!A\u0005bO\u001e\u0014XmZ1uK*\u0011QAB\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002\b\u0011\u0005A1-\u0019;bYf\u001cHO\u0003\u0002\n\u0015\u0005\u00191/\u001d7\u000b\u0005-a\u0011!B:qCJ\\'BA\u0007\u000f\u0003\u0019\t\u0007/Y2iK*\tq\"A\u0002pe\u001e\u001c\u0001aE\u0003\u0001%\u001dZc\u0006E\u0002\u0014)Yi\u0011AA\u0005\u0003+\t\u0011\u0001\u0004V=qK\u0012LU\u000e]3sCRLg/Z!hOJ,w-\u0019;f!\u00119BD\b\u0013\u000e\u0003aQ!!\u0007\u000e\u0002\u0015\r|G\u000e\\3di&|gN\u0003\u0002\u001c\u0015\u0005!Q\u000f^5m\u0013\ti\u0002DA\u0006Pa\u0016t\u0007*Y:i\u001b\u0006\u0004\bCA\u0010#\u001b\u0005\u0001#\"A\u0011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\r\u0002#AB!osJ+g\r\u0005\u0002 K%\u0011a\u0005\t\u0002\u0005\u0019>tw\r\u0005\u0002)S5\tA!\u0003\u0002+\t\t1\u0012*\u001c9mS\u000eLGoQ1ti&s\u0007/\u001e;UsB,7\u000f\u0005\u0002 Y%\u0011Q\u0006\t\u0002\b!J|G-^2u!\tyr&\u0003\u00021A\ta1+\u001a:jC2L'0\u00192mK\"A!\u0007\u0001BK\u0002\u0013\u00051'A\u0003dQ&dG-F\u00015!\tAS'\u0003\u00027\t\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\t\u0011a\u0002!\u0011#Q\u0001\nQ\naa\u00195jY\u0012\u0004\u0003\u0002\u0003\u001e\u0001\u0005+\u0007I\u0011A\u001a\u0002)A,'oY3oi\u0006<W-\u0012=qe\u0016\u001c8/[8o\u0011!a\u0004A!E!\u0002\u0013!\u0014!\u00069fe\u000e,g\u000e^1hK\u0016C\bO]3tg&|g\u000e\t\u0005\t}\u0001\u0011)\u001a!C\u0001g\u0005\u0019bM]3rk\u0016t7-_#yaJ,7o]5p]\"A\u0001\t\u0001B\tB\u0003%A'\u0001\u000bge\u0016\fX/\u001a8ds\u0016C\bO]3tg&|g\u000e\t\u0005\t\u0005\u0002\u0011)\u001a!C\u0001\u0007\u00061R.\u001e;bE2,\u0017iZ4Ck\u001a4WM](gMN,G/F\u0001E!\tyR)\u0003\u0002GA\t\u0019\u0011J\u001c;\t\u0011!\u0003!\u0011#Q\u0001\n\u0011\u000bq#\\;uC\ndW-Q4h\u0005V4g-\u001a:PM\u001a\u001cX\r\u001e\u0011\t\u0011)\u0003!Q3A\u0005\u0002\r\u000bA#\u001b8qkR\fum\u001a\"vM\u001a,'o\u00144gg\u0016$\b\u0002\u0003'\u0001\u0005#\u0005\u000b\u0011\u0002#\u0002+%t\u0007/\u001e;BO\u001e\u0014UO\u001a4fe>3gm]3uA!)a\n\u0001C\u0001\u001f\u00061A(\u001b8jiz\"b\u0001U)S'R+\u0006CA\n\u0001\u0011\u0015\u0011T\n1\u00015\u0011\u0015QT\n1\u00015\u0011\u0015qT\n1\u00015\u0011\u001d\u0011U\n%AA\u0002\u0011CqAS'\u0011\u0002\u0003\u0007A\tC\u0003O\u0001\u0011\u0005q\u000bF\u0002Q1fCQA\r,A\u0002QBQA\u000f,A\u0002QBQA\u0014\u0001\u0005\u0002m#B\u0001\u0015/^=\")!G\u0017a\u0001i!)!H\u0017a\u0001i!)qL\u0017a\u0001i\u0005IaM]3rk\u0016t7-\u001f\u0005\u0006C\u0002!\tEY\u0001\u000baJ,G\u000f^=OC6,W#A2\u0011\u0005\u0011<gBA\u0010f\u0013\t1\u0007%\u0001\u0004Qe\u0016$WMZ\u0005\u0003Q&\u0014aa\u0015;sS:<'B\u00014!\u0011\u0015Y\u0007\u0001\"\u0011m\u0003u9\u0018\u000e\u001e5OK^lU\u000f^1cY\u0016\fum\u001a\"vM\u001a,'o\u00144gg\u0016$HC\u0001)n\u0011\u0015q'\u000e1\u0001E\u0003eqWm^'vi\u0006\u0014G.Z!hO\n+hMZ3s\u001f\u001a47/\u001a;\t\u000bA\u0004A\u0011I9\u00027]LG\u000f\u001b(fo&s\u0007/\u001e;BO\u001e\u0014UO\u001a4fe>3gm]3u)\t\u0001&\u000fC\u0003t_\u0002\u0007A)A\foK^Le\u000e];u\u0003\u001e<')\u001e4gKJ|eMZ:fi\"AQ\u000f\u0001EC\u0002\u0013%a/A\u000bsKR,(O\u001c)fe\u000e,g\u000e^5mK\u0006\u0013(/Y=\u0016\u0003]\u0004\"a\b=\n\u0005e\u0004#a\u0002\"p_2,\u0017M\u001c\u0005\tw\u0002A\t\u0011)Q\u0005o\u00061\"/\u001a;ve:\u0004VM]2f]RLG.Z!se\u0006L\b\u0005\u000b\u0002{{B\u0011qD`\u0005\u0003\u007f\u0002\u0012\u0011\u0002\u001e:b]NLWM\u001c;\t\u0015\u0005\r\u0001\u0001#b\u0001\n\u0013\t)!A\u0006qKJ\u001cWM\u001c;bO\u0016\u001cXCAA\u0004!\u0019\tI!!\u0004\u0002\u00125\u0011\u00111\u0002\u0006\u00033\u0001JA!a\u0004\u0002\f\t\u00191+Z9\u0011\u0007}\t\u0019\"C\u0002\u0002\u0016\u0001\u0012a\u0001R8vE2,\u0007BCA\r\u0001!\u0005\t\u0015)\u0003\u0002\b\u0005a\u0001/\u001a:dK:$\u0018mZ3tA!\u001a\u0011qC?\t\u000f\u0005}\u0001\u0001\"\u0011\u0002\"\u0005A1\r[5mIJ,g.\u0006\u0002\u0002$A)\u0011QEA\u001bi9!\u0011qEA\u0019\u001d\u0011\tI#a\f\u000e\u0005\u0005-\"bAA\u0017!\u00051AH]8pizJ\u0011!I\u0005\u0004\u0003g\u0001\u0013a\u00029bG.\fw-Z\u0005\u0005\u0003\u001f\t9DC\u0002\u00024\u0001Ba!a\u000f\u0001\t\u00032\u0018\u0001\u00038vY2\f'\r\\3\t\u0015\u0005}\u0002\u0001#b\u0001\n\u0003\n\t%\u0001\u0005eCR\fG+\u001f9f+\t\t\u0019\u0005\u0005\u0003\u0002F\u0005-SBAA$\u0015\r\tI\u0005C\u0001\u0006if\u0004Xm]\u0005\u0005\u0003\u001b\n9E\u0001\u0005ECR\fG+\u001f9f\u0011)\t\t\u0006\u0001E\u0001B\u0003&\u00111I\u0001\nI\u0006$\u0018\rV=qK\u0002Bq!!\u0016\u0001\t\u0003\n9&\u0001\u0006j]B,H\u000fV=qKN,\"!!\u0017\u0011\r\u0005\u0015\u0012QGA.!\u0011\t)%!\u0018\n\t\u0005}\u0013q\t\u0002\u0011\u0003\n\u001cHO]1di\u0012\u000bG/\u0019+za\u0016Dq!a\u0019\u0001\t\u0003\n)'A\ndQ\u0016\u001c7.\u00138qkR$\u0015\r^1UsB,7\u000f\u0006\u0002\u0002hA!\u0011\u0011NA8\u001b\t\tYGC\u0002\u0002n\u0019\t\u0001\"\u00198bYf\u001c\u0018n]\u0005\u0005\u0003c\nYGA\bUsB,7\t[3dWJ+7/\u001e7u\u0011\u001d\t)\b\u0001C\u0005\u0003o\nQ\u0002^8E_V\u0014G.\u001a,bYV,G\u0003BA\t\u0003sB\u0001\"a\u001f\u0002t\u0001\u0007\u0011QP\u0001\u0002IB\u0019q$a \n\u0007\u0005\u0005\u0005EA\u0002B]fDq!!\"\u0001\t\u0003\n9)A\fde\u0016\fG/Z!hOJ,w-\u0019;j_:\u0014UO\u001a4feR\ta\u0003C\u0004\u0002\f\u0002!\t%!$\u0002\rU\u0004H-\u0019;f)\u00151\u0012qRAJ\u0011\u001d\t\t*!#A\u0002Y\taAY;gM\u0016\u0014\b\u0002CAK\u0003\u0013\u0003\r!a&\u0002\u000b%t\u0007/\u001e;\u0011\t\u0005e\u00151T\u0007\u0002\r%\u0019\u0011Q\u0014\u0004\u0003\u0017%sG/\u001a:oC2\u0014vn\u001e\u0005\b\u0003C\u0003A\u0011IAR\u0003\u0015iWM]4f)\u00151\u0012QUAT\u0011\u001d\t\t*a(A\u0002YAq!!+\u0002 \u0002\u0007a#A\u0003pi\",'\u000fC\u0004\u0002.\u0002!\t%a,\u0002\t\u00154\u0018\r\u001c\u000b\u0005\u0003{\n\t\fC\u0004\u0002\u0012\u0006-\u0006\u0019\u0001\f\t\u000f\u0005U\u0006\u0001\"\u0003\u00028\u0006qq-\u001a;QKJ\u001cWM\u001c;jY\u0016\u001cH\u0003BA]\u0003w\u0003b!!\n\u00026\u0005E\u0001bBAI\u0003g\u0003\rA\u0006\u0005\b\u0003\u007f\u0003A\u0011BAa\u000399WM\\3sCR,w*\u001e;qkR$B!! \u0002D\"A\u0011QYA_\u0001\u0004\tI,A\u0004sKN,H\u000e^:\t\u000f\u0005%\u0007\u0001\"\u0003\u0002L\u0006iq-\u001a;QKJ\u001cWM\u001c;jY\u0016$b!!\u0005\u0002N\u0006e\u0007\u0002CAh\u0003\u000f\u0004\r!!5\u0002\u0017\u0005<wM]3D_VtGo\u001d\t\u0007\u0003K\t)$a5\u0011\u000b}\t)N\b\u0013\n\u0007\u0005]\u0007E\u0001\u0004UkBdWM\r\u0005\t\u00037\f9\r1\u0001\u0002\u0012\u0005A\u0001o\\:ji&|g\u000eC\u0004\u0002`\u0002!I!!9\u0002#\tLg.\u0019:z'\u0016\f'o\u00195D_VtG\u000fF\u0005E\u0003G\fi/!=\u0002v\"A\u0011Q]Ao\u0001\u0004\t9/A\u0006d_VtGo]!se\u0006L\b\u0003B\u0010\u0002j\u0012J1!a;!\u0005\u0015\t%O]1z\u0011\u001d\ty/!8A\u0002\u0011\u000bQa\u001d;beRDq!a=\u0002^\u0002\u0007A)A\u0002f]\u0012Dq!a>\u0002^\u0002\u0007A%A\u0003wC2,X\rC\u0004\u0002|\u0002!\t%!@\u0002\u0013M,'/[1mSj,G\u0003BA\u0000\u0005\u000f\u0001RaHAu\u0005\u0003\u00012a\bB\u0002\u0013\r\u0011)\u0001\t\u0002\u0005\u0005f$X\rC\u0004\u0003\n\u0005e\b\u0019\u0001\f\u0002\u0007=\u0014'\u000eC\u0004\u0003\u000e\u0001!\tEa\u0004\u0002\u0017\u0011,7/\u001a:jC2L'0\u001a\u000b\u0004-\tE\u0001\u0002\u0003B\n\u0005\u0017\u0001\r!a@\u0002\u000b\tLH/Z:\t\u0013\t]\u0001!!A\u0005\u0002\te\u0011\u0001B2paf$2\u0002\u0015B\u000e\u0005;\u0011yB!\t\u0003$!A!G!\u0006\u0011\u0002\u0003\u0007A\u0007\u0003\u0005;\u0005+\u0001\n\u00111\u00015\u0011!q$Q\u0003I\u0001\u0002\u0004!\u0004\u0002\u0003\"\u0003\u0016A\u0005\t\u0019\u0001#\t\u0011)\u0013)\u0002%AA\u0002\u0011C\u0011Ba\n\u0001#\u0003%\tA!\u000b\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011!1\u0006\u0016\u0004i\t52F\u0001B\u0018!\u0011\u0011\tDa\u000f\u000e\u0005\tM\"\u0002\u0002B\u001b\u0005o\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\te\u0002%\u0001\u0006b]:|G/\u0019;j_:LAA!\u0010\u00034\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0013\t\u0005\u0003!%A\u0005\u0002\t%\u0012AD2paf$C-\u001a4bk2$HE\r\u0005\n\u0005\u000b\u0002\u0011\u0013!C\u0001\u0005S\tabY8qs\u0012\"WMZ1vYR$3\u0007C\u0005\u0003J\u0001\t\n\u0011\"\u0001\u0003L\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\"TC\u0001B'U\r!%Q\u0006\u0005\n\u0005#\u0002\u0011\u0013!C\u0001\u0005\u0017\nabY8qs\u0012\"WMZ1vYR$S\u0007C\u0005\u0003V\u0001\t\t\u0011\"\u0011\u0003X\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"A!\u0017\u0011\t\tm#QM\u0007\u0003\u0005;RAAa\u0018\u0003b\u0005!A.\u00198h\u0015\t\u0011\u0019'\u0001\u0003kCZ\f\u0017b\u00015\u0003^!A!\u0011\u000e\u0001\u0002\u0002\u0013\u00051)\u0001\u0007qe>$Wo\u0019;Be&$\u0018\u0010C\u0005\u0003n\u0001\t\t\u0011\"\u0001\u0003p\u0005q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA?\u0005cB\u0011Ba\u001d\u0003l\u0005\u0005\t\u0019\u0001#\u0002\u0007a$\u0013\u0007C\u0005\u0003x\u0001\t\t\u0011\"\u0011\u0003z\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0003|A1\u0011\u0011\u0002B?\u0003{JAAa \u0002\f\tA\u0011\n^3sCR|'\u000fC\u0005\u0003\u0004\u0002\t\t\u0011\"\u0001\u0003\u0006\u0006A1-\u00198FcV\fG\u000eF\u0002x\u0005\u000fC!Ba\u001d\u0003\u0002\u0006\u0005\t\u0019AA?\u0011%\u0011Y\tAA\u0001\n\u0003\u0012i)\u0001\u0004fcV\fGn\u001d\u000b\u0004o\n=\u0005B\u0003B:\u0005\u0013\u000b\t\u00111\u0001\u0002~!:\u0001Aa%\u0003\u001a\nm\u0005c\u0001\u0015\u0003\u0016&\u0019!q\u0013\u0003\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012!QT\u0001\u0005Z)\u0001\u0003\u0005\t\u0011!A}3UKT\"`Q\r|G\u000e\f\u0011qKJ\u001cWM\u001c;bO\u0016\u00043\f\f\u0011ge\u0016\fX/\u001a8dsvK\u0003%\f\u0011SKR,(O\\:!i\",\u0007%\u001a=bGR\u0004\u0003/\u001a:dK:$\u0018\u000e\\3!m\u0006dW/\u001a\u0011pM\u0002rW/\\3sS\u000e\u00043m\u001c7v[:T\u0001\u0005\t\u0011!A\u0001\u0002\u0003mY8mA\u0002\nG\u000f\t;iK\u0002:\u0017N^3oAA,'oY3oi\u0006<WM\f\u0011UQ\u0016\u0004c/\u00197vK\u0002zg\r\t9fe\u000e,g\u000e^1hK\u0002jWo\u001d;!E\u0016\u0004#-\u001a;xK\u0016t\u0007\u0005\r\u00181A\u0005tG\rI\u0019/a9\u0002C\u000b[3\u000bA\u0001\u0002\u0003\u0005\t\u0011!m\u0006dW/\u001a\u0011pM\u00022'/Z9vK:\u001c\u0017\u0010I:i_VdG\r\t2fAA|7/\u001b;jm\u0016\u0004\u0013N\u001c;fOJ\fGN\u0003\u0006!A\u0001\u0002\u0003\u0005I0G+:\u001bu\fK2pY2\u0002\u0013M\u001d:bs\"\u0002XM]2f]R\fw-Z\u0019!72\u0002\u0003/\u001a:dK:$\u0018mZ33;:rc&\u000b\u0011\\Y\u00012'/Z9vK:\u001c\u00170X\u0015![\u0001\u0012V\r^;s]N\u0004C\u000f[3!Kb\f7\r\u001e\u0006!A\u0001\u0002\u0003\u0005\t9fe\u000e,g\u000e^5mK\u00022\u0018\r\\;fA\u0005\u0014(/Y=!_\u001a\u0004c.^7fe&\u001c\u0007eY8mk6t\u0007\u0005Y2pY\u0002\u0004\u0013\r\u001e\u0011uQ\u0016\u0004s-\u001b<f]\u0002\u0002XM]2f]R\fw-\u001a\u0015tS9\u0002S)Y2iAY\fG.^3\u000bA\u0001\u0002\u0003\u0005\t\u0011pM\u0002\"\b.\u001a\u0011qKJ\u001cWM\u001c;bO\u0016\u0004\u0013M\u001d:bs\u0002jWo\u001d;!E\u0016\u0004#-\u001a;xK\u0016t\u0007\u0005\r\u00181A\u0005tG\rI\u0019/a9\u0002C\u000b[3!m\u0006dW/\u001a\u0011pM\u00022'/Z9vK:\u001c\u0017\u0010I:i_VdG\r\t2f\u0015\u0001\u0002\u0003\u0005\t\u0011!a>\u001c\u0018\u000e^5wK\u0002Jg\u000e^3he\u0006d'B\u0003\u0011!A\u0001\u0002\u0003eB\u0005\u0003\"\n\t\t\u0011#\u0001\u0003$\u0006Q\u0001+\u001a:dK:$\u0018\u000e\\3\u0011\u0007M\u0011)K\u0002\u0005\u0002\u0005\u0005\u0005\t\u0012\u0001BT'\u0015\u0011)K!+/!)\u0011YK!-5iQ\"E\tU\u0007\u0003\u0005[S1Aa,!\u0003\u001d\u0011XO\u001c;j[\u0016LAAa-\u0003.\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u001b\t\u000f9\u0013)\u000b\"\u0001\u00038R\u0011!1\u0015\u0005\u000b\u0005w\u0013)+!A\u0005F\tu\u0016\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\te\u0003B\u0003Ba\u0005K\u000b\t\u0011\"!\u0003D\u0006)\u0011\r\u001d9msRY\u0001K!2\u0003H\n%'1\u001aBg\u0011\u0019\u0011$q\u0018a\u0001i!1!Ha0A\u0002QBaA\u0010B`\u0001\u0004!\u0004\u0002\u0003\"\u0003@B\u0005\t\u0019\u0001#\t\u0011)\u0013y\f%AA\u0002\u0011C!B!5\u0003&\u0006\u0005I\u0011\u0011Bj\u0003\u001d)h.\u00199qYf$BA!6\u0003bB)qDa6\u0003\\&\u0019!\u0011\u001c\u0011\u0003\r=\u0003H/[8o!!y\"Q\u001c\u001b5i\u0011#\u0015b\u0001BpA\t1A+\u001e9mKVB\u0011Ba9\u0003P\u0006\u0005\t\u0019\u0001)\u0002\u0007a$\u0003\u0007\u0003\u0006\u0003h\n\u0015\u0016\u0013!C\u0001\u0005\u0017\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\"\u0004B\u0003Bv\u0005K\u000b\n\u0011\"\u0001\u0003L\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIUB!Ba<\u0003&F\u0005I\u0011\u0001B&\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\"\u0004B\u0003Bz\u0005K\u000b\n\u0011\"\u0001\u0003L\u0005y\u0011\r\u001d9ms\u0012\"WMZ1vYR$S\u0007\u0003\u0006\u0003x\n\u0015\u0016\u0011!C\u0005\u0005s\f1B]3bIJ+7o\u001c7wKR\u0011!1 \t\u0005\u00057\u0012i0\u0003\u0003\u0003\u0000\nu#AB(cU\u0016\u001cG\u000f")
public class Percentile
extends TypedImperativeAggregate<OpenHashMap<Object, Object>>
implements ImplicitCastInputTypes,
Serializable {
    private final Expression child;
    private final Expression percentageExpression;
    private final Expression frequencyExpression;
    private final int mutableAggBufferOffset;
    private final int inputAggBufferOffset;
    private transient boolean returnPercentileArray;
    private transient Seq<Object> percentages;
    private DataType dataType;
    private volatile transient byte bitmap$trans$0;
    private volatile boolean bitmap$0;

    public static int apply$default$5() {
        return Percentile$.MODULE$.apply$default$5();
    }

    public static int apply$default$4() {
        return Percentile$.MODULE$.apply$default$4();
    }

    public static int $lessinit$greater$default$5() {
        return Percentile$.MODULE$.$lessinit$greater$default$5();
    }

    public static int $lessinit$greater$default$4() {
        return Percentile$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<Tuple5<Expression, Expression, Expression, Object, Object>> unapply(Percentile percentile) {
        return Percentile$.MODULE$.unapply(percentile);
    }

    public static Function1<Tuple5<Expression, Expression, Expression, Object, Object>, Percentile> tupled() {
        return Percentile$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, Function1<Object, Function1<Object, Percentile>>>>> curried() {
        return Percentile$.MODULE$.curried();
    }

    private boolean returnPercentileArray$lzycompute() {
        Percentile percentile = this;
        synchronized (percentile) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.returnPercentileArray = this.percentageExpression().dataType() instanceof ArrayType;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
            return this.returnPercentileArray;
        }
    }

    private Seq percentages$lzycompute() {
        Percentile percentile = this;
        synchronized (percentile) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                Seq seq;
                Object object = this.percentageExpression().eval(this.percentageExpression().eval$default$1());
                if (object instanceof Double) {
                    double d = BoxesRunTime.unboxToDouble((Object)object);
                    seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{d}));
                } else {
                    if (!(object instanceof ArrayData)) {
                        throw new MatchError(object);
                    }
                    ArrayData arrayData = (ArrayData)object;
                    seq = Predef$.MODULE$.doubleArrayOps(arrayData.toDoubleArray()).toSeq();
                }
                this.percentages = seq;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
            return this.percentages;
        }
    }

    private DataType dataType$lzycompute() {
        Percentile percentile = this;
        synchronized (percentile) {
            if (!this.bitmap$0) {
                DataType dataType2 = this.percentageExpression().dataType();
                DataType dataType3 = dataType2 instanceof ArrayType ? new ArrayType(DoubleType$.MODULE$, false) : DoubleType$.MODULE$;
                this.dataType = dataType3;
                this.bitmap$0 = true;
            }
            return this.dataType;
        }
    }

    public Expression child() {
        return this.child;
    }

    public Expression percentageExpression() {
        return this.percentageExpression;
    }

    public Expression frequencyExpression() {
        return this.frequencyExpression;
    }

    @Override
    public int mutableAggBufferOffset() {
        return this.mutableAggBufferOffset;
    }

    @Override
    public int inputAggBufferOffset() {
        return this.inputAggBufferOffset;
    }

    @Override
    public String prettyName() {
        return "percentile";
    }

    @Override
    public Percentile withNewMutableAggBufferOffset(int newMutableAggBufferOffset) {
        int x$8 = newMutableAggBufferOffset;
        Expression x$9 = this.copy$default$1();
        Expression x$10 = this.copy$default$2();
        Expression x$11 = this.copy$default$3();
        int x$12 = this.copy$default$5();
        return this.copy(x$9, x$10, x$11, x$8, x$12);
    }

    @Override
    public Percentile withNewInputAggBufferOffset(int newInputAggBufferOffset) {
        int x$13 = newInputAggBufferOffset;
        Expression x$14 = this.copy$default$1();
        Expression x$15 = this.copy$default$2();
        Expression x$16 = this.copy$default$3();
        int x$17 = this.copy$default$4();
        return this.copy(x$14, x$15, x$16, x$17, x$13);
    }

    private boolean returnPercentileArray() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.returnPercentileArray$lzycompute() : this.returnPercentileArray;
    }

    private Seq<Object> percentages() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.percentages$lzycompute() : this.percentages;
    }

    @Override
    public Seq<Expression> children() {
        Expression expression = this.child();
        Expression expression2 = this.percentageExpression();
        Expression expression3 = this.frequencyExpression();
        return Nil$.MODULE$.$colon$colon((Object)expression3).$colon$colon((Object)expression2).$colon$colon((Object)expression);
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public DataType dataType() {
        return this.bitmap$0 ? this.dataType : this.dataType$lzycompute();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        DataType dataType2 = this.percentageExpression().dataType();
        DataType dataType3 = dataType2 instanceof ArrayType ? ArrayType$.MODULE$.apply(DoubleType$.MODULE$) : DoubleType$.MODULE$;
        DoubleType$ percentageExpType = dataType3;
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{NumericType$.MODULE$, percentageExpType, IntegralType$.MODULE$}));
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        TypeCheckResult defaultCheck = ExpectsInputTypes$class.checkInputDataTypes(this);
        return defaultCheck.isFailure() ? defaultCheck : (this.percentageExpression().foldable() ? (this.percentages().exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(double percentage) {
                return this.apply$mcZD$sp(percentage);
            }

            public boolean apply$mcZD$sp(double percentage) {
                return percentage < 0.0 || percentage > 1.0;
            }
        }) ? new TypeCheckResult.TypeCheckFailure(new StringBuilder().append((Object)"Percentage(s) must be between 0.0 and 1.0, ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"but got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.percentageExpression()}))).toString()) : TypeCheckResult$TypeCheckSuccess$.MODULE$) : new TypeCheckResult.TypeCheckFailure(new StringBuilder().append((Object)"The percentage(s) must be a constant literal, ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"but got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.percentageExpression()}))).toString()));
    }

    private double toDoubleValue(Object d) {
        Object object;
        block4: {
            double d2;
            block3: {
                block2: {
                    object = d;
                    if (!(object instanceof Decimal)) break block2;
                    Decimal decimal = (Decimal)object;
                    d2 = decimal.toDouble();
                    break block3;
                }
                if (!(object instanceof Number)) break block4;
                Number number = (Number)object;
                d2 = number.doubleValue();
            }
            return d2;
        }
        throw new MatchError(object);
    }

    @Override
    public OpenHashMap<Object, Object> createAggregationBuffer() {
        return new OpenHashMap.mcJ.sp(ClassTag$.MODULE$.AnyRef(), ClassTag$.MODULE$.Long());
    }

    @Override
    public OpenHashMap<Object, Object> update(OpenHashMap<Object, Object> buffer, InternalRow input) {
        Object object;
        Object key = this.child().eval(input);
        Object frqValue = this.frequencyExpression().eval(input);
        if (key == null || frqValue == null) {
            object = BoxedUnit.UNIT;
        } else {
            long frqLong = ((Number)frqValue).longValue();
            if (frqLong > 0L) {
                object = BoxesRunTime.boxToLong((long)buffer.changeValue$mcJ$sp(key, (Function0)new Serializable(this, frqLong){
                    public static final long serialVersionUID = 0L;
                    private final long frqLong$1;

                    public final long apply() {
                        return this.apply$mcJ$sp();
                    }

                    public long apply$mcJ$sp() {
                        return this.frqLong$1;
                    }
                    {
                        this.frqLong$1 = frqLong$1;
                    }
                }, (Function1)new Serializable(this, frqLong){
                    public static final long serialVersionUID = 0L;
                    private final long frqLong$1;

                    public final long apply(long x$4) {
                        return this.apply$mcJJ$sp(x$4);
                    }

                    public long apply$mcJJ$sp(long x$4) {
                        return x$4 + this.frqLong$1;
                    }
                    {
                        this.frqLong$1 = frqLong$1;
                    }
                }));
            } else {
                if (frqLong < 0L) {
                    throw new SparkException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Negative values found in ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.frequencyExpression().sql()})));
                }
                object = BoxedUnit.UNIT;
            }
        }
        return buffer;
    }

    @Override
    public OpenHashMap<Object, Object> merge(OpenHashMap<Object, Object> buffer, OpenHashMap<Object, Object> other) {
        other.foreach((Function1)new Serializable(this, buffer){
            public static final long serialVersionUID = 0L;
            private final OpenHashMap buffer$1;

            public final long apply(Tuple2<Object, Object> x0$1) {
                Tuple2<Object, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    Object key = tuple2._1();
                    long count = tuple2._2$mcJ$sp();
                    long l = this.buffer$1.changeValue$mcJ$sp(key, (Function0)new Serializable(this, count){
                        public static final long serialVersionUID = 0L;
                        private final long count$1;

                        public final long apply() {
                            return this.apply$mcJ$sp();
                        }

                        public long apply$mcJ$sp() {
                            return this.count$1;
                        }
                        {
                            this.count$1 = count$1;
                        }
                    }, (Function1)new Serializable(this, count){
                        public static final long serialVersionUID = 0L;
                        private final long count$1;

                        public final long apply(long x$5) {
                            return this.apply$mcJJ$sp(x$5);
                        }

                        public long apply$mcJJ$sp(long x$5) {
                            return x$5 + this.count$1;
                        }
                        {
                            this.count$1 = count$1;
                        }
                    });
                    return l;
                }
                throw new MatchError(tuple2);
            }
            {
                this.buffer$1 = buffer$1;
            }
        });
        return buffer;
    }

    @Override
    public Object eval(OpenHashMap<Object, Object> buffer) {
        return this.generateOutput(this.getPercentiles(buffer));
    }

    private Seq<Object> getPercentiles(OpenHashMap<Object, Object> buffer) {
        if (buffer.isEmpty()) {
            return (Seq)Seq$.MODULE$.empty();
        }
        Seq sortedCounts = (Seq)buffer.toSeq().sortBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Object apply(Tuple2<Object, Object> x$6) {
                return x$6._1();
            }
        }, ((NumericType)this.child().dataType()).ordering());
        Seq accumlatedCounts = (Seq)((TraversableLike)sortedCounts.scanLeft((Object)new Tuple2(((Tuple2)sortedCounts.head())._1(), (Object)BoxesRunTime.boxToLong((long)0L)), (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Object> apply(Tuple2<Object, Object> x0$2, Tuple2<Object, Object> x1$1) {
                Tuple2 tuple2 = new Tuple2(x0$2, x1$1);
                if (tuple2 != null) {
                    Tuple2 tuple22 = (Tuple2)tuple2._1();
                    Tuple2 tuple23 = (Tuple2)tuple2._2();
                    if (tuple22 != null) {
                        long count1 = tuple22._2$mcJ$sp();
                        if (tuple23 != null) {
                            Object key2 = tuple23._1();
                            long count2 = tuple23._2$mcJ$sp();
                            Tuple2 tuple24 = new Tuple2(key2, (Object)BoxesRunTime.boxToLong((long)(count1 + count2)));
                            return tuple24;
                        }
                    }
                }
                throw new MatchError((Object)tuple2);
            }
        }, Seq$.MODULE$.canBuildFrom())).tail();
        long maxPosition = ((Tuple2)accumlatedCounts.last())._2$mcJ$sp() - 1L;
        return (Seq)this.percentages().map((Function1)new Serializable(this, accumlatedCounts, maxPosition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Percentile $outer;
            private final Seq accumlatedCounts$1;
            private final long maxPosition$1;

            public final double apply(double percentile) {
                return this.apply$mcDD$sp(percentile);
            }

            public double apply$mcDD$sp(double percentile) {
                return this.$outer.org$apache$spark$sql$catalyst$expressions$aggregate$Percentile$$getPercentile((Seq<Tuple2<Object, Object>>)this.accumlatedCounts$1, (double)this.maxPosition$1 * percentile);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.accumlatedCounts$1 = accumlatedCounts$1;
                this.maxPosition$1 = maxPosition$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    private Object generateOutput(Seq<Object> results) {
        return results.isEmpty() ? null : (this.returnPercentileArray() ? new GenericArrayData(results) : results.head());
    }

    public double org$apache$spark$sql$catalyst$expressions$aggregate$Percentile$$getPercentile(Seq<Tuple2<Object, Object>> aggreCounts, double position2) {
        long lower = (long)RichDouble$.MODULE$.floor$extension(Predef$.MODULE$.doubleWrapper(position2));
        long higher = (long)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper(position2));
        long[] countsArray = (long[])((TraversableOnce)aggreCounts.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(Tuple2<Object, Object> x$7) {
                return x$7._2$mcJ$sp();
            }
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Long());
        int lowerIndex = this.binarySearchCount(countsArray, 0, aggreCounts.size(), lower + 1L);
        int higherIndex = this.binarySearchCount(countsArray, 0, aggreCounts.size(), higher + 1L);
        Object lowerKey = ((Tuple2)aggreCounts.apply(lowerIndex))._1();
        if (higher == lower) {
            return this.toDoubleValue(lowerKey);
        }
        Object higherKey = ((Tuple2)aggreCounts.apply(higherIndex))._1();
        if (BoxesRunTime.equals((Object)higherKey, (Object)lowerKey)) {
            return this.toDoubleValue(lowerKey);
        }
        return ((double)higher - position2) * this.toDoubleValue(lowerKey) + (position2 - (double)lower) * this.toDoubleValue(higherKey);
    }

    private int binarySearchCount(long[] countsArray, int start, int end, long value2) {
        int n = Arrays.binarySearch(countsArray, 0, end, value2);
        switch (n) {
            default: 
        }
        return n < 0 ? -(n + 1) : n;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public byte[] serialize(OpenHashMap<Object, Object> obj) {
        byte[] byArray;
        byte[] buffer = new byte[4096];
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(bos);
        try {
            UnsafeProjection projection = UnsafeProjection$.MODULE$.create((DataType[])((Object[])new DataType[]{this.child().dataType(), LongType$.MODULE$}));
            obj.foreach((Function1)new Serializable(this, buffer, out, projection){
                public static final long serialVersionUID = 0L;
                private final byte[] buffer$2;
                private final DataOutputStream out$1;
                private final UnsafeProjection projection$1;

                public final void apply(Tuple2<Object, Object> x0$3) {
                    Tuple2<Object, Object> tuple2 = x0$3;
                    if (tuple2 != null) {
                        Object key = tuple2._1();
                        long count = tuple2._2$mcJ$sp();
                        InternalRow row = InternalRow$.MODULE$.apply((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key, BoxesRunTime.boxToLong((long)count)}));
                        UnsafeRow unsafeRow = this.projection$1.apply(row);
                        this.out$1.writeInt(unsafeRow.getSizeInBytes());
                        unsafeRow.writeToStream(this.out$1, this.buffer$2);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.buffer$2 = buffer$2;
                    this.out$1 = out$1;
                    this.projection$1 = projection$1;
                }
            });
            out.writeInt(-1);
            out.flush();
            byArray = bos.toByteArray();
        }
        catch (Throwable throwable) {
            void var3_3;
            void var4_4;
            var4_4.close();
            var3_3.close();
            throw throwable;
        }
        out.close();
        bos.close();
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public OpenHashMap<Object, Object> deserialize(byte[] bytes) {
        OpenHashMap.mcJ.sp sp2;
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        DataInputStream ins = new DataInputStream(bis);
        try {
            OpenHashMap.mcJ.sp counts = new OpenHashMap.mcJ.sp(ClassTag$.MODULE$.AnyRef(), ClassTag$.MODULE$.Long());
            int sizeOfNextRow = ins.readInt();
            while (sizeOfNextRow >= 0) {
                byte[] bs = new byte[sizeOfNextRow];
                ins.readFully(bs);
                UnsafeRow row = new UnsafeRow(2);
                row.pointTo(bs, sizeOfNextRow);
                Object key = row.get(0, this.child().dataType());
                long count = BoxesRunTime.unboxToLong((Object)row.get(1, LongType$.MODULE$));
                counts.update$mcJ$sp(key, count);
                sizeOfNextRow = ins.readInt();
            }
            sp2 = counts;
        }
        catch (Throwable throwable) {
            void var2_2;
            void var3_3;
            var3_3.close();
            var2_2.close();
            throw throwable;
        }
        ins.close();
        bis.close();
        return sp2;
    }

    public Percentile copy(Expression child, Expression percentageExpression, Expression frequencyExpression, int mutableAggBufferOffset, int inputAggBufferOffset) {
        return new Percentile(child, percentageExpression, frequencyExpression, mutableAggBufferOffset, inputAggBufferOffset);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public Expression copy$default$2() {
        return this.percentageExpression();
    }

    public Expression copy$default$3() {
        return this.frequencyExpression();
    }

    public int copy$default$4() {
        return this.mutableAggBufferOffset();
    }

    public int copy$default$5() {
        return this.inputAggBufferOffset();
    }

    @Override
    public String productPrefix() {
        return "Percentile";
    }

    public int productArity() {
        return 5;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 4: {
                object = BoxesRunTime.boxToInteger((int)this.inputAggBufferOffset());
                break;
            }
            case 3: {
                object = BoxesRunTime.boxToInteger((int)this.mutableAggBufferOffset());
                break;
            }
            case 2: {
                object = this.frequencyExpression();
                break;
            }
            case 1: {
                object = this.percentageExpression();
                break;
            }
            case 0: {
                object = this.child();
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Percentile;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Percentile)) return false;
        boolean bl = true;
        if (!bl) return false;
        Percentile percentile = (Percentile)x$1;
        Expression expression = this.child();
        Expression expression2 = percentile.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.percentageExpression();
        Expression expression4 = percentile.percentageExpression();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.frequencyExpression();
        Expression expression6 = percentile.frequencyExpression();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (this.mutableAggBufferOffset() != percentile.mutableAggBufferOffset()) return false;
        if (this.inputAggBufferOffset() != percentile.inputAggBufferOffset()) return false;
        if (!percentile.canEqual(this)) return false;
        return true;
    }

    public Percentile(Expression child, Expression percentageExpression, Expression frequencyExpression, int mutableAggBufferOffset, int inputAggBufferOffset) {
        this.child = child;
        this.percentageExpression = percentageExpression;
        this.frequencyExpression = frequencyExpression;
        this.mutableAggBufferOffset = mutableAggBufferOffset;
        this.inputAggBufferOffset = inputAggBufferOffset;
        ExpectsInputTypes$class.$init$(this);
    }

    public Percentile(Expression child, Expression percentageExpression) {
        this(child, percentageExpression, Literal$.MODULE$.apply(BoxesRunTime.boxToLong((long)1L)), 0, 0);
    }

    public Percentile(Expression child, Expression percentageExpression, Expression frequency) {
        this(child, percentageExpression, frequency, 0, 0);
    }
}

