/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQueries;
import java.util.Locale;
import org.apache.spark.sql.catalyst.util.DateTimeFormatterHelper;
import org.apache.spark.sql.catalyst.util.DateTimeFormatterHelper$;
import scala.Tuple2;

public abstract class DateTimeFormatterHelper$class {
    public static Instant toInstantWithZoneId(DateTimeFormatterHelper $this, TemporalAccessor temporalAccessor, ZoneId zoneId) {
        LocalTime localTime = temporalAccessor.query(TemporalQueries.localTime()) == null ? LocalTime.ofNanoOfDay(0L) : LocalTime.from(temporalAccessor);
        LocalDate localDate = LocalDate.from(temporalAccessor);
        LocalDateTime localDateTime = LocalDateTime.of(localDate, localTime);
        ZonedDateTime zonedDateTime = ZonedDateTime.of(localDateTime, zoneId);
        return Instant.from(zonedDateTime);
    }

    public static DateTimeFormatter getOrCreateFormatter(DateTimeFormatterHelper $this, String pattern, Locale locale) {
        Tuple2 key = new Tuple2((Object)pattern, (Object)locale);
        DateTimeFormatter formatter = (DateTimeFormatter)DateTimeFormatterHelper$.MODULE$.cache().getIfPresent((Object)key);
        if (formatter == null) {
            formatter = DateTimeFormatterHelper$.MODULE$.buildFormatter(pattern, locale);
            DateTimeFormatterHelper$.MODULE$.cache().put((Object)key, (Object)formatter);
        }
        return formatter;
    }

    public static void $init$(DateTimeFormatterHelper $this) {
    }
}

