/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ArrayBinaryLike;
import org.apache.spark.sql.catalyst.expressions.ArrayIntersect$;
import org.apache.spark.sql.catalyst.expressions.ArraySetLike;
import org.apache.spark.sql.catalyst.expressions.BinaryArrayExpressionWithImplicitCast;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ComplexTypeMergingExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprValue$;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.unsafe.array.ByteArrayMethods;
import org.apache.spark.util.collection.OpenHashSet;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n  _FUNC_(array1, array2) - Returns an array of the elements in the intersection of array1 and\n    array2, without duplicates.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(array(1, 2, 3), array(1, 3, 5));\n       [1,3]\n  ", since="2.4.0")
@ScalaSignature(bytes="\u0006\u0001\u00055g\u0001B\u0001\u0003\u0001>\u0011a\"\u0011:sCfLe\u000e^3sg\u0016\u001cGO\u0003\u0002\u0004\t\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t)a!\u0001\u0005dCR\fG._:u\u0015\t9\u0001\"A\u0002tc2T!!\u0003\u0006\u0002\u000bM\u0004\u0018M]6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\u0002\u0001'\u0019\u0001\u0001\u0003F\f\u001bAA\u0011\u0011CE\u0007\u0002\u0005%\u00111C\u0001\u0002\u0011\u0005&t\u0017M]=FqB\u0014Xm]:j_:\u0004\"!E\u000b\n\u0005Y\u0011!aD!se\u0006L()\u001b8befd\u0015n[3\u0011\u0005EA\u0012BA\r\u0003\u0005q\u0019u.\u001c9mKb$\u0016\u0010]3NKJ<\u0017N\\4FqB\u0014Xm]:j_:\u0004\"a\u0007\u0010\u000e\u0003qQ\u0011!H\u0001\u0006g\u000e\fG.Y\u0005\u0003?q\u0011q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002\u001cC%\u0011!\u0005\b\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\tI\u0001\u0011)\u001a!C\u0001K\u0005!A.\u001a4u+\u00051\u0003CA\t(\u0013\tA#A\u0001\u0006FqB\u0014Xm]:j_:D\u0001B\u000b\u0001\u0003\u0012\u0003\u0006IAJ\u0001\u0006Y\u00164G\u000f\t\u0005\tY\u0001\u0011)\u001a!C\u0001K\u0005)!/[4ii\"Aa\u0006\u0001B\tB\u0003%a%\u0001\u0004sS\u001eDG\u000f\t\u0005\u0006a\u0001!\t!M\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007I\u001aD\u0007\u0005\u0002\u0012\u0001!)Ae\fa\u0001M!)Af\fa\u0001M!)a\u0007\u0001C!o\u0005AA-\u0019;b)f\u0004X-F\u00019!\tID(D\u0001;\u0015\tYd!A\u0003usB,7/\u0003\u0002>u\tAA)\u0019;b)f\u0004X\r\u0003\u0005@\u0001!\u0015\r\u0011\"\u0001A\u00035)g/\u00197J]R,'o]3diV\t\u0011\tE\u0003\u001c\u0005\u0012#E)\u0003\u0002D9\tIa)\u001e8di&|gN\r\t\u0003\u000b\"k\u0011A\u0012\u0006\u0003\u000f\u0012\tA!\u001e;jY&\u0011\u0011J\u0012\u0002\n\u0003J\u0014\u0018-\u001f#bi\u0006D#AP&\u0011\u0005ma\u0015BA'\u001d\u0005%!(/\u00198tS\u0016tG\u000fC\u0003P\u0001\u0011\u0005\u0003+\u0001\u0007ok2d7+\u00194f\u000bZ\fG\u000eF\u0002R)Z\u0003\"a\u0007*\n\u0005Mc\"aA!os\")QK\u0014a\u0001#\u00061\u0011N\u001c9viFBQa\u0016(A\u0002E\u000ba!\u001b8qkR\u0014\u0004\"B-\u0001\t\u0003R\u0016!\u00033p\u000f\u0016t7i\u001c3f)\rY\u0016M\u001a\t\u00039~k\u0011!\u0018\u0006\u0003=\n\tqaY8eK\u001e,g.\u0003\u0002a;\nAQ\t\u001f9s\u0007>$W\rC\u0003c1\u0002\u00071-A\u0002dib\u0004\"\u0001\u00183\n\u0005\u0015l&AD\"pI\u0016<WM\\\"p]R,\u0007\u0010\u001e\u0005\u0006Ob\u0003\raW\u0001\u0003KZDQ!\u001b\u0001\u0005B)\f!\u0002\u001d:fiRLh*Y7f+\u0005Y\u0007C\u00017t\u001d\ti\u0017\u000f\u0005\u0002o95\tqN\u0003\u0002q\u001d\u00051AH]8pizJ!A\u001d\u000f\u0002\rA\u0013X\rZ3g\u0013\t!XO\u0001\u0004TiJLgn\u001a\u0006\u0003erAqa\u001e\u0001\u0002\u0002\u0013\u0005\u00010\u0001\u0003d_BLHc\u0001\u001azu\"9AE\u001eI\u0001\u0002\u00041\u0003b\u0002\u0017w!\u0003\u0005\rA\n\u0005\by\u0002\t\n\u0011\"\u0001~\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\u0012A \u0016\u0003M}\\#!!\u0001\u0011\t\u0005\r\u0011QB\u0007\u0003\u0003\u000bQA!a\u0002\u0002\n\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u0017a\u0012AC1o]>$\u0018\r^5p]&!\u0011qBA\u0003\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\t\u0003'\u0001\u0011\u0013!C\u0001{\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0004\"CA\f\u0001\u0005\u0005I\u0011IA\r\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u00111\u0004\t\u0005\u0003;\t9#\u0004\u0002\u0002 )!\u0011\u0011EA\u0012\u0003\u0011a\u0017M\\4\u000b\u0005\u0005\u0015\u0012\u0001\u00026bm\u0006L1\u0001^A\u0010\u0011%\tY\u0003AA\u0001\n\u0003\ti#\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u00020A\u00191$!\r\n\u0007\u0005MBDA\u0002J]RD\u0011\"a\u000e\u0001\u0003\u0003%\t!!\u000f\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR\u0019\u0011+a\u000f\t\u0015\u0005u\u0012QGA\u0001\u0002\u0004\ty#A\u0002yIEB\u0011\"!\u0011\u0001\u0003\u0003%\t%a\u0011\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!\u0012\u0011\u000b\u0005\u001d\u0013QJ)\u000e\u0005\u0005%#bAA&9\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005=\u0013\u0011\n\u0002\t\u0013R,'/\u0019;pe\"I\u00111\u000b\u0001\u0002\u0002\u0013\u0005\u0011QK\u0001\tG\u0006tW)];bYR!\u0011qKA/!\rY\u0012\u0011L\u0005\u0004\u00037b\"a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003{\t\t&!AA\u0002EC\u0011\"!\u0019\u0001\u0003\u0003%\t%a\u0019\u0002\r\u0015\fX/\u00197t)\u0011\t9&!\u001a\t\u0013\u0005u\u0012qLA\u0001\u0002\u0004\t\u0006f\u0004\u0001\u0002j\u0005=\u0014\u0011OA;\u0003o\nY(! \u0011\u0007E\tY'C\u0002\u0002n\t\u0011Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002t\u0005\t\u0019A\u0003\u0011!?\u001a+fjQ0)CJ\u0014\u0018-_\u0019-A\u0005\u0014(/Y=3S\u0001j\u0003EU3ukJt7\u000fI1oA\u0005\u0014(/Y=!_\u001a\u0004C\u000f[3!K2,W.\u001a8ug\u0002Jg\u000e\t;iK\u0002Jg\u000e^3sg\u0016\u001cG/[8oA=4\u0007%\u0019:sCf\f\u0004%\u00198e\u0015\u0001\u0002\u0003\u0005I1se\u0006L(\u0007\f\u0011xSRDw.\u001e;!IV\u0004H.[2bi\u0016\u001chF\u0003\u0011!\u0003!)\u00070Y7qY\u0016\u001c\u0018EAA=\u0003US\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006&\u0019:sCfD\u0013\u0007\f\u00113Y\u0001\u001a\u0014\u0006\f\u0011beJ\f\u0017\u0010K\u0019-AMb\u0003%N\u0015*w)\u0001\u0003\u0005\t\u0011!A\u0001Z\u0016\u0007L\u001a^\u0015\u0001\u0002\u0013!B:j]\u000e,\u0017EAA@\u0003\u0015\u0011d\u0006\u000e\u00181\u000f%\t\u0019IAA\u0001\u0012\u0003\t))\u0001\bBeJ\f\u00170\u00138uKJ\u001cXm\u0019;\u0011\u0007E\t9I\u0002\u0005\u0002\u0005\u0005\u0005\t\u0012AAE'\u0015\t9)a#!!\u001d\ti)a%'MIj!!a$\u000b\u0007\u0005EE$A\u0004sk:$\u0018.\\3\n\t\u0005U\u0015q\u0012\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u0014\u0004b\u0002\u0019\u0002\b\u0012\u0005\u0011\u0011\u0014\u000b\u0003\u0003\u000bC!\"!(\u0002\b\u0006\u0005IQIAP\u0003!!xn\u0015;sS:<GCAA\u000e\u0011)\t\u0019+a\"\u0002\u0002\u0013\u0005\u0015QU\u0001\u0006CB\u0004H.\u001f\u000b\u0006e\u0005\u001d\u0016\u0011\u0016\u0005\u0007I\u0005\u0005\u0006\u0019\u0001\u0014\t\r1\n\t\u000b1\u0001'\u0011)\ti+a\"\u0002\u0002\u0013\u0005\u0015qV\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\t\t,!0\u0011\u000bm\t\u0019,a.\n\u0007\u0005UFD\u0001\u0004PaRLwN\u001c\t\u00067\u0005efEJ\u0005\u0004\u0003wc\"A\u0002+va2,'\u0007C\u0005\u0002@\u0006-\u0016\u0011!a\u0001e\u0005\u0019\u0001\u0010\n\u0019\t\u0015\u0005\r\u0017qQA\u0001\n\u0013\t)-A\u0006sK\u0006$'+Z:pYZ,GCAAd!\u0011\ti\"!3\n\t\u0005-\u0017q\u0004\u0002\u0007\u001f\nTWm\u0019;")
public class ArrayIntersect
extends BinaryExpression
implements ArrayBinaryLike,
ComplexTypeMergingExpression,
scala.Serializable {
    private transient Function2<ArrayData, ArrayData, ArrayData> evalIntersect;
    private final Expression left;
    private final Expression right;
    private transient Seq<DataType> inputTypesForMerging;
    private transient boolean canUseSpecializedHashSet;
    private transient Ordering<Object> ordering;
    private Tuple2<String, String> org$apache$spark$sql$catalyst$expressions$ArraySetLike$$x$71;
    private transient String hsPostFix;
    private transient String hsTypeName;
    private transient String hsValueCast;
    private transient String nullValueHolder;
    private transient DataType elementType;
    private volatile boolean bitmap$0;
    private volatile transient int bitmap$trans$0;

    public static Option<Tuple2<Expression, Expression>> unapply(ArrayIntersect arrayIntersect) {
        return ArrayIntersect$.MODULE$.unapply(arrayIntersect);
    }

    public static Function1<Tuple2<Expression, Expression>, ArrayIntersect> tupled() {
        return ArrayIntersect$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, ArrayIntersect>> curried() {
        return ArrayIntersect$.MODULE$.curried();
    }

    @Override
    public void dataTypeCheck() {
        ComplexTypeMergingExpression.dataTypeCheck$(this);
    }

    @Override
    public /* synthetic */ TypeCheckResult org$apache$spark$sql$catalyst$expressions$ArrayBinaryLike$$super$checkInputDataTypes() {
        return BinaryArrayExpressionWithImplicitCast.checkInputDataTypes$(this);
    }

    @Override
    public DataType dt() {
        return ArrayBinaryLike.dt$(this);
    }

    @Override
    public DataType et() {
        return ArrayBinaryLike.et$(this);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ArrayBinaryLike.checkInputDataTypes$(this);
    }

    @Override
    public String genGetValue(String array, String i) {
        return ArraySetLike.genGetValue$(this, array, i);
    }

    @Override
    public String withResultArrayNullCheck(String body, String value, String nullElementIndex) {
        return ArraySetLike.withResultArrayNullCheck$(this, body, value, nullElementIndex);
    }

    @Override
    public String buildResultArray(String builder, String value, String size, String nullElementIndex) {
        return ArraySetLike.buildResultArray$(this, builder, value, size, nullElementIndex);
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return BinaryArrayExpressionWithImplicitCast.inputTypes$(this);
    }

    private Seq<DataType> inputTypesForMerging$lzycompute() {
        ArrayIntersect arrayIntersect = this;
        synchronized (arrayIntersect) {
            if ((this.bitmap$trans$0 & 2) == 0) {
                this.inputTypesForMerging = ComplexTypeMergingExpression.inputTypesForMerging$(this);
                this.bitmap$trans$0 |= 2;
            }
        }
        return this.inputTypesForMerging;
    }

    @Override
    public Seq<DataType> inputTypesForMerging() {
        return (this.bitmap$trans$0 & 2) == 0 ? this.inputTypesForMerging$lzycompute() : this.inputTypesForMerging;
    }

    private boolean canUseSpecializedHashSet$lzycompute() {
        ArrayIntersect arrayIntersect = this;
        synchronized (arrayIntersect) {
            if ((this.bitmap$trans$0 & 4) == 0) {
                this.canUseSpecializedHashSet = ArraySetLike.canUseSpecializedHashSet$(this);
                this.bitmap$trans$0 |= 4;
            }
        }
        return this.canUseSpecializedHashSet;
    }

    @Override
    public boolean canUseSpecializedHashSet() {
        return (this.bitmap$trans$0 & 4) == 0 ? this.canUseSpecializedHashSet$lzycompute() : this.canUseSpecializedHashSet;
    }

    private Ordering<Object> ordering$lzycompute() {
        ArrayIntersect arrayIntersect = this;
        synchronized (arrayIntersect) {
            if ((this.bitmap$trans$0 & 8) == 0) {
                this.ordering = ArraySetLike.ordering$(this);
                this.bitmap$trans$0 |= 8;
            }
        }
        return this.ordering;
    }

    @Override
    public Ordering<Object> ordering() {
        return (this.bitmap$trans$0 & 8) == 0 ? this.ordering$lzycompute() : this.ordering;
    }

    private Tuple2<String, String> org$apache$spark$sql$catalyst$expressions$ArraySetLike$$x$71$lzycompute() {
        ArrayIntersect arrayIntersect = this;
        synchronized (arrayIntersect) {
            if (!this.bitmap$0) {
                this.org$apache$spark$sql$catalyst$expressions$ArraySetLike$$x$71 = ArraySetLike.org$apache$spark$sql$catalyst$expressions$ArraySetLike$$x$71$(this);
                this.bitmap$0 = true;
            }
        }
        return this.org$apache$spark$sql$catalyst$expressions$ArraySetLike$$x$71;
    }

    @Override
    public /* synthetic */ Tuple2 org$apache$spark$sql$catalyst$expressions$ArraySetLike$$x$71() {
        return !this.bitmap$0 ? this.org$apache$spark$sql$catalyst$expressions$ArraySetLike$$x$71$lzycompute() : this.org$apache$spark$sql$catalyst$expressions$ArraySetLike$$x$71;
    }

    private String hsPostFix$lzycompute() {
        ArrayIntersect arrayIntersect = this;
        synchronized (arrayIntersect) {
            if ((this.bitmap$trans$0 & 0x10) == 0) {
                this.hsPostFix = ArraySetLike.hsPostFix$(this);
                this.bitmap$trans$0 |= 0x10;
            }
        }
        return this.hsPostFix;
    }

    @Override
    public String hsPostFix() {
        return (this.bitmap$trans$0 & 0x10) == 0 ? this.hsPostFix$lzycompute() : this.hsPostFix;
    }

    private String hsTypeName$lzycompute() {
        ArrayIntersect arrayIntersect = this;
        synchronized (arrayIntersect) {
            if ((this.bitmap$trans$0 & 0x20) == 0) {
                this.hsTypeName = ArraySetLike.hsTypeName$(this);
                this.bitmap$trans$0 |= 0x20;
            }
        }
        return this.hsTypeName;
    }

    @Override
    public String hsTypeName() {
        return (this.bitmap$trans$0 & 0x20) == 0 ? this.hsTypeName$lzycompute() : this.hsTypeName;
    }

    private String hsValueCast$lzycompute() {
        ArrayIntersect arrayIntersect = this;
        synchronized (arrayIntersect) {
            if ((this.bitmap$trans$0 & 0x40) == 0) {
                this.hsValueCast = ArraySetLike.hsValueCast$(this);
                this.bitmap$trans$0 |= 0x40;
            }
        }
        return this.hsValueCast;
    }

    @Override
    public String hsValueCast() {
        return (this.bitmap$trans$0 & 0x40) == 0 ? this.hsValueCast$lzycompute() : this.hsValueCast;
    }

    private String nullValueHolder$lzycompute() {
        ArrayIntersect arrayIntersect = this;
        synchronized (arrayIntersect) {
            if ((this.bitmap$trans$0 & 0x80) == 0) {
                this.nullValueHolder = ArraySetLike.nullValueHolder$(this);
                this.bitmap$trans$0 |= 0x80;
            }
        }
        return this.nullValueHolder;
    }

    @Override
    public String nullValueHolder() {
        return (this.bitmap$trans$0 & 0x80) == 0 ? this.nullValueHolder$lzycompute() : this.nullValueHolder;
    }

    private DataType elementType$lzycompute() {
        ArrayIntersect arrayIntersect = this;
        synchronized (arrayIntersect) {
            if ((this.bitmap$trans$0 & 0x100) == 0) {
                this.elementType = BinaryArrayExpressionWithImplicitCast.elementType$(this);
                this.bitmap$trans$0 |= 0x100;
            }
        }
        return this.elementType;
    }

    @Override
    public DataType elementType() {
        return (this.bitmap$trans$0 & 0x100) == 0 ? this.elementType$lzycompute() : this.elementType;
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public DataType dataType() {
        this.dataTypeCheck();
        return new ArrayType(this.elementType(), ((ArrayType)this.left().dataType()).containsNull() && ((ArrayType)this.right().dataType()).containsNull());
    }

    private Function2<ArrayData, ArrayData, ArrayData> evalIntersect$lzycompute() {
        ArrayIntersect arrayIntersect = this;
        synchronized (arrayIntersect) {
            if ((this.bitmap$trans$0 & 1) == 0) {
                this.evalIntersect = TypeUtils$.MODULE$.typeWithProperEquals(this.elementType()) ? (Function2 & Serializable & scala.Serializable)(array1, array2) -> {
                    GenericArrayData genericArrayData;
                    if (array1.numElements() != 0 && array2.numElements() != 0) {
                        int i;
                        OpenHashSet hs = new OpenHashSet(ClassTag$.MODULE$.Any());
                        OpenHashSet hsResult = new OpenHashSet(ClassTag$.MODULE$.Any());
                        boolean foundNullElement = false;
                        for (i = 0; i < array2.numElements(); ++i) {
                            if (array2.isNullAt(i)) {
                                foundNullElement = true;
                                continue;
                            }
                            Object elem = array2.get(i, this.elementType());
                            hs.add(elem);
                        }
                        ArrayBuffer arrayBuffer = new ArrayBuffer();
                        for (i = 0; i < array1.numElements(); ++i) {
                            if (array1.isNullAt(i)) {
                                if (!foundNullElement) continue;
                                arrayBuffer.$plus$eq(null);
                                foundNullElement = false;
                                continue;
                            }
                            Object elem = array1.get(i, this.elementType());
                            if (!hs.contains(elem) || hsResult.contains(elem)) continue;
                            arrayBuffer.$plus$eq(elem);
                            hsResult.add(elem);
                        }
                        genericArrayData = new GenericArrayData((Seq<Object>)arrayBuffer);
                    } else {
                        genericArrayData = new GenericArrayData((Object)Array$.MODULE$.emptyObjectArray());
                    }
                    return genericArrayData;
                } : (Function2 & Serializable & scala.Serializable)(array1, array2) -> {
                    GenericArrayData genericArrayData;
                    if (array1.numElements() != 0 && array2.numElements() != 0) {
                        ArrayBuffer arrayBuffer = new ArrayBuffer();
                        boolean alreadySeenNull = false;
                        for (int i = 0; i < array1.numElements(); ++i) {
                            boolean found = false;
                            Object elem1 = array1.get(i, this.elementType());
                            if (array1.isNullAt(i)) {
                                if (!alreadySeenNull) {
                                    for (int j = 0; !found && j < array2.numElements(); ++j) {
                                        found = array2.isNullAt(j);
                                    }
                                    alreadySeenNull = true;
                                }
                            } else {
                                for (int j = 0; !found && j < array2.numElements(); ++j) {
                                    if (array2.isNullAt(j)) continue;
                                    Object elem2 = array2.get(j, this.elementType());
                                    if (!this.ordering().equiv(elem1, elem2)) continue;
                                    boolean foundArrayBuffer = false;
                                    for (int k = 0; !foundArrayBuffer && k < arrayBuffer.size(); ++k) {
                                        Object va = arrayBuffer.apply(k);
                                        foundArrayBuffer = va != null && this.ordering().equiv(va, elem1);
                                    }
                                    found = !foundArrayBuffer;
                                }
                            }
                            Object object = found ? arrayBuffer.$plus$eq(elem1) : BoxedUnit.UNIT;
                        }
                        genericArrayData = new GenericArrayData((Seq<Object>)arrayBuffer);
                    } else {
                        genericArrayData = new GenericArrayData((Object)Array$.MODULE$.emptyObjectArray());
                    }
                    return genericArrayData;
                };
                this.bitmap$trans$0 |= 1;
            }
        }
        return this.evalIntersect;
    }

    public Function2<ArrayData, ArrayData, ArrayData> evalIntersect() {
        return (this.bitmap$trans$0 & 1) == 0 ? this.evalIntersect$lzycompute() : this.evalIntersect;
    }

    @Override
    public Object nullSafeEval(Object input1, Object input2) {
        ArrayData array1 = (ArrayData)input1;
        ArrayData array2 = (ArrayData)input2;
        return this.evalIntersect().apply((Object)array1, (Object)array2);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode exprCode;
        String i = ctx.freshName("i");
        String value = ctx.freshName("value");
        String size = ctx.freshName("size");
        if (this.canUseSpecializedHashSet()) {
            String jt = CodeGenerator$.MODULE$.javaType(this.elementType());
            String ptName = CodeGenerator$.MODULE$.primitiveTypeName(jt);
            exprCode = this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(array1, array2) -> {
                String foundNullElement = ctx.freshName("foundNullElement");
                String nullElementIndex = ctx.freshName("nullElementIndex");
                String builder = ctx.freshName("builder");
                String openHashSet = OpenHashSet.class.getName();
                String classTag = new StringBuilder(34).append("scala.reflect.ClassTag$.MODULE$.").append(this.hsTypeName()).append("()").toString();
                String hashSet = ctx.freshName("hashSet");
                String hashSetResult = ctx.freshName("hashSetResult");
                String arrayBuilder = ArrayBuilder.class.getName();
                String arrayBuilderClass = new StringBuilder(3).append(arrayBuilder).append("$of").append(ptName).toString();
                String writeArray2ToHashSet = this.withArray2NullCheck$1(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(54).append("\n             |").append(jt).append(" ").append(value).append(" = ").append(this.genGetValue((String)array2, i)).append(";\n             |").append(hashSet).append(".add").append(this.hsPostFix()).append("(").append(this.hsValueCast()).append(value).append(");\n           ").toString())).stripMargin(), i, foundNullElement, (String)array2);
                String processArray1 = this.withArray1NullAssignment$1(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(240).append("\n             |").append(jt).append(" ").append(value).append(" = ").append(this.genGetValue((String)array1, i)).append(";\n             |if (").append(hashSet).append(".contains(").append(this.hsValueCast()).append(value).append(") &&\n             |    !").append(hashSetResult).append(".contains(").append(this.hsValueCast()).append(value).append(")) {\n             |  if (++").append(size).append(" > ").append(ByteArrayMethods.MAX_ROUNDED_ARRAY_LENGTH).append(") {\n             |    break;\n             |  }\n             |  ").append(hashSetResult).append(".add").append(this.hsPostFix()).append("(").append(this.hsValueCast()).append(value).append(");\n             |  ").append(builder).append(".$plus$eq(").append(value).append(");\n             |}\n           ").toString())).stripMargin(), i, size, foundNullElement, nullElementIndex, builder, (String)array1);
                String declareNullTrackVariables = ((ArrayType)this.dataType()).containsNull() ? new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(69).append("\n             |boolean ").append(foundNullElement).append(" = false;\n             |int ").append(nullElementIndex).append(" = -1;\n           ").toString())).stripMargin() : "";
                return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(292).append("\n           |").append(openHashSet).append(" ").append(hashSet).append(" = new ").append(openHashSet).append(this.hsPostFix()).append("(").append(classTag).append(");\n           |").append(openHashSet).append(" ").append(hashSetResult).append(" = new ").append(openHashSet).append(this.hsPostFix()).append("(").append(classTag).append(");\n           |").append(declareNullTrackVariables).append("\n           |for (int ").append(i).append(" = 0; ").append(i).append(" < ").append((String)array2).append(".numElements(); ").append(i).append("++) {\n           |  ").append(writeArray2ToHashSet).append("\n           |}\n           |").append(arrayBuilderClass).append(" ").append(builder).append(" = new ").append(arrayBuilderClass).append("();\n           |int ").append(size).append(" = 0;\n           |for (int ").append(i).append(" = 0; ").append(i).append(" < ").append((String)array1).append(".numElements(); ").append(i).append("++) {\n           |  ").append(processArray1).append("\n           |}\n           |").append(this.buildResultArray(builder, ExprValue$.MODULE$.exprValueToString(ev.value()), size, nullElementIndex)).append("\n         ").toString())).stripMargin();
            });
        } else {
            exprCode = this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(array1, array2) -> {
                String expr = ctx.addReferenceObj("arrayIntersectExpr", this, ctx.addReferenceObj$default$3());
                return new StringBuilder(32).append(ev.value()).append(" = (ArrayData)").append(expr).append(".nullSafeEval(").append((String)array1).append(", ").append((String)array2).append(");").toString();
            });
        }
        return exprCode;
    }

    @Override
    public String prettyName() {
        return "array_intersect";
    }

    public ArrayIntersect copy(Expression left, Expression right) {
        return new ArrayIntersect(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "ArrayIntersect";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.left();
                break;
            }
            case 1: {
                expression = this.right();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ArrayIntersect;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ArrayIntersect)) return false;
        boolean bl = true;
        if (!bl) return false;
        ArrayIntersect arrayIntersect = (ArrayIntersect)x$1;
        Expression expression = this.left();
        Expression expression2 = arrayIntersect.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = arrayIntersect.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!arrayIntersect.canEqual(this)) return false;
        return true;
    }

    private final String withArray2NullCheck$1(String body, String i$4, String foundNullElement$5, String array2$1) {
        return ((ArrayType)this.right().dataType()).containsNull() ? (((ArrayType)this.left().dataType()).containsNull() ? new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(150).append("\n                 |if (").append(array2$1).append(".isNullAt(").append(i$4).append(")) {\n                 |  ").append(foundNullElement$5).append(" = true;\n                 |} else {\n                 |  ").append(body).append("\n                 |}\n               ").toString())).stripMargin() : new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(95).append("\n                 |if (!").append(array2$1).append(".isNullAt(").append(i$4).append(")) {\n                 |  ").append(body).append("\n                 |}\n               ").toString())).stripMargin()) : body;
    }

    private final String withArray1NullAssignment$1(String body, String i$4, String size$3, String foundNullElement$5, String nullElementIndex$3, String builder$3, String array1$1) {
        return ((ArrayType)this.left().dataType()).containsNull() ? (((ArrayType)this.right().dataType()).containsNull() ? new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(291).append("\n                 |if (").append(array1$1).append(".isNullAt(").append(i$4).append(")) {\n                 |  if (").append(foundNullElement$5).append(") {\n                 |    ").append(nullElementIndex$3).append(" = ").append(size$3).append(";\n                 |    ").append(foundNullElement$5).append(" = false;\n                 |    ").append(size$3).append("++;\n                 |    ").append(builder$3).append(".$plus$eq(").append(this.nullValueHolder()).append(");\n                 |  }\n                 |} else {\n                 |  ").append(body).append("\n                 |}\n               ").toString())).stripMargin() : new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(95).append("\n                 |if (!").append(array1$1).append(".isNullAt(").append(i$4).append(")) {\n                 |  ").append(body).append("\n                 |}\n               ").toString())).stripMargin()) : body;
    }

    public ArrayIntersect(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        ExpectsInputTypes.$init$(this);
        BinaryArrayExpressionWithImplicitCast.$init$(this);
        ArraySetLike.$init$(this);
        ArrayBinaryLike.$init$(this);
        ComplexTypeMergingExpression.$init$(this);
    }
}

