/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCoercion$;
import org.apache.spark.sql.catalyst.expressions.ArrayRemove$;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(array, element) - Remove all elements that equal to element from array.", examples="\n    Examples:\n      > SELECT _FUNC_(array(1, 2, 3, null, 3), 3);\n       [1,2,null]\n  ", since="2.4.0")
@ScalaSignature(bytes="\u0006\u0001\t\ra\u0001B\u0001\u0003\u0001>\u00111\"\u0011:sCf\u0014V-\\8wK*\u00111\u0001B\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002\u0006\r\u0005A1-\u0019;bYf\u001cHO\u0003\u0002\b\u0011\u0005\u00191/\u001d7\u000b\u0005%Q\u0011!B:qCJ\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c\u0001aE\u0003\u0001!Q9R\u0004\u0005\u0002\u0012%5\t!!\u0003\u0002\u0014\u0005\t\u0001\")\u001b8bef,\u0005\u0010\u001d:fgNLwN\u001c\t\u0003#UI!A\u0006\u0002\u0003-%k\u0007\u000f\\5dSR\u001c\u0015m\u001d;J]B,H\u000fV=qKN\u0004\"\u0001G\u000e\u000e\u0003eQ\u0011AG\u0001\u0006g\u000e\fG.Y\u0005\u00039e\u0011q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002\u0019=%\u0011q$\u0007\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\tC\u0001\u0011)\u001a!C\u0001E\u0005!A.\u001a4u+\u0005\u0019\u0003CA\t%\u0013\t)#A\u0001\u0006FqB\u0014Xm]:j_:D\u0001b\n\u0001\u0003\u0012\u0003\u0006IaI\u0001\u0006Y\u00164G\u000f\t\u0005\tS\u0001\u0011)\u001a!C\u0001E\u0005)!/[4ii\"A1\u0006\u0001B\tB\u0003%1%\u0001\u0004sS\u001eDG\u000f\t\u0005\u0006[\u0001!\tAL\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007=\u0002\u0014\u0007\u0005\u0002\u0012\u0001!)\u0011\u0005\fa\u0001G!)\u0011\u0006\fa\u0001G!)1\u0007\u0001C!i\u0005AA-\u0019;b)f\u0004X-F\u00016!\t1\u0014(D\u00018\u0015\tAd!A\u0003usB,7/\u0003\u0002;o\tAA)\u0019;b)f\u0004X\rC\u0003=\u0001\u0011\u0005S(\u0001\u0006j]B,H\u000fV=qKN,\u0012A\u0010\t\u0004\u007f\u001dSeB\u0001!F\u001d\t\tE)D\u0001C\u0015\t\u0019e\"\u0001\u0004=e>|GOP\u0005\u00025%\u0011a)G\u0001\ba\u0006\u001c7.Y4f\u0013\tA\u0015JA\u0002TKFT!AR\r\u0011\u0005YZ\u0015B\u0001'8\u0005A\t%m\u001d;sC\u000e$H)\u0019;b)f\u0004X\rC\u0003O\u0001\u0011\u0005s*A\ndQ\u0016\u001c7.\u00138qkR$\u0015\r^1UsB,7\u000fF\u0001Q!\t\tF+D\u0001S\u0015\t\u0019F!\u0001\u0005b]\u0006d\u0017p]5t\u0013\t)&KA\bUsB,7\t[3dWJ+7/\u001e7u\u0011\u00159\u0006\u0001\"\u00035\u0003-)G.Z7f]R$\u0016\u0010]3\t\u0011e\u0003\u0001R1A\u0005\ni\u000b\u0001b\u001c:eKJLgnZ\u000b\u00027B\u0019q\b\u00180\n\u0005uK%\u0001C(sI\u0016\u0014\u0018N\\4\u0011\u0005ay\u0016B\u00011\u001a\u0005\r\te.\u001f\u0015\u00031\n\u0004\"\u0001G2\n\u0005\u0011L\"!\u0003;sC:\u001c\u0018.\u001a8u\u0011\u00151\u0007\u0001\"\u0011h\u00031qW\u000f\u001c7TC\u001a,WI^1m)\rq\u0006N\u001b\u0005\u0006S\u0016\u0004\rAX\u0001\u0004CJ\u0014\b\"B6f\u0001\u0004q\u0016!\u0002<bYV,\u0007\"B7\u0001\t\u0003r\u0017!\u00033p\u000f\u0016t7i\u001c3f)\ryWO\u001f\t\u0003aNl\u0011!\u001d\u0006\u0003e\n\tqaY8eK\u001e,g.\u0003\u0002uc\nAQ\t\u001f9s\u0007>$W\rC\u0003wY\u0002\u0007q/A\u0002dib\u0004\"\u0001\u001d=\n\u0005e\f(AD\"pI\u0016<WM\\\"p]R,\u0007\u0010\u001e\u0005\u0006w2\u0004\ra\\\u0001\u0003KZDQ! \u0001\u0005\u0002y\f\u0001cZ3o\u0007>$WMR8s%\u0016\u001cX\u000f\u001c;\u0015\u0017}\fy!!\u0005\u0002\u0014\u0005]\u0011\u0011\u0004\t\u0005\u0003\u0003\tIA\u0004\u0003\u0002\u0004\u0005\u0015\u0001CA!\u001a\u0013\r\t9!G\u0001\u0007!J,G-\u001a4\n\t\u0005-\u0011Q\u0002\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005\u001d\u0011\u0004C\u0003wy\u0002\u0007q\u000fC\u0003|y\u0002\u0007q\u000e\u0003\u0004\u0002\u0016q\u0004\ra`\u0001\u000bS:\u0004X\u000f^!se\u0006L\b\"B6}\u0001\u0004y\bBBA\u000ey\u0002\u0007q0\u0001\u0007oK^\f%O]1z'&TX\rC\u0004\u0002 \u0001!\t%!\t\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-F\u0001\u0000\u0011%\t)\u0003AA\u0001\n\u0003\t9#\u0001\u0003d_BLH#B\u0018\u0002*\u0005-\u0002\u0002C\u0011\u0002$A\u0005\t\u0019A\u0012\t\u0011%\n\u0019\u0003%AA\u0002\rB\u0011\"a\f\u0001#\u0003%\t!!\r\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u00111\u0007\u0016\u0004G\u0005U2FAA\u001c!\u0011\tI$a\u0011\u000e\u0005\u0005m\"\u0002BA\u001f\u0003\u007f\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u0005\u0013$\u0001\u0006b]:|G/\u0019;j_:LA!!\u0012\u0002<\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0013\u0005%\u0003!%A\u0005\u0002\u0005E\u0012AD2paf$C-\u001a4bk2$HE\r\u0005\n\u0003\u001b\u0002\u0011\u0011!C!\u0003\u001f\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA)!\u0011\t\u0019&!\u0018\u000e\u0005\u0005U#\u0002BA,\u00033\nA\u0001\\1oO*\u0011\u00111L\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\f\u0005U\u0003\"CA1\u0001\u0005\u0005I\u0011AA2\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\t)\u0007E\u0002\u0019\u0003OJ1!!\u001b\u001a\u0005\rIe\u000e\u001e\u0005\n\u0003[\u0002\u0011\u0011!C\u0001\u0003_\na\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000fF\u0002_\u0003cB!\"a\u001d\u0002l\u0005\u0005\t\u0019AA3\u0003\rAH%\r\u0005\n\u0003o\u0002\u0011\u0011!C!\u0003s\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003w\u0002R!! \u0002\u0004zk!!a \u000b\u0007\u0005\u0005\u0015$\u0001\u0006d_2dWm\u0019;j_:LA!!\"\u0002\u0000\tA\u0011\n^3sCR|'\u000fC\u0005\u0002\n\u0002\t\t\u0011\"\u0001\u0002\f\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002\u000e\u0006M\u0005c\u0001\r\u0002\u0010&\u0019\u0011\u0011S\r\u0003\u000f\t{w\u000e\\3b]\"I\u00111OAD\u0003\u0003\u0005\rA\u0018\u0005\n\u0003/\u0003\u0011\u0011!C!\u00033\u000ba!Z9vC2\u001cH\u0003BAG\u00037C\u0011\"a\u001d\u0002\u0016\u0006\u0005\t\u0019\u00010)\u001f\u0001\ty*!*\u0002(\u0006-\u0016QVAY\u0003g\u00032!EAQ\u0013\r\t\u0019K\u0001\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\tI+\u0001(`\rVs5i\u0018\u0015beJ\f\u0017\u0010\f\u0011fY\u0016lWM\u001c;*A5\u0002#+Z7pm\u0016\u0004\u0013\r\u001c7!K2,W.\u001a8ug\u0002\"\b.\u0019;!KF,\u0018\r\u001c\u0011u_\u0002*G.Z7f]R\u0004cM]8nA\u0005\u0014(/Y=/\u0003!)\u00070Y7qY\u0016\u001c\u0018EAAX\u0003YS\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006&\u0019:sCfD\u0013\u0007\f\u00113Y\u0001\u001aD\u0006\t8vY2d\u0003eM\u0015-AMJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005I.2YIbc.\u001e7m;*\u0001\u0003%A\u0003tS:\u001cW-\t\u0002\u00026\u0006)!G\f\u001b/a\u001dI\u0011\u0011\u0018\u0002\u0002\u0002#\u0005\u00111X\u0001\f\u0003J\u0014\u0018-\u001f*f[>4X\rE\u0002\u0012\u0003{3\u0001\"\u0001\u0002\u0002\u0002#\u0005\u0011qX\n\u0006\u0003{\u000b\t-\b\t\b\u0003\u0007\fImI\u00120\u001b\t\t)MC\u0002\u0002Hf\tqA];oi&lW-\u0003\u0003\u0002L\u0006\u0015'!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oe!9Q&!0\u0005\u0002\u0005=GCAA^\u0011)\t\u0019.!0\u0002\u0002\u0013\u0015\u0013Q[\u0001\ti>\u001cFO]5oOR\u0011\u0011\u0011\u000b\u0005\u000b\u00033\fi,!A\u0005\u0002\u0006m\u0017!B1qa2LH#B\u0018\u0002^\u0006}\u0007BB\u0011\u0002X\u0002\u00071\u0005\u0003\u0004*\u0003/\u0004\ra\t\u0005\u000b\u0003G\fi,!A\u0005\u0002\u0006\u0015\u0018aB;oCB\u0004H.\u001f\u000b\u0005\u0003O\f\u0019\u0010E\u0003\u0019\u0003S\fi/C\u0002\u0002lf\u0011aa\u00149uS>t\u0007#\u0002\r\u0002p\u000e\u001a\u0013bAAy3\t1A+\u001e9mKJB\u0011\"!>\u0002b\u0006\u0005\t\u0019A\u0018\u0002\u0007a$\u0003\u0007\u0003\u0006\u0002z\u0006u\u0016\u0011!C\u0005\u0003w\f1B]3bIJ+7o\u001c7wKR\u0011\u0011Q \t\u0005\u0003'\ny0\u0003\u0003\u0003\u0002\u0005U#AB(cU\u0016\u001cG\u000f")
public class ArrayRemove
extends BinaryExpression
implements ImplicitCastInputTypes,
scala.Serializable {
    private transient Ordering<Object> ordering;
    private final Expression left;
    private final Expression right;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Tuple2<Expression, Expression>> unapply(ArrayRemove arrayRemove) {
        return ArrayRemove$.MODULE$.unapply(arrayRemove);
    }

    public static Function1<Tuple2<Expression, Expression>, ArrayRemove> tupled() {
        return ArrayRemove$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, ArrayRemove>> curried() {
        return ArrayRemove$.MODULE$.curried();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public DataType dataType() {
        return this.left().dataType();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Seq<AbstractDataType> inputTypes() {
        Seq seq;
        Tuple2 tuple2 = new Tuple2((Object)this.left().dataType(), (Object)this.right().dataType());
        if (tuple2 == null) return (Seq)Seq$.MODULE$.empty();
        DataType dataType = (DataType)tuple2._1();
        DataType e2 = (DataType)tuple2._2();
        if (!(dataType instanceof ArrayType)) return (Seq)Seq$.MODULE$.empty();
        ArrayType arrayType = (ArrayType)dataType;
        DataType e1 = arrayType.elementType();
        boolean hasNull = arrayType.containsNull();
        Option option = (Option)TypeCoercion$.MODULE$.findTightestCommonType().apply((Object)e1, (Object)e2);
        if (option instanceof Some) {
            Some some = (Some)option;
            DataType dt = (DataType)some.value();
            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DataType[]{new ArrayType(dt, hasNull), dt}));
            return seq;
        } else {
            seq = (Seq)Seq$.MODULE$.empty();
        }
        return seq;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public TypeCheckResult checkInputDataTypes() {
        Tuple2 tuple2 = new Tuple2((Object)this.left().dataType(), (Object)this.right().dataType());
        if (tuple2 == null) return new TypeCheckResult.TypeCheckFailure(new StringBuilder(31).append("Input to function ").append(this.prettyName()).append(" should have ").append(new StringBuilder(59).append("been ").append(ArrayType$.MODULE$.simpleString()).append(" followed by a value with same element type, but it's ").toString()).append(new StringBuilder(5).append("[").append(this.left().dataType().catalogString()).append(", ").append(this.right().dataType().catalogString()).append("].").toString()).toString());
        DataType dataType = (DataType)tuple2._1();
        DataType e2 = (DataType)tuple2._2();
        if (!(dataType instanceof ArrayType)) return new TypeCheckResult.TypeCheckFailure(new StringBuilder(31).append("Input to function ").append(this.prettyName()).append(" should have ").append(new StringBuilder(59).append("been ").append(ArrayType$.MODULE$.simpleString()).append(" followed by a value with same element type, but it's ").toString()).append(new StringBuilder(5).append("[").append(this.left().dataType().catalogString()).append(", ").append(this.right().dataType().catalogString()).append("].").toString()).toString());
        ArrayType arrayType = (ArrayType)dataType;
        DataType e1 = arrayType.elementType();
        if (!e1.sameType(e2)) return new TypeCheckResult.TypeCheckFailure(new StringBuilder(31).append("Input to function ").append(this.prettyName()).append(" should have ").append(new StringBuilder(59).append("been ").append(ArrayType$.MODULE$.simpleString()).append(" followed by a value with same element type, but it's ").toString()).append(new StringBuilder(5).append("[").append(this.left().dataType().catalogString()).append(", ").append(this.right().dataType().catalogString()).append("].").toString()).toString());
        return TypeUtils$.MODULE$.checkForOrderingExpr(e2, new StringBuilder(9).append("function ").append(this.prettyName()).toString());
    }

    private DataType elementType() {
        return ((ArrayType)this.left().dataType()).elementType();
    }

    private Ordering<Object> ordering$lzycompute() {
        ArrayRemove arrayRemove = this;
        synchronized (arrayRemove) {
            if (!this.bitmap$trans$0) {
                this.ordering = TypeUtils$.MODULE$.getInterpretedOrdering(this.right().dataType());
                this.bitmap$trans$0 = true;
            }
        }
        return this.ordering;
    }

    private Ordering<Object> ordering() {
        return !this.bitmap$trans$0 ? this.ordering$lzycompute() : this.ordering;
    }

    @Override
    public Object nullSafeEval(Object arr, Object value) {
        Object[] newArray = new Object[((ArrayData)arr).numElements()];
        IntRef pos = IntRef.create((int)0);
        ((ArrayData)arr).foreach(this.right().dataType(), (Function2<Object, Object, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(i, v) -> {
            ArrayRemove.$anonfun$nullSafeEval$8(this, value, newArray, pos, BoxesRunTime.unboxToInt((Object)i), v);
            return BoxedUnit.UNIT;
        });
        return new GenericArrayData((Object[])Predef$.MODULE$.genericArrayOps((Object)newArray).slice(0, pos.elem));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(arr, value) -> {
            String numsToRemove = ctx.freshName("numsToRemove");
            String newArraySize = ctx.freshName("newArraySize");
            String i = ctx.freshName("i");
            String getValue = CodeGenerator$.MODULE$.getValue((String)arr, this.elementType(), i);
            String isEqual = ctx.genEqual(this.elementType(), (String)value, getValue);
            return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(211).append("\n         |int ").append(numsToRemove).append(" = 0;\n         |for (int ").append(i).append(" = 0; ").append(i).append(" < ").append((String)arr).append(".numElements(); ").append(i).append(" ++) {\n         |  if (!").append((String)arr).append(".isNullAt(").append(i).append(") && ").append(isEqual).append(") {\n         |    ").append(numsToRemove).append(" = ").append(numsToRemove).append(" + 1;\n         |  }\n         |}\n         |int ").append(newArraySize).append(" = ").append((String)arr).append(".numElements() - ").append(numsToRemove).append(";\n         |").append(this.genCodeForResult(ctx, ev, (String)arr, (String)value, newArraySize)).append("\n       ").toString())).stripMargin();
        });
    }

    public String genCodeForResult(CodegenContext ctx, ExprCode ev, String inputArray, String value, String newArraySize) {
        String values = ctx.freshName("values");
        String i = ctx.freshName("i");
        String pos = ctx.freshName("pos");
        String getValue = CodeGenerator$.MODULE$.getValue(inputArray, this.elementType(), i);
        String isEqual = ctx.genEqual(this.elementType(), value, getValue);
        String allocation = CodeGenerator$.MODULE$.createArrayData(values, this.elementType(), newArraySize, new StringBuilder(9).append(" ").append(this.prettyName()).append(" failed.").toString());
        String assignment = CodeGenerator$.MODULE$.createArrayAssignment(values, this.elementType(), inputArray, pos, i, false);
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(297).append("\n       |").append(allocation).append("\n       |int ").append(pos).append(" = 0;\n       |for (int ").append(i).append(" = 0; ").append(i).append(" < ").append(inputArray).append(".numElements(); ").append(i).append(" ++) {\n       |  if (").append(inputArray).append(".isNullAt(").append(i).append(")) {\n       |    ").append(values).append(".setNullAt(").append(pos).append(");\n       |    ").append(pos).append(" = ").append(pos).append(" + 1;\n       |  }\n       |  else {\n       |    if (!(").append(isEqual).append(")) {\n       |      ").append(assignment).append("\n       |      ").append(pos).append(" = ").append(pos).append(" + 1;\n       |    }\n       |  }\n       |}\n       |").append(ev.value()).append(" = ").append(values).append(";\n     ").toString())).stripMargin();
    }

    @Override
    public String prettyName() {
        return "array_remove";
    }

    public ArrayRemove copy(Expression left, Expression right) {
        return new ArrayRemove(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "ArrayRemove";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.left();
                break;
            }
            case 1: {
                expression = this.right();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ArrayRemove;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ArrayRemove)) return false;
        boolean bl = true;
        if (!bl) return false;
        ArrayRemove arrayRemove = (ArrayRemove)x$1;
        Expression expression = this.left();
        Expression expression2 = arrayRemove.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = arrayRemove.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!arrayRemove.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ void $anonfun$nullSafeEval$8(ArrayRemove $this, Object value$3, Object[] newArray$1, IntRef pos$1, int i, Object v) {
        block0: {
            if (v != null && $this.ordering().equiv(v, value$3)) break block0;
            newArray$1[pos$1.elem] = v;
            ++pos$1.elem;
        }
    }

    public ArrayRemove(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        ExpectsInputTypes.$init$(this);
    }
}

