/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.expressions.Atan2$;
import org.apache.spark.sql.catalyst.expressions.BinaryMathExpression;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(exprY, exprX) - Returns the angle in radians between the positive x-axis of a plane\n      and the point given by the coordinates (`exprX`, `exprY`), as if computed by\n      `java.lang.Math._FUNC_`.\n  ", arguments="\n    Arguments:\n      * exprY - coordinate on y-axis\n      * exprX - coordinate on x-axis\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(0, 0);\n       0.0\n  ")
@ScalaSignature(bytes="\u0006\u0001\u0005Ud\u0001B\u0001\u0003\u0001>\u0011Q!\u0011;b]JR!a\u0001\u0003\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003\u000b\u0019\t\u0001bY1uC2L8\u000f\u001e\u0006\u0003\u000f!\t1a]9m\u0015\tI!\"A\u0003ta\u0006\u00148N\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7\u0001A\n\u0005\u0001A!\"\u0004\u0005\u0002\u0012%5\t!!\u0003\u0002\u0014\u0005\t!\")\u001b8befl\u0015\r\u001e5FqB\u0014Xm]:j_:\u0004\"!\u0006\r\u000e\u0003YQ\u0011aF\u0001\u0006g\u000e\fG.Y\u0005\u00033Y\u0011q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002\u00167%\u0011AD\u0006\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\t=\u0001\u0011)\u001a!C\u0001?\u0005!A.\u001a4u+\u0005\u0001\u0003CA\t\"\u0013\t\u0011#A\u0001\u0006FqB\u0014Xm]:j_:D\u0001\u0002\n\u0001\u0003\u0012\u0003\u0006I\u0001I\u0001\u0006Y\u00164G\u000f\t\u0005\tM\u0001\u0011)\u001a!C\u0001?\u0005)!/[4ii\"A\u0001\u0006\u0001B\tB\u0003%\u0001%\u0001\u0004sS\u001eDG\u000f\t\u0005\u0006U\u0001!\taK\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00071jc\u0006\u0005\u0002\u0012\u0001!)a$\u000ba\u0001A!)a%\u000ba\u0001A!)\u0001\u0007\u0001C)c\u0005aa.\u001e7m'\u00064W-\u0012<bYR\u0019!'N\u001c\u0011\u0005U\u0019\u0014B\u0001\u001b\u0017\u0005\r\te.\u001f\u0005\u0006m=\u0002\rAM\u0001\u0007S:\u0004X\u000f^\u0019\t\u000baz\u0003\u0019\u0001\u001a\u0002\r%t\u0007/\u001e;3\u0011\u0015Q\u0004\u0001\"\u0011<\u0003%!wnR3o\u0007>$W\rF\u0002=\u0005\u001e\u0003\"!\u0010!\u000e\u0003yR!a\u0010\u0002\u0002\u000f\r|G-Z4f]&\u0011\u0011I\u0010\u0002\t\u000bb\u0004(oQ8eK\")1)\u000fa\u0001\t\u0006\u00191\r\u001e=\u0011\u0005u*\u0015B\u0001$?\u00059\u0019u\u000eZ3hK:\u001cuN\u001c;fqRDQ\u0001S\u001dA\u0002q\n!!\u001a<\t\u000f)\u0003\u0011\u0011!C\u0001\u0017\u0006!1m\u001c9z)\raC*\u0014\u0005\b=%\u0003\n\u00111\u0001!\u0011\u001d1\u0013\n%AA\u0002\u0001Bqa\u0014\u0001\u0012\u0002\u0013\u0005\u0001+\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0003ES#\u0001\t*,\u0003M\u0003\"\u0001V-\u000e\u0003US!AV,\u0002\u0013Ut7\r[3dW\u0016$'B\u0001-\u0017\u0003)\tgN\\8uCRLwN\\\u0005\u00035V\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011\u001da\u0006!%A\u0005\u0002A\u000babY8qs\u0012\"WMZ1vYR$#\u0007C\u0004_\u0001\u0005\u0005I\u0011I0\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\u0005\u0001\u0007CA1g\u001b\u0005\u0011'BA2e\u0003\u0011a\u0017M\\4\u000b\u0003\u0015\fAA[1wC&\u0011qM\u0019\u0002\u0007'R\u0014\u0018N\\4\t\u000f%\u0004\u0011\u0011!C\u0001U\u0006a\u0001O]8ek\u000e$\u0018I]5usV\t1\u000e\u0005\u0002\u0016Y&\u0011QN\u0006\u0002\u0004\u0013:$\bbB8\u0001\u0003\u0003%\t\u0001]\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\t\u0011\u0014\u000fC\u0004s]\u0006\u0005\t\u0019A6\u0002\u0007a$\u0013\u0007C\u0004u\u0001\u0005\u0005I\u0011I;\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\u0012A\u001e\t\u0004oj\u0014T\"\u0001=\u000b\u0005e4\u0012AC2pY2,7\r^5p]&\u00111\u0010\u001f\u0002\t\u0013R,'/\u0019;pe\"9Q\u0010AA\u0001\n\u0003q\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\u0007}\f)\u0001E\u0002\u0016\u0003\u0003I1!a\u0001\u0017\u0005\u001d\u0011un\u001c7fC:DqA\u001d?\u0002\u0002\u0003\u0007!\u0007C\u0005\u0002\n\u0001\t\t\u0011\"\u0011\u0002\f\u00051Q-];bYN$2a`A\u0007\u0011!\u0011\u0018qAA\u0001\u0002\u0004\u0011\u0004f\u0004\u0001\u0002\u0012\u0005]\u0011\u0011DA\u000f\u0003?\t\u0019#!\n\u0011\u0007E\t\u0019\"C\u0002\u0002\u0016\t\u0011Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002\u001c\u0005\tIK\u0003\u0011!A\u0001zf)\u0016(D?\"*\u0007\u0010\u001d:ZY\u0001*\u0007\u0010\u001d:YS\u0001j\u0003EU3ukJt7\u000f\t;iK\u0002\ngn\u001a7fA%t\u0007E]1eS\u0006t7\u000f\t2fi^,WM\u001c\u0011uQ\u0016\u0004\u0003o\\:ji&4X\r\t=.CbL7\u000fI8gA\u0005\u0004\u0003\u000f\\1oK*\u0001\u0003\u0005\t\u0011!A\u0005tG\r\t;iK\u0002\u0002x.\u001b8uA\u001dLg/\u001a8!Ef\u0004C\u000f[3!G>|'\u000fZ5oCR,7\u000f\t\u0015aKb\u0004(\u000f\u00171-A\u0001,\u0007\u0010\u001d:ZA&b\u0003%Y:!S\u001a\u00043m\\7qkR,G\r\t2z\u0015\u0001\u0002\u0003\u0005\t\u0011!A*\fg/\u0019\u0018mC:<g&T1uQ:zf)\u0016(D?\u0002t#\u0002\t\u0011\u0002\u0013\u0005\u0014x-^7f]R\u001c\u0018EAA\u0011\u0003qS\u0001\u0005\t\u0011!\u0003J<W/\\3oiNT$\u0002\t\u0011!A\u0001\u0002#\u0006I3yaJL\u0006%\f\u0011d_>\u0014H-\u001b8bi\u0016\u0004sN\u001c\u0011z[\u0005D\u0018n\u001d\u0006!A\u0001\u0002\u0003\u0005\t\u0016!Kb\u0004(\u000f\u0017\u0011.A\r|wN\u001d3j]\u0006$X\rI8oAal\u0013\r_5t\u0015\u0001\u0002\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005\u001d\u0012!\u000f\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)a1\u0002\u0003'K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!a9\u0002$\u0002\t\u0011\b\u0013\u0005-\"!!A\t\u0002\u00055\u0012!B!uC:\u0014\u0004cA\t\u00020\u0019A\u0011AAA\u0001\u0012\u0003\t\tdE\u0003\u00020\u0005M\"\u0004E\u0004\u00026\u0005m\u0002\u0005\t\u0017\u000e\u0005\u0005]\"bAA\u001d-\u00059!/\u001e8uS6,\u0017\u0002BA\u001f\u0003o\u0011\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c83\u0011\u001dQ\u0013q\u0006C\u0001\u0003\u0003\"\"!!\f\t\u0015\u0005\u0015\u0013qFA\u0001\n\u000b\n9%\u0001\u0005u_N#(/\u001b8h)\u0005\u0001\u0007BCA&\u0003_\t\t\u0011\"!\u0002N\u0005)\u0011\r\u001d9msR)A&a\u0014\u0002R!1a$!\u0013A\u0002\u0001BaAJA%\u0001\u0004\u0001\u0003BCA+\u0003_\t\t\u0011\"!\u0002X\u00059QO\\1qa2LH\u0003BA-\u0003K\u0002R!FA.\u0003?J1!!\u0018\u0017\u0005\u0019y\u0005\u000f^5p]B)Q#!\u0019!A%\u0019\u00111\r\f\u0003\rQ+\b\u000f\\33\u0011%\t9'a\u0015\u0002\u0002\u0003\u0007A&A\u0002yIAB!\"a\u001b\u00020\u0005\u0005I\u0011BA7\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005=\u0004cA1\u0002r%\u0019\u00111\u000f2\u0003\r=\u0013'.Z2u\u0001")
public class Atan2
extends BinaryMathExpression {
    private final Expression left;
    private final Expression right;

    public static Option<Tuple2<Expression, Expression>> unapply(Atan2 atan2) {
        return Atan2$.MODULE$.unapply(atan2);
    }

    public static Function1<Tuple2<Expression, Expression>, Atan2> tupled() {
        return Atan2$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Atan2>> curried() {
        return Atan2$.MODULE$.curried();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public Object nullSafeEval(Object input1, Object input2) {
        return BoxesRunTime.boxToDouble((double)package$.MODULE$.atan2(BoxesRunTime.unboxToDouble((Object)input1) + 0.0, BoxesRunTime.unboxToDouble((Object)input2) + 0.0));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.defineCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & java.io.Serializable & Serializable)(c1, c2) -> new StringBuilder(36).append("java.lang.Math.atan2(").append((String)c1).append(" + 0.0, ").append((String)c2).append(" + 0.0)").toString());
    }

    public Atan2 copy(Expression left, Expression right) {
        return new Atan2(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "Atan2";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.left();
                break;
            }
            case 1: {
                expression = this.right();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Atan2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Atan2)) return false;
        boolean bl = true;
        if (!bl) return false;
        Atan2 atan2 = (Atan2)x$1;
        Expression expression = this.left();
        Expression expression2 = atan2.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = atan2.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!atan2.canEqual(this)) return false;
        return true;
    }

    public Atan2(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        super((Function2<Object, Object, Object>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(double y, double x) {
                return this.apply$mcDDD$sp(y, x);
            }

            public double apply$mcDDD$sp(double y, double x) {
                return package$.MODULE$.atan2(y, x);
            }
        }, "ATAN2");
    }
}

