/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BitLength$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TypeCollection;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(expr) - Returns the bit length of string data or number of bits of binary data.", examples="\n    Examples:\n      > SELECT _FUNC_('Spark SQL');\n       72\n  ")
@ScalaSignature(bytes="\u0006\u0001\u0005\rf\u0001B\u0001\u0003\u0001>\u0011\u0011BQ5u\u0019\u0016tw\r\u001e5\u000b\u0005\r!\u0011aC3yaJ,7o]5p]NT!!\u0002\u0004\u0002\u0011\r\fG/\u00197zgRT!a\u0002\u0005\u0002\u0007M\fHN\u0003\u0002\n\u0015\u0005)1\u000f]1sW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u0019R\u0001\u0001\t\u0015/u\u0001\"!\u0005\n\u000e\u0003\tI!a\u0005\u0002\u0003\u001fUs\u0017M]=FqB\u0014Xm]:j_:\u0004\"!E\u000b\n\u0005Y\u0011!AF%na2L7-\u001b;DCN$\u0018J\u001c9viRK\b/Z:\u0011\u0005aYR\"A\r\u000b\u0003i\tQa]2bY\u0006L!\u0001H\r\u0003\u000fA\u0013x\u000eZ;diB\u0011\u0001DH\u0005\u0003?e\u0011AbU3sS\u0006d\u0017N_1cY\u0016D\u0001\"\t\u0001\u0003\u0016\u0004%\tAI\u0001\u0006G\"LG\u000eZ\u000b\u0002GA\u0011\u0011\u0003J\u0005\u0003K\t\u0011!\"\u0012=qe\u0016\u001c8/[8o\u0011!9\u0003A!E!\u0002\u0013\u0019\u0013AB2iS2$\u0007\u0005C\u0003*\u0001\u0011\u0005!&\u0001\u0004=S:LGO\u0010\u000b\u0003W1\u0002\"!\u0005\u0001\t\u000b\u0005B\u0003\u0019A\u0012\t\u000b9\u0002A\u0011I\u0018\u0002\u0011\u0011\fG/\u0019+za\u0016,\u0012\u0001\r\t\u0003cQj\u0011A\r\u0006\u0003g\u0019\tQ\u0001^=qKNL!!\u000e\u001a\u0003\u0011\u0011\u000bG/\u0019+za\u0016DQa\u000e\u0001\u0005Ba\n!\"\u001b8qkR$\u0016\u0010]3t+\u0005I\u0004c\u0001\u001eC\u000b:\u00111\b\u0011\b\u0003y}j\u0011!\u0010\u0006\u0003}9\ta\u0001\u0010:p_Rt\u0014\"\u0001\u000e\n\u0005\u0005K\u0012a\u00029bG.\fw-Z\u0005\u0003\u0007\u0012\u00131aU3r\u0015\t\t\u0015\u0004\u0005\u00022\r&\u0011qI\r\u0002\u0011\u0003\n\u001cHO]1di\u0012\u000bG/\u0019+za\u0016DQ!\u0013\u0001\u0005R)\u000bAB\\;mYN\u000bg-Z#wC2$\"a\u0013(\u0011\u0005aa\u0015BA'\u001a\u0005\r\te.\u001f\u0005\u0006\u001f\"\u0003\raS\u0001\u0006m\u0006dW/\u001a\u0005\u0006#\u0002!\tEU\u0001\nI><UM\\\"pI\u0016$2aU-_!\t!v+D\u0001V\u0015\t1&!A\u0004d_\u0012,w-\u001a8\n\u0005a+&\u0001C#yaJ\u001cu\u000eZ3\t\u000bi\u0003\u0006\u0019A.\u0002\u0007\r$\b\u0010\u0005\u0002U9&\u0011Q,\u0016\u0002\u000f\u0007>$WmZ3o\u0007>tG/\u001a=u\u0011\u0015y\u0006\u000b1\u0001T\u0003\t)g\u000fC\u0003b\u0001\u0011\u0005#-\u0001\u0006qe\u0016$H/\u001f(b[\u0016,\u0012a\u0019\t\u0003I\"t!!\u001a4\u0011\u0005qJ\u0012BA4\u001a\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011N\u001b\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u001dL\u0002b\u00027\u0001\u0003\u0003%\t!\\\u0001\u0005G>\u0004\u0018\u0010\u0006\u0002,]\"9\u0011e\u001bI\u0001\u0002\u0004\u0019\u0003b\u00029\u0001#\u0003%\t!]\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\u0005\u0011(FA\u0012tW\u0005!\bCA;{\u001b\u00051(BA<y\u0003%)hn\u00195fG.,GM\u0003\u0002z3\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005m4(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"9Q\u0010AA\u0001\n\u0003r\u0018!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070F\u0001\u0000!\u0011\t\t!a\u0003\u000e\u0005\u0005\r!\u0002BA\u0003\u0003\u000f\tA\u0001\\1oO*\u0011\u0011\u0011B\u0001\u0005U\u00064\u0018-C\u0002j\u0003\u0007A\u0011\"a\u0004\u0001\u0003\u0003%\t!!\u0005\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005M\u0001c\u0001\r\u0002\u0016%\u0019\u0011qC\r\u0003\u0007%sG\u000fC\u0005\u0002\u001c\u0001\t\t\u0011\"\u0001\u0002\u001e\u0005q\u0001O]8ek\u000e$X\t\\3nK:$HcA&\u0002 !Q\u0011\u0011EA\r\u0003\u0003\u0005\r!a\u0005\u0002\u0007a$\u0013\u0007C\u0005\u0002&\u0001\t\t\u0011\"\u0011\u0002(\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002*A)\u00111FA\u0019\u00176\u0011\u0011Q\u0006\u0006\u0004\u0003_I\u0012AC2pY2,7\r^5p]&!\u00111GA\u0017\u0005!IE/\u001a:bi>\u0014\b\"CA\u001c\u0001\u0005\u0005I\u0011AA\u001d\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA\u001e\u0003\u0003\u00022\u0001GA\u001f\u0013\r\ty$\u0007\u0002\b\u0005>|G.Z1o\u0011%\t\t#!\u000e\u0002\u0002\u0003\u00071\nC\u0005\u0002F\u0001\t\t\u0011\"\u0011\u0002H\u00051Q-];bYN$B!a\u000f\u0002J!I\u0011\u0011EA\"\u0003\u0003\u0005\ra\u0013\u0015\f\u0001\u00055\u00131KA+\u00033\nY\u0006E\u0002\u0012\u0003\u001fJ1!!\u0015\u0003\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!a\u0016\u0002-~3UKT\"`Q\u0015D\bO]\u0015![\u0001\u0012V\r^;s]N\u0004C\u000f[3!E&$\b\u0005\\3oORD\u0007e\u001c4!gR\u0014\u0018N\\4!I\u0006$\u0018\rI8sA9,XNY3sA=4\u0007EY5ug\u0002zg\r\t2j]\u0006\u0014\u0018\u0010\t3bi\u0006t\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005u\u0013a\u0010\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)OM\u0003\u0018M]6!'Fcu%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!oIR\u0001\u0005I\u0004\n\u0003C\u0012\u0011\u0011!E\u0001\u0003G\n\u0011BQ5u\u0019\u0016tw\r\u001e5\u0011\u0007E\t)G\u0002\u0005\u0002\u0005\u0005\u0005\t\u0012AA4'\u0015\t)'!\u001b\u001e!\u0019\tY'!\u001d$W5\u0011\u0011Q\u000e\u0006\u0004\u0003_J\u0012a\u0002:v]RLW.Z\u0005\u0005\u0003g\niGA\tBEN$(/Y2u\rVt7\r^5p]FBq!KA3\t\u0003\t9\b\u0006\u0002\u0002d!Q\u00111PA3\u0003\u0003%)%! \u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012a \u0005\u000b\u0003\u0003\u000b)'!A\u0005\u0002\u0006\r\u0015!B1qa2LHcA\u0016\u0002\u0006\"1\u0011%a A\u0002\rB!\"!#\u0002f\u0005\u0005I\u0011QAF\u0003\u001d)h.\u00199qYf$B!!$\u0002\u0014B!\u0001$a$$\u0013\r\t\t*\u0007\u0002\u0007\u001fB$\u0018n\u001c8\t\u0013\u0005U\u0015qQA\u0001\u0002\u0004Y\u0013a\u0001=%a!Q\u0011\u0011TA3\u0003\u0003%I!a'\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003;\u0003B!!\u0001\u0002 &!\u0011\u0011UA\u0002\u0005\u0019y%M[3di\u0002")
public class BitLength
extends UnaryExpression
implements ImplicitCastInputTypes,
scala.Serializable {
    private final Expression child;

    public static Option<Expression> unapply(BitLength bitLength) {
        return BitLength$.MODULE$.unapply(bitLength);
    }

    public static <A> Function1<Expression, A> andThen(Function1<BitLength, A> function1) {
        return BitLength$.MODULE$.andThen(function1);
    }

    public static <A> Function1<A, BitLength> compose(Function1<A, Expression> function1) {
        return BitLength$.MODULE$.compose(function1);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public DataType dataType() {
        return IntegerType$.MODULE$;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TypeCollection[]{TypeCollection$.MODULE$.apply((Seq<AbstractDataType>)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{StringType$.MODULE$, BinaryType$.MODULE$}))}));
    }

    @Override
    public Object nullSafeEval(Object value) {
        Integer n;
        DataType dataType = this.child().dataType();
        if (StringType$.MODULE$.equals(dataType)) {
            n = BoxesRunTime.boxToInteger((int)(((UTF8String)value).numBytes() * 8));
        } else if (BinaryType$.MODULE$.equals(dataType)) {
            n = BoxesRunTime.boxToInteger((int)(((byte[])value).length * 8));
        } else {
            throw new MatchError((Object)dataType);
        }
        return n;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode exprCode;
        DataType dataType = this.child().dataType();
        if (StringType$.MODULE$.equals(dataType)) {
            exprCode = this.defineCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable & scala.Serializable)c -> new StringBuilder(17).append("(").append((String)c).append(").numBytes() * 8").toString());
        } else if (BinaryType$.MODULE$.equals(dataType)) {
            exprCode = this.defineCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable & scala.Serializable)c -> new StringBuilder(13).append("(").append((String)c).append(").length * 8").toString());
        } else {
            throw new MatchError((Object)dataType);
        }
        return exprCode;
    }

    @Override
    public String prettyName() {
        return "bit_length";
    }

    public BitLength copy(Expression child) {
        return new BitLength(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "BitLength";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return this.child();
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof BitLength;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof BitLength)) return false;
        boolean bl = true;
        if (!bl) return false;
        BitLength bitLength = (BitLength)x$1;
        Expression expression = this.child();
        Expression expression2 = bitLength.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!bitLength.canEqual(this)) return false;
        return true;
    }

    public BitLength(Expression child) {
        this.child = child;
        ExpectsInputTypes.$init$(this);
    }
}

