/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.analysis.TypeCoercion$;
import org.apache.spark.sql.catalyst.expressions.CreateMap$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.GenArrayData$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StringType$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ExpressionDescription(usage="_FUNC_(key0, value0, key1, value1, ...) - Creates a map with the given key/value pairs.", examples="\n    Examples:\n      > SELECT _FUNC_(1.0, '2', 3.0, '4');\n       {1.0:\"2\",3.0:\"4\"}\n  ")
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015g\u0001B\u0001\u0003\u0001>\u0011\u0011b\u0011:fCR,W*\u00199\u000b\u0005\r!\u0011aC3yaJ,7o]5p]NT!!\u0002\u0004\u0002\u0011\r\fG/\u00197zgRT!a\u0002\u0005\u0002\u0007M\fHN\u0003\u0002\n\u0015\u0005)1\u000f]1sW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u0019B\u0001\u0001\t\u00155A\u0011\u0011CE\u0007\u0002\u0005%\u00111C\u0001\u0002\u000b\u000bb\u0004(/Z:tS>t\u0007CA\u000b\u0019\u001b\u00051\"\"A\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005e1\"a\u0002)s_\u0012,8\r\u001e\t\u0003+mI!\u0001\b\f\u0003\u0019M+'/[1mSj\f'\r\\3\t\u0011y\u0001!Q3A\u0005\u0002}\t\u0001b\u00195jY\u0012\u0014XM\\\u000b\u0002AA\u0019\u0011%\u000b\t\u000f\u0005\t:cBA\u0012'\u001b\u0005!#BA\u0013\u000f\u0003\u0019a$o\\8u}%\tq#\u0003\u0002)-\u00059\u0001/Y2lC\u001e,\u0017B\u0001\u0016,\u0005\r\u0019V-\u001d\u0006\u0003QYA\u0001\"\f\u0001\u0003\u0012\u0003\u0006I\u0001I\u0001\nG\"LG\u000e\u001a:f]\u0002BQa\f\u0001\u0005\u0002A\na\u0001P5oSRtDCA\u00193!\t\t\u0002\u0001C\u0003\u001f]\u0001\u0007\u0001\u0005\u0003\u00055\u0001!\u0015\r\u0011\"\u00016\u0003\u0011YW-_:\u0016\u0003Y\u00022a\u000e\u001f\u0011\u001b\u0005A$BA\u001d;\u0003%IW.\\;uC\ndWM\u0003\u0002<-\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005uB$AC%oI\u0016DX\rZ*fc\"Aq\b\u0001EC\u0002\u0013\u0005Q'\u0001\u0004wC2,Xm\u001d\u0005\u0006\u0003\u0002!\tEQ\u0001\tM>dG-\u00192mKV\t1\t\u0005\u0002\u0016\t&\u0011QI\u0006\u0002\b\u0005>|G.Z1o\u0011\u00159\u0005\u0001\"\u0011I\u0003M\u0019\u0007.Z2l\u0013:\u0004X\u000f\u001e#bi\u0006$\u0016\u0010]3t)\u0005I\u0005C\u0001&N\u001b\u0005Y%B\u0001'\u0005\u0003!\tg.\u00197zg&\u001c\u0018B\u0001(L\u0005=!\u0016\u0010]3DQ\u0016\u001c7NU3tk2$\b\"\u0002)\u0001\t\u0003\n\u0016\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u0003I\u0003\"a\u0015,\u000e\u0003QS!!\u0016\u0004\u0002\u000bQL\b/Z:\n\u0005]#&\u0001\u0003#bi\u0006$\u0016\u0010]3\t\u000be\u0003A\u0011\t\"\u0002\u00119,H\u000e\\1cY\u0016DQa\u0017\u0001\u0005Bq\u000bA!\u001a<bYR\u0011Q\f\u0019\t\u0003+yK!a\u0018\f\u0003\u0007\u0005s\u0017\u0010C\u0004b5B\u0005\t\u0019\u00012\u0002\u000b%t\u0007/\u001e;\u0011\u0005\r$W\"\u0001\u0003\n\u0005\u0015$!aC%oi\u0016\u0014h.\u00197S_^DQa\u001a\u0001\u0005B!\f\u0011\u0002Z8HK:\u001cu\u000eZ3\u0015\u0007%|G\u000f\u0005\u0002k[6\t1N\u0003\u0002m\u0005\u000591m\u001c3fO\u0016t\u0017B\u00018l\u0005!)\u0005\u0010\u001d:D_\u0012,\u0007\"\u00029g\u0001\u0004\t\u0018aA2uqB\u0011!N]\u0005\u0003g.\u0014abQ8eK\u001e,gnQ8oi\u0016DH\u000fC\u0003vM\u0002\u0007\u0011.\u0001\u0002fm\")q\u000f\u0001C!q\u0006Q\u0001O]3uift\u0015-\\3\u0016\u0003e\u0004\"A\u001f@\u000f\u0005md\bCA\u0012\u0017\u0013\tih#\u0001\u0004Qe\u0016$WMZ\u0005\u0004\u007f\u0006\u0005!AB*ue&twM\u0003\u0002~-!I\u0011Q\u0001\u0001\u0002\u0002\u0013\u0005\u0011qA\u0001\u0005G>\u0004\u0018\u0010F\u00022\u0003\u0013A\u0001BHA\u0002!\u0003\u0005\r\u0001\t\u0005\n\u0003\u001b\u0001\u0011\u0013!C\u0001\u0003\u001f\tabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002\u0012)\u001a\u0001%a\u0005,\u0005\u0005U\u0001\u0003BA\f\u0003Ci!!!\u0007\u000b\t\u0005m\u0011QD\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\b\u0017\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003G\tIBA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D\u0011\"a\n\u0001\u0003\u0003%\t%!\u000b\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\tY\u0003\u0005\u0003\u0002.\u0005]RBAA\u0018\u0015\u0011\t\t$a\r\u0002\t1\fgn\u001a\u0006\u0003\u0003k\tAA[1wC&\u0019q0a\f\t\u0013\u0005m\u0002!!A\u0005\u0002\u0005u\u0012\u0001\u00049s_\u0012,8\r^!sSRLXCAA !\r)\u0012\u0011I\u0005\u0004\u0003\u00072\"aA%oi\"I\u0011q\t\u0001\u0002\u0002\u0013\u0005\u0011\u0011J\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\ri\u00161\n\u0005\u000b\u0003\u001b\n)%!AA\u0002\u0005}\u0012a\u0001=%c!I\u0011\u0011\u000b\u0001\u0002\u0002\u0013\u0005\u00131K\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011Q\u000b\t\u0006\u0003/\nI&X\u0007\u0002u%\u0019\u00111\f\u001e\u0003\u0011%#XM]1u_JD\u0011\"a\u0018\u0001\u0003\u0003%\t!!\u0019\u0002\u0011\r\fg.R9vC2$2aQA2\u0011%\ti%!\u0018\u0002\u0002\u0003\u0007Q\fC\u0005\u0002h\u0001\t\t\u0011\"\u0011\u0002j\u00051Q-];bYN$2aQA6\u0011%\ti%!\u001a\u0002\u0002\u0003\u0007Q\fK\u0006\u0001\u0003_\n)(a\u001e\u0002|\u0005u\u0004cA\t\u0002r%\u0019\u00111\u000f\u0002\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u0011\u0011P\u0001X?\u001a+fjQ0)W\u0016L\b\u0007\f\u0011wC2,X\r\r\u0017!W\u0016L\u0018\u0007\f\u0011wC2,X-\r\u0017!]9r\u0013\u0006I\u0017!\u0007J,\u0017\r^3tA\u0005\u0004S.\u00199!o&$\b\u000e\t;iK\u0002:\u0017N^3oA-,\u0017p\f<bYV,\u0007\u0005]1jeNt\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005}\u0014!\u0016\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)c9\u0002D\u0006I\u00143O1\u00023G\f\u0019-A\u001d\"t%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!wFr\u0003G\u000f\u00123E1\u001ad\u0006\r\u001e#i\tj(\u0002\t\u0011\b\u0013\u0005\r%!!A\t\u0002\u0005\u0015\u0015!C\"sK\u0006$X-T1q!\r\t\u0012q\u0011\u0004\t\u0003\t\t\t\u0011#\u0001\u0002\nN)\u0011qQAF5A1\u0011QRAJAEj!!a$\u000b\u0007\u0005Ee#A\u0004sk:$\u0018.\\3\n\t\u0005U\u0015q\u0012\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\f\u0004bB\u0018\u0002\b\u0012\u0005\u0011\u0011\u0014\u000b\u0003\u0003\u000bC!\"!(\u0002\b\u0006\u0005IQIAP\u0003!!xn\u0015;sS:<GCAA\u0016\u0011)\t\u0019+a\"\u0002\u0002\u0013\u0005\u0015QU\u0001\u0006CB\u0004H.\u001f\u000b\u0004c\u0005\u001d\u0006B\u0002\u0010\u0002\"\u0002\u0007\u0001\u0005\u0003\u0006\u0002,\u0006\u001d\u0015\u0011!CA\u0003[\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u00020\u0006U\u0006\u0003B\u000b\u00022\u0002J1!a-\u0017\u0005\u0019y\u0005\u000f^5p]\"I\u0011qWAU\u0003\u0003\u0005\r!M\u0001\u0004q\u0012\u0002\u0004BCA^\u0003\u000f\u000b\t\u0011\"\u0003\u0002>\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\ty\f\u0005\u0003\u0002.\u0005\u0005\u0017\u0002BAb\u0003_\u0011aa\u00142kK\u000e$\b")
public class CreateMap
extends Expression
implements scala.Serializable {
    private IndexedSeq<Expression> keys;
    private IndexedSeq<Expression> values;
    private final Seq<Expression> children;
    private volatile byte bitmap$0;

    public static Option<Seq<Expression>> unapply(CreateMap createMap) {
        return CreateMap$.MODULE$.unapply(createMap);
    }

    public static <A> Function1<Seq<Expression>, A> andThen(Function1<CreateMap, A> function1) {
        return CreateMap$.MODULE$.andThen(function1);
    }

    public static <A> Function1<A, CreateMap> compose(Function1<A, Seq<Expression>> function1) {
        return CreateMap$.MODULE$.compose(function1);
    }

    @Override
    public Seq<Expression> children() {
        return this.children;
    }

    private IndexedSeq<Expression> keys$lzycompute() {
        CreateMap createMap = this;
        synchronized (createMap) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.keys = (IndexedSeq)((TraversableLike)this.children().indices().filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$9 -> x$9 % 2 == 0)).map(this.children(), IndexedSeq$.MODULE$.canBuildFrom());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.keys;
    }

    public IndexedSeq<Expression> keys() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.keys$lzycompute() : this.keys;
    }

    private IndexedSeq<Expression> values$lzycompute() {
        CreateMap createMap = this;
        synchronized (createMap) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.values = (IndexedSeq)((TraversableLike)this.children().indices().filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$10 -> x$10 % 2 != 0)).map(this.children(), IndexedSeq$.MODULE$.canBuildFrom());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.values;
    }

    public IndexedSeq<Expression> values() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.values$lzycompute() : this.values;
    }

    @Override
    public boolean foldable() {
        return this.children().forall((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)x$11.foldable()));
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return this.children().size() % 2 != 0 ? new TypeCheckResult.TypeCheckFailure(new StringBuilder(45).append(this.prettyName()).append(" expects a positive even number of arguments.").toString()) : (!TypeCoercion$.MODULE$.haveSameType((Seq<DataType>)((Seq)this.keys().map((Function1 & Serializable & scala.Serializable)x$12 -> x$12.dataType(), IndexedSeq$.MODULE$.canBuildFrom()))) ? new TypeCheckResult.TypeCheckFailure(new StringBuilder(73).append("The given keys of function map should all be the same type, but they are ").append(((TraversableOnce)this.keys().map((Function1 & Serializable & scala.Serializable)x$13 -> x$13.dataType().catalogString(), IndexedSeq$.MODULE$.canBuildFrom())).mkString("[", ", ", "]")).toString()) : (!TypeCoercion$.MODULE$.haveSameType((Seq<DataType>)((Seq)this.values().map((Function1 & Serializable & scala.Serializable)x$14 -> x$14.dataType(), IndexedSeq$.MODULE$.canBuildFrom()))) ? new TypeCheckResult.TypeCheckFailure(new StringBuilder(75).append("The given values of function map should all be the same type, but they are ").append(((TraversableOnce)this.values().map((Function1 & Serializable & scala.Serializable)x$15 -> x$15.dataType().catalogString(), IndexedSeq$.MODULE$.canBuildFrom())).mkString("[", ", ", "]")).toString()) : TypeCheckResult$TypeCheckSuccess$.MODULE$));
    }

    @Override
    public DataType dataType() {
        return new MapType((DataType)TypeCoercion$.MODULE$.findCommonTypeDifferentOnlyInNullFlags((Seq<DataType>)((Seq)this.keys().map((Function1 & Serializable & scala.Serializable)x$16 -> x$16.dataType(), IndexedSeq$.MODULE$.canBuildFrom()))).getOrElse((Function0 & Serializable & scala.Serializable)() -> StringType$.MODULE$), (DataType)TypeCoercion$.MODULE$.findCommonTypeDifferentOnlyInNullFlags((Seq<DataType>)((Seq)this.values().map((Function1 & Serializable & scala.Serializable)x$17 -> x$17.dataType(), IndexedSeq$.MODULE$.canBuildFrom()))).getOrElse((Function0 & Serializable & scala.Serializable)() -> StringType$.MODULE$), this.values().exists((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)x$18.nullable())));
    }

    @Override
    public boolean nullable() {
        return false;
    }

    @Override
    public Object eval(InternalRow input) {
        Object[] keyArray = (Object[])((TraversableOnce)this.keys().map((Function1 & Serializable & scala.Serializable)x$19 -> x$19.eval(input), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Any());
        if (Predef$.MODULE$.genericArrayOps((Object)keyArray).contains(null)) {
            throw new RuntimeException("Cannot use null as map key!");
        }
        Object[] valueArray = (Object[])((TraversableOnce)this.values().map((Function1 & Serializable & scala.Serializable)x$20 -> x$20.eval(input), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Any());
        return new ArrayBasedMapData(new GenericArrayData(keyArray), new GenericArrayData(valueArray));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String mapClass = ArrayBasedMapData.class.getName();
        DataType dataType = this.dataType();
        if (!(dataType instanceof MapType)) {
            throw new MatchError((Object)dataType);
        }
        MapType mapType = (MapType)dataType;
        DataType keyDt = mapType.keyType();
        DataType valueDt = mapType.valueType();
        Tuple2 tuple2 = new Tuple2((Object)keyDt, (Object)valueDt);
        Tuple2 tuple22 = tuple2;
        DataType keyDt2 = (DataType)tuple22._1();
        DataType valueDt2 = (DataType)tuple22._2();
        IndexedSeq evalKeys = (IndexedSeq)this.keys().map((Function1 & Serializable & scala.Serializable)e -> e.genCode(ctx), IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq evalValues = (IndexedSeq)this.values().map((Function1 & Serializable & scala.Serializable)e -> e.genCode(ctx), IndexedSeq$.MODULE$.canBuildFrom());
        Tuple4<String, String, String, String> tuple4 = GenArrayData$.MODULE$.genCodeToCreateArrayData(ctx, keyDt2, (Seq<ExprCode>)evalKeys, true);
        if (tuple4 == null) {
            throw new MatchError(tuple4);
        }
        String preprocessKeyData = (String)tuple4._1();
        String assignKeys = (String)tuple4._2();
        String postprocessKeyData = (String)tuple4._3();
        String keyArrayData = (String)tuple4._4();
        Tuple4 tuple42 = new Tuple4((Object)preprocessKeyData, (Object)assignKeys, (Object)postprocessKeyData, (Object)keyArrayData);
        Tuple4 tuple43 = tuple42;
        String preprocessKeyData2 = (String)tuple43._1();
        String assignKeys2 = (String)tuple43._2();
        String postprocessKeyData2 = (String)tuple43._3();
        String keyArrayData2 = (String)tuple43._4();
        Tuple4<String, String, String, String> tuple44 = GenArrayData$.MODULE$.genCodeToCreateArrayData(ctx, valueDt2, (Seq<ExprCode>)evalValues, false);
        if (tuple44 == null) {
            throw new MatchError(tuple44);
        }
        String preprocessValueData = (String)tuple44._1();
        String assignValues = (String)tuple44._2();
        String postprocessValueData = (String)tuple44._3();
        String valueArrayData = (String)tuple44._4();
        Tuple4 tuple45 = new Tuple4((Object)preprocessValueData, (Object)assignValues, (Object)postprocessValueData, (Object)valueArrayData);
        Tuple4 tuple46 = tuple45;
        String preprocessValueData2 = (String)tuple46._1();
        String assignValues2 = (String)tuple46._2();
        String postprocessValueData2 = (String)tuple46._3();
        String valueArrayData2 = (String)tuple46._4();
        Block code = Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n       final boolean ", " = false;\n       ", "\n       ", "\n       ", "\n       ", "\n       ", "\n       ", "\n       final MapData ", " = new ", "(", ", ", ");\n      "}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), preprocessKeyData2, assignKeys2, postprocessKeyData2, preprocessValueData2, assignValues2, postprocessValueData2, ev.value(), mapClass, keyArrayData2, valueArrayData2}));
        return ev.copy(code, ev.copy$default$2(), ev.copy$default$3());
    }

    @Override
    public String prettyName() {
        return "map";
    }

    public CreateMap copy(Seq<Expression> children2) {
        return new CreateMap(children2);
    }

    public Seq<Expression> copy$default$1() {
        return this.children();
    }

    @Override
    public String productPrefix() {
        return "CreateMap";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return this.children();
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof CreateMap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof CreateMap)) return false;
        boolean bl = true;
        if (!bl) return false;
        CreateMap createMap = (CreateMap)x$1;
        Seq<Expression> seq = this.children();
        Seq<Expression> seq2 = createMap.children();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        if (!createMap.canEqual(this)) return false;
        return true;
    }

    public CreateMap(Seq<Expression> children2) {
        this.children = children2;
    }
}

