/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.text.DateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.DateFormatClass$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(timestamp, fmt) - Converts `timestamp` to a value of string in the format specified by the date format `fmt`.", examples="\n    Examples:\n      > SELECT _FUNC_('2016-04-08', 'y');\n       2016\n  ", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0001\u0005uh\u0001B\u0001\u0003\u0001>\u0011q\u0002R1uK\u001a{'/\\1u\u00072\f7o\u001d\u0006\u0003\u0007\u0011\t1\"\u001a=qe\u0016\u001c8/[8og*\u0011QAB\u0001\tG\u0006$\u0018\r\\=ti*\u0011q\u0001C\u0001\u0004gFd'BA\u0005\u000b\u0003\u0015\u0019\b/\u0019:l\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001M1\u0001\u0001\u0005\u000b\u00185\u0001\u0002\"!\u0005\n\u000e\u0003\tI!a\u0005\u0002\u0003!\tKg.\u0019:z\u000bb\u0004(/Z:tS>t\u0007CA\t\u0016\u0013\t1\"AA\fUS6,'l\u001c8f\u0003^\f'/Z#yaJ,7o]5p]B\u0011\u0011\u0003G\u0005\u00033\t\u0011a#S7qY&\u001c\u0017\u000e^\"bgRLe\u000e];u)f\u0004Xm\u001d\t\u00037yi\u0011\u0001\b\u0006\u0002;\u0005)1oY1mC&\u0011q\u0004\b\u0002\b!J|G-^2u!\tY\u0012%\u0003\u0002#9\ta1+\u001a:jC2L'0\u00192mK\"AA\u0005\u0001BK\u0002\u0013\u0005Q%\u0001\u0003mK\u001a$X#\u0001\u0014\u0011\u0005E9\u0013B\u0001\u0015\u0003\u0005))\u0005\u0010\u001d:fgNLwN\u001c\u0005\tU\u0001\u0011\t\u0012)A\u0005M\u0005)A.\u001a4uA!AA\u0006\u0001BK\u0002\u0013\u0005Q%A\u0003sS\u001eDG\u000f\u0003\u0005/\u0001\tE\t\u0015!\u0003'\u0003\u0019\u0011\u0018n\u001a5uA!A\u0001\u0007\u0001BK\u0002\u0013\u0005\u0011'\u0001\u0006uS6,'l\u001c8f\u0013\u0012,\u0012A\r\t\u00047M*\u0014B\u0001\u001b\u001d\u0005\u0019y\u0005\u000f^5p]B\u0011a'\u0010\b\u0003om\u0002\"\u0001\u000f\u000f\u000e\u0003eR!A\u000f\b\u0002\rq\u0012xn\u001c;?\u0013\taD$\u0001\u0004Qe\u0016$WMZ\u0005\u0003}}\u0012aa\u0015;sS:<'B\u0001\u001f\u001d\u0011!\t\u0005A!E!\u0002\u0013\u0011\u0014a\u0003;j[\u0016TvN\\3JI\u0002BQa\u0011\u0001\u0005\u0002\u0011\u000ba\u0001P5oSRtD\u0003B#G\u000f\"\u0003\"!\u0005\u0001\t\u000b\u0011\u0012\u0005\u0019\u0001\u0014\t\u000b1\u0012\u0005\u0019\u0001\u0014\t\u000fA\u0012\u0005\u0013!a\u0001e!)1\t\u0001C\u0001\u0015R\u0019Qi\u0013'\t\u000b\u0011J\u0005\u0019\u0001\u0014\t\u000b1J\u0005\u0019\u0001\u0014\t\u000b9\u0003A\u0011I(\u0002\u0011\u0011\fG/\u0019+za\u0016,\u0012\u0001\u0015\t\u0003#Rk\u0011A\u0015\u0006\u0003'\u001a\tQ\u0001^=qKNL!!\u0016*\u0003\u0011\u0011\u000bG/\u0019+za\u0016DQa\u0016\u0001\u0005Ba\u000b!\"\u001b8qkR$\u0016\u0010]3t+\u0005I\u0006c\u0001.`E:\u00111,\u0018\b\u0003qqK\u0011!H\u0005\u0003=r\tq\u0001]1dW\u0006<W-\u0003\u0002aC\n\u00191+Z9\u000b\u0005yc\u0002CA)d\u0013\t!'K\u0001\tBEN$(/Y2u\t\u0006$\u0018\rV=qK\")a\r\u0001C!O\u0006aq/\u001b;i)&lWMW8oKR\u0011A\u0003\u001b\u0005\u0006a\u0015\u0004\r!\u000e\u0005\u0006U\u0002!\tf[\u0001\r]VdGnU1gK\u00163\u0018\r\u001c\u000b\u0004Y>\f\bCA\u000en\u0013\tqGDA\u0002B]fDQ\u0001]5A\u00021\f\u0011\u0002^5nKN$\u0018-\u001c9\t\u000bIL\u0007\u0019\u00017\u0002\r\u0019|'/\\1u\u0011\u0015!\b\u0001\"\u0011v\u0003%!wnR3o\u0007>$W\r\u0006\u0003wy\u0006\r\u0001CA<{\u001b\u0005A(BA=\u0003\u0003\u001d\u0019w\u000eZ3hK:L!a\u001f=\u0003\u0011\u0015C\bO]\"pI\u0016DQ!`:A\u0002y\f1a\u0019;y!\t9x0C\u0002\u0002\u0002a\u0014abQ8eK\u001e,gnQ8oi\u0016DH\u000f\u0003\u0004\u0002\u0006M\u0004\rA^\u0001\u0003KZDq!!\u0003\u0001\t\u0003\nY!\u0001\u0006qe\u0016$H/\u001f(b[\u0016,\u0012!\u000e\u0005\n\u0003\u001f\u0001\u0011\u0011!C\u0001\u0003#\tAaY8qsR9Q)a\u0005\u0002\u0016\u0005]\u0001\u0002\u0003\u0013\u0002\u000eA\u0005\t\u0019\u0001\u0014\t\u00111\ni\u0001%AA\u0002\u0019B\u0001\u0002MA\u0007!\u0003\u0005\rA\r\u0005\n\u00037\u0001\u0011\u0013!C\u0001\u0003;\tabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002 )\u001aa%!\t,\u0005\u0005\r\u0002\u0003BA\u0013\u0003_i!!a\n\u000b\t\u0005%\u00121F\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\f\u001d\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003c\t9CA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D\u0011\"!\u000e\u0001#\u0003%\t!!\b\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e!I\u0011\u0011\b\u0001\u0012\u0002\u0013\u0005\u00111H\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134+\t\tiDK\u00023\u0003CA\u0011\"!\u0011\u0001\u0003\u0003%\t%a\u0011\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t)\u0005\u0005\u0003\u0002H\u0005ESBAA%\u0015\u0011\tY%!\u0014\u0002\t1\fgn\u001a\u0006\u0003\u0003\u001f\nAA[1wC&\u0019a(!\u0013\t\u0013\u0005U\u0003!!A\u0005\u0002\u0005]\u0013\u0001\u00049s_\u0012,8\r^!sSRLXCAA-!\rY\u00121L\u0005\u0004\u0003;b\"aA%oi\"I\u0011\u0011\r\u0001\u0002\u0002\u0013\u0005\u00111M\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\ra\u0017Q\r\u0005\u000b\u0003O\ny&!AA\u0002\u0005e\u0013a\u0001=%c!I\u00111\u000e\u0001\u0002\u0002\u0013\u0005\u0013QN\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011q\u000e\t\u0006\u0003c\n9\b\\\u0007\u0003\u0003gR1!!\u001e\u001d\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003s\n\u0019H\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0011%\ti\bAA\u0001\n\u0003\ty(\u0001\u0005dC:,\u0015/^1m)\u0011\t\t)a\"\u0011\u0007m\t\u0019)C\u0002\u0002\u0006r\u0011qAQ8pY\u0016\fg\u000eC\u0005\u0002h\u0005m\u0014\u0011!a\u0001Y\"I\u00111\u0012\u0001\u0002\u0002\u0013\u0005\u0013QR\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005\u0005\u0015q\u0012\u0005\n\u0003O\nI)!AA\u00021Ds\u0002AAJ\u00033\u000bY*a(\u0002\"\u0006\u0015\u0016q\u0015\t\u0004#\u0005U\u0015bAAL\u0005\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAAO\u0003Q|f)\u0016(D?\"\"\u0018.\\3ti\u0006l\u0007\u000f\f\u0011g[RL\u0003%\f\u0011D_:4XM\u001d;tA\u0001$\u0018.\\3ti\u0006l\u0007\u000f\u0019\u0011u_\u0002\n\u0007E^1mk\u0016\u0004sN\u001a\u0011tiJLgn\u001a\u0011j]\u0002\"\b.\u001a\u0011g_Jl\u0017\r\u001e\u0011ta\u0016\u001c\u0017NZ5fI\u0002\u0012\u0017\u0010\t;iK\u0002\"\u0017\r^3!M>\u0014X.\u0019;!A\u001alG\u000f\u0019\u0018\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!a)\u0002\u000f*\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~CsE\r\u00192m5\u0002D'\f\u00199O1\u0002s%_\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001\u0012\u0004'\r\u001c\u000bA\u0001\nQa]5oG\u0016\f#!!+\u0002\u000bErSG\f\u0019\b\u0013\u00055&!!A\t\u0002\u0005=\u0016a\u0004#bi\u00164uN]7bi\u000ec\u0017m]:\u0011\u0007E\t\tL\u0002\u0005\u0002\u0005\u0005\u0005\t\u0012AAZ'\u0015\t\t,!.!!!\t9,!0'MI*UBAA]\u0015\r\tY\fH\u0001\beVtG/[7f\u0013\u0011\ty,!/\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t7\u0007C\u0004D\u0003c#\t!a1\u0015\u0005\u0005=\u0006BCAd\u0003c\u000b\t\u0011\"\u0012\u0002J\u0006AAo\\*ue&tw\r\u0006\u0002\u0002F!Q\u0011QZAY\u0003\u0003%\t)a4\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000f\u0015\u000b\t.a5\u0002V\"1A%a3A\u0002\u0019Ba\u0001LAf\u0001\u00041\u0003\u0002\u0003\u0019\u0002LB\u0005\t\u0019\u0001\u001a\t\u0015\u0005e\u0017\u0011WA\u0001\n\u0003\u000bY.A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005u\u0017Q\u001d\t\u00057M\ny\u000e\u0005\u0004\u001c\u0003C4cEM\u0005\u0004\u0003Gd\"A\u0002+va2,7\u0007C\u0005\u0002h\u0006]\u0017\u0011!a\u0001\u000b\u0006\u0019\u0001\u0010\n\u0019\t\u0015\u0005-\u0018\u0011WI\u0001\n\u0003\tY$A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$He\r\u0005\u000b\u0003_\f\t,%A\u0005\u0002\u0005m\u0012aD1qa2LH\u0005Z3gCVdG\u000fJ\u001a\t\u0015\u0005M\u0018\u0011WA\u0001\n\u0013\t)0A\u0006sK\u0006$'+Z:pYZ,GCAA|!\u0011\t9%!?\n\t\u0005m\u0018\u0011\n\u0002\u0007\u001f\nTWm\u0019;")
public class DateFormatClass
extends BinaryExpression
implements TimeZoneAwareExpression,
ImplicitCastInputTypes,
scala.Serializable {
    private final Expression left;
    private final Expression right;
    private final Option<String> timeZoneId;
    private boolean resolved;
    private transient TimeZone timeZone;
    private volatile boolean bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public static Option<String> apply$default$3() {
        return DateFormatClass$.MODULE$.apply$default$3();
    }

    public static Option<String> $lessinit$greater$default$3() {
        return DateFormatClass$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple3<Expression, Expression, Option<String>>> unapply(DateFormatClass dateFormatClass) {
        return DateFormatClass$.MODULE$.unapply(dateFormatClass);
    }

    public static Function1<Tuple3<Expression, Expression, Option<String>>, DateFormatClass> tupled() {
        return DateFormatClass$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Option<String>, DateFormatClass>>> curried() {
        return DateFormatClass$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    private boolean resolved$lzycompute() {
        DateFormatClass dateFormatClass = this;
        synchronized (dateFormatClass) {
            if (!this.bitmap$0) {
                this.resolved = TimeZoneAwareExpression.resolved$(this);
                this.bitmap$0 = true;
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        return !this.bitmap$0 ? this.resolved$lzycompute() : this.resolved;
    }

    private TimeZone timeZone$lzycompute() {
        DateFormatClass dateFormatClass = this;
        synchronized (dateFormatClass) {
            if (!this.bitmap$trans$0) {
                this.timeZone = TimeZoneAwareExpression.timeZone$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.timeZone;
    }

    @Override
    public TimeZone timeZone() {
        return !this.bitmap$trans$0 ? this.timeZone$lzycompute() : this.timeZone;
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AtomicType[]{TimestampType$.MODULE$, StringType$.MODULE$}));
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Option x$11 = Option$.MODULE$.apply((Object)timeZoneId);
        Expression x$12 = this.copy$default$1();
        Expression x$13 = this.copy$default$2();
        return this.copy(x$12, x$13, (Option<String>)x$11);
    }

    @Override
    public Object nullSafeEval(Object timestamp, Object format) {
        DateFormat df = DateTimeUtils$.MODULE$.newDateFormat(format.toString(), this.timeZone());
        return UTF8String.fromString((String)df.format(new Date(BoxesRunTime.unboxToLong((Object)timestamp) / 1000L)));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String dtu = new StringOps(Predef$.MODULE$.augmentString(DateTimeUtils$.MODULE$.getClass().getName())).stripSuffix("$");
        String tz = ctx.addReferenceObj("timeZone", this.timeZone(), ctx.addReferenceObj$default$3());
        return this.defineCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(timestamp, format) -> new StringBuilder(99).append("UTF8String.fromString(").append(dtu).append(".newDateFormat(").append((String)format).append(".toString(), ").append(tz).append(")\n          .format(new java.util.Date(").append((String)timestamp).append(" / 1000)))").toString());
    }

    @Override
    public String prettyName() {
        return "date_format";
    }

    public DateFormatClass copy(Expression left, Expression right, Option<String> timeZoneId) {
        return new DateFormatClass(left, right, timeZoneId);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    public Option<String> copy$default$3() {
        return this.timeZoneId();
    }

    @Override
    public String productPrefix() {
        return "DateFormatClass";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Option<String> option;
        int n = x$1;
        switch (n) {
            case 0: {
                option = this.left();
                break;
            }
            case 1: {
                option = this.right();
                break;
            }
            case 2: {
                option = this.timeZoneId();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return option;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof DateFormatClass;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof DateFormatClass)) return false;
        boolean bl = true;
        if (!bl) return false;
        DateFormatClass dateFormatClass = (DateFormatClass)x$1;
        Expression expression = this.left();
        Expression expression2 = dateFormatClass.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = dateFormatClass.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Option<String> option = this.timeZoneId();
        Option<String> option2 = dateFormatClass.timeZoneId();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!dateFormatClass.canEqual(this)) return false;
        return true;
    }

    public DateFormatClass(Expression left, Expression right, Option<String> timeZoneId) {
        this.left = left;
        this.right = right;
        this.timeZoneId = timeZoneId;
        TimeZoneAwareExpression.$init$(this);
        ExpectsInputTypes.$init$(this);
    }

    public DateFormatClass(Expression left, Expression right) {
        this(left, right, (Option<String>)None$.MODULE$);
    }
}

