/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.analysis.TypeCoercion$;
import org.apache.spark.sql.catalyst.expressions.ElementAt$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.GetMapValueUtil;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.IntegralType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.MapType$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(array, index) - Returns element of array at given (1-based) index. If index < 0,\n      accesses elements from the last to the first. Returns NULL if the index exceeds the length\n      of the array.\n\n    _FUNC_(map, key) - Returns value for given key, or NULL if the key is not contained in the map\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(array(1, 2, 3), 2);\n       2\n      > SELECT _FUNC_(map(1, 'a', 2, 'b'), 2);\n       b\n  ", since="2.4.0")
@ScalaSignature(bytes="\u0006\u0001\t\u001da\u0001B\u0001\u0003\u0001>\u0011\u0011\"\u00127f[\u0016tG/\u0011;\u000b\u0005\r!\u0011aC3yaJ,7o]5p]NT!!\u0002\u0004\u0002\u0011\r\fG/\u00197zgRT!a\u0002\u0005\u0002\u0007M\fHN\u0003\u0002\n\u0015\u0005)1\u000f]1sW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u0019B\u0001\u0001\t\u00155A\u0011\u0011CE\u0007\u0002\u0005%\u00111C\u0001\u0002\u0010\u000f\u0016$X*\u00199WC2,X-\u0016;jYB\u0011Q\u0003G\u0007\u0002-)\tq#A\u0003tG\u0006d\u0017-\u0003\u0002\u001a-\t9\u0001K]8ek\u000e$\bCA\u000b\u001c\u0013\tabC\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0003\u0005\u001f\u0001\tU\r\u0011\"\u0001 \u0003\u0011aWM\u001a;\u0016\u0003\u0001\u0002\"!E\u0011\n\u0005\t\u0012!AC#yaJ,7o]5p]\"AA\u0005\u0001B\tB\u0003%\u0001%A\u0003mK\u001a$\b\u0005\u0003\u0005'\u0001\tU\r\u0011\"\u0001 \u0003\u0015\u0011\u0018n\u001a5u\u0011!A\u0003A!E!\u0002\u0013\u0001\u0013A\u0002:jO\"$\b\u0005C\u0003+\u0001\u0011\u00051&\u0001\u0004=S:LGO\u0010\u000b\u0004Y5r\u0003CA\t\u0001\u0011\u0015q\u0012\u00061\u0001!\u0011\u00151\u0013\u00061\u0001!\u0011!\u0001\u0004\u0001#b\u0001\n\u0013\t\u0014AC7ba.+\u0017\u0010V=qKV\t!\u0007\u0005\u00024m5\tAG\u0003\u00026\r\u0005)A/\u001f9fg&\u0011q\u0007\u000e\u0002\t\t\u0006$\u0018\rV=qK\"\u0012q&\u000f\t\u0003+iJ!a\u000f\f\u0003\u0013Q\u0014\u0018M\\:jK:$\b\u0002C\u001f\u0001\u0011\u000b\u0007I\u0011\u0002 \u0002#\u0005\u0014(/Y=D_:$\u0018-\u001b8t\u001dVdG.F\u0001@!\t)\u0002)\u0003\u0002B-\t9!i\\8mK\u0006t\u0007F\u0001\u001f:\u0011!!\u0005\u0001#b\u0001\n\u0013)\u0015\u0001C8sI\u0016\u0014\u0018N\\4\u0016\u0003\u0019\u00032aR(S\u001d\tAUJ\u0004\u0002J\u00196\t!J\u0003\u0002L\u001d\u00051AH]8pizJ\u0011aF\u0005\u0003\u001dZ\tq\u0001]1dW\u0006<W-\u0003\u0002Q#\nAqJ\u001d3fe&twM\u0003\u0002O-A\u0011QcU\u0005\u0003)Z\u00111!\u00118zQ\t\u0019\u0015\b\u0003\u0005X\u0001!\u0015\r\u0011\"\u00112\u0003!!\u0017\r^1UsB,\u0007F\u0001,:\u0011\u0015Q\u0006\u0001\"\u0011\\\u0003)Ig\u000e];u)f\u0004Xm]\u000b\u00029B\u0019q)X0\n\u0005y\u000b&aA*fcB\u00111\u0007Y\u0005\u0003CR\u0012\u0001#\u00112tiJ\f7\r\u001e#bi\u0006$\u0016\u0010]3\t\u000b\r\u0004A\u0011\t3\u0002'\rDWmY6J]B,H\u000fR1uCRK\b/Z:\u0015\u0003\u0015\u0004\"AZ5\u000e\u0003\u001dT!\u0001\u001b\u0003\u0002\u0011\u0005t\u0017\r\\=tSNL!A[4\u0003\u001fQK\b/Z\"iK\u000e\\'+Z:vYRDQ\u0001\u001c\u0001\u0005By\n\u0001B\\;mY\u0006\u0014G.\u001a\u0005\u0006]\u0002!\te\\\u0001\r]VdGnU1gK\u00163\u0018\r\u001c\u000b\u0004%B\u0014\b\"B9n\u0001\u0004\u0011\u0016!\u0002<bYV,\u0007\"B:n\u0001\u0004\u0011\u0016aB8sI&t\u0017\r\u001c\u0005\tk\u0002A)\u0019!C\u0005m\u0006YAm\\#mK6,g\u000e^!u+\u00059\b#B\u000by%J\u0013\u0016BA=\u0017\u0005%1UO\\2uS>t'\u0007\u000b\u0002us!)A\u0010\u0001C!{\u0006IAm\\$f]\u000e{G-\u001a\u000b\u0006}\u0006%\u00111\u0003\t\u0004\u007f\u0006\u0015QBAA\u0001\u0015\r\t\u0019AA\u0001\bG>$WmZ3o\u0013\u0011\t9!!\u0001\u0003\u0011\u0015C\bO]\"pI\u0016Dq!a\u0003|\u0001\u0004\ti!A\u0002dib\u00042a`A\b\u0013\u0011\t\t\"!\u0001\u0003\u001d\r{G-Z4f]\u000e{g\u000e^3yi\"1\u0011QC>A\u0002y\f!!\u001a<\t\u000f\u0005e\u0001\u0001\"\u0011\u0002\u001c\u0005Q\u0001O]3uift\u0015-\\3\u0016\u0005\u0005u\u0001\u0003BA\u0010\u0003OqA!!\t\u0002$A\u0011\u0011JF\u0005\u0004\u0003K1\u0012A\u0002)sK\u0012,g-\u0003\u0003\u0002*\u0005-\"AB*ue&twMC\u0002\u0002&YA\u0011\"a\f\u0001\u0003\u0003%\t!!\r\u0002\t\r|\u0007/\u001f\u000b\u0006Y\u0005M\u0012Q\u0007\u0005\t=\u00055\u0002\u0013!a\u0001A!Aa%!\f\u0011\u0002\u0003\u0007\u0001\u0005C\u0005\u0002:\u0001\t\n\u0011\"\u0001\u0002<\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA\u001fU\r\u0001\u0013qH\u0016\u0003\u0003\u0003\u0002B!a\u0011\u0002N5\u0011\u0011Q\t\u0006\u0005\u0003\u000f\nI%A\u0005v]\u000eDWmY6fI*\u0019\u00111\n\f\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002P\u0005\u0015#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"I\u00111\u000b\u0001\u0012\u0002\u0013\u0005\u00111H\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u0011%\t9\u0006AA\u0001\n\u0003\nI&A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u00037\u0002B!!\u0018\u0002h5\u0011\u0011q\f\u0006\u0005\u0003C\n\u0019'\u0001\u0003mC:<'BAA3\u0003\u0011Q\u0017M^1\n\t\u0005%\u0012q\f\u0005\n\u0003W\u0002\u0011\u0011!C\u0001\u0003[\nA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!a\u001c\u0011\u0007U\t\t(C\u0002\u0002tY\u00111!\u00138u\u0011%\t9\bAA\u0001\n\u0003\tI(\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\u0007I\u000bY\b\u0003\u0006\u0002~\u0005U\u0014\u0011!a\u0001\u0003_\n1\u0001\u001f\u00132\u0011%\t\t\tAA\u0001\n\u0003\n\u0019)A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t)\tE\u0003\u0002\b\u00065%+\u0004\u0002\u0002\n*\u0019\u00111\u0012\f\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\u0010\u0006%%\u0001C%uKJ\fGo\u001c:\t\u0013\u0005M\u0005!!A\u0005\u0002\u0005U\u0015\u0001C2b]\u0016\u000bX/\u00197\u0015\u0007}\n9\nC\u0005\u0002~\u0005E\u0015\u0011!a\u0001%\"I\u00111\u0014\u0001\u0002\u0002\u0013\u0005\u0013QT\u0001\u0007KF,\u0018\r\\:\u0015\u0007}\ny\nC\u0005\u0002~\u0005e\u0015\u0011!a\u0001%\"z\u0001!a)\u0002*\u0006-\u0016qVAY\u0003k\u000b9\fE\u0002\u0012\u0003KK1!a*\u0003\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!!,\u0002\u0005cR\u0001\u0005\t\u0011!?\u001a+fjQ0)CJ\u0014\u0018-\u001f\u0017!S:$W\r_\u0015![\u0001\u0012V\r^;s]N\u0004S\r\\3nK:$\be\u001c4!CJ\u0014\u0018-\u001f\u0011bi\u0002:\u0017N^3oA!\nTFY1tK\u0012L\u0003%\u001b8eKbt\u0003%\u00134!S:$W\r\u001f\u0011=AAb#\u0002\t\u0011!A\u0001\u0002\u0013mY2fgN,7\u000fI3mK6,g\u000e^:!MJ|W\u000e\t;iK\u0002b\u0017m\u001d;!i>\u0004C\u000f[3!M&\u00148\u000f\u001e\u0018!%\u0016$XO\u001d8tA9+F\n\u0014\u0011jM\u0002\"\b.\u001a\u0011j]\u0012,\u0007\u0010I3yG\u0016,Gm\u001d\u0011uQ\u0016\u0004C.\u001a8hi\"T\u0001\u0005\t\u0011!A\u0001zg\r\t;iK\u0002\n'O]1z])Q\u0001\u0005\t\u0011!?\u001a+fjQ0)[\u0006\u0004H\u0006I6fs&\u0002S\u0006\t*fiV\u0014hn\u001d\u0011wC2,X\r\t4pe\u0002:\u0017N^3oA-,\u0017\u0010\f\u0011pe\u0002rU\u000b\u0014'!S\u001a\u0004C\u000f[3!W\u0016L\b%[:!]>$\beY8oi\u0006Lg.\u001a3!S:\u0004C\u000f[3![\u0006\u0004(\u0002\t\u0011\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!a-\u0002y*\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~C\u0013M\u001d:bs\"\nD\u0006\t\u001a-AMJC\u0006\t\u001a*w)\u0001\u0003\u0005\t\u0011!A\u0001\u0012$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK7ba\"\nD\u0006I\u0014bO1\u0002#\u0007\f\u0011(E\u001eJC\u0006\t\u001a*w)\u0001\u0003\u0005\t\u0011!A\u0001\u0012'\u0002\t\u0011\u0002\u000bMLgnY3\"\u0005\u0005e\u0016!\u0002\u001a/i9\u0002t!CA_\u0005\u0005\u0005\t\u0012AA`\u0003%)E.Z7f]R\fE\u000fE\u0002\u0012\u0003\u00034\u0001\"\u0001\u0002\u0002\u0002#\u0005\u00111Y\n\u0006\u0003\u0003\f)M\u0007\t\b\u0003\u000f\fi\r\t\u0011-\u001b\t\tIMC\u0002\u0002LZ\tqA];oi&lW-\u0003\u0003\u0002P\u0006%'!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oe!9!&!1\u0005\u0002\u0005MGCAA`\u0011)\t9.!1\u0002\u0002\u0013\u0015\u0013\u0011\\\u0001\ti>\u001cFO]5oOR\u0011\u00111\f\u0005\u000b\u0003;\f\t-!A\u0005\u0002\u0006}\u0017!B1qa2LH#\u0002\u0017\u0002b\u0006\r\bB\u0002\u0010\u0002\\\u0002\u0007\u0001\u0005\u0003\u0004'\u00037\u0004\r\u0001\t\u0005\u000b\u0003O\f\t-!A\u0005\u0002\u0006%\u0018aB;oCB\u0004H.\u001f\u000b\u0005\u0003W\f9\u0010E\u0003\u0016\u0003[\f\t0C\u0002\u0002pZ\u0011aa\u00149uS>t\u0007#B\u000b\u0002t\u0002\u0002\u0013bAA{-\t1A+\u001e9mKJB\u0011\"!?\u0002f\u0006\u0005\t\u0019\u0001\u0017\u0002\u0007a$\u0003\u0007\u0003\u0006\u0002~\u0006\u0005\u0017\u0011!C\u0005\u0003\u007f\f1B]3bIJ+7o\u001c7wKR\u0011!\u0011\u0001\t\u0005\u0003;\u0012\u0019!\u0003\u0003\u0003\u0006\u0005}#AB(cU\u0016\u001cG\u000f")
public class ElementAt
extends GetMapValueUtil
implements scala.Serializable {
    private transient DataType mapKeyType;
    private transient boolean arrayContainsNull;
    private transient Ordering<Object> ordering;
    private transient DataType dataType;
    private transient Function2<Object, Object, Object> doElementAt;
    private final Expression left;
    private final Expression right;
    private volatile transient byte bitmap$trans$0;

    public static Option<Tuple2<Expression, Expression>> unapply(ElementAt elementAt) {
        return ElementAt$.MODULE$.unapply(elementAt);
    }

    public static Function1<Tuple2<Expression, Expression>, ElementAt> tupled() {
        return ElementAt$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, ElementAt>> curried() {
        return ElementAt$.MODULE$.curried();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    private DataType mapKeyType$lzycompute() {
        ElementAt elementAt = this;
        synchronized (elementAt) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.mapKeyType = ((MapType)this.left().dataType()).keyType();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.mapKeyType;
    }

    private DataType mapKeyType() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.mapKeyType$lzycompute() : this.mapKeyType;
    }

    private boolean arrayContainsNull$lzycompute() {
        ElementAt elementAt = this;
        synchronized (elementAt) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.arrayContainsNull = ((ArrayType)this.left().dataType()).containsNull();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.arrayContainsNull;
    }

    private boolean arrayContainsNull() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.arrayContainsNull$lzycompute() : this.arrayContainsNull;
    }

    private Ordering<Object> ordering$lzycompute() {
        ElementAt elementAt = this;
        synchronized (elementAt) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.ordering = TypeUtils$.MODULE$.getInterpretedOrdering(this.mapKeyType());
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.ordering;
    }

    private Ordering<Object> ordering() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.ordering$lzycompute() : this.ordering;
    }

    private DataType dataType$lzycompute() {
        ElementAt elementAt = this;
        synchronized (elementAt) {
            if ((byte)(this.bitmap$trans$0 & 8) == 0) {
                DataType dataType;
                DataType dataType2 = this.left().dataType();
                if (dataType2 instanceof ArrayType) {
                    DataType elementType;
                    ArrayType arrayType = (ArrayType)dataType2;
                    dataType = elementType = arrayType.elementType();
                } else if (dataType2 instanceof MapType) {
                    DataType valueType;
                    MapType mapType = (MapType)dataType2;
                    dataType = valueType = mapType.valueType();
                } else {
                    throw new MatchError((Object)dataType2);
                }
                this.dataType = dataType;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 8);
            }
        }
        return this.dataType;
    }

    @Override
    public DataType dataType() {
        return (byte)(this.bitmap$trans$0 & 8) == 0 ? this.dataType$lzycompute() : this.dataType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Seq<AbstractDataType> inputTypes() {
        Tuple2 tuple2 = new Tuple2((Object)this.left().dataType(), (Object)this.right().dataType());
        if (tuple2 != null) {
            DataType arr = (DataType)tuple2._1();
            DataType e2 = (DataType)tuple2._2();
            if (arr instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)arr;
                if (e2 instanceof IntegralType) {
                    IntegralType integralType;
                    IntegralType integralType2 = integralType = (IntegralType)e2;
                    LongType$ longType$ = LongType$.MODULE$;
                    if (integralType2 == null ? longType$ != null : !integralType2.equals(longType$)) {
                        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DataType[]{arrayType, IntegerType$.MODULE$}));
                    }
                }
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            DataType e2 = (DataType)tuple2._2();
            if (dataType instanceof MapType) {
                Seq seq;
                MapType mapType = (MapType)dataType;
                DataType keyType = mapType.keyType();
                DataType valueType = mapType.valueType();
                boolean hasNull = mapType.valueContainsNull();
                Option option = (Option)TypeCoercion$.MODULE$.findTightestCommonType().apply((Object)keyType, (Object)e2);
                if (option instanceof Some) {
                    Some some = (Some)option;
                    DataType dt = (DataType)some.value();
                    seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DataType[]{new MapType(dt, valueType, hasNull), dt}));
                    return seq;
                } else {
                    seq = (Seq)Seq$.MODULE$.empty();
                }
                return seq;
            }
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        return (Seq)Seq$.MODULE$.empty();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    public TypeCheckResult checkInputDataTypes() {
        DataType e1;
        void var1_8;
        Tuple2 tuple2 = new Tuple2((Object)this.left().dataType(), (Object)this.right().dataType());
        if (tuple2 != null) {
            DataType e2 = (DataType)tuple2._2();
            if (tuple2._1() instanceof ArrayType) {
                DataType dataType = e2;
                IntegerType$ integerType$ = IntegerType$.MODULE$;
                if (dataType == null ? integerType$ != null : !dataType.equals(integerType$)) {
                    TypeCheckResult.TypeCheckFailure typeCheckFailure = new TypeCheckResult.TypeCheckFailure(new StringBuilder(31).append("Input to function ").append(this.prettyName()).append(" should have ").append(new StringBuilder(31).append("been ").append(ArrayType$.MODULE$.simpleString()).append(" followed by a ").append(IntegerType$.MODULE$.simpleString()).append(", but it's ").toString()).append(new StringBuilder(5).append("[").append(this.left().dataType().catalogString()).append(", ").append(this.right().dataType().catalogString()).append("].").toString()).toString());
                    return var1_8;
                }
            }
        }
        if (tuple2 != null) {
            MapType mapType;
            DataType e12;
            DataType dataType = (DataType)tuple2._1();
            DataType e2 = (DataType)tuple2._2();
            if (dataType instanceof MapType && !e2.sameType(e12 = (mapType = (MapType)dataType).keyType())) {
                TypeCheckResult.TypeCheckFailure typeCheckFailure = new TypeCheckResult.TypeCheckFailure(new StringBuilder(31).append("Input to function ").append(this.prettyName()).append(" should have ").append(new StringBuilder(53).append("been ").append(MapType$.MODULE$.simpleString()).append(" followed by a value of same key type, but it's ").toString()).append(new StringBuilder(5).append("[").append(this.left().dataType().catalogString()).append(", ").append(this.right().dataType().catalogString()).append("].").toString()).toString());
                return var1_8;
            }
        }
        if (tuple2 != null && !((e1 = (DataType)tuple2._1()) instanceof MapType) && !(e1 instanceof ArrayType)) {
            TypeCheckResult.TypeCheckFailure typeCheckFailure = new TypeCheckResult.TypeCheckFailure(new StringBuilder(39).append("The first argument to function ").append(this.prettyName()).append(" should ").append(new StringBuilder(29).append("have been ").append(ArrayType$.MODULE$.simpleString()).append(" or ").append(MapType$.MODULE$.simpleString()).append(" type, but its ").toString()).append(new StringBuilder(6).append(this.left().dataType().catalogString()).append(" type.").toString()).toString());
            return var1_8;
        }
        TypeCheckResult$TypeCheckSuccess$ typeCheckResult$TypeCheckSuccess$ = TypeCheckResult$TypeCheckSuccess$.MODULE$;
        return var1_8;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public Object nullSafeEval(Object value, Object ordinal) {
        return this.doElementAt().apply(value, ordinal);
    }

    private Function2<Object, Object, Object> doElementAt$lzycompute() {
        ElementAt elementAt = this;
        synchronized (elementAt) {
            if ((byte)(this.bitmap$trans$0 & 0x10) == 0) {
                Function2 & Serializable & scala.Serializable intersect;
                DataType dataType = this.left().dataType();
                if (dataType instanceof ArrayType) {
                    intersect = (Function2 & Serializable & scala.Serializable)(value, ordinal) -> {
                        Object object;
                        ArrayData array = (ArrayData)value;
                        int index = BoxesRunTime.unboxToInt((Object)ordinal);
                        if (array.numElements() < package$.MODULE$.abs(index)) {
                            object = null;
                        } else {
                            if (index == 0) {
                                throw new ArrayIndexOutOfBoundsException("SQL array indices start at 1");
                            }
                            int idx = index > 0 ? index - 1 : array.numElements() + index;
                            object = this.arrayContainsNull() && array.isNullAt(idx) ? null : array.get(idx, this.dataType());
                        }
                        return object;
                    };
                } else if (dataType instanceof MapType) {
                    intersect = (Function2 & Serializable & scala.Serializable)(value, ordinal) -> this.getValueEval(value, ordinal, this.mapKeyType(), this.ordering());
                } else {
                    throw new MatchError((Object)dataType);
                }
                this.doElementAt = intersect;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 0x10);
            }
        }
        return this.doElementAt;
    }

    private Function2<Object, Object, Object> doElementAt() {
        return (byte)(this.bitmap$trans$0 & 0x10) == 0 ? this.doElementAt$lzycompute() : this.doElementAt;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode exprCode;
        DataType dataType = this.left().dataType();
        if (dataType instanceof ArrayType) {
            exprCode = this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(eval1, eval2) -> {
                String index = ctx.freshName("elementAtIndex");
                String nullCheck = this.arrayContainsNull() ? new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(99).append("\n               |if (").append((String)eval1).append(".isNullAt(").append(index).append(")) {\n               |  ").append(ev.isNull()).append(" = true;\n               |} else\n             ").toString())).stripMargin() : "";
                return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(489).append("\n             |int ").append(index).append(" = (int) ").append((String)eval2).append(";\n             |if (").append((String)eval1).append(".numElements() < Math.abs(").append(index).append(")) {\n             |  ").append(ev.isNull()).append(" = true;\n             |} else {\n             |  if (").append(index).append(" == 0) {\n             |    throw new ArrayIndexOutOfBoundsException(\"SQL array indices start at 1\");\n             |  } else if (").append(index).append(" > 0) {\n             |    ").append(index).append("--;\n             |  } else {\n             |    ").append(index).append(" += ").append((String)eval1).append(".numElements();\n             |  }\n             |  ").append(nullCheck).append("\n             |  {\n             |    ").append(ev.value()).append(" = ").append(CodeGenerator$.MODULE$.getValue((String)eval1, this.dataType(), index)).append(";\n             |  }\n             |}\n           ").toString())).stripMargin();
            });
        } else if (dataType instanceof MapType) {
            exprCode = this.doGetValueGenCode(ctx, ev, (MapType)this.left().dataType());
        } else {
            throw new MatchError((Object)dataType);
        }
        return exprCode;
    }

    @Override
    public String prettyName() {
        return "element_at";
    }

    public ElementAt copy(Expression left, Expression right) {
        return new ElementAt(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "ElementAt";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.left();
                break;
            }
            case 1: {
                expression = this.right();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ElementAt;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ElementAt)) return false;
        boolean bl = true;
        if (!bl) return false;
        ElementAt elementAt = (ElementAt)x$1;
        Expression expression = this.left();
        Expression expression2 = elementAt.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = elementAt.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!elementAt.canEqual(this)) return false;
        return true;
    }

    public ElementAt(Expression left, Expression right) {
        this.left = left;
        this.right = right;
    }
}

