/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.BinaryComparison;
import org.apache.spark.sql.catalyst.expressions.EqualNullSafe$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprValue$;
import org.apache.spark.sql.catalyst.expressions.codegen.FalseLiteral$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    expr1 _FUNC_ expr2 - Returns same result as the EQUAL(=) operator for non-null operands,\n      but returns true if both are null, false if one of the them is null.\n  ", arguments="\n    Arguments:\n      * expr1, expr2 - the two expressions must be same type or can be casted to a common type,\n          and must be a type that can be used in equality comparison. Map type is not supported.\n          For complex types such array/struct, the data types of fields must be orderable.\n  ", examples="\n    Examples:\n      > SELECT 2 _FUNC_ 2;\n       true\n      > SELECT 1 _FUNC_ '1';\n       true\n      > SELECT true _FUNC_ NULL;\n       false\n      > SELECT NULL _FUNC_ NULL;\n       true\n  ")
@ScalaSignature(bytes="\u0006\u0001\u0005ee\u0001B\u0001\u0003\u0001>\u0011Q\"R9vC2tU\u000f\u001c7TC\u001a,'BA\u0002\u0005\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005\u00151\u0011\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005\u001dA\u0011aA:rY*\u0011\u0011BC\u0001\u0006gB\f'o\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001\u0001BC\u0007\t\u0003#Ii\u0011AA\u0005\u0003'\t\u0011\u0001CQ5oCJL8i\\7qCJL7o\u001c8\u0011\u0005UAR\"\u0001\f\u000b\u0003]\tQa]2bY\u0006L!!\u0007\f\u0003\u000fA\u0013x\u000eZ;diB\u0011QcG\u0005\u00039Y\u0011AbU3sS\u0006d\u0017N_1cY\u0016D\u0001B\b\u0001\u0003\u0016\u0004%\taH\u0001\u0005Y\u00164G/F\u0001!!\t\t\u0012%\u0003\u0002#\u0005\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\t\u0011\u0011\u0002!\u0011#Q\u0001\n\u0001\nQ\u0001\\3gi\u0002B\u0001B\n\u0001\u0003\u0016\u0004%\taH\u0001\u0006e&<\u0007\u000e\u001e\u0005\tQ\u0001\u0011\t\u0012)A\u0005A\u00051!/[4ii\u0002BQA\u000b\u0001\u0005\u0002-\na\u0001P5oSRtDc\u0001\u0017.]A\u0011\u0011\u0003\u0001\u0005\u0006=%\u0002\r\u0001\t\u0005\u0006M%\u0002\r\u0001\t\u0005\u0006a\u0001!\t%M\u0001\u0007gfl'm\u001c7\u0016\u0003I\u0002\"a\r\u001e\u000f\u0005QB\u0004CA\u001b\u0017\u001b\u00051$BA\u001c\u000f\u0003\u0019a$o\\8u}%\u0011\u0011HF\u0001\u0007!J,G-\u001a4\n\u0005mb$AB*ue&twM\u0003\u0002:-!)a\b\u0001C!\u007f\u0005Aa.\u001e7mC\ndW-F\u0001A!\t)\u0012)\u0003\u0002C-\t9!i\\8mK\u0006t\u0007\"\u0002#\u0001\t\u0003*\u0015\u0001B3wC2$\"AR%\u0011\u0005U9\u0015B\u0001%\u0017\u0005\r\te.\u001f\u0005\b\u0015\u000e\u0003\n\u00111\u0001L\u0003\u0015Ig\u000e];u!\taU*D\u0001\u0005\u0013\tqEAA\u0006J]R,'O\\1m%><\b\"\u0002)\u0001\t\u0003\n\u0016!\u00033p\u000f\u0016t7i\u001c3f)\r\u0011\u0006,\u0018\t\u0003'Zk\u0011\u0001\u0016\u0006\u0003+\n\tqaY8eK\u001e,g.\u0003\u0002X)\nAQ\t\u001f9s\u0007>$W\rC\u0003Z\u001f\u0002\u0007!,A\u0002dib\u0004\"aU.\n\u0005q#&AD\"pI\u0016<WM\\\"p]R,\u0007\u0010\u001e\u0005\u0006=>\u0003\rAU\u0001\u0003KZDq\u0001\u0019\u0001\u0002\u0002\u0013\u0005\u0011-\u0001\u0003d_BLHc\u0001\u0017cG\"9ad\u0018I\u0001\u0002\u0004\u0001\u0003b\u0002\u0014`!\u0003\u0005\r\u0001\t\u0005\bK\u0002\t\n\u0011\"\u0001g\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\u0012a\u001a\u0016\u0003A!\\\u0013!\u001b\t\u0003U>l\u0011a\u001b\u0006\u0003Y6\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u000594\u0012AC1o]>$\u0018\r^5p]&\u0011\u0001o\u001b\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007b\u0002:\u0001#\u0003%\tAZ\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u0011\u001d!\b!!A\u0005BU\fQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DX#\u0001<\u0011\u0005]dX\"\u0001=\u000b\u0005eT\u0018\u0001\u00027b]\u001eT\u0011a_\u0001\u0005U\u00064\u0018-\u0003\u0002<q\"9a\u0010AA\u0001\n\u0003y\u0018\u0001\u00049s_\u0012,8\r^!sSRLXCAA\u0001!\r)\u00121A\u0005\u0004\u0003\u000b1\"aA%oi\"I\u0011\u0011\u0002\u0001\u0002\u0002\u0013\u0005\u00111B\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\r1\u0015Q\u0002\u0005\u000b\u0003\u001f\t9!!AA\u0002\u0005\u0005\u0011a\u0001=%c!I\u00111\u0003\u0001\u0002\u0002\u0013\u0005\u0013QC\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011q\u0003\t\u0006\u00033\tyBR\u0007\u0003\u00037Q1!!\b\u0017\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003C\tYB\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0011%\t)\u0003AA\u0001\n\u0003\t9#\u0001\u0005dC:,\u0015/^1m)\r\u0001\u0015\u0011\u0006\u0005\n\u0003\u001f\t\u0019#!AA\u0002\u0019C\u0011\"!\f\u0001\u0003\u0003%\t%a\f\u0002\r\u0015\fX/\u00197t)\r\u0001\u0015\u0011\u0007\u0005\n\u0003\u001f\tY#!AA\u0002\u0019Cs\u0002AA\u001b\u0003w\ti$!\u0011\u0002D\u0005\u001d\u0013\u0011\n\t\u0004#\u0005]\u0012bAA\u001d\u0005\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAA \u0003\u0005]#\u0002\t\u0011!A\u0015D\bO]\u0019!?\u001a+fjQ0!Kb\u0004(O\r\u0011.AI+G/\u001e:og\u0002\u001a\u0018-\\3!e\u0016\u001cX\u000f\u001c;!CN\u0004C\u000f[3!\u000bF+\u0016\t\u0014\u0015>S\u0001z\u0007/\u001a:bi>\u0014\bEZ8sA9|g.\f8vY2\u0004s\u000e]3sC:$7\u000f\f\u0006!A\u0001\u0002\u0003\u0005\t2vi\u0002\u0012X\r^;s]N\u0004CO];fA%4\u0007EY8uQ\u0002\n'/\u001a\u0011ok2dG\u0006\t4bYN,\u0007%\u001b4!_:,\u0007e\u001c4!i\",\u0007\u0005\u001e5f[\u0002J7\u000f\t8vY2t#\u0002\t\u0011\u0002\u0013\u0005\u0014x-^7f]R\u001c\u0018EAA#\u0003\tu#\u0002\t\u0011!A\u0005\u0013x-^7f]R\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011fqB\u0014\u0018\u0007\f\u0011fqB\u0014(\u0007I\u0017!i\",\u0007\u0005^<pA\u0015D\bO]3tg&|gn\u001d\u0011nkN$\bEY3!g\u0006lW\r\t;za\u0016\u0004sN\u001d\u0011dC:\u0004#-\u001a\u0011dCN$X\r\u001a\u0011u_\u0002\n\u0007eY8n[>t\u0007\u0005^=qK2R\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011b]\u0012\u0004S.^:uA\t,\u0007%\u0019\u0011usB,\u0007\u0005\u001e5bi\u0002\u001a\u0017M\u001c\u0011cK\u0002*8/\u001a3!S:\u0004S-];bY&$\u0018\u0010I2p[B\f'/[:p]:\u0002S*\u00199!if\u0004X\rI5tA9|G\u000fI:vaB|'\u000f^3e])\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t$pe\u0002\u001aw.\u001c9mKb\u0004C/\u001f9fg\u0002\u001aXo\u00195!CJ\u0014\u0018-_\u0018tiJ,8\r\u001e\u0017!i\",\u0007\u0005Z1uC\u0002\"\u0018\u0010]3tA=4\u0007EZ5fY\u0012\u001c\b%\\;ti\u0002\u0012W\rI8sI\u0016\u0014\u0018M\u00197f])\u0001\u0003%\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\tY%AA=\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002\u0012\u0004e\u0018$V\u001d\u000e{\u0006EM\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!iJ,XM\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u00112A}3UKT\"`A\u001d\nte\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011ueV,'\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000b\t;sk\u0016\u0004sLR+O\u0007~\u0003c*\u0016'Mw)\u0001\u0003\u0005\t\u0011!A\u00012\u0017\r\\:f\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002rU\u000b\u0014'!?\u001a+fjQ0!\u001dVcEj\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011ueV,'\u0002\t\u0011\b\u0013\u0005=#!!A\t\u0002\u0005E\u0013!D#rk\u0006dg*\u001e7m'\u00064W\rE\u0002\u0012\u0003'2\u0001\"\u0001\u0002\u0002\u0002#\u0005\u0011QK\n\u0006\u0003'\n9F\u0007\t\b\u00033\ny\u0006\t\u0011-\u001b\t\tYFC\u0002\u0002^Y\tqA];oi&lW-\u0003\u0003\u0002b\u0005m#!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oe!9!&a\u0015\u0005\u0002\u0005\u0015DCAA)\u0011)\tI'a\u0015\u0002\u0002\u0013\u0015\u00131N\u0001\ti>\u001cFO]5oOR\ta\u000f\u0003\u0006\u0002p\u0005M\u0013\u0011!CA\u0003c\nQ!\u00199qYf$R\u0001LA:\u0003kBaAHA7\u0001\u0004\u0001\u0003B\u0002\u0014\u0002n\u0001\u0007\u0001\u0005\u0003\u0006\u0002z\u0005M\u0013\u0011!CA\u0003w\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002~\u0005%\u0005#B\u000b\u0002\u0000\u0005\r\u0015bAAA-\t1q\n\u001d;j_:\u0004R!FACA\u0001J1!a\"\u0017\u0005\u0019!V\u000f\u001d7fe!I\u00111RA<\u0003\u0003\u0005\r\u0001L\u0001\u0004q\u0012\u0002\u0004BCAH\u0003'\n\t\u0011\"\u0003\u0002\u0012\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\t\u0019\nE\u0002x\u0003+K1!a&y\u0005\u0019y%M[3di\u0002")
public class EqualNullSafe
extends BinaryComparison
implements Serializable {
    private final Expression left;
    private final Expression right;

    public static Option<Tuple2<Expression, Expression>> unapply(EqualNullSafe equalNullSafe) {
        return EqualNullSafe$.MODULE$.unapply(equalNullSafe);
    }

    public static Function1<Tuple2<Expression, Expression>, EqualNullSafe> tupled() {
        return EqualNullSafe$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, EqualNullSafe>> curried() {
        return EqualNullSafe$.MODULE$.curried();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public String symbol() {
        return "<=>";
    }

    @Override
    public boolean nullable() {
        return false;
    }

    @Override
    public Object eval(InternalRow input) {
        Object input1 = this.left().eval(input);
        Object input2 = this.right().eval(input);
        return input1 == null && input2 == null ? BoxesRunTime.boxToBoolean((boolean)true) : (input1 == null || input2 == null ? BoxesRunTime.boxToBoolean((boolean)false) : BoxesRunTime.boxToBoolean((boolean)this.ordering().equiv(input1, input2)));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode eval1 = this.left().genCode(ctx);
        ExprCode eval2 = this.right().genCode(ctx);
        String equalCode = ctx.genEqual(this.left().dataType(), ExprValue$.MODULE$.exprValueToString(eval1.value()), ExprValue$.MODULE$.exprValueToString(eval2.value()));
        return ev.copy(eval1.code().$plus(eval2.code()).$plus(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        boolean ", " = (", " && ", ") ||\n           (!", " && !", " && ", ");"}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.value(), eval1.isNull(), eval2.isNull(), eval1.isNull(), eval2.isNull(), equalCode}))), FalseLiteral$.MODULE$, ev.copy$default$3());
    }

    public EqualNullSafe copy(Expression left, Expression right) {
        return new EqualNullSafe(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "EqualNullSafe";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.left();
                break;
            }
            case 1: {
                expression = this.right();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof EqualNullSafe;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof EqualNullSafe)) return false;
        boolean bl = true;
        if (!bl) return false;
        EqualNullSafe equalNullSafe = (EqualNullSafe)x$1;
        Expression expression = this.left();
        Expression expression2 = equalNullSafe.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = equalNullSafe.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!equalNullSafe.canEqual(this)) return false;
        return true;
    }

    public EqualNullSafe(Expression left, Expression right) {
        this.left = left;
        this.right = right;
    }
}

