/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.FindInSet$;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(str, str_array) - Returns the index (1-based) of the given string (`str`) in the comma-delimited list (`str_array`).\n      Returns 0, if the string was not found or if the given string (`str`) contains a comma.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('ab','abc,b,ab,c,def');\n       3\n  ")
@ScalaSignature(bytes="\u0006\u0001\u0005}f\u0001B\u0001\u0003\u0001>\u0011\u0011BR5oI&s7+\u001a;\u000b\u0005\r!\u0011aC3yaJ,7o]5p]NT!!\u0002\u0004\u0002\u0011\r\fG/\u00197zgRT!a\u0002\u0005\u0002\u0007M\fHN\u0003\u0002\n\u0015\u0005)1\u000f]1sW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u0019R\u0001\u0001\t\u0015/u\u0001\"!\u0005\n\u000e\u0003\tI!a\u0005\u0002\u0003!\tKg.\u0019:z\u000bb\u0004(/Z:tS>t\u0007CA\t\u0016\u0013\t1\"A\u0001\fJ[Bd\u0017nY5u\u0007\u0006\u001cH/\u00138qkR$\u0016\u0010]3t!\tA2$D\u0001\u001a\u0015\u0005Q\u0012!B:dC2\f\u0017B\u0001\u000f\u001a\u0005\u001d\u0001&o\u001c3vGR\u0004\"\u0001\u0007\u0010\n\u0005}I\"\u0001D*fe&\fG.\u001b>bE2,\u0007\u0002C\u0011\u0001\u0005+\u0007I\u0011\u0001\u0012\u0002\t1,g\r^\u000b\u0002GA\u0011\u0011\u0003J\u0005\u0003K\t\u0011!\"\u0012=qe\u0016\u001c8/[8o\u0011!9\u0003A!E!\u0002\u0013\u0019\u0013!\u00027fMR\u0004\u0003\u0002C\u0015\u0001\u0005+\u0007I\u0011\u0001\u0012\u0002\u000bILw\r\u001b;\t\u0011-\u0002!\u0011#Q\u0001\n\r\naA]5hQR\u0004\u0003\"B\u0017\u0001\t\u0003q\u0013A\u0002\u001fj]&$h\bF\u00020aE\u0002\"!\u0005\u0001\t\u000b\u0005b\u0003\u0019A\u0012\t\u000b%b\u0003\u0019A\u0012\t\u000bM\u0002A\u0011\t\u001b\u0002\u0015%t\u0007/\u001e;UsB,7/F\u00016!\r1d(\u0011\b\u0003oqr!\u0001O\u001e\u000e\u0003eR!A\u000f\b\u0002\rq\u0012xn\u001c;?\u0013\u0005Q\u0012BA\u001f\u001a\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u0010!\u0003\u0007M+\u0017O\u0003\u0002>3A\u0011!)R\u0007\u0002\u0007*\u0011AIB\u0001\u0006if\u0004Xm]\u0005\u0003\r\u000e\u0013\u0001#\u00112tiJ\f7\r\u001e#bi\u0006$\u0016\u0010]3\t\u000b!\u0003A\u0011K%\u0002\u00199,H\u000e\\*bM\u0016,e/\u00197\u0015\u0007)ku\n\u0005\u0002\u0019\u0017&\u0011A*\u0007\u0002\u0004\u0003:L\b\"\u0002(H\u0001\u0004Q\u0015\u0001B<pe\u0012DQ\u0001U$A\u0002)\u000b1a]3u\u0011\u0015\u0011\u0006\u0001\"\u0011T\u0003%!wnR3o\u0007>$W\rF\u0002U5~\u0003\"!\u0016-\u000e\u0003YS!a\u0016\u0002\u0002\u000f\r|G-Z4f]&\u0011\u0011L\u0016\u0002\t\u000bb\u0004(oQ8eK\")1,\u0015a\u00019\u0006\u00191\r\u001e=\u0011\u0005Uk\u0016B\u00010W\u00059\u0019u\u000eZ3hK:\u001cuN\u001c;fqRDQ\u0001Y)A\u0002Q\u000b!!\u001a<\t\u000b\t\u0004A\u0011I2\u0002\u0011\u0011\fG/\u0019+za\u0016,\u0012\u0001\u001a\t\u0003\u0005\u0016L!AZ\"\u0003\u0011\u0011\u000bG/\u0019+za\u0016DQ\u0001\u001b\u0001\u0005B%\f!\u0002\u001d:fiRLh*Y7f+\u0005Q\u0007CA6p\u001d\taW\u000e\u0005\u000293%\u0011a.G\u0001\u0007!J,G-\u001a4\n\u0005A\f(AB*ue&twM\u0003\u0002o3!91\u000fAA\u0001\n\u0003!\u0018\u0001B2paf$2aL;w\u0011\u001d\t#\u000f%AA\u0002\rBq!\u000b:\u0011\u0002\u0003\u00071\u0005C\u0004y\u0001E\u0005I\u0011A=\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\t!P\u000b\u0002$w.\nA\u0010E\u0002~\u0003\u000bi\u0011A \u0006\u0004\u007f\u0006\u0005\u0011!C;oG\",7m[3e\u0015\r\t\u0019!G\u0001\u000bC:tw\u000e^1uS>t\u0017bAA\u0004}\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0011\u0005-\u0001!%A\u0005\u0002e\fabY8qs\u0012\"WMZ1vYR$#\u0007C\u0005\u0002\u0010\u0001\t\t\u0011\"\u0011\u0002\u0012\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!a\u0005\u0011\t\u0005U\u0011qD\u0007\u0003\u0003/QA!!\u0007\u0002\u001c\u0005!A.\u00198h\u0015\t\ti\"\u0001\u0003kCZ\f\u0017b\u00019\u0002\u0018!I\u00111\u0005\u0001\u0002\u0002\u0013\u0005\u0011QE\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003O\u00012\u0001GA\u0015\u0013\r\tY#\u0007\u0002\u0004\u0013:$\b\"CA\u0018\u0001\u0005\u0005I\u0011AA\u0019\u00039\u0001(o\u001c3vGR,E.Z7f]R$2ASA\u001a\u0011)\t)$!\f\u0002\u0002\u0003\u0007\u0011qE\u0001\u0004q\u0012\n\u0004\"CA\u001d\u0001\u0005\u0005I\u0011IA\u001e\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA\u001f!\u0015\ty$!\u0012K\u001b\t\t\tEC\u0002\u0002De\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\t9%!\u0011\u0003\u0011%#XM]1u_JD\u0011\"a\u0013\u0001\u0003\u0003%\t!!\u0014\u0002\u0011\r\fg.R9vC2$B!a\u0014\u0002VA\u0019\u0001$!\u0015\n\u0007\u0005M\u0013DA\u0004C_>dW-\u00198\t\u0013\u0005U\u0012\u0011JA\u0001\u0002\u0004Q\u0005\"CA-\u0001\u0005\u0005I\u0011IA.\u0003\u0019)\u0017/^1mgR!\u0011qJA/\u0011%\t)$a\u0016\u0002\u0002\u0003\u0007!\nK\u0006\u0001\u0003C\n9'!\u001b\u0002n\u0005=\u0004cA\t\u0002d%\u0019\u0011Q\r\u0002\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u00111N\u0001\u0002D*\u0001\u0003\u0005\t\u0011`\rVs5i\u0018\u0015tiJd\u0003e\u001d;s?\u0006\u0014(/Y=*A5\u0002#+\u001a;ve:\u001c\b\u0005\u001e5fA%tG-\u001a=!QEj#-Y:fI&\u0002sN\u001a\u0011uQ\u0016\u0004s-\u001b<f]\u0002\u001aHO]5oO\u0002B\u0003m\u001d;sA&\u0002\u0013N\u001c\u0011uQ\u0016\u00043m\\7nC6\"W\r\\5nSR,G\r\t7jgR\u0004\u0003\u0006Y:ue~\u000b'O]1zA&r#\u0002\t\u0011!A\u0001\u0002#+\u001a;ve:\u001c\b\u0005\r\u0017!S\u001a\u0004C\u000f[3!gR\u0014\u0018N\\4!o\u0006\u001c\bE\\8uA\u0019|WO\u001c3!_J\u0004\u0013N\u001a\u0011uQ\u0016\u0004s-\u001b<f]\u0002\u001aHO]5oO\u0002B\u0003m\u001d;sA&\u00023m\u001c8uC&t7\u000fI1!G>lW.\u0019\u0018\u000bA\u0001\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0003c\n\u0001J\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015(C\n<CfJ1cG2\u0012G&\u00192-G2\"WMZ\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001\u001a$\u0002\t\u0011\b\u0013\u0005U$!!A\t\u0002\u0005]\u0014!\u0003$j]\u0012LenU3u!\r\t\u0012\u0011\u0010\u0004\t\u0003\t\t\t\u0011#\u0001\u0002|M)\u0011\u0011PA?;A9\u0011qPACG\rzSBAAA\u0015\r\t\u0019)G\u0001\beVtG/[7f\u0013\u0011\t9)!!\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t'\u0007C\u0004.\u0003s\"\t!a#\u0015\u0005\u0005]\u0004BCAH\u0003s\n\t\u0011\"\u0012\u0002\u0012\u0006AAo\\*ue&tw\r\u0006\u0002\u0002\u0014!Q\u0011QSA=\u0003\u0003%\t)a&\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000b=\nI*a'\t\r\u0005\n\u0019\n1\u0001$\u0011\u0019I\u00131\u0013a\u0001G!Q\u0011qTA=\u0003\u0003%\t)!)\u0002\u000fUt\u0017\r\u001d9msR!\u00111UAX!\u0015A\u0012QUAU\u0013\r\t9+\u0007\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000ba\tYkI\u0012\n\u0007\u00055\u0016D\u0001\u0004UkBdWM\r\u0005\n\u0003c\u000bi*!AA\u0002=\n1\u0001\u001f\u00131\u0011)\t),!\u001f\u0002\u0002\u0013%\u0011qW\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002:B!\u0011QCA^\u0013\u0011\ti,a\u0006\u0003\r=\u0013'.Z2u\u0001")
public class FindInSet
extends BinaryExpression
implements ImplicitCastInputTypes,
scala.Serializable {
    private final Expression left;
    private final Expression right;

    public static Option<Tuple2<Expression, Expression>> unapply(FindInSet findInSet) {
        return FindInSet$.MODULE$.unapply(findInSet);
    }

    public static Function1<Tuple2<Expression, Expression>, FindInSet> tupled() {
        return FindInSet$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, FindInSet>> curried() {
        return FindInSet$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StringType$[]{StringType$.MODULE$, StringType$.MODULE$}));
    }

    @Override
    public Object nullSafeEval(Object word, Object set) {
        return BoxesRunTime.boxToInteger((int)((UTF8String)set).findInSet((UTF8String)word));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(word, set) -> new StringBuilder(16).append(ev.value()).append(" = ").append((String)set).append(".findInSet(").append((String)word).append(");").toString());
    }

    @Override
    public DataType dataType() {
        return IntegerType$.MODULE$;
    }

    @Override
    public String prettyName() {
        return "find_in_set";
    }

    public FindInSet copy(Expression left, Expression right) {
        return new FindInSet(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "FindInSet";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.left();
                break;
            }
            case 1: {
                expression = this.right();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof FindInSet;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof FindInSet)) return false;
        boolean bl = true;
        if (!bl) return false;
        FindInSet findInSet = (FindInSet)x$1;
        Expression expression = this.left();
        Expression expression2 = findInSet.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = findInSet.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!findInSet.canEqual(this)) return false;
        return true;
    }

    public FindInSet(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        ExpectsInputTypes.$init$(this);
    }
}

