/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Flatten$;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprValue$;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.unsafe.array.ByteArrayMethods;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(arrayOfArrays) - Transforms an array of arrays into a single array.", examples="\n    Examples:\n      > SELECT _FUNC_(array(array(1, 2), array(3, 4)));\n       [1,2,3,4]\n  ", since="2.4.0")
@ScalaSignature(bytes="\u0006\u0001\u0005Ug\u0001B\u0001\u0003\u0001>\u0011qA\u00127biR,gN\u0003\u0002\u0004\t\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t)a!\u0001\u0005dCR\fG._:u\u0015\t9\u0001\"A\u0002tc2T!!\u0003\u0006\u0002\u000bM\u0004\u0018M]6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\u0002\u0001'\u0011\u0001\u0001\u0003\u0006\u000e\u0011\u0005E\u0011R\"\u0001\u0002\n\u0005M\u0011!aD+oCJLX\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005UAR\"\u0001\f\u000b\u0003]\tQa]2bY\u0006L!!\u0007\f\u0003\u000fA\u0013x\u000eZ;diB\u0011QcG\u0005\u00039Y\u0011AbU3sS\u0006d\u0017N_1cY\u0016D\u0001B\b\u0001\u0003\u0016\u0004%\taH\u0001\u0006G\"LG\u000eZ\u000b\u0002AA\u0011\u0011#I\u0005\u0003E\t\u0011!\"\u0012=qe\u0016\u001c8/[8o\u0011!!\u0003A!E!\u0002\u0013\u0001\u0013AB2iS2$\u0007\u0005C\u0003'\u0001\u0011\u0005q%\u0001\u0004=S:LGO\u0010\u000b\u0003Q%\u0002\"!\u0005\u0001\t\u000by)\u0003\u0019\u0001\u0011\t\u000b-\u0002A\u0011\u0002\u0017\u0002\u001b\rD\u0017\u000e\u001c3ECR\fG+\u001f9f+\u0005i\u0003C\u0001\u00182\u001b\u0005y#B\u0001\u0019\u0007\u0003\u0015!\u0018\u0010]3t\u0013\t\u0011tFA\u0005BeJ\f\u0017\u0010V=qK\")A\u0007\u0001C!k\u0005Aa.\u001e7mC\ndW-F\u00017!\t)r'\u0003\u00029-\t9!i\\8mK\u0006t\u0007\u0002\u0003\u001e\u0001\u0011\u000b\u0007I\u0011I\u001e\u0002\u0011\u0011\fG/\u0019+za\u0016,\u0012\u0001\u0010\t\u0003]uJ!AP\u0018\u0003\u0011\u0011\u000bG/\u0019+za\u0016D#!\u000f!\u0011\u0005U\t\u0015B\u0001\"\u0017\u0005%!(/\u00198tS\u0016tG\u000f\u0003\u0005E\u0001!\u0015\r\u0011\"\u0003<\u0003-)G.Z7f]R$\u0016\u0010]3)\u0005\r\u0003\u0005\"B$\u0001\t\u0003B\u0015aE2iK\u000e\\\u0017J\u001c9vi\u0012\u000bG/\u0019+za\u0016\u001cH#A%\u0011\u0005)kU\"A&\u000b\u00051#\u0011\u0001C1oC2L8/[:\n\u00059[%a\u0004+za\u0016\u001c\u0005.Z2l%\u0016\u001cX\u000f\u001c;\t\u000bA\u0003A\u0011I)\u0002\u00199,H\u000e\\*bM\u0016,e/\u00197\u0015\u0005I+\u0006CA\u000bT\u0013\t!fCA\u0002B]fDQAH(A\u0002ICQa\u0016\u0001\u0005Ba\u000b\u0011\u0002Z8HK:\u001cu\u000eZ3\u0015\u0007e{F\r\u0005\u0002[;6\t1L\u0003\u0002]\u0005\u000591m\u001c3fO\u0016t\u0017B\u00010\\\u0005!)\u0005\u0010\u001d:D_\u0012,\u0007\"\u00021W\u0001\u0004\t\u0017aA2uqB\u0011!LY\u0005\u0003Gn\u0013abQ8eK\u001e,gnQ8oi\u0016DH\u000fC\u0003f-\u0002\u0007\u0011,\u0001\u0002fm\")q\r\u0001C\u0005Q\u0006Qr-\u001a8D_\u0012,gi\u001c:Ok6\u0014WM](g\u000b2,W.\u001a8ugR\u0019\u0011n\u001e=\u0011\tUQG\u000e\\\u0005\u0003WZ\u0011a\u0001V;qY\u0016\u0014\u0004CA7u\u001d\tq'\u000f\u0005\u0002p-5\t\u0001O\u0003\u0002r\u001d\u00051AH]8pizJ!a\u001d\f\u0002\rA\u0013X\rZ3g\u0013\t)hO\u0001\u0004TiJLgn\u001a\u0006\u0003gZAQ\u0001\u00194A\u0002\u0005DQ!\u001f4A\u00021\f\u0011c\u00195jY\u00124\u0016M]5bE2,g*Y7f\u0011\u0015Y\b\u0001\"\u0003}\u0003E9WM\\\"pI\u00164uN\u001d$mCR$XM\u001c\u000b\u0005Yvtx\u0010C\u0003au\u0002\u0007\u0011\rC\u0003zu\u0002\u0007A\u000e\u0003\u0004\u0002\u0002i\u0004\r\u0001\\\u0001\u000eCJ\u0014\u0018-\u001f#bi\u0006t\u0015-\\3\t\u000f\u0005\u0015\u0001\u0001\"\u0011\u0002\b\u0005Q\u0001O]3uift\u0015-\\3\u0016\u00031D\u0011\"a\u0003\u0001\u0003\u0003%\t!!\u0004\u0002\t\r|\u0007/\u001f\u000b\u0004Q\u0005=\u0001\u0002\u0003\u0010\u0002\nA\u0005\t\u0019\u0001\u0011\t\u0013\u0005M\u0001!%A\u0005\u0002\u0005U\u0011AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003/Q3\u0001IA\rW\t\tY\u0002\u0005\u0003\u0002\u001e\u0005\u001dRBAA\u0010\u0015\u0011\t\t#a\t\u0002\u0013Ut7\r[3dW\u0016$'bAA\u0013-\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005%\u0012q\u0004\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007\"CA\u0017\u0001\u0005\u0005I\u0011IA\u0018\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011\u0011\u0007\t\u0005\u0003g\ti$\u0004\u0002\u00026)!\u0011qGA\u001d\u0003\u0011a\u0017M\\4\u000b\u0005\u0005m\u0012\u0001\u00026bm\u0006L1!^A\u001b\u0011%\t\t\u0005AA\u0001\n\u0003\t\u0019%\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002FA\u0019Q#a\u0012\n\u0007\u0005%cCA\u0002J]RD\u0011\"!\u0014\u0001\u0003\u0003%\t!a\u0014\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR\u0019!+!\u0015\t\u0015\u0005M\u00131JA\u0001\u0002\u0004\t)%A\u0002yIEB\u0011\"a\u0016\u0001\u0003\u0003%\t%!\u0017\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!a\u0017\u0011\u000b\u0005u\u00131\r*\u000e\u0005\u0005}#bAA1-\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005\u0015\u0014q\f\u0002\t\u0013R,'/\u0019;pe\"I\u0011\u0011\u000e\u0001\u0002\u0002\u0013\u0005\u00111N\u0001\tG\u0006tW)];bYR\u0019a'!\u001c\t\u0013\u0005M\u0013qMA\u0001\u0002\u0004\u0011\u0006\"CA9\u0001\u0005\u0005I\u0011IA:\u0003\u0019)\u0017/^1mgR\u0019a'!\u001e\t\u0013\u0005M\u0013qNA\u0001\u0002\u0004\u0011\u0006f\u0004\u0001\u0002z\u0005}\u0014\u0011QAC\u0003\u000f\u000bY)!$\u0011\u0007E\tY(C\u0002\u0002~\t\u0011Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002\u0004\u0006QuLR+O\u0007~C\u0013M\u001d:bs>3\u0017I\u001d:bsNL\u0003%\f\u0011Ue\u0006t7OZ8s[N\u0004\u0013M\u001c\u0011beJ\f\u0017\u0010I8gA\u0005\u0014(/Y=tA%tGo\u001c\u0011bAMLgn\u001a7fA\u0005\u0014(/Y=/\u0003!)\u00070Y7qY\u0016\u001c\u0018EAAE\u0003iS\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006&\u0019:sCfD\u0013M\u001d:bs\"\nD\u0006\t\u001a*Y\u0001\n'O]1zQMb\u0003\u0005N\u0015*SmR\u0001\u0005\t\u0011!A\u0001\u00023,\r\u00173YMbC'\u0018\u0006!A\u0005)1/\u001b8dK\u0006\u0012\u0011qR\u0001\u0006e9\"d\u0006M\u0004\n\u0003'\u0013\u0011\u0011!E\u0001\u0003+\u000bqA\u00127biR,g\u000eE\u0002\u0012\u0003/3\u0001\"\u0001\u0002\u0002\u0002#\u0005\u0011\u0011T\n\u0006\u0003/\u000bYJ\u0007\t\u0007\u0003;\u000b\u0019\u000b\t\u0015\u000e\u0005\u0005}%bAAQ-\u00059!/\u001e8uS6,\u0017\u0002BAS\u0003?\u0013\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c82\u0011\u001d1\u0013q\u0013C\u0001\u0003S#\"!!&\t\u0015\u00055\u0016qSA\u0001\n\u000b\ny+\u0001\u0005u_N#(/\u001b8h)\t\t\t\u0004\u0003\u0006\u00024\u0006]\u0015\u0011!CA\u0003k\u000bQ!\u00199qYf$2\u0001KA\\\u0011\u0019q\u0012\u0011\u0017a\u0001A!Q\u00111XAL\u0003\u0003%\t)!0\u0002\u000fUt\u0017\r\u001d9msR!\u0011qXAc!\u0011)\u0012\u0011\u0019\u0011\n\u0007\u0005\rgC\u0001\u0004PaRLwN\u001c\u0005\n\u0003\u000f\fI,!AA\u0002!\n1\u0001\u001f\u00131\u0011)\tY-a&\u0002\u0002\u0013%\u0011QZ\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002PB!\u00111GAi\u0013\u0011\t\u0019.!\u000e\u0003\r=\u0013'.Z2u\u0001")
public class Flatten
extends UnaryExpression
implements scala.Serializable {
    private transient DataType dataType;
    private transient DataType elementType;
    private final Expression child;
    private volatile transient byte bitmap$trans$0;

    public static Option<Expression> unapply(Flatten flatten) {
        return Flatten$.MODULE$.unapply(flatten);
    }

    public static <A> Function1<Expression, A> andThen(Function1<Flatten, A> function1) {
        return Flatten$.MODULE$.andThen(function1);
    }

    public static <A> Function1<A, Flatten> compose(Function1<A, Expression> function1) {
        return Flatten$.MODULE$.compose(function1);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    private ArrayType childDataType() {
        return (ArrayType)this.child().dataType();
    }

    @Override
    public boolean nullable() {
        return this.child().nullable() || this.childDataType().containsNull();
    }

    private DataType dataType$lzycompute() {
        Flatten flatten = this;
        synchronized (flatten) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.dataType = this.childDataType().elementType();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.dataType;
    }

    @Override
    public DataType dataType() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.dataType$lzycompute() : this.dataType;
    }

    private DataType elementType$lzycompute() {
        Flatten flatten = this;
        synchronized (flatten) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.elementType = ((ArrayType)this.dataType()).elementType();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.elementType;
    }

    private DataType elementType() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.elementType$lzycompute() : this.elementType;
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        ArrayType arrayType;
        DataType dataType = this.child().dataType();
        TypeCheckResult typeCheckResult = dataType instanceof ArrayType && (arrayType = (ArrayType)dataType).elementType() instanceof ArrayType ? TypeCheckResult$TypeCheckSuccess$.MODULE$ : new TypeCheckResult.TypeCheckFailure(new StringBuilder(43).append("The argument should be an array of arrays, ").append(new StringBuilder(19).append("but '").append(this.child().sql()).append("' is of ").append(this.child().dataType().catalogString()).append(" type.").toString()).toString());
        return typeCheckResult;
    }

    @Override
    public Object nullSafeEval(Object child) {
        GenericArrayData genericArrayData;
        Object[] elements = ((ArrayData)child).toObjectArray(this.dataType());
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(elements)).contains(null)) {
            genericArrayData = null;
        } else {
            ArrayData[] arrayData = (ArrayData[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(elements)).map((Function1 & Serializable & scala.Serializable)x$59 -> (ArrayData)x$59, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ArrayData.class)));
            long numberOfElements = BoxesRunTime.unboxToLong((Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])arrayData)).foldLeft((Object)BoxesRunTime.boxToLong((long)0L), (Function2 & Serializable & scala.Serializable)(sum, e) -> BoxesRunTime.boxToLong((long)Flatten.$anonfun$nullSafeEval$6(BoxesRunTime.unboxToLong((Object)sum), e))));
            if (numberOfElements > (long)ByteArrayMethods.MAX_ROUNDED_ARRAY_LENGTH) {
                throw new RuntimeException(new StringBuilder(53).append("Unsuccessful try to flatten an array of arrays with ").append(new StringBuilder(48).append(numberOfElements).append(" elements due to exceeding the array size limit ").toString()).append(ByteArrayMethods.MAX_ROUNDED_ARRAY_LENGTH).append(".").toString());
            }
            Object[] flattenedData = (Object[])ClassTag$.MODULE$.Nothing().newArray((int)numberOfElements);
            IntRef position = IntRef.create((int)0);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])arrayData)).foreach((Function1 & Serializable & scala.Serializable)ad -> {
                Flatten.$anonfun$nullSafeEval$7(this, flattenedData, position, ad);
                return BoxedUnit.UNIT;
            });
            genericArrayData = new GenericArrayData((Object)flattenedData);
        }
        return genericArrayData;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable & scala.Serializable)c -> {
            String code = this.genCodeForFlatten(ctx, (String)c, ExprValue$.MODULE$.exprValueToString(ev.value()));
            return ctx.nullArrayElementsSaveExec(this.childDataType().containsNull(), ExprValue$.MODULE$.exprValueToString(ev.isNull()), (String)c, code);
        });
    }

    private Tuple2<String, String> genCodeForNumberOfElements(CodegenContext ctx, String childVariableName) {
        String variableName = ctx.freshName("numElements");
        String code = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(125).append("\n      |long ").append(variableName).append(" = 0;\n      |for (int z = 0; z < ").append(childVariableName).append(".numElements(); z++) {\n      |  ").append(variableName).append(" += ").append(childVariableName).append(".getArray(z).numElements();\n      |}\n      ").toString())).stripMargin();
        return new Tuple2((Object)code, (Object)variableName);
    }

    private String genCodeForFlatten(CodegenContext ctx, String childVariableName, String arrayDataName) {
        String counter = ctx.freshName("counter");
        String tempArrayDataName = ctx.freshName("tempArrayData");
        String k = ctx.freshName("k");
        String l = ctx.freshName("l");
        String arr = ctx.freshName("arr");
        Tuple2<String, String> tuple2 = this.genCodeForNumberOfElements(ctx, childVariableName);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String numElemCode = (String)tuple2._1();
        String numElemName = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)numElemCode, (Object)numElemName);
        Tuple2 tuple23 = tuple22;
        String numElemCode2 = (String)tuple23._1();
        String numElemName2 = (String)tuple23._2();
        String allocation = CodeGenerator$.MODULE$.createArrayData(tempArrayDataName, this.elementType(), numElemName2, new StringBuilder(9).append(" ").append(this.prettyName()).append(" failed.").toString());
        String assignment = CodeGenerator$.MODULE$.createArrayAssignment(tempArrayDataName, this.elementType(), arr, counter, l, ((ArrayType)this.dataType()).containsNull());
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(203).append("\n    |").append(numElemCode2).append("\n    |").append(allocation).append("\n    |int ").append(counter).append(" = 0;\n    |for (int ").append(k).append(" = 0; ").append(k).append(" < ").append(childVariableName).append(".numElements(); ").append(k).append("++) {\n    |  ArrayData ").append(arr).append(" = ").append(childVariableName).append(".getArray(").append(k).append(");\n    |  for (int ").append(l).append(" = 0; ").append(l).append(" < ").append(arr).append(".numElements(); ").append(l).append("++) {\n    |   ").append(assignment).append("\n    |   ").append(counter).append("++;\n    | }\n    |}\n    |").append(arrayDataName).append(" = ").append(tempArrayDataName).append(";\n    ").toString())).stripMargin();
    }

    @Override
    public String prettyName() {
        return "flatten";
    }

    public Flatten copy(Expression child) {
        return new Flatten(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "Flatten";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return this.child();
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Flatten;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Flatten)) return false;
        boolean bl = true;
        if (!bl) return false;
        Flatten flatten = (Flatten)x$1;
        Expression expression = this.child();
        Expression expression2 = flatten.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!flatten.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ long $anonfun$nullSafeEval$6(long sum, ArrayData e) {
        return sum + (long)e.numElements();
    }

    public static final /* synthetic */ void $anonfun$nullSafeEval$7(Flatten $this, Object[] flattenedData$1, IntRef position$3, ArrayData ad) {
        Object[] arr = ad.toObjectArray($this.elementType());
        Array$.MODULE$.copy((Object)arr, 0, (Object)flattenedData$1, position$3.elem, arr.length);
        position$3.elem += arr.length;
    }

    public Flatten(Expression child) {
        this.child = child;
    }
}

