/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.util.TimeZone;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Hour$;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(timestamp) - Returns the hour component of the string/timestamp.", examples="\n    Examples:\n      > SELECT _FUNC_('2009-07-30 12:58:59');\n       12\n  ", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0001\u0005}g\u0001B\u0001\u0003\u0001>\u0011A\u0001S8ve*\u00111\u0001B\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002\u0006\r\u0005A1-\u0019;bYf\u001cHO\u0003\u0002\b\u0011\u0005\u00191/\u001d7\u000b\u0005%Q\u0011!B:qCJ\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c\u0001a\u0005\u0004\u0001!Q9\"\u0004\t\t\u0003#Ii\u0011AA\u0005\u0003'\t\u0011q\"\u00168bef,\u0005\u0010\u001d:fgNLwN\u001c\t\u0003#UI!A\u0006\u0002\u0003/QKW.\u001a.p]\u0016\fu/\u0019:f\u000bb\u0004(/Z:tS>t\u0007CA\t\u0019\u0013\tI\"A\u0001\fJ[Bd\u0017nY5u\u0007\u0006\u001cH/\u00138qkR$\u0016\u0010]3t!\tYb$D\u0001\u001d\u0015\u0005i\u0012!B:dC2\f\u0017BA\u0010\u001d\u0005\u001d\u0001&o\u001c3vGR\u0004\"aG\u0011\n\u0005\tb\"\u0001D*fe&\fG.\u001b>bE2,\u0007\u0002\u0003\u0013\u0001\u0005+\u0007I\u0011A\u0013\u0002\u000b\rD\u0017\u000e\u001c3\u0016\u0003\u0019\u0002\"!E\u0014\n\u0005!\u0012!AC#yaJ,7o]5p]\"A!\u0006\u0001B\tB\u0003%a%\u0001\u0004dQ&dG\r\t\u0005\tY\u0001\u0011)\u001a!C\u0001[\u0005QA/[7f5>tW-\u00133\u0016\u00039\u00022aG\u00182\u0013\t\u0001DD\u0001\u0004PaRLwN\u001c\t\u0003eer!aM\u001c\u0011\u0005QbR\"A\u001b\u000b\u0005Yr\u0011A\u0002\u001fs_>$h(\u0003\u000299\u00051\u0001K]3eK\u001aL!AO\u001e\u0003\rM#(/\u001b8h\u0015\tAD\u0004\u0003\u0005>\u0001\tE\t\u0015!\u0003/\u0003-!\u0018.\\3[_:,\u0017\n\u001a\u0011\t\u000b}\u0002A\u0011\u0001!\u0002\rqJg.\u001b;?)\r\t%i\u0011\t\u0003#\u0001AQ\u0001\n A\u0002\u0019Bq\u0001\f \u0011\u0002\u0003\u0007a\u0006C\u0003@\u0001\u0011\u0005Q\t\u0006\u0002B\r\")A\u0005\u0012a\u0001M!)\u0001\n\u0001C!\u0013\u0006Q\u0011N\u001c9viRK\b/Z:\u0016\u0003)\u00032a\u0013)T\u001d\taeJ\u0004\u00025\u001b&\tQ$\u0003\u0002P9\u00059\u0001/Y2lC\u001e,\u0017BA)S\u0005\r\u0019V-\u001d\u0006\u0003\u001fr\u0001\"\u0001V,\u000e\u0003US!A\u0016\u0004\u0002\u000bQL\b/Z:\n\u0005a+&\u0001E!cgR\u0014\u0018m\u0019;ECR\fG+\u001f9f\u0011\u0015Q\u0006\u0001\"\u0011\\\u0003!!\u0017\r^1UsB,W#\u0001/\u0011\u0005Qk\u0016B\u00010V\u0005!!\u0015\r^1UsB,\u0007\"\u00021\u0001\t\u0003\n\u0017\u0001D<ji\"$\u0016.\\3[_:,GC\u0001\u000bc\u0011\u0015as\f1\u00012\u0011\u0015!\u0007\u0001\"\u0015f\u00031qW\u000f\u001c7TC\u001a,WI^1m)\t1\u0017\u000e\u0005\u0002\u001cO&\u0011\u0001\u000e\b\u0002\u0004\u0003:L\b\"\u00026d\u0001\u00041\u0017!\u0003;j[\u0016\u001cH/Y7q\u0011\u0015a\u0007\u0001\"\u0011n\u0003%!wnR3o\u0007>$W\rF\u0002oif\u0004\"a\u001c:\u000e\u0003AT!!\u001d\u0002\u0002\u000f\r|G-Z4f]&\u00111\u000f\u001d\u0002\t\u000bb\u0004(oQ8eK\")Qo\u001ba\u0001m\u0006\u00191\r\u001e=\u0011\u0005=<\u0018B\u0001=q\u00059\u0019u\u000eZ3hK:\u001cuN\u001c;fqRDQA_6A\u00029\f!!\u001a<\t\u000fq\u0004\u0011\u0011!C\u0001{\u0006!1m\u001c9z)\r\tep \u0005\bIm\u0004\n\u00111\u0001'\u0011\u001da3\u0010%AA\u00029B\u0011\"a\u0001\u0001#\u0003%\t!!\u0002\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011q\u0001\u0016\u0004M\u0005%1FAA\u0006!\u0011\ti!a\u0006\u000e\u0005\u0005=!\u0002BA\t\u0003'\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005UA$\u0001\u0006b]:|G/\u0019;j_:LA!!\u0007\u0002\u0010\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0013\u0005u\u0001!%A\u0005\u0002\u0005}\u0011AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0003CQ3ALA\u0005\u0011%\t)\u0003AA\u0001\n\u0003\n9#A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003S\u0001B!a\u000b\u000265\u0011\u0011Q\u0006\u0006\u0005\u0003_\t\t$\u0001\u0003mC:<'BAA\u001a\u0003\u0011Q\u0017M^1\n\u0007i\ni\u0003C\u0005\u0002:\u0001\t\t\u0011\"\u0001\u0002<\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011Q\b\t\u00047\u0005}\u0012bAA!9\t\u0019\u0011J\u001c;\t\u0013\u0005\u0015\u0003!!A\u0005\u0002\u0005\u001d\u0013A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0004M\u0006%\u0003BCA&\u0003\u0007\n\t\u00111\u0001\u0002>\u0005\u0019\u0001\u0010J\u0019\t\u0013\u0005=\u0003!!A\u0005B\u0005E\u0013a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005M\u0003#BA+\u000372WBAA,\u0015\r\tI\u0006H\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA/\u0003/\u0012\u0001\"\u0013;fe\u0006$xN\u001d\u0005\n\u0003C\u0002\u0011\u0011!C\u0001\u0003G\n\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003K\nY\u0007E\u0002\u001c\u0003OJ1!!\u001b\u001d\u0005\u001d\u0011un\u001c7fC:D\u0011\"a\u0013\u0002`\u0005\u0005\t\u0019\u00014\t\u0013\u0005=\u0004!!A\u0005B\u0005E\u0014AB3rk\u0006d7\u000f\u0006\u0003\u0002f\u0005M\u0004\"CA&\u0003[\n\t\u00111\u0001gQ=\u0001\u0011qOA?\u0003\u007f\n\u0019)!\"\u0002\n\u0006-\u0005cA\t\u0002z%\u0019\u00111\u0010\u0002\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u0011\u0011Q\u0001H?\u001a+fjQ0)i&lWm\u001d;b[BL\u0003%\f\u0011SKR,(O\\:!i\",\u0007\u0005[8ve\u0002\u001aw.\u001c9p]\u0016tG\u000fI8gAQDW\rI:ue&twm\f;j[\u0016\u001cH/Y7q]\u0005AQ\r_1na2,7/\t\u0002\u0002\b\u0006I%\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u00143aAJT\u0006M\u001c.gA\u0002\u0013G\r\u001e6qi*\u0014hJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AE\u0012$\u0002\t\u0011\u0002\u000bMLgnY3\"\u0005\u00055\u0015!B\u0019/k9\u0002t!CAI\u0005\u0005\u0005\t\u0012AAJ\u0003\u0011Au.\u001e:\u0011\u0007E\t)J\u0002\u0005\u0002\u0005\u0005\u0005\t\u0012AAL'\u0015\t)*!'!!\u001d\tY*!)']\u0005k!!!(\u000b\u0007\u0005}E$A\u0004sk:$\u0018.\\3\n\t\u0005\r\u0016Q\u0014\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u0014\u0004bB \u0002\u0016\u0012\u0005\u0011q\u0015\u000b\u0003\u0003'C!\"a+\u0002\u0016\u0006\u0005IQIAW\u0003!!xn\u0015;sS:<GCAA\u0015\u0011)\t\t,!&\u0002\u0002\u0013\u0005\u00151W\u0001\u0006CB\u0004H.\u001f\u000b\u0006\u0003\u0006U\u0016q\u0017\u0005\u0007I\u0005=\u0006\u0019\u0001\u0014\t\u00111\ny\u000b%AA\u00029B!\"a/\u0002\u0016\u0006\u0005I\u0011QA_\u0003\u001d)h.\u00199qYf$B!a0\u0002HB!1dLAa!\u0015Y\u00121\u0019\u0014/\u0013\r\t)\r\b\u0002\u0007)V\u0004H.\u001a\u001a\t\u0013\u0005%\u0017\u0011XA\u0001\u0002\u0004\t\u0015a\u0001=%a!Q\u0011QZAK#\u0003%\t!a\b\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00133\u0011)\t\t.!&\u0012\u0002\u0013\u0005\u0011qD\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%e!Q\u0011Q[AK\u0003\u0003%I!a6\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u00033\u0004B!a\u000b\u0002\\&!\u0011Q\\A\u0017\u0005\u0019y%M[3di\u0002")
public class Hour
extends UnaryExpression
implements TimeZoneAwareExpression,
ImplicitCastInputTypes,
scala.Serializable {
    private final Expression child;
    private final Option<String> timeZoneId;
    private boolean resolved;
    private transient TimeZone timeZone;
    private volatile boolean bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public static Option<String> apply$default$2() {
        return Hour$.MODULE$.apply$default$2();
    }

    public static Option<String> $lessinit$greater$default$2() {
        return Hour$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<Expression, Option<String>>> unapply(Hour hour) {
        return Hour$.MODULE$.unapply(hour);
    }

    public static Function1<Tuple2<Expression, Option<String>>, Hour> tupled() {
        return Hour$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Option<String>, Hour>> curried() {
        return Hour$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    private boolean resolved$lzycompute() {
        Hour hour = this;
        synchronized (hour) {
            if (!this.bitmap$0) {
                this.resolved = TimeZoneAwareExpression.resolved$(this);
                this.bitmap$0 = true;
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        return !this.bitmap$0 ? this.resolved$lzycompute() : this.resolved;
    }

    private TimeZone timeZone$lzycompute() {
        Hour hour = this;
        synchronized (hour) {
            if (!this.bitmap$trans$0) {
                this.timeZone = TimeZoneAwareExpression.timeZone$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.timeZone;
    }

    @Override
    public TimeZone timeZone() {
        return !this.bitmap$trans$0 ? this.timeZone$lzycompute() : this.timeZone;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TimestampType$[]{TimestampType$.MODULE$}));
    }

    @Override
    public DataType dataType() {
        return IntegerType$.MODULE$;
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Option x$5 = Option$.MODULE$.apply((Object)timeZoneId);
        Expression x$6 = this.copy$default$1();
        return this.copy(x$6, (Option<String>)x$5);
    }

    @Override
    public Object nullSafeEval(Object timestamp) {
        return BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getHours(BoxesRunTime.unboxToLong((Object)timestamp), this.timeZone()));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String tz = ctx.addReferenceObj("timeZone", this.timeZone(), ctx.addReferenceObj$default$3());
        String dtu = new StringOps(Predef$.MODULE$.augmentString(DateTimeUtils$.MODULE$.getClass().getName())).stripSuffix("$");
        return this.defineCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable & scala.Serializable)c -> new StringBuilder(13).append(dtu).append(".getHours(").append((String)c).append(", ").append(tz).append(")").toString());
    }

    public Hour copy(Expression child, Option<String> timeZoneId) {
        return new Hour(child, timeZoneId);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public Option<String> copy$default$2() {
        return this.timeZoneId();
    }

    @Override
    public String productPrefix() {
        return "Hour";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Option<String> option;
        int n = x$1;
        switch (n) {
            case 0: {
                option = this.child();
                break;
            }
            case 1: {
                option = this.timeZoneId();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return option;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Hour;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Hour)) return false;
        boolean bl = true;
        if (!bl) return false;
        Hour hour = (Hour)x$1;
        Expression expression = this.child();
        Expression expression2 = hour.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<String> option = this.timeZoneId();
        Option<String> option2 = hour.timeZoneId();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!hour.canEqual(this)) return false;
        return true;
    }

    public Hour(Expression child, Option<String> timeZoneId) {
        this.child = child;
        this.timeZoneId = timeZoneId;
        TimeZoneAwareExpression.$init$(this);
        ExpectsInputTypes.$init$(this);
    }

    public Hour(Expression child) {
        this(child, (Option<String>)None$.MODULE$);
    }
}

