/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Generator;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.catalyst.expressions.JsonTuple$;
import org.apache.spark.sql.catalyst.expressions.SharedFactory$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.json.CreateJacksonParser$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.unsafe.types.UTF8String;
import org.apache.spark.util.Utils$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.IndexedSeq$;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(jsonStr, p1, p2, ..., pn) - Returns a tuple like the function get_json_object, but it takes multiple names. All the input parameters and output column types are string.", examples="\n    Examples:\n      > SELECT _FUNC_('{\"a\":1, \"b\":2}', 'a', 'b');\n       1  2\n  ")
@ScalaSignature(bytes="\u0006\u0001\tMa\u0001B\u0001\u0003\u0001>\u0011\u0011BS:p]R+\b\u000f\\3\u000b\u0005\r!\u0011aC3yaJ,7o]5p]NT!!\u0002\u0004\u0002\u0011\r\fG/\u00197zgRT!a\u0002\u0005\u0002\u0007M\fHN\u0003\u0002\n\u0015\u0005)1\u000f]1sW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u0019b\u0001\u0001\t\u0015/u\u0019\u0003CA\t\u0013\u001b\u0005\u0011\u0011BA\n\u0003\u0005))\u0005\u0010\u001d:fgNLwN\u001c\t\u0003#UI!A\u0006\u0002\u0003\u0013\u001d+g.\u001a:bi>\u0014\bC\u0001\r\u001c\u001b\u0005I\"B\u0001\u000e\u0003\u0003\u001d\u0019w\u000eZ3hK:L!\u0001H\r\u0003\u001f\r{G-Z4f]\u001a\u000bG\u000e\u001c2bG.\u0004\"AH\u0011\u000e\u0003}Q\u0011\u0001I\u0001\u0006g\u000e\fG.Y\u0005\u0003E}\u0011q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002\u001fI%\u0011Qe\b\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\tO\u0001\u0011)\u001a!C\u0001Q\u0005A1\r[5mIJ,g.F\u0001*!\rQ#\u0007\u0005\b\u0003WAr!\u0001L\u0018\u000e\u00035R!A\f\b\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0001\u0013BA\u0019 \u0003\u001d\u0001\u0018mY6bO\u0016L!a\r\u001b\u0003\u0007M+\u0017O\u0003\u00022?!Aa\u0007\u0001B\tB\u0003%\u0011&A\u0005dQ&dGM]3oA!)\u0001\b\u0001C\u0001s\u00051A(\u001b8jiz\"\"AO\u001e\u0011\u0005E\u0001\u0001\"B\u00148\u0001\u0004I\u0003\"B\u001f\u0001\t\u0003r\u0014\u0001\u00038vY2\f'\r\\3\u0016\u0003}\u0002\"A\b!\n\u0005\u0005{\"a\u0002\"p_2,\u0017M\u001c\u0005\t\u0007\u0002A)\u0019!C\u0005\t\u00069a.\u001e7m%><X#A#\u0011\u0007)\u0012d\t\u0005\u0002H\u00116\tA!\u0003\u0002J\t\tY\u0011J\u001c;fe:\fGNU8xQ\t\u00115\n\u0005\u0002\u001f\u0019&\u0011Qj\b\u0002\niJ\fgn]5f]RD\u0001b\u0014\u0001\t\u0006\u0004%I\u0001U\u0001\tUN|g.\u0012=qeV\t\u0001\u0003\u000b\u0002O\u0017\"A1\u000b\u0001EC\u0002\u0013%\u0001&\u0001\tgS\u0016dG-\u0012=qe\u0016\u001c8/[8og\"\u0012!k\u0013\u0005\t-\u0002A)\u0019!C\u0005/\u0006\u0011bm\u001c7eC\ndWMR5fY\u0012t\u0015-\\3t+\u0005A\u0006c\u0001\u0016Z7&\u0011!\f\u000e\u0002\u000b\u0013:$W\r_3e'\u0016\f\bc\u0001\u0010]=&\u0011Ql\b\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005}\u001bgB\u00011b!\tas$\u0003\u0002c?\u00051\u0001K]3eK\u001aL!\u0001Z3\u0003\rM#(/\u001b8h\u0015\t\u0011w\u0004\u000b\u0002V\u0017\"A\u0001\u000e\u0001EC\u0002\u0013%\u0011.\u0001\bd_:\u001cH/\u00198u\r&,G\u000eZ:\u0016\u0003)\u0004\"AH6\n\u00051|\"aA%oi\"\u0012qm\u0013\u0005\u0006_\u0002!\t\u0005]\u0001\u000eK2,W.\u001a8u'\u000eDW-\\1\u0016\u0003E\u0004\"A];\u000e\u0003MT!\u0001\u001e\u0004\u0002\u000bQL\b/Z:\n\u0005Y\u001c(AC*ueV\u001cG\u000fV=qK\")\u0001\u0010\u0001C!s\u0006Q\u0001O]3uift\u0015-\\3\u0016\u0003yCQa\u001f\u0001\u0005Bq\f1c\u00195fG.Le\u000e];u\t\u0006$\u0018\rV=qKN$\u0012! \t\u0004}\u0006\rQ\"A@\u000b\u0007\u0005\u0005A!\u0001\u0005b]\u0006d\u0017p]5t\u0013\r\t)a \u0002\u0010)f\u0004Xm\u00115fG.\u0014Vm];mi\"9\u0011\u0011\u0002\u0001\u0005B\u0005-\u0011\u0001B3wC2$B!!\u0004\u0002\u0014A!!&a\u0004G\u0013\r\t\t\u0002\u000e\u0002\u0010)J\fg/\u001a:tC\ndWm\u00148dK\"I\u0011QCA\u0004!\u0003\u0005\rAR\u0001\u0006S:\u0004X\u000f\u001e\u0005\b\u00033\u0001A\u0011BA\u000e\u0003!\u0001\u0018M]:f%><H#B#\u0002\u001e\u0005e\u0002\u0002CA\u0010\u0003/\u0001\r!!\t\u0002\rA\f'o]3s!\u0011\t\u0019#!\u000e\u000e\u0005\u0005\u0015\"\u0002BA\u0014\u0003S\tAaY8sK*!\u00111FA\u0017\u0003\u001dQ\u0017mY6t_:TA!a\f\u00022\u0005Ia-Y:uKJDX\u000e\u001c\u0006\u0003\u0003g\t1aY8n\u0013\u0011\t9$!\n\u0003\u0015)\u001bxN\u001c)beN,'\u000fC\u0004\u0002\u0016\u0005]\u0001\u0019\u0001$\t\u000f\u0005u\u0002\u0001\"\u0003\u0002@\u0005!2m\u001c9z\u0007V\u0014(/\u001a8u'R\u0014Xo\u0019;ve\u0016$b!!\u0011\u0002H\u0005E\u0003c\u0001\u0010\u0002D%\u0019\u0011QI\u0010\u0003\tUs\u0017\u000e\u001e\u0005\t\u0003\u0013\nY\u00041\u0001\u0002L\u0005Iq-\u001a8fe\u0006$xN\u001d\t\u0005\u0003G\ti%\u0003\u0003\u0002P\u0005\u0015\"!\u0004&t_:<UM\\3sCR|'\u000f\u0003\u0005\u0002 \u0005m\u0002\u0019AA\u0011\u0011%\t)\u0006AA\u0001\n\u0003\t9&\u0001\u0003d_BLHc\u0001\u001e\u0002Z!Aq%a\u0015\u0011\u0002\u0003\u0007\u0011\u0006C\u0005\u0002^\u0001\t\n\u0011\"\u0001\u0002`\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA1U\rI\u00131M\u0016\u0003\u0003K\u0002B!a\u001a\u0002r5\u0011\u0011\u0011\u000e\u0006\u0005\u0003W\ni'A\u0005v]\u000eDWmY6fI*\u0019\u0011qN\u0010\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002t\u0005%$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"I\u0011q\u000f\u0001\u0002\u0002\u0013\u0005\u0013\u0011P\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005m\u0004\u0003BA?\u0003\u000fk!!a \u000b\t\u0005\u0005\u00151Q\u0001\u0005Y\u0006twM\u0003\u0002\u0002\u0006\u0006!!.\u0019<b\u0013\r!\u0017q\u0010\u0005\t\u0003\u0017\u0003\u0011\u0011!C\u0001S\u0006a\u0001O]8ek\u000e$\u0018I]5us\"I\u0011q\u0012\u0001\u0002\u0002\u0013\u0005\u0011\u0011S\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\t\u0019*!'\u0011\u0007y\t)*C\u0002\u0002\u0018~\u00111!\u00118z\u0011%\tY*!$\u0002\u0002\u0003\u0007!.A\u0002yIEB\u0011\"a(\u0001\u0003\u0003%\t%!)\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!a)\u0011\r\u0005\u0015\u00161VAJ\u001b\t\t9KC\u0002\u0002*~\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\ti+a*\u0003\u0011%#XM]1u_JD\u0011\"!-\u0001\u0003\u0003%\t!a-\u0002\u0011\r\fg.R9vC2$2aPA[\u0011)\tY*a,\u0002\u0002\u0003\u0007\u00111\u0013\u0005\n\u0003s\u0003\u0011\u0011!C!\u0003w\u000ba!Z9vC2\u001cHcA \u0002>\"Q\u00111TA\\\u0003\u0003\u0005\r!a%)\u0017\u0001\t\t-a2\u0002J\u00065\u0017q\u001a\t\u0004#\u0005\r\u0017bAAc\u0005\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAAf\u0003\u0005}sLR+O\u0007~C#n]8o'R\u0014H\u0006\t92Y\u0001\u0002(\u0007\f\u0011/]9b\u0003\u0005\u001d8*A5\u0002#+\u001a;ve:\u001c\b%\u0019\u0011ukBdW\r\t7jW\u0016\u0004C\u000f[3!MVt7\r^5p]\u0002:W\r^0kg>twl\u001c2kK\u000e$H\u0006\t2vi\u0002JG\u000f\t;bW\u0016\u001c\b%\\;mi&\u0004H.\u001a\u0011oC6,7O\f\u0011BY2\u0004C\u000f[3!S:\u0004X\u000f\u001e\u0011qCJ\fW.\u001a;feN\u0004\u0013M\u001c3!_V$\b/\u001e;!G>dW/\u001c8!if\u0004Xm\u001d\u0011be\u0016\u00043\u000f\u001e:j]\u001et\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005E\u0017\u0001\u0015\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)Om\u0014\u0013M\t\u001e2Y\u0001\u0012#M\t\u001e3{\u001eb\u0003eJ1(Y\u0001:#mJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AE\u0002\u0003E\r\u0006!A\u001dI\u0011Q\u001b\u0002\u0002\u0002#\u0005\u0011q[\u0001\n\u0015N|g\u000eV;qY\u0016\u00042!EAm\r!\t!!!A\t\u0002\u0005m7#BAm\u0003;\u001c\u0003CBAp\u0003KL#(\u0004\u0002\u0002b*\u0019\u00111]\u0010\u0002\u000fI,h\u000e^5nK&!\u0011q]Aq\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|g.\r\u0005\bq\u0005eG\u0011AAv)\t\t9\u000e\u0003\u0006\u0002p\u0006e\u0017\u0011!C#\u0003c\f\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003wB!\"!>\u0002Z\u0006\u0005I\u0011QA|\u0003\u0015\t\u0007\u000f\u001d7z)\rQ\u0014\u0011 \u0005\u0007O\u0005M\b\u0019A\u0015\t\u0015\u0005u\u0018\u0011\\A\u0001\n\u0003\u000by0A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\t\u0005!1\u0001\t\u0004=qK\u0003\"\u0003B\u0003\u0003w\f\t\u00111\u0001;\u0003\rAH\u0005\r\u0005\u000b\u0005\u0013\tI.!A\u0005\n\t-\u0011a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"A!\u0004\u0011\t\u0005u$qB\u0005\u0005\u0005#\tyH\u0001\u0004PE*,7\r\u001e")
public class JsonTuple
extends Expression
implements Generator,
CodegenFallback,
scala.Serializable {
    private transient Seq<InternalRow> nullRow;
    private transient Expression jsonExpr;
    private transient Seq<Expression> fieldExpressions;
    private transient IndexedSeq<Option<String>> foldableFieldNames;
    private transient int constantFields;
    private final Seq<Expression> children;
    private volatile transient byte bitmap$trans$0;

    public static Option<Seq<Expression>> unapply(JsonTuple jsonTuple) {
        return JsonTuple$.MODULE$.unapply(jsonTuple);
    }

    public static <A> Function1<Seq<Expression>, A> andThen(Function1<JsonTuple, A> function1) {
        return JsonTuple$.MODULE$.andThen(function1);
    }

    public static <A> Function1<A, JsonTuple> compose(Function1<A, Seq<Expression>> function1) {
        return JsonTuple$.MODULE$.compose(function1);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$(this, ctx, ev);
    }

    @Override
    public DataType dataType() {
        return Generator.dataType$(this);
    }

    @Override
    public boolean foldable() {
        return Generator.foldable$(this);
    }

    @Override
    public TraversableOnce<InternalRow> terminate() {
        return Generator.terminate$(this);
    }

    @Override
    public boolean supportCodegen() {
        return Generator.supportCodegen$(this);
    }

    @Override
    public Seq<Expression> children() {
        return this.children;
    }

    @Override
    public boolean nullable() {
        return false;
    }

    private Seq<InternalRow> nullRow$lzycompute() {
        JsonTuple jsonTuple = this;
        synchronized (jsonTuple) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                GenericInternalRow genericInternalRow = new GenericInternalRow((Object[])Array$.MODULE$.ofDim(this.fieldExpressions().length(), ClassTag$.MODULE$.Any()));
                this.nullRow = Nil$.MODULE$.$colon$colon((Object)genericInternalRow);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.nullRow;
    }

    private Seq<InternalRow> nullRow() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.nullRow$lzycompute() : this.nullRow;
    }

    private Expression jsonExpr$lzycompute() {
        JsonTuple jsonTuple = this;
        synchronized (jsonTuple) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.jsonExpr = (Expression)this.children().head();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.jsonExpr;
    }

    private Expression jsonExpr() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.jsonExpr$lzycompute() : this.jsonExpr;
    }

    private Seq<Expression> fieldExpressions$lzycompute() {
        JsonTuple jsonTuple = this;
        synchronized (jsonTuple) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.fieldExpressions = (Seq)this.children().tail();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.fieldExpressions;
    }

    private Seq<Expression> fieldExpressions() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.fieldExpressions$lzycompute() : this.fieldExpressions;
    }

    private IndexedSeq<Option<String>> foldableFieldNames$lzycompute() {
        JsonTuple jsonTuple = this;
        synchronized (jsonTuple) {
            if ((byte)(this.bitmap$trans$0 & 8) == 0) {
                this.foldableFieldNames = ((TraversableOnce)this.fieldExpressions().map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    Expression expression = x0$2;
                    Option option = expression.foldable() ? Option$.MODULE$.apply(expression.eval(expression.eval$default$1())).map((Function1 & Serializable & scala.Serializable)x$6 -> ((UTF8String)x$6).toString()) : null;
                    return option;
                }, Seq$.MODULE$.canBuildFrom())).toIndexedSeq();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 8);
            }
        }
        return this.foldableFieldNames;
    }

    private IndexedSeq<Option<String>> foldableFieldNames() {
        return (byte)(this.bitmap$trans$0 & 8) == 0 ? this.foldableFieldNames$lzycompute() : this.foldableFieldNames;
    }

    private int constantFields$lzycompute() {
        JsonTuple jsonTuple = this;
        synchronized (jsonTuple) {
            if ((byte)(this.bitmap$trans$0 & 0x10) == 0) {
                this.constantFields = this.foldableFieldNames().count((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)JsonTuple.$anonfun$constantFields$1(x$7)));
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 0x10);
            }
        }
        return this.constantFields;
    }

    private int constantFields() {
        return (byte)(this.bitmap$trans$0 & 0x10) == 0 ? this.constantFields$lzycompute() : this.constantFields;
    }

    @Override
    public StructType elementSchema() {
        return StructType$.MODULE$.apply((Seq<StructField>)((Seq)((TraversableLike)this.fieldExpressions().zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int idx = tuple2._2$mcI$sp();
            StructField structField = new StructField(new StringBuilder(1).append("c").append(idx).toString(), StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
            return structField;
        }, Seq$.MODULE$.canBuildFrom())));
    }

    @Override
    public String prettyName() {
        return "json_tuple";
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return this.children().length() < 2 ? new TypeCheckResult.TypeCheckFailure(new StringBuilder(32).append(this.prettyName()).append(" requires at least two arguments").toString()) : (this.children().forall((Function1 & Serializable & scala.Serializable)child -> BoxesRunTime.boxToBoolean((boolean)StringType$.MODULE$.acceptsType(child.dataType()))) ? TypeCheckResult$TypeCheckSuccess$.MODULE$ : new TypeCheckResult.TypeCheckFailure(new StringBuilder(40).append(this.prettyName()).append(" requires that all arguments are strings").toString()));
    }

    @Override
    public TraversableOnce<InternalRow> eval(InternalRow input) {
        TraversableOnce traversableOnce;
        UTF8String json = (UTF8String)this.jsonExpr().eval(input);
        if (json == null) {
            return this.nullRow();
        }
        try {
            traversableOnce = (TraversableOnce)Utils$.MODULE$.tryWithResource((Function0 & Serializable & scala.Serializable)() -> CreateJacksonParser$.MODULE$.utf8String(SharedFactory$.MODULE$.jsonFactory(), json), (Function1 & Serializable & scala.Serializable)parser -> this.parseRow((JsonParser)parser, input));
        }
        catch (JsonProcessingException jsonProcessingException) {
            traversableOnce = this.nullRow();
        }
        return traversableOnce;
    }

    private Seq<InternalRow> parseRow(JsonParser parser, InternalRow input) {
        JsonToken jsonToken = parser.nextToken();
        JsonToken jsonToken2 = JsonToken.START_OBJECT;
        if (jsonToken == null ? jsonToken2 != null : !jsonToken.equals(jsonToken2)) {
            return this.nullRow();
        }
        Seq fieldNames = this.constantFields() == this.fieldExpressions().length() ? (Seq)this.foldableFieldNames().map((Function1 & Serializable & scala.Serializable)x$8 -> (String)x$8.orNull(Predef$.MODULE$.$conforms()), IndexedSeq$.MODULE$.canBuildFrom()) : (this.constantFields() == 0 ? (Seq)this.fieldExpressions().map((Function1 & Serializable & scala.Serializable)x$9 -> ((UTF8String)x$9.eval(input)).toString(), Seq$.MODULE$.canBuildFrom()) : (Seq)((TraversableLike)this.foldableFieldNames().zip(this.fieldExpressions(), IndexedSeq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$4 -> {
            Tuple2 tuple2 = x0$4;
            if (tuple2 != null) {
                Option option = (Option)tuple2._1();
                Expression expr = (Expression)tuple2._2();
                if (option == null) {
                    return ((UTF8String)expr.eval(input)).toString();
                }
            }
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            Option fieldName = (Option)tuple2._1();
            return (String)fieldName.orNull(Predef$.MODULE$.$conforms());
        }, IndexedSeq$.MODULE$.canBuildFrom()));
        Object[] row = (Object[])Array$.MODULE$.ofDim(fieldNames.length(), ClassTag$.MODULE$.Any());
        while (true) {
            String jsonField;
            int idx;
            JsonToken jsonToken3 = parser.nextToken();
            JsonToken jsonToken4 = JsonToken.END_OBJECT;
            if (!(jsonToken3 == null ? jsonToken4 != null : !jsonToken3.equals(jsonToken4))) break;
            JsonToken jsonToken5 = parser.getCurrentToken();
            JsonToken jsonToken6 = JsonToken.FIELD_NAME;
            if (!(jsonToken5 != null ? !jsonToken5.equals(jsonToken6) : jsonToken6 != null) && (idx = fieldNames.indexOf((Object)(jsonField = parser.getCurrentName()))) >= 0) {
                ByteArrayOutputStream output = new ByteArrayOutputStream();
                JsonToken jsonToken7 = parser.nextToken();
                JsonToken jsonToken8 = JsonToken.VALUE_NULL;
                if (jsonToken7 == null ? jsonToken8 != null : !jsonToken7.equals(jsonToken8)) {
                    Utils$.MODULE$.tryWithResource((Function0 & Serializable & scala.Serializable)() -> SharedFactory$.MODULE$.jsonFactory().createGenerator((OutputStream)output, JsonEncoding.UTF8), (Function1 & Serializable & scala.Serializable)generator -> {
                        this.copyCurrentStructure(generator, parser);
                        return BoxedUnit.UNIT;
                    });
                    UTF8String jsonValue = UTF8String.fromBytes((byte[])output.toByteArray());
                    do {
                        row[idx] = jsonValue;
                    } while ((idx = fieldNames.indexOf((Object)jsonField, idx + 1)) >= 0);
                }
            }
            parser.skipChildren();
        }
        GenericInternalRow genericInternalRow = new GenericInternalRow(row);
        return Nil$.MODULE$.$colon$colon((Object)genericInternalRow);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void copyCurrentStructure(JsonGenerator generator, JsonParser parser) {
        boolean bl = false;
        JsonToken jsonToken = null;
        JsonToken jsonToken2 = parser.getCurrentToken();
        if (JsonToken.VALUE_STRING.equals(jsonToken2)) {
            bl = true;
            jsonToken = jsonToken2;
            if (parser.hasTextCharacters()) {
                generator.writeRaw(parser.getTextCharacters(), parser.getTextOffset(), parser.getTextLength());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (bl) {
            generator.writeRaw(parser.getText());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (JsonToken.VALUE_NULL.equals(jsonToken2)) {
            throw new IllegalStateException("Do not attempt to copy a null field");
        }
        generator.copyCurrentStructure(parser);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public JsonTuple copy(Seq<Expression> children2) {
        return new JsonTuple(children2);
    }

    public Seq<Expression> copy$default$1() {
        return this.children();
    }

    @Override
    public String productPrefix() {
        return "JsonTuple";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return this.children();
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof JsonTuple;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof JsonTuple)) return false;
        boolean bl = true;
        if (!bl) return false;
        JsonTuple jsonTuple = (JsonTuple)x$1;
        Seq<Expression> seq = this.children();
        Seq<Expression> seq2 = jsonTuple.children();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        if (!jsonTuple.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$constantFields$1(Option x$7) {
        return x$7 != null;
    }

    public JsonTuple(Seq<Expression> children2) {
        this.children = children2;
        Generator.$init$(this);
        CodegenFallback.$init$(this);
    }
}

