/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.expressions.BinaryComparison;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.LessThan$;
import org.apache.spark.sql.catalyst.expressions.package;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="expr1 _FUNC_ expr2 - Returns true if `expr1` is less than `expr2`.", arguments="\n    Arguments:\n      * expr1, expr2 - the two expressions must be same type or can be casted to a common type,\n          and must be a type that can be ordered. For example, map type is not orderable, so it\n          is not supported. For complex types such array/struct, the data types of fields must\n          be orderable.\n  ", examples="\n    Examples:\n      > SELECT 1 _FUNC_ 2;\n       true\n      > SELECT 1.1 _FUNC_ '1';\n       false\n      > SELECT to_date('2009-07-30 04:17:52') _FUNC_ to_date('2009-07-30 04:17:52');\n       false\n      > SELECT to_date('2009-07-30 04:17:52') _FUNC_ to_date('2009-08-01 04:17:52');\n       true\n      > SELECT 1 _FUNC_ NULL;\n       NULL\n  ")
@ScalaSignature(bytes="\u0006\u0001\u0005ud\u0001B\u0001\u0003\u0001>\u0011\u0001\u0002T3tgRC\u0017M\u001c\u0006\u0003\u0007\u0011\t1\"\u001a=qe\u0016\u001c8/[8og*\u0011QAB\u0001\tG\u0006$\u0018\r\\=ti*\u0011q\u0001C\u0001\u0004gFd'BA\u0005\u000b\u0003\u0015\u0019\b/\u0019:l\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001M)\u0001\u0001\u0005\u000b\u001cCA\u0011\u0011CE\u0007\u0002\u0005%\u00111C\u0001\u0002\u0011\u0005&t\u0017M]=D_6\u0004\u0018M]5t_:\u0004\"!\u0006\r\u000f\u0005E1\u0012BA\f\u0003\u0003\u001d\u0001\u0018mY6bO\u0016L!!\u0007\u000e\u0003\u001d9+H\u000e\\%oi>dWM]1oi*\u0011qC\u0001\t\u00039}i\u0011!\b\u0006\u0002=\u0005)1oY1mC&\u0011\u0001%\b\u0002\b!J|G-^2u!\ta\"%\u0003\u0002$;\ta1+\u001a:jC2L'0\u00192mK\"AQ\u0005\u0001BK\u0002\u0013\u0005a%\u0001\u0003mK\u001a$X#A\u0014\u0011\u0005EA\u0013BA\u0015\u0003\u0005))\u0005\u0010\u001d:fgNLwN\u001c\u0005\tW\u0001\u0011\t\u0012)A\u0005O\u0005)A.\u001a4uA!AQ\u0006\u0001BK\u0002\u0013\u0005a%A\u0003sS\u001eDG\u000f\u0003\u00050\u0001\tE\t\u0015!\u0003(\u0003\u0019\u0011\u0018n\u001a5uA!)\u0011\u0007\u0001C\u0001e\u00051A(\u001b8jiz\"2a\r\u001b6!\t\t\u0002\u0001C\u0003&a\u0001\u0007q\u0005C\u0003.a\u0001\u0007q\u0005C\u00038\u0001\u0011\u0005\u0003(\u0001\u0004ts6\u0014w\u000e\\\u000b\u0002sA\u0011!(\u0011\b\u0003w}\u0002\"\u0001P\u000f\u000e\u0003uR!A\u0010\b\u0002\rq\u0012xn\u001c;?\u0013\t\u0001U$\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0005\u000e\u0013aa\u0015;sS:<'B\u0001!\u001e\u0011\u0015)\u0005\u0001\"\u0015G\u00031qW\u000f\u001c7TC\u001a,WI^1m)\r9%\n\u0014\t\u00039!K!!S\u000f\u0003\u0007\u0005s\u0017\u0010C\u0003L\t\u0002\u0007q)\u0001\u0004j]B,H/\r\u0005\u0006\u001b\u0012\u0003\raR\u0001\u0007S:\u0004X\u000f\u001e\u001a\t\u000f=\u0003\u0011\u0011!C\u0001!\u0006!1m\u001c9z)\r\u0019\u0014K\u0015\u0005\bK9\u0003\n\u00111\u0001(\u0011\u001dic\n%AA\u0002\u001dBq\u0001\u0016\u0001\u0012\u0002\u0013\u0005Q+\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0003YS#aJ,,\u0003a\u0003\"!\u00170\u000e\u0003iS!a\u0017/\u0002\u0013Ut7\r[3dW\u0016$'BA/\u001e\u0003)\tgN\\8uCRLwN\\\u0005\u0003?j\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011\u001d\t\u0007!%A\u0005\u0002U\u000babY8qs\u0012\"WMZ1vYR$#\u0007C\u0004d\u0001\u0005\u0005I\u0011\t3\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\u0005)\u0007C\u00014l\u001b\u00059'B\u00015j\u0003\u0011a\u0017M\\4\u000b\u0003)\fAA[1wC&\u0011!i\u001a\u0005\b[\u0002\t\t\u0011\"\u0001o\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\u0005y\u0007C\u0001\u000fq\u0013\t\tXDA\u0002J]RDqa\u001d\u0001\u0002\u0002\u0013\u0005A/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\u0005\u001d+\bb\u0002<s\u0003\u0003\u0005\ra\\\u0001\u0004q\u0012\n\u0004b\u0002=\u0001\u0003\u0003%\t%_\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\t!\u0010E\u0002|}\u001ek\u0011\u0001 \u0006\u0003{v\t!bY8mY\u0016\u001cG/[8o\u0013\tyHP\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0011%\t\u0019\u0001AA\u0001\n\u0003\t)!\u0001\u0005dC:,\u0015/^1m)\u0011\t9!!\u0004\u0011\u0007q\tI!C\u0002\u0002\fu\u0011qAQ8pY\u0016\fg\u000e\u0003\u0005w\u0003\u0003\t\t\u00111\u0001H\u0011%\t\t\u0002AA\u0001\n\u0003\n\u0019\"\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003\u000f\t)\u0002\u0003\u0005w\u0003\u001f\t\t\u00111\u0001HQ=\u0001\u0011\u0011DA\u0010\u0003C\t)#a\n\u0002,\u00055\u0002cA\t\u0002\u001c%\u0019\u0011Q\u0004\u0002\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u00111E\u0001CKb\u0004(/\r\u0011`\rVs5i\u0018\u0011fqB\u0014(\u0007I\u0017!%\u0016$XO\u001d8tAQ\u0014X/\u001a\u0011jM\u0002\u0002W\r\u001f9sc\u0001\u0004\u0013n\u001d\u0011mKN\u001c\b\u0005\u001e5b]\u0002\u0002W\r\u001f9se\u0001t\u0013!C1sOVlWM\u001c;tC\t\tI#\u0001BJ\u0015\u0001\u0002\u0003\u0005I!sOVlWM\u001c;tu)\u0001\u0003\u0005\t\u0011!A)\u0002S\r\u001f9sc1\u0002S\r\u001f9se\u0001j\u0003\u0005\u001e5fAQ<x\u000eI3yaJ,7o]5p]N\u0004S.^:uA\t,\u0007e]1nK\u0002\"\u0018\u0010]3!_J\u00043-\u00198!E\u0016\u00043-Y:uK\u0012\u0004Co\u001c\u0011bA\r|W.\\8oAQL\b/\u001a\u0017\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0013M\u001c3![V\u001cH\u000f\t2fA\u0005\u0004C/\u001f9fAQD\u0017\r\u001e\u0011dC:\u0004#-\u001a\u0011pe\u0012,'/\u001a3/A\u0019{'\u000fI3yC6\u0004H.\u001a\u0017![\u0006\u0004\b\u0005^=qK\u0002J7\u000f\t8pi\u0002z'\u000fZ3sC\ndW\r\f\u0011t_\u0002JGO\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A%\u001c\bE\\8uAM,\b\u000f]8si\u0016$g\u0006\t$pe\u0002\u001aw.\u001c9mKb\u0004C/\u001f9fg\u0002\u001aXo\u00195!CJ\u0014\u0018-_\u0018tiJ,8\r\u001e\u0017!i\",\u0007\u0005Z1uC\u0002\"\u0018\u0010]3tA=4\u0007EZ5fY\u0012\u001c\b%\\;ti*\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t2fA=\u0014H-\u001a:bE2,gF\u0003\u0011!\u0003!)\u00070Y7qY\u0016\u001c\u0018EAA\u0018\u0003\t\r&\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI\u0019!?\u001a+fjQ0!emR\u0001\u0005\t\u0011!A\u0001\u0002CO];f\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002\nd&\r\u0011`\rVs5i\u0018\u0011(c\u001dZ$\u0002\t\u0011!A\u0001\u0002\u0003EZ1mg\u0016T\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006\u0005^8`I\u0006$X\rK\u00143aAJT\u0006M\u001c.gA\u0002\u0003\u0007\u000e\u001e2oi*$gJ\u0015!?\u001a+fjQ0!i>|F-\u0019;fQ\u001d\u0012\u0004\u0007M\u001d.a]j3\u0007\r\u00111ii\ntGO\u001b3O%Z$\u0002\t\u0011!A\u0001\u0002\u0003EZ1mg\u0016T\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006\u0005^8`I\u0006$X\rK\u00143aAJT\u0006M\u001c.gA\u0002\u0003\u0007\u000e\u001e2oi*$gJ\u0015!?\u001a+fjQ0!i>|F-\u0019;fQ\u001d\u0012\u0004\u0007M\u001d.aaj\u0003'\r\u00111ii\ntGO\u001b3O%Z$\u0002\t\u0011!A\u0001\u0002\u0003\u0005\u001e:vK*\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003\u0013\u0007I0G+:\u001bu\f\t(V\u00192[$\u0002\t\u0011!A\u0001\u0002\u0003ET+M\u0019*\u0001\u0003eB\u0005\u00024\t\t\t\u0011#\u0001\u00026\u0005AA*Z:t)\"\fg\u000eE\u0002\u0012\u0003o1\u0001\"\u0001\u0002\u0002\u0002#\u0005\u0011\u0011H\n\u0006\u0003o\tY$\t\t\b\u0003{\t\u0019eJ\u00144\u001b\t\tyDC\u0002\u0002Bu\tqA];oi&lW-\u0003\u0003\u0002F\u0005}\"!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oe!9\u0011'a\u000e\u0005\u0002\u0005%CCAA\u001b\u0011)\ti%a\u000e\u0002\u0002\u0013\u0015\u0013qJ\u0001\ti>\u001cFO]5oOR\tQ\r\u0003\u0006\u0002T\u0005]\u0012\u0011!CA\u0003+\nQ!\u00199qYf$RaMA,\u00033Ba!JA)\u0001\u00049\u0003BB\u0017\u0002R\u0001\u0007q\u0005\u0003\u0006\u0002^\u0005]\u0012\u0011!CA\u0003?\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002b\u00055\u0004#\u0002\u000f\u0002d\u0005\u001d\u0014bAA3;\t1q\n\u001d;j_:\u0004R\u0001HA5O\u001dJ1!a\u001b\u001e\u0005\u0019!V\u000f\u001d7fe!I\u0011qNA.\u0003\u0003\u0005\raM\u0001\u0004q\u0012\u0002\u0004BCA:\u0003o\t\t\u0011\"\u0003\u0002v\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\t9\bE\u0002g\u0003sJ1!a\u001fh\u0005\u0019y%M[3di\u0002")
public class LessThan
extends BinaryComparison
implements package.NullIntolerant,
Serializable {
    private final Expression left;
    private final Expression right;

    public static Option<Tuple2<Expression, Expression>> unapply(LessThan lessThan) {
        return LessThan$.MODULE$.unapply(lessThan);
    }

    public static Function1<Tuple2<Expression, Expression>, LessThan> tupled() {
        return LessThan$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, LessThan>> curried() {
        return LessThan$.MODULE$.curried();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public String symbol() {
        return "<";
    }

    @Override
    public Object nullSafeEval(Object input1, Object input2) {
        return BoxesRunTime.boxToBoolean((boolean)this.ordering().lt(input1, input2));
    }

    public LessThan copy(Expression left, Expression right) {
        return new LessThan(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "LessThan";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.left();
                break;
            }
            case 1: {
                expression = this.right();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof LessThan;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof LessThan)) return false;
        boolean bl = true;
        if (!bl) return false;
        LessThan lessThan = (LessThan)x$1;
        Expression expression = this.left();
        Expression expression2 = lessThan.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = lessThan.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!lessThan.canEqual(this)) return false;
        return true;
    }

    public LessThan(Expression left, Expression right) {
        this.left = left;
        this.right = right;
    }
}

