/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.expressions.BinaryComparison;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.LessThanOrEqual$;
import org.apache.spark.sql.catalyst.expressions.package;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="expr1 _FUNC_ expr2 - Returns true if `expr1` is less than or equal to `expr2`.", arguments="\n    Arguments:\n      * expr1, expr2 - the two expressions must be same type or can be casted to a common type,\n          and must be a type that can be ordered. For example, map type is not orderable, so it\n          is not supported. For complex types such array/struct, the data types of fields must\n          be orderable.\n  ", examples="\n    Examples:\n      > SELECT 2 _FUNC_ 2;\n       true\n      > SELECT 1.0 _FUNC_ '1';\n       true\n      > SELECT to_date('2009-07-30 04:17:52') _FUNC_ to_date('2009-07-30 04:17:52');\n       true\n      > SELECT to_date('2009-07-30 04:17:52') _FUNC_ to_date('2009-08-01 04:17:52');\n       true\n      > SELECT 1 _FUNC_ NULL;\n       NULL\n  ")
@ScalaSignature(bytes="\u0006\u0001\u0005ud\u0001B\u0001\u0003\u0001>\u0011q\u0002T3tgRC\u0017M\\(s\u000bF,\u0018\r\u001c\u0006\u0003\u0007\u0011\t1\"\u001a=qe\u0016\u001c8/[8og*\u0011QAB\u0001\tG\u0006$\u0018\r\\=ti*\u0011q\u0001C\u0001\u0004gFd'BA\u0005\u000b\u0003\u0015\u0019\b/\u0019:l\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001M)\u0001\u0001\u0005\u000b\u001cCA\u0011\u0011CE\u0007\u0002\u0005%\u00111C\u0001\u0002\u0011\u0005&t\u0017M]=D_6\u0004\u0018M]5t_:\u0004\"!\u0006\r\u000f\u0005E1\u0012BA\f\u0003\u0003\u001d\u0001\u0018mY6bO\u0016L!!\u0007\u000e\u0003\u001d9+H\u000e\\%oi>dWM]1oi*\u0011qC\u0001\t\u00039}i\u0011!\b\u0006\u0002=\u0005)1oY1mC&\u0011\u0001%\b\u0002\b!J|G-^2u!\ta\"%\u0003\u0002$;\ta1+\u001a:jC2L'0\u00192mK\"AQ\u0005\u0001BK\u0002\u0013\u0005a%\u0001\u0003mK\u001a$X#A\u0014\u0011\u0005EA\u0013BA\u0015\u0003\u0005))\u0005\u0010\u001d:fgNLwN\u001c\u0005\tW\u0001\u0011\t\u0012)A\u0005O\u0005)A.\u001a4uA!AQ\u0006\u0001BK\u0002\u0013\u0005a%A\u0003sS\u001eDG\u000f\u0003\u00050\u0001\tE\t\u0015!\u0003(\u0003\u0019\u0011\u0018n\u001a5uA!)\u0011\u0007\u0001C\u0001e\u00051A(\u001b8jiz\"2a\r\u001b6!\t\t\u0002\u0001C\u0003&a\u0001\u0007q\u0005C\u0003.a\u0001\u0007q\u0005C\u00038\u0001\u0011\u0005\u0003(\u0001\u0004ts6\u0014w\u000e\\\u000b\u0002sA\u0011!(\u0011\b\u0003w}\u0002\"\u0001P\u000f\u000e\u0003uR!A\u0010\b\u0002\rq\u0012xn\u001c;?\u0013\t\u0001U$\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0005\u000e\u0013aa\u0015;sS:<'B\u0001!\u001e\u0011\u0015)\u0005\u0001\"\u0015G\u00031qW\u000f\u001c7TC\u001a,WI^1m)\r9%\n\u0014\t\u00039!K!!S\u000f\u0003\u0007\u0005s\u0017\u0010C\u0003L\t\u0002\u0007q)\u0001\u0004j]B,H/\r\u0005\u0006\u001b\u0012\u0003\raR\u0001\u0007S:\u0004X\u000f\u001e\u001a\t\u000f=\u0003\u0011\u0011!C\u0001!\u0006!1m\u001c9z)\r\u0019\u0014K\u0015\u0005\bK9\u0003\n\u00111\u0001(\u0011\u001dic\n%AA\u0002\u001dBq\u0001\u0016\u0001\u0012\u0002\u0013\u0005Q+\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0003YS#aJ,,\u0003a\u0003\"!\u00170\u000e\u0003iS!a\u0017/\u0002\u0013Ut7\r[3dW\u0016$'BA/\u001e\u0003)\tgN\\8uCRLwN\\\u0005\u0003?j\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011\u001d\t\u0007!%A\u0005\u0002U\u000babY8qs\u0012\"WMZ1vYR$#\u0007C\u0004d\u0001\u0005\u0005I\u0011\t3\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\u0005)\u0007C\u00014l\u001b\u00059'B\u00015j\u0003\u0011a\u0017M\\4\u000b\u0003)\fAA[1wC&\u0011!i\u001a\u0005\b[\u0002\t\t\u0011\"\u0001o\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\u0005y\u0007C\u0001\u000fq\u0013\t\tXDA\u0002J]RDqa\u001d\u0001\u0002\u0002\u0013\u0005A/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\u0005\u001d+\bb\u0002<s\u0003\u0003\u0005\ra\\\u0001\u0004q\u0012\n\u0004b\u0002=\u0001\u0003\u0003%\t%_\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\t!\u0010E\u0002|}\u001ek\u0011\u0001 \u0006\u0003{v\t!bY8mY\u0016\u001cG/[8o\u0013\tyHP\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0011%\t\u0019\u0001AA\u0001\n\u0003\t)!\u0001\u0005dC:,\u0015/^1m)\u0011\t9!!\u0004\u0011\u0007q\tI!C\u0002\u0002\fu\u0011qAQ8pY\u0016\fg\u000e\u0003\u0005w\u0003\u0003\t\t\u00111\u0001H\u0011%\t\t\u0002AA\u0001\n\u0003\n\u0019\"\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003\u000f\t)\u0002\u0003\u0005w\u0003\u001f\t\t\u00111\u0001HQ=\u0001\u0011\u0011DA\u0010\u0003C\t)#a\n\u0002,\u00055\u0002cA\t\u0002\u001c%\u0019\u0011Q\u0004\u0002\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u00111E\u0001OKb\u0004(/\r\u0011`\rVs5i\u0018\u0011fqB\u0014(\u0007I\u0017!%\u0016$XO\u001d8tAQ\u0014X/\u001a\u0011jM\u0002\u0002W\r\u001f9sc\u0001\u0004\u0013n\u001d\u0011mKN\u001c\b\u0005\u001e5b]\u0002z'\u000fI3rk\u0006d\u0007\u0005^8!A\u0016D\bO\u001d\u001aa]\u0005I\u0011M]4v[\u0016tGo]\u0011\u0003\u0003S\t!1\u0013\u0006!A\u0001\u0002\u0013I]4v[\u0016tGo\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011+A\u0015D\bO]\u0019-A\u0015D\bO\u001d\u001a![\u0001\"\b.\u001a\u0011uo>\u0004S\r\u001f9sKN\u001c\u0018n\u001c8tA5,8\u000f\u001e\u0011cK\u0002\u001a\u0018-\\3!if\u0004X\rI8sA\r\fg\u000e\t2fA\r\f7\u000f^3eAQ|\u0007%\u0019\u0011d_6lwN\u001c\u0011usB,GF\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0005tG\rI7vgR\u0004#-\u001a\u0011bAQL\b/\u001a\u0011uQ\u0006$\beY1oA\t,\u0007e\u001c:eKJ,GM\f\u0011G_J\u0004S\r_1na2,G\u0006I7ba\u0002\"\u0018\u0010]3!SN\u0004cn\u001c;!_J$WM]1cY\u0016d\u0003e]8!SRT\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011jg\u0002rw\u000e\u001e\u0011tkB\u0004xN\u001d;fI:\u0002ci\u001c:!G>l\u0007\u000f\\3yAQL\b/Z:!gV\u001c\u0007\u000eI1se\u0006Lxf\u001d;sk\u000e$H\u0006\t;iK\u0002\"\u0017\r^1!if\u0004Xm\u001d\u0011pM\u00022\u0017.\u001a7eg\u0002jWo\u001d;\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002#-\u001a\u0011pe\u0012,'/\u00192mK:R\u0001\u0005I\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u0011qF\u0001\u0003 *\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003#\u0007I0G+:\u001bu\f\t\u001a<\u0015\u0001\u0002\u0003\u0005\t\u0011!AQ\u0014X/\u001a\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!c9\u0002\u0004e\u0018$V\u001d\u000e{\u0006eJ\u0019(w)\u0001\u0003\u0005\t\u0011!A\u0001\"(/^3\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UAQ|w\fZ1uK\":#\u0007\r\u0019:[A:Tf\r\u0019!aQR\u0014g\u000e\u001e6e\u001dJ\u0003e\u0018$V\u001d\u000e{\u0006\u0005^8`I\u0006$X\rK\u00143aAJT\u0006M\u001c.gA\u0002\u0003\u0007\u000e\u001e2oi*$gJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AQ\u0014X/\u001a\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!i>|F-\u0019;fQ\u001d\u0012\u0004\u0007M\u001d.a]j3\u0007\r\u00111ii\ntGO\u001b3O%\u0002sLR+O\u0007~\u0003Co\\0eCR,\u0007f\n\u001a1aej\u0003\u0007O\u00171c\u0001\u0002DGO\u00198uU\u0012t%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!iJ,XM\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u00112A}3UKT\"`A9+F\nT\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!\u001dVcEJ\u0003\u0011!\u000f%\t\u0019DAA\u0001\u0012\u0003\t)$A\bMKN\u001cH\u000b[1o\u001fJ,\u0015/^1m!\r\t\u0012q\u0007\u0004\t\u0003\t\t\t\u0011#\u0001\u0002:M)\u0011qGA\u001eCA9\u0011QHA\"O\u001d\u001aTBAA \u0015\r\t\t%H\u0001\beVtG/[7f\u0013\u0011\t)%a\u0010\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t'\u0007C\u00042\u0003o!\t!!\u0013\u0015\u0005\u0005U\u0002BCA'\u0003o\t\t\u0011\"\u0012\u0002P\u0005AAo\\*ue&tw\rF\u0001f\u0011)\t\u0019&a\u000e\u0002\u0002\u0013\u0005\u0015QK\u0001\u0006CB\u0004H.\u001f\u000b\u0006g\u0005]\u0013\u0011\f\u0005\u0007K\u0005E\u0003\u0019A\u0014\t\r5\n\t\u00061\u0001(\u0011)\ti&a\u000e\u0002\u0002\u0013\u0005\u0015qL\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\t\t'!\u001c\u0011\u000bq\t\u0019'a\u001a\n\u0007\u0005\u0015TD\u0001\u0004PaRLwN\u001c\t\u00069\u0005%teJ\u0005\u0004\u0003Wj\"A\u0002+va2,'\u0007C\u0005\u0002p\u0005m\u0013\u0011!a\u0001g\u0005\u0019\u0001\u0010\n\u0019\t\u0015\u0005M\u0014qGA\u0001\n\u0013\t)(A\u0006sK\u0006$'+Z:pYZ,GCAA<!\r1\u0017\u0011P\u0005\u0004\u0003w:'AB(cU\u0016\u001cG\u000f")
public class LessThanOrEqual
extends BinaryComparison
implements package.NullIntolerant,
Serializable {
    private final Expression left;
    private final Expression right;

    public static Option<Tuple2<Expression, Expression>> unapply(LessThanOrEqual lessThanOrEqual) {
        return LessThanOrEqual$.MODULE$.unapply(lessThanOrEqual);
    }

    public static Function1<Tuple2<Expression, Expression>, LessThanOrEqual> tupled() {
        return LessThanOrEqual$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, LessThanOrEqual>> curried() {
        return LessThanOrEqual$.MODULE$.curried();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public String symbol() {
        return "<=";
    }

    @Override
    public Object nullSafeEval(Object input1, Object input2) {
        return BoxesRunTime.boxToBoolean((boolean)this.ordering().lteq(input1, input2));
    }

    public LessThanOrEqual copy(Expression left, Expression right) {
        return new LessThanOrEqual(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "LessThanOrEqual";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.left();
                break;
            }
            case 1: {
                expression = this.right();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof LessThanOrEqual;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof LessThanOrEqual)) return false;
        boolean bl = true;
        if (!bl) return false;
        LessThanOrEqual lessThanOrEqual = (LessThanOrEqual)x$1;
        Expression expression = this.left();
        Expression expression2 = lessThanOrEqual.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = lessThanOrEqual.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!lessThanOrEqual.canEqual(this)) return false;
        return true;
    }

    public LessThanOrEqual(Expression left, Expression right) {
        this.left = left;
        this.right = right;
    }
}

