/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.util.TimeZone;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Minute$;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(timestamp) - Returns the minute component of the string/timestamp.", examples="\n    Examples:\n      > SELECT _FUNC_('2009-07-30 12:58:59');\n       58\n  ", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0001\u0005}g\u0001B\u0001\u0003\u0001>\u0011a!T5okR,'BA\u0002\u0005\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005\u00151\u0011\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005\u001dA\u0011aA:rY*\u0011\u0011BC\u0001\u0006gB\f'o\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\r\u0001\u0001Bc\u0006\u000e!!\t\t\"#D\u0001\u0003\u0013\t\u0019\"AA\bV]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o!\t\tR#\u0003\u0002\u0017\u0005\t9B+[7f5>tW-Q<be\u0016,\u0005\u0010\u001d:fgNLwN\u001c\t\u0003#aI!!\u0007\u0002\u0003-%k\u0007\u000f\\5dSR\u001c\u0015m\u001d;J]B,H\u000fV=qKN\u0004\"a\u0007\u0010\u000e\u0003qQ\u0011!H\u0001\u0006g\u000e\fG.Y\u0005\u0003?q\u0011q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002\u001cC%\u0011!\u0005\b\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\tI\u0001\u0011)\u001a!C\u0001K\u0005)1\r[5mIV\ta\u0005\u0005\u0002\u0012O%\u0011\u0001F\u0001\u0002\u000b\u000bb\u0004(/Z:tS>t\u0007\u0002\u0003\u0016\u0001\u0005#\u0005\u000b\u0011\u0002\u0014\u0002\r\rD\u0017\u000e\u001c3!\u0011!a\u0003A!f\u0001\n\u0003i\u0013A\u0003;j[\u0016TvN\\3JIV\ta\u0006E\u0002\u001c_EJ!\u0001\r\u000f\u0003\r=\u0003H/[8o!\t\u0011\u0014H\u0004\u00024oA\u0011A\u0007H\u0007\u0002k)\u0011aGD\u0001\u0007yI|w\u000e\u001e \n\u0005ab\u0012A\u0002)sK\u0012,g-\u0003\u0002;w\t11\u000b\u001e:j]\u001eT!\u0001\u000f\u000f\t\u0011u\u0002!\u0011#Q\u0001\n9\n1\u0002^5nKj{g.Z%eA!)q\b\u0001C\u0001\u0001\u00061A(\u001b8jiz\"2!\u0011\"D!\t\t\u0002\u0001C\u0003%}\u0001\u0007a\u0005C\u0004-}A\u0005\t\u0019\u0001\u0018\t\u000b}\u0002A\u0011A#\u0015\u0005\u00053\u0005\"\u0002\u0013E\u0001\u00041\u0003\"\u0002%\u0001\t\u0003J\u0015AC5oaV$H+\u001f9fgV\t!\nE\u0002L!Ns!\u0001\u0014(\u000f\u0005Qj\u0015\"A\u000f\n\u0005=c\u0012a\u00029bG.\fw-Z\u0005\u0003#J\u00131aU3r\u0015\tyE\u0004\u0005\u0002U/6\tQK\u0003\u0002W\r\u0005)A/\u001f9fg&\u0011\u0001,\u0016\u0002\u0011\u0003\n\u001cHO]1di\u0012\u000bG/\u0019+za\u0016DQA\u0017\u0001\u0005Bm\u000b\u0001\u0002Z1uCRK\b/Z\u000b\u00029B\u0011A+X\u0005\u0003=V\u0013\u0001\u0002R1uCRK\b/\u001a\u0005\u0006A\u0002!\t%Y\u0001\ro&$\b\u000eV5nKj{g.\u001a\u000b\u0003)\tDQ\u0001L0A\u0002EBQ\u0001\u001a\u0001\u0005R\u0015\fAB\\;mYN\u000bg-Z#wC2$\"AZ5\u0011\u0005m9\u0017B\u00015\u001d\u0005\r\te.\u001f\u0005\u0006U\u000e\u0004\rAZ\u0001\ni&lWm\u001d;b[BDQ\u0001\u001c\u0001\u0005B5\f\u0011\u0002Z8HK:\u001cu\u000eZ3\u0015\u00079$\u0018\u0010\u0005\u0002pe6\t\u0001O\u0003\u0002r\u0005\u000591m\u001c3fO\u0016t\u0017BA:q\u0005!)\u0005\u0010\u001d:D_\u0012,\u0007\"B;l\u0001\u00041\u0018aA2uqB\u0011qn^\u0005\u0003qB\u0014abQ8eK\u001e,gnQ8oi\u0016DH\u000fC\u0003{W\u0002\u0007a.\u0001\u0002fm\"9A\u0010AA\u0001\n\u0003i\u0018\u0001B2paf$2!\u0011@\u0000\u0011\u001d!3\u0010%AA\u0002\u0019Bq\u0001L>\u0011\u0002\u0003\u0007a\u0006C\u0005\u0002\u0004\u0001\t\n\u0011\"\u0001\u0002\u0006\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA\u0004U\r1\u0013\u0011B\u0016\u0003\u0003\u0017\u0001B!!\u0004\u0002\u00185\u0011\u0011q\u0002\u0006\u0005\u0003#\t\u0019\"A\u0005v]\u000eDWmY6fI*\u0019\u0011Q\u0003\u000f\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\u001a\u0005=!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"I\u0011Q\u0004\u0001\u0012\u0002\u0013\u0005\u0011qD\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\t\tCK\u0002/\u0003\u0013A\u0011\"!\n\u0001\u0003\u0003%\t%a\n\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\tI\u0003\u0005\u0003\u0002,\u0005URBAA\u0017\u0015\u0011\ty#!\r\u0002\t1\fgn\u001a\u0006\u0003\u0003g\tAA[1wC&\u0019!(!\f\t\u0013\u0005e\u0002!!A\u0005\u0002\u0005m\u0012\u0001\u00049s_\u0012,8\r^!sSRLXCAA\u001f!\rY\u0012qH\u0005\u0004\u0003\u0003b\"aA%oi\"I\u0011Q\t\u0001\u0002\u0002\u0013\u0005\u0011qI\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\r1\u0017\u0011\n\u0005\u000b\u0003\u0017\n\u0019%!AA\u0002\u0005u\u0012a\u0001=%c!I\u0011q\n\u0001\u0002\u0002\u0013\u0005\u0013\u0011K\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u00111\u000b\t\u0006\u0003+\nYFZ\u0007\u0003\u0003/R1!!\u0017\u001d\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003;\n9F\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0011%\t\t\u0007AA\u0001\n\u0003\t\u0019'\u0001\u0005dC:,\u0015/^1m)\u0011\t)'a\u001b\u0011\u0007m\t9'C\u0002\u0002jq\u0011qAQ8pY\u0016\fg\u000eC\u0005\u0002L\u0005}\u0013\u0011!a\u0001M\"I\u0011q\u000e\u0001\u0002\u0002\u0013\u0005\u0013\u0011O\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005\u0015\u00141\u000f\u0005\n\u0003\u0017\ni'!AA\u0002\u0019Ds\u0002AA<\u0003{\ny(a!\u0002\u0006\u0006%\u00151\u0012\t\u0004#\u0005e\u0014bAA>\u0005\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAAA\u0003%{f)\u0016(D?\"\"\u0018.\\3ti\u0006l\u0007/\u000b\u0011.AI+G/\u001e:og\u0002\"\b.\u001a\u0011nS:,H/\u001a\u0011d_6\u0004xN\\3oi\u0002zg\r\t;iK\u0002\u001aHO]5oO>\"\u0018.\\3ti\u0006l\u0007OL\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u0011qQ\u0001J\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":#\u0007\r\u0019:[A:Tf\r\u0019!cIRT\u0007\u000f\u001e6s\u001dJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005I\u001b9\u0015\u0001\u0002\u0013!B:j]\u000e,\u0017EAAG\u0003\u0015\td&\u000e\u00181\u000f%\t\tJAA\u0001\u0012\u0003\t\u0019*\u0001\u0004NS:,H/\u001a\t\u0004#\u0005Ue\u0001C\u0001\u0003\u0003\u0003E\t!a&\u0014\u000b\u0005U\u0015\u0011\u0014\u0011\u0011\u000f\u0005m\u0015\u0011\u0015\u0014/\u00036\u0011\u0011Q\u0014\u0006\u0004\u0003?c\u0012a\u0002:v]RLW.Z\u0005\u0005\u0003G\u000biJA\tBEN$(/Y2u\rVt7\r^5p]JBqaPAK\t\u0003\t9\u000b\u0006\u0002\u0002\u0014\"Q\u00111VAK\u0003\u0003%)%!,\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!\u000b\t\u0015\u0005E\u0016QSA\u0001\n\u0003\u000b\u0019,A\u0003baBd\u0017\u0010F\u0003B\u0003k\u000b9\f\u0003\u0004%\u0003_\u0003\rA\n\u0005\tY\u0005=\u0006\u0013!a\u0001]!Q\u00111XAK\u0003\u0003%\t)!0\u0002\u000fUt\u0017\r\u001d9msR!\u0011qXAd!\u0011Yr&!1\u0011\u000bm\t\u0019M\n\u0018\n\u0007\u0005\u0015GD\u0001\u0004UkBdWM\r\u0005\n\u0003\u0013\fI,!AA\u0002\u0005\u000b1\u0001\u001f\u00131\u0011)\ti-!&\u0012\u0002\u0013\u0005\u0011qD\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\t\u0015\u0005E\u0017QSI\u0001\n\u0003\ty\"A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00133\u0011)\t).!&\u0002\u0002\u0013%\u0011q[\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002ZB!\u00111FAn\u0013\u0011\ti.!\f\u0003\r=\u0013'.Z2u\u0001")
public class Minute
extends UnaryExpression
implements TimeZoneAwareExpression,
ImplicitCastInputTypes,
scala.Serializable {
    private final Expression child;
    private final Option<String> timeZoneId;
    private boolean resolved;
    private transient TimeZone timeZone;
    private volatile boolean bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public static Option<String> apply$default$2() {
        return Minute$.MODULE$.apply$default$2();
    }

    public static Option<String> $lessinit$greater$default$2() {
        return Minute$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<Expression, Option<String>>> unapply(Minute minute) {
        return Minute$.MODULE$.unapply(minute);
    }

    public static Function1<Tuple2<Expression, Option<String>>, Minute> tupled() {
        return Minute$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Option<String>, Minute>> curried() {
        return Minute$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    private boolean resolved$lzycompute() {
        Minute minute = this;
        synchronized (minute) {
            if (!this.bitmap$0) {
                this.resolved = TimeZoneAwareExpression.resolved$(this);
                this.bitmap$0 = true;
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        return !this.bitmap$0 ? this.resolved$lzycompute() : this.resolved;
    }

    private TimeZone timeZone$lzycompute() {
        Minute minute = this;
        synchronized (minute) {
            if (!this.bitmap$trans$0) {
                this.timeZone = TimeZoneAwareExpression.timeZone$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.timeZone;
    }

    @Override
    public TimeZone timeZone() {
        return !this.bitmap$trans$0 ? this.timeZone$lzycompute() : this.timeZone;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TimestampType$[]{TimestampType$.MODULE$}));
    }

    @Override
    public DataType dataType() {
        return IntegerType$.MODULE$;
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Option x$7 = Option$.MODULE$.apply((Object)timeZoneId);
        Expression x$8 = this.copy$default$1();
        return this.copy(x$8, (Option<String>)x$7);
    }

    @Override
    public Object nullSafeEval(Object timestamp) {
        return BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getMinutes(BoxesRunTime.unboxToLong((Object)timestamp), this.timeZone()));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String tz = ctx.addReferenceObj("timeZone", this.timeZone(), ctx.addReferenceObj$default$3());
        String dtu = new StringOps(Predef$.MODULE$.augmentString(DateTimeUtils$.MODULE$.getClass().getName())).stripSuffix("$");
        return this.defineCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable & scala.Serializable)c -> new StringBuilder(15).append(dtu).append(".getMinutes(").append((String)c).append(", ").append(tz).append(")").toString());
    }

    public Minute copy(Expression child, Option<String> timeZoneId) {
        return new Minute(child, timeZoneId);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public Option<String> copy$default$2() {
        return this.timeZoneId();
    }

    @Override
    public String productPrefix() {
        return "Minute";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Option<String> option;
        int n = x$1;
        switch (n) {
            case 0: {
                option = this.child();
                break;
            }
            case 1: {
                option = this.timeZoneId();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return option;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Minute;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Minute)) return false;
        boolean bl = true;
        if (!bl) return false;
        Minute minute = (Minute)x$1;
        Expression expression = this.child();
        Expression expression2 = minute.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<String> option = this.timeZoneId();
        Option<String> option2 = minute.timeZoneId();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!minute.canEqual(this)) return false;
        return true;
    }

    public Minute(Expression child, Option<String> timeZoneId) {
        this.child = child;
        this.timeZoneId = timeZoneId;
        TimeZoneAwareExpression.$init$(this);
        ExpectsInputTypes.$init$(this);
    }

    public Minute(Expression child) {
        this(child, (Option<String>)None$.MODULE$);
    }
}

