/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ParseToTimestamp$;
import org.apache.spark.sql.catalyst.expressions.RuntimeReplaceable;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.Unevaluable;
import org.apache.spark.sql.catalyst.expressions.UnixTimestamp;
import org.apache.spark.sql.catalyst.expressions.UnixTimestamp$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(timestamp[, fmt]) - Parses the `timestamp` expression with the `fmt` expression to\n      a timestamp. Returns null with invalid input. By default, it follows casting rules to\n      a timestamp if the `fmt` is omitted.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('2016-12-31 00:12:00');\n       2016-12-31 00:12:00\n      > SELECT _FUNC_('2016-12-31', 'yyyy-MM-dd');\n       2016-12-31 00:00:00\n  ", since="2.2.0")
@ScalaSignature(bytes="\u0006\u0001\u0005ef\u0001B\u0001\u0003\u0001>\u0011\u0001\u0003U1sg\u0016$v\u000eV5nKN$\u0018-\u001c9\u000b\u0005\r!\u0011aC3yaJ,7o]5p]NT!!\u0002\u0004\u0002\u0011\r\fG/\u00197zgRT!a\u0002\u0005\u0002\u0007M\fHN\u0003\u0002\n\u0015\u0005)1\u000f]1sW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u0019R\u0001\u0001\t\u0015/u\u0001\"!\u0005\n\u000e\u0003\tI!a\u0005\u0002\u0003\u001fUs\u0017M]=FqB\u0014Xm]:j_:\u0004\"!E\u000b\n\u0005Y\u0011!A\u0005*v]RLW.\u001a*fa2\f7-Z1cY\u0016\u0004\"\u0001G\u000e\u000e\u0003eQ\u0011AG\u0001\u0006g\u000e\fG.Y\u0005\u00039e\u0011q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002\u0019=%\u0011q$\u0007\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\tC\u0001\u0011)\u001a!C\u0001E\u0005!A.\u001a4u+\u0005\u0019\u0003CA\t%\u0013\t)#A\u0001\u0006FqB\u0014Xm]:j_:D\u0001b\n\u0001\u0003\u0012\u0003\u0006IaI\u0001\u0006Y\u00164G\u000f\t\u0005\tS\u0001\u0011)\u001a!C\u0001U\u00051am\u001c:nCR,\u0012a\u000b\t\u000411\u001a\u0013BA\u0017\u001a\u0005\u0019y\u0005\u000f^5p]\"Aq\u0006\u0001B\tB\u0003%1&A\u0004g_Jl\u0017\r\u001e\u0011\t\u0011E\u0002!Q3A\u0005\u0002\t\nQa\u00195jY\u0012D\u0001b\r\u0001\u0003\u0012\u0003\u0006IaI\u0001\u0007G\"LG\u000e\u001a\u0011\t\u000bU\u0002A\u0011\u0001\u001c\u0002\rqJg.\u001b;?)\u00119\u0004(\u000f\u001e\u0011\u0005E\u0001\u0001\"B\u00115\u0001\u0004\u0019\u0003\"B\u00155\u0001\u0004Y\u0003\"B\u00195\u0001\u0004\u0019\u0003\"B\u001b\u0001\t\u0003aDcA\u001c>}!)\u0011e\u000fa\u0001G!)\u0011f\u000fa\u0001G!)Q\u0007\u0001C\u0001\u0001R\u0011q'\u0011\u0005\u0006C}\u0002\ra\t\u0005\u0006\u0007\u0002!\t\u0005R\u0001\u000eM2\fG/\u0011:hk6,g\u000e^:\u0016\u0003\u0015\u00032A\u0012(R\u001d\t9EJ\u0004\u0002I\u00176\t\u0011J\u0003\u0002K\u001d\u00051AH]8pizJ\u0011AG\u0005\u0003\u001bf\tq\u0001]1dW\u0006<W-\u0003\u0002P!\nA\u0011\n^3sCR|'O\u0003\u0002N3A\u0011\u0001DU\u0005\u0003'f\u00111!\u00118z\u0011\u00159\u0001\u0001\"\u0011V+\u00051\u0006CA,\\\u001d\tA\u0016\f\u0005\u0002I3%\u0011!,G\u0001\u0007!J,G-\u001a4\n\u0005qk&AB*ue&twM\u0003\u0002[3!)q\f\u0001C!+\u0006Q\u0001O]3uift\u0015-\\3\t\u000b\u0005\u0004A\u0011\t2\u0002\u0011\u0011\fG/\u0019+za\u0016,\u0012a\u0019\t\u0003I\u001el\u0011!\u001a\u0006\u0003M\u001a\tQ\u0001^=qKNL!\u0001[3\u0003\u0011\u0011\u000bG/\u0019+za\u0016DqA\u001b\u0001\u0002\u0002\u0013\u00051.\u0001\u0003d_BLH\u0003B\u001cm[:Dq!I5\u0011\u0002\u0003\u00071\u0005C\u0004*SB\u0005\t\u0019A\u0016\t\u000fEJ\u0007\u0013!a\u0001G!9\u0001\u000fAI\u0001\n\u0003\t\u0018AD2paf$C-\u001a4bk2$H%M\u000b\u0002e*\u00121e]\u0016\u0002iB\u0011QO_\u0007\u0002m*\u0011q\u000f_\u0001\nk:\u001c\u0007.Z2lK\u0012T!!_\r\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002|m\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u000fu\u0004\u0011\u0013!C\u0001}\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012T#A@+\u0005-\u001a\b\u0002CA\u0002\u0001E\u0005I\u0011A9\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%g!I\u0011q\u0001\u0001\u0002\u0002\u0013\u0005\u0013\u0011B\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005-\u0001\u0003BA\u0007\u0003/i!!a\u0004\u000b\t\u0005E\u00111C\u0001\u0005Y\u0006twM\u0003\u0002\u0002\u0016\u0005!!.\u0019<b\u0013\ra\u0016q\u0002\u0005\n\u00037\u0001\u0011\u0011!C\u0001\u0003;\tA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!a\b\u0011\u0007a\t\t#C\u0002\u0002$e\u00111!\u00138u\u0011%\t9\u0003AA\u0001\n\u0003\tI#\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\u0007E\u000bY\u0003\u0003\u0006\u0002.\u0005\u0015\u0012\u0011!a\u0001\u0003?\t1\u0001\u001f\u00132\u0011%\t\t\u0004AA\u0001\n\u0003\n\u0019$A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t)\u0004E\u0003\u00028\u0005u\u0012+\u0004\u0002\u0002:)\u0019\u00111H\r\u0002\u0015\r|G\u000e\\3di&|g.C\u0002P\u0003sA\u0011\"!\u0011\u0001\u0003\u0003%\t!a\u0011\u0002\u0011\r\fg.R9vC2$B!!\u0012\u0002LA\u0019\u0001$a\u0012\n\u0007\u0005%\u0013DA\u0004C_>dW-\u00198\t\u0013\u00055\u0012qHA\u0001\u0002\u0004\t\u0006\"CA(\u0001\u0005\u0005I\u0011IA)\u0003\u0019)\u0017/^1mgR!\u0011QIA*\u0011%\ti#!\u0014\u0002\u0002\u0003\u0007\u0011\u000bK\b\u0001\u0003/\ni&a\u0018\u0002d\u0005\u0015\u0014\u0011NA6!\r\t\u0012\u0011L\u0005\u0004\u00037\u0012!!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003C\n\u0011\u0011\u001b\u0006!A\u0001\u0002sLR+O\u0007~CC/[7fgR\fW\u000e].-A\u0019lG/X\u0015![\u0001\u0002\u0016M]:fg\u0002\"\b.\u001a\u0011ai&lWm\u001d;b[B\u0004\u0007%\u001a=qe\u0016\u001c8/[8oA]LG\u000f\u001b\u0011uQ\u0016\u0004\u0003MZ7uA\u0002*\u0007\u0010\u001d:fgNLwN\u001c\u0011u_*\u0001\u0003\u0005\t\u0011!A\u0005\u0004C/[7fgR\fW\u000e\u001d\u0018!%\u0016$XO\u001d8tA9,H\u000e\u001c\u0011xSRD\u0007%\u001b8wC2LG\rI5oaV$h\u0006\t\"zA\u0011,g-Y;mi2\u0002\u0013\u000e\u001e\u0011g_2dwn^:!G\u0006\u001cH/\u001b8hAI,H.Z:!i>T\u0001\u0005\t\u0011!A\u0001\n\u0007\u0005^5nKN$\u0018-\u001c9!S\u001a\u0004C\u000f[3!A\u001alG\u000f\u0019\u0011jg\u0002zW.\u001b;uK\u0012t#\u0002\t\u0011\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!a\u001a\u0002\u0003#R\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006f\n\u001a1cYj\u0013GM\u00174c\u0001\u0002\u0004GO\u00193uA\u0002t%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!eA\nd'L\u00193[M\n\u0004\u0005\r\u0019;cIR\u0004\u0007\r\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)OI\u0002\u0014GN\u00172e5\u001a\u0014g\n\u0017!OeL\u00180_\u0017N\u001b6\"GmJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AI\u0002\u0014GN\u00172e5\u001a\u0014\u0007\t\u00191uA\u0002$\b\r\u0019\u000bA\u0001\nQa]5oG\u0016\f#!!\u001c\u0002\u000bIr#G\f\u0019\b\u0013\u0005E$!!A\t\u0002\u0005M\u0014\u0001\u0005)beN,Gk\u001c+j[\u0016\u001cH/Y7q!\r\t\u0012Q\u000f\u0004\t\u0003\t\t\t\u0011#\u0001\u0002xM)\u0011QOA=;AA\u00111PAAG-\u001as'\u0004\u0002\u0002~)\u0019\u0011qP\r\u0002\u000fI,h\u000e^5nK&!\u00111QA?\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gn\r\u0005\bk\u0005UD\u0011AAD)\t\t\u0019\b\u0003\u0006\u0002\f\u0006U\u0014\u0011!C#\u0003\u001b\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003\u0017A!\"!%\u0002v\u0005\u0005I\u0011QAJ\u0003\u0015\t\u0007\u000f\u001d7z)\u001d9\u0014QSAL\u00033Ca!IAH\u0001\u0004\u0019\u0003BB\u0015\u0002\u0010\u0002\u00071\u0006\u0003\u00042\u0003\u001f\u0003\ra\t\u0005\u000b\u0003;\u000b)(!A\u0005\u0002\u0006}\u0015aB;oCB\u0004H.\u001f\u000b\u0005\u0003C\u000bI\u000b\u0005\u0003\u0019Y\u0005\r\u0006C\u0002\r\u0002&\u000eZ3%C\u0002\u0002(f\u0011a\u0001V;qY\u0016\u001c\u0004\"CAV\u00037\u000b\t\u00111\u00018\u0003\rAH\u0005\r\u0005\u000b\u0003_\u000b)(!A\u0005\n\u0005E\u0016a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!a-\u0011\t\u00055\u0011QW\u0005\u0005\u0003o\u000byA\u0001\u0004PE*,7\r\u001e")
public class ParseToTimestamp
extends UnaryExpression
implements RuntimeReplaceable,
Serializable {
    private final Expression left;
    private final Option<Expression> format;
    private final Expression child;
    private Expression canonicalized;
    private volatile boolean bitmap$0;

    public static Option<Tuple3<Expression, Option<Expression>, Expression>> unapply(ParseToTimestamp parseToTimestamp) {
        return ParseToTimestamp$.MODULE$.unapply(parseToTimestamp);
    }

    public static Function1<Tuple3<Expression, Option<Expression>, Expression>, ParseToTimestamp> tupled() {
        return ParseToTimestamp$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Option<Expression>, Function1<Expression, ParseToTimestamp>>> curried() {
        return ParseToTimestamp$.MODULE$.curried();
    }

    @Override
    public boolean nullable() {
        return RuntimeReplaceable.nullable$(this);
    }

    @Override
    public boolean foldable() {
        return RuntimeReplaceable.foldable$(this);
    }

    @Override
    public final Object eval(InternalRow input) {
        return Unevaluable.eval$(this, input);
    }

    @Override
    public final ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return Unevaluable.doGenCode$(this, ctx, ev);
    }

    @Override
    public final InternalRow eval$default$1() {
        return Unevaluable.eval$default$1$(this);
    }

    private Expression canonicalized$lzycompute() {
        ParseToTimestamp parseToTimestamp = this;
        synchronized (parseToTimestamp) {
            if (!this.bitmap$0) {
                this.canonicalized = RuntimeReplaceable.canonicalized$(this);
                this.bitmap$0 = true;
            }
        }
        return this.canonicalized;
    }

    @Override
    public Expression canonicalized() {
        return !this.bitmap$0 ? this.canonicalized$lzycompute() : this.canonicalized;
    }

    public Expression left() {
        return this.left;
    }

    public Option<Expression> format() {
        return this.format;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Iterator<Object> flatArguments() {
        return package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray(new Object[]{this.left(), this.format()}));
    }

    @Override
    public String sql() {
        return this.format().isDefined() ? new StringBuilder(4).append(this.prettyName()).append("(").append(this.left().sql()).append(", ").append(((Expression)this.format().get()).sql()).append(")").toString() : new StringBuilder(2).append(this.prettyName()).append("(").append(this.left().sql()).append(")").toString();
    }

    @Override
    public String prettyName() {
        return "to_timestamp";
    }

    @Override
    public DataType dataType() {
        return TimestampType$.MODULE$;
    }

    public ParseToTimestamp copy(Expression left, Option<Expression> format, Expression child) {
        return new ParseToTimestamp(left, format, child);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Option<Expression> copy$default$2() {
        return this.format();
    }

    public Expression copy$default$3() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "ParseToTimestamp";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.left();
                break;
            }
            case 1: {
                object = this.format();
                break;
            }
            case 2: {
                object = this.child();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ParseToTimestamp;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ParseToTimestamp)) return false;
        boolean bl = true;
        if (!bl) return false;
        ParseToTimestamp parseToTimestamp = (ParseToTimestamp)x$1;
        Expression expression = this.left();
        Expression expression2 = parseToTimestamp.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<Expression> option = this.format();
        Option<Expression> option2 = parseToTimestamp.format();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Expression expression3 = this.child();
        Expression expression4 = parseToTimestamp.child();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!parseToTimestamp.canEqual(this)) return false;
        return true;
    }

    public ParseToTimestamp(Expression left, Option<Expression> format, Expression child) {
        this.left = left;
        this.format = format;
        this.child = child;
        Unevaluable.$init$(this);
        RuntimeReplaceable.$init$(this);
    }

    public ParseToTimestamp(Expression left, Expression format) {
        this(left, (Option<Expression>)Option$.MODULE$.apply((Object)format), new Cast(new UnixTimestamp(left, format, UnixTimestamp$.MODULE$.apply$default$3()), TimestampType$.MODULE$, Cast$.MODULE$.apply$default$3()));
    }

    public ParseToTimestamp(Expression left) {
        this(left, (Option<Expression>)None$.MODULE$, new Cast(left, TimestampType$.MODULE$, Cast$.MODULE$.apply$default$3()));
    }
}

