/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.StringLPad$;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function3;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(str, len, pad) - Returns `str`, left-padded with `pad` to a length of `len`.\n      If `str` is longer than `len`, the return value is shortened to `len` characters.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('hi', 5, '??');\n       ???hi\n      > SELECT _FUNC_('hi', 1, '??');\n       h\n  ")
@ScalaSignature(bytes="\u0006\u0001\u0005Eg\u0001B\u0001\u0003\u0001>\u0011!b\u0015;sS:<G\nU1e\u0015\t\u0019A!A\u0006fqB\u0014Xm]:j_:\u001c(BA\u0003\u0007\u0003!\u0019\u0017\r^1msN$(BA\u0004\t\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u0013)\tQa\u001d9be.T!a\u0003\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0011aA8sO\u000e\u00011#\u0002\u0001\u0011)]i\u0002CA\t\u0013\u001b\u0005\u0011\u0011BA\n\u0003\u0005E!VM\u001d8bef,\u0005\u0010\u001d:fgNLwN\u001c\t\u0003#UI!A\u0006\u0002\u0003-%k\u0007\u000f\\5dSR\u001c\u0015m\u001d;J]B,H\u000fV=qKN\u0004\"\u0001G\u000e\u000e\u0003eQ\u0011AG\u0001\u0006g\u000e\fG.Y\u0005\u00039e\u0011q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002\u0019=%\u0011q$\u0007\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\tC\u0001\u0011)\u001a!C\u0001E\u0005\u00191\u000f\u001e:\u0016\u0003\r\u0002\"!\u0005\u0013\n\u0005\u0015\u0012!AC#yaJ,7o]5p]\"Aq\u0005\u0001B\tB\u0003%1%\u0001\u0003tiJ\u0004\u0003\u0002C\u0015\u0001\u0005+\u0007I\u0011\u0001\u0012\u0002\u00071,g\u000e\u0003\u0005,\u0001\tE\t\u0015!\u0003$\u0003\u0011aWM\u001c\u0011\t\u00115\u0002!Q3A\u0005\u0002\t\n1\u0001]1e\u0011!y\u0003A!E!\u0002\u0013\u0019\u0013\u0001\u00029bI\u0002BQ!\r\u0001\u0005\u0002I\na\u0001P5oSRtD\u0003B\u001a5kY\u0002\"!\u0005\u0001\t\u000b\u0005\u0002\u0004\u0019A\u0012\t\u000b%\u0002\u0004\u0019A\u0012\t\u000b5\u0002\u0004\u0019A\u0012\t\u000ba\u0002A\u0011I\u001d\u0002\u0011\rD\u0017\u000e\u001c3sK:,\u0012A\u000f\t\u0004w\r\u001bcB\u0001\u001fB\u001d\ti\u0004)D\u0001?\u0015\tyd\"\u0001\u0004=e>|GOP\u0005\u00025%\u0011!)G\u0001\ba\u0006\u001c7.Y4f\u0013\t!UIA\u0002TKFT!AQ\r\t\u000b\u001d\u0003A\u0011\t%\u0002\u0011\u0011\fG/\u0019+za\u0016,\u0012!\u0013\t\u0003\u00156k\u0011a\u0013\u0006\u0003\u0019\u001a\tQ\u0001^=qKNL!AT&\u0003\u0011\u0011\u000bG/\u0019+za\u0016DQ\u0001\u0015\u0001\u0005BE\u000b!\"\u001b8qkR$\u0016\u0010]3t+\u0005\u0011\u0006cA\u001eD\u0013\")A\u000b\u0001C!+\u0006aa.\u001e7m'\u00064W-\u0012<bYR!a+\u0017.\\!\tAr+\u0003\u0002Y3\t\u0019\u0011I\\=\t\u000b\u0005\u001a\u0006\u0019\u0001,\t\u000b%\u001a\u0006\u0019\u0001,\t\u000b5\u001a\u0006\u0019\u0001,\t\u000bu\u0003A\u0011\u000b0\u0002\u0013\u0011|w)\u001a8D_\u0012,GcA0fUB\u0011\u0001mY\u0007\u0002C*\u0011!MA\u0001\bG>$WmZ3o\u0013\t!\u0017M\u0001\u0005FqB\u00148i\u001c3f\u0011\u00151G\f1\u0001h\u0003\r\u0019G\u000f\u001f\t\u0003A\"L!![1\u0003\u001d\r{G-Z4f]\u000e{g\u000e^3yi\")1\u000e\u0018a\u0001?\u0006\u0011QM\u001e\u0005\u0006[\u0002!\tE\\\u0001\u000baJ,G\u000f^=OC6,W#A8\u0011\u0005A$hBA9s!\ti\u0014$\u0003\u0002t3\u00051\u0001K]3eK\u001aL!!\u001e<\u0003\rM#(/\u001b8h\u0015\t\u0019\u0018\u0004C\u0004y\u0001\u0005\u0005I\u0011A=\u0002\t\r|\u0007/\u001f\u000b\u0005gi\\H\u0010C\u0004\"oB\u0005\t\u0019A\u0012\t\u000f%:\b\u0013!a\u0001G!9Qf\u001eI\u0001\u0002\u0004\u0019\u0003b\u0002@\u0001#\u0003%\ta`\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\t\tAK\u0002$\u0003\u0007Y#!!\u0002\u0011\t\u0005\u001d\u0011\u0011C\u0007\u0003\u0003\u0013QA!a\u0003\u0002\u000e\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u001fI\u0012AC1o]>$\u0018\r^5p]&!\u00111CA\u0005\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\t\u0003/\u0001\u0011\u0013!C\u0001\u007f\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0004\u0002CA\u000e\u0001E\u0005I\u0011A@\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%g!I\u0011q\u0004\u0001\u0002\u0002\u0013\u0005\u0013\u0011E\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005\r\u0002\u0003BA\u0013\u0003_i!!a\n\u000b\t\u0005%\u00121F\u0001\u0005Y\u0006twM\u0003\u0002\u0002.\u0005!!.\u0019<b\u0013\r)\u0018q\u0005\u0005\n\u0003g\u0001\u0011\u0011!C\u0001\u0003k\tA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!a\u000e\u0011\u0007a\tI$C\u0002\u0002<e\u00111!\u00138u\u0011%\ty\u0004AA\u0001\n\u0003\t\t%\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\u0007Y\u000b\u0019\u0005\u0003\u0006\u0002F\u0005u\u0012\u0011!a\u0001\u0003o\t1\u0001\u001f\u00132\u0011%\tI\u0005AA\u0001\n\u0003\nY%A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\ti\u0005E\u0003\u0002P\u0005Uc+\u0004\u0002\u0002R)\u0019\u00111K\r\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002X\u0005E#\u0001C%uKJ\fGo\u001c:\t\u0013\u0005m\u0003!!A\u0005\u0002\u0005u\u0013\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005}\u0013Q\r\t\u00041\u0005\u0005\u0014bAA23\t9!i\\8mK\u0006t\u0007\"CA#\u00033\n\t\u00111\u0001W\u0011%\tI\u0007AA\u0001\n\u0003\nY'\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003?\ni\u0007C\u0005\u0002F\u0005\u001d\u0014\u0011!a\u0001-\"Z\u0001!!\u001d\u0002x\u0005e\u0014QPA@!\r\t\u00121O\u0005\u0004\u0003k\u0012!!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003w\n\u0011q\r\u0006!A\u0001\u0002sLR+O\u0007~C3\u000f\u001e:-A1,g\u000e\f\u0011qC\u0012L\u0003%\f\u0011SKR,(O\\:!AN$(\u000f\u0019\u0017!Y\u00164G/\f9bI\u0012,G\rI<ji\"\u0004\u0003\r]1eA\u0002\"x\u000eI1!Y\u0016tw\r\u001e5!_\u001a\u0004\u0003\r\\3oA:R\u0001\u0005\t\u0011!A\u0001Je\r\t1tiJ\u0004\u0007%[:!Y>tw-\u001a:!i\"\fg\u000e\t1mK:\u0004G\u0006\t;iK\u0002\u0012X\r^;s]\u00022\u0018\r\\;fA%\u001c\be\u001d5peR,g.\u001a3!i>\u0004\u0003\r\\3oA\u0002\u001a\u0007.\u0019:bGR,'o\u001d\u0018\u000bA\u0001\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0003\u0003\u000b1O\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015(Q&<C\u0006I\u001b-A\u001dzthJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!A}zt\b[5\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001dB\u0017n\n\u0017!c1\u0002seP (SmR\u0001\u0005\t\u0011!A\u0001\u0002\u0003N\u0003\u0011!\u000f%\t)IAA\u0001\u0012\u0003\t9)\u0001\u0006TiJLgn\u001a'QC\u0012\u00042!EAE\r!\t!!!A\t\u0002\u0005-5#BAE\u0003\u001bk\u0002\u0003CAH\u0003+\u001b3eI\u001a\u000e\u0005\u0005E%bAAJ3\u00059!/\u001e8uS6,\u0017\u0002BAL\u0003#\u0013\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c84\u0011\u001d\t\u0014\u0011\u0012C\u0001\u00037#\"!a\"\t\u0015\u0005}\u0015\u0011RA\u0001\n\u000b\n\t+\u0001\u0005u_N#(/\u001b8h)\t\t\u0019\u0003\u0003\u0006\u0002&\u0006%\u0015\u0011!CA\u0003O\u000bQ!\u00199qYf$raMAU\u0003W\u000bi\u000b\u0003\u0004\"\u0003G\u0003\ra\t\u0005\u0007S\u0005\r\u0006\u0019A\u0012\t\r5\n\u0019\u000b1\u0001$\u0011)\t\t,!#\u0002\u0002\u0013\u0005\u00151W\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\t),!1\u0011\u000ba\t9,a/\n\u0007\u0005e\u0016D\u0001\u0004PaRLwN\u001c\t\u00071\u0005u6eI\u0012\n\u0007\u0005}\u0016D\u0001\u0004UkBdWm\r\u0005\n\u0003\u0007\fy+!AA\u0002M\n1\u0001\u001f\u00131\u0011)\t9-!#\u0002\u0002\u0013%\u0011\u0011Z\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002LB!\u0011QEAg\u0013\u0011\ty-a\n\u0003\r=\u0013'.Z2u\u0001")
public class StringLPad
extends TernaryExpression
implements ImplicitCastInputTypes,
scala.Serializable {
    private final Expression str;
    private final Expression len;
    private final Expression pad;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(StringLPad stringLPad) {
        return StringLPad$.MODULE$.unapply(stringLPad);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, StringLPad> tupled() {
        return StringLPad$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, StringLPad>>> curried() {
        return StringLPad$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression str() {
        return this.str;
    }

    public Expression len() {
        return this.len;
    }

    public Expression pad() {
        return this.pad;
    }

    @Override
    public Seq<Expression> children() {
        Expression expression = this.str();
        Expression expression2 = this.len();
        Expression expression3 = this.pad();
        return Nil$.MODULE$.$colon$colon((Object)expression3).$colon$colon((Object)expression2).$colon$colon((Object)expression);
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    public Seq<DataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AtomicType[]{StringType$.MODULE$, IntegerType$.MODULE$, StringType$.MODULE$}));
    }

    @Override
    public Object nullSafeEval(Object str, Object len, Object pad) {
        return ((UTF8String)str).lpad(BoxesRunTime.unboxToInt((Object)len), (UTF8String)pad);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.defineCodeGen(ctx, ev, (Function3<String, String, String, String>)(Function3 & Serializable & scala.Serializable)(str, len, pad) -> new StringBuilder(9).append((String)str).append(".lpad(").append((String)len).append(", ").append((String)pad).append(")").toString());
    }

    @Override
    public String prettyName() {
        return "lpad";
    }

    public StringLPad copy(Expression str, Expression len, Expression pad) {
        return new StringLPad(str, len, pad);
    }

    public Expression copy$default$1() {
        return this.str();
    }

    public Expression copy$default$2() {
        return this.len();
    }

    public Expression copy$default$3() {
        return this.pad();
    }

    @Override
    public String productPrefix() {
        return "StringLPad";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.str();
                break;
            }
            case 1: {
                expression = this.len();
                break;
            }
            case 2: {
                expression = this.pad();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StringLPad;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StringLPad)) return false;
        boolean bl = true;
        if (!bl) return false;
        StringLPad stringLPad = (StringLPad)x$1;
        Expression expression = this.str();
        Expression expression2 = stringLPad.str();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.len();
        Expression expression4 = stringLPad.len();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.pad();
        Expression expression6 = stringLPad.pad();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!stringLPad.canEqual(this)) return false;
        return true;
    }

    public StringLPad(Expression str, Expression len, Expression pad) {
        this.str = str;
        this.len = len;
        this.pad = pad;
        ExpectsInputTypes.$init$(this);
    }
}

