/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.StringReplace$;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function3;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(str, search[, replace]) - Replaces all occurrences of `search` with `replace`.", arguments="\n    Arguments:\n      * str - a string expression\n      * search - a string expression. If `search` is not found in `str`, `str` is returned unchanged.\n      * replace - a string expression. If `replace` is not specified or is an empty string, nothing replaces\n          the string that is removed from `str`.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('ABCabc', 'abc', 'DEF');\n       ABCDEF\n  ")
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015h\u0001B\u0001\u0003\u0001>\u0011Qb\u0015;sS:<'+\u001a9mC\u000e,'BA\u0002\u0005\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005\u00151\u0011\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005\u001dA\u0011aA:rY*\u0011\u0011BC\u0001\u0006gB\f'o\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000b\u0001\u0001BcF\u000f\u0011\u0005E\u0011R\"\u0001\u0002\n\u0005M\u0011!!\u0005+fe:\f'/_#yaJ,7o]5p]B\u0011\u0011#F\u0005\u0003-\t\u0011a#S7qY&\u001c\u0017\u000e^\"bgRLe\u000e];u)f\u0004Xm\u001d\t\u00031mi\u0011!\u0007\u0006\u00025\u0005)1oY1mC&\u0011A$\u0007\u0002\b!J|G-^2u!\tAb$\u0003\u0002 3\ta1+\u001a:jC2L'0\u00192mK\"A\u0011\u0005\u0001BK\u0002\u0013\u0005!%A\u0004te\u000e,\u0005\u0010\u001d:\u0016\u0003\r\u0002\"!\u0005\u0013\n\u0005\u0015\u0012!AC#yaJ,7o]5p]\"Aq\u0005\u0001B\tB\u0003%1%\u0001\u0005te\u000e,\u0005\u0010\u001d:!\u0011!I\u0003A!f\u0001\n\u0003\u0011\u0013AC:fCJ\u001c\u0007.\u0012=qe\"A1\u0006\u0001B\tB\u0003%1%A\u0006tK\u0006\u00148\r[#yaJ\u0004\u0003\u0002C\u0017\u0001\u0005+\u0007I\u0011\u0001\u0012\u0002\u0017I,\u0007\u000f\\1dK\u0016C\bO\u001d\u0005\t_\u0001\u0011\t\u0012)A\u0005G\u0005a!/\u001a9mC\u000e,W\t\u001f9sA!)\u0011\u0007\u0001C\u0001e\u00051A(\u001b8jiz\"Ba\r\u001b6mA\u0011\u0011\u0003\u0001\u0005\u0006CA\u0002\ra\t\u0005\u0006SA\u0002\ra\t\u0005\u0006[A\u0002\ra\t\u0005\u0006c\u0001!\t\u0001\u000f\u000b\u0004geR\u0004\"B\u00118\u0001\u0004\u0019\u0003\"B\u00158\u0001\u0004\u0019\u0003\"\u0002\u001f\u0001\t\u0003j\u0014\u0001\u00048vY2\u001c\u0016MZ3Fm\u0006dG\u0003\u0002 B\u0007\u0016\u0003\"\u0001G \n\u0005\u0001K\"aA!os\")!i\u000fa\u0001}\u000591O]2Fm\u0006d\u0007\"\u0002#<\u0001\u0004q\u0014AC:fCJ\u001c\u0007.\u0012<bY\")ai\u000fa\u0001}\u0005Y!/\u001a9mC\u000e,WI^1m\u0011\u0015A\u0005\u0001\"\u0011J\u0003%!wnR3o\u0007>$W\rF\u0002K!V\u0003\"a\u0013(\u000e\u00031S!!\u0014\u0002\u0002\u000f\r|G-Z4f]&\u0011q\n\u0014\u0002\t\u000bb\u0004(oQ8eK\")\u0011k\u0012a\u0001%\u0006\u00191\r\u001e=\u0011\u0005-\u001b\u0016B\u0001+M\u00059\u0019u\u000eZ3hK:\u001cuN\u001c;fqRDQAV$A\u0002)\u000b!!\u001a<\t\u000ba\u0003A\u0011I-\u0002\u0011\u0011\fG/\u0019+za\u0016,\u0012A\u0017\t\u00037zk\u0011\u0001\u0018\u0006\u0003;\u001a\tQ\u0001^=qKNL!a\u0018/\u0003\u0011\u0011\u000bG/\u0019+za\u0016DQ!\u0019\u0001\u0005B\t\f!\"\u001b8qkR$\u0016\u0010]3t+\u0005\u0019\u0007c\u00013m5:\u0011QM\u001b\b\u0003M&l\u0011a\u001a\u0006\u0003Q:\ta\u0001\u0010:p_Rt\u0014\"\u0001\u000e\n\u0005-L\u0012a\u00029bG.\fw-Z\u0005\u0003[:\u00141aU3r\u0015\tY\u0017\u0004C\u0003q\u0001\u0011\u0005\u0013/\u0001\u0005dQ&dGM]3o+\u0005\u0011\bc\u00013mG!)A\u000f\u0001C!k\u0006Q\u0001O]3uift\u0015-\\3\u0016\u0003Y\u0004\"a^>\u000f\u0005aL\bC\u00014\u001a\u0013\tQ\u0018$\u0001\u0004Qe\u0016$WMZ\u0005\u0003yv\u0014aa\u0015;sS:<'B\u0001>\u001a\u0011!y\b!!A\u0005\u0002\u0005\u0005\u0011\u0001B2paf$raMA\u0002\u0003\u000b\t9\u0001C\u0004\"}B\u0005\t\u0019A\u0012\t\u000f%r\b\u0013!a\u0001G!9QF I\u0001\u0002\u0004\u0019\u0003\"CA\u0006\u0001E\u0005I\u0011AA\u0007\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!a\u0004+\u0007\r\n\tb\u000b\u0002\u0002\u0014A!\u0011QCA\u0010\u001b\t\t9B\u0003\u0003\u0002\u001a\u0005m\u0011!C;oG\",7m[3e\u0015\r\ti\"G\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u0011\u0003/\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011%\t)\u0003AI\u0001\n\u0003\ti!\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\t\u0013\u0005%\u0002!%A\u0005\u0002\u00055\u0011AD2paf$C-\u001a4bk2$He\r\u0005\n\u0003[\u0001\u0011\u0011!C!\u0003_\tQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA\u0019!\u0011\t\u0019$!\u0010\u000e\u0005\u0005U\"\u0002BA\u001c\u0003s\tA\u0001\\1oO*\u0011\u00111H\u0001\u0005U\u00064\u0018-C\u0002}\u0003kA\u0011\"!\u0011\u0001\u0003\u0003%\t!a\u0011\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005\u0015\u0003c\u0001\r\u0002H%\u0019\u0011\u0011J\r\u0003\u0007%sG\u000fC\u0005\u0002N\u0001\t\t\u0011\"\u0001\u0002P\u0005q\u0001O]8ek\u000e$X\t\\3nK:$Hc\u0001 \u0002R!Q\u00111KA&\u0003\u0003\u0005\r!!\u0012\u0002\u0007a$\u0013\u0007C\u0005\u0002X\u0001\t\t\u0011\"\u0011\u0002Z\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002\\A)\u0011QLA2}5\u0011\u0011q\f\u0006\u0004\u0003CJ\u0012AC2pY2,7\r^5p]&!\u0011QMA0\u0005!IE/\u001a:bi>\u0014\b\"CA5\u0001\u0005\u0005I\u0011AA6\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA7\u0003g\u00022\u0001GA8\u0013\r\t\t(\u0007\u0002\b\u0005>|G.Z1o\u0011%\t\u0019&a\u001a\u0002\u0002\u0003\u0007a\bC\u0005\u0002x\u0001\t\t\u0011\"\u0011\u0002z\u00051Q-];bYN$B!!\u001c\u0002|!I\u00111KA;\u0003\u0003\u0005\rA\u0010\u0015\u0010\u0001\u0005}\u0014QQAD\u0003\u0017\u000bi)!%\u0002\u0014B\u0019\u0011#!!\n\u0007\u0005\r%AA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\u0005%\u0015!V0G+:\u001bu\fK:ue2\u00023/Z1sG\"\\F\u0006\t:fa2\f7-Z/*A5\u0002#+\u001a9mC\u000e,7\u000fI1mY\u0002z7mY;se\u0016t7-Z:!_\u001a\u0004\u0003m]3be\u000eD\u0007\rI<ji\"\u0004\u0003M]3qY\u0006\u001cW\r\u0019\u0018\u0002\u0013\u0005\u0014x-^7f]R\u001c\u0018EAAH\u0003\tE$\u0002\t\u0011!A\u0005\u0013x-^7f]R\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011tiJ\u0004S\u0006I1!gR\u0014\u0018N\\4!Kb\u0004(/Z:tS>t'\u0002\t\u0011!A\u0001\u0002#\u0006I:fCJ\u001c\u0007\u000eI\u0017!C\u0002\u001aHO]5oO\u0002*\u0007\u0010\u001d:fgNLwN\u001c\u0018!\u0013\u001a\u0004\u0003m]3be\u000eD\u0007\rI5tA9|G\u000f\t4pk:$\u0007%\u001b8!AN$(\u000f\u0019\u0017!AN$(\u000f\u0019\u0011jg\u0002\u0012X\r^;s]\u0016$\u0007%\u001e8dQ\u0006tw-\u001a3/\u0015\u0001\u0002\u0003\u0005\t\u0011!U\u0001\u0012X\r\u001d7bG\u0016\u0004S\u0006I1!gR\u0014\u0018N\\4!Kb\u0004(/Z:tS>tg\u0006I%gA\u0001\u0014X\r\u001d7bG\u0016\u0004\u0007%[:!]>$\be\u001d9fG&4\u0017.\u001a3!_J\u0004\u0013n\u001d\u0011b]\u0002*W\u000e\u001d;zAM$(/\u001b8hY\u0001rw\u000e\u001e5j]\u001e\u0004#/\u001a9mC\u000e,7O\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!AQDW\rI:ue&tw\r\t;iCR\u0004\u0013n\u001d\u0011sK6|g/\u001a3!MJ|W\u000e\t1tiJ\u0004gF\u0003\u0011!\u0003!)\u00070Y7qY\u0016\u001c\u0018EAAK\u00039S\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006fJ!C\u0007\u0006\u00147m\n\u0017!O\u0005\u00147m\n\u0017!O\u0011+eiJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0005\u00135\tR#G\u0015\u0001\u0002s!CAM\u0005\u0005\u0005\t\u0012AAN\u00035\u0019FO]5oOJ+\u0007\u000f\\1dKB\u0019\u0011#!(\u0007\u0011\u0005\u0011\u0011\u0011!E\u0001\u0003?\u001bR!!(\u0002\"v\u0001\u0002\"a)\u0002*\u000e\u001a3eM\u0007\u0003\u0003KS1!a*\u001a\u0003\u001d\u0011XO\u001c;j[\u0016LA!a+\u0002&\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u001a\t\u000fE\ni\n\"\u0001\u00020R\u0011\u00111\u0014\u0005\u000b\u0003g\u000bi*!A\u0005F\u0005U\u0016\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005E\u0002BCA]\u0003;\u000b\t\u0011\"!\u0002<\u0006)\u0011\r\u001d9msR91'!0\u0002@\u0006\u0005\u0007BB\u0011\u00028\u0002\u00071\u0005\u0003\u0004*\u0003o\u0003\ra\t\u0005\u0007[\u0005]\u0006\u0019A\u0012\t\u0015\u0005\u0015\u0017QTA\u0001\n\u0003\u000b9-A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005%\u0017Q\u001b\t\u00061\u0005-\u0017qZ\u0005\u0004\u0003\u001bL\"AB(qi&|g\u000e\u0005\u0004\u0019\u0003#\u001c3eI\u0005\u0004\u0003'L\"A\u0002+va2,7\u0007C\u0005\u0002X\u0006\r\u0017\u0011!a\u0001g\u0005\u0019\u0001\u0010\n\u0019\t\u0015\u0005m\u0017QTA\u0001\n\u0013\ti.A\u0006sK\u0006$'+Z:pYZ,GCAAp!\u0011\t\u0019$!9\n\t\u0005\r\u0018Q\u0007\u0002\u0007\u001f\nTWm\u0019;")
public class StringReplace
extends TernaryExpression
implements ImplicitCastInputTypes,
scala.Serializable {
    private final Expression srcExpr;
    private final Expression searchExpr;
    private final Expression replaceExpr;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(StringReplace stringReplace) {
        return StringReplace$.MODULE$.unapply(stringReplace);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, StringReplace> tupled() {
        return StringReplace$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, StringReplace>>> curried() {
        return StringReplace$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression srcExpr() {
        return this.srcExpr;
    }

    public Expression searchExpr() {
        return this.searchExpr;
    }

    public Expression replaceExpr() {
        return this.replaceExpr;
    }

    @Override
    public Object nullSafeEval(Object srcEval, Object searchEval, Object replaceEval) {
        return ((UTF8String)srcEval).replace((UTF8String)searchEval, (UTF8String)replaceEval);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function3<String, String, String, String>)(Function3 & Serializable & scala.Serializable)(src, search, replace) -> new StringBuilder(16).append(ev.value()).append(" = ").append((String)src).append(".replace(").append((String)search).append(", ").append((String)replace).append(");").toString());
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    public Seq<DataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StringType$[]{StringType$.MODULE$, StringType$.MODULE$, StringType$.MODULE$}));
    }

    @Override
    public Seq<Expression> children() {
        Expression expression = this.srcExpr();
        Expression expression2 = this.searchExpr();
        Expression expression3 = this.replaceExpr();
        return Nil$.MODULE$.$colon$colon((Object)expression3).$colon$colon((Object)expression2).$colon$colon((Object)expression);
    }

    @Override
    public String prettyName() {
        return "replace";
    }

    public StringReplace copy(Expression srcExpr, Expression searchExpr, Expression replaceExpr) {
        return new StringReplace(srcExpr, searchExpr, replaceExpr);
    }

    public Expression copy$default$1() {
        return this.srcExpr();
    }

    public Expression copy$default$2() {
        return this.searchExpr();
    }

    public Expression copy$default$3() {
        return this.replaceExpr();
    }

    @Override
    public String productPrefix() {
        return "StringReplace";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.srcExpr();
                break;
            }
            case 1: {
                expression = this.searchExpr();
                break;
            }
            case 2: {
                expression = this.replaceExpr();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StringReplace;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StringReplace)) return false;
        boolean bl = true;
        if (!bl) return false;
        StringReplace stringReplace = (StringReplace)x$1;
        Expression expression = this.srcExpr();
        Expression expression2 = stringReplace.srcExpr();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.searchExpr();
        Expression expression4 = stringReplace.searchExpr();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.replaceExpr();
        Expression expression6 = stringReplace.replaceExpr();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!stringReplace.canEqual(this)) return false;
        return true;
    }

    public StringReplace(Expression srcExpr, Expression searchExpr, Expression replaceExpr) {
        this.srcExpr = srcExpr;
        this.searchExpr = searchExpr;
        this.replaceExpr = replaceExpr;
        ExpectsInputTypes.$init$(this);
    }

    public StringReplace(Expression srcExpr, Expression searchExpr) {
        this(srcExpr, searchExpr, Literal$.MODULE$.apply(""));
    }
}

