/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.StringSplit$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(str, regex) - Splits `str` around occurrences that match `regex`.", examples="\n    Examples:\n      > SELECT _FUNC_('oneAtwoBthreeC', '[ABC]');\n       [\"one\",\"two\",\"three\",\"\"]\n  ")
@ScalaSignature(bytes="\u0006\u0001\u0005\u0005g\u0001B\u0001\u0003\u0001>\u00111b\u0015;sS:<7\u000b\u001d7ji*\u00111\u0001B\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002\u0006\r\u0005A1-\u0019;bYf\u001cHO\u0003\u0002\b\u0011\u0005\u00191/\u001d7\u000b\u0005%Q\u0011!B:qCJ\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c\u0001aE\u0003\u0001!Q9R\u0004\u0005\u0002\u0012%5\t!!\u0003\u0002\u0014\u0005\t\u0001\")\u001b8bef,\u0005\u0010\u001d:fgNLwN\u001c\t\u0003#UI!A\u0006\u0002\u0003-%k\u0007\u000f\\5dSR\u001c\u0015m\u001d;J]B,H\u000fV=qKN\u0004\"\u0001G\u000e\u000e\u0003eQ\u0011AG\u0001\u0006g\u000e\fG.Y\u0005\u00039e\u0011q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002\u0019=%\u0011q$\u0007\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\tC\u0001\u0011)\u001a!C\u0001E\u0005\u00191\u000f\u001e:\u0016\u0003\r\u0002\"!\u0005\u0013\n\u0005\u0015\u0012!AC#yaJ,7o]5p]\"Aq\u0005\u0001B\tB\u0003%1%\u0001\u0003tiJ\u0004\u0003\u0002C\u0015\u0001\u0005+\u0007I\u0011\u0001\u0012\u0002\u000fA\fG\u000f^3s]\"A1\u0006\u0001B\tB\u0003%1%\u0001\u0005qCR$XM\u001d8!\u0011\u0015i\u0003\u0001\"\u0001/\u0003\u0019a\u0014N\\5u}Q\u0019q\u0006M\u0019\u0011\u0005E\u0001\u0001\"B\u0011-\u0001\u0004\u0019\u0003\"B\u0015-\u0001\u0004\u0019\u0003\"B\u001a\u0001\t\u0003\u0012\u0013\u0001\u00027fMRDQ!\u000e\u0001\u0005B\t\nQA]5hQRDQa\u000e\u0001\u0005Ba\n\u0001\u0002Z1uCRK\b/Z\u000b\u0002sA\u0011!(P\u0007\u0002w)\u0011AHB\u0001\u0006if\u0004Xm]\u0005\u0003}m\u0012\u0001\u0002R1uCRK\b/\u001a\u0005\u0006\u0001\u0002!\t%Q\u0001\u000bS:\u0004X\u000f\u001e+za\u0016\u001cX#\u0001\"\u0011\u0007\r[\u0015H\u0004\u0002E\u0013:\u0011Q\tS\u0007\u0002\r*\u0011qID\u0001\u0007yI|w\u000e\u001e \n\u0003iI!AS\r\u0002\u000fA\f7m[1hK&\u0011A*\u0014\u0002\u0004'\u0016\f(B\u0001&\u001a\u0011\u0015y\u0005\u0001\"\u0011Q\u00031qW\u000f\u001c7TC\u001a,WI^1m)\r\tFK\u0016\t\u00031IK!aU\r\u0003\u0007\u0005s\u0017\u0010C\u0003V\u001d\u0002\u0007\u0011+\u0001\u0004tiJLgn\u001a\u0005\u0006/:\u0003\r!U\u0001\u0006e\u0016<W\r\u001f\u0005\u00063\u0002!\tEW\u0001\nI><UM\\\"pI\u0016$2aW1g!\tav,D\u0001^\u0015\tq&!A\u0004d_\u0012,w-\u001a8\n\u0005\u0001l&\u0001C#yaJ\u001cu\u000eZ3\t\u000b\tD\u0006\u0019A2\u0002\u0007\r$\b\u0010\u0005\u0002]I&\u0011Q-\u0018\u0002\u000f\u0007>$WmZ3o\u0007>tG/\u001a=u\u0011\u00159\u0007\f1\u0001\\\u0003\t)g\u000fC\u0003j\u0001\u0011\u0005#.\u0001\u0006qe\u0016$H/\u001f(b[\u0016,\u0012a\u001b\t\u0003YBt!!\u001c8\u0011\u0005\u0015K\u0012BA8\u001a\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011O\u001d\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005=L\u0002b\u0002;\u0001\u0003\u0003%\t!^\u0001\u0005G>\u0004\u0018\u0010F\u00020m^Dq!I:\u0011\u0002\u0003\u00071\u0005C\u0004*gB\u0005\t\u0019A\u0012\t\u000fe\u0004\u0011\u0013!C\u0001u\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nT#A>+\u0005\rb8&A?\u0011\u0007y\f9!D\u0001\u0000\u0015\u0011\t\t!a\u0001\u0002\u0013Ut7\r[3dW\u0016$'bAA\u00033\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0007\u0005%qPA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D\u0001\"!\u0004\u0001#\u0003%\tA_\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u0011%\t\t\u0002AA\u0001\n\u0003\n\u0019\"A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003+\u0001B!a\u0006\u0002\"5\u0011\u0011\u0011\u0004\u0006\u0005\u00037\ti\"\u0001\u0003mC:<'BAA\u0010\u0003\u0011Q\u0017M^1\n\u0007E\fI\u0002C\u0005\u0002&\u0001\t\t\u0011\"\u0001\u0002(\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011\u0011\u0006\t\u00041\u0005-\u0012bAA\u00173\t\u0019\u0011J\u001c;\t\u0013\u0005E\u0002!!A\u0005\u0002\u0005M\u0012A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0004#\u0006U\u0002BCA\u001c\u0003_\t\t\u00111\u0001\u0002*\u0005\u0019\u0001\u0010J\u0019\t\u0013\u0005m\u0002!!A\u0005B\u0005u\u0012a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005}\u0002#BA!\u0003\u000f\nVBAA\"\u0015\r\t)%G\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA%\u0003\u0007\u0012\u0001\"\u0013;fe\u0006$xN\u001d\u0005\n\u0003\u001b\u0002\u0011\u0011!C\u0001\u0003\u001f\n\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003#\n9\u0006E\u0002\u0019\u0003'J1!!\u0016\u001a\u0005\u001d\u0011un\u001c7fC:D\u0011\"a\u000e\u0002L\u0005\u0005\t\u0019A)\t\u0013\u0005m\u0003!!A\u0005B\u0005u\u0013AB3rk\u0006d7\u000f\u0006\u0003\u0002R\u0005}\u0003\"CA\u001c\u00033\n\t\u00111\u0001RQ-\u0001\u00111MA5\u0003W\ny'!\u001d\u0011\u0007E\t)'C\u0002\u0002h\t\u0011Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002n\u0005AuLR+O\u0007~C3\u000f\u001e:-AI,w-\u001a=*A5\u00023\u000b\u001d7jiN\u0004\u0003m\u001d;sA\u0002\n'o\\;oI\u0002z7mY;se\u0016t7-Z:!i\"\fG\u000fI7bi\u000eD\u0007\u0005\u0019:fO\u0016D\bML\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u00111O\u0001d\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":sN\\3Bi^|'\t\u001e5sK\u0016\u001cu\u0005\f\u0011(7\u0006\u00135)X\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001Z&e\u001c8fE1\u0012Co^8#Y\t\"\bN]3fE1\u0012#%\u0018\u0006!A\u001dI\u0011q\u000f\u0002\u0002\u0002#\u0005\u0011\u0011P\u0001\f'R\u0014\u0018N\\4Ta2LG\u000fE\u0002\u0012\u0003w2\u0001\"\u0001\u0002\u0002\u0002#\u0005\u0011QP\n\u0006\u0003w\ny(\b\t\b\u0003\u0003\u000b9iI\u00120\u001b\t\t\u0019IC\u0002\u0002\u0006f\tqA];oi&lW-\u0003\u0003\u0002\n\u0006\r%!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oe!9Q&a\u001f\u0005\u0002\u00055ECAA=\u0011)\t\t*a\u001f\u0002\u0002\u0013\u0015\u00131S\u0001\ti>\u001cFO]5oOR\u0011\u0011Q\u0003\u0005\u000b\u0003/\u000bY(!A\u0005\u0002\u0006e\u0015!B1qa2LH#B\u0018\u0002\u001c\u0006u\u0005BB\u0011\u0002\u0016\u0002\u00071\u0005\u0003\u0004*\u0003+\u0003\ra\t\u0005\u000b\u0003C\u000bY(!A\u0005\u0002\u0006\r\u0016aB;oCB\u0004H.\u001f\u000b\u0005\u0003K\u000b\t\fE\u0003\u0019\u0003O\u000bY+C\u0002\u0002*f\u0011aa\u00149uS>t\u0007#\u0002\r\u0002.\u000e\u001a\u0013bAAX3\t1A+\u001e9mKJB\u0011\"a-\u0002 \u0006\u0005\t\u0019A\u0018\u0002\u0007a$\u0003\u0007\u0003\u0006\u00028\u0006m\u0014\u0011!C\u0005\u0003s\u000b1B]3bIJ+7o\u001c7wKR\u0011\u00111\u0018\t\u0005\u0003/\ti,\u0003\u0003\u0002@\u0006e!AB(cU\u0016\u001cG\u000f")
public class StringSplit
extends BinaryExpression
implements ImplicitCastInputTypes,
scala.Serializable {
    private final Expression str;
    private final Expression pattern;

    public static Option<Tuple2<Expression, Expression>> unapply(StringSplit stringSplit) {
        return StringSplit$.MODULE$.unapply(stringSplit);
    }

    public static Function1<Tuple2<Expression, Expression>, StringSplit> tupled() {
        return StringSplit$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, StringSplit>> curried() {
        return StringSplit$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression str() {
        return this.str;
    }

    public Expression pattern() {
        return this.pattern;
    }

    @Override
    public Expression left() {
        return this.str();
    }

    @Override
    public Expression right() {
        return this.pattern();
    }

    @Override
    public DataType dataType() {
        return ArrayType$.MODULE$.apply(StringType$.MODULE$);
    }

    public Seq<DataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StringType$[]{StringType$.MODULE$, StringType$.MODULE$}));
    }

    @Override
    public Object nullSafeEval(Object string, Object regex) {
        UTF8String[] strings = ((UTF8String)string).split((UTF8String)regex, -1);
        return new GenericArrayData(strings);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String arrayClass = GenericArrayData.class.getName();
        return this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(str, pattern) -> new StringBuilder(22).append(ev.value()).append(" = new ").append(arrayClass).append("(").append((String)str).append(".split(").append((String)pattern).append(", -1));").toString());
    }

    @Override
    public String prettyName() {
        return "split";
    }

    public StringSplit copy(Expression str, Expression pattern) {
        return new StringSplit(str, pattern);
    }

    public Expression copy$default$1() {
        return this.str();
    }

    public Expression copy$default$2() {
        return this.pattern();
    }

    @Override
    public String productPrefix() {
        return "StringSplit";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.str();
                break;
            }
            case 1: {
                expression = this.pattern();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StringSplit;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StringSplit)) return false;
        boolean bl = true;
        if (!bl) return false;
        StringSplit stringSplit = (StringSplit)x$1;
        Expression expression = this.str();
        Expression expression2 = stringSplit.str();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.pattern();
        Expression expression4 = stringSplit.pattern();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!stringSplit.canEqual(this)) return false;
        return true;
    }

    public StringSplit(Expression str, Expression pattern) {
        this.str = str;
        this.pattern = pattern;
        ExpectsInputTypes.$init$(this);
    }
}

